/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class ByteStringEncoding {
    private static final String[] BYTE_STRINGS = new String[256];
    private static final HashMap<String, Integer> contextDictionary;
    private static final HashSet<String> contextDictionaryToCreate;
    private static final ArrayList<String> allStrings;
    private static final StringBuilder sb;

    private ByteStringEncoding() {
    }

    public static String compress(byte[] uncompressed) {
        int i;
        int value;
        if (uncompressed == null) {
            return null;
        }
        if (uncompressed.length == 0) {
            return "";
        }
        int bitsPerChar = 15;
        int offset = 32;
        String context_w = "";
        int context_enlargeIn = 2;
        int context_dictSize = 3;
        int context_numBits = 2;
        int context_data_val = 0;
        int context_data_position = 0;
        contextDictionary.clear();
        contextDictionaryToCreate.clear();
        sb.setLength(0);
        for (int ii = 0; ii < uncompressed.length; ++ii) {
            String context_wc;
            String context_c = BYTE_STRINGS[uncompressed[ii] & 0xFF];
            if (!contextDictionary.containsKey(context_c)) {
                contextDictionary.put(context_c, context_dictSize++);
                contextDictionaryToCreate.add(context_c);
            }
            if (contextDictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (contextDictionaryToCreate.contains(context_w)) {
                value = context_w.charAt(0) & 0xFF;
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val <<= 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                        continue;
                    }
                    ++context_data_position;
                }
                for (i = 0; i < 8; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
                if (--context_enlargeIn == 0) {
                    context_enlargeIn = 1 << context_numBits++;
                }
                contextDictionaryToCreate.remove(context_w);
            } else {
                value = contextDictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
            if (--context_enlargeIn == 0) {
                context_enlargeIn = 1 << context_numBits++;
            }
            contextDictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (contextDictionaryToCreate.contains(context_w)) {
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val <<= 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                        continue;
                    }
                    ++context_data_position;
                }
                value = context_w.charAt(0);
                for (i = 0; i < 8; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
                contextDictionaryToCreate.remove(context_w);
            } else {
                value = contextDictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == 14) {
                        context_data_position = 0;
                        sb.append((char)(context_data_val + 32));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == 14) {
                context_data_position = 0;
                sb.append((char)(context_data_val + 32));
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>= 1;
        }
        while (true) {
            context_data_val <<= 1;
            if (context_data_position == 14) break;
            ++context_data_position;
        }
        sb.append((char)(context_data_val + 32));
        sb.append(' ');
        return sb.toString();
    }

    public static byte[] decompress(String compressed) {
        String c;
        int resb;
        if (compressed == null) {
            return null;
        }
        if (compressed.isEmpty()) {
            return new byte[0];
        }
        int length = compressed.length();
        int resetValue = 16384;
        int offset = -32;
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = 16384;
        int index = 1;
        sb.setLength(0);
        char val = (char)(compressed.charAt(0) + -32);
        allStrings.clear();
        for (int i = 0; i < 3; ++i) {
            allStrings.add(i, BYTE_STRINGS[i]);
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>= 1) == 0) {
                position = 16384;
                val = (char)(compressed.charAt(index++) + -32);
            }
            bits = (char)(bits | (resb > 0 ? 1 : 0) << power++);
        }
        switch (bits) {
            case '\u0000': {
                bits = '\u0000';
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = 16384;
                        val = (char)(compressed.charAt(index++) + -32);
                    }
                    bits = (char)(bits | (resb > 0 ? 1 : 0) << power++);
                }
                c = BYTE_STRINGS[bits];
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = 16384;
                        val = (char)(compressed.charAt(index++) + -32);
                    }
                    bits = (char)(bits | (resb > 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return new byte[0];
            }
        }
        allStrings.add(c);
        String w = c;
        sb.append(w);
        while (index <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>= 1) == 0) {
                    position = 16384;
                    val = (char)(compressed.charAt(index++) + -32);
                }
                cc |= (resb > 0 ? 1 : 0) << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = 16384;
                            val = (char)(compressed.charAt(index++) + -32);
                        }
                        bits = (char)(bits | (resb > 0 ? 1 : 0) << power++);
                    }
                    allStrings.add(BYTE_STRINGS[bits]);
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = 16384;
                            val = (char)(compressed.charAt(index++) + -32);
                        }
                        bits = (char)(bits | (resb > 0 ? 1 : 0) << power++);
                    }
                    allStrings.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    try {
                        return sb.toString().getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < allStrings.size() && allStrings.get(cc) != null) {
                entry = allStrings.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return new byte[0];
            }
            sb.append(entry);
            allStrings.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return new byte[0];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ByteStringEncoding.BYTE_STRINGS[i] = Character.toString((char)i);
        }
        contextDictionary = new HashMap(256, 0.5f);
        contextDictionaryToCreate = new HashSet(256, 0.5f);
        allStrings = new ArrayList(256);
        sb = new StringBuilder(1024);
    }
}

