/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.ds.IntList;
import com.github.yellowstonegames.core.DescriptiveColor;
import com.github.yellowstonegames.core.Interpolations;

public final class ColorGradients {
    private ColorGradients() {
    }

    public static IntList makeGradient(int start, int end, int steps) {
        return ColorGradients.makeGradient(start, end, steps, Interpolations.linear);
    }

    public static IntList makeGradient(int start, int end, int steps, Interpolations.InterpolationFunction interpolation) {
        IntList appending = new IntList(steps);
        if (steps <= 0) {
            return appending;
        }
        if (steps == 1) {
            appending.add(start);
            return appending;
        }
        ColorGradients.appendPartialGradient(appending, start, end, steps - 1, interpolation).add(end);
        return appending;
    }

    public static IntList appendGradient(IntList appending, int start, int end, int steps) {
        return ColorGradients.appendGradient(appending, start, end, steps, Interpolations.linear);
    }

    public static IntList appendGradient(IntList appending, int start, int end, int steps, Interpolations.InterpolationFunction interpolation) {
        if (appending == null) {
            return null;
        }
        if (steps <= 0) {
            return appending;
        }
        if (steps == 1) {
            appending.add(start);
            return appending;
        }
        appending.ensureCapacity(steps);
        ColorGradients.appendPartialGradient(appending, start, end, steps - 1, interpolation).add(end);
        return appending;
    }

    public static IntList appendGradientChain(IntList appending, int steps, int ... chain) {
        return ColorGradients.appendGradientChain(appending, steps, (Interpolations.InterpolationFunction)Interpolations.linear, chain);
    }

    public static IntList appendGradientChain(IntList appending, int steps, IntList chain) {
        return ColorGradients.appendGradientChain(appending, steps, (Interpolations.InterpolationFunction)Interpolations.linear, chain);
    }

    public static IntList appendGradientChain(IntList appending, int steps, Interpolations.InterpolationFunction interpolation, IntList chain) {
        if (appending == null) {
            return null;
        }
        if (chain == null) {
            return appending;
        }
        if (steps <= 0 || chain.size() == 0) {
            return appending;
        }
        if (steps == 1 || chain.size() == 1) {
            appending.add(chain.first());
            return appending;
        }
        appending.ensureCapacity(steps);
        int limit = steps - 1;
        int splits = chain.size() - 1;
        float step = 1.0f / (float)steps;
        float change = 0.0f;
        for (int i = 0; i < limit; ++i) {
            float interp = interpolation.apply(change);
            float splint = Math.min(Math.max(interp * (float)splits, 0.0f), (float)splits - 1.0E-6f);
            int idx = (int)splint;
            appending.add(DescriptiveColor.limitToGamut(DescriptiveColor.lerpColors(chain.get(idx), chain.get(idx + 1), MathTools.norm((float)idx, (float)(idx + 1), (float)splint))));
            change += step;
        }
        appending.add(chain.get(splits));
        return appending;
    }

    public static IntList appendGradientChain(IntList appending, int steps, Interpolations.InterpolationFunction interpolation, int ... chain) {
        if (appending == null) {
            return null;
        }
        if (chain == null) {
            return appending;
        }
        if (steps <= 0 || chain.length == 0) {
            return appending;
        }
        if (steps == 1 || chain.length == 1) {
            appending.add(chain[0]);
            return appending;
        }
        appending.ensureCapacity(steps);
        int limit = steps - 1;
        int splits = chain.length - 1;
        float step = 1.0f / (float)steps;
        float change = 0.0f;
        for (int i = 0; i < limit; ++i) {
            float interp = interpolation.apply(change);
            float splint = Math.min(Math.max(interp * (float)splits, 0.0f), (float)splits - 1.0E-6f);
            int idx = (int)splint;
            appending.add(DescriptiveColor.limitToGamut(DescriptiveColor.lerpColors(chain[idx], chain[idx + 1], MathTools.norm((float)idx, (float)(idx + 1), (float)splint))));
            change += step;
        }
        appending.add(chain[splits]);
        return appending;
    }

    public static IntList appendPartialGradient(IntList appending, int start, int end, int steps) {
        return ColorGradients.appendPartialGradient(appending, start, end, steps, Interpolations.linear);
    }

    public static IntList appendPartialGradient(IntList appending, int start, int end, int steps, Interpolations.InterpolationFunction interpolation) {
        if (appending == null) {
            return null;
        }
        if (steps <= 0) {
            return appending;
        }
        if (steps == 1) {
            appending.add(start);
            return appending;
        }
        int limit = steps;
        float step = 1.0f / (float)steps;
        float change = 0.0f;
        for (int i = 0; i < limit; ++i) {
            appending.add(DescriptiveColor.limitToGamut(DescriptiveColor.lerpColors(start, end, interpolation.apply(change))));
            change += step;
        }
        return appending;
    }

    public static IntList toRGBA8888(IntList colors) {
        int n = colors.size();
        for (int i = 0; i < n; ++i) {
            colors.set(i, DescriptiveColor.toRGBA8888(colors.get(i)));
        }
        return colors;
    }
}

