/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.ObjectIntOrderedMap;
import com.github.tommyettinger.ds.ObjectList;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.Gamut;
import org.checkerframework.checker.nullness.qual.NonNull;
import regexodus.Pattern;
import regexodus.Replacer;
import regexodus.Substitution;

public final class DescriptiveColor {
    public static final ObjectIntOrderedMap<String> NAMED = new ObjectIntOrderedMap(50);
    public static final ObjectIntOrderedMap<String> ALIASES = new ObjectIntOrderedMap(10);
    public static final IntList LIST = new IntList(50);
    public static final int PLACEHOLDER = 256;
    public static final int TRANSPARENT = 0x7F7F00;
    public static final int BLACK = -8421632;
    public static final int GRAY = -8421501;
    public static final int SILVER = -8421448;
    public static final int WHITE = -8421377;
    public static final int RED = -7365502;
    public static final int ORANGE = -7172953;
    public static final int YELLOW = -6785296;
    public static final int GREEN = -6921778;
    public static final int BLUE = -11044018;
    public static final int INDIGO = -10581934;
    public static final int VIOLET = -10121354;
    public static final int PURPLE = -10249601;
    public static final int BROWN = -7895448;
    public static final int PINK = -8810812;
    public static final int MAGENTA = -9789037;
    public static final int BRICK = -7827069;
    public static final int EMBER = -7433581;
    public static final int SALMON = -7826275;
    public static final int CHOCOLATE = -7829947;
    public static final int TAN = -7962181;
    public static final int BRONZE = -7371873;
    public static final int CINNAMON = -7370101;
    public static final int APRICOT = -7109187;
    public static final int PEACH = -7633715;
    public static final int PEAR = -6982187;
    public static final int SAFFRON = -6914857;
    public static final int BUTTER = -7439125;
    public static final int CHARTREUSE = -6983452;
    public static final int CACTUS = -7312505;
    public static final int LIME = -7049284;
    public static final int OLIVE = -7374467;
    public static final int FERN = -7899538;
    public static final int MOSS = -7768774;
    public static final int CELERY = -7377958;
    public static final int SAGE = -8226860;
    public static final int JADE = -7443806;
    public static final int CYAN = -8753957;
    public static final int MINT = -8228640;
    public static final int TEAL = -8621200;
    public static final int TURQUOISE = -8556869;
    public static final int SKY = -9014868;
    public static final int COBALT = -9864371;
    public static final int DENIM = -9144447;
    public static final int NAVY = -10060764;
    public static final int LAVENDER = -9467732;
    public static final int PLUM = -9659532;
    public static final int MAUVE = -8877428;
    public static final int ROSE = -8479362;
    public static final int RASPBERRY = -8154036;
    public static final ObjectList<String> NAMES;
    public static final ObjectList<String> NAMES_BY_HUE;
    public static final IntList COLORS_BY_HUE;
    public static final ObjectList<String> NAMES_BY_LIGHTNESS;
    private static final IntList mixing;
    private static final ObjectList<String> namesByHue;
    private static final IntList colorsByHue;
    private static final StringBuilder builder;
    private static final Substitution sub;
    private static final Replacer rep;

    private DescriptiveColor() {
    }

    private static float cube(float x) {
        return x * x * x;
    }

    private static float cbrtPositive(float x) {
        int ix = BitConversion.floatToRawIntBits((float)x);
        float x0 = x;
        ix = (ix >>> 2) + (ix >>> 4);
        ix += ix >>> 4;
        ix += (ix >>> 8) + 709965728;
        x = BitConversion.intBitsToFloat((int)ix);
        x = 0.33333334f * (2.0f * x + x0 / (x * x));
        x = 0.33333334f * (2.0f * x + x0 / (x * x));
        return x;
    }

    private static float forwardGamma(float component) {
        return component * component;
    }

    private static float reverseGamma(float component) {
        return (float)Math.sqrt(component);
    }

    public static float forwardLight(float L) {
        float shape = 0.65789473f;
        float turning = 0.963f;
        float d = 0.963f - L;
        float r = d < 0.0f ? 0.037f * (L - 1.0f) / (1.0f - (L + 0.65789473f * d)) + 1.0f : 0.963f * L / (1.0E-20f + (L + 0.65789473f * d));
        return r * r * 1.0039216f;
    }

    public static float reverseLight(float L) {
        L = (float)Math.sqrt(L * 0.99609375f);
        float shape = 1.52f;
        float turning = 0.963f;
        float d = 0.963f - L;
        float r = d < 0.0f ? 0.037f * (L - 1.0f) / (1.0f - (L + 1.52f * d)) + 1.0f : 0.963f * L / (1.0E-20f + (L + 1.52f * d));
        return r;
    }

    public static int oklab(float L, float A, float B, float alpha) {
        return DescriptiveColor.limitToGamut((int)(L * 255.999f), (int)(A * 255.999f), (int)(B * 255.999f), (int)(alpha * 255.999f));
    }

    public static int toRGBA8888(int oklab) {
        float L = DescriptiveColor.reverseLight((float)(oklab & 0xFF) / 255.0f);
        float A = ((float)(oklab >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(oklab >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        int r = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f)) * 255.999f);
        int g = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f)) * 255.999f);
        int b = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f)) * 255.999f);
        return r << 24 | g << 16 | b << 8 | (oklab & 0xFE000000) >>> 24 | oklab >>> 31;
    }

    public static float oklabIntToFloat(int packed) {
        float L = DescriptiveColor.reverseLight((float)(packed & 0xFF) / 255.0f);
        float A = ((float)(packed >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(packed >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        int r = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f)) * 255.999f);
        int g = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f)) * 255.999f);
        int b = (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f)) * 255.999f);
        return BitConversion.intBitsToFloat((int)(r | g << 8 | b << 16 | packed & 0xFE000000));
    }

    public static int fromRGBA8888(int rgba) {
        float r = DescriptiveColor.forwardGamma((float)(rgba >>> 24) * 0.003921569f);
        float g = DescriptiveColor.forwardGamma((float)(rgba >>> 16 & 0xFF) * 0.003921569f);
        float b = DescriptiveColor.forwardGamma((float)(rgba >>> 8 & 0xFF) * 0.003921569f);
        float l = DescriptiveColor.cbrtPositive(0.4121656f * r + 0.5362752f * g + 0.051457565f * b);
        float m = DescriptiveColor.cbrtPositive(0.2118591f * r + 0.68071896f * g + 0.10740658f * b);
        float s = DescriptiveColor.cbrtPositive(0.088309795f * r + 0.28184742f * g + 0.63026136f * b);
        return Math.min(Math.max((int)(DescriptiveColor.forwardLight(0.21045426f * l + 0.7936178f * m - 0.004072047f * s) * 255.999f), 0), 255) | Math.min(Math.max((int)((1.9779985f * l - 2.4285922f * m + 0.4505937f * s) * 127.999f + 127.5f), 0), 255) << 8 | Math.min(Math.max((int)((0.025904037f * l + 0.78277177f * m - 0.80867577f * s) * 127.999f + 127.5f), 0), 255) << 16 | rgba << 24;
    }

    public static int fromRGBA(float packed) {
        int abgr = BitConversion.floatToRawIntBits((float)packed);
        float r = DescriptiveColor.forwardGamma((float)(abgr & 0xFF) * 0.003921569f);
        float g = DescriptiveColor.forwardGamma((float)(abgr >>> 8 & 0xFF) * 0.003921569f);
        float b = DescriptiveColor.forwardGamma((float)(abgr >>> 16 & 0xFF) * 0.003921569f);
        float l = DescriptiveColor.cbrtPositive(0.4121656f * r + 0.5362752f * g + 0.051457565f * b);
        float m = DescriptiveColor.cbrtPositive(0.2118591f * r + 0.68071896f * g + 0.10740658f * b);
        float s = DescriptiveColor.cbrtPositive(0.088309795f * r + 0.28184742f * g + 0.63026136f * b);
        return Math.min(Math.max((int)(DescriptiveColor.forwardLight(0.21045426f * l + 0.7936178f * m - 0.004072047f * s) * 255.999f), 0), 255) | Math.min(Math.max((int)((1.9779985f * l - 2.4285922f * m + 0.4505937f * s) * 127.999f + 127.5f), 0), 255) << 8 | Math.min(Math.max((int)((0.025904037f * l + 0.78277177f * m - 0.80867577f * s) * 127.999f + 127.5f), 0), 255) << 16 | abgr & 0xFE000000;
    }

    public static int fromRGBA(float r, float g, float b, float a) {
        r = DescriptiveColor.forwardGamma(r);
        g = DescriptiveColor.forwardGamma(g);
        b = DescriptiveColor.forwardGamma(b);
        float l = DescriptiveColor.cbrtPositive(0.4121656f * r + 0.5362752f * g + 0.051457565f * b);
        float m = DescriptiveColor.cbrtPositive(0.2118591f * r + 0.68071896f * g + 0.10740658f * b);
        float s = DescriptiveColor.cbrtPositive(0.088309795f * r + 0.28184742f * g + 0.63026136f * b);
        return Math.min(Math.max((int)(DescriptiveColor.forwardLight(0.21045426f * l + 0.7936178f * m - 0.004072047f * s) * 255.999f), 0), 255) | Math.min(Math.max((int)((1.9779985f * l - 2.4285922f * m + 0.4505937f * s) * 127.999f + 127.5f), 0), 255) << 8 | Math.min(Math.max((int)((0.025904037f * l + 0.78277177f * m - 0.80867577f * s) * 127.999f + 127.5f), 0), 255) << 16 | (int)(a * 255.0f) << 24;
    }

    public static int redInt(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f)) * 255.999f);
    }

    public static int greenInt(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f)) * 255.999f);
    }

    public static int blueInt(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return (int)(DescriptiveColor.reverseGamma(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f)) * 255.999f);
    }

    public static int alphaInt(int encoded) {
        return encoded >>> 24;
    }

    public static float red(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return DescriptiveColor.reverseGamma(Math.min(Math.max(4.0767245f * l - 3.307217f * m + 0.23075905f * s, 0.0f), 1.0f));
    }

    public static float green(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return DescriptiveColor.reverseGamma(Math.min(Math.max(-1.2681438f * l + 2.6093323f * m - 0.34113443f * s, 0.0f), 1.0f));
    }

    public static float blue(int encoded) {
        float L = DescriptiveColor.reverseLight((float)(encoded & 0xFF) / 255.0f);
        float A = ((float)(encoded >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(encoded >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float l = DescriptiveColor.cube(L + 0.39633778f * A + 0.21580376f * B);
        float m = DescriptiveColor.cube(L - 0.105561346f * A - 0.06385417f * B);
        float s = DescriptiveColor.cube(L - 0.08948418f * A - 1.2914855f * B);
        return DescriptiveColor.reverseGamma(Math.min(Math.max(-0.0041119885f * l - 0.7034763f * m + 1.7068626f * s, 0.0f), 1.0f));
    }

    public static float alpha(int encoded) {
        return (float)(encoded >>> 24) / 255.0f;
    }

    public static float channelL(int encoded) {
        return (float)(encoded & 0xFF) / 255.0f;
    }

    public static float lightness(int encoded) {
        return (float)(encoded & 0xFF) / 255.0f;
    }

    public static float channelA(int encoded) {
        return (float)(encoded >>> 8 & 0xFF) / 255.0f;
    }

    public static float channelB(int encoded) {
        return (float)(encoded >>> 16 & 0xFF) / 255.0f;
    }

    public static float chroma(int oklab) {
        float a = (float)((oklab >>> 7 & 0x1FE) - 255) * 0.00390625f;
        float b = (float)((oklab >>> 15 & 0x1FE) - 255) * 0.00390625f;
        return (float)Math.sqrt(a * a + b * b);
    }

    public static float chromaLimit(float hue, float lightness) {
        int idx = (int)(Math.min(Math.max(lightness, 0.0f), 1.0f) * 255.999f) << 8 | (int)(256.0f * (hue - (float)MathTools.fastFloor((float)hue)));
        return ((float)Gamut.GAMUT_DATA[idx] + 1.5f) * 0.00390625f;
    }

    public static float saturation(int packed) {
        float B = (float)(packed >>> 16 & 0xFF) - 127.5f;
        float A = (float)(packed >>> 8 & 0xFF) - 127.5f;
        float hue = TrigTools.atan2Turns((float)B, (float)A);
        int idx = (packed & 0xFF) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] + 1.5f;
        return dist == 3.5f ? 0.0f : (A * A + B * B) * 4.0f / (dist * dist);
    }

    public static float hue(int oklab) {
        float a = (oklab >>> 7 & 0x1FE) - 255;
        float b = (oklab >>> 15 & 0x1FE) - 255;
        return TrigTools.atan2Turns((float)a, (float)b);
    }

    public static int lighten(int oklab, float change) {
        int L = oklab & 0xFF;
        int other = oklab & 0xFFFFFF00;
        return (int)((float)L + (float)(255 - L) * change) & 0xFF | other;
    }

    public static int darken(int oklab, float change) {
        int i = oklab & 0xFF;
        int other = oklab & 0xFFFFFF00;
        return (int)((float)i * (1.0f - change)) & 0xFF | other;
    }

    public static int raiseA(int start, float change) {
        int p = start >>> 8 & 0xFF;
        int other = start & 0xFFFF00FF;
        return (int)((float)p + (float)(255 - p) * change) << 8 & 0xFF00 | other;
    }

    public static int lowerA(int start, float change) {
        int p = start >>> 8 & 0xFF;
        int other = start & 0xFFFF00FF;
        return ((int)((float)p * (1.0f - change)) & 0xFF) << 8 | other;
    }

    public static int raiseB(int start, float change) {
        int t = start >>> 16 & 0xFF;
        int other = start & 0xFF00FFFF;
        return (int)((float)t + (float)(255 - t) * change) << 16 & 0xFF0000 | other;
    }

    public static int lowerB(int start, float change) {
        int t = start >>> 16 & 0xFF;
        int other = start & 0xFF00FFFF;
        return ((int)((float)t * (1.0f - change)) & 0xFF) << 16 | other;
    }

    public static int blot(int start, float change) {
        int opacity = start >>> 24;
        int other = start & 0xFFFFFF;
        return ((int)((float)opacity + (float)(255 - opacity) * change) & 0xFF) << 24 | other;
    }

    public static int fade(int start, float change) {
        int opacity = start >>> 24;
        int other = start & 0xFFFFFF;
        return ((int)((float)opacity * (1.0f - change)) & 0xFF) << 24 | other;
    }

    public static int dullen(int oklab, float change) {
        return (int)(((float)(oklab >>> 8 & 0xFF) - 127.5f) * (1.0f - change) + 127.5f) << 8 | (int)(((float)(oklab >>> 16 & 0xFF) - 127.5f) * (1.0f - change) + 127.5f) << 16 | oklab & 0xFF0000FF;
    }

    public static int enrich(int oklab, float change) {
        return DescriptiveColor.limitToGamut((int)(((float)(oklab >>> 8 & 0xFF) - 127.5f) * (1.0f - change) + 127.5f) << 8 | (int)(((float)(oklab >>> 16 & 0xFF) - 127.5f) * (1.0f - change) + 127.5f) << 16 | oklab & 0xFF0000FF);
    }

    public static int edit(int oklab, float addL, float addA, float addB, float addAlpha) {
        return DescriptiveColor.edit(oklab, addL, addA, addB, addAlpha, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static int edit(int oklab, float addL, float addA, float addB, float addAlpha, float mulL, float mulA, float mulB, float mulAlpha) {
        float L = (float)(oklab & 0xFF) / 255.0f;
        float A = ((float)(oklab >>> 8 & 0xFF) - 127.5f) / 127.5f;
        float B = ((float)(oklab >>> 16 & 0xFF) - 127.5f) / 127.5f;
        float alpha = (float)(oklab >>> 24) / 255.0f;
        L = Math.min(Math.max(L * mulL + addL, 0.0f), 1.0f);
        A = Math.min(Math.max(A * mulA + addA * 2.0f, -1.0f), 1.0f) * 0.5f;
        B = Math.min(Math.max(B * mulB + addB * 2.0f, -1.0f), 1.0f) * 0.5f;
        alpha = Math.min(Math.max(alpha * mulAlpha + addAlpha, 0.0f), 1.0f);
        float hue = TrigTools.atan2Turns((float)B, (float)A);
        int idx = (int)(L * 255.999f) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        if (dist * dist * 1.5258789E-5f + 6.1035156E-5f >= A * A + B * B) {
            return (int)(alpha * 255.999f) << 24 | (int)((B + 0.5f) * 255.999f) << 16 | (int)((A + 0.5f) * 255.999f) << 8 | (int)(L * 255.999f);
        }
        return (int)(alpha * 255.999f) << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(L * 255.999f);
    }

    public static byte getRawGamutValue(int index) {
        return Gamut.GAMUT_DATA[index];
    }

    public static boolean inGamut(int packed) {
        float B = ((float)(packed >>> 16 & 0xFF) - 127.0f) / 255.0f;
        float A = ((float)(packed >>> 8 & 0xFF) - 127.0f) / 255.0f;
        float g = Gamut.GAMUT_DATA[(packed & 0xFF) << 8 | (int)(256.0f * TrigTools.atan2Turns((float)B, (float)A))];
        return (double)(g * g) * 3.814697265625E-6 + 6.103515625E-5 >= (double)(A * A + B * B);
    }

    public static boolean inGamut(int L, int A, int B) {
        float B2 = ((float)B - 127.0f) / 255.0f;
        float A2 = ((float)A - 127.0f) / 255.0f;
        float g = Gamut.GAMUT_DATA[(L & 0xFF) << 8 | (int)(256.0f * TrigTools.atan2Turns((float)B2, (float)A2))];
        return (double)(g * g) * 3.814697265625E-6 + 6.103515625E-5 >= (double)(A2 * A2 + B2 * B2);
    }

    public static boolean inGamut(float L, float A, float B) {
        byte g = Gamut.GAMUT_DATA[(int)(L * 255.999f) << 8 & 0xFF00 | (int)(256.0f * TrigTools.atan2Turns((float)(B -= 0.5f), (float)(A -= 0.5f)))];
        return (double)(g * g) * 3.814697265625E-6 + 6.103515625E-5 >= (double)(A * A + B * B);
    }

    public static int maximizeSaturation(int packed) {
        float A = (float)(packed >>> 8 & 0xFF) - 127.5f;
        float B = (float)(packed >>> 16 & 0xFF) - 127.5f;
        float hue = TrigTools.atan2Turns((float)B, (float)A);
        int idx = (packed & 0xFF) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        return packed & 0xFF0000FF | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16;
    }

    public static int maximizeSaturation(int L, int A, int B, int alpha) {
        L = Math.min(Math.max(L, 0), 255);
        A = Math.min(Math.max(A, 0), 255);
        B = Math.min(Math.max(B, 0), 255);
        alpha = Math.min(Math.max(alpha, 0), 255);
        float A2 = (float)A - 127.5f;
        float B2 = (float)B - 127.5f;
        float hue = TrigTools.atan2Turns((float)B2, (float)A2);
        int idx = L << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        return alpha << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | L;
    }

    public static float maximizeSaturation(float L, float A, float B, float alpha) {
        L = Math.min(Math.max(L, 0.0f), 1.0f);
        A = Math.min(Math.max(A, 0.0f), 1.0f);
        B = Math.min(Math.max(B, 0.0f), 1.0f);
        alpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        float A2 = A - 0.5f;
        float B2 = B - 0.5f;
        float hue = TrigTools.atan2Turns((float)B2, (float)A2);
        int idx = (int)(L * 255.999f) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        return BitConversion.intBitsToFloat((int)((int)(alpha * 255.999f) << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(L * 255.999f)));
    }

    public static int limitToGamut(int packed) {
        float B = (float)(packed >>> 16 & 0xFF) - 127.5f;
        float A = (float)(packed >>> 8 & 0xFF) - 127.5f;
        float hue = TrigTools.atan2Turns((float)B, (float)A);
        int idx = (packed & 0xFF) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        if (dist * dist >= A * A + B * B) {
            return packed;
        }
        return packed & 0xFF0000FF | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16;
    }

    public static int limitToGamut(int L, int A, int B) {
        return DescriptiveColor.limitToGamut(L, A, B, 255);
    }

    public static int limitToGamut(int L, int A, int B, int alpha) {
        L = Math.min(Math.max(L, 0), 255);
        A = Math.min(Math.max(A, 0), 255);
        B = Math.min(Math.max(B, 0), 255);
        alpha = Math.min(Math.max(alpha, 0), 255);
        float B2 = ((float)B - 127.5f) / 255.0f;
        float A2 = ((float)A - 127.5f) / 255.0f;
        float hue = TrigTools.atan2Turns((float)B2, (float)A2);
        int idx = L << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * 0.5f;
        if (dist * dist * 1.5258789E-5f + 6.1035156E-5f >= A2 * A2 + B2 * B2) {
            return L | A << 8 | B << 16 | alpha << 24;
        }
        return alpha << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | L;
    }

    public static int oklabByHSL(float hue, float saturation, float lightness, float alpha) {
        lightness = Math.min(Math.max(lightness, 0.0f), 1.0f);
        saturation = Math.min(Math.max(saturation, 0.0f), 1.0f);
        hue -= (float)MathTools.fastFloor((float)hue);
        alpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        int idx = (int)(lightness * 255.999f) << 8 | (int)(256.0f * hue);
        float dist = (float)Gamut.GAMUT_DATA[idx] * saturation * 0.5f;
        return (int)(alpha * 255.999f) << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(lightness * 255.999f);
    }

    public static int oklabByHCL(float hue, float chroma, float lightness, float alpha) {
        lightness = Math.min(Math.max(lightness, 0.0f), 1.0f);
        chroma = Math.max(chroma, 0.0f);
        hue -= (float)MathTools.fastFloor((float)hue);
        alpha = Math.min(Math.max(alpha, 0.0f), 1.0f);
        int idx = (int)(lightness * 255.999f) << 8 | (int)(256.0f * hue);
        float dist = Math.min(chroma * 127.5f, (float)Gamut.GAMUT_DATA[idx] * 0.5f);
        return (int)(alpha * 255.999f) << 24 | (int)(TrigTools.sinTurns((float)hue) * dist + 128.0f) << 16 | (int)(TrigTools.cosTurns((float)hue) * dist + 128.0f) << 8 | (int)(lightness * 255.999f);
    }

    public static int lerpColors(int s, int e, float change) {
        int sL = s & 0xFF;
        int sA = s >>> 8 & 0xFF;
        int sB = s >>> 16 & 0xFF;
        int sAlpha = s >>> 24 & 0xFF;
        int eL = e & 0xFF;
        int eA = e >>> 8 & 0xFF;
        int eB = e >>> 16 & 0xFF;
        int eAlpha = e >>> 24 & 0xFF;
        return (int)((float)sL + change * (float)(eL - sL)) & 0xFF | ((int)((float)sA + change * (float)(eA - sA)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | ((int)((float)sAlpha + change * (float)(eAlpha - sAlpha)) & 0xFF) << 24;
    }

    public static int lerpColorsBlended(int start, int end, float change) {
        int sL = start & 0xFF;
        int sA = start >>> 8 & 0xFF;
        int sB = start >>> 16 & 0xFF;
        int sAlpha = start & 0xFF000000;
        int eL = end & 0xFF;
        int eA = end >>> 8 & 0xFF;
        int eB = end >>> 16 & 0xFF;
        int eAlpha = end >>> 24;
        return (int)((float)sL + (change *= (float)eAlpha / 255.0f) * (float)(eL - sL)) & 0xFF | ((int)((float)sA + change * (float)(eA - sA)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | sAlpha;
    }

    public static int mix(int[] colors, int offset, int size) {
        int end = offset + size;
        if (colors == null || colors.length < end || offset < 0 || size <= 0) {
            return 256;
        }
        int result = 256;
        while (colors[offset] == 256) {
            ++offset;
        }
        if (offset < end) {
            result = colors[offset];
        }
        int i = offset + 1;
        int denom = 2;
        while (i < end) {
            if (colors[i] != 256) {
                result = DescriptiveColor.lerpColors(result, colors[i], 1.0f / (float)denom);
            } else {
                --denom;
            }
            ++i;
            ++denom;
        }
        return result;
    }

    public static int describe(CharSequence description) {
        if (description == null || description.length() == 0) {
            return 0;
        }
        char initial = description.charAt(0);
        if (initial == '#') {
            if (description.length() >= 7 && description.length() < 9) {
                return DigitTools.intFromHex(description, 1, 7) << 8 | 0xFF;
            }
            if (description.length() >= 9) {
                return DigitTools.intFromHex(description, 1, 9);
            }
            return 0;
        }
        return DescriptiveColor.toRGBA8888(DescriptiveColor.describeOklab(description, initial == '|' ? 1 : 0, description.length()));
    }

    public static int describeOklab(CharSequence description) {
        return DescriptiveColor.describeOklab(description, 0, description.length());
    }

    public static int describeOklab(CharSequence description, int start, int length) {
        float lightness = 0.0f;
        float saturation = 0.0f;
        String[] terms = description.toString().split("[^a-zA-Z]+");
        mixing.clear();
        block56: for (int i = 0; i < terms.length; ++i) {
            String term = terms[i];
            if (term == null || term.isEmpty()) continue;
            int len = term.length();
            switch (term.charAt(0)) {
                case 'l': {
                    if (len > 2 && term.charAt(2) == 'g') {
                        switch (len) {
                            case 9: {
                                lightness += 0.15f;
                            }
                            case 8: {
                                lightness += 0.15f;
                            }
                            case 7: {
                                lightness += 0.15f;
                            }
                            case 5: {
                                lightness += 0.15f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                case 'b': {
                    if (len > 3 && term.charAt(3) == 'g') {
                        switch (len) {
                            case 10: {
                                lightness += 0.15f;
                                saturation += 0.25f;
                            }
                            case 9: {
                                lightness += 0.15f;
                                saturation += 0.2f;
                            }
                            case 8: {
                                lightness += 0.15f;
                                saturation += 0.1f;
                            }
                            case 6: {
                                lightness += 0.15f;
                                saturation += 0.1f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                case 'p': {
                    if (len > 2 && term.charAt(2) == 'l') {
                        switch (len) {
                            case 7: 
                            case 8: {
                                lightness += 0.15f;
                                saturation -= 0.25f;
                            }
                            case 6: {
                                lightness += 0.15f;
                                saturation -= 0.2f;
                            }
                            case 5: {
                                lightness += 0.15f;
                                saturation -= 0.15f;
                            }
                            case 4: {
                                lightness += 0.15f;
                                saturation -= 0.1f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                case 'w': {
                    if (len > 3 && term.charAt(3) == 'k') {
                        switch (len) {
                            case 8: {
                                lightness -= 0.15f;
                                saturation -= 0.25f;
                            }
                            case 7: {
                                lightness -= 0.15f;
                                saturation -= 0.2f;
                            }
                            case 6: {
                                lightness -= 0.15f;
                                saturation -= 0.15f;
                            }
                            case 4: {
                                lightness -= 0.15f;
                                saturation -= 0.1f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                case 'r': {
                    if (len > 1 && term.charAt(1) == 'i') {
                        switch (len) {
                            case 8: {
                                saturation += 0.25f;
                            }
                            case 7: {
                                saturation += 0.2f;
                            }
                            case 6: {
                                saturation += 0.15f;
                            }
                            case 4: {
                                saturation += 0.1f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                case 'd': {
                    if (len > 1 && term.charAt(1) == 'a') {
                        switch (len) {
                            case 8: {
                                lightness -= 0.15f;
                            }
                            case 7: {
                                lightness -= 0.15f;
                            }
                            case 6: {
                                lightness -= 0.15f;
                            }
                            case 4: {
                                lightness -= 0.15f;
                                continue block56;
                            }
                        }
                    } else if (len > 1 && term.charAt(1) == 'u') {
                        switch (len) {
                            case 8: {
                                saturation -= 0.25f;
                            }
                            case 7: {
                                saturation -= 0.2f;
                            }
                            case 6: {
                                saturation -= 0.15f;
                            }
                            case 4: {
                                saturation -= 0.1f;
                                continue block56;
                            }
                        }
                    } else if (len > 3 && term.charAt(3) == 'p') {
                        switch (len) {
                            case 8: {
                                lightness -= 0.15f;
                                saturation += 0.25f;
                            }
                            case 7: {
                                lightness -= 0.15f;
                                saturation += 0.2f;
                            }
                            case 6: {
                                lightness -= 0.15f;
                                saturation += 0.15f;
                            }
                            case 4: {
                                lightness -= 0.15f;
                                saturation += 0.1f;
                                continue block56;
                            }
                        }
                    }
                    mixing.add(NAMED.get((Object)term));
                    continue block56;
                }
                default: {
                    mixing.add(NAMED.get((Object)term));
                }
            }
        }
        if (mixing.size() == 0) {
            return 0;
        }
        int result = DescriptiveColor.mix(DescriptiveColor.mixing.items, 0, mixing.size());
        if (result == 256) {
            return result;
        }
        if (lightness > 0.0f) {
            result = DescriptiveColor.lighten(result, lightness);
        } else if (lightness < 0.0f) {
            result = DescriptiveColor.darken(result, -lightness);
        }
        result = saturation > 0.0f ? DescriptiveColor.enrich(result, saturation) : (saturation < 0.0f ? DescriptiveColor.limitToGamut(DescriptiveColor.dullen(result, -saturation)) : DescriptiveColor.limitToGamut(result));
        return result;
    }

    public static @NonNull String bestMatch(int oklab, int mixCount) {
        int e;
        int i;
        mixCount = Math.max(1, mixCount);
        float bestDistance = Float.POSITIVE_INFINITY;
        int paletteSize = namesByHue.size();
        int colorTries = (int)Math.pow(paletteSize, mixCount);
        int totalTries = colorTries * 81;
        float targetL = DescriptiveColor.channelL(oklab);
        float targetA = DescriptiveColor.channelA(oklab);
        float targetB = DescriptiveColor.channelB(oklab);
        String[] lightAdjectives = new String[]{"darkmost ", "darkest ", "darker ", "dark ", "", "light ", "lighter ", "lightest ", "lightmost "};
        String[] satAdjectives = new String[]{"dullmost ", "dullest ", "duller ", "dull ", "", "rich ", "richer ", "richest ", "richmost "};
        mixing.clear();
        for (int i2 = 0; i2 < mixCount; ++i2) {
            mixing.add(colorsByHue.get(0));
        }
        int bestCode = 0;
        for (int c = 0; c < totalTries; ++c) {
            float f;
            i = 0;
            e = 1;
            while (i < mixCount) {
                mixing.set(i, colorsByHue.get(c / e % paletteSize));
                ++i;
                e *= paletteSize;
            }
            int idxI = c / colorTries % 9 - 4;
            int idxS = c / (colorTries * 9) - 4;
            int result = DescriptiveColor.mix(DescriptiveColor.mixing.items, 0, mixCount);
            if (idxI > 0) {
                result = DescriptiveColor.lighten(result, 0.125f * (float)idxI);
            } else if (idxI < 0) {
                result = DescriptiveColor.darken(result, -0.15f * (float)idxI);
            }
            result = idxS > 0 ? DescriptiveColor.limitToGamut(DescriptiveColor.enrich(result, 0.2f * (float)idxS)) : (idxS < 0 ? DescriptiveColor.dullen(result, -0.2f * (float)idxS) : DescriptiveColor.limitToGamut(result));
            float dL = DescriptiveColor.channelL(result) - targetL;
            float dA = DescriptiveColor.channelA(result) - targetA;
            float dB = DescriptiveColor.channelB(result) - targetB;
            float f2 = bestDistance;
            bestDistance = Math.min(dL * dL + dA * dA + dB * dB, bestDistance);
            if (!(f2 > f)) continue;
            bestCode = c;
        }
        StringBuilder description = new StringBuilder(lightAdjectives[bestCode / colorTries % 9] + satAdjectives[bestCode / (colorTries * 9)]);
        i = 0;
        e = 1;
        while (i < mixCount) {
            description.append((String)namesByHue.get(bestCode / e % paletteSize));
            if (++i < mixCount) {
                description.append(' ');
            }
            e *= paletteSize;
        }
        return description.toString();
    }

    public static String processColorMarkup(CharSequence markupString) {
        builder.setLength(0);
        return rep.replace(markupString);
    }

    public static int differentiateLightness(int mainColor, int contrastingColor) {
        return DescriptiveColor.limitToGamut(mainColor & 0xFFFFFF00 | (contrastingColor + 128 & 0xFF) + (mainColor & 0xFF) >>> 1);
    }

    public static int offsetLightness(int oklab) {
        return DescriptiveColor.limitToGamut(oklab & 0xFFFFFF00 | (oklab + 128 & 0xFF) + (oklab & 0xFF) >>> 1);
    }

    public static float rgbaIntToFloat(int rgba) {
        return BitConversion.reversedIntBitsToFloat((int)(rgba & 0xFFFFFFFE));
    }

    public static float distanceSquared(int colorA, int colorB) {
        float LA = DescriptiveColor.reverseLight((float)(colorA & 0xFF) / 255.0f);
        float AA = ((float)(colorA >>> 8 & 0xFF) - 127.0f) / 127.0f;
        float BA = ((float)(colorA >>> 16 & 0xFF) - 127.0f) / 127.0f;
        float LDiff = DescriptiveColor.reverseLight((float)(colorB & 0xFF) / 255.0f) - LA;
        float ADiff = ((float)(colorB >>> 8 & 0xFF) - 127.0f) / 127.0f - AA;
        float BDiff = ((float)(colorB >>> 16 & 0xFF) - 127.0f) / 127.0f - BA;
        return LDiff * LDiff + ADiff * ADiff + BDiff * BDiff;
    }

    public static float distance(int encodedA, int encodedB) {
        return (float)Math.sqrt(DescriptiveColor.distanceSquared(encodedA, encodedB));
    }

    static {
        NAMED.put((Object)"transparent", 0x7F7F00);
        LIST.add(0x7F7F00);
        NAMED.put((Object)"black", -8421632);
        LIST.add(-8421632);
        NAMED.put((Object)"gray", -8421501);
        LIST.add(-8421501);
        NAMED.put((Object)"silver", -8421448);
        LIST.add(-8421448);
        NAMED.put((Object)"white", -8421377);
        LIST.add(-8421377);
        NAMED.put((Object)"red", -7365502);
        LIST.add(-7365502);
        NAMED.put((Object)"orange", -7172953);
        LIST.add(-7172953);
        NAMED.put((Object)"yellow", -6785296);
        LIST.add(-6785296);
        NAMED.put((Object)"green", -6921778);
        LIST.add(-6921778);
        NAMED.put((Object)"blue", -11044018);
        LIST.add(-11044018);
        NAMED.put((Object)"indigo", -10581934);
        LIST.add(-10581934);
        NAMED.put((Object)"violet", -10121354);
        LIST.add(-10121354);
        NAMED.put((Object)"purple", -10249601);
        LIST.add(-10249601);
        NAMED.put((Object)"brown", -7895448);
        LIST.add(-7895448);
        NAMED.put((Object)"pink", -8810812);
        LIST.add(-8810812);
        NAMED.put((Object)"magenta", -9789037);
        LIST.add(-9789037);
        NAMED.put((Object)"brick", -7827069);
        LIST.add(-7827069);
        NAMED.put((Object)"ember", -7433581);
        LIST.add(-7433581);
        NAMED.put((Object)"salmon", -7826275);
        LIST.add(-7826275);
        NAMED.put((Object)"chocolate", -7829947);
        LIST.add(-7829947);
        NAMED.put((Object)"tan", -7962181);
        LIST.add(-7962181);
        NAMED.put((Object)"bronze", -7371873);
        LIST.add(-7371873);
        NAMED.put((Object)"cinnamon", -7370101);
        LIST.add(-7370101);
        NAMED.put((Object)"apricot", -7109187);
        LIST.add(-7109187);
        NAMED.put((Object)"peach", -7633715);
        LIST.add(-7633715);
        NAMED.put((Object)"pear", -6982187);
        LIST.add(-6982187);
        NAMED.put((Object)"saffron", -6914857);
        LIST.add(-6914857);
        NAMED.put((Object)"butter", -7439125);
        LIST.add(-7439125);
        NAMED.put((Object)"chartreuse", -6983452);
        LIST.add(-6983452);
        NAMED.put((Object)"cactus", -7312505);
        LIST.add(-7312505);
        NAMED.put((Object)"lime", -7049284);
        LIST.add(-7049284);
        NAMED.put((Object)"olive", -7374467);
        LIST.add(-7374467);
        NAMED.put((Object)"fern", -7899538);
        LIST.add(-7899538);
        NAMED.put((Object)"moss", -7768774);
        LIST.add(-7768774);
        NAMED.put((Object)"celery", -7377958);
        LIST.add(-7377958);
        NAMED.put((Object)"sage", -8226860);
        LIST.add(-8226860);
        NAMED.put((Object)"jade", -7443806);
        LIST.add(-7443806);
        NAMED.put((Object)"cyan", -8753957);
        LIST.add(-8753957);
        NAMED.put((Object)"mint", -8228640);
        LIST.add(-8228640);
        NAMED.put((Object)"teal", -8621200);
        LIST.add(-8621200);
        NAMED.put((Object)"turquoise", -8556869);
        LIST.add(-8556869);
        NAMED.put((Object)"sky", -9014868);
        LIST.add(-9014868);
        NAMED.put((Object)"cobalt", -9864371);
        LIST.add(-9864371);
        NAMED.put((Object)"denim", -9144447);
        LIST.add(-9144447);
        NAMED.put((Object)"navy", -10060764);
        LIST.add(-10060764);
        NAMED.put((Object)"lavender", -9467732);
        LIST.add(-9467732);
        NAMED.put((Object)"plum", -9659532);
        LIST.add(-9659532);
        NAMED.put((Object)"mauve", -8877428);
        LIST.add(-8877428);
        NAMED.put((Object)"rose", -8479362);
        LIST.add(-8479362);
        NAMED.put((Object)"raspberry", -8154036);
        LIST.add(-8154036);
        NAMES = NAMED.order();
        NAMED.setDefaultValue(256);
        NAMES.sort(null);
        NAMES_BY_HUE = new ObjectList(NAMES);
        COLORS_BY_HUE = new IntList(NAMES_BY_HUE.size());
        NAMES_BY_LIGHTNESS = new ObjectList(NAMES);
        NAMES_BY_HUE.sort((o1, o2) -> {
            int c1 = NAMED.get(o1);
            int c2 = NAMED.get(o2);
            if (c1 >= 0) {
                return -10000;
            }
            if (c2 >= 0) {
                return 10000;
            }
            float s1 = DescriptiveColor.chroma(c1);
            float s2 = DescriptiveColor.chroma(c2);
            if (s1 <= 0.015625f && s2 > 0.015625f) {
                return -1000;
            }
            if (s1 > 0.015625f && s2 <= 0.015625f) {
                return 1000;
            }
            if (s1 <= 0.015625f && s2 <= 0.015625f) {
                return (c1 & 0xFF) - (c2 & 0xFF);
            }
            return ((int)Math.signum(DescriptiveColor.hue(c1) - DescriptiveColor.hue(c2)) << 8) + (c1 & 0xFF) - (c2 & 0xFF);
        });
        for (String name : NAMES_BY_HUE) {
            COLORS_BY_HUE.add(NAMED.get((Object)name));
        }
        NAMES_BY_LIGHTNESS.sort((o1, o2) -> (NAMED.get(o1) + Integer.MIN_VALUE & 0x800000FF) - (NAMED.get(o2) + Integer.MIN_VALUE & 0x800000FF));
        mixing = new IntList(4);
        namesByHue = new ObjectList(NAMES_BY_HUE);
        colorsByHue = new IntList(COLORS_BY_HUE);
        int trn = namesByHue.indexOf((Object)"transparent");
        namesByHue.removeAt(trn);
        colorsByHue.removeAt(trn);
        ALIASES.put((Object)"grey", -8421501);
        ALIASES.put((Object)"gold", -6914857);
        ALIASES.put((Object)"puce", -8877428);
        ALIASES.put((Object)"sand", -7962181);
        ALIASES.put((Object)"skin", -7633715);
        ALIASES.put((Object)"coral", -7826275);
        ALIASES.put((Object)"azure", -9014868);
        ALIASES.put((Object)"ocean", -8621200);
        ALIASES.put((Object)"sapphire", -9864371);
        NAMED.putAll(ALIASES);
        builder = new StringBuilder(80);
        sub = (matchResult, textBuffer) -> {
            builder.setLength(0);
            matchResult.getGroup(1, builder);
            textBuffer.append('[');
            textBuffer.append('#');
            textBuffer.append(DigitTools.hex(DescriptiveColor.describe(builder)));
            textBuffer.append(']');
        };
        rep = new Replacer(Pattern.compile((String)"(?<!\\[)\\[(\\|[^\\]]*)(?:\\]|$)"), sub);
    }
}

