/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.WhiskerRandom;
import com.github.yellowstonegames.core.DigitTools;
import org.checkerframework.checker.nullness.qual.NonNull;
import regexodus.Matcher;
import regexodus.Pattern;

public class Dice {
    private static final Matcher mat = Pattern.compile((String)"\\s*(?:({=op}[+/*-])?\\s*({=sn}-?\\d+)?\\s*(?:({=im}[:><])\\s*({=mn}\\d+))?\\s*(?:({=mm}[d:!])\\s*({=en}\\d+))?)\\s*").matcher();
    private EnhancedRandom rng;
    private transient IntList temp = new IntList(20);
    private transient Rule tempRule = new Rule();

    public Dice() {
        this.rng = new WhiskerRandom();
    }

    public Dice(EnhancedRandom rng) {
        this.rng = rng;
    }

    public Dice(long seed) {
        this.rng = new WhiskerRandom(seed);
    }

    public Dice(CharSequence seed) {
        this.rng = new WhiskerRandom(Hasher.dantalion.hash64(seed), Hasher.dantalion_.hash64(seed), Hasher.decarabia.hash64(seed), Hasher.decarabia_.hash64(seed));
    }

    public void setRandom(@NonNull EnhancedRandom rng) {
        this.rng = rng;
    }

    private int bestOf(int n, int dice, int sides) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.rollDice(1, sides));
        }
        return this.bestOf(rolls, this.temp);
    }

    private int bestOfExploding(int n, int dice, int sides) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.rollExplodingDice(1, sides));
        }
        return this.bestOf(rolls, this.temp);
    }

    private int worstOf(int n, int dice, int sides) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.rollDice(1, sides));
        }
        return this.worstOf(rolls, this.temp);
    }

    private int worstOfExploding(int n, int dice, int sides) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.rollExplodingDice(1, sides));
        }
        return this.worstOf(rolls, this.temp);
    }

    private int bestOf(int n, IntList pool) {
        int rolls = Math.min(n, pool.size());
        pool.sort();
        int ret = 0;
        int i = pool.size() - 1;
        for (int r = 0; r < rolls && i >= 0; --i, ++r) {
            ret += pool.get(i);
        }
        return ret;
    }

    private int worstOf(int n, IntList pool) {
        int rolls = Math.min(n, pool.size());
        pool.sort();
        int ret = 0;
        for (int r = 0; r < rolls; ++r) {
            ret += pool.get(r);
        }
        return ret;
    }

    public int bestOf(int n, int dice, String group) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.roll(group));
        }
        return this.bestOf(rolls, this.temp);
    }

    public int worstOf(int n, int dice, String group) {
        int rolls = Math.min(n, dice);
        this.temp.clear();
        for (int i = 0; i < dice; ++i) {
            this.temp.add(this.roll(group));
        }
        return this.worstOf(rolls, this.temp);
    }

    public int rollDice(int n, int sides) {
        int ret = 0;
        for (int i = 0; i < n; ++i) {
            ret += this.rng.nextInt(sides) + 1;
        }
        return ret;
    }

    public int rollExplodingDice(int n, int sides) {
        int ret = 0;
        if (sides <= 1) {
            return n;
        }
        int i = 0;
        while (i < n) {
            int curr = this.rng.nextInt(sides) + 1;
            ret += curr;
            if (curr == sides) continue;
            ++i;
        }
        return ret;
    }

    public IntList independentRolls(int n, int sides) {
        IntList ret = new IntList(n);
        for (int i = 0; i < n; ++i) {
            ret.add(this.rng.nextInt(sides) + 1);
        }
        return ret;
    }

    public int roll(String rollCode) {
        return this.runRollRule(this.tempRule.reset(rollCode));
    }

    public static Rule parseRollRule(String rollCode) {
        return new Rule(rollCode);
    }

    public static Rule parseRollRuleInto(Rule into, String rollCode) {
        into.rollCode = rollCode;
        mat.setTarget((CharSequence)rollCode);
        int op = mat.pattern().groupId("op");
        int sn = mat.pattern().groupId("sn");
        int im = mat.pattern().groupId("im");
        int mn = mat.pattern().groupId("mn");
        int mm = mat.pattern().groupId("mm");
        int en = mat.pattern().groupId("en");
        boolean starting = true;
        while (mat.find()) {
            int midN;
            if (starting && !mat.isCaptured(op)) {
                into.instructions.add(43);
                starting = false;
            }
            if (mat.isCaptured("op")) {
                into.instructions.add((int)mat.charAt(0, op));
                starting = false;
            }
            boolean startNum = mat.isCaptured(sn);
            char initialMode = mat.isCaptured(im) ? mat.charAt(0, im) : (char)'\u0000';
            boolean midNum = mat.isCaptured(mn);
            char mainMode = mat.isCaptured(mm) ? mat.charAt(0, mm) : (char)'\u0000';
            boolean endNum = mat.isCaptured(en);
            if (!startNum && !midNum && !endNum) break;
            int startN = startNum ? DigitTools.intFromDec(rollCode, mat.start(sn), mat.end(sn)) : 0;
            int n = midN = midNum ? DigitTools.intFromDec(rollCode, mat.start(mn), mat.end(mn)) : 0;
            if (!startNum && endNum && mainMode != ':') {
                midN = 1;
            }
            int endN = endNum ? DigitTools.intFromDec(rollCode, mat.start(en), mat.end(en)) : 0;
            into.instructions.add(startN);
            into.instructions.add((int)initialMode);
            into.instructions.add(midN);
            into.instructions.add((int)mainMode);
            into.instructions.add(endN);
        }
        return into;
    }

    public int runRollRule(Rule rule) {
        if (rule == null || rule.instructions.isEmpty()) {
            return 0;
        }
        IntList rollRule = rule.instructions;
        int previousTotal = 0;
        block5: for (int i = 0; i < rollRule.size(); i += 6) {
            int currentMode = rollRule.get(i);
            int currentResult = 0;
            int startN = rollRule.get(i + 1);
            int midMode = rollRule.get(i + 2);
            int midN = rollRule.get(i + 3);
            int mainMode = rollRule.get(i + 4);
            int endN = rollRule.get(i + 5);
            if (mainMode != 0) {
                if (midMode != 0) {
                    if (62 == midMode) {
                        if (100 == mainMode) {
                            currentResult = this.bestOf(startN, midN, endN);
                        } else if (33 == mainMode) {
                            currentResult = this.bestOfExploding(startN, midN, endN);
                        }
                    } else if (60 == midMode) {
                        if (100 == mainMode) {
                            currentResult = this.worstOf(startN, midN, endN);
                        } else if (33 == mainMode) {
                            currentResult = this.worstOfExploding(startN, midN, endN);
                        }
                    } else if (100 == mainMode) {
                        currentResult = startN + this.rng.nextSignedInt(this.rollDice(midN, endN) + 1 - startN);
                    } else if (33 == mainMode) {
                        currentResult = startN + this.rng.nextSignedInt(this.rollExplodingDice(midN, endN) + 1 - startN);
                    } else if (58 == mainMode) {
                        currentResult = startN + this.rng.nextSignedInt(midN + this.rng.nextSignedInt(endN + 1 - midN) + 1 - startN);
                    }
                } else if (100 == mainMode) {
                    currentResult = this.rollDice(startN, endN);
                } else if (33 == mainMode) {
                    currentResult = this.rollExplodingDice(startN, endN);
                } else if (58 == mainMode) {
                    currentResult = startN + this.rng.nextSignedInt(endN + 1 - startN);
                }
            } else {
                currentResult = 58 == midMode ? startN + this.rng.nextSignedInt(midN + 1 - startN) : startN;
            }
            switch (currentMode) {
                case 45: {
                    previousTotal -= currentResult;
                    continue block5;
                }
                case 42: {
                    previousTotal *= currentResult;
                    continue block5;
                }
                case 47: {
                    previousTotal /= currentResult;
                    continue block5;
                }
                default: {
                    previousTotal += currentResult;
                }
            }
        }
        return previousTotal;
    }

    public static class Rule {
        public @NonNull String rollCode;
        public @NonNull IntList instructions;

        protected Rule() {
            this.rollCode = "";
            this.instructions = new IntList(10);
        }

        public Rule(@NonNull String rollCode) {
            this.rollCode = rollCode;
            this.instructions = new IntList(10);
            Dice.parseRollRuleInto(this, rollCode);
        }

        public Rule reset() {
            this.rollCode = "";
            this.instructions.clear();
            return this;
        }

        public Rule reset(@NonNull String rollCode) {
            this.instructions.clear();
            Dice.parseRollRuleInto(this, rollCode);
            return this;
        }

        public String toString() {
            return this.rollCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            return this.instructions.equals((Object)rule.instructions);
        }

        public int hashCode() {
            return this.instructions.hashCode();
        }
    }
}

