/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.yellowstonegames.core.StringTools;

public final class DigitTools {
    private DigitTools() {
    }

    public static String hex(long number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(double number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(int number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(float number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(short number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(char number) {
        return Base.BASE16.unsigned(number);
    }

    public static String hex(byte number) {
        return Base.BASE16.unsigned(number);
    }

    public static StringBuilder appendHex(StringBuilder builder, long number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, double number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, int number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, float number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, short number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, char number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static StringBuilder appendHex(StringBuilder builder, byte number) {
        return Base.BASE16.appendUnsigned(builder, number);
    }

    public static String hex(long[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 4);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(double[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 4);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(int[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 3);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(float[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 3);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(short[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 2);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(char[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 2);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String hex(byte[] numbers) {
        int len;
        if (numbers == null || (len = numbers.length) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(numbers.length << 1);
        for (int i = 0; i < len; ++i) {
            DigitTools.appendHex(sb, numbers[i]);
        }
        return sb.toString();
    }

    public static String bin(long number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(int number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(double number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(float number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(short number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(char number) {
        return Base.BASE2.unsigned(number);
    }

    public static String bin(byte number) {
        return Base.BASE2.unsigned(number);
    }

    public static long longFromHex(CharSequence cs) {
        return DigitTools.longFromHex(cs, 0, cs.length());
    }

    public static long longFromHex(CharSequence cs, int start, int end) {
        return Base.BASE16.readLong(cs, start, end);
    }

    public static long longFromHex(char[] cs, int start, int end) {
        return Base.BASE16.readLong(cs, start, end);
    }

    public static int intFromHex(CharSequence cs) {
        return DigitTools.intFromHex(cs, 0, cs.length());
    }

    public static int intFromHex(CharSequence cs, int start, int end) {
        return Base.BASE16.readInt(cs, start, end);
    }

    public static int intFromHex(char[] cs, int start, int end) {
        return Base.BASE16.readInt(cs, start, end);
    }

    public static long longFromDec(CharSequence cs) {
        return DigitTools.longFromDec(cs, 0, cs.length());
    }

    public static long longFromDec(CharSequence cs, int start, int end) {
        return Base.BASE10.readLong(cs, start, end);
    }

    public static int intFromDec(CharSequence cs) {
        return DigitTools.intFromDec(cs, 0, cs.length());
    }

    public static int intFromDec(CharSequence cs, int start, int end) {
        return Base.BASE10.readInt(cs, start, end);
    }

    public static long longFromBin(CharSequence cs) {
        return DigitTools.longFromBin(cs, 0, cs.length());
    }

    public static long longFromBin(CharSequence cs, int start, int end) {
        return Base.BASE2.readLong(cs, start, end);
    }

    public static int intFromBin(CharSequence cs) {
        return DigitTools.intFromBin(cs, 0, cs.length());
    }

    public static int intFromBin(CharSequence cs, int start, int end) {
        return Base.BASE2.readInt(cs, start, end);
    }

    public static String hexHash(boolean ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(byte ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(short ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(char ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(int ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(long ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(float ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static String hexHash(double ... array) {
        return DigitTools.hex(Hasher.astaroth.hash64(array));
    }

    public static long[] splitLongFromDec(String source, String delimiter) {
        int amount;
        if (source == null || source.length() == 0) {
            return new long[0];
        }
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = " ";
        }
        if ((amount = StringTools.count(source, delimiter)) <= 0) {
            return new long[]{DigitTools.longFromDec(source)};
        }
        long[] splat = new long[amount + 1];
        int dl = delimiter.length();
        int idx = -dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = DigitTools.longFromDec(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? DigitTools.longFromDec(source, idx + dl, source.length()) : DigitTools.longFromDec(source, idx + dl, idx2);
        return splat;
    }

    public static int[] splitIntFromDec(String source, String delimiter) {
        int amount;
        if (source == null || source.length() == 0) {
            return new int[0];
        }
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = " ";
        }
        if ((amount = StringTools.count(source, delimiter)) <= 0) {
            return new int[]{DigitTools.intFromDec(source)};
        }
        int[] splat = new int[amount + 1];
        int dl = delimiter.length();
        int idx = -dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = DigitTools.intFromDec(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? DigitTools.intFromDec(source, idx + dl, source.length()) : DigitTools.intFromDec(source, idx + dl, idx2);
        return splat;
    }

    public static String joinFloatsBits(CharSequence delimiter, float ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(BitConversion.floatToReversedIntBits((float)elements[0]));
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(BitConversion.floatToReversedIntBits((float)elements[i]));
        }
        return sb.toString();
    }

    public static StringBuilder appendJoinedFloatsBits(StringBuilder sb, CharSequence delimiter, float ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(BitConversion.floatToReversedIntBits((float)elements[0]));
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(BitConversion.floatToReversedIntBits((float)elements[i]));
        }
        return sb;
    }

    public static float[] splitFloatFromBits(String source, String delimiter) {
        int amount;
        if (source == null || source.length() == 0) {
            return new float[0];
        }
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = " ";
        }
        if ((amount = StringTools.count(source, delimiter)) <= 0) {
            return new float[]{BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec(source))};
        }
        float[] splat = new float[amount + 1];
        int dl = delimiter.length();
        int idx = -dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec(source, n, idx));
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec(source, idx + dl, source.length())) : BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec(source, idx + dl, idx2));
        return splat;
    }
}

