/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.TricycleRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GapShuffler<T>
implements Iterator<T>,
Iterable<T> {
    public @NonNull EnhancedRandom random;
    protected @NonNull ObjectList<T> elements;
    protected int index;

    protected GapShuffler() {
        this.random = new TricycleRandom();
        this.elements = new ObjectList();
        this.index = 0;
    }

    public GapShuffler(T single) {
        this.random = new TricycleRandom();
        this.elements = new ObjectList(1);
        this.elements.add(single);
        this.index = 0;
    }

    public GapShuffler(Collection<T> elements) {
        this(elements, (EnhancedRandom)new TricycleRandom());
    }

    public GapShuffler(Collection<T> elements, String seed) {
        this(elements, (EnhancedRandom)new TricycleRandom(Hasher.gaap.hash64((CharSequence)seed), Hasher.furfur.hash64((CharSequence)seed), Hasher.raum.hash64((CharSequence)seed)));
    }

    public GapShuffler(Collection<T> items, EnhancedRandom random) {
        this(items, random, false);
    }

    public GapShuffler(Collection<T> items, EnhancedRandom random, boolean shareRNG) {
        this.random = shareRNG ? random : random.copy();
        this.elements = new ObjectList(items);
        this.elements.shuffle((Random)this.random);
        this.index = 0;
    }

    public GapShuffler(Collection<T> items, EnhancedRandom random, int index, boolean shareRNG) {
        this.random = shareRNG ? random : random.copy();
        this.elements = new ObjectList(items);
        this.elements.shuffle((Random)this.random);
        this.index = (index & Integer.MAX_VALUE) % this.elements.size();
    }

    public GapShuffler(Collection<T> items, EnhancedRandom random, int index, boolean shareRNG, boolean initialShuffle) {
        this.random = shareRNG ? random : random.copy();
        this.elements = new ObjectList(items);
        if (initialShuffle) {
            this.elements.shuffle((Random)this.random);
        }
        this.index = (index & Integer.MAX_VALUE) % this.elements.size();
    }

    public GapShuffler(GapShuffler<T> other) {
        this((Collection<T>)other.elements, other.random, other.index, false, false);
    }

    public GapShuffler(T[] elements) {
        this(elements, (EnhancedRandom)new TricycleRandom());
    }

    public GapShuffler(T[] elements, CharSequence seed) {
        this(elements, (EnhancedRandom)new TricycleRandom(Hasher.gaap.hash64(seed), Hasher.furfur.hash64(seed), Hasher.raum.hash64(seed)));
    }

    public GapShuffler(T[] items, EnhancedRandom random) {
        this.random = random.copy();
        this.elements = ObjectList.with((Object[])items);
        this.elements.shuffle((Random)this.random);
        this.index = 0;
    }

    public GapShuffler(T[] items, EnhancedRandom random, boolean shareRNG) {
        this.random = shareRNG ? random : random.copy();
        this.elements = ObjectList.with((Object[])items);
        this.elements.shuffle((Random)this.random);
        this.index = 0;
    }

    @Override
    public T next() {
        int size = this.elements.size();
        if (size == 1) {
            return (T)this.elements.get(0);
        }
        if (this.index >= size) {
            int n;
            for (int i = n = size - 1; i > 1; --i) {
                this.elements.swap(this.random.nextInt(i), i - 1);
            }
            this.elements.swap(1 + this.random.nextInt(n), n);
            this.index = 0;
        }
        return (T)this.elements.get(this.index++);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public EnhancedRandom getRNG() {
        return this.random;
    }

    public void setRNG(EnhancedRandom random) {
        this.setRNG(random, false);
    }

    public void setRNG(EnhancedRandom random, boolean shareRNG) {
        this.random = shareRNG ? random : random.copy();
        this.elements.shuffle((Random)this.random);
    }

    public void fillInto(Collection<T> coll) {
        coll.addAll((Collection<T>)this.elements);
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "GapShuffler{elements=" + this.elements + ", random=" + this.random + ", index=" + this.index + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GapShuffler that = (GapShuffler)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.random.equals(that.random)) {
            return false;
        }
        return this.elements.equals(that.elements);
    }
}

