/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.digital.MathTools;
import com.github.yellowstonegames.core.annotations.Beta;
import org.checkerframework.checker.nullness.qual.NonNull;

@Beta
public class IntShuffler {
    public final int bound;
    protected int index;
    protected int pow4;
    protected int halfBits;
    protected int leftMask;
    protected int rightMask;
    protected long key0;
    protected long key1;
    protected long key2;
    protected long key3;

    public IntShuffler() {
        this(10);
    }

    public IntShuffler(int bound) {
        this(bound, (long)((Math.random() - 0.5) * 4.503599627370496E15) ^ (long)((Math.random() - 0.5) * 1.8446744073709552E19));
    }

    public IntShuffler(int bound, long seed) {
        this.bound = bound;
        this.restart(seed);
        this.pow4 = MathTools.nextPowerOfTwo((int)bound);
        this.pow4 = ((this.pow4 | this.pow4 << 1) & 0x55555554) - 1;
        this.halfBits = Integer.bitCount(this.pow4) >>> 1;
        this.rightMask = this.pow4 >>> this.halfBits;
        this.leftMask = this.pow4 ^ this.rightMask;
    }

    public IntShuffler(IntShuffler other) {
        this.bound = other.bound;
        this.index = other.index;
        this.key0 = other.key0;
        this.key1 = other.key1;
        this.key2 = other.key2;
        this.key3 = other.key3;
        this.pow4 = other.pow4;
        this.halfBits = other.halfBits;
        this.rightMask = other.rightMask;
        this.leftMask = other.leftMask;
    }

    public int next() {
        while (this.index <= this.pow4) {
            int shuffleIndex;
            if ((shuffleIndex = this.encode(this.index++)) >= this.bound) continue;
            return shuffleIndex;
        }
        return -1;
    }

    public int previous() {
        while (this.index > 0) {
            int shuffleIndex;
            if ((shuffleIndex = this.encode(--this.index)) >= this.bound) continue;
            return shuffleIndex;
        }
        return -1;
    }

    public void restart() {
        this.index = 0;
    }

    public void restart(long seed) {
        this.index = 0;
        this.key0 = Hasher.randomize2((long)(seed + 6384245875588680899L));
        this.key1 = Hasher.randomize2((long)(seed ^ 0x1D8E4E27C47D124FL));
        this.key2 = Hasher.randomize2((long)(seed - -1800455987208640293L));
        this.key3 = Hasher.randomize2((long)(seed ^ 0x8EBC6AF09C88C6E3L));
    }

    public long fuse(long a, long b) {
        return (a *= b) ^ a >>> 32;
    }

    public int round(long data, long seed) {
        return (int)this.fuse(data + -1800455987208640293L, seed - -8161530843051276573L);
    }

    public int encode(int index) {
        int left = (index & this.leftMask) >>> this.halfBits;
        int right = index & this.rightMask;
        int newRight = left + this.round(right, this.key0) & this.rightMask;
        left = right;
        right = newRight;
        newRight = left + this.round(right, this.key1) & this.rightMask;
        left = right;
        right = newRight;
        newRight = left + this.round(right, this.key2) & this.rightMask;
        left = right;
        right = newRight;
        newRight = left + this.round(right, this.key3) & this.rightMask;
        return right << this.halfBits | newRight;
    }

    public IntShuffler copy() {
        return new IntShuffler(this);
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder("`");
        Base.BASE36.appendSigned(sb, this.bound);
        sb.append('~');
        Base.BASE36.appendSigned(sb, this.index);
        sb.append('~');
        Base.BASE36.appendSigned(sb, this.key0);
        sb.append('~');
        Base.BASE36.appendSigned(sb, this.key1);
        sb.append('~');
        Base.BASE36.appendSigned(sb, this.key2);
        sb.append('~');
        Base.BASE36.appendSigned(sb, this.key3);
        return sb.append('`').toString();
    }

    public static IntShuffler deserializeFromString(@NonNull String data) {
        if (data.length() < 13) {
            return null;
        }
        int idx = 0;
        int n = idx + 1;
        idx = data.indexOf(126, idx + 1);
        int bound = Base.BASE36.readInt((CharSequence)data, n, idx);
        int n2 = idx + 1;
        idx = data.indexOf(126, idx + 1);
        int index = Base.BASE36.readInt((CharSequence)data, n2, idx);
        int n3 = idx + 1;
        idx = data.indexOf(126, idx + 1);
        long key0 = Base.BASE36.readLong((CharSequence)data, n3, idx);
        int n4 = idx + 1;
        idx = data.indexOf(126, idx + 1);
        long key1 = Base.BASE36.readLong((CharSequence)data, n4, idx);
        int n5 = idx + 1;
        idx = data.indexOf(126, idx + 1);
        long key2 = Base.BASE36.readLong((CharSequence)data, n5, idx);
        long key3 = Base.BASE36.readLong((CharSequence)data, idx + 1, data.indexOf(96, idx + 1));
        IntShuffler is = new IntShuffler(bound, 0L);
        is.index = index;
        is.key0 = key0;
        is.key1 = key1;
        is.key2 = key2;
        is.key3 = key3;
        return is;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntShuffler that = (IntShuffler)o;
        if (this.bound != that.bound) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.key0 != that.key0) {
            return false;
        }
        if (this.key1 != that.key1) {
            return false;
        }
        if (this.key2 != that.key2) {
            return false;
        }
        return this.key3 == that.key3;
    }

    public int hashCode() {
        int result = this.bound;
        result = 31 * result + this.index;
        result = 31 * result + (int)(this.key0 ^ this.key0 >>> 32);
        result = 31 * result + (int)(this.key1 ^ this.key1 >>> 32);
        result = 31 * result + (int)(this.key2 ^ this.key2 >>> 32);
        result = 31 * result + (int)(this.key3 ^ this.key3 >>> 32);
        return result;
    }
}

