/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ObjectObjectOrderedMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Interpolations {
    private static final ObjectObjectOrderedMap<String, Interpolator> REGISTRY = new ObjectObjectOrderedMap(128);
    public static final InterpolationFunction linearFunction = a -> a;
    public static final Interpolator linear = new Interpolator("linear", linearFunction);
    public static final Interpolator smooth = new Interpolator("smooth", a -> a * a * (3.0f - 2.0f * a));
    public static final Interpolator smooth2 = new Interpolator("smooth2", a -> {
        a *= a * (3.0f - 2.0f * a);
        return a * a * (3.0f - 2.0f * a);
    });
    public static final Interpolator smoother = new Interpolator("smoother", a -> a * a * a * (a * (a * 6.0f - 15.0f) + 10.0f));
    public static final Interpolator fade = new Interpolator("fade", a -> a * a * a * (a * (a * 6.0f - 15.0f) + 10.0f));
    public static final Interpolator pow2 = new Interpolator("pow2", Interpolations.powFunction(2.0f));
    public static final Interpolator pow3 = new Interpolator("pow3", Interpolations.powFunction(3.0f));
    public static final Interpolator pow4 = new Interpolator("pow4", Interpolations.powFunction(4.0f));
    public static final Interpolator pow5 = new Interpolator("pow5", Interpolations.powFunction(5.0f));
    public static final Interpolator pow0_75 = new Interpolator("pow0_75", Interpolations.powFunction(0.75f));
    public static final Interpolator pow0_5 = new Interpolator("pow0_5", a -> {
        if (a <= 0.5f) {
            return (float)Math.sqrt(a + a) * 0.5f;
        }
        return (float)Math.sqrt(2.0f - a - a) * -0.5f + 1.0f;
    });
    public static final Interpolator pow0_25 = new Interpolator("pow0_25", Interpolations.powFunction(0.25f));
    public static final Interpolator pow2In = new Interpolator("pow2In", Interpolations.powInFunction(2.0f));
    public static final Interpolator slowFast = new Interpolator("slowFast", Interpolations.powInFunction(2.0f));
    public static final Interpolator pow3In = new Interpolator("pow3In", Interpolations.powInFunction(3.0f));
    public static final Interpolator pow4In = new Interpolator("pow4In", Interpolations.powInFunction(4.0f));
    public static final Interpolator pow5In = new Interpolator("pow5In", Interpolations.powInFunction(5.0f));
    public static final Interpolator pow0_75In = new Interpolator("pow0_75In", Interpolations.powInFunction(0.75f));
    public static final Interpolator pow0_5In = new Interpolator("pow0_5In", a -> (float)Math.sqrt(a));
    public static final Interpolator pow0_25In = new Interpolator("pow0_25In", Interpolations.powInFunction(0.25f));
    public static final Interpolator pow2InInverse = new Interpolator("pow2InInverse", a -> (float)Math.sqrt(a));
    public static final Interpolator pow3InInverse = new Interpolator("pow3InInverse", MathTools::cbrt);
    public static final Interpolator pow2Out = new Interpolator("pow2Out", Interpolations.powOutFunction(2.0f));
    public static final Interpolator fastSlow = new Interpolator("fastSlow", Interpolations.powOutFunction(2.0f));
    public static final Interpolator pow3Out = new Interpolator("pow3Out", Interpolations.powOutFunction(3.0f));
    public static final Interpolator pow4Out = new Interpolator("pow4Out", Interpolations.powOutFunction(4.0f));
    public static final Interpolator pow5Out = new Interpolator("pow5Out", Interpolations.powOutFunction(5.0f));
    public static final Interpolator pow0_75Out = new Interpolator("pow0_75Out", Interpolations.powOutFunction(0.75f));
    public static final Interpolator pow0_5Out = new Interpolator("pow0_5Out", a -> 1.0f - (float)Math.sqrt(1.0f - a));
    public static final Interpolator pow0_25Out = new Interpolator("pow0_25Out", Interpolations.powOutFunction(0.25f));
    public static final Interpolator pow2OutInverse = new Interpolator("pow2OutInverse", a -> 1.0f - (float)Math.sqrt(1.0f - a));
    public static final Interpolator pow3OutInverse = new Interpolator("pow3OutInverse", a -> 1.0f - MathTools.cbrt((float)(1.0f - a)));
    public static final Interpolator exp5 = new Interpolator("exp5", Interpolations.expFunction(2.0f, 5.0f));
    public static final Interpolator exp10 = new Interpolator("exp10", Interpolations.expFunction(2.0f, 10.0f));
    public static final Interpolator exp5In = new Interpolator("exp5In", Interpolations.expInFunction(2.0f, 5.0f));
    public static final Interpolator exp10In = new Interpolator("exp10In", Interpolations.expInFunction(2.0f, 10.0f));
    public static final Interpolator exp5Out = new Interpolator("exp5Out", Interpolations.expOutFunction(2.0f, 5.0f));
    public static final Interpolator exp10Out = new Interpolator("exp10Out", Interpolations.expOutFunction(2.0f, 10.0f));
    public static final Interpolator biasGainCenteredA = new Interpolator("biasGainCenteredA", Interpolations.biasGainFunction(0.75f, 0.5f));
    public static final Interpolator biasGainCenteredB = new Interpolator("biasGainCenteredB", Interpolations.biasGainFunction(0.5f, 0.5f));
    public static final Interpolator biasGainCenteredC = new Interpolator("biasGainCenteredC", Interpolations.biasGainFunction(0.25f, 0.5f));
    public static final Interpolator biasGainExtremeA = new Interpolator("biasGainExtremeA", Interpolations.biasGainFunction(2.0f, 0.5f));
    public static final Interpolator biasGainExtremeB = new Interpolator("biasGainExtremeB", Interpolations.biasGainFunction(3.0f, 0.5f));
    public static final Interpolator biasGainExtremeC = new Interpolator("biasGainExtremeC", Interpolations.biasGainFunction(4.0f, 0.5f));
    public static final Interpolator biasGainMostlyLow = new Interpolator("biasGainMostlyLow", Interpolations.biasGainFunction(3.0f, 0.9f));
    public static final Interpolator biasGainMostlyHigh = new Interpolator("biasGainMostlyHigh", Interpolations.biasGainFunction(3.0f, 0.1f));
    public static final Interpolator sine = new Interpolator("sine", a -> (1.0f - TrigTools.cosTurns((float)(0.5f * a))) * 0.5f);
    public static final Interpolator sineIn = new Interpolator("sineIn", a -> 1.0f - TrigTools.cosTurns((float)(0.25f * a)));
    public static final Interpolator sineOut = new Interpolator("sineOut", a -> TrigTools.sinTurns((float)(0.25f * a)));
    public static final Interpolator circle = new Interpolator("circle", a -> a <= 0.5f ? (1.0f - (float)Math.sqrt(1.0f - a * a * 4.0f)) * 0.5f : ((float)Math.sqrt(1.0f - 4.0f * (a * (a - 2.0f) + 1.0f)) + 1.0f) * 0.5f);
    public static final Interpolator circleIn = new Interpolator("circleIn", a -> 1.0f - (float)Math.sqrt(1.0f - a * a));
    public static final Interpolator circleOut = new Interpolator("circleOut", a -> (float)Math.sqrt(a * (2.0f - a)));
    public static final Interpolator bounce2 = new Interpolator("bounce2", Interpolations.bounceFunction(1.2f, 1.0f, 0.4f, 0.33f));
    public static final Interpolator bounce3 = new Interpolator("bounce3", Interpolations.bounceFunction(0.8f, 1.0f, 0.4f, 0.33f, 0.2f, 0.1f));
    public static final Interpolator bounce4 = new Interpolator("bounce4", Interpolations.bounceFunction(0.65f, 1.0f, 0.325f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounce = new Interpolator("bounce", Interpolations.bounceFunction(0.68f, 1.0f, 0.34f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounce5 = new Interpolator("bounce5", Interpolations.bounceFunction(0.61f, 1.0f, 0.31f, 0.45f, 0.21f, 0.3f, 0.11f, 0.15f, 0.06f, 0.06f));
    public static final Interpolator bounce2Out = new Interpolator("bounce2Out", Interpolations.bounceOutFunction(1.2f, 1.0f, 0.4f, 0.33f));
    public static final Interpolator bounce3Out = new Interpolator("bounce3Out", Interpolations.bounceOutFunction(0.8f, 1.0f, 0.4f, 0.33f, 0.2f, 0.1f));
    public static final Interpolator bounce4Out = new Interpolator("bounce4Out", Interpolations.bounceOutFunction(0.65f, 1.0f, 0.325f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounceOut = new Interpolator("bounceOut", Interpolations.bounceOutFunction(0.68f, 1.0f, 0.34f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounce5Out = new Interpolator("bounce5Out", Interpolations.bounceOutFunction(0.61f, 1.0f, 0.31f, 0.45f, 0.21f, 0.3f, 0.11f, 0.15f, 0.06f, 0.06f));
    public static final Interpolator bounce2In = new Interpolator("bounce2In", Interpolations.bounceInFunction(1.2f, 1.0f, 0.4f, 0.33f));
    public static final Interpolator bounce3In = new Interpolator("bounce3In", Interpolations.bounceInFunction(0.8f, 1.0f, 0.4f, 0.33f, 0.2f, 0.1f));
    public static final Interpolator bounce4In = new Interpolator("bounce4In", Interpolations.bounceInFunction(0.65f, 1.0f, 0.325f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounceIn = new Interpolator("bounceIn", Interpolations.bounceInFunction(0.68f, 1.0f, 0.34f, 0.26f, 0.2f, 0.11f, 0.15f, 0.03f));
    public static final Interpolator bounce5In = new Interpolator("bounce5In", Interpolations.bounceInFunction(0.61f, 1.0f, 0.31f, 0.45f, 0.21f, 0.3f, 0.11f, 0.15f, 0.06f, 0.06f));
    public static final Interpolator swing2 = new Interpolator("swing2", Interpolations.swingFunction(2.0f));
    public static final Interpolator swing = new Interpolator("swing", Interpolations.swingFunction(1.5f));
    public static final Interpolator swing3 = new Interpolator("swing3", Interpolations.swingFunction(3.0f));
    public static final Interpolator swing0_75 = new Interpolator("swing0_75", Interpolations.swingFunction(0.75f));
    public static final Interpolator swing0_5 = new Interpolator("swing0_5", Interpolations.swingFunction(0.5f));
    public static final Interpolator swing2Out = new Interpolator("swing2Out", Interpolations.swingOutFunction(2.0f));
    public static final Interpolator swingOut = new Interpolator("swingOut", Interpolations.swingOutFunction(2.0f));
    public static final Interpolator swing3Out = new Interpolator("swing3Out", Interpolations.swingOutFunction(3.0f));
    public static final Interpolator swing0_75Out = new Interpolator("swing0_75Out", Interpolations.swingOutFunction(0.75f));
    public static final Interpolator swing0_5Out = new Interpolator("swing0_5Out", Interpolations.swingOutFunction(0.5f));
    public static final Interpolator swing2In = new Interpolator("swing2In", Interpolations.swingInFunction(2.0f));
    public static final Interpolator swingIn = new Interpolator("swingIn", Interpolations.swingInFunction(2.0f));
    public static final Interpolator swing3In = new Interpolator("swing3In", Interpolations.swingInFunction(3.0f));
    public static final Interpolator swing0_75In = new Interpolator("swing0_75In", Interpolations.swingInFunction(0.75f));
    public static final Interpolator swing0_5In = new Interpolator("swing0_5In", Interpolations.swingInFunction(0.5f));
    public static final Interpolator elastic = new Interpolator("elastic", Interpolations.elasticFunction(2.0f, 10.0f, 7, 1.0f));
    public static final Interpolator elasticOut = new Interpolator("elasticOut", Interpolations.elasticOutFunction(2.0f, 10.0f, 7, 1.0f));
    public static final Interpolator elasticIn = new Interpolator("elasticIn", Interpolations.elasticInFunction(2.0f, 10.0f, 6, 1.0f));

    public static @Nullable Interpolator get(String tag) {
        return (Interpolator)REGISTRY.get((Object)tag);
    }

    public static String[] getTagArray() {
        return (String[])REGISTRY.keySet().toArray((Object[])new String[0]);
    }

    public static Interpolator[] getInterpolatorArray() {
        return (Interpolator[])REGISTRY.values().toArray((Object[])new Interpolator[0]);
    }

    public static ObjectList<String> getTagList() {
        return REGISTRY.keySet().toList();
    }

    public static ObjectList<Interpolator> getInterpolatorList() {
        return REGISTRY.values().toList();
    }

    private Interpolations() {
    }

    public static InterpolationFunction powFunction(float power) {
        return a -> {
            if (a <= 0.5f) {
                return (float)Math.pow(a + a, power) * 0.5f;
            }
            return (float)Math.pow(2.0f - a - a, power) * -0.5f + 1.0f;
        };
    }

    public static InterpolationFunction powInFunction(float power) {
        return a -> (float)Math.pow(a, power);
    }

    public static InterpolationFunction powOutFunction(float power) {
        return a -> 1.0f - (float)Math.pow(1.0f - a, power);
    }

    public static InterpolationFunction expFunction(float value, float power) {
        float min = (float)Math.pow(value, -power);
        float scale = 1.0f / (1.0f - min);
        return a -> {
            if (a <= 0.5f) {
                return ((float)Math.pow(value, power * (a * 2.0f - 1.0f)) - min) * scale * 0.5f;
            }
            return (2.0f - ((float)Math.pow(value, -power * (a * 2.0f - 1.0f)) - min) * scale) * 0.5f;
        };
    }

    public static InterpolationFunction expInFunction(float value, float power) {
        float min = (float)Math.pow(value, -power);
        float scale = 1.0f / (1.0f - min);
        return a -> ((float)Math.pow(value, power * (a - 1.0f)) - min) * scale;
    }

    public static InterpolationFunction expOutFunction(float value, float power) {
        float min = (float)Math.pow(value, -power);
        float scale = 1.0f / (1.0f - min);
        return a -> 1.0f - ((float)Math.pow(value, -power * a) - min) * scale;
    }

    public static InterpolationFunction biasGainFunction(float shape, float turning) {
        return a -> MathTools.barronSpline((float)a, (float)shape, (float)turning);
    }

    public static InterpolationFunction bounceFunction(float ... pairs) {
        InterpolationFunction bOut = Interpolations.bounceOutFunction(pairs);
        InterpolationFunction iOut = o -> {
            float test = o + pairs[0] * 0.5f;
            if (test < pairs[0]) {
                return test / (pairs[0] * 0.5f) - 1.0f;
            }
            return bOut.apply(o);
        };
        return a -> {
            if (a <= 0.5f) {
                return (1.0f - iOut.apply(1.0f - a - a)) * 0.5f;
            }
            return iOut.apply(a + a - 1.0f) * 0.5f + 0.5f;
        };
    }

    public static InterpolationFunction bounceOutFunction(float ... pairs) {
        return a -> {
            a += pairs[0] * 0.5f;
            float width = 0.0f;
            float height = 0.0f;
            int n = (pairs.length & 0xFFFFFFFE) - 1;
            for (int i = 0; i < n; i += 2) {
                width = pairs[i];
                if (a <= width) {
                    height = pairs[i + 1];
                    break;
                }
                a -= width;
            }
            float z = 4.0f / (width * width) * height * a;
            return 1.0f - (z * width - z * a);
        };
    }

    public static InterpolationFunction bounceInFunction(float ... pairs) {
        InterpolationFunction bOut = Interpolations.bounceOutFunction(pairs);
        return a -> 1.0f - bOut.apply(1.0f - a);
    }

    public static InterpolationFunction swingFunction(float scale) {
        float sc = scale + scale;
        return a -> {
            if (a <= 0.5f) {
                a += a;
                return ((sc + 1.0f) * a - sc) * a * a * 0.5f;
            }
            a += a - 2.0f;
            return ((sc + 1.0f) * a + sc) * a * a * 0.5f + 1.0f;
        };
    }

    public static InterpolationFunction swingOutFunction(float scale) {
        return a -> ((scale + 1.0f) * (a -= 1.0f) + scale) * a * a + 1.0f;
    }

    public static InterpolationFunction swingInFunction(float scale) {
        return a -> a * a * ((scale + 1.0f) * a - scale);
    }

    public static InterpolationFunction elasticFunction(float value, float power, int bounces, float scale) {
        float bounce = (float)bounces * (0.5f - (float)(bounces & 1));
        return a -> {
            float f;
            if (a <= 0.5f) {
                a += a;
                f = (float)Math.pow(value, power * (a - 1.0f)) * TrigTools.sinTurns((float)(a * bounce)) * scale * 0.5f;
            } else {
                a = 2.0f - a - a;
                f = 1.0f - (float)Math.pow(value, power * (a - 1.0f)) * TrigTools.sinTurns((float)(a * bounce)) * scale * 0.5f;
            }
            return f;
        };
    }

    public static InterpolationFunction elasticOutFunction(float value, float power, int bounces, float scale) {
        float bounce = (float)bounces * (0.5f - (float)(bounces & 1));
        return a -> 1.0f - (float)Math.pow(value, power * -a) * TrigTools.sinTurns((float)(bounce - a * bounce)) * scale;
    }

    public static InterpolationFunction elasticInFunction(float value, float power, int bounces, float scale) {
        float bounce = (float)bounces * (0.5f - (float)(bounces & 1));
        return a -> (float)Math.pow(value, power * (a - 1.0f)) * TrigTools.sinTurns((float)(a * bounce)) * scale;
    }

    public static class Interpolator
    implements InterpolationFunction {
        public final @NonNull String tag;
        public final @NonNull InterpolationFunction fn;

        public Interpolator() {
            this("linear", linearFunction);
        }

        public Interpolator(@NonNull String tag, @NonNull InterpolationFunction fn) {
            this.tag = tag;
            this.fn = fn;
            REGISTRY.put((Object)tag, (Object)this);
        }

        @Override
        public float apply(float alpha) {
            if (alpha < 9.536743E-7f) {
                return 0.0f;
            }
            if (alpha >= 1.0f) {
                return 1.0f;
            }
            return this.fn.apply(alpha);
        }

        public @NonNull String getTag() {
            return this.tag;
        }

        public @NonNull InterpolationFunction getFn() {
            return this.fn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interpolator that = (Interpolator)o;
            return this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public String toString() {
            return this.tag;
        }
    }

    @FunctionalInterface
    public static interface InterpolationFunction {
        public float apply(float var1);

        default public float apply(float start, float end, float alpha) {
            return start + this.apply(alpha) * (end - start);
        }
    }
}

