/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.ds.ByteList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class LZByteEncoding {
    private LZByteEncoding() {
    }

    public static byte[] compressToBytes(String uncompressedStr) {
        int i;
        int value;
        if (uncompressedStr == null) {
            return null;
        }
        if (uncompressedStr.isEmpty()) {
            return new byte[0];
        }
        int bitsPerChar = 8;
        HashMap<String, Integer> context_dictionary = new HashMap<String, Integer>(256, 0.5f);
        HashSet<String> context_dictionaryToCreate = new HashSet<String>(256, 0.5f);
        String context_w = "";
        int context_enlargeIn = 2;
        int context_dictSize = 3;
        int context_numBits = 2;
        ByteList context_data = new ByteList(uncompressedStr.length() >>> 1);
        byte context_data_val = 0;
        int context_data_position = 0;
        char[] uncompressed = uncompressedStr.toCharArray();
        for (int ii = 0; ii < uncompressed.length; ++ii) {
            String context_wc;
            String context_c = String.valueOf(uncompressed[ii]);
            if (!context_dictionary.containsKey(context_c)) {
                context_dictionary.put(context_c, context_dictSize++);
                context_dictionaryToCreate.add(context_c);
            }
            if (context_dictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (context_dictionaryToCreate.contains(context_w)) {
                char c = context_w.charAt(0);
                value = c;
                if (c < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    for (i = 0; i < 8; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                }
                if (--context_enlargeIn == 0) {
                    context_enlargeIn = 1 << context_numBits++;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = (byte)(context_data_val << 1 | value & 1);
                    if (context_data_position == 7) {
                        context_data_position = 0;
                        context_data.add(context_data_val);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>>= 1;
                }
            }
            if (--context_enlargeIn == 0) {
                context_enlargeIn = 1 << context_numBits++;
            }
            context_dictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = (byte)(context_data_val << 1 | value & 1);
                        if (context_data_position == 7) {
                            context_data_position = 0;
                            context_data.add(context_data_val);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>>= 1;
                    }
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = (byte)(context_data_val << 1 | value & 1);
                    if (context_data_position == 7) {
                        context_data_position = 0;
                        context_data.add(context_data_val);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>>= 1;
                }
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = (byte)(context_data_val << 1 | value & 1);
            if (context_data_position == 7) {
                context_data_position = 0;
                context_data.add(context_data_val);
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>>= 1;
        }
        while (true) {
            context_data_val = (byte)(context_data_val << 1);
            if (context_data_position == 7) break;
            ++context_data_position;
        }
        context_data.add(context_data_val);
        return context_data.shrink();
    }

    public static String decompressFromBytes(byte[] compressedBytes) {
        String c;
        int resb;
        if (compressedBytes == null) {
            return null;
        }
        int length = compressedBytes.length;
        if (length == 0) {
            return "";
        }
        int resetValue = 128;
        ArrayList<String> dictionary = new ArrayList<String>(256);
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = 128;
        int index = 1;
        StringBuilder res = new StringBuilder(length);
        byte val = compressedBytes[0];
        for (char i = '\u0000'; i < '\u0003'; i = (char)(i + '\u0001')) {
            dictionary.add(String.valueOf(i));
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>>= 1) == 0) {
                position = 128;
                val = compressedBytes[index++];
            }
            bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
        }
        switch (bits) {
            case '\u0000': {
                bits = '\u0000';
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>>= 1) == 0) {
                        position = 128;
                        val = compressedBytes[index++];
                    }
                    bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return "";
            }
        }
        dictionary.add(c);
        String w = c;
        res.append(w);
        while (index <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>>= 1) == 0) {
                    position = 128;
                    val = compressedBytes[index++];
                }
                cc |= (resb != 0 ? 1 : 0) << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>>= 1) == 0) {
                            position = 128;
                            val = compressedBytes[index++];
                        }
                        bits = (char)(bits | (resb != 0 ? 1 : 0) << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    return res.toString();
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return "";
            }
            res.append(entry);
            dictionary.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return "";
    }

    public static String join(byte ... elements) {
        if (elements == null) {
            return null;
        }
        return Base.BASE10.join(",", elements);
    }

    public static byte[] readJoined(String source) {
        if (source == null) {
            return null;
        }
        return Base.BASE10.byteSplit(source, ",");
    }
}

