/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class LZSEncoding {
    private static final char[] keyStrBase64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static final char[] keyStrUriSafe = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$".toCharArray();
    private static final char[] valStrBase64 = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '>', '\u0000', '\u0000', '\u0000', '?', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '\u0000', '\u0000', '\u0000', '@', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3'};
    private static final char[] valStrUriSafe = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '@', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '>', '\u0000', '?', '\u0000', '\u0000', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3'};

    private LZSEncoding() {
    }

    public static String compressToBase64(String uncompressed) {
        if (uncompressed == null) {
            return null;
        }
        String res = LZSEncoding._compress(uncompressed, 6, keyStrBase64);
        switch (res.length() & 3) {
            default: {
                return res;
            }
            case 1: {
                return res + "===";
            }
            case 2: {
                return res + "==";
            }
            case 3: 
        }
        return res + "=";
    }

    public static String decompressFromBase64(String compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length() == 0) {
            return "";
        }
        return LZSEncoding._decompress(compressed.length(), compressed, valStrBase64);
    }

    public static String compressToUTF16(String uncompressed) {
        if (uncompressed == null) {
            return null;
        }
        return LZSEncoding._compress(uncompressed, 15, 32) + " ";
    }

    public static String decompressFromUTF16(String compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length() == 0) {
            return "";
        }
        return LZSEncoding._decompress(compressed.length(), 16384, compressed, -32);
    }

    public static String compressToEncodedURIComponent(String uncompressed) {
        if (uncompressed == null) {
            return null;
        }
        return LZSEncoding._compress(uncompressed, 6, keyStrUriSafe);
    }

    public static String decompressFromEncodedURIComponent(String compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.length() == 0) {
            return "";
        }
        return LZSEncoding._decompress(compressed.length(), compressed, valStrUriSafe);
    }

    public static String compress(String uncompressed) {
        return LZSEncoding._compress(uncompressed, 16, 0);
    }

    private static String _compress(String uncompressedStr, int bitsPerChar, char[] getCharFromInt) {
        int i;
        int value;
        if (uncompressedStr == null) {
            return null;
        }
        if (uncompressedStr.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> context_dictionary = new HashMap<String, Integer>(256, 0.5f);
        HashSet<String> context_dictionaryToCreate = new HashSet<String>(256, 0.5f);
        String context_w = "";
        int context_enlargeIn = 2;
        int context_dictSize = 3;
        int context_numBits = 2;
        StringBuilder context_data = new StringBuilder(uncompressedStr.length() >>> 1);
        int context_data_val = 0;
        int context_data_position = 0;
        int uncompressedLength = uncompressedStr.length();
        for (int ii = 0; ii < uncompressedLength; ++ii) {
            String context_wc;
            String context_c = String.valueOf(uncompressedStr.charAt(ii));
            if (!context_dictionary.containsKey(context_c)) {
                context_dictionary.put(context_c, context_dictSize++);
                context_dictionaryToCreate.add(context_c);
            }
            if (context_dictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (context_dictionaryToCreate.contains(context_w)) {
                char c = context_w.charAt(0);
                value = c;
                if (c < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                if (--context_enlargeIn == 0) {
                    context_enlargeIn = 1 << context_numBits++;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.append(getCharFromInt[context_data_val]);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
            if (--context_enlargeIn == 0) {
                context_enlargeIn = 1 << context_numBits++;
            }
            context_dictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append(getCharFromInt[context_data_val]);
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.append(getCharFromInt[context_data_val]);
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == bitsPerChar - 1) {
                context_data_position = 0;
                context_data.append(getCharFromInt[context_data_val]);
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>= 1;
        }
        while (true) {
            context_data_val <<= 1;
            if (context_data_position == bitsPerChar - 1) break;
            ++context_data_position;
        }
        context_data.append(getCharFromInt[context_data_val]);
        return context_data.toString();
    }

    private static String _compress(String uncompressedStr, int bitsPerChar, int offset) {
        int i;
        int value;
        if (uncompressedStr == null) {
            return null;
        }
        if (uncompressedStr.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> context_dictionary = new HashMap<String, Integer>(256, 0.5f);
        HashSet<String> context_dictionaryToCreate = new HashSet<String>(256, 0.5f);
        String context_w = "";
        int context_enlargeIn = 2;
        int context_dictSize = 3;
        int context_numBits = 2;
        StringBuilder context_data = new StringBuilder(uncompressedStr.length() >>> 1);
        int context_data_val = 0;
        int context_data_position = 0;
        int uncompressedLength = uncompressedStr.length();
        for (int ii = 0; ii < uncompressedLength; ++ii) {
            String context_wc;
            String context_c = String.valueOf(uncompressedStr.charAt(ii));
            if (!context_dictionary.containsKey(context_c)) {
                context_dictionary.put(context_c, context_dictSize++);
                context_dictionaryToCreate.add(context_c);
            }
            if (context_dictionary.containsKey(context_wc = context_w + context_c)) {
                context_w = context_wc;
                continue;
            }
            if (context_dictionaryToCreate.contains(context_w)) {
                char c = context_w.charAt(0);
                value = c;
                if (c < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                if (--context_enlargeIn == 0) {
                    context_enlargeIn = 1 << context_numBits++;
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.append((char)(context_data_val + offset));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
            if (--context_enlargeIn == 0) {
                context_enlargeIn = 1 << context_numBits++;
            }
            context_dictionary.put(context_wc, context_dictSize++);
            context_w = context_c;
        }
        if (!context_w.isEmpty()) {
            if (context_dictionaryToCreate.contains(context_w)) {
                if (context_w.charAt(0) < '\u0100') {
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val <<= 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                            continue;
                        }
                        ++context_data_position;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 8; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                } else {
                    value = 1;
                    for (i = 0; i < context_numBits; ++i) {
                        context_data_val = context_data_val << 1 | value;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value = 0;
                    }
                    value = context_w.charAt(0);
                    for (i = 0; i < 16; ++i) {
                        context_data_val = context_data_val << 1 | value & 1;
                        if (context_data_position == bitsPerChar - 1) {
                            context_data_position = 0;
                            context_data.append((char)(context_data_val + offset));
                            context_data_val = 0;
                        } else {
                            ++context_data_position;
                        }
                        value >>= 1;
                    }
                }
                context_dictionaryToCreate.remove(context_w);
            } else {
                value = (Integer)context_dictionary.get(context_w);
                for (i = 0; i < context_numBits; ++i) {
                    context_data_val = context_data_val << 1 | value & 1;
                    if (context_data_position == bitsPerChar - 1) {
                        context_data_position = 0;
                        context_data.append((char)(context_data_val + offset));
                        context_data_val = 0;
                    } else {
                        ++context_data_position;
                    }
                    value >>= 1;
                }
            }
        }
        value = 2;
        for (i = 0; i < context_numBits; ++i) {
            context_data_val = context_data_val << 1 | value & 1;
            if (context_data_position == bitsPerChar - 1) {
                context_data_position = 0;
                context_data.append((char)(context_data_val + offset));
                context_data_val = 0;
            } else {
                ++context_data_position;
            }
            value >>= 1;
        }
        while (true) {
            context_data_val <<= 1;
            if (context_data_position == bitsPerChar - 1) break;
            ++context_data_position;
        }
        context_data.append((char)(context_data_val + offset));
        return context_data.toString();
    }

    public static String decompress(String compressed) {
        if (compressed == null) {
            return null;
        }
        if (compressed.isEmpty()) {
            return "";
        }
        return LZSEncoding._decompress(compressed.length(), 32768, compressed, 0);
    }

    private static String _decompress(int length, String getNextValue, char[] modify) {
        String c;
        int resb;
        if (getNextValue == null) {
            return null;
        }
        if (getNextValue.length() == 0) {
            return "";
        }
        ArrayList<String> dictionary = new ArrayList<String>();
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = 32;
        int index = 1;
        StringBuilder sb = new StringBuilder(getNextValue.length());
        char val = modify[getNextValue.charAt(0)];
        for (char i = '\u0000'; i < '\u0003'; i = (char)(i + '\u0001')) {
            dictionary.add(i, String.valueOf(i));
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>= 1) == 0) {
                position = 32;
                val = modify[getNextValue.charAt(index++)];
            }
            bits = (char)(bits | -resb >>> 31 << power++);
        }
        switch (bits) {
            case '\u0000': {
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = 32;
                        val = modify[getNextValue.charAt(index++)];
                    }
                    bits = (char)(bits | -resb >>> 31 << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = 32;
                        val = modify[getNextValue.charAt(index++)];
                    }
                    bits = (char)(bits | -resb >>> 31 << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return "";
            }
        }
        dictionary.add(c);
        String w = c;
        sb.append(w);
        while (index <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>= 1) == 0) {
                    position = 32;
                    val = modify[getNextValue.charAt(index++)];
                }
                cc |= -resb >>> 31 << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = 32;
                            val = modify[getNextValue.charAt(index++)];
                        }
                        bits = (char)(bits | -resb >>> 31 << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = 32;
                            val = modify[getNextValue.charAt(index++)];
                        }
                        bits = (char)(bits | -resb >>> 31 << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    return sb.toString();
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return "";
            }
            sb.append(entry);
            dictionary.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return "";
    }

    private static String _decompress(int length, int resetValue, String getNextValue, int offset) {
        String c;
        int resb;
        if (getNextValue == null) {
            return null;
        }
        if (getNextValue.length() == 0) {
            return "";
        }
        ArrayList<String> dictionary = new ArrayList<String>();
        int enlargeIn = 4;
        int dictSize = 4;
        int numBits = 3;
        int position = resetValue;
        int index = 1;
        StringBuilder sb = new StringBuilder(getNextValue.length());
        char val = (char)(getNextValue.charAt(0) + offset);
        for (char i = '\u0000'; i < '\u0003'; i = (char)(i + '\u0001')) {
            dictionary.add(i, String.valueOf(i));
        }
        char bits = '\u0000';
        int maxpower = 2;
        int power = 0;
        while (power != maxpower) {
            resb = val & position;
            if ((position >>= 1) == 0) {
                position = resetValue;
                val = (char)(getNextValue.charAt(index++) + offset);
            }
            bits = (char)(bits | -resb >>> 31 << power++);
        }
        switch (bits) {
            case '\u0000': {
                maxpower = 8;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = resetValue;
                        val = (char)(getNextValue.charAt(index++) + offset);
                    }
                    bits = (char)(bits | -resb >>> 31 << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            case '\u0001': {
                bits = '\u0000';
                maxpower = 16;
                power = 0;
                while (power != maxpower) {
                    resb = val & position;
                    if ((position >>= 1) == 0) {
                        position = resetValue;
                        val = (char)(getNextValue.charAt(index++) + offset);
                    }
                    bits = (char)(bits | -resb >>> 31 << power++);
                }
                c = String.valueOf(bits);
                break;
            }
            default: {
                return "";
            }
        }
        dictionary.add(c);
        String w = c;
        sb.append(w);
        while (index <= length) {
            String entry;
            int cc = 0;
            maxpower = numBits;
            power = 0;
            while (power != maxpower) {
                resb = val & position;
                if ((position >>= 1) == 0) {
                    position = resetValue;
                    val = (char)(getNextValue.charAt(index++) + offset);
                }
                cc |= -resb >>> 31 << power++;
            }
            switch (cc) {
                case 0: {
                    bits = '\u0000';
                    maxpower = 8;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = resetValue;
                            val = (char)(getNextValue.charAt(index++) + offset);
                        }
                        bits = (char)(bits | -resb >>> 31 << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 1: {
                    bits = '\u0000';
                    maxpower = 16;
                    power = 0;
                    while (power != maxpower) {
                        resb = val & position;
                        if ((position >>= 1) == 0) {
                            position = resetValue;
                            val = (char)(getNextValue.charAt(index++) + offset);
                        }
                        bits = (char)(bits | -resb >>> 31 << power++);
                    }
                    dictionary.add(String.valueOf(bits));
                    cc = dictSize++;
                    --enlargeIn;
                    break;
                }
                case 2: {
                    return sb.toString();
                }
            }
            if (enlargeIn == 0) {
                enlargeIn = 1 << numBits;
                ++numBits;
            }
            if (cc < dictionary.size() && dictionary.get(cc) != null) {
                entry = (String)dictionary.get(cc);
            } else if (cc == dictSize) {
                entry = w + w.charAt(0);
            } else {
                return "";
            }
            sb.append(entry);
            dictionary.add(w + entry.charAt(0));
            ++dictSize;
            w = entry;
            if (--enlargeIn != 0) continue;
            enlargeIn = 1 << numBits;
            ++numBits;
        }
        return "";
    }
}

