/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.NumberedSet;
import com.github.tommyettinger.ds.ObjectIntMap;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ObjectOrderedSet;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.WhiskerRandom;

public class ProbabilityTable<T> {
    public final NumberedSet<T> table;
    public final ObjectList<ProbabilityTable<T>> extraTable;
    public final IntList weights;
    public EnhancedRandom rng;
    public int total;

    public ProbabilityTable() {
        this((EnhancedRandom)new WhiskerRandom());
    }

    public ProbabilityTable(EnhancedRandom rng) {
        this.rng = rng == null ? new WhiskerRandom() : rng;
        this.table = new NumberedSet(64, 0.5f);
        this.extraTable = new ObjectList(16);
        this.weights = new IntList(64);
        this.total = 0;
    }

    public ProbabilityTable(ProbabilityTable<? extends T> other) {
        this.rng = other.rng.copy();
        this.table = new NumberedSet(other.table);
        this.extraTable = new ObjectList(other.extraTable.size());
        for (int i = 0; i < other.extraTable.size(); ++i) {
            this.extraTable.add(new ProbabilityTable<T>((ProbabilityTable)other.extraTable.get(i)));
        }
        this.weights = new IntList(other.weights);
        this.total = other.total;
    }

    public ProbabilityTable(long seed) {
        this((EnhancedRandom)new WhiskerRandom(seed));
    }

    public ProbabilityTable(String seed) {
        this((EnhancedRandom)new WhiskerRandom(Hasher.purson.hash64((CharSequence)seed), Hasher.purson_.hash64((CharSequence)seed), Hasher.astaroth.hash64((CharSequence)seed), (long)Hasher.astaroth_.hash((CharSequence)seed)));
    }

    public T random() {
        int i;
        if (this.table.isEmpty() && this.extraTable.isEmpty()) {
            return null;
        }
        int index = this.rng.nextInt(this.total);
        int sz = this.table.size();
        for (i = 0; i < sz; ++i) {
            if ((index -= this.weights.get(i)) >= 0) continue;
            return (T)this.table.getAt(i);
        }
        for (i = 0; i < this.extraTable.size(); ++i) {
            if ((index -= this.weights.get(sz + i)) >= 0) continue;
            return ((ProbabilityTable)this.extraTable.get(i)).random();
        }
        return null;
    }

    public ProbabilityTable<T> add(T item, int weight) {
        if (weight <= 0) {
            return this;
        }
        int i = this.table.indexOf(item);
        if (i < 0) {
            this.weights.insert(this.table.size(), weight);
            this.table.add(item);
            this.total += weight;
        } else {
            int i2 = this.weights.get(i);
            int w = Math.max(0, i2 + weight);
            this.weights.set(i, w);
            this.total += w - i2;
        }
        return this;
    }

    public ProbabilityTable<T> addAll(ObjectIntMap<T> itemsAndWeights) {
        if (itemsAndWeights == null) {
            return this;
        }
        for (ObjectIntMap.Entry ent : itemsAndWeights) {
            this.add(ent.key, ent.value);
        }
        return this;
    }

    public boolean remove(T item) {
        return this.remove(item, this.weight(item));
    }

    public boolean remove(T item, int weight) {
        if (weight <= 0) {
            return false;
        }
        int idx = this.table.indexOf(item);
        if (idx < 0) {
            return false;
        }
        int o = this.weights.get(idx);
        this.weights.minus(idx, weight);
        int w = this.weights.get(idx);
        if (w <= 0) {
            this.table.removeAt(idx);
            this.weights.removeAt(idx);
        }
        w = Math.min(o, o - w);
        this.total -= w;
        return true;
    }

    public boolean removeAll(Iterable<T> items) {
        boolean changed = false;
        for (T t : items) {
            changed |= this.remove(t);
        }
        return changed;
    }

    public boolean removeAll(ObjectIntMap<T> itemsAndWeights) {
        if (itemsAndWeights == null) {
            return false;
        }
        boolean changed = false;
        for (ObjectIntMap.Entry ent : itemsAndWeights) {
            changed |= this.remove(ent.key, ent.value);
        }
        return changed;
    }

    public ProbabilityTable<T> add(ProbabilityTable<T> table, int weight) {
        if (weight <= 0 || table == null || this.contentEquals(table) || table.total <= 0) {
            return this;
        }
        this.weights.add(weight);
        this.extraTable.add(table);
        this.total += weight;
        return this;
    }

    public ProbabilityTable<T> addAllNested(ObjectIntMap<ProbabilityTable<T>> itemsAndWeights) {
        if (itemsAndWeights == null) {
            return this;
        }
        for (ObjectIntMap.Entry ent : itemsAndWeights) {
            this.add((ProbabilityTable)ent.key, ent.value);
        }
        return this;
    }

    public int weight(T item) {
        int i = this.table.indexOf(item);
        return i < 0 ? 0 : this.weights.get(i);
    }

    public int weight(ProbabilityTable<T> item) {
        int i = this.extraTable.indexOf(item);
        return i < 0 ? 0 : this.weights.get(i + this.table.size());
    }

    public ObjectOrderedSet<T> items() {
        ObjectOrderedSet os = new ObjectOrderedSet(this.table);
        for (int i = 0; i < this.extraTable.size(); ++i) {
            os.addAll(((ProbabilityTable)this.extraTable.get(i)).items());
        }
        return os;
    }

    public NumberedSet<T> simpleItems() {
        return this.table;
    }

    public ObjectList<ProbabilityTable<T>> tables() {
        return this.extraTable;
    }

    public void setRandom(EnhancedRandom random) {
        if (random != null) {
            this.rng = random;
        }
    }

    public EnhancedRandom getRandom() {
        return this.rng;
    }

    public ProbabilityTable<T> copy() {
        return new ProbabilityTable<T>(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProbabilityTable that = (ProbabilityTable)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.extraTable.equals(that.extraTable)) {
            return false;
        }
        return this.weights.equals((Object)that.weights);
    }

    public boolean contentEquals(ProbabilityTable<T> o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.table.equals(o.table)) {
            return false;
        }
        if (!this.extraTable.equals(o.extraTable)) {
            return false;
        }
        return this.weights.equals((Object)o.weights);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 421 * result + this.extraTable.hashCode();
        result = 83 * result + this.weights.hashCode();
        return result;
    }
}

