/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.ds.ObjectList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import regexodus.Matcher;
import regexodus.Pattern;
import regexodus.Replacer;

public final class StringTools {
    public static final Pattern whitespacePattern = Pattern.compile((String)"\\s+");
    public static final Pattern nonSpacePattern = Pattern.compile((String)"\\S+");
    private static final Matcher matcher = new Matcher(whitespacePattern);
    private static final Matcher capitalizeMatcher = Pattern.compile((String)"(?<!\\pL)(\\pL)(\\pL*)(\\PL*)").matcher();
    private static final StringBuilder sb = new StringBuilder(64);
    private static final Matcher sentenceMatcher = Pattern.compile((String)"(\\PL*)((\\pL)([^.?!]*)($|[.?!]+))(\\PL*)").matcher();
    private static final Replacer anReplacer = new Replacer(Pattern.compile((String)"\\b(a)(\\p{G}+)(?=[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u0101\u0103\u0105\u01fb\u01fda\u00e8\u00e9\u00ea\u00eb\u0113\u0115\u0117\u0119\u011be\u00ec\u00ed\u00ee\u00ef\u0129\u012b\u012d\u012f\u0131i\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u014f\u0151\u0153\u01ffo\u00f9\u00fa\u00fb\u00fc\u0169\u016b\u016d\u016f\u0171\u0173u])", (int)17), "$1n$2");
    public static final String PERMISSIBLE_CHARS = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u0100\u0101\u0102\u0103\u0104\u0105\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u010e\u010f\u0110\u0111\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0130\u0131\u0134\u0135\u0136\u0137\u0139\u013a\u013b\u013c\u013d\u013e\u013f\u0140\u0141\u0142\u0143\u0144\u0145\u0146\u0147\u0148\u014a\u014b\u014c\u014d\u014e\u014f\u0150\u0151\u0152\u0153\u0154\u0155\u0156\u0157\u0158\u0159\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u0162\u0163\u0164\u0165\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173\u0174\u0175\u0176\u0177\u0178\u0179\u017a\u017b\u017c\u017d\u017e\u017f\u0192\u01fa\u01fb\u01fc\u01fd\u01fe\u01ff\u0218\u0219\u021a\u021b\u0237\u02c6\u02c7\u02c9\u02cb\u02d8\u02d9\u02da\u02db\u02dc\u02dd\u0384\u0385\u0386\u0387\u0388\u0389\u038a\u038c\u038e\u038f\u0390\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u03aa\u03ab\u03ac\u03ad\u03ae\u03af\u03b0\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ca\u03cb\u03cc\u03cd\u03ce\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0474\u0475\u0490\u0491\u1e80\u1e81\u1e82\u1e83\u1e84\u1e85\u1ef2\u1ef3\u2013\u2014\u2018\u2019\u201a\u201b\u201c\u201d\u201e\u2020\u2021\u2022\u2026\u2030\u2039\u203a\u207f\u20a4\u20ac\u2116\u2122\u2126\u212e\u2190\u2191\u2192\u2193\u2206\u2212\u221a\u2248\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2550\u2551\u2552\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u25a0\u25a1\u25b2\u25bc\u25cb\u25cf\u25e6\u2640\u2642\u2660\u2663\u2665\u2666\u266a";
    public static final String BOX_DRAWING_SINGLE = "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c";
    public static final String BOX_DRAWING_DOUBLE = "\u2550\u2551\u2554\u2557\u255a\u255d\u2560\u2563\u2566\u2569\u256c";
    public static final String BOX_DRAWING = "\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2550\u2551\u2552\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c";
    public static final String VISUAL_SYMBOLS = "\u2190\u2191\u2192\u2193\u25a0\u25a1\u25b2\u25bc\u25cb\u25cf\u25e6\u2640\u2642\u2660\u2663\u2665\u2666\u266a";
    public static final String DIGITS = "0123456789";
    public static final String MARKS = "~`^'\u00a8\u00af\u00b0\u00b4\u00b8\u02c6\u02c7\u02c9\u02cb\u02d8\u02d9\u02da\u02db\u02dc\u02dd\u0384\u0385\u2018\u2019\u201a\u201b";
    public static final String GROUPING_SIGNS_OPEN = "([{<\u00ab\u2018\u201b\u201c\u2039";
    public static final String GROUPING_SIGNS_CLOSE = ")]}>\u00bb\u2019\u2019\u201d\u203a";
    public static final String COMMON_PUNCTUATION = "!\"%&'*+,-./:;<>?\u2022\u2026\u2013\u2014";
    public static final String MODERN_PUNCTUATION = "@\\^_`|~\u00a6\u00a9\u00ae\u2122\u00b4\u2116\u2640\u2642\u266a";
    public static final String UNCOMMON_PUNCTUATION = "\u00a7\u00b6\u00a8\u00aa\u00ba\u00af\u00b0\u00b7\u00b8\u00a1\u00bf\u0387\u201a\u201e\u2020\u2021";
    public static final String TECHNICAL_PUNCTUATION = "#%'*+,-./<=>^|\u00ac\u00b0\u00b5\u00b1\u00b9\u00b2\u00b3\u207f\u00bc\u00bd\u00be\u00d7\u00f7\u2030\u2116\u2126\u212e\u2206\u2212\u221a\u2248";
    public static final String PUNCTUATION = "!\"%&'*+,-./:;<>?\u2022\u2026\u2013\u2014@\\^_`|~\u00a6\u00a9\u00ae\u2122\u00b4\u2116\u2640\u2642\u266a\u00a7\u00b6\u00a8\u00aa\u00ba\u00af\u00b0\u00b7\u00b8\u00a1\u00bf\u0387\u201a\u201e\u2020\u2021#%'*+,-./<=>^|\u00ac\u00b0\u00b5\u00b1\u00b9\u00b2\u00b3\u207f\u00bc\u00bd\u00be\u00d7\u00f7\u2030\u2116\u2126\u212e\u2206\u2212\u221a\u2248([{<\u00ab\u2018\u201b\u201c\u2039)]}>\u00bb\u2019\u2019\u201d\u203a";
    public static final String CURRENCY = "$\u00a2\u00a3\u00a4\u00a5\u20a4\u20ac";
    public static final String SPACING = " ";
    public static final String ENGLISH_LETTERS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ENGLISH_LETTERS_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String ENGLISH_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String LATIN_EXTENDED_LETTERS_UPPER = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ";
    public static final String LATIN_EXTENDED_LETTERS_LOWER = "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237";
    public static final String LATIN_EXTENDED_LETTERS = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237";
    public static final String LATIN_LETTERS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ";
    public static final String LATIN_LETTERS_LOWER = "abcdefghijklmnopqrstuvwxyz\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237";
    public static final String LATIN_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJabcdefghijklmnopqrstuvwxyz\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237";
    public static final String GREEK_LETTERS_UPPER = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03aa\u03ab\u03aa\u03ab";
    public static final String GREEK_LETTERS_LOWER = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce\u03ca\u03cb\u0390\u03b0";
    public static final String GREEK_LETTERS = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03aa\u03ab\u03aa\u03ab\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce\u03ca\u03cb\u0390\u03b0";
    public static final String CYRILLIC_LETTERS_UPPER = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0474\u0490";
    public static final String CYRILLIC_LETTERS_LOWER = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0475\u0491";
    public static final String CYRILLIC_LETTERS = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0474\u0490\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0475\u0491";
    public static final String LETTERS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03aa\u03ab\u03aa\u03ab\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0474\u0490";
    public static final String LETTERS_LOWER = "abcdefghijklmnopqrstuvwxyz\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce\u03ca\u03cb\u0390\u03b0\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0475\u0491";
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03aa\u03ab\u03aa\u03ab\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0474\u0490abcdefghijklmnopqrstuvwxyz\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce\u03ca\u03cb\u0390\u03b0\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0475\u0491";
    public static final String LETTERS_AND_NUMBERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u0100\u0102\u0104\u0106\u0108\u010a\u010c\u010e\u0110\u0112\u0114\u0116\u0118\u011a\u011c\u011e\u0120\u0122\u0124\u0126\u0128\u012a\u012c\u012e\u0130\u0134\u0136\u0139\u013b\u013d\u013f\u0141\u0143\u0145\u0147\u014a\u014c\u014e\u0150\u0152\u0154\u0156\u0158\u015a\u015c\u015e\u0160\u0162\u0164\u0168\u016a\u016c\u016e\u0170\u0172\u0174\u0176\u0178\u0179\u017b\u017d\u01fa\u01fc\u01fe\u0218\u021a\u1e80\u1e82\u1e84\u1ef2\u00dfSFJ\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03aa\u03ab\u03aa\u03ab\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0400\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040d\u040e\u040f\u0474\u0490abcdefghijklmnopqrstuvwxyz\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u011b\u011d\u011f\u0121\u0123\u0125\u0127\u0129\u012b\u012d\u012f\u0131\u0135\u0137\u013a\u013c\u013e\u0140\u0142\u0144\u0146\u0148\u014b\u014d\u014f\u0151\u0153\u0155\u0157\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u00ff\u017a\u017c\u017e\u01fb\u01fd\u01ff\u0219\u021b\u1e81\u1e83\u1e85\u1ef3\u00df\u017f\u0192\u0237\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce\u03ca\u03cb\u0390\u03b0\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0450\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045d\u045e\u045f\u0475\u04910123456789";

    private StringTools() {
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Collection<? extends CharSequence> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        Iterator<? extends CharSequence> it = elements.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb.toString();
    }

    public static String joinArrays(CharSequence delimiter, char[] ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, long ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, double ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, int ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, float ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, short ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, char ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, byte ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, boolean ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable<?> elements) {
        if (elements == null) {
            return "";
        }
        Iterator<?> it = elements.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb.toString();
    }

    public static String joinAlt(boolean ... elements) {
        if (elements == null) {
            return "N";
        }
        if (elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i] ? (char)'1' : '0');
        }
        return sb.toString();
    }

    public static String joinAlt(CharSequence delimiter, long ... elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(elements.length << 2);
        sb.append(elements[0]).append('L');
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]).append('L');
        }
        return sb.toString();
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, CharSequence ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Collection<? extends CharSequence> elements) {
        if (sb == null || elements == null || elements.isEmpty()) {
            return sb;
        }
        Iterator<? extends CharSequence> it = elements.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb;
    }

    public static StringBuilder appendJoinedArrays(StringBuilder sb, CharSequence delimiter, char[] ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, long ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, double ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, int ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, float ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, short ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, char ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, byte ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, boolean ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Object[] elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb;
    }

    public static StringBuilder appendJoined(StringBuilder sb, CharSequence delimiter, Iterable<?> elements) {
        if (sb == null || elements == null) {
            return sb;
        }
        Iterator<?> it = elements.iterator();
        if (!it.hasNext()) {
            return sb;
        }
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(delimiter).append(it.next());
        }
        return sb;
    }

    public static StringBuilder appendJoinedAlt(StringBuilder sb, boolean ... elements) {
        if (sb == null || elements == null) {
            return sb;
        }
        if (elements.length == 0) {
            return sb;
        }
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i] ? (char)'1' : '0');
        }
        return sb;
    }

    public static StringBuilder appendJoinedAlt(StringBuilder sb, CharSequence delimiter, long ... elements) {
        if (sb == null || elements == null || elements.length == 0) {
            return sb;
        }
        sb.append(elements[0]).append('L');
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]).append('L');
        }
        return sb;
    }

    public static boolean contains(CharSequence text, CharSequence search) {
        return text != null && text.length() != 0 && search != null && search.length() > 0 && StringTools.containsPart(text, search) == search.length();
    }

    public static int containsPart(CharSequence text, CharSequence search) {
        if (text == null || text.length() == 0 || search == null || search.length() <= 0) {
            return 0;
        }
        int sl = search.length();
        int tl = text.length() - sl;
        int f = 0;
        char s = search.charAt(0);
        block0: for (int i = 0; i <= tl; ++i) {
            if (text.charAt(i) != s) continue;
            int j = i + 1;
            for (int x = 1; x < sl; ++x) {
                if (text.charAt(j) != search.charAt(x)) {
                    f = Math.max(f, x);
                    continue block0;
                }
                ++j;
            }
            return sl;
        }
        return f;
    }

    public static boolean contains(CharSequence text, char[] search) {
        return text != null && text.length() != 0 && search != null && search.length > 0 && StringTools.containsPart(text, search) == search.length;
    }

    public static int containsPart(CharSequence text, char[] search) {
        if (text == null || text.length() == 0 || search == null || search.length <= 0) {
            return 0;
        }
        int sl = search.length;
        int tl = text.length() - sl;
        int f = 0;
        char s = search[0];
        block0: for (int i = 0; i <= tl; ++i) {
            if (text.charAt(i) != s) continue;
            int j = i + 1;
            for (int x = 1; x < sl; ++x) {
                if (text.charAt(j) != search[x]) {
                    f = Math.max(f, x);
                    continue block0;
                }
                ++j;
            }
            return sl;
        }
        return f;
    }

    public static int containsPart(CharSequence text, char[] search, CharSequence prefix, CharSequence suffix) {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        int bl = prefix.length();
        int el = suffix.length();
        if (text == null || text.length() == 0 || search == null || search.length + bl + el <= 0) {
            return 0;
        }
        int sl = bl + search.length + el;
        int tl = text.length() - sl;
        int f = 0;
        int sl2 = sl - el;
        char s = bl <= 0 ? (search.length <= 0 ? suffix.charAt(0) : search[0]) : prefix.charAt(0);
        block0: for (int i = 0; i <= tl; ++i) {
            if (text.charAt(i) != s) continue;
            int j = i + 1;
            for (int x = 1; x < sl; ++x) {
                if (x < bl) {
                    if (text.charAt(j) != prefix.charAt(x)) {
                        f = Math.max(f, x);
                        continue block0;
                    }
                } else if (x < sl2) {
                    if (text.charAt(j) != search[x - bl]) {
                        f = Math.max(f, x);
                        continue block0;
                    }
                } else if (text.charAt(j) != suffix.charAt(x - sl2)) {
                    f = Math.max(f, x);
                    continue block0;
                }
                ++j;
            }
            return sl;
        }
        return f;
    }

    public static String replace(CharSequence text, CharSequence before, CharSequence after) {
        if (text instanceof String) {
            return ((String)text).replace(before, after);
        }
        String t = text.toString();
        return t.replace(before, after);
    }

    public static int count(String source, String search) {
        if (source == null || search == null || source.isEmpty() || search.isEmpty()) {
            return 0;
        }
        int amount = 0;
        int idx = -1;
        while ((idx = source.indexOf(search, idx + 1)) >= 0) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, int search) {
        if (source == null || source.isEmpty()) {
            return 0;
        }
        int amount = 0;
        int idx = -1;
        while ((idx = source.indexOf(search, idx + 1)) >= 0) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, String search, int startIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = Integer.MAX_VALUE;
        }
        if (source == null || search == null || source.isEmpty() || search.isEmpty() || startIndex < 0 || startIndex >= endIndex) {
            return 0;
        }
        int amount = 0;
        int idx = startIndex - 1;
        while ((idx = source.indexOf(search, idx + 1)) >= 0 && idx < endIndex) {
            ++amount;
        }
        return amount;
    }

    public static int count(String source, int search, int startIndex, int endIndex) {
        if (endIndex < 0) {
            endIndex = Integer.MAX_VALUE;
        }
        if (source == null || source.isEmpty() || startIndex < 0 || startIndex >= endIndex) {
            return 0;
        }
        int amount = 0;
        int idx = startIndex - 1;
        while ((idx = source.indexOf(search, idx + 1)) >= 0 && idx < endIndex) {
            ++amount;
        }
        return amount;
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > source.length()) {
            endIndex = source.length();
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return source.substring(beginIndex, endIndex);
    }

    public static String[] split(String source, String delimiter) {
        int amount = StringTools.count(source, delimiter);
        if (amount <= 0) {
            return new String[]{source};
        }
        String[] splat = new String[amount + 1];
        int dl = delimiter.length();
        int idx = -dl;
        for (int i = 0; i < amount; ++i) {
            int n = idx + dl;
            idx = source.indexOf(delimiter, idx + dl);
            splat[i] = StringTools.safeSubstring(source, n, idx);
        }
        int idx2 = source.indexOf(delimiter, idx + dl);
        splat[amount] = idx2 < 0 ? StringTools.safeSubstring(source, idx + dl, source.length()) : StringTools.safeSubstring(source, idx + dl, idx2);
        return splat;
    }

    public static String padRight(String text, int minimumLength) {
        if (text.length() < minimumLength) {
            return StringTools.padRightStrict(text, ' ', minimumLength);
        }
        return text;
    }

    public static String padRight(String text, char padChar, int minimumLength) {
        if (text.length() < minimumLength) {
            return StringTools.padRightStrict(text, padChar, minimumLength);
        }
        return text;
    }

    public static String padRightStrict(String text, int totalLength) {
        return StringTools.padRightStrict(text, ' ', totalLength);
    }

    public static String padRightStrict(String text, char padChar, int totalLength) {
        char[] c = new char[totalLength];
        int len = text.length();
        text.getChars(0, Math.min(len, totalLength), c, 0);
        for (int i = len; i < totalLength; ++i) {
            c[i] = padChar;
        }
        return String.valueOf(c);
    }

    public static String padLeft(String text, int minimumLength) {
        if (text.length() < minimumLength) {
            return StringTools.padLeftStrict(text, ' ', minimumLength);
        }
        return text;
    }

    public static String padLeft(String text, char padChar, int minimumLength) {
        if (text.length() < minimumLength) {
            return StringTools.padLeftStrict(text, padChar, minimumLength);
        }
        return text;
    }

    public static String padLeftStrict(String text, int totalLength) {
        return StringTools.padLeftStrict(text, ' ', totalLength);
    }

    public static String padLeftStrict(String text, char padChar, int totalLength) {
        char[] c = new char[totalLength];
        int len = text.length();
        text.getChars(0, Math.min(len, totalLength), c, Math.max(0, totalLength - len));
        for (int i = totalLength - len - 1; i >= 0; --i) {
            c[i] = padChar;
        }
        return String.valueOf(c);
    }

    public static List<String> wrap(CharSequence longText, int width) {
        if (width <= 0) {
            return new ObjectList(0);
        }
        return StringTools.wrap((List<String>)new ObjectList(longText.length() / width + 2), longText, width);
    }

    public static List<String> wrap(List<String> receiving, CharSequence longText, int width) {
        if (width <= 0 || receiving == null) {
            return receiving;
        }
        Matcher widthMatcher = Pattern.compile((String)("(?:({=Y}(?!\\s).{1," + width + "})((?<=\\p{Pd})|(\\s+)))|({=Y}\\S{1," + width + "})")).matcher((CharSequence)(longText + "\n"));
        while (widthMatcher.find()) {
            receiving.add(widthMatcher.group("Y"));
        }
        return receiving;
    }

    public static int indexOf(CharSequence text, Pattern regex, int beginIndex) {
        matcher.setPattern(regex);
        matcher.setTarget(text);
        matcher.setPosition(beginIndex);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    public static int indexOf(CharSequence text, String regex, int beginIndex) {
        matcher.setPattern(Pattern.compile((String)regex));
        matcher.setTarget(text);
        matcher.setPosition(beginIndex);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    public static int indexOf(CharSequence text, Pattern regex) {
        matcher.setPattern(regex);
        matcher.setTarget(text);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    public static int indexOf(CharSequence text, String regex) {
        matcher.setPattern(Pattern.compile((String)regex));
        matcher.setTarget(text);
        if (!matcher.find()) {
            return -1;
        }
        return matcher.start();
    }

    public static String capitalize(CharSequence original) {
        if (original == null || original.length() <= 0) {
            return "";
        }
        sb.setLength(0);
        capitalizeMatcher.setTarget(original);
        while (capitalizeMatcher.find()) {
            sb.append(capitalizeMatcher.group(1).toUpperCase());
            capitalizeMatcher.getGroup(2, sb, 1);
            capitalizeMatcher.getGroup(3, sb);
        }
        return sb.toString();
    }

    public static String sentenceCase(CharSequence original) {
        if (original == null || original.length() <= 0) {
            return "";
        }
        sb.setLength(0);
        sentenceMatcher.setTarget(original);
        while (sentenceMatcher.find()) {
            sentenceMatcher.getGroup(1, sb);
            sb.append(sentenceMatcher.group(3).toUpperCase());
            sentenceMatcher.getGroup(4, sb);
            sentenceMatcher.getGroup(5, sb);
            sentenceMatcher.getGroup(6, sb);
        }
        return sb.toString();
    }

    public static String correctABeforeVowel(CharSequence text) {
        return anReplacer.replace(text);
    }
}

