/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.core;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.IntList;
import com.github.yellowstonegames.core.StringTools;
import java.util.Arrays;
import java.util.Random;

public class WeightedTable {
    protected final int[] mixed;
    public final int size;

    public WeightedTable() {
        this(1.0f);
    }

    public WeightedTable(float ... probabilities) {
        this.size = probabilities.length;
        if (this.size == 0) {
            throw new IllegalArgumentException("Array 'probabilities' given to WeightedTable must be nonempty.");
        }
        this.mixed = new int[this.size << 1];
        float sum = 0.0f;
        float[] probs = new float[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (probabilities[i] <= 0.0f) continue;
            probs[i] = probabilities[i];
            sum += probs[i];
        }
        if (sum <= 0.0f) {
            throw new IllegalArgumentException("At least one probability must be positive");
        }
        float average = sum / (float)this.size;
        float invAverage = 1.0f / average;
        IntList small = new IntList(this.size);
        IntList large = new IntList(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (probs[i] >= average) {
                large.add(i);
                continue;
            }
            small.add(i);
        }
        while (!small.isEmpty() && !large.isEmpty()) {
            int less = small.pop();
            int less2 = less << 1;
            int more = large.pop();
            this.mixed[less2] = (int)(2.1474836E9f * (probs[less] * invAverage));
            this.mixed[less2 | 1] = more;
            int n = more;
            probs[n] = probs[n] + (probs[less] - average);
            if (probs[more] >= average) {
                large.add(more);
                continue;
            }
            small.add(more);
        }
        while (!small.isEmpty()) {
            this.mixed[small.pop() << 1] = Integer.MAX_VALUE;
        }
        while (!large.isEmpty()) {
            this.mixed[large.pop() << 1] = Integer.MAX_VALUE;
        }
    }

    private WeightedTable(int[] mixed, boolean ignored) {
        this.size = mixed.length >> 1;
        this.mixed = mixed;
    }

    public WeightedTable(WeightedTable other) {
        this(Arrays.copyOf(other.mixed, other.mixed.length), true);
    }

    public WeightedTable copy() {
        return new WeightedTable(this);
    }

    public int random(long state) {
        int column;
        return (state = Hasher.randomize3((long)state)) >>> 33 <= (long)this.mixed[(column = (int)((long)this.size * (state & 0xFFFFFFFFL) >>> 32)) << 1] ? column : this.mixed[column << 1 | 1];
    }

    public int random(Random rng) {
        int column;
        long state = rng.nextLong();
        return state >>> 33 <= (long)this.mixed[(column = (int)((long)this.size * (state & 0xFFFFFFFFL) >> 32)) << 1] ? column : this.mixed[column << 1 | 1];
    }

    public String serializeToString() {
        return StringTools.join((CharSequence)",", this.mixed);
    }

    public static WeightedTable deserializeFromString(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        int pos = -1;
        int count = StringTools.count(data, 44) + 1;
        int[] mixed = new int[count];
        for (int i = 0; i < count; ++i) {
            int next = data.indexOf(44, pos + 1);
            if (next == -1) {
                next = data.length();
            }
            int n = pos + 1;
            pos = next;
            mixed[i] = Base.BASE10.readInt((CharSequence)data, n, pos);
        }
        return new WeightedTable(mixed, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedTable that = (WeightedTable)o;
        if (this.size != that.size) {
            return false;
        }
        return Arrays.equals(this.mixed, that.mixed);
    }

    public int hashCode() {
        return Hasher.hash((long)((long)this.size ^ 0xFEDCBA9876543210L), (int[])this.mixed);
    }
}

