/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.ObjectList;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.LineDrawer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BresenhamLine
implements LineDrawer {
    public final ObjectList<Coord> lastLine = new ObjectList();

    public static ObjectList<Coord> line(Coord a, Coord b) {
        return BresenhamLine.line(a.x, a.y, b.x, b.y, Integer.MAX_VALUE, null);
    }

    public static Coord[] lineArray(Coord a, Coord b) {
        return BresenhamLine.lineArray(a.x, a.y, b.x, b.y, Integer.MAX_VALUE);
    }

    public static ObjectList<Coord> line(int startX, int startY, int targetX, int targetY) {
        return BresenhamLine.line(startX, startY, targetX, targetY, Integer.MAX_VALUE, null);
    }

    public static ObjectList<Coord> line(int startX, int startY, int targetX, int targetY, int maxLength) {
        return BresenhamLine.line(startX, startY, targetX, targetY, maxLength, null);
    }

    public static ObjectList<Coord> line(int startX, int startY, int targetX, int targetY, ObjectList<Coord> buffer) {
        return BresenhamLine.line(startX, startY, targetX, targetY, Integer.MAX_VALUE, buffer);
    }

    public static ObjectList<Coord> line(int startX, int startY, int targetX, int targetY, int maxLength, ObjectList<Coord> buffer) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        if (buffer == null) {
            buffer = new ObjectList(Math.max(ax, ay) + 1);
        } else {
            buffer.clear();
        }
        int signx = dx >> 31 | -dx >>> 31;
        int signy = dy >> 31 | -dy >>> 31;
        int x = startX;
        int y = startY;
        if ((ax <<= 1) >= (ay <<= 1)) {
            int deltay = ay - (ax >> 1);
            while (buffer.size() < maxLength) {
                buffer.add((Object)Coord.get(x, y));
                if (x == targetX) {
                    return buffer;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                x += signx;
                deltay += ay;
            }
        } else {
            int deltax = ax - (ay >> 1);
            while (buffer.size() < maxLength) {
                buffer.add((Object)Coord.get(x, y));
                if (y == targetY) {
                    return buffer;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                y += signy;
                deltax += ax;
            }
        }
        return buffer;
    }

    public static ObjectList<Coord> lineEuclidean(int startX, int startY, int targetX, int targetY, int maxLength, ObjectList<Coord> buffer) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        if (buffer == null) {
            buffer = new ObjectList(Math.min((int)Math.sqrt(dx * dx + dy * dy) + 1, maxLength));
        } else {
            buffer.clear();
        }
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        int max2 = maxLength * maxLength;
        ax <<= 1;
        ay <<= 1;
        int signX = dx >> 31 | -dx >>> 31;
        int signY = dy >> 31 | -dy >>> 31;
        int x = startX;
        int y = startY;
        dx = 0;
        dy = 0;
        if (ax >= ay) {
            int deltaY = ay - (ax >> 1);
            while (dx * dx + dy * dy < max2) {
                buffer.add((Object)Coord.get(x, y));
                if (x == targetX) {
                    return buffer;
                }
                if (deltaY >= 0) {
                    y += signY;
                    deltaY -= ax;
                    ++dy;
                }
                x += signX;
                deltaY += ay;
                ++dx;
            }
        } else {
            int deltaX = ax - (ay >> 1);
            while (dx * dx + dy * dy < max2) {
                buffer.add((Object)Coord.get(x, y));
                if (y == targetY) {
                    return buffer;
                }
                if (deltaX >= 0) {
                    x += signX;
                    deltaX -= ay;
                    ++dx;
                }
                y += signY;
                deltaX += ax;
                ++dy;
            }
        }
        return buffer;
    }

    public static boolean reachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap, @Nullable ObjectList<Coord> buffer) {
        return BresenhamLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap, @Nullable ObjectList<Coord> buffer) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap, @Nullable ObjectList<Coord> buffer) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        int dist = Math.max(ax, ay);
        if (buffer != null) {
            buffer.clear();
        }
        if (maxLength <= 0) {
            return false;
        }
        if (startX == targetX && startY == targetY) {
            if (buffer != null) {
                buffer.add((Object)Coord.get(startX, startY));
            }
            return true;
        }
        float decay = 1.0f / (float)dist;
        float currentForce = 1.0f;
        ax <<= 1;
        ay <<= 1;
        int signX = dx >> 31 | -dx >>> 31;
        int signY = dy >> 31 | -dy >>> 31;
        int x = startX;
        int y = startY;
        int size = 0;
        if (ax >= ay) {
            int deltaY = ay - (ax >> 1);
            while (size < maxLength) {
                if (buffer != null) {
                    buffer.add((Object)Coord.get(x, y));
                }
                ++size;
                if (x == targetX) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentForce -= resistanceMap[x][y];
                }
                if ((currentForce -= decay) <= -0.001f) {
                    return false;
                }
                if (deltaY >= 0) {
                    y += signY;
                    deltaY -= ax;
                }
                x += signX;
                deltaY += ay;
            }
        } else {
            int deltaX = ax - (ay >> 1);
            while (size < maxLength) {
                if (buffer != null) {
                    buffer.add((Object)Coord.get(x, y));
                }
                ++size;
                if (y == targetY) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentForce -= resistanceMap[x][y];
                }
                if ((currentForce -= decay) <= -0.001f) {
                    return false;
                }
                if (deltaX >= 0) {
                    x += signX;
                    deltaX -= ay;
                }
                y += signY;
                deltaX += ax;
            }
        }
        return false;
    }

    public static boolean reachableEuclidean(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap, @Nullable ObjectList<Coord> buffer) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        float dist = Math.min((float)Math.sqrt(dx * dx + dy * dy), (float)maxLength);
        if (buffer != null) {
            buffer.clear();
        }
        if (maxLength <= 0) {
            return false;
        }
        if (startX == targetX && startY == targetY) {
            if (buffer != null) {
                buffer.add((Object)Coord.get(startX, startY));
            }
            return true;
        }
        float currentBlockage = 1.0f;
        ax <<= 1;
        ay <<= 1;
        int signX = dx >> 31 | -dx >>> 31;
        int signY = dy >> 31 | -dy >>> 31;
        int x = startX;
        int y = startY;
        int changeX = 0;
        int changeY = 0;
        int size = 0;
        if (ax >= ay) {
            int deltaY = ay - (ax >> 1);
            while (size < maxLength) {
                if (buffer != null) {
                    buffer.add((Object)Coord.get(x, y));
                }
                ++size;
                if (x == targetX) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentBlockage -= resistanceMap[x][y];
                }
                if (deltaY >= 0) {
                    y += signY;
                    deltaY -= ax;
                    ++changeY;
                }
                x += signX;
                deltaY += ay;
                if (!((float)(++changeX * changeX + changeY * changeY) >= dist * dist * currentBlockage + 0.5f)) continue;
                return false;
            }
        } else {
            int deltaX = ax - (ay >> 1);
            while (size < maxLength) {
                if (buffer != null) {
                    buffer.add((Object)Coord.get(x, y));
                }
                ++size;
                if (y == targetY) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentBlockage -= resistanceMap[x][y];
                }
                if (deltaX >= 0) {
                    x += signX;
                    deltaX -= ay;
                    ++changeX;
                }
                y += signY;
                deltaX += ax;
                if (!((float)(changeX * changeX + ++changeY * changeY) >= dist * dist * currentBlockage + 0.5f)) continue;
                return false;
            }
        }
        return false;
    }

    public static boolean reachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap) {
        return BresenhamLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap) {
        if (maxLength <= 0) {
            return false;
        }
        int dx = targetX - startX;
        int dy = targetY - startY;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        int dist = Math.max(ax, ay);
        if (startX == targetX && startY == targetY) {
            return true;
        }
        float decay = 1.0f / (float)dist;
        float currentForce = 1.0f;
        ax <<= 1;
        ay <<= 1;
        int signx = dx >> 31 | -dx >>> 31;
        int signy = dy >> 31 | -dy >>> 31;
        int x = startX;
        int y = startY;
        int traveled = 0;
        if (ax >= ay) {
            int deltay = ay - (ax >> 1);
            while (traveled < maxLength) {
                ++traveled;
                if (x == targetX) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentForce -= resistanceMap[x][y];
                }
                if ((currentForce -= decay) <= -0.001f) {
                    return false;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                x += signx;
                deltay += ay;
            }
        } else {
            int deltax = ax - (ay >> 1);
            while (traveled < maxLength) {
                ++traveled;
                if (y == targetY) {
                    return true;
                }
                if (x != startX || y != startY) {
                    currentForce -= resistanceMap[x][y];
                }
                if ((currentForce -= decay) <= -0.001f) {
                    return false;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                y += signy;
                deltax += ax;
            }
        }
        return false;
    }

    public static Coord[] lineArray(int startX, int startY, int targetX, int targetY) {
        return BresenhamLine.lineArray(startX, startY, targetX, targetY, Integer.MAX_VALUE);
    }

    public static Coord[] lineArray(int startX, int startY, int targetX, int targetY, int maxLength) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        int signx = dx >> 31 | -dx >>> 31;
        int signy = dy >> 31 | -dy >>> 31;
        dx = Math.abs(dx);
        int ax = dx << 1;
        dy = Math.abs(dy);
        int ay = dy << 1;
        int x = startX;
        int y = startY;
        if (ax >= ay) {
            int deltay = ay - (ax >> 1);
            Coord[] result = new Coord[Math.min(maxLength, dx + 1)];
            for (int i = 0; i <= dx && i < maxLength; ++i) {
                result[i] = Coord.get(x, y);
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                x += signx;
                deltay += ay;
            }
            return result;
        }
        int deltax = ax - (ay >> 1);
        Coord[] result = new Coord[Math.min(maxLength, dy + 1)];
        for (int i = 0; i <= dy && i < maxLength; ++i) {
            result[i] = Coord.get(x, y);
            if (deltax >= 0) {
                x += signx;
                deltax -= ay;
            }
            y += signy;
            deltax += ax;
        }
        return result;
    }

    @Override
    public ObjectList<Coord> getLastLine() {
        return this.lastLine;
    }

    @Override
    public ObjectList<Coord> drawLine(Coord a, Coord b) {
        this.lastLine.clear();
        return BresenhamLine.line(a.x, a.y, b.x, b.y, Integer.MAX_VALUE, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY) {
        this.lastLine.clear();
        return BresenhamLine.line(startX, startY, targetX, targetY, Integer.MAX_VALUE, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, int maxLength) {
        this.lastLine.clear();
        return BresenhamLine.line(startX, startY, targetX, targetY, maxLength, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, ObjectList<Coord> buffer) {
        return BresenhamLine.line(startX, startY, targetX, targetY, Integer.MAX_VALUE, buffer);
    }

    @Override
    public boolean isReachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return BresenhamLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, int maxLength, ObjectList<Coord> buffer) {
        return BresenhamLine.line(startX, startY, targetX, targetY, maxLength, buffer);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, maxLength, resistanceMap, buffer);
    }

    @Override
    public boolean isReachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap) {
        return BresenhamLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap) {
        return BresenhamLine.reachable(startX, startY, targetX, targetY, maxLength, resistanceMap);
    }

    @Override
    public Coord[] drawLineArray(Coord a, Coord b) {
        return BresenhamLine.lineArray(a.x, a.y, b.x, b.y, Integer.MAX_VALUE);
    }

    @Override
    public Coord[] drawLineArray(int startX, int startY, int targetX, int targetY) {
        return BresenhamLine.lineArray(startX, startY, targetX, targetY, Integer.MAX_VALUE);
    }

    @Override
    public Coord[] drawLineArray(int startX, int startY, int targetX, int targetY, int maxLength) {
        return BresenhamLine.lineArray(startX, startY, targetX, targetY, maxLength);
    }
}

