/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.ArrayTools;
import com.github.yellowstonegames.grid.Region;

public class CellularAutomaton {
    public Region current;
    private final Region[] neighbors = new Region[9];
    private int[][] sums;

    public CellularAutomaton() {
        this(new Region(64, 64));
    }

    public CellularAutomaton(int width, int height) {
        this(new Region(Math.max(1, width), Math.max(1, height)));
    }

    public CellularAutomaton(Region current) {
        this.current = current;
        for (int i = 0; i < 9; ++i) {
            this.neighbors[i] = current.copy();
        }
        this.sums = new int[current.width][current.height];
    }

    public CellularAutomaton remake(Region next) {
        if (next == null) {
            return this;
        }
        if (this.current.width != next.width || this.current.height != next.height) {
            this.sums = new int[next.width][next.height];
        } else {
            ArrayTools.fill((int[][])this.sums, (int)0);
        }
        this.current = next;
        for (int i = 0; i < 9; ++i) {
            this.neighbors[i].remake(this.current);
        }
        return this;
    }

    public Region runBasicSmoothing() {
        this.neighbors[0].remake(this.current).neighborUp();
        this.neighbors[1].remake(this.current).neighborDown();
        this.neighbors[2].remake(this.current).neighborLeft();
        this.neighbors[3].remake(this.current).neighborRight();
        this.neighbors[4].remake(this.current).neighborUpLeft();
        this.neighbors[5].remake(this.current).neighborUpRight();
        this.neighbors[6].remake(this.current).neighborDownLeft();
        this.neighbors[7].remake(this.current).neighborDownRight();
        this.neighbors[8].remake(this.current);
        ArrayTools.fill((int[][])this.sums, (int)0);
        Region.sumInto(this.sums, this.neighbors);
        return this.current.refill(this.sums, 5, 10);
    }

    public Region runGameOfLife() {
        this.neighbors[0].remake(this.current).neighborUp();
        this.neighbors[1].remake(this.current).neighborDown();
        this.neighbors[2].remake(this.current).neighborLeft();
        this.neighbors[3].remake(this.current).neighborRight();
        this.neighbors[4].remake(this.current).neighborUpLeft();
        this.neighbors[5].remake(this.current).neighborUpRight();
        this.neighbors[6].remake(this.current).neighborDownLeft();
        this.neighbors[7].remake(this.current).neighborDownRight();
        this.neighbors[8].remake(this.current);
        ArrayTools.fill((int[][])this.sums, (int)0);
        Region.sumInto(this.sums, this.neighbors);
        return this.current.refill(this.sums, 3).or(this.neighbors[0].refill(this.sums, 4).and(this.neighbors[8]));
    }

    public Region runDiagonalGapCleanup() {
        this.neighbors[0].remake(this.current.not()).neighborUp();
        this.neighbors[1].remake(this.current).neighborDown();
        this.neighbors[2].remake(this.current).neighborLeft();
        this.neighbors[3].remake(this.current).neighborRight();
        this.neighbors[4].remake(this.current.not()).neighborUpLeft();
        this.neighbors[5].remake(this.current).neighborUpRight();
        this.neighbors[6].remake(this.current).neighborDownLeft();
        this.neighbors[7].remake(this.current).neighborDownRight();
        this.current.andNot(this.neighbors[4].and(this.neighbors[0]).and(this.neighbors[2]));
        this.current.andNot(this.neighbors[5].and(this.neighbors[0]).and(this.neighbors[3]));
        this.current.andNot(this.neighbors[6].and(this.neighbors[1]).and(this.neighbors[2]));
        this.current.andNot(this.neighbors[7].and(this.neighbors[1]).and(this.neighbors[3]));
        return this.current;
    }

    public Region runDiagonalGapWiden() {
        this.neighbors[0].remake(this.current).neighborUp();
        this.neighbors[1].remake(this.current).neighborDown();
        this.neighbors[2].remake(this.current).neighborLeft();
        this.neighbors[3].remake(this.current).neighborRight();
        this.neighbors[4].remake(this.current).neighborUpLeft();
        this.neighbors[5].remake(this.current).neighborUpRight();
        this.neighbors[6].remake(this.current).neighborDownLeft();
        this.neighbors[7].remake(this.current).neighborDownRight();
        this.current.or(this.neighbors[4].notAnd(this.neighbors[0]).and(this.neighbors[2]));
        this.current.or(this.neighbors[5].notAnd(this.neighbors[0]).and(this.neighbors[3]));
        this.current.or(this.neighbors[6].notAnd(this.neighbors[1]).and(this.neighbors[2]));
        this.current.or(this.neighbors[7].notAnd(this.neighbors[1]).and(this.neighbors[3]));
        return this.current;
    }
}

