/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.random.EnhancedRandom;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.Region;
import java.util.Collection;

public class ConvChain {
    public static final Region boulders = new Region((char[][])new char[][]{"...........##...".toCharArray(), "..##..##...##...".toCharArray(), "..##..##........".toCharArray(), ".........##..##.".toCharArray(), "...##.##.##..##.".toCharArray(), "...##.##........".toCharArray(), "##..............".toCharArray(), "##..##.##.......".toCharArray(), "....##.##...##..".toCharArray(), ".##.........##..".toCharArray(), ".##.##..........".toCharArray(), "....##...##.....".toCharArray(), ".........##.##..".toCharArray(), ".##...##....##..".toCharArray(), ".##...##........".toCharArray(), "................".toCharArray()}, '.');
    public static final Region cave = new Region((char[][])new char[][]{"################".toCharArray(), "####.####.######".toCharArray(), "###...##......##".toCharArray(), "##..........####".toCharArray(), "##............##".toCharArray(), "###............#".toCharArray(), "###..........###".toCharArray(), "####........####".toCharArray(), "####.........###".toCharArray(), "###...........##".toCharArray(), "##............##".toCharArray(), "##.............#".toCharArray(), "###.....##.....#".toCharArray(), "####...####..###".toCharArray(), "################".toCharArray(), "################".toCharArray()}, '.');
    public static final Region caves = new Region((char[][])new char[][]{"###.########.###".toCharArray(), "###.#######..###".toCharArray(), "##...######..###".toCharArray(), "#.....####....##".toCharArray(), "#..............#".toCharArray(), "........#.......".toCharArray(), "##.....###....##".toCharArray(), "###...#####..###".toCharArray(), "####..#####.####".toCharArray(), "####.#####...###".toCharArray(), "##....###.....##".toCharArray(), "#..............#".toCharArray(), ".......##.......".toCharArray(), "#.....###.....##".toCharArray(), "##....####....##".toCharArray(), "###.########.###".toCharArray()}, '.');
    public static final Region chess = new Region((char[][])new char[][]{".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray(), ".#.#.#.#.#.#.#.#".toCharArray(), "#.#.#.#.#.#.#.#.".toCharArray()}, '.');
    public static final Region lessRooms = new Region((char[][])new char[][]{"###.########.###".toCharArray(), "###.#####......#".toCharArray(), "###.#####......#".toCharArray(), "###.#####......#".toCharArray(), "##.............#".toCharArray(), "...######.......".toCharArray(), "##.######......#".toCharArray(), "##.######......#".toCharArray(), "##.########.####".toCharArray(), "##.########.####".toCharArray(), "##......###.####".toCharArray(), "........###.....".toCharArray(), "##...........###".toCharArray(), "##......####.###".toCharArray(), "##......####.###".toCharArray(), "###.########.###".toCharArray()}, '.');
    public static final Region maze = new Region((char[][])new char[][]{".....####...#..#".toCharArray(), ".###.#..#.######".toCharArray(), ".#...#.####...#.".toCharArray(), ".#####.#....#.##".toCharArray(), "...#...####.###.".toCharArray(), "######....#.#.##".toCharArray(), ".....#..#.#.#.#.".toCharArray(), "######..#...#.#.".toCharArray(), "........#####.##".toCharArray(), "###.###..#....#.".toCharArray(), "..#.#...########".toCharArray(), ".##.#.#.#..#.#..".toCharArray(), "....###.##.#.##.".toCharArray(), "##..#......#..##".toCharArray(), ".########..##..#".toCharArray(), "........#...#..#".toCharArray()}, '.');
    public static final Region quarterBlack = new Region((char[][])new char[][]{"####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray(), "####............".toCharArray()}, '.');
    public static final Region river = new Region((char[][])new char[][]{"......###.......".toCharArray(), "......###.......".toCharArray(), ".......###......".toCharArray(), ".......###......".toCharArray(), ".......###......".toCharArray(), "........###.....".toCharArray(), "........###.....".toCharArray(), "........###.....".toCharArray(), ".......###......".toCharArray(), ".......###......".toCharArray(), "......###.......".toCharArray(), "......###.......".toCharArray(), ".....###........".toCharArray(), ".....###........".toCharArray(), "......###.......".toCharArray(), "......###.......".toCharArray()}, '.');
    public static final Region rooms = new Region((char[][])new char[][]{"###.########.###".toCharArray(), "###.#####......#".toCharArray(), "#.....###......#".toCharArray(), "#.....###......#".toCharArray(), "#..............#".toCharArray(), "......###.......".toCharArray(), "#.....###......#".toCharArray(), "##.######......#".toCharArray(), "##.########.####".toCharArray(), "##.########.####".toCharArray(), "##......##....##".toCharArray(), "........##......".toCharArray(), "##............##".toCharArray(), "##......##....##".toCharArray(), "##......####.###".toCharArray(), "###.########.###".toCharArray()}, '.');
    public static final Region simpleMaze = new Region((char[][])new char[][]{"....".toCharArray(), ".###".toCharArray(), ".#.#".toCharArray(), ".###".toCharArray()}, '.');
    public static final Region simpleRooms = new Region((char[][])new char[][]{"#####.#####".toCharArray(), "#####.#####".toCharArray(), "##.......##".toCharArray(), "##.......##".toCharArray(), "##.......##".toCharArray(), "...........".toCharArray(), "##.......##".toCharArray(), "##.......##".toCharArray(), "##.......##".toCharArray(), "#####.#####".toCharArray(), "#####.#####".toCharArray()}, '.');
    public static final Region thickWalls = new Region((char[][])new char[][]{"#######.#######".toCharArray(), "#######.#######".toCharArray(), "#######.#######".toCharArray(), "#######.#######".toCharArray(), "####.......####".toCharArray(), "####.......####".toCharArray(), "####.......####".toCharArray(), "...............".toCharArray(), "####.......####".toCharArray(), "####.......####".toCharArray(), "####.......####".toCharArray(), "#######.#######".toCharArray(), "#######.#######".toCharArray(), "#######.#######".toCharArray(), "#######.#######".toCharArray()}, '.');
    public static final Region ruins = new Region((char[][])new char[][]{"#.#####..........#########......".toCharArray(), "#.#####..######.......########..".toCharArray(), "#.######.######..###............".toCharArray(), "#.....##.######......#######.##.".toCharArray(), "#......#.######.###.####.....##.".toCharArray(), "#...............###.###......##.".toCharArray(), "......####..........####........".toCharArray(), "#.##.......##.......####....####".toCharArray(), "#.########..#......#######..####".toCharArray(), "#.########........########..####".toCharArray(), "...###........##.#########......".toCharArray(), "...####.......############..####".toCharArray(), "...####.......####..#####...####".toCharArray(), "...####......######.#######.##..".toCharArray(), "#######....#.##.###.#######.....".toCharArray(), "#########.##.##.###.######..####".toCharArray(), "#########.#..##.###.........####".toCharArray(), "####.####.##.##.###...#.....####".toCharArray(), "###..####.##.##..###..#.##.#####".toCharArray(), "###..####.##.##..####.#.##.#####".toCharArray(), "####.##.#.##.###.####.#.##.###.#".toCharArray(), "#.##.......#.###.####.#....###.#".toCharArray(), ".......##.##..........########..".toCharArray(), "........#.##.###......#####.....".toCharArray(), "######.##.##.####.##..##########".toCharArray(), "######.##.....######..####...###".toCharArray(), "######.####...######..####...###".toCharArray(), "........###...######...###......".toCharArray(), "######.......####...........##.#".toCharArray(), "###.......########.#######...###".toCharArray(), "#######..#########.#######...###".toCharArray(), "#.#####..######....#####........".toCharArray()}, '.');
    public static final Region openRooms = new Region((char[][])new char[][]{"......#......#......##..........".toCharArray(), "......#.........................".toCharArray(), "....###...............####......".toCharArray(), "....###...##..........#..#...#..".toCharArray(), "..#####....#.....######..#...#..".toCharArray(), ".....####..########......#...###".toCharArray(), ".....####..####..........#....##".toCharArray(), ".....#........#.......######..##".toCharArray(), ".....#........###.....#....#####".toCharArray(), ".....#..##....###.....#....#####".toCharArray(), ".....#..#####.........#....#####".toCharArray(), ".....#..#####.........#....#####".toCharArray(), "######..#...###.......#.......##".toCharArray(), "........#...####......#.........".toCharArray(), "......###......#####..#.........".toCharArray(), "#.....###......#####..#######..#".toCharArray(), "#..#####.......#..###########..#".toCharArray(), "#..##.............#####........#".toCharArray(), "#..##.............#...#........#".toCharArray(), "#####.......#.....#...#........#".toCharArray(), "............#.....#####........#".toCharArray(), "............#..................#".toCharArray(), ".....########..................#".toCharArray(), "........###########......###....".toCharArray(), ".........####.....#......###....".toCharArray(), ".........####.....#...######....".toCharArray(), ".........###......#...#....#....".toCharArray(), ".......###........#...#....###..".toCharArray(), ".#########........#####....###..".toCharArray(), ".##...............############..".toCharArray(), ".##.................##..........".toCharArray(), ".######......#####..##..........".toCharArray()}, '.');
    public static final Region[] samples = new Region[]{boulders, cave, caves, chess, lessRooms, maze, quarterBlack, river, rooms, simpleMaze, simpleRooms, thickWalls, ruins, openRooms};

    private ConvChain() {
    }

    public static Region mapToSample(Region toFill, char[][] map, char ... yes) {
        if (map == null || map.length == 0) {
            return toFill;
        }
        if (yes == null || yes.length == 0) {
            return toFill.empty();
        }
        return toFill.refill(map, yes);
    }

    public static char[][] sampleToMap(Region sample, char on, char off) {
        if (sample == null || sample.width == 0 || sample.height == 0) {
            return new char[0][0];
        }
        return sample.toChars(on, off);
    }

    public static Region markSample(Region sample, Collection<Coord> points) {
        if (sample == null || sample.width == 0 || sample.height == 0) {
            return sample;
        }
        sample.addAll((Collection<? extends Coord>)points);
        return sample;
    }

    public static Region fill(Region field, Region sample, double temperature, int iterations, EnhancedRandom random) {
        return ConvChain.fill(field, sample, temperature, iterations, random, 3);
    }

    public static Region fill(Region field, Region sample, double temperature, int iterations, EnhancedRandom random, int order) {
        int k;
        if (field == null) {
            field = new Region(64, 64);
        }
        if (sample == null) {
            return field;
        }
        int size = Math.max(field.width, field.height);
        order = Math.min(Math.max(order, 2), 5);
        float[] weights = new float[1 << order * order];
        for (int x = 0; x < sample.width; ++x) {
            for (int y = 0; y < sample.height; ++y) {
                int n = ConvChain.index(sample, x, y, order, false, false, false);
                weights[n] = weights[n] + 1.0f;
                int n2 = ConvChain.index(sample, x, y, order, false, true, true);
                weights[n2] = weights[n2] + 1.0f;
                int n3 = ConvChain.index(sample, x, y, order, true, true, false);
                weights[n3] = weights[n3] + 1.0f;
                int n4 = ConvChain.index(sample, x, y, order, true, false, true);
                weights[n4] = weights[n4] + 1.0f;
                int n5 = ConvChain.index(sample, x, y, order, true, false, false);
                weights[n5] = weights[n5] + 1.0f;
                int n6 = ConvChain.index(sample, x, y, order, true, true, true);
                weights[n6] = weights[n6] + 1.0f;
                int n7 = ConvChain.index(sample, x, y, order, false, true, false);
                weights[n7] = weights[n7] + 1.0f;
                int n8 = ConvChain.index(sample, x, y, order, false, false, true);
                weights[n8] = weights[n8] + 1.0f;
            }
        }
        for (k = 0; k < weights.length; ++k) {
            if (!(weights[k] < 0.1f)) continue;
            weights[k] = 0.1f;
        }
        field.refill(random, size, size);
        for (k = 0; k < iterations * size * size; ++k) {
            int x = random.nextInt(size);
            int y = random.nextInt(size);
            double q = 1.0;
            for (int sy = y - order + 1; sy <= y + order - 1; ++sy) {
                for (int sx = x - order + 1; sx <= x + order - 1; ++sx) {
                    int ind = 0;
                    int difference = 0;
                    for (int dy = 0; dy < order; ++dy) {
                        for (int dx = 0; dx < order; ++dx) {
                            int X = sx + dx;
                            if (X < 0) {
                                X += size;
                            } else if (X >= size) {
                                X -= size;
                            }
                            int Y = sy + dy;
                            if (Y < 0) {
                                Y += size;
                            } else if (Y >= size) {
                                Y -= size;
                            }
                            boolean value = field.contains(X, Y);
                            int power = 1 << dy * order + dx;
                            if (value) {
                                ind += power;
                                if (X != x || Y != y) continue;
                                difference = power;
                                continue;
                            }
                            if (X != x || Y != y) continue;
                            difference = -power;
                        }
                    }
                    q *= (double)(weights[ind - difference] / weights[ind]);
                }
            }
            if (q >= 1.0) {
                field.toggle(x, y);
                continue;
            }
            if (temperature != 1.0) {
                q = Math.pow(q, 1.0 / temperature);
            }
            if (!(q > random.nextDouble())) continue;
            field.toggle(x, y);
        }
        return field;
    }

    private static int index(Region field, int x, int y, int order, boolean flipX, boolean flipY, boolean swap) {
        int result = 0;
        int width = field.width;
        int height = field.height;
        if (swap) {
            for (int i = 0; i < order; ++i) {
                for (int j = 0; j < order; ++j) {
                    if (!field.contains((height * 2 + (flipY ? -(y + j) : y + j)) % height, (width * 2 + (flipX ? -(x + i) : x + i)) % width)) continue;
                    result += 1 << j * order + i;
                }
            }
        } else {
            for (int i = 0; i < order; ++i) {
                for (int j = 0; j < order; ++j) {
                    if (!field.contains((width * 2 + (flipX ? -(x + i) : x + i)) % width, (height * 2 + (flipY ? -(y + j) : y + j)) % height)) continue;
                    result += 1 << j * order + i;
                }
            }
        }
        return result;
    }
}

