/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.grid.Direction;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Coord {
    public final int x;
    public final int y;
    private static @NonNull Coord[][] POOL = new Coord[259][259];

    protected Coord() {
        this(0, 0);
    }

    protected Coord(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static @NonNull Coord get(int x, int y) {
        if (x >= -3 && y >= -3 && x < POOL.length - 3 && y < POOL[x + 3].length - 3) {
            return POOL[x + 3][y + 3];
        }
        return new Coord(x, y);
    }

    public static double degrees(Coord from, Coord to) {
        return TrigTools.atan2Deg360((float)(to.y - from.y), (float)(to.x - from.x));
    }

    public Coord getLocation() {
        return this;
    }

    public Coord translate(int x, int y) {
        return Coord.get(this.x + x, this.y + y);
    }

    public Coord translateCapped(int x, int y, int width, int height) {
        return Coord.get(Math.min(Math.max(0, this.x + x), width - 1), Math.min(Math.max(0, this.y + y), height - 1));
    }

    public Coord add(Coord other) {
        return Coord.get(this.x + other.x, this.y + other.y);
    }

    public Coord add(int operand) {
        return Coord.get(this.x + operand, this.y + operand);
    }

    public Coord add(double operand) {
        return Coord.get((int)Math.round((double)this.x + operand), (int)Math.round((double)this.y + operand));
    }

    public Coord subtract(Coord other) {
        return Coord.get(this.x - other.x, this.y - other.y);
    }

    public Coord subtract(int operand) {
        return Coord.get(this.x - operand, this.y - operand);
    }

    public Coord subtract(double operand) {
        return Coord.get((int)Math.round((double)this.x - operand), (int)Math.round((double)this.y - operand));
    }

    public Coord multiply(Coord other) {
        return Coord.get(this.x * other.x, this.y * other.y);
    }

    public Coord multiply(int operand) {
        return Coord.get(this.x * operand, this.y * operand);
    }

    public Coord multiply(double operand) {
        return Coord.get((int)Math.round((double)this.x * operand), (int)Math.round((double)this.y * operand));
    }

    public Coord divide(Coord other) {
        return Coord.get(this.x / other.x, this.y / other.y);
    }

    public Coord divide(int operand) {
        return Coord.get(this.x / operand, this.y / operand);
    }

    public Coord divide(double operand) {
        return Coord.get((int)((double)this.x / operand), (int)((double)this.y / operand));
    }

    public Coord divideRounding(double operand) {
        return Coord.get((int)Math.round((double)this.x / operand), (int)Math.round((double)this.y / operand));
    }

    public Coord average(Coord other) {
        return Coord.get(Math.round((float)(this.x + other.x) / 2.0f), Math.round((float)(this.y + other.y) / 2.0f));
    }

    public Coord translate(Direction d) {
        return this.add(d.coord);
    }

    public Coord scale(int i) {
        return Coord.get(this.x * i, this.y * i);
    }

    public Coord scale(int i, int j) {
        return Coord.get(this.x * i, this.y * j);
    }

    public float distance(float x2, float y2) {
        return (float)Math.sqrt((x2 - (float)this.x) * (x2 - (float)this.x) + (y2 - (float)this.y) * (y2 - (float)this.y));
    }

    public float distance(Coord co) {
        return (float)Math.sqrt((co.x - this.x) * (co.x - this.x) + (co.y - this.y) * (co.y - this.y));
    }

    public float distanceSq(float x2, float y2) {
        return (x2 - (float)this.x) * (x2 - (float)this.x) + (y2 - (float)this.y) * (y2 - (float)this.y);
    }

    public float distanceSq(Coord co) {
        return (co.x - this.x) * (co.x - this.x) + (co.y - this.y) * (co.y - this.y);
    }

    public double distanceD(double x2, double y2) {
        return Math.sqrt((x2 - (double)this.x) * (x2 - (double)this.x) + (y2 - (double)this.y) * (y2 - (double)this.y));
    }

    public double distanceD(Coord co) {
        return Math.sqrt((co.x - this.x) * (co.x - this.x) + (co.y - this.y) * (co.y - this.y));
    }

    public double distanceSqD(double x2, double y2) {
        return (x2 - (double)this.x) * (x2 - (double)this.x) + (y2 - (double)this.y) * (y2 - (double)this.y);
    }

    public double distanceSqD(Coord co) {
        return (co.x - this.x) * (co.x - this.x) + (co.y - this.y) * (co.y - this.y);
    }

    public Coord makeEven() {
        return Coord.get(this.x & 0xFFFFFFFE, this.y & 0xFFFFFFFE);
    }

    public Coord makeOdd() {
        return Coord.get(this.x | 1, this.y | 1);
    }

    public boolean isAdjacent(Coord c) {
        switch (Math.abs(this.x - c.x)) {
            case 0: {
                return Math.abs(this.y - c.y) == 1;
            }
            case 1: {
                return this.y == c.y || Math.abs(this.y - c.y) == 1;
            }
        }
        return false;
    }

    public Direction toGoTo(Coord target) {
        return Direction.toGoTo(this, target);
    }

    public boolean isWithin(int width, int height) {
        return this.x >= 0 && this.y >= 0 && this.x < width && this.y < height;
    }

    public boolean isWithinRectangle(int minX, int minY, int maxX, int maxY) {
        return this.x >= minX && this.y >= minY && this.x < maxX && this.y < maxY;
    }

    public int getX() {
        return this.x;
    }

    public Coord setX(int x) {
        return Coord.get(x, this.y);
    }

    public int getY() {
        return this.y;
    }

    public Coord setY(int y) {
        return Coord.get(this.x, y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public int hashCode() {
        return this.x >= this.y ? this.x * (this.x + 8) - this.y + 12 : this.y * (this.y + 6) + this.x + 12;
    }

    public int denseHashCode() {
        return this.y + ((this.x + this.y) * (this.x + this.y + 1) >> 1);
    }

    public static int rosenbergStrongHashCode(int x, int y) {
        return x >= y ? x * (x + 8) - y + 12 : y * (y + 6) + x + 12;
    }

    public static int rosenbergStrongRandomizedHashCode(int x, int y) {
        int n = x >= y ? x * (x + 8) - y + 12 : y * (y + 6) + x + 12;
        return ((n ^ n >>> 1) * 648051 ^ 0xD1B54A35) * 1201299 ^ 0x91E10DA5;
    }

    public static int xoroHashCode(int x, int y) {
        int r = x ^ y;
        r ^= (x << 13 | x >>> 19) ^ r << 5 ^ (r << 28 | r >>> 4);
        r = x ^ (r << 11 | r >>> 21);
        return r ^ (r << 25 | r >>> 7);
    }

    public int encode() {
        return this.x + 256 << 16 ^ this.y + 256;
    }

    public static int pureEncode(int x, int y) {
        return x + 256 << 16 ^ y + 256;
    }

    public static Coord decode(int code) {
        return Coord.get((code >>> 16) - 256, (code & 0xFFFF) - 256);
    }

    public boolean equals(Object o) {
        if (o instanceof Coord) {
            Coord other = (Coord)o;
            return this.x == other.x && this.y == other.y;
        }
        return false;
    }

    public static int getCacheWidth() {
        return POOL.length - 3;
    }

    public static int getCacheHeight() {
        return POOL[0].length - 3;
    }

    public static void expandPoolTo(int width, int height) {
        Coord.expandPool(Math.max(0, width + 3 - POOL.length), Math.max(0, height + 3 - POOL[0].length));
    }

    public static void expandPool(int xIncrease, int yIncrease) {
        int j;
        int i;
        if (xIncrease < 0 || yIncrease < 0 || (xIncrease | yIncrease) == 0) {
            return;
        }
        int width = POOL.length;
        int height = POOL[0].length;
        Coord[][] POOL2 = new Coord[width + xIncrease][height + yIncrease];
        for (i = 0; i < width; ++i) {
            POOL2[i] = new Coord[height + yIncrease];
            System.arraycopy(POOL[i], 0, POOL2[i], 0, height);
            for (j = 0; j < height + yIncrease; ++j) {
                if (POOL2[i][j] != null) continue;
                POOL2[i][j] = new Coord(i - 3, j - 3);
            }
        }
        for (i = width; i < width + xIncrease; ++i) {
            POOL2[i] = new Coord[height + yIncrease];
            for (j = 0; j < height + yIncrease; ++j) {
                POOL2[i][j] = new Coord(i - 3, j - 3);
            }
        }
        POOL = POOL2;
    }

    public Coord interpolate(Coord end, float amountTraveled) {
        return Coord.get(this.x + Math.round((float)(end.x - this.x) * amountTraveled), this.y + Math.round((float)(end.y - this.y) * amountTraveled));
    }

    static {
        int width = POOL.length;
        int height = POOL[0].length;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Coord.POOL[i][j] = new Coord(i - 3, j - 3);
            }
        }
    }
}

