/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.ObjectFloatMap;
import com.github.tommyettinger.ds.ObjectFloatOrderedMap;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.yellowstonegames.grid.Coord;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoordFloatOrderedMap
extends ObjectFloatOrderedMap<Coord> {
    public CoordFloatOrderedMap() {
    }

    public CoordFloatOrderedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CoordFloatOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CoordFloatOrderedMap(ObjectFloatOrderedMap<? extends Coord> map) {
        super(map);
    }

    public CoordFloatOrderedMap(ObjectFloatMap<? extends Coord> map) {
        super(map);
    }

    public CoordFloatOrderedMap(Coord[] keys, float[] values) {
        super((Object[])keys, values);
    }

    public CoordFloatOrderedMap(Collection<? extends Coord> keys, PrimitiveCollection.OfFloat values) {
        super(keys, values);
    }

    public CoordFloatOrderedMap(ObjectFloatOrderedMap<? extends Coord> other, int offset, int count) {
        super(other, offset, count);
    }

    protected int place(Object item) {
        return item.hashCode() & this.mask;
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left == right;
    }

    public static CoordFloatOrderedMap with(Coord key0, Number value0) {
        CoordFloatOrderedMap map = new CoordFloatOrderedMap(1);
        map.put(key0, value0.floatValue());
        return map;
    }

    public static CoordFloatOrderedMap with(Coord key0, Number value0, Object ... rest) {
        CoordFloatOrderedMap map = new CoordFloatOrderedMap(1 + (rest.length >>> 1));
        map.put(key0, value0.floatValue());
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put((Coord)rest[i - 1], ((Number)rest[i]).floatValue());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static CoordFloatOrderedMap fromArray2D(float[][] array, float min, float max) {
        int width = array.length;
        CoordFloatOrderedMap map = new CoordFloatOrderedMap(width * array[0].length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < array[x].length; ++y) {
                float f = array[x][y];
                if (!(f >= min) || !(f <= max)) continue;
                map.put(Coord.get(x, y), f);
            }
        }
        return map;
    }
}

