/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.RotationTools;
import java.util.Arrays;

@Beta
public class CyclicNoise
implements INoise {
    protected int octaves;
    protected float total = 1.0f;
    protected float start = 1.0f;
    protected float frequency = 2.0f;
    protected final float lacunarity = 1.6f;
    protected final float gain = 0.625f;
    protected long seed;
    protected transient float[][][] rotations = new float[5][4][];
    protected transient float[][] inputs = new float[][]{new float[2], new float[3], new float[4], new float[5], new float[6]};
    protected transient float[][] outputs = new float[][]{new float[2], new float[3], new float[4], new float[5], new float[6]};
    private static final float radToIndex = 2607.5945f;

    public CyclicNoise() {
        this(3);
    }

    public CyclicNoise(int octaves) {
        this.setOctaves(octaves);
        this.setSeed(209934215531127L);
    }

    public CyclicNoise(long seed, int octaves) {
        this.setOctaves(octaves);
        this.setSeed(seed);
    }

    public CyclicNoise(long seed, int octaves, float frequency) {
        this.setOctaves(octaves);
        this.setSeed(seed, frequency);
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int octaves) {
        this.octaves = Math.max(1, octaves);
        this.start = 0.625f;
        this.total = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            this.start /= 0.625f;
            this.total += this.start;
        }
        this.total = 1.0f / this.total;
    }

    @Override
    public boolean canUseSeed() {
        return false;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed(seed, this.frequency);
    }

    public void setSeed(long seed, float frequency) {
        this.seed = seed;
        this.frequency = frequency;
        for (int i = 0; i < 4; ++i) {
            this.rotations[0][i] = RotationTools.randomRotation2D(seed);
            this.rotations[1][i] = RotationTools.randomRotation3D(seed, this.rotations[0][i]);
            this.rotations[2][i] = RotationTools.randomRotation4D(seed, this.rotations[1][i]);
            this.rotations[3][i] = RotationTools.randomRotation5D(seed, this.rotations[2][i]);
            this.rotations[4][i] = RotationTools.randomRotation6D(seed, this.rotations[3][i]);
        }
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.setSeed(this.seed, frequency);
    }

    @Override
    public String getTag() {
        return "CycN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '~' + this.octaves + '~' + this.frequency + '`';
    }

    @Override
    public CyclicNoise copy() {
        return new CyclicNoise(this.seed, this.octaves, this.frequency);
    }

    @Override
    public CyclicNoise deserializeFromString(String data) {
        if (data == null || data.length() < 5) {
            return this;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int octaves = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float freq = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1));
        this.setSeed(seed, freq);
        this.setOctaves(octaves);
        return this;
    }

    public static CyclicNoise recreateFromString(String data) {
        if (data == null || data.length() < 5) {
            return null;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int octaves = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float freq = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1));
        return new CyclicNoise(seed, octaves, freq);
    }

    @Override
    public float getNoise(float x, float y) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        x *= this.frequency;
        y *= this.frequency;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            this.inputs[0][0] = x + yy;
            this.inputs[0][1] = y + xx;
            Arrays.fill(this.outputs[0], 0.0f);
            RotationTools.rotate(this.inputs[0], this.rotations[0][i & 3], this.outputs[0]);
            xx = this.outputs[0][0];
            yy = this.outputs[0][1];
            int xs = (int)(xx * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)(yy * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[ys] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs]) * 0.25f)) * amp;
            x = xx * 1.6f;
            y = yy * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.625f;
        }
        return noise * this.total;
    }

    @Override
    public float getNoise(float x, float y, float z) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            float zz = TrigTools.sin((float)((z - 2.0f) * warpTrk)) * 0.3f;
            this.inputs[1][0] = x + zz;
            this.inputs[1][1] = y + xx;
            this.inputs[1][2] = z + yy;
            Arrays.fill(this.outputs[1], 0.0f);
            RotationTools.rotate(this.inputs[1], this.rotations[1][i & 3], this.outputs[1]);
            xx = this.outputs[1][0];
            yy = this.outputs[1][1];
            zz = this.outputs[1][2];
            int xs = (int)(xx * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)(yy * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            int zs = (int)(zz * 2607.5945f) & 0x3FFF;
            int zc = zs + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[zs] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs] + TrigTools.SIN_TABLE[zc] * TrigTools.SIN_TABLE[ys]) * 0.16666667f)) * amp;
            x = xx * 1.6f;
            y = yy * 1.6f;
            z = zz * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.625f;
        }
        return noise * this.total;
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            float zz = TrigTools.sin((float)((z - 2.0f) * warpTrk)) * 0.3f;
            float ww = TrigTools.sin((float)((w - 2.0f) * warpTrk)) * 0.3f;
            this.inputs[2][0] = x + ww;
            this.inputs[2][1] = y + xx;
            this.inputs[2][2] = z + yy;
            this.inputs[2][3] = w + zz;
            Arrays.fill(this.outputs[2], 0.0f);
            RotationTools.rotate(this.inputs[2], this.rotations[2][i & 3], this.outputs[2]);
            xx = this.outputs[2][0];
            yy = this.outputs[2][1];
            zz = this.outputs[2][2];
            ww = this.outputs[2][3];
            int xs = (int)(xx * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)(yy * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            int zs = (int)(zz * 2607.5945f) & 0x3FFF;
            int zc = zs + 4096 & 0x3FFF;
            int ws = (int)(ww * 2607.5945f) & 0x3FFF;
            int wc = ws + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[ws] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs] + TrigTools.SIN_TABLE[zc] * TrigTools.SIN_TABLE[ys] + TrigTools.SIN_TABLE[wc] * TrigTools.SIN_TABLE[zs]) * 0.125f)) * amp;
            x = xx * 1.6f;
            y = yy * 1.6f;
            z = zz * 1.6f;
            w = ww * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.625f;
        }
        return noise * this.total;
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            float zz = TrigTools.sin((float)((z - 2.0f) * warpTrk)) * 0.3f;
            float ww = TrigTools.sin((float)((w - 2.0f) * warpTrk)) * 0.3f;
            float uu = TrigTools.sin((float)((u - 2.0f) * warpTrk)) * 0.3f;
            this.inputs[3][0] = x + uu;
            this.inputs[3][1] = y + xx;
            this.inputs[3][2] = z + yy;
            this.inputs[3][3] = w + zz;
            this.inputs[3][4] = u + ww;
            Arrays.fill(this.outputs[3], 0.0f);
            RotationTools.rotate(this.inputs[3], this.rotations[3][i & 3], this.outputs[3]);
            xx = this.outputs[3][0];
            yy = this.outputs[3][1];
            zz = this.outputs[3][2];
            ww = this.outputs[3][3];
            uu = this.outputs[3][4];
            int xs = (int)(xx * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)(yy * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            int zs = (int)(zz * 2607.5945f) & 0x3FFF;
            int zc = zs + 4096 & 0x3FFF;
            int ws = (int)(ww * 2607.5945f) & 0x3FFF;
            int wc = ws + 4096 & 0x3FFF;
            int us = (int)(uu * 2607.5945f) & 0x3FFF;
            int uc = us + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[us] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs] + TrigTools.SIN_TABLE[zc] * TrigTools.SIN_TABLE[ys] + TrigTools.SIN_TABLE[wc] * TrigTools.SIN_TABLE[zs] + TrigTools.SIN_TABLE[uc] * TrigTools.SIN_TABLE[ws]) * 0.1f)) * amp;
            x = xx * 1.6f;
            y = yy * 1.6f;
            z = zz * 1.6f;
            w = ww * 1.6f;
            u = uu * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.625f;
        }
        return noise * this.total;
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            float zz = TrigTools.sin((float)((z - 2.0f) * warpTrk)) * 0.3f;
            float ww = TrigTools.sin((float)((w - 2.0f) * warpTrk)) * 0.3f;
            float uu = TrigTools.sin((float)((u - 2.0f) * warpTrk)) * 0.3f;
            float vv = TrigTools.sin((float)((v - 2.0f) * warpTrk)) * 0.3f;
            this.inputs[4][0] = x + vv;
            this.inputs[4][1] = y + xx;
            this.inputs[4][2] = z + yy;
            this.inputs[4][3] = w + zz;
            this.inputs[4][4] = u + ww;
            this.inputs[4][5] = v + uu;
            Arrays.fill(this.outputs[4], 0.0f);
            RotationTools.rotate(this.inputs[4], this.rotations[4][i & 3], this.outputs[4]);
            xx = this.outputs[4][0];
            yy = this.outputs[4][1];
            zz = this.outputs[4][2];
            ww = this.outputs[4][3];
            uu = this.outputs[4][4];
            vv = this.outputs[4][5];
            int xs = (int)(xx * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)(yy * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            int zs = (int)(zz * 2607.5945f) & 0x3FFF;
            int zc = zs + 4096 & 0x3FFF;
            int ws = (int)(ww * 2607.5945f) & 0x3FFF;
            int wc = ws + 4096 & 0x3FFF;
            int us = (int)(uu * 2607.5945f) & 0x3FFF;
            int uc = us + 4096 & 0x3FFF;
            int vs = (int)(vv * 2607.5945f) & 0x3FFF;
            int vc = vs + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[vs] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs] + TrigTools.SIN_TABLE[zc] * TrigTools.SIN_TABLE[ys] + TrigTools.SIN_TABLE[wc] * TrigTools.SIN_TABLE[zs] + TrigTools.SIN_TABLE[uc] * TrigTools.SIN_TABLE[ws] + TrigTools.SIN_TABLE[vc] * TrigTools.SIN_TABLE[us]) * 0.083333336f)) * amp;
            x = xx * 1.6f;
            y = yy * 1.6f;
            z = zz * 1.6f;
            w = ww * 1.6f;
            u = uu * 1.6f;
            v = vv * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.625f;
        }
        return noise * this.total;
    }

    public String toString() {
        return "CyclicNoise with seed: " + this.seed + ", octaves:" + this.octaves + ", frequency: " + this.frequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CyclicNoise that = (CyclicNoise)o;
        if (this.octaves != that.octaves) {
            return false;
        }
        if (Float.compare(that.frequency, this.frequency) != 0) {
            return false;
        }
        return this.seed == that.seed;
    }

    public int hashCode() {
        int result = this.octaves;
        result = 31 * result + (this.frequency != 0.0f ? Float.floatToIntBits(this.frequency) : 0);
        result = 31 * result + (int)(this.seed ^ this.seed >>> 32);
        return result;
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return 6;
    }
}

