/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.grid.Coord;

public enum Direction {
    UP(0, 1),
    DOWN(0, -1),
    LEFT(-1, 0),
    RIGHT(1, 0),
    UP_LEFT(-1, 1),
    UP_RIGHT(1, 1),
    DOWN_LEFT(-1, -1),
    DOWN_RIGHT(1, -1),
    NONE(0, 0);

    public static final Direction[] CARDINALS;
    public static final Direction[] CARDINALS_CLOCKWISE;
    public static final Direction[] CARDINALS_COUNTERCLOCKWISE;
    public static final Direction[] DIAGONALS;
    public static final Direction[] OUTWARDS;
    public static final Direction[] CLOCKWISE;
    public static final Direction[] COUNTERCLOCKWISE;
    public final int deltaX;
    public final int deltaY;
    public final Coord coord;

    public static Direction getDirection(int x, int y) {
        if ((x | y) == 0) {
            return NONE;
        }
        return COUNTERCLOCKWISE[(int)(TrigTools.atan2Turns((float)y, (float)x) * 8.0f + 6.5f) & 7];
    }

    public static Direction getRoughDirection(int x, int y) {
        x = x >> 31 | -x >>> 31;
        y = y >> 31 | -y >>> 31;
        switch (x) {
            case -1: {
                switch (y) {
                    case -1: {
                        return DOWN_LEFT;
                    }
                    case 1: {
                        return UP_LEFT;
                    }
                }
                return LEFT;
            }
            case 1: {
                switch (y) {
                    case -1: {
                        return DOWN_RIGHT;
                    }
                    case 1: {
                        return UP_RIGHT;
                    }
                }
                return RIGHT;
            }
        }
        switch (y) {
            case -1: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
        }
        return NONE;
    }

    public static Direction getCardinalDirection(int x, int y) {
        if ((x | y) == 0) {
            return NONE;
        }
        return CARDINALS_COUNTERCLOCKWISE[(int)(TrigTools.atan2Turns((float)y, (float)x) * 4.0f + 3.5f) & 3];
    }

    public static Direction toGoTo(Coord from, Coord to) {
        return Direction.getDirection(to.x - from.x, to.y - from.y);
    }

    public Direction clockwise() {
        switch (this) {
            case UP: {
                return UP_RIGHT;
            }
            case DOWN: {
                return DOWN_LEFT;
            }
            case LEFT: {
                return UP_LEFT;
            }
            case RIGHT: {
                return DOWN_RIGHT;
            }
            case UP_LEFT: {
                return UP;
            }
            case UP_RIGHT: {
                return RIGHT;
            }
            case DOWN_LEFT: {
                return LEFT;
            }
            case DOWN_RIGHT: {
                return DOWN;
            }
        }
        return NONE;
    }

    public Direction counterClockwise() {
        switch (this) {
            case UP: {
                return UP_LEFT;
            }
            case DOWN: {
                return DOWN_RIGHT;
            }
            case LEFT: {
                return DOWN_LEFT;
            }
            case RIGHT: {
                return UP_RIGHT;
            }
            case UP_LEFT: {
                return LEFT;
            }
            case UP_RIGHT: {
                return UP;
            }
            case DOWN_LEFT: {
                return DOWN;
            }
            case DOWN_RIGHT: {
                return RIGHT;
            }
        }
        return NONE;
    }

    public Direction opposite() {
        switch (this) {
            case UP: {
                return DOWN;
            }
            case DOWN: {
                return UP;
            }
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
            case UP_LEFT: {
                return DOWN_RIGHT;
            }
            case UP_RIGHT: {
                return DOWN_LEFT;
            }
            case DOWN_LEFT: {
                return UP_RIGHT;
            }
            case DOWN_RIGHT: {
                return UP_LEFT;
            }
        }
        return NONE;
    }

    public boolean isDiagonal() {
        return (this.deltaX & this.deltaY) != 0;
    }

    public boolean isCardinal() {
        return (this.deltaX + this.deltaY & 1) == 1;
    }

    public boolean hasUp() {
        switch (this) {
            case UP: 
            case UP_LEFT: 
            case UP_RIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDown() {
        switch (this) {
            case DOWN: 
            case DOWN_LEFT: 
            case DOWN_RIGHT: {
                return true;
            }
        }
        return false;
    }

    public boolean hasLeft() {
        switch (this) {
            case LEFT: 
            case UP_LEFT: 
            case DOWN_LEFT: {
                return true;
            }
        }
        return false;
    }

    public boolean hasRight() {
        switch (this) {
            case RIGHT: 
            case UP_RIGHT: 
            case DOWN_RIGHT: {
                return true;
            }
        }
        return false;
    }

    private Direction(int x, int y) {
        this.deltaX = x;
        this.deltaY = y;
        this.coord = Coord.get(x, y);
    }

    static {
        CARDINALS = new Direction[]{UP, DOWN, LEFT, RIGHT};
        CARDINALS_CLOCKWISE = new Direction[]{UP, RIGHT, DOWN, LEFT};
        CARDINALS_COUNTERCLOCKWISE = new Direction[]{UP, LEFT, DOWN, RIGHT};
        DIAGONALS = new Direction[]{UP_LEFT, UP_RIGHT, DOWN_LEFT, DOWN_RIGHT};
        OUTWARDS = new Direction[]{UP, DOWN, LEFT, RIGHT, UP_LEFT, UP_RIGHT, DOWN_LEFT, DOWN_RIGHT};
        CLOCKWISE = new Direction[]{UP, UP_RIGHT, RIGHT, DOWN_RIGHT, DOWN, DOWN_LEFT, LEFT, UP_LEFT};
        COUNTERCLOCKWISE = new Direction[]{UP, UP_LEFT, LEFT, DOWN_LEFT, DOWN, DOWN_RIGHT, RIGHT, UP_RIGHT};
    }
}

