/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.FourWheelRandom;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.Direction;

public class DrunkenWalk {
    private DrunkenWalk() {
    }

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY, int width, int height) {
        return DrunkenWalk.line(startX, startY, endX, endY, width, height, 0.75f, (EnhancedRandom)new FourWheelRandom());
    }

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY, int width, int height, float weight, EnhancedRandom rng) {
        return DrunkenWalk.line(startX, startY, endX, endY, width, height, weight, rng, (ObjectList<Coord>)new ObjectList(Math.abs(startX - endX) + Math.abs(startY - endY)));
    }

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY, int width, int height, float weight, EnhancedRandom rng, ObjectList<Coord> buffer) {
        Direction dir;
        if (buffer == null) {
            buffer = new ObjectList(Math.abs(startX - endX) + Math.abs(startY - endY));
        }
        Coord start = Coord.get(startX, startY);
        do {
            buffer.add((Object)start);
            dir = DrunkenWalk.stepWobbly(start.x, start.y, endX, endY, weight, width, height, rng);
            start = start.translate(dir);
        } while (start.x >= 1 && start.y >= 1 && start.x < width - 1 && start.y < height - 1 && dir != Direction.NONE);
        return buffer;
    }

    private static Direction stepWobbly(int currentX, int currentY, int targetX, int targetY, float weight, int width, int height, EnhancedRandom rng) {
        Direction dir;
        int dx = targetX - currentX;
        int dy = targetY - currentY;
        if (dx > 1) {
            dx = 1;
        }
        if (dx < -1) {
            dx = -1;
        }
        if (dy > 1) {
            dy = 1;
        }
        if (dy < -1) {
            dy = -1;
        }
        float r = rng.nextFloat();
        if (dx == 0 && dy == 0) {
            return Direction.NONE;
        }
        if (dx == 0 || dy == 0) {
            int dy2;
            int dx2 = 0;
            int n = dy2 = dx == 0 ? dy : dx;
            if (r >= weight * 0.5f) {
                if ((r -= weight * 0.5f) < (weight + (1.0f - weight) * 2.0f) * 0.16666667f) {
                    dx2 = -1;
                    dy2 = 0;
                } else if (r < (weight + (1.0f - weight) * 2.0f) * 0.33333334f) {
                    dx2 = 1;
                    dy2 = 0;
                } else {
                    dy2 = -dy2;
                }
            }
            dir = Direction.getCardinalDirection(dx2, dy2);
        } else {
            if (r < weight * 0.5f) {
                dy = 0;
            } else if (r < weight) {
                dx = 0;
            } else if (r < weight + (1.0f - weight) * 0.5f) {
                dx = -dx;
                dy = 0;
            } else {
                dx = 0;
                dy = -dy;
            }
            dir = Direction.getCardinalDirection(dx, dy);
        }
        if (currentX + dir.deltaX <= 0 || currentX + dir.deltaX >= width - 1) {
            if (currentY < targetY) {
                dir = Direction.DOWN;
            } else if (currentY > targetY) {
                dir = Direction.UP;
            }
        } else if (currentY + dir.deltaY <= 0 || currentY + dir.deltaY >= height - 1) {
            if (currentX < targetX) {
                dir = Direction.RIGHT;
            } else if (currentX > targetX) {
                dir = Direction.LEFT;
            }
        }
        return dir;
    }

    public static ObjectList<Coord> line(Coord start, Coord end, int width, int height) {
        return DrunkenWalk.line(start.x, start.y, end.x, end.y, width, height);
    }
}

