/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.ArrayTools;
import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.ds.ObjectDeque;
import com.github.tommyettinger.ds.ObjectList;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.Direction;
import com.github.yellowstonegames.grid.OrthoLine;
import com.github.yellowstonegames.grid.Radius;
import com.github.yellowstonegames.grid.Region;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FOV {
    private static final Direction[] ccw = new Direction[]{Direction.UP_RIGHT, Direction.UP_LEFT, Direction.DOWN_LEFT, Direction.DOWN_RIGHT, Direction.UP_RIGHT};
    private static final Direction[] ccw_full = new Direction[]{Direction.RIGHT, Direction.UP_RIGHT, Direction.UP, Direction.UP_LEFT, Direction.LEFT, Direction.DOWN_LEFT, Direction.DOWN, Direction.DOWN_RIGHT};
    private static final ObjectDeque<Coord> dq = new ObjectDeque(256);
    private static final Region lightWorkspace = new Region(256, 256);
    private static final ObjectList<Coord> neighbors = new ObjectList(8);
    private static final float[] directionRanges = new float[8];

    private FOV() {
    }

    public static float[][] reuseFOV(float[][] resistanceMap, float[][] light, int startx, int starty) {
        return FOV.reuseFOV(resistanceMap, light, startx, starty, 2.1474836E9f, Radius.CIRCLE);
    }

    public static float[][] reuseFOV(float[][] resistanceMap, float[][] light, int startx, int starty, float radius) {
        return FOV.reuseFOV(resistanceMap, light, startx, starty, radius, Radius.CIRCLE);
    }

    public static float[][] reuseFOV(float[][] resistanceMap, float[][] light, int startX, int startY, float radius, Radius radiusTechnique) {
        float decay = 1.0f / radius;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = Math.min(1.0f, radius);
        int width = light.length;
        int height = light[0].length;
        FOV.shadowCast(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCast(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        return light;
    }

    public static float[][] reuseFOVSymmetrical(float[][] resistanceMap, float[][] light, int startX, int startY, float radius, Radius radiusTechnique) {
        float decay = 1.0f / radius;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = Math.min(1.0f, radius);
        int width = light.length;
        int height = light[0].length;
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastSymmetrical(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        return light;
    }

    private static void shadowCastSymmetrical(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startX, int startY, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy, int minX, int minY, int maxX, int maxY) {
        float newStart = 0.0f;
        if (start < end) {
            return;
        }
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startX + deltaX * xx + deltaY * xy;
                int currentY = startY + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                float deltaRadius = radiusStrategy.radius(deltaX, deltaY);
                if (deltaRadius <= radius && FOV.shadowCastCheck(1, 1.0f, 0.0f, -xx, -xy, -yx, -yy, radius, currentX, currentY, map, minX, minY, maxX, maxY, startX, startY)) {
                    lightMap[currentX][currentY] = 1.0f - decay * deltaRadius;
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                FOV.shadowCastSymmetrical(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startX, startY, decay, lightMap, map, radiusStrategy, minX, minY, maxX, maxY);
                newStart = rightSlope;
            }
        }
    }

    public static float[][] reuseLOS(float[][] resistanceMap, float[][] light, int startX, int startY) {
        return FOV.reuseLOS(resistanceMap, light, startX, startY, 0, 0, light.length, light[0].length);
    }

    public static float[][] reuseLOS(float[][] resistanceMap, float[][] light, int startX, int startY, int minX, int minY, int maxX, int maxY) {
        float radius = light.length + light[0].length;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = 1.0f;
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, light, resistanceMap, minX, minY, maxX, maxY);
        return light;
    }

    public static Region reuseLOS(@NonNull Region blockingMap, @NonNull Region light, int startX, int startY) {
        return FOV.reuseLOS(blockingMap, light, startX, startY, 0, 0, light.width, light.height);
    }

    public static Region reuseLOS(@NonNull Region blockingMap, @NonNull Region light, int startX, int startY, int minX, int minY, int maxX, int maxY) {
        float radius = maxX - minX + (maxY - minY);
        light.clear();
        light.insert(startX, startY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        FOV.shadowCastBinary(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, light, blockingMap, minX, minY, maxX, maxY);
        return light;
    }

    public static float[][] reuseFOV(float[][] resistanceMap, float[][] light, int startX, int startY, float radius, Radius radiusTechnique, float angle, float span) {
        float decay = 1.0f / radius;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = Math.min(1.0f, radius);
        angle *= 0.0027777778f;
        angle -= (float)MathTools.fastFloor((float)angle);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span *= 0.0027777778f);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        light = FOV.shadowCastLimited(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, angle, span);
        return light;
    }

    public static float[][] reuseRippleFOV(float[][] resistanceMap, float[][] light, int x, int y, float radius, Radius radiusTechnique) {
        return FOV.reuseRippleFOV(resistanceMap, light, 2, x, y, radius, radiusTechnique);
    }

    public static float[][] reuseRippleFOV(float[][] resistanceMap, float[][] light, int rippleLooseness, int x, int y, float radius, Radius radiusTechnique) {
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[x][y] = Math.min(1.0f, radius);
        lightWorkspace.resizeAndEmpty(light.length, light[0].length);
        FOV.doRippleFOV(light, Math.min(Math.max(rippleLooseness, 1), 6), x, y, 1.0f / radius, radius, resistanceMap, radiusTechnique);
        return light;
    }

    public static float[][] reuseSoundField(float[][] resistanceMap, float[][] sound, int x, int y, float radius, Radius radiusTechnique) {
        return FOV.reuseRippleFOV(resistanceMap, sound, 6, x, y, radius, radiusTechnique);
    }

    public static float[][] reuseRippleFOV(float[][] resistanceMap, float[][] light, int rippleLooseness, int x, int y, float radius, Radius radiusTechnique, float angle, float span) {
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[x][y] = Math.min(1.0f, radius);
        lightWorkspace.resizeAndEmpty(light.length, light[0].length);
        angle *= 0.0027777778f;
        angle -= (float)MathTools.fastFloor((float)angle);
        FOV.doRippleFOV(light, Math.min(Math.max(rippleLooseness, 1), 6), x, y, 1.0f / radius, radius, resistanceMap, radiusTechnique, angle, span *= 0.0027777778f);
        return light;
    }

    public static float[][] bouncingLine(float[][] resistanceMap, float[][] light, int startX, int startY, float distance, float angle) {
        int dy;
        int dx;
        float rad = Math.max(1.0f, distance);
        float decay = 1.0f / rad;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = 1.0f;
        float s = TrigTools.sinDeg((float)angle);
        float c = TrigTools.cosDeg((float)angle);
        float deteriorate = 1.0f;
        int width = resistanceMap.length;
        int height = resistanceMap[0].length;
        int d = 1;
        while ((float)d <= rad && (dx = startX + Math.round(c * (float)d)) >= 0 && dx <= width && (dy = startY + Math.round(s * (float)d)) >= 0 && dy <= height && (deteriorate -= decay) > 0.0f) {
            light[dx][dy] = Math.min(light[dx][dy] + deteriorate, 1.0f);
            if (resistanceMap[dx][dy] >= 1.0f && deteriorate > decay) {
                startX = dx;
                startY = dy;
                d = 1;
                float flipX = resistanceMap[startX + Math.round(-c * (float)d)][dy];
                float flipY = resistanceMap[dx][startY + Math.round(-s * (float)d)];
                if (flipX >= 1.0f) {
                    s = -s;
                }
                if (!(flipY >= 1.0f)) continue;
                c = -c;
                continue;
            }
            ++d;
        }
        return light;
    }

    private static void doRippleFOV(float[][] lightMap, int ripple, int x, int y, float decay, float radius, float[][] map, Radius radiusStrategy) {
        dq.clear();
        int width = lightMap.length;
        int height = lightMap[0].length;
        dq.addLast((Object)Coord.get(x, y));
        while (!dq.isEmpty()) {
            Coord p = (Coord)dq.removeFirst();
            if (lightMap[p.x][p.y] <= 0.0f || lightWorkspace.contains(p)) continue;
            for (Direction dir : Direction.OUTWARDS) {
                float surroundingLight;
                int x2 = p.x + dir.deltaX;
                int y2 = p.y + dir.deltaY;
                if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height || radiusStrategy.radius(x, y, x2, y2) >= radius + 1.0f || !(lightMap[x2][y2] < (surroundingLight = FOV.nearRippleLight(x2, y2, ripple, x, y, decay, lightMap, map, radiusStrategy)))) continue;
                lightMap[x2][y2] = surroundingLight;
                if (!(map[x2][y2] < 1.0f)) continue;
                dq.addLast((Object)Coord.get(x2, y2));
            }
        }
    }

    private static void doRippleFOV(float[][] lightMap, int ripple, int x, int y, float decay, float radius, float[][] map, Radius radiusStrategy, float angle, float span) {
        dq.clear();
        int width = lightMap.length;
        int height = lightMap[0].length;
        dq.addLast((Object)Coord.get(x, y));
        while (!dq.isEmpty()) {
            Coord p = (Coord)dq.removeFirst();
            if (lightMap[p.x][p.y] <= 0.0f || lightWorkspace.contains(p)) continue;
            for (Direction dir : ccw_full) {
                float surroundingLight;
                int x2 = p.x + dir.deltaX;
                int y2 = p.y + dir.deltaY;
                if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height || radiusStrategy.radius(x, y, x2, y2) >= radius + 1.0f) continue;
                float newAngle = TrigTools.atan2Turns((float)(y2 - y), (float)(x2 - x)) - angle;
                if ((newAngle -= (float)MathTools.fastFloor((float)newAngle)) > span * 0.5f && newAngle < 1.0f - span * 0.5f || !(lightMap[x2][y2] < (surroundingLight = FOV.nearRippleLight(x2, y2, ripple, x, y, decay, lightMap, map, radiusStrategy)))) continue;
                lightMap[x2][y2] = surroundingLight;
                if (!(map[x2][y2] < 1.0f)) continue;
                dq.addLast((Object)Coord.get(x2, y2));
            }
        }
    }

    private static float nearRippleLight(int x, int y, int rippleNeighbors, int startx, int starty, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy) {
        if (x == startx && y == starty) {
            return 1.0f;
        }
        int width = lightMap.length;
        int height = lightMap[0].length;
        neighbors.clear();
        float tmpDistance = 0.0f;
        for (Direction di : Direction.OUTWARDS) {
            int x2 = x + di.deltaX;
            int y2 = y + di.deltaY;
            if (x2 < 0 || x2 >= width || y2 < 0 || y2 >= height) continue;
            tmpDistance = radiusStrategy.radius(startx, starty, x2, y2);
            int idx = 0;
            for (int i = 0; i < neighbors.size() && i <= rippleNeighbors; ++i) {
                Coord c = (Coord)neighbors.get(i);
                float testDistance = radiusStrategy.radius(startx, starty, c.x, c.y);
                if (tmpDistance < testDistance) break;
                ++idx;
            }
            neighbors.add(idx, (Object)Coord.get(x2, y2));
        }
        if (neighbors.isEmpty()) {
            return 0.0f;
        }
        int max = Math.min(rippleNeighbors, neighbors.size());
        float light = 0.0f;
        int lit = 0;
        int indirects = 0;
        for (int i = 0; i < max; ++i) {
            Coord p = (Coord)neighbors.get(i);
            if (!(lightMap[p.x][p.y] > 0.0f)) continue;
            ++lit;
            if (lightWorkspace.contains(p)) {
                ++indirects;
            }
            float dist = radiusStrategy.radius(x, y, p.x, p.y);
            light = Math.max(light, lightMap[p.x][p.y] - dist * decay - map[p.x][p.y]);
        }
        if (map[x][y] >= 1.0f || indirects >= lit) {
            lightWorkspace.insert(x, y);
        }
        return light;
    }

    private static void shadowCast(int xx, int xy, int yx, int yy, float radius, int startx, int starty, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy) {
        FOV.shadowCast(1, 1.0f, 0.0f, xx, xy, yx, yy, radius, startx, starty, decay, lightMap, map, radiusStrategy, 0, 0, lightMap.length, lightMap[0].length);
    }

    private static void shadowCastBinary(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, float[][] lightMap, float[][] blockMap, int minX, int minY, int maxX, int maxY) {
        float newStart = 0.0f;
        if (start < end) {
            return;
        }
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                lightMap[currentX][currentY] = 1.0f;
                if (blocked) {
                    if (blockMap[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(blockMap[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                FOV.shadowCastBinary(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, lightMap, blockMap, minX, minY, maxX, maxY);
                newStart = rightSlope;
            }
        }
    }

    private static void shadowCastBinary(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, Region lightMap, Region map, int minX, int minY, int maxX, int maxY) {
        if (start < end) {
            return;
        }
        float newStart = 0.0f;
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                lightMap.insert(currentX, currentY);
                if (blocked) {
                    if (map.contains(currentX, currentY)) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!map.contains(currentX, currentY) || !((float)distance < radius)) continue;
                blocked = true;
                FOV.shadowCastBinary(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, lightMap, map, minX, minY, maxX, maxY);
                newStart = rightSlope;
            }
        }
    }

    private static boolean shadowCastCheck(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, float[][] map, int minX, int minY, int maxX, int maxY, int targetX, int targetY) {
        float newStart = 0.0f;
        if (start < end) {
            return false;
        }
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                if (currentX == targetX && currentY == targetY) {
                    return true;
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                if (FOV.shadowCastCheck(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, map, minX, minY, maxX, maxY, targetX, targetY)) {
                    return true;
                }
                newStart = rightSlope;
            }
        }
        return false;
    }

    private static void shadowCast(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy, int minX, int minY, int maxX, int maxY) {
        float newStart = 0.0f;
        if (start < end) {
            return;
        }
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                float deltaRadius = radiusStrategy.radius(deltaX, deltaY);
                if (deltaRadius <= radius) {
                    lightMap[currentX][currentY] = 1.0f - decay * deltaRadius;
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                FOV.shadowCast(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, decay, lightMap, map, radiusStrategy, minX, minY, maxX, maxY);
                newStart = rightSlope;
            }
        }
    }

    private static float[][] shadowCastLimited(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy, float angle, float span) {
        float newStart = 0.0f;
        if (start < end) {
            return lightMap;
        }
        int width = lightMap.length;
        int height = lightMap[0].length;
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < width + height && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < 0 || currentY < 0 || currentX >= width || currentY >= height || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                float deltaRadius = radiusStrategy.radius(deltaX, deltaY);
                float at2 = Math.abs(angle - TrigTools.atan2Turns((float)(currentY - starty), (float)(currentX - startx)));
                if (deltaRadius <= radius && (at2 <= span * 0.5f || at2 >= 1.0f - span * 0.5f)) {
                    float bright;
                    lightMap[currentX][currentY] = bright = 1.0f - decay * deltaRadius;
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                lightMap = FOV.shadowCastLimited(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, decay, lightMap, map, radiusStrategy, angle, span);
                newStart = rightSlope;
            }
        }
        return lightMap;
    }

    public static float[][] reuseFOV(float[][] resistanceMap, float[][] light, int startX, int startY, float radius, Radius radiusTechnique, float angle, float forward, float sideForward, float side, float sideBack, float back) {
        FOV.directionRanges[0] = forward * radius;
        FOV.directionRanges[7] = FOV.directionRanges[1] = sideForward * radius;
        FOV.directionRanges[6] = FOV.directionRanges[2] = side * radius;
        FOV.directionRanges[5] = FOV.directionRanges[3] = sideBack * radius;
        FOV.directionRanges[4] = back * radius;
        radius = Math.max(1.0f, radius);
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = 1.0f;
        angle *= 0.0027777778f;
        angle -= (float)MathTools.fastFloor((float)angle);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        light = FOV.shadowCastPersonalized(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, light, resistanceMap, radiusTechnique, angle, directionRanges);
        return light;
    }

    private static float[][] shadowCastPersonalized(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startx, int starty, float[][] lightMap, float[][] map, Radius radiusStrategy, float angle, float[] directionRanges) {
        float newStart = 0.0f;
        if (start < end) {
            return lightMap;
        }
        int width = lightMap.length;
        int height = lightMap[0].length;
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < width + height && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int high;
                int low;
                int ia;
                float a;
                float adjRadius;
                int currentX = startx + deltaX * xx + deltaY * xy;
                int currentY = starty + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < 0 || currentY < 0 || currentX >= width || currentY >= height || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                float at2 = Math.abs(angle - TrigTools.atan2Turns((float)(currentY - starty), (float)(currentX - startx))) * 8.0f;
                float deltaRadius = radiusStrategy.radius(deltaX, deltaY);
                if (deltaRadius <= (adjRadius = (1.0f - (a = at2 - (float)(ia = (int)at2))) * directionRanges[low = ia & 7] + a * directionRanges[high = ia + 1 & 7])) {
                    lightMap[currentX][currentY] = 1.0f - deltaRadius / (adjRadius + 1.0f);
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < adjRadius)) continue;
                blocked = true;
                lightMap = FOV.shadowCastPersonalized(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startx, starty, lightMap, map, radiusStrategy, angle, directionRanges);
                newStart = rightSlope;
            }
        }
        return lightMap;
    }

    @Beta
    public static float[][] reuseFOVOrtho(float[][] resistanceMap, float[][] light, int startX, int startY, float radius, Radius radiusTechnique) {
        float decay = 1.0f / radius;
        ArrayTools.fill((float[][])light, (float)0.0f);
        light[startX][startY] = Math.min(1.0f, radius);
        int width = light.length;
        int height = light[0].length;
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 0, 1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 0, 1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 0, -1, -1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, -1, 0, 0, -1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, 0, -1, 1, 0, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        FOV.shadowCastOrtho(1, 1.0f, 0.0f, -1, 0, 0, 1, radius, startX, startY, decay, light, resistanceMap, radiusTechnique, 0, 0, width, height);
        return light;
    }

    private static void shadowCastOrtho(int row, float start, float end, int xx, int xy, int yx, int yy, float radius, int startX, int startY, float decay, float[][] lightMap, float[][] map, Radius radiusStrategy, int minX, int minY, int maxX, int maxY) {
        float newStart = 0.0f;
        if (start < end) {
            return;
        }
        boolean blocked = false;
        block0: for (int distance = row; (float)distance <= radius && distance < maxX - minX + maxY - minY && !blocked; ++distance) {
            int deltaY = -distance;
            for (int deltaX = -distance; deltaX <= 0; ++deltaX) {
                int currentX = startX + deltaX * xx + deltaY * xy;
                int currentY = startY + deltaX * yx + deltaY * yy;
                float leftSlope = ((float)deltaX - 0.5f) / ((float)deltaY + 0.5f);
                float rightSlope = ((float)deltaX + 0.5f) / ((float)deltaY - 0.5f);
                if (currentX < minX || currentY < minY || currentX >= maxX || currentY >= maxY || start < rightSlope) continue;
                if (end > leftSlope) continue block0;
                float deltaRadius = radiusStrategy.radius(deltaX, deltaY);
                if (deltaRadius <= radius && (OrthoLine.reachable(startX, startY, currentX, currentY, map) || OrthoLine.reachable(currentX, currentY, startX, startY, map))) {
                    lightMap[currentX][currentY] = 1.0f - decay * deltaRadius;
                }
                if (blocked) {
                    if (map[currentX][currentY] >= 1.0f) {
                        newStart = rightSlope;
                        continue;
                    }
                    blocked = false;
                    start = newStart;
                    continue;
                }
                if (!(map[currentX][currentY] >= 1.0f) || !((float)distance < radius)) continue;
                blocked = true;
                FOV.shadowCastOrtho(distance + 1, start, leftSlope, xx, xy, yx, yy, radius, startX, startY, decay, lightMap, map, radiusStrategy, minX, minY, maxX, maxY);
                newStart = rightSlope;
            }
        }
    }

    public static float[][] addFOVsInto(float[][] basis, float[][] addend) {
        for (int x = 0; x < basis.length && x < addend.length; ++x) {
            for (int y = 0; y < basis[x].length && y < addend[x].length; ++y) {
                basis[x][y] = Math.min(1.0f, basis[x][y] + addend[x][y]);
            }
        }
        return basis;
    }

    public static float[][] addFOVs(float[][] ... maps) {
        if (maps == null || maps.length == 0) {
            return new float[0][0];
        }
        float[][] map = ArrayTools.copy((float[][])maps[0]);
        for (int i = 1; i < maps.length; ++i) {
            for (int x = 0; x < map.length && x < maps[i].length; ++x) {
                for (int y = 0; y < map[x].length && y < maps[i][x].length; ++y) {
                    float[] fArray = map[x];
                    int n = y;
                    fArray[n] = fArray[n] + maps[i][x][y];
                }
            }
        }
        for (int x = 0; x < map.length; ++x) {
            for (int y = 0; y < map[x].length; ++y) {
                if (!(map[x][y] > 1.0f)) continue;
                map[x][y] = 1.0f;
            }
        }
        return map;
    }

    public static float[][] addFOVsInto(float[][] basis, float[][] ... maps) {
        if (maps == null || maps.length == 0) {
            return basis;
        }
        for (int i = 1; i < maps.length; ++i) {
            for (int x = 0; x < basis.length && x < maps[i].length; ++x) {
                for (int y = 0; y < basis[x].length && y < maps[i][x].length; ++y) {
                    float[] fArray = basis[x];
                    int n = y;
                    fArray[n] = fArray[n] + maps[i][x][y];
                }
            }
        }
        for (int x = 0; x < basis.length; ++x) {
            for (int y = 0; y < basis[x].length; ++y) {
                if (!(basis[x][y] > 1.0f)) continue;
                basis[x][y] = 1.0f;
            }
        }
        return basis;
    }

    public static float[][] addFOVs(Iterable<float[][]> maps) {
        int y;
        int x;
        if (maps == null) {
            return new float[0][0];
        }
        Iterator<float[][]> it = maps.iterator();
        if (!it.hasNext()) {
            return new float[0][0];
        }
        float[][] map = ArrayTools.copy((float[][])it.next());
        while (it.hasNext()) {
            float[][] t = it.next();
            for (x = 0; x < map.length && x < t.length; ++x) {
                for (y = 0; y < map[x].length && y < t[x].length; ++y) {
                    float[] fArray = map[x];
                    int n = y;
                    fArray[n] = fArray[n] + t[x][y];
                }
            }
        }
        for (x = 0; x < map.length; ++x) {
            for (y = 0; y < map[x].length; ++y) {
                if (!(map[x][y] > 1.0f)) continue;
                map[x][y] = 1.0f;
            }
        }
        return map;
    }

    public static float[][] mixVisibleFOVs(float[][] losMap, float[][] ... maps) {
        if (losMap == null || losMap.length == 0) {
            return FOV.addFOVs(maps);
        }
        int width = losMap.length;
        int height = losMap[0].length;
        float[][] map = new float[width][height];
        if (maps == null || maps.length == 0) {
            return map;
        }
        for (int i = 0; i < maps.length; ++i) {
            for (int x = 0; x < width && x < maps[i].length; ++x) {
                for (int y = 0; y < height && y < maps[i][x].length; ++y) {
                    if (!(losMap[x][y] > 1.0E-4f)) continue;
                    float[] fArray = map[x];
                    int n = y;
                    fArray[n] = fArray[n] + maps[i][x][y];
                }
            }
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!(map[x][y] > 1.0f)) continue;
                map[x][y] = 1.0f;
            }
        }
        return map;
    }

    public static float[][] mixVisibleFOVsInto(float[][] losMap, float[][] basis, float[][] ... maps) {
        if (losMap == null || losMap.length <= 0 || losMap[0].length <= 0) {
            return FOV.addFOVsInto(basis, maps);
        }
        int width = losMap.length;
        int height = losMap[0].length;
        float[][] map = new float[width][height];
        if (maps == null || maps.length == 0) {
            return map;
        }
        for (int i = 0; i < maps.length; ++i) {
            for (int x = 0; x < width && x < maps[i].length; ++x) {
                for (int y = 0; y < height && y < maps[i][x].length; ++y) {
                    if (!(losMap[x][y] > 1.0E-4f)) continue;
                    float[] fArray = map[x];
                    int n = y;
                    fArray[n] = fArray[n] + maps[i][x][y];
                }
            }
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!(map[x][y] > 1.0f)) continue;
                map[x][y] = 1.0f;
            }
        }
        return map;
    }

    public static float[][] mixVisibleFOVs(float[][] losMap, Iterable<float[][]> maps) {
        if (losMap == null || losMap.length == 0) {
            return FOV.addFOVs(maps);
        }
        int width = losMap.length;
        int height = losMap[0].length;
        float[][] map = new float[width][height];
        if (maps == null) {
            return map;
        }
        for (float[][] map1 : maps) {
            for (int x = 0; x < width && x < map1.length; ++x) {
                for (int y = 0; y < height && y < map1[x].length; ++y) {
                    if (!(losMap[x][y] > 1.0E-4f)) continue;
                    float[] fArray = map[x];
                    int n = y;
                    fArray[n] = fArray[n] + map1[x][y];
                    if (!(map[x][y] > 1.0f)) continue;
                    map[x][y] = 1.0f;
                }
            }
        }
        return map;
    }

    public static float[][] generateResistances(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        float[][] portion = new float[width][height];
        for (int i = 0; i < width; ++i) {
            block6: for (int j = 0; j < height; ++j) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case ' ': 
                    case '#': 
                    case '\u2500': 
                    case '\u2502': 
                    case '\u250c': 
                    case '\u2510': 
                    case '\u2514': 
                    case '\u2518': 
                    case '\u251c': 
                    case '\u2524': 
                    case '\u252c': 
                    case '\u2534': 
                    case '\u253c': {
                        portion[i][j] = 1.0f;
                        continue block6;
                    }
                    case '/': {
                        portion[i][j] = 0.15f;
                        continue block6;
                    }
                    case '+': {
                        portion[i][j] = 0.95f;
                        continue block6;
                    }
                    default: {
                        portion[i][j] = 0.0f;
                    }
                }
            }
        }
        return portion;
    }

    public static float[][] generateResistances3x3(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        float[][] portion = new float[width * 3][height * 3];
        int i = 0;
        int x = 0;
        while (i < width) {
            int j = 0;
            int y = 0;
            while (j < height) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case '#': {
                        portion[x + 2][y + 2] = 1.0f;
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 2][y] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        portion[x][y] = 1.0f;
                        break;
                    }
                    case '\u251c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2524': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2534': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u252c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u250c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2510': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2514': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2518': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2502': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2500': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2574': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2575': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2576': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2577': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u253c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '/': {
                        portion[x + 2][y + 2] = 0.15f;
                        portion[x + 1][y + 2] = 0.15f;
                        portion[x][y + 2] = 0.15f;
                        portion[x + 2][y + 1] = 0.15f;
                        portion[x + 1][y + 1] = 0.15f;
                        portion[x][y + 1] = 0.15f;
                        portion[x + 2][y] = 0.15f;
                        portion[x + 1][y] = 0.15f;
                        portion[x][y] = 0.15f;
                        break;
                    }
                    case '+': {
                        portion[x + 2][y + 2] = 0.95f;
                        portion[x + 1][y + 2] = 0.95f;
                        portion[x][y + 2] = 0.95f;
                        portion[x + 2][y + 1] = 0.95f;
                        portion[x + 1][y + 1] = 0.95f;
                        portion[x][y + 1] = 0.95f;
                        portion[x + 2][y] = 0.95f;
                        portion[x + 1][y] = 0.95f;
                        portion[x][y] = 0.95f;
                    }
                }
                ++j;
                y += 3;
            }
            ++i;
            x += 3;
        }
        return portion;
    }

    public static float[][] generateSimpleResistances(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        float[][] portion = new float[width][height];
        for (int i = 0; i < width; ++i) {
            block4: for (int j = 0; j < height; ++j) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case ' ': 
                    case '#': 
                    case '+': 
                    case '\u2500': 
                    case '\u2502': 
                    case '\u250c': 
                    case '\u2510': 
                    case '\u2514': 
                    case '\u2518': 
                    case '\u251c': 
                    case '\u2524': 
                    case '\u252c': 
                    case '\u2534': 
                    case '\u253c': {
                        portion[i][j] = 1.0f;
                        continue block4;
                    }
                    default: {
                        portion[i][j] = 0.0f;
                    }
                }
            }
        }
        return portion;
    }

    public static float[][] generateSimpleResistances3x3(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        float[][] portion = new float[width * 3][height * 3];
        int i = 0;
        int x = 0;
        while (i < width) {
            int j = 0;
            int y = 0;
            while (j < height) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case '#': 
                    case '+': {
                        portion[x + 2][y + 2] = 1.0f;
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 2][y] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        portion[x][y] = 1.0f;
                        break;
                    }
                    case '\u251c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2524': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2534': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u252c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u250c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2510': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2514': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2518': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2502': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2500': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2574': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2575': {
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                        break;
                    }
                    case '\u2576': {
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u2577': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        break;
                    }
                    case '\u253c': {
                        portion[x + 1][y + 2] = 1.0f;
                        portion[x + 2][y + 1] = 1.0f;
                        portion[x + 1][y + 1] = 1.0f;
                        portion[x][y + 1] = 1.0f;
                        portion[x + 1][y] = 1.0f;
                    }
                }
                ++j;
                y += 3;
            }
            ++i;
            x += 3;
        }
        return portion;
    }

    public static float[][] generateSoundResistances(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        float[][] portion = new float[width][height];
        for (int i = 0; i < width; ++i) {
            block7: for (int j = 0; j < height; ++j) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case ' ': {
                        portion[i][j] = 1.0f;
                        continue block7;
                    }
                    case '#': 
                    case '\u2500': 
                    case '\u2502': 
                    case '\u250c': 
                    case '\u2510': 
                    case '\u2514': 
                    case '\u2518': 
                    case '\u251c': 
                    case '\u2524': 
                    case '\u252c': 
                    case '\u2534': 
                    case '\u253c': {
                        portion[i][j] = 0.55f;
                        continue block7;
                    }
                    case '/': {
                        portion[i][j] = 0.05f;
                        continue block7;
                    }
                    case '+': {
                        portion[i][j] = 0.3f;
                        continue block7;
                    }
                    default: {
                        portion[i][j] = 0.0f;
                    }
                }
            }
        }
        return portion;
    }
}

