/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.QuasiRandomTools;
import java.util.Arrays;

@Beta
public class FlanNoise
implements INoise {
    public long seed;
    public int dim;
    public float sharpness;
    public int detail;
    protected transient int vc;
    protected transient float inverse;
    protected transient float[] points;
    protected transient float[] input;
    protected transient float[][] vertices;

    public FlanNoise() {
        this(-77195684566545666L, 3);
    }

    public FlanNoise(long seed, int dimension) {
        this(seed, dimension, Math.max(2, dimension));
    }

    public FlanNoise(long seed, int dimension, float sharpness) {
        this(seed, dimension, sharpness, 3);
    }

    public FlanNoise(long seed, int dimension, float sharpness, int detail) {
        this.dim = Math.max(2, dimension);
        this.sharpness = 0.625f / sharpness;
        this.detail = detail;
        this.vc = this.dim * detail;
        this.points = new float[this.vc];
        this.input = new float[this.dim];
        this.vertices = new float[this.vc][this.dim];
        this.seed = seed;
        for (int v = 0; v < this.vc; ++v) {
            int d;
            double sum = 0.0;
            for (d = 0; d < this.dim; ++d) {
                double g = QuasiRandomTools.goldenFloat[this.dim - 1][d] * (float)(v + 1);
                g -= (double)((int)g);
                g = EnhancedRandom.probit((double)g);
                this.vertices[v][d] = (float)g;
                sum += g * g;
            }
            sum = 1.0 / Math.sqrt(sum);
            d = 0;
            while (d < this.dim) {
                float[] fArray = this.vertices[v];
                int n = d++;
                fArray[n] = (float)((double)fArray[n] * sum);
            }
        }
        this.inverse = 1.0f / (float)this.vc;
    }

    public FlanNoise reassign(long seed, int dimension, float sharpness, int detail) {
        boolean unchanged;
        this.sharpness = 0.625f / sharpness;
        boolean bl = unchanged = this.dim == Math.max(2, dimension) && this.detail == detail;
        if (!unchanged) {
            this.dim = Math.max(2, dimension);
            this.detail = detail;
            this.vc = this.dim * detail;
            this.points = new float[this.vc];
            this.input = new float[this.dim];
            this.vertices = new float[this.vc][this.dim];
            for (int v = 0; v < this.vc; ++v) {
                int d;
                double sum = 0.0;
                for (d = 0; d < this.dim; ++d) {
                    double g = QuasiRandomTools.goldenFloat[this.dim - 1][d] * (float)(v + 1);
                    g -= (double)((int)g);
                    g = EnhancedRandom.probit((double)g);
                    this.vertices[v][d] = (float)g;
                    sum += g * g;
                }
                sum = 1.0 / Math.sqrt(sum);
                d = 0;
                while (d < this.dim) {
                    float[] fArray = this.vertices[v];
                    int n = d++;
                    fArray[n] = (float)((double)fArray[n] * sum);
                }
            }
            this.inverse = 1.0f / (float)this.vc;
        }
        this.seed = seed;
        return this;
    }

    private void printDebugInfo() {
        int d;
        String dimNames = "xyzwuvmnopqrstabcdefghijkl";
        System.out.println("FlanNoise with dimension " + this.dim + " and detail " + this.detail + ": \n        float result = 0.0f;\n        float warp = 0.0f;");
        int v = this.vc - 1;
        for (d = 0; d < this.dim; ++d) {
            if ((double)this.vertices[v][d] == 0.0) continue;
            if (d == 0) {
                System.out.print("        float p = ");
            } else {
                System.out.print(" + ");
            }
            if ((double)this.vertices[v][d] == 1.0) {
                System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(d % "xyzwuvmnopqrstabcdefghijkl".length()));
                continue;
            }
            System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(d % "xyzwuvmnopqrstabcdefghijkl".length()) + " * " + this.vertices[v][d] + "f");
        }
        System.out.println(";");
        for (v = 0; v < this.vc; ++v) {
            if ((v & 1) == 0) {
                System.out.println("            result += warp = TrigTools.sin(p - warp) * TrigTools.SIN_TABLE[(seed ^= (seed << 21 | seed >>> 11) + 0x9E3779B9) + (int) ((p = ");
            } else {
                System.out.println("            result += warp = TrigTools.sin(p - warp) * TrigTools.SIN_TABLE[(seed >>> 18) + (int) ((p = ");
            }
            for (d = 0; d < this.dim; ++d) {
                if ((double)this.vertices[v][d] == 0.0) continue;
                if (d == 0) {
                    System.out.print("                            ");
                } else {
                    System.out.print(" + ");
                }
                if ((double)this.vertices[v][d] == 1.0) {
                    System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(d % "xyzwuvmnopqrstabcdefghijkl".length()));
                    continue;
                }
                System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(d % "xyzwuvmnopqrstabcdefghijkl".length()) + " * " + this.vertices[v][d] + "f");
            }
            System.out.println("\n                            ) + 4213f * warp) & 0x3FFF];");
        }
        System.out.println("        final float sharp = sharpnessInverse * (0.75f/" + this.dim + "f);\n        result *= " + 1.0f / (float)this.vc + ";\n        return result / (((sharp - 1f) * (1f - Math.abs(result))) + 1.0000001f);\n\n");
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public String getTag() {
        return "FlaN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '~' + this.dim + '~' + this.detail + '~' + BitConversion.floatToReversedIntBits((float)this.sharpness) + '`';
    }

    @Override
    public FlanNoise deserializeFromString(String data) {
        if (data == null || data.length() < 7) {
            return this;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        int n2 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int detail = DigitTools.intFromDec((CharSequence)data, (int)n2, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return this.reassign(seed, dim, 0.625f / sharp, detail);
    }

    public static FlanNoise recreateFromString(String data) {
        if (data == null || data.length() < 7) {
            return null;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        int n2 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int detail = DigitTools.intFromDec((CharSequence)data, (int)n2, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return new FlanNoise(seed, dim, 0.625f / sharp, detail);
    }

    @Override
    public FlanNoise copy() {
        return new FlanNoise(this.seed, this.dim, 0.625f / this.sharpness, this.detail);
    }

    public float getNoise(float ... args) {
        for (int v = 0; v < this.vc; ++v) {
            this.points[v] = 0.0f;
            for (int d = 0; d < this.dim; ++d) {
                int n = v;
                this.points[n] = this.points[n] + args[d] * this.vertices[v][d];
            }
        }
        float result = 0.0f;
        float warp = 0.5f;
        int seed = (int)(this.seed ^ this.seed >>> 32);
        seed ^= (seed << 21 | seed >>> 11) + -1640531527;
        warp = TrigTools.sin((float)(this.points[this.vc - 1] - warp)) * TrigTools.SIN_TABLE[seed + (int)(this.points[0] + 4213.0f * warp) & 0x3FFF];
        result += warp;
        for (int v = 1; v < this.vc; ++v) {
            seed ^= (seed << 21 | seed >>> 11) + -1640531527;
            warp = TrigTools.sin((float)(this.points[v - 1] - warp)) * TrigTools.SIN_TABLE[seed + (int)(this.points[v] + 4213.0f * warp) & 0x3FFF];
            result += warp;
        }
        return (result *= this.inverse) / ((this.sharpness - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public String toString() {
        return "FlanNoise in " + this.dim + "D with seed " + this.seed + ", detail " + this.detail + ", and sharpness " + 0.625f / this.sharpness;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlanNoise flanNoise = (FlanNoise)o;
        if (this.seed != flanNoise.seed) {
            return false;
        }
        if (this.dim != flanNoise.dim) {
            return false;
        }
        if (Float.compare(flanNoise.sharpness, this.sharpness) != 0) {
            return false;
        }
        return this.detail == flanNoise.detail;
    }

    public int hashCode() {
        int result = (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + this.dim;
        result = 31 * result + (this.sharpness != 0.0f ? BitConversion.floatToIntBits((float)this.sharpness) : 0);
        result = 31 * result + this.detail;
        return result;
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return this.dim;
    }

    @Override
    public boolean canUseSeed() {
        return false;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public float getNoise(float x, float y) {
        if (this.dim > 2) {
            Arrays.fill(this.input, 2, this.input.length, 0.0f);
        }
        if (this.dim >= 2) {
            this.input[0] = x;
            this.input[1] = y;
            return this.getNoise(this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 2D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z) {
        if (this.dim > 3) {
            Arrays.fill(this.input, 3, this.input.length, 0.0f);
        }
        if (this.dim >= 3) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            return this.getNoise(this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 3D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        if (this.dim > 4) {
            Arrays.fill(this.input, 4, this.input.length, 0.0f);
        }
        if (this.dim >= 4) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            return this.getNoise(this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 4D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        if (this.dim > 5) {
            Arrays.fill(this.input, 5, this.input.length, 0.0f);
        }
        if (this.dim >= 5) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            return this.getNoise(this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 5D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        if (this.dim > 6) {
            Arrays.fill(this.input, 6, this.input.length, 0.0f);
        }
        if (this.dim >= 6) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            this.input[5] = v;
            return this.getNoise(this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 6D noise.");
    }
}

