/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.core.IFlawed;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.IPointHash;

@Beta
public interface FlawedPointHash
extends IPointHash,
IFlawed {

    public static class LowLeaningHash
    extends IPointHash.IntImpl
    implements FlawedPointHash {
        public LowLeaningHash() {
        }

        public LowLeaningHash(int state) {
            super(state);
        }

        public int getState() {
            return this.state;
        }

        @Override
        public int hashWithState(int x, int y, int s) {
            s ^= x * 1583093 ^ y * 1195041;
            s ^= (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27);
            return s & ((s ^ 0xD1B54A35) * 1201299 ^ s >>> 11);
        }

        @Override
        public int hashWithState(int x, int y, int z, int s) {
            s ^= x * 1717929 ^ y * 1407281 ^ z * 1152805;
            s ^= (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27);
            return s & ((s ^ 0xD1B54A35) * 1201299 ^ s >>> 11);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int s) {
            s ^= x * 1796577 ^ y * 1539083 ^ z * 1318493 ^ w * 0x113C31;
            s ^= (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27);
            return s & ((s ^ 0xD1B54A35) * 1201299 ^ s >>> 11);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int s) {
            s ^= x * 1848160 ^ y * 1628730 ^ z * 1435354 ^ w * 1264936 ^ u * 1114752;
            s ^= (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27);
            return s & ((s ^ 0xD1B54A35) * 1201299 ^ s >>> 11);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int s) {
            s ^= x * 0x1CC1C5 ^ y * 1693615 ^ z * 1521973 ^ w * 1367727 ^ u * 1229113 ^ v * 1104547;
            s ^= (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27);
            return s & ((s ^ 0xD1B54A35) * 1201299 ^ s >>> 11);
        }
    }

    public static class FNVHash
    extends IPointHash.IntImpl
    implements FlawedPointHash {
        public FNVHash() {
        }

        public FNVHash(int state) {
            super(state);
        }

        public int getState() {
            return this.state;
        }

        @Override
        public int hashWithState(int x, int y, int state) {
            return ((state ^ 0x811C9DC5 ^ x) * 16777619 ^ y) * 16777619;
        }

        @Override
        public int hashWithState(int x, int y, int z, int state) {
            return (((state ^ 0x811C9DC5 ^ x) * 16777619 ^ y) * 16777619 ^ z) * 16777619;
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int state) {
            return ((((state ^ 0x811C9DC5 ^ x) * 16777619 ^ y) * 16777619 ^ z) * 16777619 ^ w) * 16777619;
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int state) {
            return (((((state ^ 0x811C9DC5 ^ x) * 16777619 ^ y) * 16777619 ^ z) * 16777619 ^ w) * 16777619 ^ u) * 16777619;
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int state) {
            return ((((((state ^ 0x811C9DC5 ^ x) * 16777619 ^ y) * 16777619 ^ z) * 16777619 ^ w) * 16777619 ^ u) * 16777619 ^ v) * 16777619;
        }
    }

    public static class SquishedCubeHash
    extends IPointHash.LongImpl
    implements FlawedPointHash {
        private int size = 6;
        private long mask = (1L << this.size) - 1L;

        public SquishedCubeHash() {
        }

        public SquishedCubeHash(long state) {
            super(state);
        }

        public SquishedCubeHash(long state, int size) {
            super(state);
            this.setSize(size);
        }

        public long getState() {
            return this.state;
        }

        public int getSize() {
            return 1 << this.size;
        }

        public void setSize(int size) {
            this.size = 32 - Integer.numberOfLeadingZeros(Math.max(1, size));
            this.mask = (1L << this.size) - 1L;
        }

        public long hashLongs(long x, long y, long s) {
            if ((x = x * x * -4521708957497675121L & this.mask) < (y = y * y * -7935046062780286179L & this.mask)) {
                long t = x;
                x = y;
                y = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + y);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            s = (s + -7046029254386353131L ^ s) * (y + x);
            return s;
        }

        public long hashLongs(long x, long y, long z, long s) {
            long t;
            x = x * x * -3335678366873096957L & this.mask;
            y = y * y * -6068174398545744893L & this.mask;
            z = z * z * -8306560040656073257L & this.mask >>> 1;
            if (x < y) {
                t = x;
                x = y;
                y = t;
            }
            if (x < z) {
                t = x;
                x = z;
                z = t;
            }
            if (y < z) {
                t = y;
                y = z;
                z = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + z);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            s = (s + -7046029254386353131L ^ s) * (z + y);
            return s;
        }

        public long hashLongs(long x, long y, long z, long w, long s) {
            long t;
            x = x * x * -2643881736870682267L & this.mask;
            y = y * y * -4908828816729415329L & this.mask;
            z = z * z * -6849152093303990923L & this.mask >>> 1;
            w = w * w * -8511378310903703927L & this.mask >>> 1;
            if (x < y) {
                t = x;
                x = y;
                y = t;
            }
            if (x < z) {
                t = x;
                x = z;
                z = t;
            }
            if (y < z) {
                t = y;
                y = z;
                z = t;
            }
            if (x < w) {
                t = x;
                x = w;
                w = t;
            }
            if (y < w) {
                t = y;
                y = w;
                w = t;
            }
            if (z < w) {
                t = z;
                z = w;
                w = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + w);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            w = (w + -7046029254386353131L ^ w) * (z + y);
            s = (s + -7046029254386353131L ^ s) * (w + z);
            return s;
        }

        public long hashLongs(long x, long y, long z, long w, long u, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, u, s), s), s), s);
        }

        public long hashLongs(long x, long y, long z, long w, long u, long v, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, this.hashLongs(u, v, s), s), s), s), s);
        }

        @Override
        public int hashWithState(int x, int y, int state) {
            return (int)(this.hashLongs(x, y, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int state) {
            return (int)(this.hashLongs(x, y, z, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int state) {
            return (int)(this.hashLongs(x, y, z, w, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, v, state) >>> 32);
        }
    }

    public static class CubeHash
    extends IPointHash.LongImpl
    implements FlawedPointHash {
        private int size = 6;
        private long mask = (1L << this.size) - 1L;

        public CubeHash() {
        }

        public CubeHash(long state) {
            super(state);
        }

        public CubeHash(long state, int size) {
            super(state);
            this.setSize(size);
        }

        public long getState() {
            return this.state;
        }

        public int getSize() {
            return 1 << this.size;
        }

        public void setSize(int size) {
            this.size = 32 - Integer.numberOfLeadingZeros(Math.max(1, size));
            this.mask = (1L << this.size) - 1L;
        }

        public long hashLongs(long x, long y, long s) {
            if ((x = x * x * -4521708957497675121L & this.mask) < (y = y * y * -7935046062780286179L & this.mask)) {
                long t = x;
                x = y;
                y = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + y);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            s = (s + -7046029254386353131L ^ s) * (y + x);
            return s;
        }

        public long hashLongs(long x, long y, long z, long s) {
            long t;
            x = x * x * -3335678366873096957L & this.mask;
            y = y * y * -6068174398545744893L & this.mask;
            z = z * z * -8306560040656073257L & this.mask;
            if (x < y) {
                t = x;
                x = y;
                y = t;
            }
            if (x < z) {
                t = x;
                x = z;
                z = t;
            }
            if (y < z) {
                t = y;
                y = z;
                z = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + z);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            s = (s + -7046029254386353131L ^ s) * (z + y);
            return s;
        }

        public long hashLongs(long x, long y, long z, long w, long s) {
            long t;
            x = x * x * -2643881736870682267L & this.mask;
            y = y * y * -4908828816729415329L & this.mask;
            z = z * z * -6849152093303990923L & this.mask;
            w = w * w * -8511378310903703927L & this.mask;
            if (x < y) {
                t = x;
                x = y;
                y = t;
            }
            if (x < z) {
                t = x;
                x = z;
                z = t;
            }
            if (y < z) {
                t = y;
                y = z;
                z = t;
            }
            if (x < w) {
                t = x;
                x = w;
                w = t;
            }
            if (y < w) {
                t = y;
                y = w;
                w = t;
            }
            if (z < w) {
                t = z;
                z = w;
                w = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + w);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            w = (w + -7046029254386353131L ^ w) * (z + y);
            s = (s + -7046029254386353131L ^ s) * (w + z);
            return s;
        }

        public long hashLongs(long x, long y, long z, long w, long u, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, u, s), s), s), s);
        }

        public long hashLongs(long x, long y, long z, long w, long u, long v, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, this.hashLongs(u, v, s), s), s), s), s);
        }

        @Override
        public int hashWithState(int x, int y, int state) {
            return (int)(this.hashLongs(x, y, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int state) {
            return (int)(this.hashLongs(x, y, z, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int state) {
            return (int)(this.hashLongs(x, y, z, w, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, v, state) >>> 32);
        }
    }

    public static class QuiltHash
    extends IPointHash.LongImpl
    implements FlawedPointHash {
        private int size = 6;
        private long mask = (1L << this.size) - 1L;

        public QuiltHash() {
        }

        public QuiltHash(long state) {
            super(state);
        }

        public QuiltHash(long state, int size) {
            super(state);
            this.setSize(size);
        }

        public long getState() {
            return this.state;
        }

        public int getSize() {
            return 1 << this.size;
        }

        public void setSize(int size) {
            this.size = 32 - Integer.numberOfLeadingZeros(Math.max(1, size));
            this.mask = (1L << this.size) - 1L;
        }

        public long hashLongs(long x, long y, long s) {
            s ^= (x >> this.size) * -4521708957497675121L;
            s ^= (y >> this.size) * -7935046062780286179L;
            x *= x;
            y *= y;
            if ((x = x >>> 1 & this.mask) < (y = y >>> 1 & this.mask)) {
                long t = x;
                x = y;
                y = t;
            }
            x = (x + -7046029254386353131L ^ x) * (s + y);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            s = (s + -7046029254386353131L ^ s) * (y + x);
            return s;
        }

        public long hashLongs(long x, long y, long z, long s) {
            return this.hashLongs(x, this.hashLongs(y, z, s), s);
        }

        public long hashLongs(long x, long y, long z, long w, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, w, s), s), s);
        }

        public long hashLongs(long x, long y, long z, long w, long u, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, u, s), s), s), s);
        }

        public long hashLongs(long x, long y, long z, long w, long u, long v, long s) {
            return this.hashLongs(x, this.hashLongs(y, this.hashLongs(z, this.hashLongs(w, this.hashLongs(u, v, s), s), s), s), s);
        }

        @Override
        public int hashWithState(int x, int y, int state) {
            return (int)(this.hashLongs(x, y, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int state) {
            return (int)(this.hashLongs(x, y, z, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int state) {
            return (int)(this.hashLongs(x, y, z, w, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, state) >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int state) {
            return (int)(this.hashLongs(x, y, z, w, u, v, state) >>> 32);
        }
    }

    public static class RugHash
    extends IPointHash.LongImpl
    implements FlawedPointHash {
        public RugHash() {
        }

        public RugHash(long state) {
            super(state);
        }

        public long getState() {
            return this.state;
        }

        public static int hashLongs(long x, long y, long s) {
            x = (x + -7046029254386353131L ^ x) * (s + y);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            s = (s + -7046029254386353131L ^ s) * (y + x);
            return (int)(s >>> 32);
        }

        public static int hashLongs(long x, long y, long z, long s) {
            x = (x + -7046029254386353131L ^ x) * (s + z);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            s = (s + -7046029254386353131L ^ s) * (z + y);
            return (int)(s >>> 32);
        }

        public static int hashLongs(long x, long y, long z, long w, long s) {
            x = (x + -7046029254386353131L ^ x) * (s + w);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            w = (w + -7046029254386353131L ^ w) * (z + y);
            s = (s + -7046029254386353131L ^ s) * (w + z);
            return (int)(s >>> 32);
        }

        public static int hashLongs(long x, long y, long z, long w, long u, long s) {
            x = (x + -7046029254386353131L ^ x) * (s + u);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            w = (w + -7046029254386353131L ^ w) * (z + y);
            u = (u + -7046029254386353131L ^ u) * (w + z);
            s = (s + -7046029254386353131L ^ s) * (u + w);
            return (int)(s >>> 32);
        }

        public static int hashLongs(long x, long y, long z, long w, long u, long v, long s) {
            x = (x + -7046029254386353131L ^ x) * (s + v);
            y = (y + -7046029254386353131L ^ y) * (x + s);
            z = (z + -7046029254386353131L ^ z) * (y + x);
            w = (w + -7046029254386353131L ^ w) * (z + y);
            u = (u + -7046029254386353131L ^ u) * (w + z);
            v = (v + -7046029254386353131L ^ v) * (u + w);
            s = (s + -7046029254386353131L ^ s) * (v + u);
            return (int)(s >>> 32);
        }

        @Override
        public int hashWithState(int x, int y, int state) {
            return RugHash.hashLongs(x, y, state);
        }

        @Override
        public int hashWithState(int x, int y, int z, int state) {
            return RugHash.hashLongs(x, y, z, state);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int state) {
            return RugHash.hashLongs(x, y, z, w, state);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int state) {
            return RugHash.hashLongs(x, y, z, w, u, state);
        }

        @Override
        public int hashWithState(int x, int y, int z, int w, int u, int v, int state) {
            return RugHash.hashLongs(x, y, z, w, u, v, state);
        }
    }
}

