/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.QuasiRandomTools;

@Beta
public class HighDimensionalValueNoise
implements INoise {
    public long seed;
    public int dim;
    protected transient float[] working;
    protected transient float[] input;
    protected transient long[] floors;
    public static final HighDimensionalValueNoise instance2D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[12][0], 2);
    public static final HighDimensionalValueNoise instance3D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[13][0], 3);
    public static final HighDimensionalValueNoise instance4D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[14][0], 4);
    public static final HighDimensionalValueNoise instance5D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[15][0], 5);
    public static final HighDimensionalValueNoise instance6D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[16][0], 6);
    public static final HighDimensionalValueNoise instance7D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[17][0], 7);
    public static final HighDimensionalValueNoise instance8D = new HighDimensionalValueNoise(QuasiRandomTools.goldenLong[18][0], 8);

    public HighDimensionalValueNoise() {
        this(-77195684566545666L, 3);
    }

    public HighDimensionalValueNoise(long seed, int dimension) {
        this.dim = Math.max(2, dimension);
        this.input = new float[this.dim];
        this.working = new float[this.dim + 1];
        this.floors = new long[this.dim + 1];
        this.seed = seed;
    }

    public HighDimensionalValueNoise reassign(long seed, int dimension) {
        if (this.dim != Math.max(2, dimension)) {
            this.dim = Math.max(2, dimension);
            this.input = new float[this.dim];
            this.working = new float[this.dim + 1];
            this.floors = new long[this.dim + 1];
        }
        this.seed = seed;
        return this;
    }

    @Override
    public String getTag() {
        return "HDVN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '~' + this.dim + '`';
    }

    @Override
    public HighDimensionalValueNoise deserializeFromString(String data) {
        if (data == null || data.length() < 5) {
            return this;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1));
        return this.reassign(seed, dim);
    }

    public static HighDimensionalValueNoise recreateFromString(String data) {
        if (data == null || data.length() < 5) {
            return null;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1));
        return new HighDimensionalValueNoise(seed, dim);
    }

    @Override
    public HighDimensionalValueNoise copy() {
        return new HighDimensionalValueNoise(this.seed, this.dim);
    }

    public float getNoise(float ... args) {
        return this.noise(args.length, args);
    }

    protected float noise(int dim, float ... args) {
        long[] gold = QuasiRandomTools.goldenLong[dim];
        long hashSeed = gold[dim] * this.seed;
        for (int i = 0; i < dim; ++i) {
            this.floors[i] = args[i] >= 0.0f ? (long)args[i] : (long)args[i] - 1L;
            this.working[i] = args[i] - (float)this.floors[i];
            int n = i;
            this.working[n] = this.working[n] * (this.working[i] * (3.0f - 2.0f * this.working[i]));
        }
        float sum = 0.0f;
        int limit = 1 << dim;
        for (int i = 0; i < limit; ++i) {
            float temp = 1.0f;
            long hash = hashSeed;
            for (int j = 0; j < dim; ++j) {
                int bit = i >>> j & 1;
                temp *= (float)bit + (float)(1 | -bit) * this.working[j];
                hash += (this.floors[j] - (long)bit) * gold[j];
            }
            hash ^= hash * hash | 1L;
            sum += temp * (float)(hash >> 32);
        }
        return sum * 4.656613E-10f;
    }

    protected float getNoise2D(float x, float y) {
        long[] gold = QuasiRandomTools.goldenLong[2];
        long hashSeed = gold[2] * this.seed;
        this.floors[0] = x >= 0.0f ? (long)x : (long)x - 1L;
        x -= (float)this.floors[0];
        x *= x * (3.0f - 2.0f * x);
        this.floors[1] = y >= 0.0f ? (long)y : (long)y - 1L;
        y -= (float)this.floors[1];
        y *= y * (3.0f - 2.0f * y);
        float sum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float temp = 1.0f;
            long hash = hashSeed;
            int bit = i & 1;
            temp *= (float)bit + (float)(1 | -bit) * x;
            hash += (this.floors[0] - (long)bit) * gold[0];
            bit = i >>> 1;
            hash += (this.floors[1] - (long)bit) * gold[1];
            hash ^= hash * hash | 1L;
            sum += (temp *= (float)bit + (float)(1 | -bit) * y) * (float)(hash >> 32);
        }
        return sum * 4.656613E-10f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighDimensionalValueNoise that = (HighDimensionalValueNoise)o;
        if (this.dim != that.dim) {
            return false;
        }
        return this.seed == that.seed;
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return this.dim;
    }

    @Override
    public boolean canUseSeed() {
        return true;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public float getNoise(float x, float y) {
        if (this.dim >= 2) {
            return this.getNoise2D(x, y);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 2D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z) {
        if (this.dim >= 3) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            return this.noise(3, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 3D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        if (this.dim >= 4) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            return this.noise(4, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 4D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        if (this.dim >= 5) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            return this.noise(5, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 5D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        if (this.dim >= 6) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            this.input[5] = v;
            return this.noise(6, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 6D noise.");
    }
}

