/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.grid.Coord;

public final class HilbertCurve {
    public static final int DEPTH = 8;
    private static final int BITS = 16;
    public static char[] hilbertX = new char[65536];
    public static char[] hilbertY = new char[65536];
    public static char[] hilbertDistances = new char[65536];
    public static char[] mooreX = new char[256];
    public static char[] mooreY = new char[256];
    public static char[] mooreDistances = new char[256];
    public static char[] hilbert3X = new char[512];
    public static char[] hilbert3Y = new char[512];
    public static char[] hilbert3Z = new char[512];
    public static char[] hilbert3Distances = new char[512];
    private static boolean initialized2D;
    private static boolean initialized3D;

    public static void init2D() {
        if (initialized2D) {
            return;
        }
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                HilbertCurve.computeHilbert2D(x, y);
            }
        }
        for (int i = 64; i < 128; ++i) {
            HilbertCurve.mooreX[i - 64] = hilbertX[i];
            HilbertCurve.mooreY[i - 64] = hilbertY[i];
            HilbertCurve.mooreDistances[HilbertCurve.mooreX[i - 64] + (HilbertCurve.mooreY[i - 64] << 4)] = (char)(i - 64);
            HilbertCurve.mooreX[i] = hilbertX[i];
            HilbertCurve.mooreY[i] = (char)(hilbertY[i] + 8);
            HilbertCurve.mooreDistances[HilbertCurve.mooreX[i] + (HilbertCurve.mooreY[i] << 4)] = (char)i;
            HilbertCurve.mooreX[i + 64] = (char)(15 - hilbertX[i]);
            HilbertCurve.mooreY[i + 64] = (char)(15 - hilbertY[i]);
            HilbertCurve.mooreDistances[HilbertCurve.mooreX[i + 64] + (HilbertCurve.mooreY[i + 64] << 4)] = (char)(i + 64);
            HilbertCurve.mooreX[i + 128] = (char)(15 - hilbertX[i]);
            HilbertCurve.mooreY[i + 128] = (char)(7 - hilbertY[i]);
            HilbertCurve.mooreDistances[HilbertCurve.mooreX[i + 128] + (HilbertCurve.mooreY[i + 128] << 4)] = (char)(i + 128);
        }
        initialized2D = true;
    }

    public static void init3D() {
        if (initialized3D) {
            return;
        }
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                for (int z = 0; z < 8; ++z) {
                    HilbertCurve.computeHilbert3D(x, y, z);
                }
            }
        }
        initialized3D = true;
    }

    private HilbertCurve() {
    }

    public static int grayEncode(int n) {
        return n ^ n >> 1;
    }

    public static int grayDecode(int n) {
        int p = n;
        while ((n >>= 1) != 0) {
            p ^= n;
        }
        return p;
    }

    public static int posToHilbert(int x, int y) {
        return hilbertDistances[x + (y << 8)] & 0xFFFF;
    }

    public static int posToHilbert3D(int x, int y, int z) {
        return hilbert3Distances[x | y << 3 | z << 6];
    }

    public static int posToMoore(int x, int y) {
        return mooreDistances[x + (y << 4)] & 0xFF;
    }

    private static int posToHilbertNoLUT(int x, int y) {
        int hilbert = 0;
        int remap = 180;
        int mcode = x >> 7 & 1 | (y >> 7 & 1) << 1;
        int hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = 0 + hcode;
        mcode = x >> 6 & 1 | (y >> 6 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 5 & 1 | (y >> 5 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 4 & 1 | (y >> 4 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 3 & 1 | (y >> 3 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 2 & 1 | (y >> 2 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 1 & 1 | (y >> 1 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x & 1 | (y & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        hilbert = (hilbert << 2) + hcode;
        return hilbert;
    }

    public static int mortonToHilbert(int morton) {
        int hilbert = 0;
        int remap = 180;
        int block = 16;
        while (block > 0) {
            int mcode = morton >> (block -= 2) & 3;
            int hcode = remap >> (mcode << 1) & 3;
            remap ^= -2113929176 >> (hcode << 3);
            hilbert = (hilbert << 2) + hcode;
        }
        return hilbert;
    }

    public static int hilbertToMorton(int hilbert) {
        return HilbertCurve.mortonEncode(hilbertX[hilbert], hilbertY[hilbert]);
    }

    public static Coord hilbertToCoord(int hilbert) {
        return Coord.get(hilbertX[hilbert], hilbertY[hilbert]);
    }

    public static Coord mooreToCoord(int moore) {
        return Coord.get(mooreX[moore & 0xFF], mooreY[moore & 0xFF]);
    }

    public static int coordToHilbert(Coord pt) {
        return HilbertCurve.posToHilbert(pt.x, pt.y);
    }

    public static int coordToMoore(Coord pt) {
        return HilbertCurve.posToMoore(pt.x, pt.y);
    }

    public static int mortonEncode3D(int index1, int index2, int index3) {
        index1 &= 0x1F;
        index2 &= 0x1F;
        index3 &= 0x1F;
        index1 *= 0x1041041;
        index2 *= 0x1041041;
        index3 *= 0x1041041;
        index1 &= 0x10204081;
        index2 &= 0x10204081;
        index3 &= 0x10204081;
        index1 *= 69905;
        index2 *= 69905;
        index3 *= 69905;
        return (index1 &= 0x12490000) >> 16 | (index2 &= 0x12490000) >> 15 | (index3 &= 0x12490000) >> 14;
    }

    public static int mortonBitDecode3D(int morton) {
        int value1 = morton;
        int value2 = value1 >>> 1;
        int value3 = value1 >>> 2;
        value1 &= 0x1249;
        value2 &= 0x1249;
        value3 &= 0x1249;
        value1 |= value1 >>> 2;
        value2 |= value2 >>> 2;
        value3 |= value3 >>> 2;
        value1 &= 0x10C3;
        value2 &= 0x10C3;
        value3 &= 0x10C3;
        value1 |= value1 >>> 4;
        value2 |= value2 >>> 4;
        value3 |= value3 >>> 4;
        value1 &= 0x100F;
        value2 &= 0x100F;
        value3 &= 0x100F;
        value1 |= value1 >>> 8;
        value2 |= value2 >>> 8;
        value3 |= value3 >>> 8;
        return (value1 &= 0x1F) | (value2 &= 0x1F) << 5 | (value3 &= 0x1F) << 10;
    }

    private static void computeHilbert2D(int x, int y) {
        int hilbert = 0;
        int remap = 180;
        int mcode = x >> 7 & 1 | (y >> 7 & 1) << 1;
        int hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = 0 + hcode;
        mcode = x >> 6 & 1 | (y >> 6 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 5 & 1 | (y >> 5 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 4 & 1 | (y >> 4 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 3 & 1 | (y >> 3 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 2 & 1 | (y >> 2 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x >> 1 & 1 | (y >> 1 & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        remap ^= -2113929176 >> (hcode << 3);
        hilbert = (hilbert << 2) + hcode;
        mcode = x & 1 | (y & 1) << 1;
        hcode = remap >> (mcode << 1) & 3;
        hilbert = (hilbert << 2) + hcode;
        HilbertCurve.hilbertDistances[x | y << 8] = (char)hilbert;
        HilbertCurve.hilbertX[hilbert] = (char)x;
        HilbertCurve.hilbertY[hilbert] = (char)y;
    }

    private static void computeHilbert3D(int x, int y, int z) {
        int hilbert = HilbertCurve.mortonEncode3D(x, y, z);
        int block = 6;
        int hcode = hilbert >> block & 7;
        int signs = 0;
        int shift = 0;
        while (block > 0) {
            int mcode = 0x20212021 >> (hcode <<= 2) & 3;
            shift = 72 >> 7 - shift - mcode & 3;
            signs = (signs | signs << 3) >> mcode;
            signs = (signs ^ 1398145792 >> hcode) & 7;
            hcode = mcode = hilbert >> (block -= 3) & 7;
            hcode = (hcode | hcode << 3) >> shift & 7;
            hilbert ^= (mcode ^ (hcode ^= signs)) << block;
        }
        hilbert ^= hilbert >> 1 & 0x92492492;
        hilbert ^= (hilbert & 0x92492492) >> 1;
        HilbertCurve.hilbert3X[hilbert] = (char)x;
        HilbertCurve.hilbert3Y[hilbert] = (char)y;
        HilbertCurve.hilbert3Z[hilbert] = (char)z;
        HilbertCurve.hilbert3Distances[x | y << 3 | z << 6] = (char)hilbert;
    }

    public static int getXMoore3D(int index, int n) {
        int hilbert = index & 0x1FF;
        int sector = index >> 9;
        if (sector < 2 * n) {
            return 7 - hilbert3X[hilbert];
        }
        return 8 + hilbert3X[hilbert];
    }

    public static int getYMoore3D(int index, int n) {
        int hilbert = index & 0x1FF;
        int sector = index >> 9;
        if (sector < n || sector >= 3 * n) {
            return 7 - hilbert3Y[hilbert];
        }
        return 8 + hilbert3Y[hilbert];
    }

    public static int getZMoore3D(int index, int n) {
        int hilbert = index & 0x1FF;
        int sector = index >> 9;
        if ((sector / n & 1) == 0) {
            return hilbert3Z[hilbert] + (sector % n << 3);
        }
        return (n << 3) - 1 - hilbert3Z[hilbert] - (sector % n << 3);
    }

    public static char zEncode(int index1, int index2) {
        index1 &= 0xFF;
        index2 &= 0xFF;
        index1 |= index1 << 4;
        index2 |= index2 << 4;
        index1 &= 0xF0F;
        index2 &= 0xF0F;
        index1 |= index1 << 2;
        index2 |= index2 << 2;
        index1 &= 0x3333;
        index2 &= 0x3333;
        index1 |= index1 << 1;
        index2 |= index2 << 1;
        return (char)((index1 &= 0x5555) | (index2 &= 0x5555) << 1);
    }

    public static int mortonEncode(int index1, int index2) {
        index1 &= 0xFF;
        index2 &= 0xFF;
        index1 |= index1 << 4;
        index2 |= index2 << 4;
        index1 &= 0xF0F;
        index2 &= 0xF0F;
        index1 |= index1 << 2;
        index2 |= index2 << 2;
        index1 &= 0x3333;
        index2 &= 0x3333;
        index1 |= index1 << 1;
        index2 |= index2 << 1;
        return (index1 &= 0x5555) | (index2 &= 0x5555) << 1;
    }

    public static Coord mortonDecode(int morton) {
        int value1 = morton;
        int value2 = value1 >> 1;
        value1 &= 0x5555;
        value2 &= 0x5555;
        value1 |= value1 >> 1;
        value2 |= value2 >> 1;
        value1 &= 0x3333;
        value2 &= 0x3333;
        value1 |= value1 >> 2;
        value2 |= value2 >> 2;
        value1 &= 0xF0F;
        value2 &= 0xF0F;
        value1 |= value1 >> 4;
        value2 |= value2 >> 4;
        return Coord.get(value1 &= 0xFF, value2 &= 0xFF);
    }

    public static Coord zDecode(int morton) {
        int value1 = morton & 0xFFFF;
        int value2 = value1 >> 1;
        value1 &= 0x5555;
        value2 &= 0x5555;
        value1 |= value1 >> 1;
        value2 |= value2 >> 1;
        value1 &= 0x3333;
        value2 &= 0x3333;
        value1 |= value1 >> 2;
        value2 |= value2 >> 2;
        value1 &= 0xF0F;
        value2 &= 0xF0F;
        value1 |= value1 >> 4;
        value2 |= value2 >> 4;
        return Coord.get(value1 &= 0xFF, value2 &= 0xFF);
    }
}

