/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.ObjectObjectMap;
import com.github.yellowstonegames.grid.CyclicNoise;
import com.github.yellowstonegames.grid.FlanNoise;
import com.github.yellowstonegames.grid.HighDimensionalValueNoise;
import com.github.yellowstonegames.grid.Noise;
import com.github.yellowstonegames.grid.NoiseWrapper;
import com.github.yellowstonegames.grid.PhantomNoise;
import com.github.yellowstonegames.grid.SimplexNoise;
import com.github.yellowstonegames.grid.SimplexNoiseScaled;
import com.github.yellowstonegames.grid.TaffyNoise;
import com.github.yellowstonegames.grid.ValueNoise;

public interface INoise {
    public int getMinDimension();

    public int getMaxDimension();

    public boolean canUseSeed();

    public float getNoise(float var1, float var2);

    public float getNoise(float var1, float var2, float var3);

    public float getNoise(float var1, float var2, float var3, float var4);

    public float getNoise(float var1, float var2, float var3, float var4, float var5);

    public float getNoise(float var1, float var2, float var3, float var4, float var5, float var6);

    default public void setSeed(long seed) {
        throw new UnsupportedOperationException("setSeed() is not supported.");
    }

    default public long getSeed() {
        throw new UnsupportedOperationException("getSeed() is not supported.");
    }

    default public String getTag() {
        return "(NO)";
    }

    default public String serializeToString() {
        throw new UnsupportedOperationException("serializeToString() is not supported.");
    }

    default public INoise deserializeFromString(String data) {
        throw new UnsupportedOperationException("deserializeFromString() is not supported.");
    }

    default public INoise copy() {
        throw new UnsupportedOperationException("copy() is not supported.");
    }

    default public float getNoiseWithSeed(float x, float y, long seed) {
        if (!this.canUseSeed()) {
            float s = (float)seed * 3.5527137E-15f;
            return this.getNoise(x + s, y + s);
        }
        long s = this.getSeed();
        this.setSeed(seed);
        float r = this.getNoise(x, y);
        this.setSeed(s);
        return r;
    }

    default public float getNoiseWithSeed(float x, float y, float z, long seed) {
        if (!this.canUseSeed()) {
            float s = (float)seed * 3.5527137E-15f;
            return this.getNoise(x + s, y + s, z + s);
        }
        long s = this.getSeed();
        this.setSeed(seed);
        float r = this.getNoise(x, y, z);
        this.setSeed(s);
        return r;
    }

    default public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        if (!this.canUseSeed()) {
            float s = (float)seed * 3.5527137E-15f;
            return this.getNoise(x + s, y + s, z + s, w + s);
        }
        long s = this.getSeed();
        this.setSeed(seed);
        float r = this.getNoise(x, y, z, w);
        this.setSeed(s);
        return r;
    }

    default public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        if (!this.canUseSeed()) {
            float s = (float)seed * 3.5527137E-15f;
            return this.getNoise(x + s, y + s, z + s, w + s, u + s);
        }
        long s = this.getSeed();
        this.setSeed(seed);
        float r = this.getNoise(x, y, z, w, u);
        this.setSeed(s);
        return r;
    }

    default public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        if (!this.canUseSeed()) {
            float s = (float)seed * 3.5527137E-15f;
            return this.getNoise(x + s, y + s, z + s, w + s, u + s, v + s);
        }
        long s = this.getSeed();
        this.setSeed(seed);
        float r = this.getNoise(x, y, z, w, u, v);
        this.setSeed(s);
        return r;
    }

    public static class Serializer {
        private static final ObjectObjectMap<String, INoise> NOISE_BY_TAG = new ObjectObjectMap(16);

        private Serializer() {
        }

        public static void register(INoise random) {
            String tag = random.getTag();
            if (!NOISE_BY_TAG.containsKey((Object)tag)) {
                NOISE_BY_TAG.put((Object)tag, (Object)random);
            } else {
                System.err.println("When registering an INoise, a duplicate tag failed to register: " + tag);
            }
        }

        public static INoise get(String tag) {
            INoise r = (INoise)NOISE_BY_TAG.get((Object)tag);
            if (r == null) {
                return null;
            }
            return r.copy();
        }

        public static String serialize(INoise noise) {
            return noise.getTag() + noise.serializeToString();
        }

        public static INoise deserialize(String data) {
            int idx = data.indexOf(96);
            if (idx == -1) {
                throw new IllegalArgumentException("String given cannot represent a valid INoise.");
            }
            String tagData = data.substring(0, idx);
            INoise root = (INoise)NOISE_BY_TAG.get((Object)tagData);
            if (root == null) {
                throw new RuntimeException("Tag in given data is invalid or unknown.");
            }
            return root.copy().deserializeFromString(data.substring(idx));
        }

        static {
            NOISE_BY_TAG.put((Object)"(NO)", null);
            Serializer.register(new CyclicNoise());
            Serializer.register(new FlanNoise());
            Serializer.register(new HighDimensionalValueNoise());
            Serializer.register(new Noise());
            Serializer.register(new PhantomNoise());
            Serializer.register(new SimplexNoise());
            Serializer.register(new SimplexNoiseScaled());
            Serializer.register(new TaffyNoise());
            Serializer.register(new ValueNoise());
            Serializer.register(new NoiseWrapper());
        }
    }
}

