/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.ArrayTools;
import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.yellowstonegames.core.DescriptiveColor;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.CoordObjectOrderedMap;
import com.github.yellowstonegames.grid.FOV;
import com.github.yellowstonegames.grid.Radiance;
import com.github.yellowstonegames.grid.Radius;
import com.github.yellowstonegames.grid.Region;
import java.util.Arrays;
import java.util.Objects;

public class LightingManager {
    public Radius radiusStrategy;
    public float[][] resistances;
    public float[][] fovResult;
    public float[][] losResult;
    public float[][] lightFromFOV;
    public float[][] lightingStrength;
    public int[][] colorLighting;
    public int[][] tempColorLighting;
    public int width;
    public int height;
    public int backgroundColor;
    public float viewerRange;
    public CoordObjectOrderedMap<Radiance> lights;
    public Region noticeable;

    public LightingManager() {
        this(new float[20][20], -8421632, Radius.CIRCLE, 4.0f);
    }

    public LightingManager(float[][] resistance) {
        this(resistance, -8421632, Radius.CIRCLE, 4.0f);
    }

    public LightingManager(float[][] resistance, String backgroundColor, Radius radiusStrategy, float viewerVisionRange) {
        this(resistance, DescriptiveColor.describeOklab((CharSequence)backgroundColor), radiusStrategy, viewerVisionRange);
    }

    public LightingManager(float[][] resistance, int backgroundColor, Radius radiusStrategy, float viewerVisionRange) {
        this.radiusStrategy = radiusStrategy;
        this.viewerRange = viewerVisionRange;
        this.backgroundColor = backgroundColor;
        this.resistances = resistance;
        this.width = this.resistances.length;
        this.height = this.resistances[0].length;
        this.fovResult = new float[this.width][this.height];
        this.lightFromFOV = new float[this.width][this.height];
        this.losResult = new float[this.width][this.height];
        this.colorLighting = ArrayTools.fill((int)-8421377, (int)this.width, (int)this.height);
        this.lightingStrength = new float[this.width][this.height];
        this.tempColorLighting = new int[this.width][this.height];
        Coord.expandPoolTo(this.width, this.height);
        this.lights = new CoordObjectOrderedMap(32);
        this.noticeable = new Region(this.width, this.height);
    }

    public LightingManager addLight(int x, int y, Radiance light) {
        return this.addLight(Coord.get(x, y), light);
    }

    public LightingManager addLight(Coord position, Radiance light) {
        this.lights.put(position, light);
        return this;
    }

    public LightingManager removeLight(int x, int y) {
        return this.removeLight(Coord.get(x, y));
    }

    public LightingManager removeLight(Coord position) {
        this.lights.remove(position);
        return this;
    }

    public LightingManager moveLight(int oldX, int oldY, int newX, int newY) {
        return this.moveLight(Coord.get(oldX, oldY), Coord.get(newX, newY));
    }

    public LightingManager moveLight(Coord oldPosition, Coord newPosition) {
        Radiance old = (Radiance)this.lights.get(oldPosition);
        if (old == null) {
            return this;
        }
        this.lights.alter(oldPosition, newPosition);
        return this;
    }

    public Radiance get(int x, int y) {
        return (Radiance)this.lights.get(Coord.get(x, y));
    }

    public Radiance get(Coord position) {
        return (Radiance)this.lights.get(position);
    }

    public void mixColoredLighting(float flare) {
        int[][] basis = this.colorLighting;
        int[][] other = this.tempColorLighting;
        float[][] basisStrength = this.lightingStrength;
        float[][] otherStrength = this.lightFromFOV;
        flare += 1.0f;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int o;
                float os;
                if (!(this.losResult[x][y] > 0.0f)) continue;
                if (this.resistances[x][y] >= 1.0f) {
                    os = 0.0f;
                    if (y > 0 && (this.losResult[x][y - 1] > 0.0f && otherStrength[x][y - 1] > 0.0f && this.resistances[x][y - 1] < 1.0f || x > 0 && this.losResult[x - 1][y - 1] > 0.0f && otherStrength[x - 1][y - 1] > 0.0f && this.resistances[x - 1][y - 1] < 1.0f || x < this.width - 1 && this.losResult[x + 1][y - 1] > 0.0f && otherStrength[x + 1][y - 1] > 0.0f && this.resistances[x + 1][y - 1] < 1.0f)) {
                        os = otherStrength[x][y];
                    }
                    if (y < this.height - 1 && (this.losResult[x][y + 1] > 0.0f && otherStrength[x][y + 1] > 0.0f && this.resistances[x][y + 1] < 1.0f || x > 0 && this.losResult[x - 1][y + 1] > 0.0f && otherStrength[x - 1][y + 1] > 0.0f && this.resistances[x - 1][y + 1] < 1.0f || x < this.width - 1 && this.losResult[x + 1][y + 1] > 0.0f && otherStrength[x + 1][y + 1] > 0.0f && this.resistances[x + 1][y + 1] < 1.0f)) {
                        os = otherStrength[x][y];
                    }
                    if (x > 0 && this.losResult[x - 1][y] > 0.0f && otherStrength[x - 1][y] > 0.0f && this.resistances[x - 1][y] < 1.0f) {
                        os = otherStrength[x][y];
                    }
                    if (x < this.width - 1 && this.losResult[x + 1][y] > 0.0f && otherStrength[x + 1][y] > 0.0f && this.resistances[x + 1][y] < 1.0f) {
                        os = otherStrength[x][y];
                    }
                    if (!(os > 0.0f)) continue;
                    o = other[x][y];
                } else {
                    os = otherStrength[x][y];
                    o = other[x][y];
                }
                if (os <= 0.0f || (float)(o & 0xFE000000) == 0.0f) continue;
                float bs = basisStrength[x][y];
                int b = basis[x][y];
                if ((b & 0xFF) == 255) {
                    basis[x][y] = o;
                    basisStrength[x][y] = Math.min(1.0f, bs + os * flare);
                    continue;
                }
                if ((o & 0xFF) != 255) {
                    int sL = b & 0xFF;
                    int sA = b >>> 8 & 0xFF;
                    int sB = b >>> 16 & 0xFF;
                    int sAlpha = b & 0xFE000000;
                    int eL = o & 0xFF;
                    int eA = o >>> 8 & 0xFF;
                    int eB = o >>> 16 & 0xFF;
                    int eAlpha = o >>> 25;
                    float change = ((os - bs) * 0.5f + 0.5f) * (float)eAlpha * 0.007874016f;
                    basis[x][y] = (int)((float)sL + change * (float)(eL - sL)) & 0xFF | ((int)((float)sA + change * (float)(eA - sA)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | sAlpha;
                    basisStrength[x][y] = Math.min(1.0f, bs + os * change * flare);
                    continue;
                }
                basisStrength[x][y] = Math.min(1.0f, bs + os * flare);
            }
        }
    }

    public void mixColoredLighting(float flare, int color) {
        int[][] basis = this.colorLighting;
        float[][] basisStrength = this.lightingStrength;
        float[][] otherStrength = this.lightFromFOV;
        flare += 1.0f;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int o;
                float os;
                if (!(this.losResult[x][y] > 0.0f)) continue;
                if (this.resistances[x][y] >= 1.0f) {
                    os = 0.0f;
                    if (y > 0 && (this.losResult[x][y - 1] > 0.0f && otherStrength[x][y - 1] > 0.0f && this.resistances[x][y - 1] < 1.0f || x > 0 && this.losResult[x - 1][y - 1] > 0.0f && otherStrength[x - 1][y - 1] > 0.0f && this.resistances[x - 1][y - 1] < 1.0f || x < this.width - 1 && this.losResult[x + 1][y - 1] > 0.0f && otherStrength[x + 1][y - 1] > 0.0f && this.resistances[x + 1][y - 1] < 1.0f)) {
                        os = otherStrength[x][y];
                    }
                    if (y < this.height - 1 && (this.losResult[x][y + 1] > 0.0f && otherStrength[x][y + 1] > 0.0f && this.resistances[x][y + 1] < 1.0f || x > 0 && this.losResult[x - 1][y + 1] > 0.0f && otherStrength[x - 1][y + 1] > 0.0f && this.resistances[x - 1][y + 1] < 1.0f || x < this.width - 1 && this.losResult[x + 1][y + 1] > 0.0f && otherStrength[x + 1][y + 1] > 0.0f && this.resistances[x + 1][y + 1] < 1.0f)) {
                        os = otherStrength[x][y];
                    }
                    if (x > 0 && this.losResult[x - 1][y] > 0.0f && otherStrength[x - 1][y] > 0.0f && this.resistances[x - 1][y] < 1.0f) {
                        os = otherStrength[x][y];
                    }
                    if (x < this.width - 1 && this.losResult[x + 1][y] > 0.0f && otherStrength[x + 1][y] > 0.0f && this.resistances[x + 1][y] < 1.0f) {
                        os = otherStrength[x][y];
                    }
                    if (!(os > 0.0f)) continue;
                    o = color;
                } else {
                    os = otherStrength[x][y];
                    if (os == 0.0f) continue;
                    o = color;
                }
                float bs = basisStrength[x][y];
                int b = basis[x][y];
                if ((b & 0xFF) == 255) {
                    basis[x][y] = o;
                    basisStrength[x][y] = Math.min(1.0f, bs + os * flare);
                    continue;
                }
                if ((o & 0xFF) != 255) {
                    int sL = b & 0xFF;
                    int sA = b >>> 8 & 0xFF;
                    int sB = b >>> 16 & 0xFF;
                    int sAlpha = b & 0xFE000000;
                    int eL = o & 0xFF;
                    int eA = o >>> 8 & 0xFF;
                    int eB = o >>> 16 & 0xFF;
                    int eAlpha = o >>> 25;
                    float change = ((os - bs) * 0.5f + 0.5f) * (float)eAlpha * 0.007874016f;
                    basis[x][y] = (int)((float)sL + change * (float)(eL - sL)) & 0xFF | ((int)((float)sA + change * (float)(eA - sA)) & 0xFF) << 8 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 16 | sAlpha;
                    basisStrength[x][y] = Math.min(1.0f, bs + os * change * flare);
                    continue;
                }
                basisStrength[x][y] = Math.min(1.0f, bs + os * flare);
            }
        }
    }

    public void update() {
        ArrayTools.fill((float[][])this.lightingStrength, (float)0.0f);
        ArrayTools.fill((int[][])this.colorLighting, (int)-8421377);
        int sz = this.lights.size();
        for (int i = 0; i < sz; ++i) {
            Radiance radiance;
            Coord pos = (Coord)this.lights.keyAt(i);
            if (!this.noticeable.contains(pos) || (radiance = (Radiance)this.lights.getAt(i)) == null) continue;
            FOV.reuseFOVSymmetrical(this.resistances, this.lightFromFOV, pos.x, pos.y, radiance.currentRange(), this.radiusStrategy);
            this.mixColoredLighting(radiance.flare, radiance.color);
        }
    }

    public void updateAll() {
        for (int x = 0; x < this.width; ++x) {
            block1: for (int y = 0; y < this.height; ++y) {
                int xx = Math.max(0, x - 1);
                for (int xi = 0; xi < 3 && xx < this.width; ++xi, ++xx) {
                    int yy = Math.max(0, y - 1);
                    for (int yi = 0; yi < 3 && yy < this.height; ++yi, ++yy) {
                        if (!(this.resistances[xx][yy] < 1.0f)) continue;
                        this.losResult[x][y] = 1.0f;
                        continue block1;
                    }
                }
            }
        }
        ArrayTools.fill((float[][])this.lightingStrength, (float)0.0f);
        ArrayTools.fill((int[][])this.colorLighting, (int)-8421377);
        int sz = this.lights.size();
        for (int i = 0; i < sz; ++i) {
            Coord pos = (Coord)this.lights.keyAt(i);
            Radiance radiance = (Radiance)this.lights.getAt(i);
            if (radiance == null) continue;
            FOV.reuseFOVSymmetrical(this.resistances, this.lightFromFOV, pos.x, pos.y, radiance.currentRange(), this.radiusStrategy);
            this.mixColoredLighting(radiance.flare, radiance.color);
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(this.losResult[x][y] > 0.0f)) continue;
                this.fovResult[x][y] = Math.min(Math.max(this.losResult[x][y] + this.lightingStrength[x][y], 0.0f), 1.0f);
            }
        }
    }

    public void updateUI(Coord pos, Radiance radiance) {
        this.updateUI(pos.x, pos.y, radiance);
    }

    public void updateUI(int lightX, int lightY, Radiance radiance) {
        FOV.reuseFOVSymmetrical(this.resistances, this.lightFromFOV, lightX, lightY, radiance.currentRange(), this.radiusStrategy);
        this.mixColoredLighting(radiance.flare, radiance.color);
    }

    public void draw(int[][] backgrounds) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(this.losResult[x][y] > 0.0f) || !(this.fovResult[x][y] > 0.0f)) continue;
                int current = backgrounds[x][y];
                if ((float)current == 0.0f) {
                    current = this.backgroundColor;
                }
                backgrounds[x][y] = DescriptiveColor.toRGBA8888((int)DescriptiveColor.lerpColorsBlended((int)current, (int)this.colorLighting[x][y], (float)(this.lightingStrength[x][y] * 0.4f)));
            }
        }
    }

    public float[][] calculateFOV(Coord viewer) {
        return this.calculateFOV(viewer.x, viewer.y);
    }

    public float[][] calculateFOV(int viewerX, int viewerY) {
        return this.calculateFOV(viewerX, viewerY, 0, 0, this.width, this.height);
    }

    public float[][] calculateFOV(int viewerX, int viewerY, int minX, int minY, int maxX, int maxY) {
        Radiance radiance;
        Coord pos;
        int i;
        minX = Math.min(Math.max(minX, 0), this.width);
        maxX = Math.min(Math.max(maxX, 0), this.width);
        minY = Math.min(Math.max(minY, 0), this.height);
        maxY = Math.min(Math.max(maxY, 0), this.height);
        FOV.reuseFOVSymmetrical(this.resistances, this.fovResult, viewerX, viewerY, this.viewerRange, this.radiusStrategy);
        ArrayTools.fill((float[][])this.lightingStrength, (float)0.0f);
        ArrayTools.fill((int[][])this.colorLighting, (int)-8421377);
        int sz = this.lights.size();
        float maxRange = 0.0f;
        for (i = 0; i < sz; ++i) {
            float range;
            pos = (Coord)this.lights.keyAt(i);
            radiance = (Radiance)this.lights.getAt(i);
            if (radiance == null || !((range = radiance.range) > maxRange) || !((float)pos.x + range >= (float)minX) || !((float)pos.x - range < (float)maxX) || !((float)pos.y + range >= (float)minY) || !((float)pos.y - range < (float)maxY)) continue;
            maxRange = range;
        }
        FOV.reuseLOS(this.resistances, this.losResult, viewerX, viewerY, minX, minY, maxX, maxY);
        this.noticeable.refill(this.losResult, 1.0E-4f, Float.POSITIVE_INFINITY).expand8way((int)Math.ceil(maxRange));
        for (i = 0; i < sz; ++i) {
            pos = (Coord)this.lights.keyAt(i);
            if (!this.noticeable.contains(pos) || (radiance = (Radiance)this.lights.getAt(i)) == null) continue;
            FOV.reuseFOVSymmetrical(this.resistances, this.lightFromFOV, pos.x, pos.y, radiance.range, this.radiusStrategy);
            this.mixColoredLighting(radiance.flare, radiance.color);
        }
        for (int x = Math.max(0, minX); x < maxX && x < this.width; ++x) {
            for (int y = Math.max(0, minY); y < maxY && y < this.height; ++y) {
                if (!(this.losResult[x][y] > 0.0f)) continue;
                this.fovResult[x][y] = Math.min(Math.max(this.fovResult[x][y] + this.lightingStrength[x][y], 0.0f), 1.0f);
            }
        }
        return this.fovResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LightingManager that = (LightingManager)o;
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (Float.compare(that.viewerRange, this.viewerRange) != 0) {
            return false;
        }
        if (this.radiusStrategy != that.radiusStrategy) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.resistances, (Object[])that.resistances)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.fovResult, (Object[])that.fovResult)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.losResult, (Object[])that.losResult)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.lightFromFOV, (Object[])that.lightFromFOV)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.lightingStrength, (Object[])that.lightingStrength)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.colorLighting, (Object[])that.colorLighting)) {
            return false;
        }
        if (!Objects.equals(this.lights, that.lights)) {
            return false;
        }
        return Objects.equals(this.noticeable, that.noticeable);
    }

    public int hashCode() {
        int result = this.radiusStrategy != null ? this.radiusStrategy.hashCode() : 0;
        result = 31 * result + Hasher.eligos.hash(this.resistances);
        result = 31 * result + Hasher.eligos.hash(this.fovResult);
        result = 31 * result + Hasher.eligos.hash(this.losResult);
        result = 31 * result + Hasher.eligos.hash(this.lightFromFOV);
        result = 31 * result + Hasher.eligos.hash(this.lightingStrength);
        result = 31 * result + Hasher.eligos.hash(this.colorLighting);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.backgroundColor;
        result = 31 * result + BitConversion.floatToIntBits((float)this.viewerRange);
        result = 31 * result + (this.lights != null ? this.lights.hashCode() : 0);
        result = 31 * result + (this.noticeable != null ? this.noticeable.hashCode() : 0);
        return result;
    }
}

