/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.grid.Region;

public final class LineTools {
    public static final char[] lightA0 = " \u2574\u2575\u2518\u2576\u2500\u2514\u2534\u2577\u2510\u2502\u2524\u250c\u252c\u251c\u253c".toCharArray();
    public static final char[] lightAlt = " \u2574\u2577\u2510\u2576\u2500\u250c\u252c\u2575\u2518\u2502\u2524\u2514\u2534\u251c\u253c".toCharArray();
    public static final char[] heavyA0 = " \u2578\u2579\u251b\u257a\u2501\u2517\u253b\u257b\u2513\u2503\u252b\u250f\u2533\u2523\u254b".toCharArray();
    public static final char[] heavyAlt = " \u2578\u257b\u2513\u257a\u2501\u250f\u2533\u2579\u251b\u2503\u252b\u2517\u253b\u2523\u254b".toCharArray();
    public static final char[] light0 = " \u2500\u2502\u2518\u2500\u2500\u2514\u2534\u2502\u2510\u2502\u2524\u250c\u252c\u251c\u253c".toCharArray();
    public static final char[] light = " \u2500\u2502\u2510\u2500\u2500\u250c\u252c\u2502\u2518\u2502\u2524\u2514\u2534\u251c\u253c".toCharArray();
    public static final char[] heavy0 = " \u2501\u2503\u251b\u2501\u2501\u2517\u253b\u2503\u2513\u2503\u252b\u250f\u2533\u2523\u254b".toCharArray();
    public static final char[] heavy = " \u2501\u2503\u2513\u2501\u2501\u250f\u2533\u2503\u251b\u2503\u252b\u2517\u253b\u2523\u254b".toCharArray();
    public static final long interiorSquare = 3996592820201627100L;
    public static final long exteriorSquare = 3843435299502462300L;
    public static final long interiorPlus = 243264708356606400L;
    public static final long exteriorPlus = 243260997341284800L;
    public static final long interiorSquareLarge = -281479271752228L;
    public static final long exteriorSquareLarge = 2814792717456732L;
    public static final long shallowInteriorSquareLarge = -8725857996636160L;
    public static final long shallowExteriorSquareLarge = 45036684907118592L;
    public static final long shallowerInteriorSquareLarge = -143873295517745152L;
    public static final long shallowerExteriorSquareLarge = 720677095449034752L;
    public static final long interiorPlusLarge = -281625334064128L;
    public static final long exteriorPlusLarge = 2818443606776832L;
    public static final long interiorCircleLarge = -281487865750528L;
    public static final long exteriorCircleLarge = 2815007528082432L;
    public static final long interiorDiamondLarge = -844695580131328L;
    public static final long exteriorDiamondLarge = 0x3C03C03C00C000L;
    private static final char[] wallLookup = new char[]{'#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u2502', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u2524', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u2500', '\u2534', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u2502', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u2500', '\u2518', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2500', '\u2510', '\u2524', '\u252c', '\u252c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2524', '\u252c', '\u253c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u2502', '\u2500', '\u2518', '\u2500', '\u2500', '\u2510', '\u2524', '\u252c', '\u2510', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2502', '\u252c', '\u251c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2500', '\u2510', '\u2502', '\u252c', '\u250c', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u251c', '\u2500', '\u2518', '\u2500', '\u2534', '\u2510', '\u2502', '\u2500', '\u2514', '#', '\u2502', '\u2500', '\u2514', '\u2502', '\u2502', '\u250c', '\u2502', '\u2500', '\u2518', '\u2500', '\u2500', '\u2510', '\u2502', '\u2500', ' '};

    private LineTools() {
    }

    public static char[][] decode4x4(long encoded) {
        return LineTools.decode4x4(encoded, light);
    }

    public static char[][] decode4x4(long encoded, char[] symbols) {
        char[][] v = new char[4][4];
        for (int i = 0; i < 16; ++i) {
            v[i & 3][i >> 2] = symbols[(int)(encoded >>> (i << 2) & 0xFL)];
        }
        return v;
    }

    public static char[][] decodeInto4x4(long encoded, char[] symbols, char[][] into, int startX, int startY) {
        for (int i = 0; i < 16; ++i) {
            into[(i & 3) + startX][(i >> 2) + startY] = symbols[(int)(encoded >>> (i << 2) & 0xFL)];
        }
        return into;
    }

    public static long encode4x4(char[][] decoded) {
        long v = 0L;
        block17: for (int i = 0; i < 16; ++i) {
            switch (decoded[i & 3][i >> 2]) {
                case '\u2500': 
                case '\u2501': {
                    v |= 5L << (i << 2);
                    continue block17;
                }
                case '\u2502': 
                case '\u2503': {
                    v |= 10L << (i << 2);
                    continue block17;
                }
                case '\u2518': 
                case '\u251b': {
                    v |= 3L << (i << 2);
                    continue block17;
                }
                case '\u2514': 
                case '\u2517': {
                    v |= 6L << (i << 2);
                    continue block17;
                }
                case '\u2510': 
                case '\u2513': {
                    v |= 9L << (i << 2);
                    continue block17;
                }
                case '\u250c': 
                case '\u250f': {
                    v |= 12L << (i << 2);
                    continue block17;
                }
                case '\u2534': 
                case '\u253b': {
                    v |= 7L << (i << 2);
                    continue block17;
                }
                case '\u2524': 
                case '\u252b': {
                    v |= 11L << (i << 2);
                    continue block17;
                }
                case '\u252c': 
                case '\u2533': {
                    v |= 13L << (i << 2);
                    continue block17;
                }
                case '\u251c': 
                case '\u2523': {
                    v |= 14L << (i << 2);
                    continue block17;
                }
                case '\u253c': 
                case '\u254b': {
                    v |= 15L << (i << 2);
                    continue block17;
                }
                case '\u2574': 
                case '\u2578': {
                    v |= 1L << (i << 2);
                    continue block17;
                }
                case '\u2575': 
                case '\u2579': {
                    v |= 2L << (i << 2);
                    continue block17;
                }
                case '\u2576': 
                case '\u257a': {
                    v |= 4L << (i << 2);
                    continue block17;
                }
                case '\u2577': 
                case '\u257b': {
                    v |= 8L << (i << 2);
                }
            }
        }
        return v;
    }

    public static long flipHorizontal4x4(long encoded) {
        long v = 0L;
        int i = 0;
        int i4 = 0;
        while (i < 16) {
            v |= (encoded >>> i4 & 0xAL | (encoded >>> i4 & 1L) << 2 | (encoded >>> i4 & 4L) >>> 2) << (i + 3 - ((i & 3) << 1) << 2);
            ++i;
            i4 += 4;
        }
        return v;
    }

    public static long flipVertical4x4(long encoded) {
        long v = 0L;
        int i = 0;
        int i4 = 0;
        while (i < 16) {
            v |= (encoded >>> i4 & 5L | (encoded >>> i4 & 2L) << 2 | (encoded >>> i4 & 8L) >>> 2) << (i + 12 - (i >> 2 << 3) << 2);
            ++i;
            i4 += 4;
        }
        return v;
    }

    public static long transpose4x4(long encoded) {
        long v = 0L;
        for (int i4 = 0; i4 < 64; i4 += 4) {
            v |= ((encoded >>> i4 & 5L) << 1 | (encoded >>> i4 & 0xAL) >>> 1) << (int)((long)(i4 >>> 2) & 0xCL | ((long)i4 & 0xCL) << 2);
        }
        return v;
    }

    public static long rotateClockwise(long encoded) {
        long v = 0L;
        for (int i4 = 0; i4 < 64; i4 += 4) {
            v |= ((encoded >>> i4 & 7L) << 1 | (encoded >>> i4 & 8L) >>> 3) << (int)((long)(~i4 >>> 2) & 0xCL | ((long)i4 & 0xCL) << 2);
        }
        return v;
    }

    public static long rotateCounterclockwise(long encoded) {
        long v = 0L;
        for (int i4 = 0; i4 < 64; i4 += 4) {
            v |= (encoded >>> i4 + 1 & 7L | (encoded >>> i4 & 1L) << 3) << (int)((long)(i4 >>> 2) & 0xCL | ((long)(~i4) & 0xCL) << 2);
        }
        return v;
    }

    public static char[][] pruneLines(char[][] map, Region seen, char[][] writeInto) {
        return LineTools.pruneLines(map, seen, light, writeInto);
    }

    public static char[][] pruneLines(char[][] map, Region seen, char[] symbols, char[][] writeInto) {
        int width = map.length;
        int height = map[0].length;
        for (int x = 0; x < width; ++x) {
            block18: for (int y = 0; y < height; ++y) {
                if (!seen.contains(x, y)) continue;
                int mask = 15;
                if (!seen.contains(x - 1, y)) {
                    mask ^= 1;
                }
                if (!seen.contains(x + 1, y)) {
                    mask ^= 4;
                }
                if (!seen.contains(x, y - 1)) {
                    mask ^= 2;
                }
                if (!seen.contains(x, y + 1)) {
                    mask ^= 8;
                }
                switch (map[x][y]) {
                    case '\u2500': 
                    case '\u2501': {
                        writeInto[x][y] = symbols[5 & mask];
                        continue block18;
                    }
                    case '\u2502': 
                    case '\u2503': {
                        writeInto[x][y] = symbols[0xA & mask];
                        continue block18;
                    }
                    case '\u2518': 
                    case '\u251b': {
                        writeInto[x][y] = symbols[9 & mask];
                        continue block18;
                    }
                    case '\u2514': 
                    case '\u2517': {
                        writeInto[x][y] = symbols[0xC & mask];
                        continue block18;
                    }
                    case '\u2510': 
                    case '\u2513': {
                        writeInto[x][y] = symbols[3 & mask];
                        continue block18;
                    }
                    case '\u250c': 
                    case '\u250f': {
                        writeInto[x][y] = symbols[6 & mask];
                        continue block18;
                    }
                    case '\u2534': 
                    case '\u253b': {
                        writeInto[x][y] = symbols[0xD & mask];
                        continue block18;
                    }
                    case '\u2524': 
                    case '\u252b': {
                        writeInto[x][y] = symbols[0xB & mask];
                        continue block18;
                    }
                    case '\u252c': 
                    case '\u2533': {
                        writeInto[x][y] = symbols[7 & mask];
                        continue block18;
                    }
                    case '\u251c': 
                    case '\u2523': {
                        writeInto[x][y] = symbols[0xE & mask];
                        continue block18;
                    }
                    case '\u253c': 
                    case '\u254b': {
                        writeInto[x][y] = symbols[0xF & mask];
                        continue block18;
                    }
                    case '\u2574': 
                    case '\u2578': {
                        writeInto[x][y] = symbols[1 & mask];
                        continue block18;
                    }
                    case '\u2575': 
                    case '\u2579': {
                        writeInto[x][y] = symbols[8 & mask];
                        continue block18;
                    }
                    case '\u2576': 
                    case '\u257a': {
                        writeInto[x][y] = symbols[4 & mask];
                        continue block18;
                    }
                    case '\u2577': 
                    case '\u257b': {
                        writeInto[x][y] = symbols[2 & mask];
                    }
                }
            }
        }
        return writeInto;
    }

    public static char[][] hashesToLines(char[][] map) {
        return LineTools.hashesToLines(map, false);
    }

    public static char[][] hashesToLines(char[][] map, boolean keepSingleHashes) {
        int width = map.length;
        int height = map[0].length;
        char[][] dungeon = new char[width][height];
        for (int i = 0; i < width; ++i) {
            System.arraycopy(map[i], 0, dungeon[i], 0, height);
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (map[x][y] == '#') {
                    int q = 0;
                    if (y >= height - 1 || map[x][y + 1] == '#' || map[x][y + 1] == '+' || map[x][y + 1] == '/') {
                        q |= 1;
                    }
                    if (x >= width - 1 || map[x + 1][y] == '#' || map[x + 1][y] == '+' || map[x + 1][y] == '/') {
                        q |= 2;
                    }
                    if (y <= 0 || map[x][y - 1] == '#' || map[x][y - 1] == '+' || map[x][y - 1] == '/') {
                        q |= 4;
                    }
                    if (x <= 0 || map[x - 1][y] == '#' || map[x - 1][y] == '+' || map[x - 1][y] == '/') {
                        q |= 8;
                    }
                    if (y >= height - 1 || x >= width - 1 || map[x + 1][y + 1] == '#' || map[x + 1][y + 1] == '+' || map[x + 1][y + 1] == '/') {
                        q |= 0x10;
                    }
                    if (y <= 0 || x >= width - 1 || map[x + 1][y - 1] == '#' || map[x + 1][y - 1] == '+' || map[x + 1][y - 1] == '/') {
                        q |= 0x20;
                    }
                    if (y <= 0 || x <= 0 || map[x - 1][y - 1] == '#' || map[x - 1][y - 1] == '+' || map[x - 1][y - 1] == '/') {
                        q |= 0x40;
                    }
                    if (y >= height - 1 || x <= 0 || map[x - 1][y + 1] == '#' || map[x - 1][y + 1] == '+' || map[x - 1][y + 1] == '/') {
                        q |= 0x80;
                    }
                    if (!keepSingleHashes && wallLookup[q] == '#') {
                        dungeon[x][y] = 9472;
                        continue;
                    }
                    dungeon[x][y] = wallLookup[q];
                    continue;
                }
                if (map[x][y] != '\u0001') continue;
                dungeon[x][y] = 32;
            }
        }
        return dungeon;
    }

    public static char[][] linesToHashes(char[][] map) {
        int width = map.length;
        int height = map[0].length;
        char[][] dungeon = new char[width][height];
        for (int i = 0; i < width; ++i) {
            block4: for (int j = 0; j < height; ++j) {
                switch (map[i][j]) {
                    case '\u0001': 
                    case '\u2500': 
                    case '\u2502': 
                    case '\u250c': 
                    case '\u2510': 
                    case '\u2514': 
                    case '\u2518': 
                    case '\u251c': 
                    case '\u2524': 
                    case '\u252c': 
                    case '\u2534': 
                    case '\u253c': {
                        dungeon[i][j] = 35;
                        continue block4;
                    }
                    default: {
                        dungeon[i][j] = map[i][j];
                    }
                }
            }
        }
        return dungeon;
    }

    public static char[][] transposeLines(char[][] map) {
        int width = map[0].length;
        int height = map.length;
        char[][] portion = new char[height][width];
        for (int i = 0; i < height; ++i) {
            block12: for (int j = 0; j < width; ++j) {
                switch (map[i][j]) {
                    case '\u0001': {
                        portion[i][j] = 32;
                        continue block12;
                    }
                    case '\u251c': {
                        portion[i][j] = 9516;
                        continue block12;
                    }
                    case '\u2524': {
                        portion[i][j] = 9524;
                        continue block12;
                    }
                    case '\u2534': {
                        portion[i][j] = 9508;
                        continue block12;
                    }
                    case '\u252c': {
                        portion[i][j] = 9500;
                        continue block12;
                    }
                    case '\u2510': {
                        portion[i][j] = 9492;
                        continue block12;
                    }
                    case '\u2514': {
                        portion[i][j] = 9488;
                        continue block12;
                    }
                    case '\u2502': {
                        portion[i][j] = 9472;
                        continue block12;
                    }
                    case '\u2500': {
                        portion[i][j] = 9474;
                        continue block12;
                    }
                    default: {
                        portion[i][j] = map[i][j];
                    }
                }
            }
        }
        return portion;
    }
}

