/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.grid.Direction;
import com.github.yellowstonegames.grid.Radius;

public enum Measurement {
    MANHATTAN,
    CHEBYSHEV,
    EUCLIDEAN;


    public float heuristic(Direction target) {
        if (this == EUCLIDEAN && (target == Direction.DOWN_LEFT || target == Direction.DOWN_RIGHT || target == Direction.UP_LEFT || target == Direction.UP_RIGHT)) {
            return 1.4142135f;
        }
        return 1.0f;
    }

    public int directionCount() {
        return this == MANHATTAN ? 4 : 8;
    }

    public static Measurement matchingMeasurement(Radius radius) {
        switch (radius) {
            case SQUARE: {
                return CHEBYSHEV;
            }
            case DIAMOND: {
                return MANHATTAN;
            }
        }
        return EUCLIDEAN;
    }

    public Radius matchingRadius() {
        switch (this) {
            case CHEBYSHEV: {
                return Radius.SQUARE;
            }
            case EUCLIDEAN: {
                return Radius.CIRCLE;
            }
        }
        return Radius.DIAMOND;
    }
}

