/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.random.LineWobble;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.IPointHash;
import com.github.yellowstonegames.grid.IntPointHash;

public class Noise
implements INoise {
    public static final int VALUE = 0;
    public static final int VALUE_FRACTAL = 1;
    public static final int PERLIN = 2;
    public static final int PERLIN_FRACTAL = 3;
    public static final int SIMPLEX = 4;
    public static final int SIMPLEX_FRACTAL = 5;
    public static final int CELLULAR = 6;
    public static final int CELLULAR_FRACTAL = 7;
    public static final int CUBIC = 8;
    public static final int CUBIC_FRACTAL = 9;
    public static final int FOAM = 10;
    public static final int FOAM_FRACTAL = 11;
    public static final int HONEY = 12;
    public static final int HONEY_FRACTAL = 13;
    public static final int MUTANT = 14;
    public static final int MUTANT_FRACTAL = 15;
    public static final int TAFFY = 16;
    public static final int TAFFY_FRACTAL = 17;
    public static final int WHITE_NOISE = 18;
    public static final int LINEAR = 0;
    public static final int HERMITE = 1;
    public static final int QUINTIC = 2;
    public static final int FBM = 0;
    public static final int BILLOW = 1;
    public static final int RIDGED_MULTI = 2;
    public static final int DOMAIN_WARP = 3;
    public static final int EUCLIDEAN = 0;
    public static final int MANHATTAN = 1;
    public static final int NATURAL = 2;
    public static final int CELL_VALUE = 0;
    public static final int NOISE_LOOKUP = 1;
    public static final int DISTANCE = 2;
    public static final int DISTANCE_2 = 3;
    public static final int DISTANCE_2_ADD = 4;
    public static final int DISTANCE_2_SUB = 5;
    public static final int DISTANCE_2_MUL = 6;
    public static final int DISTANCE_2_DIV = 7;
    public static final int DISTANCE_VALUE = 8;
    protected int seed;
    protected float frequency = 0.03125f;
    protected int interpolation = 1;
    protected int noiseType = 5;
    protected int octaves = 1;
    protected float lacunarity = 2.0f;
    protected float gain = 0.5f;
    protected int fractalType = 0;
    private float fractalBounding;
    protected int cellularDistanceFunction = 0;
    protected int cellularReturnType = 0;
    protected float gradientPerturbAmp = 2.2222223f;
    protected float sharpness = 1.0f;
    protected float sharpnessInverse = 1.0f;
    protected float mutation = 0.0f;
    protected boolean fractalSpiral = false;
    protected IPointHash pointHash = new IntPointHash();
    public static final Noise instance = new Noise();
    private static final float CUBIC_2D_BOUNDING = 0.44444445f;
    private static final float CUBIC_3D_BOUNDING = 0.2962963f;
    private static final float CUBIC_4D_BOUNDING = 0.19753087f;
    public static final float F2 = 0.36602542f;
    public static final float G2 = 0.21132487f;
    public static final float H2 = 0.42264974f;
    public static final float LIMIT2 = 0.5f;
    public static final float F3 = 0.33333334f;
    public static final float G3 = 0.16666667f;
    public static final float LIMIT3 = 0.6f;
    public static final float F4 = (float)((Math.sqrt(5.0) - 1.0) * 0.25);
    public static final float G4 = (float)((5.0 - Math.sqrt(5.0)) * 0.05);
    public static final float LIMIT4 = 0.4675f;
    public static final float F5 = (float)((Math.sqrt(6.0) - 1.0) / 5.0);
    public static final float G5 = (float)((6.0 - Math.sqrt(6.0)) / 30.0);
    public static final float LIMIT5 = 0.67f;
    public static final float F6 = (float)((Math.sqrt(7.0) - 1.0) / 6.0);
    public static final float G6 = (float)((double)F6 / (1.0 + 6.0 * (double)F6));
    public static final float LIMIT6 = 0.69f;
    protected static final float[] GRADIENTS_2D = new float[]{0.64994293f, 0.759983f, -0.1551483f, 0.9878912f, -0.85161805f, 0.5241628f, -0.951858f, -0.3065393f, -0.38568878f, -0.92262894f, 0.4505066f, -0.8927731f, 0.97129595f, -0.23787422f, 0.81206733f, 0.58356375f, 0.08429892f, 0.99644053f, -0.70248836f, 0.71169525f, -0.99745363f, -0.07131789f, -0.5940876f, -0.8044004f, 0.22520755f, -0.9743108f, 0.8868317f, -0.46209255f, 0.9275725f, 0.37364322f, 0.31890672f, 0.9477861f, -0.5130302f, 0.8583706f, -0.9857874f, 0.16799773f, -0.768381f, -0.6399927f, -0.013020236f, -0.99991524f, 0.75145614f, -0.659783f, 0.9898275f, 0.14227258f, 0.5352067f, 0.84472114f, -0.2941199f, 0.9557685f, -0.917529f, 0.39766893f, -0.8985631f, -0.4388443f, -0.25050056f, -0.96811646f, 0.57294095f, -0.81959665f, 0.99525845f, -0.09726567f, 0.7207815f, 0.6931624f, -0.05832476f, 0.9982977f, -0.796597f, 0.6045107f, -0.97716045f, -0.2125027f, -0.47360012f, -0.88074f, 0.36153433f, -0.9323588f, 0.9435535f, -0.3312201f, 0.8649776f, 0.5018105f, 0.18081868f, 0.98351645f, -0.62993395f, 0.7766487f, -0.99966097f, 0.026038265f, -0.66951126f, -0.7428019f, 0.12937273f, -0.99159604f, 0.837681f, -0.5461598f, 0.959517f, 0.28165063f, 0.40958166f, 0.91227347f, -0.4271076f, 0.9042008f, -0.9647728f, 0.26308444f, -0.82698697f, -0.56222105f, -0.110215925f, -0.9939077f, 0.68371886f, -0.7297455f, 0.9989724f, 0.045321748f, 0.6148313f, 0.7886586f, -0.19976184f, 0.9798445f, -0.87449896f, 0.48502743f, -0.93698704f, -0.34936416f, -0.3434773f, -0.939161f, 0.49050573f, -0.87143797f, 0.9810788f, -0.19360895f, 0.78478473f, 0.6197684f, 0.03905188f, 0.9992372f, -0.7340218f, 0.67912596f, -0.9931964f, -0.11645094f, -0.5570203f, -0.8304989f, 0.2691336f, -0.9631029f, 0.9068633f, -0.42142496f, 0.9096852f, 0.4152985f, 0.2756237f, 0.9612656f, -0.55140585f, 0.83423716f, -0.99238837f, 0.123147495f, -0.7385858f, -0.67415947f, 0.03231105f, -0.99947786f, 0.78058654f, -0.62504774f, 0.9823624f, 0.18698709f, 0.4963725f, 0.86810964f, -0.33713475f, 0.9414564f, -0.93460923f, 0.35567626f, -0.8777506f, -0.4791178f, -0.20636642f, -0.9784748f, 0.6094978f, -0.7927878f, 0.998644f, -0.05205887f, 0.6886255f, 0.72511715f, -0.10350942f, 0.9946285f, -0.82317597f, 0.5677864f, -0.9665254f, -0.25657097f, -0.4331968f, -0.90129936f, 0.40341896f, -0.9150154f, 0.95759547f, -0.28811625f, 0.84134585f, 0.5404971f, 0.13605818f, 0.99070084f, -0.66448575f, 0.7473009f, -0.99981385f, -0.019294871f, -0.6351582f, -0.7723821f, 0.17418066f, -0.98471373f, 0.86157316f, -0.5076334f, 0.94576615f, 0.3248482f, 0.36781496f, 0.929899f, -0.46764868f, 0.8839144f, -0.9757049f, 0.21908891f, -0.8006564f, -0.59912384f, -0.06505704f, -0.99788153f, 0.71608967f, -0.69800836f, 0.99589187f, 0.09055035f, 0.57845616f, 0.81571347f, -0.24396482f, 0.9697841f, -0.8955826f, 0.4448952f, -0.9201904f, -0.39147106f, -0.30055994f, -0.95376295f, 0.5294968f, -0.84831196f, 0.98884535f, -0.14894581f, 0.75588936f, 0.6546994f, -0.0062754224f, 0.99998033f, -0.76404667f, 0.645161f, -0.9868981f, -0.16134468f, -0.51880825f, -0.85489064f, 0.31250656f, -0.9499156f, 0.9250311f, -0.37989128f, 0.8899284f, 0.45610026f, 0.23177424f, 0.9727696f, -0.5886483f, 0.80838925f, -0.9969499f, 0.07804418f, -0.7072728f, -0.7069407f, 0.07757593f, -0.99698645f, 0.8081127f, -0.58902794f, 0.97287834f, 0.23131733f, 0.4565182f, 0.88971406f, -0.3794568f, 0.92520946f, -0.9497687f, 0.31295267f, -0.8551342f, -0.5184067f, -0.1618082f, -0.98682225f, 0.64480203f, -0.76434964f, 0.99997723f, -0.0067450893f, 0.65505433f, 0.7555818f, -0.14848135f, 0.9889152f, -0.8480632f, 0.5298952f, -0.953904f, -0.30011195f, -0.39190322f, -0.92000645f, 0.44447452f, -0.8957915f, 0.9696694f, -0.24442029f, 0.815985f, 0.578073f, 0.09101809f, 0.99584925f, -0.69767195f, 0.7164174f, -0.997912f, -0.06458835f, -0.5994998f, -0.80037487f, 0.21863061f, -0.97580767f, 0.8836947f, -0.4680638f, 0.93007165f, 0.36737818f, 0.32529235f, 0.9456135f, -0.5072287f, 0.8618115f, -0.9846318f, 0.17464313f, -0.7726803f, -0.63479537f, -0.019764457f, -0.9998047f, 0.7469888f, -0.66483665f, 0.9907646f, 0.13559286f, 0.54089224f, 0.84109193f, -0.28766644f, 0.95773065f, -0.9148258f, 0.40384868f, -0.9015027f, -0.43277344f, -0.25702488f, -0.9664048f, 0.5673997f, -0.8234425f, 0.99457973f, -0.10397656f, 0.7254405f, 0.6882849f, -0.051589828f, 0.9986684f, -0.7925014f, 0.6098701f, -0.9785716f, -0.20590684f, -0.47953004f, -0.87752545f, 0.35523728f, -0.9347762f, 0.94129795f, -0.3375769f, 0.8683427f, 0.4959647f, 0.18744847f, 0.9822744f, -0.62468106f, 0.78088f, -0.9994626f, 0.032780476f, -0.67450625f, -0.73826915f, 0.12268138f, -0.9924461f, 0.83397806f, -0.55179757f, 0.96139497f, 0.27517217f, 0.4157257f, 0.90949005f, -0.42099896f, 0.9070611f, -0.96297634f, 0.26958594f, -0.8307604f, -0.5566302f, -0.11691742f, -0.99314165f, 0.6787811f, -0.73434067f, 0.9992554f, 0.038582556f, 0.6201369f, 0.78449357f, -0.19314815f, 0.9811696f, -0.8712075f, 0.49091497f, -0.9393222f, -0.34303614f, -0.3498042f, -0.93682283f, 0.48461664f, -0.87472665f, 0.9797506f, -0.20022202f, 0.7889473f, 0.6144609f, 0.045790937f, 0.998951f, -0.7294243f, 0.6840615f, -0.9939593f, -0.1097491f, -0.56260943f, -0.82672286f, 0.26263127f, -0.96489626f, 0.9040001f, -0.42753223f, 0.91246575f, 0.40915313f, 0.28210124f, 0.9593846f, -0.5457663f, 0.8379374f, -0.9915352f, 0.12983844f, -0.7431163f, -0.6691623f, 0.025568744f, -0.99967307f, 0.77635276f, -0.6302987f, 0.9836013f, 0.18035671f, 0.5022167f, 0.8647418f, -0.33077687f, 0.943709f, -0.93218887f, 0.3619722f, -0.8809623f, -0.4731864f, -0.21296163f, -0.97706056f, 0.6041365f, -0.79688084f, 0.99827015f, -0.058793634f, 0.6935008f, 0.7204558f, -0.09679821f, 0.99530405f, -0.8193275f, 0.5733259f, -0.968234f, -0.25004584f, -0.4392663f, -0.8983569f, 0.39723793f, -0.91771567f, 0.9556303f, -0.29456875f, 0.84497243f, 0.5348099f, 0.14273746f, 0.9897606f, -0.65943f, 0.75176597f, -0.99992126f, -0.012550597f, -0.6403535f, -0.7680803f, 0.16753471f, -0.9858662f, 0.85812956f, -0.5134333f, 0.94793576f, 0.31846154f, 0.37407884f, 0.9273969f, -0.46167597f, 0.88704866f, -0.97420496f, 0.22566514f, -0.8046793f, -0.5937097f, -0.07178636f, -0.99742f, 0.7113652f, -0.70282257f, 0.99648f, 0.08383091f, 0.5839451f, 0.81179315f, -0.237418f, 0.9714076f, -0.8925614f, 0.4509259f, -0.92281f, -0.3852554f, -0.3069863f, -0.9517139f, 0.5237628f, -0.85186416f, 0.98781824f, -0.15561228f, 0.7602882f, 0.64958596f, 4.6967724E-4f, 0.9999999f, -0.75967765f, 0.65029985f, -0.987964f, -0.15468429f, -0.5245628f, -0.85137177f, 0.30609217f, -0.95200187f, 0.9224477f, -0.38612205f, 0.89298457f, 0.45008725f, 0.2383304f, 0.97118413f, -0.5831823f, 0.81234133f, -0.99640083f, 0.084766924f, -0.7120251f, -0.702154f, 0.0708494f, -0.997487f, 0.80412126f, -0.5944653f, 0.9744165f, 0.22474992f, 0.462509f, 0.88661456f};
    protected static final float[] GRADIENTS_3D = new float[]{-0.448549f, 1.1743165f, 1.0E-15f, 0.0f, 1.0E-15f, 1.0693244f, 0.6608788f, 0.0f, 0.448549f, 1.1743165f, 1.0E-15f, 0.0f, 1.0E-15f, 1.0693244f, -0.6608788f, 0.0f, -0.7257675f, 0.7257675f, -0.7257675f, 0.0f, -1.0693244f, 0.6608788f, 1.0E-15f, 0.0f, -0.7257675f, 0.7257675f, 0.7257675f, 0.0f, 0.7257675f, 0.7257675f, 0.7257675f, 0.0f, 1.0693244f, 0.6608788f, 0.0f, 0.0f, 0.7257675f, 0.7257675f, -0.7257675f, 0.0f, -0.6608788f, 3.0E-15f, -1.0693244f, 0.0f, -1.1743165f, 3.0E-15f, -0.448549f, 0.0f, 0.0f, 0.448549f, -1.1743165f, 0.0f, -0.6608788f, 1.0E-15f, 1.0693244f, 0.0f, 1.0E-15f, 0.448549f, 1.1743165f, 0.0f, -1.1743165f, 1.0E-15f, 0.448549f, 0.0f, 0.6608788f, 1.0E-15f, 1.0693244f, 0.0f, 1.1743165f, 1.0E-15f, 0.448549f, 0.0f, 0.6608788f, 1.0E-15f, -1.0693244f, 0.0f, 1.1743165f, 1.0E-15f, -0.448549f, 0.0f, -0.7257675f, -0.7257675f, -0.7257675f, 0.0f, -1.0693244f, -0.6608788f, -1.0E-15f, 0.0f, -1.0E-15f, -0.448549f, -1.1743165f, 0.0f, -1.0E-15f, -0.448549f, 1.1743165f, 0.0f, -0.7257675f, -0.7257675f, 0.7257675f, 0.0f, 0.7257675f, -0.7257675f, 0.7257675f, 0.0f, 1.0693244f, -0.6608788f, 1.0E-15f, 0.0f, 0.7257675f, -0.7257675f, -0.7257675f, 0.0f, -4.0E-15f, -1.0693244f, -0.6608788f, 0.0f, -0.448549f, -1.1743165f, -3.0E-15f, 0.0f, -3.0E-15f, -1.0693244f, 0.6608788f, 0.0f, 0.448549f, -1.1743165f, 3.0E-15f, 0.0f};
    protected static final float[] GRADIENTS_4D = new float[]{-0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, -0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, -0.5875167f, 0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, 1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, 1.4183908f, -1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, 1.4183908f, 0.5875167f, -1.4183908f, -1.4183908f, -1.4183908f, 0.5875167f};
    protected static final float[] GRADIENTS_5D = new float[]{-1.6797904f, -0.06909217f, -0.70980316f, -0.5887571f, 0.5683971f, 0.0f, 0.0f, 0.0f, -1.0516781f, -0.2945341f, -1.4440603f, 0.7418854f, -0.414148f, 0.0f, 0.0f, 0.0f, 1.0641253f, -1.565007f, 0.41563505f, 0.11308752f, 0.48254448f, 0.0f, 0.0f, 0.0f, 0.8695557f, 1.02645f, -0.3870691f, -1.1785231f, -0.80717677f, 0.0f, 0.0f, 0.0f, 0.40368435f, 0.22658835f, -1.6373382f, 0.7147764f, 0.7706589f, 0.0f, 0.0f, 0.0f, 0.18520802f, -0.7234242f, 1.334798f, -0.7398257f, -1.0551435f, 0.0f, 0.0f, 0.0f, -0.17982808f, -0.9172835f, -0.16605623f, 1.5451497f, 0.8433212f, 0.0f, 0.0f, 0.0f, -0.53760874f, 1.4095479f, -1.2573363f, 0.17362547f, -0.33632016f, 0.0f, 0.0f, 0.0f, -0.8831071f, 0.48907483f, 0.7809593f, -0.9126098f, 1.2402312f, 0.0f, 0.0f, 0.0f, -1.7880013f, -0.08327746f, -0.06888064f, 0.8681275f, -0.194233f, 0.0f, 0.0f, 0.0f, 1.1634898f, -0.505277f, -0.7356837f, -0.2313504f, 1.3402362f, 0.0f, 0.0f, 0.0f, 0.5846947f, -1.242492f, 0.64070046f, 1.3053017f, -0.0060293367f, 0.0f, 0.0f, 0.0f, 0.4938779f, 0.77839357f, 0.06803623f, 0.19498108f, -1.762822f, 0.0f, 0.0f, 0.0f, 0.3495453f, 0.31754646f, -1.2837807f, -1.4389421f, 0.24152651f, 0.0f, 0.0f, 0.0f, -0.08144756f, -0.36450198f, 1.2414339f, 0.7877421f, -1.3033837f, 0.0f, 0.0f, 0.0f, -0.6130444f, -1.7598573f, 0.32785103f, -0.42448467f, 0.4892908f, 0.0f, 0.0f, 0.0f, -0.44627345f, 0.79871815f, -0.37412357f, 1.626673f, -0.61388594f, 0.0f, 0.0f, 0.0f, -1.1190041f, 0.43878978f, 1.5187622f, 0.23103313f, 0.441903f, 0.0f, 0.0f, 0.0f, 1.7898524f, -0.073076546f, 0.2593137f, -0.61967254f, -0.5829671f, 0.0f, 0.0f, 0.0f, 1.2710361f, -0.7953333f, -0.5194551f, 0.96171105f, 0.74645185f, 0.0f, 0.0f, 0.0f, 0.39194602f, -1.2475587f, -1.4706984f, -0.1307051f, -0.33156937f, 0.0f, 0.0f, 0.0f, 0.26523367f, 0.6189864f, 0.3777316f, -1.7165369f, 0.6762596f, 0.0f, 0.0f, 0.0f, 0.13699026f, 0.54915386f, -1.0396636f, 0.9490333f, -1.3031113f, 0.0f, 0.0f, 0.0f, -0.24016835f, -0.37338486f, -1.461395f, -0.72270507f, 1.0700116f, 0.0f, 0.0f, 0.0f, -0.66989386f, -1.34227f, 0.7466878f, 1.0575187f, -0.27141285f, 0.0f, 0.0f, 0.0f, -0.88475555f, 1.1306623f, -0.16409643f, -0.16860795f, 1.3723899f, 0.0f, 0.0f, 0.0f, -1.1982151f, 0.3128615f, -0.84509724f, -1.3226475f, -0.05303398f, 0.0f, 0.0f, 0.0f, 0.81510645f, -0.07073879f, 0.47229868f, 0.19162528f, -1.752373f, 0.0f, 0.0f, 0.0f, 1.2690966f, -1.1058708f, -0.0729186f, -1.0707271f, 0.12111958f, 0.0f, 0.0f, 0.0f, 0.28535858f, -1.5643353f, -0.5748321f, 0.58084196f, -0.89644635f, 0.0f, 0.0f, 0.0f, 0.2535726f, 1.1620185f, 1.550283f, -0.22309257f, 0.36368456f, 0.0f, 0.0f, 0.0f, -0.12592743f, 0.13972807f, 0.08188043f, -1.6542089f, -1.105218f, 0.0f, 0.0f, 0.0f, -0.7748099f, -0.7541306f, -1.3684353f, 0.66406184f, 0.7192798f, 0.0f, 0.0f, 0.0f, -0.7154067f, -1.0897763f, 1.1541034f, -0.5995216f, -0.78051275f, 0.0f, 0.0f, 0.0f, -1.220533f, 1.114049f, 0.20193954f, 0.96719223f, 0.54125214f, 0.0f, 0.0f, 0.0f, 1.7763125f, 0.38842323f, -0.55908597f, -0.09975168f, -0.60935545f, 0.0f, 0.0f, 0.0f, 0.7941439f, -0.112563394f, 1.2801757f, -1.1687349f, 0.59318954f, 0.0f, 0.0f, 0.0f, 1.0158349f, -1.2589196f, 0.57796705f, 0.67760545f, -0.7681185f, 0.0f, 0.0f, 0.0f, 0.21120489f, 1.7680264f, -0.32198793f, -0.44193187f, 0.728351f, 0.0f, 0.0f, 0.0f, -0.0026910086f, 0.5409839f, -1.7270072f, 0.82139516f, -0.22379749f, 0.0f, 0.0f, 0.0f, -0.4138014f, 0.15974505f, 0.6839984f, -0.09295073f, 1.8239398f, 0.0f, 0.0f, 0.0f, -0.7659506f, -0.5475011f, -0.37207896f, -1.7162536f, -0.17202619f, 0.0f, 0.0f, 0.0f, -0.7070623f, -0.8458705f, -1.0146426f, 0.30714232f, 1.2886932f, 0.0f, 0.0f, 0.0f, -1.6125362f, 0.94256103f, 0.53997916f, -0.46859422f, 0.012143515f, 0.0f, 0.0f, 0.0f, 1.02636f, 0.30948555f, -0.13575399f, 0.9416268f, -1.3948884f, 0.0f, 0.0f, 0.0f, 1.0884857f, -0.241295f, -1.6426715f, -0.0397578f, 0.2388003f, 0.0f, 0.0f, 0.0f, 0.38834962f, -0.7333844f, 0.7553963f, -1.1941141f, -1.1466472f, 0.0f, 0.0f, 0.0f, 0.11018248f, 1.9193423f, -0.034956023f, 0.45865336f, 0.3039742f, 0.0f, 0.0f, 0.0f, -0.21518967f, 0.8619435f, -1.1688234f, -0.6467742f, -1.1942705f, 0.0f, 0.0f, 0.0f, -0.5440612f, 0.10200415f, 1.1614696f, 1.4233072f, 0.564604f, 0.0f, 0.0f, 0.0f, -1.3903048f, -0.7781815f, 0.1518957f, 0.017201519f, -1.1992157f, 0.0f, 0.0f, 0.0f, -1.135291f, -1.0508611f, -0.59947294f, -0.9722493f, 0.5496989f, 0.0f, 0.0f, 0.0f, 1.3336722f, 0.87353677f, 1.0383656f, 0.4365891f, -0.43524563f, 0.0f, 0.0f, 0.0f, 1.3114501f, 0.49187684f, 0.30843338f, -0.6495376f, 1.2333391f, 0.0f, 0.0f, 0.0f, 0.6896295f, -0.24192874f, -0.71412677f, 1.6588951f, -0.4516321f, 0.0f, 0.0f, 0.0f, 0.21769683f, -0.7421851f, 1.5213708f, 0.04388346f, 1.0417651f, 0.0f, 0.0f, 0.0f, -0.0434373f, 1.6845775f, 0.32299188f, -1.010882f, -0.18467776f, 0.0f, 0.0f, 0.0f, -0.3651205f, 0.6939929f, -0.45624286f, 0.619907f, 1.671113f, 0.0f, 0.0f, 0.0f, -0.58901656f, 0.056176726f, -1.8733437f, -0.37224296f, -0.04384276f, 0.0f, 0.0f, 0.0f, -0.7545213f, -0.3365186f, 0.33809185f, 0.977602f, -1.4991468f, 0.0f, 0.0f, 0.0f, -1.7417773f, -0.9568394f, -0.2040756f, 0.061434798f, 0.07244995f, 0.0f, 0.0f, 0.0f, 0.8480497f, 0.7472073f, -1.0543921f, -0.76103204f, -1.0156676f, 0.0f, 0.0f, 0.0f, 1.1550078f, 0.5368674f, 1.0697389f, 1.0270433f, 0.42257684f, 0.0f, 0.0f, 0.0f, 0.6091831f, -0.363296f, -0.25887862f, -0.63274246f, -1.7405547f, 0.0f, 0.0f, 0.0f, 0.06779259f, -0.79439795f, -1.0479221f, 1.4543495f, 0.38866764f, 0.0f, 0.0f, 0.0f, -0.20613576f, 1.6481341f, 0.7904935f, 0.12015973f, -0.7757859f, 0.0f, 0.0f, 0.0f, -0.7481242f, 0.88153064f, -0.03893023f, -1.3935543f, 0.84835404f, 0.0f, 0.0f, 0.0f, -1.1501638f, 0.050056085f, -1.1550196f, 0.85883737f, -0.7764958f, 0.0f, 0.0f, 0.0f, -1.4576211f, -0.4980765f, 0.9775176f, -0.32443672f, 0.75263596f, 0.0f, 0.0f, 0.0f, 1.0804926f, -1.0462781f, 0.074569106f, 1.2771082f, -0.31823257f, 0.0f, 0.0f, 0.0f, 0.9560364f, 1.0747533f, -0.79082495f, 0.17952733f, 1.1283908f, 0.0f, 0.0f, 0.0f, 0.5870024f, 0.35180983f, 1.5130869f, -1.0689826f, -0.31543937f, 0.0f, 0.0f, 0.0f, 0.2461488f, -0.30861536f, 0.29215586f, 0.9112884f, 1.7112468f, 0.0f, 0.0f, 0.0f, -0.16664144f, -1.6148303f, -1.0133052f, -0.54320216f, -0.20663497f, 0.0f, 0.0f, 0.0f, -0.208266f, 0.8616009f, 0.9278341f, 1.0618169f, 1.1072208f, 0.0f, 0.0f, 0.0f, -1.4200071f, 1.1449938f, 0.7148016f, 0.395174f, 0.073927015f, 0.0f, 0.0f, 0.0f, -1.0824869f, 0.013096781f, -0.37370682f, -0.77066725f, -1.447227f, 0.0f, 0.0f, 0.0f, 1.3772509f, -0.35640088f, -1.308193f, 0.49957988f, 0.123325676f, 0.0f, 0.0f, 0.0f, 0.94979084f, -1.3263098f, 0.45020843f, -0.2307263f, -1.040614f, 0.0f, 0.0f, 0.0f, 0.45497453f, 0.6615624f, -0.19552223f, 1.8045986f, 0.24602565f, 0.0f, 0.0f, 0.0f, 0.3671055f, 0.3148111f, -1.6182063f, 0.27693623f, -1.0348152f, 0.0f, 0.0f, 0.0f, 0.04819663f, -0.4532365f, 1.1128664f, -1.3414977f, 0.86842734f, 0.0f, 0.0f, 0.0f, -0.35764492f, -1.2810416f, -0.200698f, 1.1378443f, -0.94660074f, 0.0f, 0.0f, 0.0f, -0.5489242f, 1.443636f, -1.0580643f, -0.21110308f, 0.6712174f, 0.0f, 0.0f, 0.0f, -0.7396914f, 0.42412853f, 0.6373932f, -1.6490546f, -0.38382328f, 0.0f, 0.0f, 0.0f, -1.7438368f, -0.010302654f, -0.017474605f, 0.28590533f, 0.9364187f, 0.0f, 0.0f, 0.0f, 1.4125224f, -0.6136775f, -0.93827444f, -0.78826207f, -0.35561833f, 0.0f, 0.0f, 0.0f, 0.6333526f, -1.2469836f, 0.8203449f, 0.69454175f, 0.9426251f, 0.0f, 0.0f, 0.0f, 0.8639746f, 1.7229496f, 0.21310975f, -0.349033f, -0.34315118f, 0.0f, 0.0f, 0.0f, 0.1160084f, 0.19254273f, -0.546945f, -1.4198631f, 1.2784011f, 0.0f, 0.0f, 0.0f, -0.19603682f, -0.42416325f, 1.88894f, 0.46058306f, -0.037736267f, 0.0f, 0.0f, 0.0f, -0.3716846f, -0.8276497f, 0.20588869f, -0.592634f, -1.6683049f, 0.0f, 0.0f, 0.0f, -0.7995956f, 1.4545513f, -0.55671465f, 0.9584702f, 0.12779222f, 0.0f, 0.0f, 0.0f, -0.9905084f, 0.40122277f, 1.3537558f, -0.109089285f, -1.0066569f, 0.0f, 0.0f, 0.0f, 1.4450754f, -0.028178725f, 0.30532005f, -1.3288357f, 0.22789955f, 0.0f, 0.0f, 0.0f, 1.2162147f, -0.747884f, -0.4936637f, 0.44278145f, -1.233585f, 0.0f, 0.0f, 0.0f, 0.42881566f, -1.2286192f, -1.4078773f, -0.46953458f, 0.322538f, 0.0f, 0.0f, 0.0f, 0.33298588f, 1.0484961f, 0.6324502f, 1.2260809f, -0.9415459f, 0.0f, 0.0f, 0.0f, -0.043082524f, 0.62049687f, -0.74086505f, -0.29177037f, 1.7260118f, 0.0f, 0.0f, 0.0f, -0.28311083f, -0.29737017f, -1.2778575f, -1.3826667f, -0.53547364f, 0.0f, 0.0f, 0.0f, -0.76267016f, -1.2292796f, 0.8192696f, 0.4886038f, 0.99863386f, 0.0f, 0.0f, 0.0f, -1.1212379f, 1.456446f, -0.14524642f, -0.64187664f, -0.4341527f, 0.0f, 0.0f, 0.0f, -1.437186f, 0.3591868f, -0.783223f, 0.7741764f, 0.7698662f, 0.0f, 0.0f, 0.0f, 1.6195536f, -0.07833059f, 1.1220764f, -0.088074f, -0.32264248f, 0.0f, 0.0f, 0.0f, 0.67366225f, -0.5801267f, -0.0064584925f, -1.2469664f, 1.286338f, 0.0f, 0.0f, 0.0f, 0.38083375f, -1.7282318f, -0.8266342f, 0.42130736f, -0.08577023f, 0.0f, 0.0f, 0.0f, 0.07485219f, 0.58650553f, 0.75472265f, -0.3937893f, 1.7104771f, 0.0f, 0.0f, 0.0f, -0.3050023f, 0.33322564f, 0.203947f, 1.9348633f, 0.103169076f, 0.0f, 0.0f, 0.0f, -0.548693f, -0.3926995f, -0.7835797f, -0.032389533f, -1.7116299f, 0.0f, 0.0f, 0.0f, -0.7373648f, -0.9164391f, 1.1634542f, -1.1082134f, 0.18619816f, 0.0f, 0.0f, 0.0f, -1.2396833f, 1.1286466f, 0.21934655f, 0.4244819f, -0.98032874f, 0.0f, 0.0f, 0.0f, 1.711825f, 0.51113427f, -0.58161503f, -0.55275697f, 0.4056853f, 0.0f, 0.0f, 0.0f, 0.7213414f, -0.06593983f, 1.4422535f, 0.9666694f, -0.6788033f, 0.0f, 0.0f, 0.0f, 0.9873966f, -1.2334566f, 0.71104115f, 0.017284995f, 0.9988765f, 0.0f, 0.0f, 0.0f, 0.1849031f, -1.6262999f, -0.31820145f, -0.9668115f, -0.5338379f, 0.0f, 0.0f, 0.0f, -0.053786192f, 0.71122754f, -1.6810226f, 0.47841382f, 0.66071594f, 0.0f, 0.0f, 0.0f, -0.7517873f, 0.36868787f, 1.1316389f, -0.9931707f, -1.0158201f, 0.0f, 0.0f, 0.0f, -0.74796367f, -0.40877295f, -0.28012055f, 1.4488806f, 1.0467726f, 0.0f, 0.0f, 0.0f, -1.0753365f, -1.048701f, -1.2861468f, 0.04515599f, -0.29608306f, 0.0f, 0.0f, 0.0f, -1.6717167f, 0.61936927f, 0.34443593f, -0.5570386f, 0.6267512f, 0.0f, 0.0f, 0.0f, 1.6653427f, 0.65140116f, -0.18438008f, 0.8463999f, -0.2278624f, 0.0f, 0.0f, 0.0f, 0.6180556f, -0.09808901f, -0.9637327f, -0.38184908f, 1.5917903f, 0.0f, 0.0f, 0.0f, 0.3828037f, -0.76085097f, 0.9360621f, 1.5486593f, -0.003020631f, 0.0f, 0.0f, 0.0f, 0.041648556f, -1.5762523f, 0.0019777673f, 0.0585731f, -1.2289261f, 0.0f, 0.0f, 0.0f, -0.28867123f, 0.9630135f, -1.0923276f, -1.3265795f, 0.1904764f, 0.0f, 0.0f, 0.0f, -0.57648116f, 0.15909077f, 1.1606879f, 0.668939f, -1.3592954f, 0.0f, 0.0f, 0.0f, -1.6356922f, -0.7138956f, 0.23406929f, -0.68081826f, 0.54457515f, 0.0f, 0.0f, 0.0f, -1.1383733f, -0.8340753f, -0.4924317f, 1.1297774f, -0.6996704f, 0.0f, 0.0f, 0.0f, 1.2119765f, 1.0042478f, 1.1627126f, 0.10529842f, 0.3995139f, 0.0f, 0.0f, 0.0f, 1.084896f, 0.5299383f, 0.3338775f, -1.2410743f, -0.9436241f, 0.0f, 0.0f, 0.0f, 0.8223389f, -0.22572698f, -0.88554543f, 1.1320984f, 1.0986211f, 0.0f, 0.0f, 0.0f, 0.16965128f, -0.68440044f, 1.7720907f, -0.3171058f, -0.5118135f, 0.0f, 0.0f, 0.0f, -0.0617271f, 1.6228011f, 0.23620363f, 1.0239074f, 0.5084564f, 0.0f, 0.0f, 0.0f, -0.801691f, 1.4462166f, -0.76271886f, 0.3252217f, -0.760421f, 0.0f, 0.0f, 0.0f, -0.6115306f, 0.10145504f, -1.4858079f, -0.7519599f, 0.91796976f, 0.0f, 0.0f, 0.0f, -1.5359735f, -0.5360812f, 0.68037164f, 0.90228987f, -0.27635068f, 0.0f, 0.0f, 0.0f, 1.4311849f, -0.8591028f, -0.17529958f, -0.21455559f, 1.0662496f, 0.0f, 0.0f, 0.0f, 0.74106425f, 0.7990758f, -0.9368641f, 1.3900908f, -0.047273543f, 0.0f, 0.0f, 0.0f, 0.4550756f, 0.28131494f, 0.5064435f, 0.14540808f, -1.8536828f, 0.0f, 0.0f, 0.0f, 0.65843683f, -0.33986568f, -0.24739265f, -1.8321141f, 0.18195343f, 0.0f, 0.0f, 0.0f, 0.015996033f, -0.7374889f, -1.0065472f, 0.7388569f, -1.3772463f, 0.0f, 0.0f, 0.0f, -0.22997025f, 1.8176358f, 0.7442497f, -0.22063813f, 0.2018042f, 0.0f, 0.0f, 0.0f, -0.40694267f, 0.4769186f, 0.008926976f, 1.7464026f, -0.7462872f, 0.0f, 0.0f, 0.0f, -1.4305779f, 0.14211598f, -1.216572f, 0.34714544f, 0.5767953f, 0.0f, 0.0f, 0.0f, -1.4621197f, -0.37479937f, 0.9054069f, -0.6585117f, -0.6843479f, 0.0f, 0.0f, 0.0f, 1.2555507f, -1.2133186f, 0.1361146f, 0.79384595f, 0.5502108f, 0.0f, 0.0f, 0.0f, 0.96232814f, 1.3224211f, -0.81485295f, -0.27081552f, -0.76668155f, 0.0f, 0.0f, 0.0f, 0.31743488f, 0.2633415f, 1.0144166f, -1.5786067f, 0.5557393f, 0.0f, 0.0f, 0.0f, 0.4312067f, -0.57471794f, 0.8536422f, 0.8761257f, -1.4097726f, 0.0f, 0.0f, 0.0f, -0.18862687f, -1.0208136f, -0.65065f, -0.94770193f, 1.265257f, 0.0f, 0.0f, 0.0f, -0.304875f, 1.3023137f, 1.3472499f, 0.5983792f, -0.19465442f, 0.0f, 0.0f, 0.0f, -0.9288707f, 0.7613447f, 0.47295013f, -0.21144833f, 1.5129975f, 0.0f, 0.0f, 0.0f, -1.1557324f, 0.06388063f, -0.32101503f, -1.5950471f, -0.11391296f, 0.0f, 0.0f, 0.0f, 1.0864354f, -0.30522835f, -1.1052395f, 0.20220265f, 1.2099807f, 0.0f, 0.0f, 0.0f, 1.0414088f, -1.4163018f, 0.59404045f, -0.7457759f, 0.022163564f, 0.0f, 0.0f, 0.0f, 0.5070316f, 0.91375333f, -0.20732176f, 0.828895f, -1.4757793f, 0.0f, 0.0f, 0.0f, 0.3763094f, 0.4850536f, -1.8754774f, -0.20804843f, 0.24982871f, 0.0f, 0.0f, 0.0f, -0.02530811f, -0.19218382f, 0.65753037f, -1.5122491f, -1.1149803f, 0.0f, 0.0f, 0.0f, -0.6196419f, -1.6338763f, -0.20487152f, 0.7010006f, 0.6427426f, 0.0f, 0.0f, 0.0f, -0.5308926f, 1.4556534f, -0.852287f, -0.53444123f, -0.76629347f, 0.0f, 0.0f, 0.0f, -1.1271693f, 0.66194844f, 0.9450689f, 1.0599682f, 0.5240476f, 0.0f, 0.0f, 0.0f, -1.893449f, 0.043849155f, 0.020534702f, -0.094767585f, -0.6352368f, 0.0f, 0.0f, 0.0f, 0.51032305f, 1.3058157f, 0.1990339f, -0.7882347f, 1.1719587f, 0.0f, 0.0f, 0.0f, 0.13847926f, 0.46102768f, -0.972727f, 1.5951805f, -0.52676207f, 0.0f, 0.0f, 0.0f, -0.20737976f, -0.2507461f, 1.5291535f, -0.07251616f, 1.2452114f, 0.0f, 0.0f, 0.0f, -0.5725773f, -1.0055907f, 0.32473806f, -1.5826349f, -0.22528805f, 0.0f, 0.0f, 0.0f, -0.68621033f, 1.2996571f, -0.39610106f, 0.3505478f, 1.2490904f, 0.0f, 0.0f, 0.0f, -1.0941521f, 0.44774607f, 1.5583662f, -0.41568238f, -0.032521985f, 0.0f, 0.0f, 0.0f, 1.0615423f, 0.016871653f, 0.290981f, 0.7952956f, -1.4682229f, 0.0f, 0.0f, 0.0f, 0.35295746f, -0.98604375f, -1.143822f, -0.862479f, -0.9224641f, 0.0f, 0.0f, 0.0f, 0.34253302f, 1.5160689f, 0.900648f, 0.77327365f, 0.41843438f, 0.0f, 0.0f, 0.0f, -0.11822088f, 0.46898013f, -0.3711657f, -0.8412806f, -1.7089659f, 0.0f, 0.0f, 0.0f, -0.389515f, -0.27639046f, -1.3594382f, 1.3110052f, 0.45285708f, 0.0f, 0.0f, 0.0f, -0.8866701f, -1.1592071f, 0.9217069f, 0.010806213f, -1.0101458f, 0.0f, 0.0f, 0.0f, -0.9839607f, 1.3163966f, -0.081086494f, -1.0154752f, 0.51103467f, 0.0f, 0.0f, 0.0f, 1.7393576f, 0.39722422f, -0.7097572f, 0.37075788f, -0.41908407f, 0.0f, 0.0f, 0.0f, 1.2992927f, -3.032116E-4f, 1.0675929f, -0.54672974f, 0.9344359f, 0.0f, 0.0f, 0.0f, 0.33091527f, -1.5010778f, -0.78847826f, 0.045202818f, 1.0067371f, 0.0f, 0.0f, 0.0f, 0.05271548f, 0.98485136f, 1.2271602f, -1.2005996f, -0.28271452f, 0.0f, 0.0f, 0.0f, -1.1072849f, -0.57339376f, -1.2917947f, -0.8540936f, -0.21663433f, 0.0f, 0.0f, 0.0f, -0.5785672f, -0.5892745f, 0.9002795f, 0.88273185f, 1.3146471f, 0.0f, 0.0f, 0.0f, 1.1323242f, 0.4385085f, -0.3984529f, -0.8482584f, -1.2834505f, 0.0f, 0.0f, 0.0f, 0.6832479f, -0.020372277f, 1.8021713f, 0.5087859f, 0.16146956f, 0.0f, 0.0f, 0.0f, 0.6295137f, -0.79572207f, 0.57357526f, -0.5094408f, -1.5433795f, 0.0f, 0.0f, 0.0f, 0.14641452f, -1.4152601f, -0.29970285f, 1.3388225f, 0.30550668f, 0.0f, 0.0f, 0.0f, -0.111753255f, 0.84296787f, -1.5895178f, 0.11845022f, -0.8580903f, 0.0f, 0.0f, 0.0f, -0.6186592f, 0.34919307f, 0.865206f, -1.4602097f, 0.78392047f, 0.0f, 0.0f, 0.0f, -1.1893741f, -0.48738888f, -0.33687f, 1.0489489f, -1.0649256f, 0.0f, 0.0f, 0.0f, -1.1495757f, -0.9135567f, -1.148876f, -0.31390792f, 0.65225434f, 0.0f, 0.0f, 0.0f, 1.2507068f, 0.9082987f, 0.4849121f, 1.1269927f, -0.32476702f, 0.0f, 0.0f, 0.0f, 1.3812528f, 0.6859061f, -0.11446759f, 0.21716052f, 1.2495646f, 0.0f, 0.0f, 0.0f, 0.8074889f, -0.06501601f, -1.3097079f, -1.2004749f, -0.43273535f, 0.0f, 0.0f, 0.0f, 0.32289207f, -0.6888576f, 1.0170445f, 0.78765684f, 1.3290722f, 0.0f, 0.0f, 0.0f, 0.0052441536f, -1.9617941f, 0.047765452f, -0.33520496f, -0.19155197f, 0.0f, 0.0f, 0.0f, -0.20017993f, 0.5900368f, -0.5616998f, 1.378741f, 1.1812497f, 0.0f, 0.0f, 0.0f, -0.90153146f, 0.3110013f, 1.7320695f, 0.29928178f, -0.02974806f, 0.0f, 0.0f, 0.0f, -0.8591941f, -0.2863601f, 0.14613573f, -0.7274398f, -1.6214991f, 0.0f, 0.0f, 0.0f, 0.93958324f, 0.9730324f, 1.0982292f, -0.19307114f, -0.9628123f, 0.0f, 0.0f, 0.0f, 0.5731182f, 0.35810092f, 0.22586454f, 1.8565152f, 0.2136256f, 0.0f, 0.0f, 0.0f, 0.70116746f, -0.12268707f, -0.79097813f, 0.39592475f, -1.6464839f, 0.0f, 0.0f, 0.0f, 0.09549724f, -0.5011464f, 1.803253f, -0.6086203f, 0.34291777f, 0.0f, 0.0f, 0.0f, -0.14124247f, -1.6893857f, 0.38864723f, 0.7238267f, -0.6716061f, 0.0f, 0.0f, 0.0f, -0.7766532f, 1.3490342f, -0.5674059f, -0.37396672f, 1.0559906f, 0.0f, 0.0f, 0.0f, -1.5471156f, -0.41174087f, 0.6692645f, 0.3161028f, 0.9429035f, 0.0f, 0.0f, 0.0f, 1.533446f, -1.0006421f, -0.18882573f, -0.6902113f, -0.3677118f, 0.0f, 0.0f, 0.0f, 0.7809057f, 1.0330833f, -1.0077019f, 0.7218705f, 0.8867723f, 0.0f, 0.0f, 0.0f, 1.0334456f, 0.83613646f, 1.3880172f, -0.33824173f, -0.43802613f, 0.0f, 0.0f, 0.0f, -0.06342316f, -1.110229f, -1.5755978f, 0.51243967f, -0.13515207f, 0.0f, 0.0f, 0.0f, -0.18461561f, -1.2027986f, 0.5261838f, -0.3886987f, 1.4461108f, 0.0f, 0.0f, 0.0f, -1.4795809f, -0.2528894f, 0.7657021f, -1.0677046f, 0.14350882f, 0.0f, 0.0f, 0.0f, 0.8358974f, 1.4130062f, -0.72468525f, -0.7614331f, 0.44692263f, 0.0f, 0.0f, 0.0f, 0.35869312f, 0.40763262f, 1.4558997f, 0.95809495f, -0.8170587f, 0.0f, 0.0f, 0.0f, 0.24578354f, -0.37441865f, 0.9525361f, -0.32325456f, 1.6696055f, 0.0f, 0.0f, 0.0f, -0.22138476f, -0.7780999f, -0.5024501f, -1.6139364f, -0.6987863f, 0.0f, 0.0f, 0.0f, -0.2574376f, -1.3890644f, 1.3509473f, 0.20105183f, 0.37248573f, 0.0f, 0.0f, 0.0f, -1.2190443f, 1.0117162f, 0.62373775f, -0.8273041f, -0.6456626f, 0.0f, 0.0f, 0.0f, -1.4202182f, 0.12605153f, -0.30997565f, 1.0152806f, 0.91663057f, 0.0f, 0.0f, 0.0f, 1.3394545f, -0.3743458f, -1.4096087f, -0.06157868f, -0.2737483f, 0.0f, 0.0f, 0.0f, 0.717137f, -0.9616513f, 0.4897306f, -1.1232009f, 1.0293323f, 0.0f, 0.0f, 0.0f, 0.17796677f, 0.35042828f, -1.056844f, -0.48692396f, 1.578453f, 0.0f, 0.0f, 0.0f, -0.120436445f, -0.21367003f, 1.1047462f, 1.6490451f, 0.0051371576f, 0.0f, 0.0f, 0.0f, -0.3871281f, -0.77350575f, -0.06652887f, -0.031126628f, -1.801784f, 0.0f, 0.0f, 0.0f, -1.1000913f, 0.65495896f, 0.8947793f, 0.45215f, -1.1643702f, 0.0f, 0.0f, 0.0f, 1.9292604f, 0.09326768f, 0.054334316f, -0.44042128f, 0.26894686f, 0.0f, 0.0f, 0.0f, 1.0366998f, -0.42353174f, -0.735265f, 1.1718961f, -0.9120961f, 0.0f, 0.0f, 0.0f, 0.3604157f, 1.2092121f, 0.21105145f, -1.3105327f, -0.80365926f, 0.0f, 0.0f, 0.0f, 0.06686388f, 0.67590714f, -1.0954065f, 0.9579351f, 1.1921089f, 0.0f, 0.0f, 0.0f, -0.28782266f, -0.19882283f, 1.7896272f, -0.5362534f, -0.6223298f, 0.0f, 0.0f, 0.0f, -0.5998367f, -0.8396322f, 0.3455361f, 1.4029136f, 0.9206803f, 0.0f, 0.0f, 0.0f, -0.8343249f, 1.7431141f, -0.39750403f, 0.039885692f, -0.3253537f, 0.0f, 0.0f, 0.0f, 1.7378988f, 0.1069271f, 0.5947544f, 0.7345801f, -0.27373976f, 0.0f, 0.0f, 0.0f, 0.36691907f, -1.0350628f, -1.2227443f, 1.1386733f, -0.04831831f, 0.0f, 0.0f, 0.0f, -0.4256377f, -0.19808422f, -1.1814821f, 0.618606f, -1.4145749f, 0.0f, 0.0f, 0.0f, -1.0694433f, -1.138896f, 1.0788633f, -0.5297258f, 0.33860254f, 0.0f, 0.0f, 0.0f, -0.8783536f, 1.24753f, -0.037699398f, 1.065303f, -0.7320331f, 0.0f, 0.0f, 0.0f, 1.664465f, 0.5820689f, -0.8613458f, 0.111106195f, 0.3694466f, 0.0f, 0.0f, 0.0f, 1.0607201f, 0.062035657f, 1.0296432f, -1.0302379f, -0.86571896f, 0.0f, 0.0f, 0.0f, -0.8817724f, 0.95157355f, 0.6010913f, 0.4766383f, -1.3147206f, 0.0f, 0.0f, 0.0f, -0.76111376f, -0.2756268f, -0.7300243f, -1.1275553f, 1.2411364f, 0.0f, 0.0f, 0.0f, -1.3207783f, 1.1561699f, 0.22994702f, -0.20725226f, 0.9071862f, 0.0f, 0.0f, 0.0f, -1.1816771f, -0.7596862f, -0.9827823f, -0.67742914f, -0.77572197f, 0.0f, 0.0f, 0.0f, 1.2474995f, 1.226668f, 0.6167133f, 0.6372268f, 0.39068854f, 0.0f, 0.0f, 0.0f, 1.4101962f, 0.8763908f, -0.067969054f, -0.3381071f, -1.0603536f, 0.0f, 0.0f, 0.0f, 0.430389f, 0.007545631f, -0.73184025f, -1.7280563f, 0.5412391f, 0.0f, 0.0f, 0.0f, -1.0150772f, -0.25018287f, 0.19382954f, -1.6850991f, -0.17290953f, 0.0f, 0.0f, 0.0f, -0.24916823f, -1.8343103f, 0.55708927f, 0.40964967f, 0.30831718f, 0.0f, 0.0f, 0.0f, 0.67070556f, 0.7050913f, 1.0951484f, -0.81445277f, 1.0910164f, 0.0f, 0.0f, 0.0f, -0.12539443f, -0.8069577f, -1.1981626f, -0.090934746f, 1.3744937f, 0.0f, 0.0f, 0.0f, 0.49794316f, 1.0477297f, -0.4424841f, -0.99924785f, -1.2083155f, 0.0f, 0.0f, 0.0f, 0.33912835f, 0.52973974f, 1.8127693f, 0.52f, 0.21871227f, 0.0f, 0.0f, 0.0f, 0.1729942f, 0.55130607f, -1.329578f, -1.3236932f, -0.38235226f, 0.0f, 0.0f, 0.0f, -0.17599851f, -0.11166241f, 1.0347327f, 0.71886957f, 1.5391916f, 0.0f, 0.0f, 0.0f, 1.3834109f, -0.53198755f, -1.005375f, 0.8686684f, 0.1944212f, 0.0f, 0.0f, 0.0f, 0.2655537f, 1.2074448f, 0.23000939f, 1.5279398f, 0.28992087f, 0.0f, 0.0f, 0.0f, -0.76500076f, -1.7462692f, -0.29857463f, -0.24972762f, 0.46239257f, 0.0f, 0.0f, 0.0f, 1.5421515f, 0.18092427f, 0.64543873f, 0.20203029f, 1.06378f, 0.0f, 0.0f, 0.0f};
    protected static final float[] GRADIENTS_6D = new float[]{0.31733185f, 0.04359915f, -0.63578105f, 0.60224146f, -0.06199565f, 0.3558705f, 0.0f, 0.0f, -0.54645425f, -0.75981516f, -0.03514434f, 0.13137364f, 0.2965003f, 0.13289887f, 0.0f, 0.0f, 0.7272073f, -0.0170513f, 0.10403853f, 0.57016796f, 0.1000665f, -0.35348266f, 0.0f, 0.0f, 0.05248672f, 0.16599786f, -0.49406272f, 0.5184747f, 0.6392717f, -0.21933445f, 0.0f, 0.0f, -0.57224125f, -0.08998594f, 0.44829956f, 0.5383668f, -0.05129933f, -0.41352093f, 0.0f, 0.0f, -0.35034585f, -0.37367517f, -0.5267601f, 0.12379417f, 0.4256649f, 0.51345193f, 0.0f, 0.0f, 0.40936908f, 0.3303602f, 0.46771482f, 0.15073372f, 0.51541334f, -0.46491972f, 0.0f, 0.0f, -0.6433975f, -0.29341468f, -0.5084162f, -0.08065981f, -0.468735f, -0.12345817f, 0.0f, 0.0f, 0.46950904f, 0.41685006f, -0.33378792f, -0.3961703f, 0.5465977f, 0.19662896f, 0.0f, 0.0f, -0.49213883f, 0.5045059f, -0.00732472f, 0.5795842f, 0.3959145f, 0.1027298f, 0.0f, 0.0f, 0.34572956f, 0.6277011f, 0.12165109f, 0.3526725f, 0.3484237f, -0.47527513f, 0.0f, 0.0f, 0.07628223f, 0.5646119f, -0.39242673f, -0.20639694f, 0.33197603f, 0.6071144f, 0.0f, 0.0f, 0.4679259f, -0.38434666f, -0.46719345f, -0.4016952f, -0.06134349f, 0.49993116f, 0.0f, 0.0f, -0.25398818f, -0.8225502f, 0.40372968f, 0.21051604f, 0.02038482f, 0.22621006f, 0.0f, 0.0f, 0.2326949f, -0.42234242f, -0.18886779f, 0.44290933f, -0.40895241f, 0.6069581f, 0.0f, 0.0f, -0.13615584f, 0.26142848f, 0.68738604f, 0.42914966f, 0.263323f, 0.43256062f, 0.0f, 0.0f, 0.06145597f, -0.25432792f, 0.65050465f, 0.35622066f, -0.5267095f, -0.32259598f, 0.0f, 0.0f, -0.28027055f, 0.30275297f, 0.3908387f, 0.17564172f, 0.25278202f, 0.76307625f, 0.0f, 0.0f, -0.629371f, -0.24958587f, 0.11855057f, 0.5271422f, 0.4775915f, -0.14687496f, 0.0f, 0.0f, 0.68607575f, 0.28465343f, 0.57132494f, 0.11365238f, -0.32111326f, -0.07635256f, 0.0f, 0.0f, 0.42669573f, -0.16439965f, -0.54881376f, -0.5655122f, 0.4027156f, -0.08788072f, 0.0f, 0.0f, -0.30211043f, -0.47278547f, 0.05013786f, 0.46804386f, -0.3945016f, 0.554971f, 0.0f, 0.0f, 0.31255895f, 0.03447891f, -0.07923299f, 0.3980316f, 0.822814f, 0.24369694f, 0.0f, 0.0f, -0.5524322f, 0.49350232f, 0.5253067f, 0.25362578f, 0.26218498f, -0.20557247f, 0.0f, 0.0f, 0.06076301f, -0.0239384f, 0.3655741f, 0.55368745f, 0.255579f, -0.7001428f, 0.0f, 0.0f, 0.36398575f, 0.04911046f, -0.24289511f, -0.18733972f, 0.0201308f, 0.87784f, 0.0f, 0.0f, -0.6238549f, 0.02094759f, -0.4454863f, -0.21069895f, -0.6055913f, 0.02780938f, 0.0f, 0.0f, 0.5156284f, -0.2741613f, -0.1436558f, -0.46525735f, 0.16338488f, 0.628623f, 0.0f, 0.0f, 0.5208519f, 0.513593f, 0.02184478f, 0.53521776f, -0.23767218f, -0.348586f, 0.0f, 0.0f, 0.12263603f, 0.5391295f, 0.5755073f, -0.10335514f, 0.5752471f, 0.14662749f, 0.0f, 0.0f, 0.40942177f, 0.17197663f, -0.02523801f, -0.20104824f, -0.60303015f, 0.63094777f, 0.0f, 0.0f, 0.0516857f, 0.23577797f, -0.19154993f, -0.67743576f, -0.510703f, 0.43047547f, 0.0f, 0.0f, 0.2137384f, -0.44348267f, 0.34347987f, -0.49945694f, 0.45888698f, -0.42382318f, 0.0f, 0.0f, -0.60376537f, -0.06530087f, 0.49448067f, 0.12358559f, 0.58623743f, -0.16656622f, 0.0f, 0.0f, 0.4414093f, -0.4169255f, -0.23774987f, -0.27542785f, 0.39264396f, 0.58717644f, 0.0f, 0.0f, -0.678607f, 0.20709912f, -0.12832399f, -0.5838122f, 0.24050209f, 0.28540775f, 0.0f, 0.0f, -0.0213245f, 0.00986587f, 0.26949012f, 0.42580554f, -0.829032f, -0.24128534f, 0.0f, 0.0f, -0.20344882f, 0.5171962f, 0.24379623f, 0.11303683f, -0.46058655f, -0.6377796f, 0.0f, 0.0f, 0.15686479f, -0.6777717f, -0.04974608f, 0.5131321f, 0.49928668f, -0.03086314f, 0.0f, 0.0f, 0.5352713f, -0.501026f, -0.6075447f, -0.252351f, 0.13490559f, 0.10708155f, 0.0f, 0.0f, -0.20613512f, 0.39533043f, -0.34422305f, 0.47921455f, -0.1917804f, -0.645218f, 0.0f, 0.0f, 0.33047795f, 0.4914854f, -0.3000435f, 0.3347331f, 0.31079742f, 0.5920803f, 0.0f, 0.0f, -0.52688855f, 0.4025031f, 0.38833192f, 0.50432307f, -0.3332749f, -0.21015252f, 0.0f, 0.0f, -0.3030642f, -0.34460825f, -0.26894227f, -0.5857965f, -0.51178485f, 0.3346432f, 0.0f, 0.0f, -0.20258582f, -0.29195675f, 0.11887973f, 0.9121154f, 0.03411881f, -0.16269371f, 0.0f, 0.0f, 0.61207676f, -0.21883722f, -0.23415725f, 0.00414476f, -0.34019274f, 0.6378827f, 0.0f, 0.0f, 0.11272999f, -0.54780877f, -0.62497663f, -0.4137374f, 0.3330601f, 0.12039112f, 0.0f, 0.0f, 0.24918468f, -0.06873428f, -0.4223458f, 0.12235329f, -0.26545137f, 0.8181515f, 0.0f, 0.0f, 0.32048708f, -0.40233907f, 0.24633288f, -0.3708776f, -0.554668f, -0.4790873f, 0.0f, 0.0f, -0.33748728f, -0.45507985f, -0.50597644f, -0.28637016f, -0.54042f, -0.22120318f, 0.0f, 0.0f, -0.23520315f, 0.8219509f, -0.22661284f, 0.16382454f, -0.41400233f, -0.13959354f, 0.0f, 0.0f, -0.3049575f, -0.47964558f, -0.68490237f, -0.43240777f, -0.13521732f, -0.0508877f, 0.0f, 0.0f, -0.5662925f, 0.19768903f, -0.08007522f, -0.29952636f, 0.09597442f, -0.73136353f, 0.0f, 0.0f, -0.21316607f, 0.47585902f, -0.4942985f, -0.24146904f, 0.45631328f, 0.46610972f, 0.0f, 0.0f, 0.12647584f, -0.102037f, 0.20801342f, 0.6641889f, -0.6521978f, -0.25261414f, 0.0f, 0.0f, -0.6934528f, 0.3014998f, -0.4687094f, 0.20092958f, -0.2181792f, 0.34721422f, 0.0f, 0.0f, -0.6900142f, 0.09722776f, -0.37852252f, -0.24995375f, 0.24829304f, 0.49701267f, 0.0f, 0.0f, -0.8227851f, 0.05074883f, -0.3934733f, 2.998E-4f, -0.34677213f, -0.2130187f, 0.0f, 0.0f, -0.5182181f, -0.22147302f, 0.53524315f, 0.12892242f, -0.55439556f, -0.26821452f, 0.0f, 0.0f, -0.21006612f, 0.2607921f, -0.02187063f, 0.72402585f, -0.2765166f, 0.5354498f, 0.0f, 0.0f, -0.09974428f, -0.4534213f, 0.7195498f, -0.31082395f, -0.26933825f, 0.31233585f, 0.0f, 0.0f, -0.4812195f, -0.43051246f, -0.5038415f, 0.1234271f, 0.03746782f, -0.5590997f, 0.0f, 0.0f, -0.51180834f, -0.07995548f, -0.53046703f, 0.4874821f, 0.16148937f, -0.43191028f, 0.0f, 0.0f, -0.38131648f, 0.46242478f, 0.46416074f, -0.2063411f, -0.5377849f, 0.30582118f, 0.0f, 0.0f, 0.6245043f, 0.14316691f, -0.14361037f, 0.2751925f, -0.60467863f, -0.35708046f, 0.0f, 0.0f, 0.5242589f, -0.20390682f, -0.33609143f, 0.51803374f, 0.28921536f, 0.46756035f, 0.0f, 0.0f, -0.4455164f, 0.31831804f, 0.2421775f, 0.4982122f, -0.47209418f, 0.4128565f, 0.0f, 0.0f, -0.01585731f, -0.45214513f, -0.14591363f, 0.74070674f, 0.00988742f, -0.4746349f, 0.0f, 0.0f, 0.24260837f, 0.44639367f, 0.3152857f, 0.45334774f, -0.47964168f, -0.45484996f, 0.0f, 0.0f, 0.47123462f, 0.6452505f, -0.06425763f, -0.1873773f, -0.11735335f, -0.55549854f, 0.0f, 0.0f, -0.02519722f, -0.25796327f, 0.26277107f, -0.58236206f, -0.4189354f, 0.59086293f, 0.0f, 0.0f, -0.4894033f, 0.33728564f, -0.05763492f, 0.4486202f, -0.40048257f, 0.53080565f, 0.0f, 0.0f, 0.7335066f, -0.02148298f, 0.01656814f, 0.00219059f, 0.4938496f, 0.4661971f, 0.0f, 0.0f, -0.2515123f, -0.6200996f, -0.26948658f, 0.31711936f, -0.35081923f, 0.5059211f, 0.0f, 0.0f, 0.00942985f, -0.35926f, 0.47529206f, -0.26709476f, -0.5335215f, 0.5375463f, 0.0f, 0.0f, -0.59485495f, -0.53195924f, -0.09438376f, -0.4170449f, -0.4139753f, -0.09463944f, 0.0f, 0.0f, -0.74917126f, -0.24166384f, 0.22864553f, 0.31721357f, 0.06066292f, -0.47303042f, 0.0f, 0.0f, -0.3300396f, -0.08758658f, -0.09672609f, -0.3960709f, 0.5556693f, 0.63906646f, 0.0f, 0.0f, -0.5893307f, -0.3817687f, 0.46748018f, -0.06135883f, 0.3626848f, -0.3912788f, 0.0f, 0.0f, -0.06655669f, -0.73863083f, -0.32153946f, 0.574546f, -0.09085689f, -0.09082394f, 0.0f, 0.0f, -0.36335403f, -0.41643676f, -0.5783983f, -0.03095988f, 0.59897923f, -0.01658256f, 0.0f, 0.0f, 0.23126668f, 0.21077907f, -0.14272194f, -0.29232225f, -0.4845134f, -0.7493416f, 0.0f, 0.0f, 0.48188198f, -0.04021475f, -0.1566797f, 0.16054852f, -0.60839754f, -0.5879631f, 0.0f, 0.0f, 0.31319356f, -0.19280657f, 0.7613669f, -0.08450623f, 0.47687867f, -0.22472487f, 0.0f, 0.0f, 0.6750454f, 0.36920157f, 0.4032105f, 0.03443604f, -0.2933273f, 0.3977417f, 0.0f, 0.0f, -0.14591599f, -0.59726185f, -0.03638422f, -0.6509349f, 0.3951571f, -0.20198429f, 0.0f, 0.0f, 0.6009213f, 0.18110181f, 0.2579492f, -0.3959477f, 0.15112959f, 0.5999527f, 0.0f, 0.0f, -0.42310244f, -0.26937196f, 0.07470001f, 0.5311951f, 0.41614375f, 0.53618944f, 0.0f, 0.0f, 0.00716054f, -0.69599783f, -0.0531386f, -5.45E-4f, 0.6953387f, 0.17092635f, 0.0f, 0.0f, 0.12447149f, 0.33265314f, 0.35070014f, 0.53879935f, 0.37648082f, 0.5646376f, 0.0f, 0.0f, 0.29540077f, 0.04954124f, -0.48345086f, 0.72758496f, 0.0700691f, 0.37718663f, 0.0f, 0.0f, 0.48824143f, 0.45135802f, 0.48450857f, -0.26042408f, -0.4251358f, 0.27310535f, 0.0f, 0.0f, -0.4980637f, -0.47197595f, 0.02964708f, -0.13788472f, -0.4534614f, -0.551047f, 0.0f, 0.0f, -0.5359512f, -0.5358547f, 0.17710362f, -0.45377633f, 0.41838965f, 0.11527149f, 0.0f, 0.0f, -0.36846432f, -0.4653318f, 0.65800816f, -0.28691298f, 0.31521457f, 0.18178646f, 0.0f, 0.0f, -0.29243127f, -0.43529564f, -0.58895975f, -0.4964947f, 0.29271343f, 0.21433587f, 0.0f, 0.0f, 0.05625669f, -0.5038771f, 0.4814504f, 0.44723672f, -0.5577117f, -0.00924491f, 0.0f, 0.0f, -0.40973124f, -0.7314717f, -0.0940763f, 0.4303345f, 0.01433427f, -0.32066458f, 0.0f, 0.0f, 0.26752725f, 0.50477344f, 0.06506951f, 0.36001098f, 0.59393394f, -0.43247366f, 0.0f, 0.0f, 0.4894572f, 0.60433155f, 0.12458128f, -0.48327804f, -0.25681943f, 0.2831618f, 0.0f, 0.0f, -0.4518276f, 0.21574003f, -0.31462622f, 0.2527935f, 0.4486573f, -0.62058073f, 0.0f, 0.0f, 0.44017303f, 0.43789554f, 0.5842356f, 0.41842994f, -0.26836655f, 0.16143005f, 0.0f, 0.0f, -0.67897034f, -0.32730886f, -0.02439973f, 0.40649244f, 0.47711065f, -0.19596475f, 0.0f, 0.0f, 0.57441586f, 0.09386994f, 0.28400794f, 0.5939423f, 0.45349905f, 0.14881355f, 0.0f, 0.0f, -0.33937398f, -0.54929054f, 0.26209494f, 0.07338003f, 0.5655708f, 0.43492126f, 0.0f, 0.0f, 0.05000799f, 0.7465276f, -0.36432144f, -0.20993543f, -0.1352041f, 0.4950884f, 0.0f, 0.0f, -0.04133215f, -0.20655741f, 0.5251128f, 0.04724863f, -0.6276122f, -0.53268445f, 0.0f, 0.0f, -0.18894911f, 0.05188976f, -0.45677122f, 0.42884457f, 0.6161209f, -0.43526217f, 0.0f, 0.0f, -0.6587354f, -0.09477005f, 0.4084403f, 0.35536012f, -0.16940065f, 0.48506227f, 0.0f, 0.0f, -0.45779282f, -0.46052673f, 0.3413805f, -0.5494327f, 0.37140593f, -0.14826176f, 0.0f, 0.0f, -0.06937871f, -0.14845487f, -0.73991835f, 0.41519183f, -0.11098464f, -0.49088356f, 0.0f, 0.0f, 0.46422562f, 0.46130717f, -0.4420779f, 0.12050605f, 0.34969556f, -0.48933494f, 0.0f, 0.0f, -0.35482925f, 0.28146982f, -0.35356605f, -0.38774753f, 0.35979703f, -0.6245478f, 0.0f, 0.0f, -0.4834319f, 0.41492185f, -0.50175315f, 0.21953122f, -0.5408316f, 0.04104095f, 0.0f, 0.0f, -0.5128051f, -0.54131126f, -0.00992871f, 0.23788701f, 0.43503332f, 0.44505087f, 0.0f, 0.0f, 0.22538373f, -0.30117118f, 0.46587685f, -0.46672902f, -0.5918207f, 0.27086738f, 0.0f, 0.0f, 0.43015757f, -0.06785111f, -0.26917803f, -0.5773186f, -0.5395012f, -0.33696523f, 0.0f, 0.0f, 0.20858352f, 0.63695055f, 0.49453142f, -0.04623537f, -0.5443625f, -0.08807572f, 0.0f, 0.0f, -0.35626465f, 0.06753954f, -0.18142793f, -0.49044207f, 0.5542388f, 0.53654796f, 0.0f, 0.0f, 0.5223854f, 0.55175877f, 0.29070267f, -0.14119026f, -0.5584159f, -0.08002963f, 0.0f, 0.0f, -0.025988f, 0.46612948f, -0.5688097f, -0.44824564f, -0.03000049f, 0.50663525f, 0.0f, 0.0f, 0.04728458f, -0.26595724f, 0.21032032f, 0.52986836f, -0.52245337f, -0.57365346f, 0.0f, 0.0f, -0.31924245f, -0.1388842f, 0.307258f, 0.4979233f, 0.6103559f, -0.40487772f, 0.0f, 0.0f, 0.03875857f, -0.53813547f, -0.56167257f, 0.46815372f, -0.14142713f, 0.39276248f, 0.0f, 0.0f, -0.19936872f, 0.1248886f, -0.6299003f, -0.29296145f, 0.4973453f, 0.46335924f, 0.0f, 0.0f, -0.0788267f, -0.155488f, 0.5745677f, 0.55588543f, -0.56893057f, -0.08240882f, 0.0f, 0.0f, 0.11678856f, 0.5335876f, 0.4930249f, -0.53981847f, -0.23791336f, -0.33251226f, 0.0f, 0.0f, 0.39126927f, -0.39416116f, -0.35778844f, -0.3939561f, 0.50270355f, -0.3944876f, 0.0f, 0.0f, -0.1796129f, 0.3423953f, -0.21870226f, -0.23322836f, 0.75997835f, 0.41317236f, 0.0f, 0.0f, 0.296995f, 0.17195435f, -0.34903628f, -0.31751883f, -0.59661543f, 0.5510273f, 0.0f, 0.0f, -0.22372913f, -0.512543f, -0.31277317f, 0.542702f, -0.3488501f, 0.41616818f, 0.0f, 0.0f, 0.53534025f, 0.45905986f, -0.20308675f, 0.01952364f, 0.33785805f, 0.58898336f, 0.0f, 0.0f, -0.04503846f, -0.5255333f, -0.6098546f, 0.46226028f, -0.3606903f, 0.07798443f, 0.0f, 0.0f, -0.40129033f, 0.39526722f, -0.20379584f, 0.45466492f, 0.46504796f, -0.4671267f, 0.0f, 0.0f, -0.43845832f, -0.5928453f, 0.0502419f, -0.3649484f, 0.3236388f, 0.4645805f, 0.0f, 0.0f, -0.4605736f, -0.34584627f, -0.12264748f, 0.48835438f, 0.21102525f, 0.6084392f, 0.0f, 0.0f, -0.08604754f, -0.16981605f, -0.37222832f, 0.4515861f, -0.55710256f, 0.55759406f, 0.0f, 0.0f, 0.54697454f, -0.45070836f, 0.03296252f, -0.48584333f, -0.28055686f, 0.42642516f, 0.0f, 0.0f, 0.34061924f, 0.38443008f, 0.61614805f, -0.5577417f, -0.07566037f, 0.19938219f, 0.0f, 0.0f, 0.30626923f, -0.05793904f, -0.10461119f, -0.43956387f, -0.57307196f, 0.6084989f, 0.0f, 0.0f, -0.52519953f, -0.42567533f, -0.198965f, 0.48819482f, 0.12539008f, 0.49932158f, 0.0f, 0.0f, -0.10173361f, -0.0787385f, 0.3713554f, 0.65889543f, 0.6341189f, 0.09641423f, 0.0f, 0.0f, 0.60342395f, 0.05761737f, 0.3555884f, 0.20766418f, 0.03067018f, -0.67974377f, 0.0f, 0.0f, -0.07197105f, -0.44567382f, 0.65917593f, 0.44113803f, -0.29627118f, 0.2816074f, 0.0f, 0.0f, 0.38284478f, 0.4355232f, -0.42823684f, -0.5480926f, -0.27202272f, 0.32551613f, 0.0f, 0.0f, -0.747557f, -0.20979308f, 0.192683f, 0.27864012f, -0.39085278f, 0.36001727f, 0.0f, 0.0f, -0.64575535f, 0.59253746f, 0.04088551f, -0.20167391f, -0.43481684f, -0.02212841f, 0.0f, 0.0f, 0.45874104f, -0.00665875f, -0.30494055f, 0.5273106f, -0.64443886f, 0.05626427f, 0.0f, 0.0f, 0.61573774f, -7.4622E-4f, 0.2545566f, 0.3067028f, -0.18573195f, 0.6538383f, 0.0f, 0.0f, -0.08991956f, -0.28968403f, -0.6061829f, 0.53370863f, 0.37921557f, -0.33450055f, 0.0f, 0.0f, -0.47481167f, 0.38992742f, -0.10479631f, 0.45545456f, 0.12142073f, 0.62397623f, 0.0f, 0.0f, 0.59154224f, -0.10812441f, -0.46858346f, -0.3600727f, -0.10123747f, 0.5281241f, 0.0f, 0.0f, -0.01292122f, -0.23607533f, -0.5768041f, -0.44955814f, -0.31913444f, -0.554481f, 0.0f, 0.0f, 0.542314f, -0.31845385f, -0.38636422f, 0.2218798f, -0.6346426f, -0.05659949f, 0.0f, 0.0f, -0.4195069f, -0.4578029f, 0.31139812f, 0.39787963f, -0.20885901f, 0.5617218f, 0.0f, 0.0f, -0.03140488f, 0.56267476f, -0.5556815f, 0.33075362f, 0.39071116f, 0.3340295f, 0.0f, 0.0f, -0.5148516f, -0.34037012f, -0.4682609f, -0.6008668f, -0.0750694f, 0.18202034f, 0.0f, 0.0f, -0.49669644f, 0.13236482f, 0.5344074f, 0.472012f, -0.05992551f, -0.47306928f, 0.0f, 0.0f, -0.3279685f, 0.655933f, 0.2080003f, -0.38965914f, -0.5156456f, -0.03463672f, 0.0f, 0.0f, -0.30473793f, 0.1258423f, 0.6391121f, 0.11269477f, 0.6294434f, 0.27191007f, 0.0f, 0.0f, -0.53642195f, 0.50742227f, -0.2290782f, 0.4702256f, -0.19141255f, 0.3801926f, 0.0f, 0.0f, -0.28865424f, 0.7616967f, -0.36166126f, -0.30555403f, -0.12541658f, -0.31081402f, 0.0f, 0.0f, 0.00259784f, 0.37371463f, -0.31515118f, 0.6203281f, 0.6052464f, -0.09939888f, 0.0f, 0.0f, -0.40019834f, 0.1593148f, -0.6165303f, -0.4947944f, -0.02151791f, -0.43481714f, 0.0f, 0.0f, -0.26445144f, -0.48401156f, 0.27737057f, -0.12537485f, -0.46956235f, 0.6185921f, 0.0f, 0.0f, -0.49776295f, 0.6509513f, -0.20147786f, 0.26022926f, 0.39526194f, -0.252883f, 0.0f, 0.0f, 0.20792542f, 0.67256f, 0.01329671f, 0.0690824f, -0.37233546f, 0.6007056f, 0.0f, 0.0f, -0.60329264f, 0.40708026f, -0.17229997f, -0.5299795f, 0.22211745f, -0.33229783f, 0.0f, 0.0f, 0.61826885f, -0.6258217f, 0.33820438f, 0.2387092f, -0.20670655f, -0.10953969f, 0.0f, 0.0f, -0.6367817f, -0.5110165f, -0.19131817f, -0.49493417f, -0.22614515f, 0.02582853f, 0.0f, 0.0f, 0.70684624f, 0.0729328f, -0.30827034f, -0.526597f, -0.33954838f, 0.08614532f, 0.0f, 0.0f, -0.5242905f, 0.39091423f, 0.5281921f, -0.16569161f, 0.44719166f, 0.25667977f, 0.0f, 0.0f, 0.8503398f, -0.37311667f, -0.03158551f, -0.06354692f, -0.35026506f, 0.09992363f, 0.0f, 0.0f, -0.43149573f, 0.16017753f, -0.36624038f, 0.4937203f, -0.60067105f, 0.22238962f, 0.0f, 0.0f, -0.43599537f, -0.36065835f, -0.42475054f, -0.5230176f, 0.03945453f, 0.47362065f, 0.0f, 0.0f, -0.3579317f, -0.43917817f, -0.49072242f, -0.32880276f, -0.3850956f, -0.42636725f, 0.0f, 0.0f, -0.04367964f, 0.74697226f, -0.40732953f, -0.48088968f, 0.1802929f, -0.10220931f, 0.0f, 0.0f, -0.05890257f, 0.00825952f, 0.7136596f, -0.5304379f, 0.22906332f, 0.39155823f, 0.0f, 0.0f, 0.43459648f, 0.1896447f, 0.15217426f, 0.59694624f, 0.05378658f, 0.6267104f, 0.0f, 0.0f, -0.48833576f, 0.06890988f, 0.60168403f, -0.05545504f, -0.62426263f, -0.04446193f, 0.0f, 0.0f, -0.7182214f, 0.05449495f, 0.25733757f, -0.4270688f, -0.44024664f, 0.19687748f, 0.0f, 0.0f, 0.4723221f, 0.63009685f, 0.21662569f, 0.3106372f, 0.07945588f, 0.47974408f, 0.0f, 0.0f, -0.39506537f, 0.42517728f, 0.29375774f, 0.04450363f, -0.46173212f, 0.6013957f, 0.0f, 0.0f, -0.40354127f, 0.41304135f, -0.2953398f, -0.45300698f, 0.23702355f, -0.56385297f, 0.0f, 0.0f, -0.6231538f, -0.42397904f, 0.5304408f, 0.37874433f, 0.05492271f, 0.06395219f, 0.0f, 0.0f, 0.41959044f, -0.83420444f, -0.25505373f, 0.2501231f, 0.01097423f, 0.01767574f, 0.0f, 0.0f, -0.25231576f, -0.17034034f, -0.00222544f, -0.4967771f, 0.431849f, -0.68850195f, 0.0f, 0.0f, -0.18528128f, -0.48330897f, 0.13528869f, 0.15202104f, 0.57661283f, -0.5984877f, 0.0f, 0.0f, 0.6428747f, -0.30923674f, 0.22234318f, 0.09924896f, 0.6437045f, 0.1320696f, 0.0f, 0.0f, -0.490189f, 0.6865412f, -0.27238864f, -0.08583242f, 0.44161946f, 0.10856057f, 0.0f, 0.0f, 0.48795432f, 0.42184192f, -0.43797314f, 0.35186997f, -0.46483433f, 0.22857392f, 0.0f, 0.0f, 0.5297083f, -0.5068449f, -0.3978216f, -0.39327094f, -0.34863028f, 0.16748196f, 0.0f, 0.0f, -0.46048504f, -0.3887127f, -0.6828732f, -0.1844853f, -0.25358257f, 0.2687028f, 0.0f, 0.0f, 0.6889557f, -0.31010228f, -0.35882193f, 0.30088738f, -0.03913954f, -0.45646277f, 0.0f, 0.0f, -0.21954767f, 0.40838838f, 0.23284186f, 0.30349648f, 0.5723326f, 0.5577882f, 0.0f, 0.0f, 0.5773103f, 0.0912183f, 0.70670015f, 0.01635803f, 0.39392453f, -0.05935263f, 0.0f, 0.0f, 0.5005557f, -0.02174979f, 0.5676785f, 0.50580174f, 0.3469132f, 0.22478399f, 0.0f, 0.0f, -0.3790191f, 0.538041f, -0.46780196f, 0.51497346f, -0.27981004f, 0.06727844f, 0.0f, 0.0f, 0.672419f, 0.07409958f, 0.43138117f, 0.05456751f, -0.37927768f, 0.45764947f, 0.0f, 0.0f, 0.1452919f, -0.23854981f, 0.45401648f, 0.2546654f, 0.4618207f, -0.66160446f, 0.0f, 0.0f, -0.1557098f, -0.38476786f, 0.3732284f, -0.43977612f, -0.61243004f, -0.34631643f, 0.0f, 0.0f, -0.19590302f, 0.42065975f, 0.43447548f, -0.10575548f, 0.7043995f, -0.2975492f, 0.0f, 0.0f, -0.13558865f, 0.14270733f, 0.49647495f, -0.6553323f, -0.11714854f, 0.5211321f, 0.0f, 0.0f, -0.6228375f, 0.20812698f, -0.16205154f, 0.20384566f, -0.5932189f, 0.38604942f, 0.0f, 0.0f, 0.44487837f, -0.37224942f, -0.22188447f, 0.48921537f, 0.4143242f, -0.450871f, 0.0f, 0.0f, 0.66422844f, 0.21517761f, 0.09401257f, -0.4358159f, 0.2224568f, -0.5140412f, 0.0f, 0.0f, -0.11369362f, 0.3228469f, -0.38818285f, 0.49680024f, 0.04768486f, -0.6950348f, 0.0f, 0.0f, -0.5137201f, -0.5067323f, 0.32715252f, -0.26799715f, -0.4761651f, 0.27153194f, 0.0f, 0.0f, -0.47315177f, -0.45711496f, -0.3117828f, -0.5169776f, -0.14302371f, -0.42689943f, 0.0f, 0.0f, -0.05044203f, 0.23609184f, 0.3863488f, 0.56012774f, 0.3896367f, -0.57174385f, 0.0f, 0.0f, -0.15472133f, -0.1533358f, -0.14189768f, 0.03227926f, -0.66054296f, -0.7036018f, 0.0f, 0.0f, -0.10345191f, -0.30503726f, 0.31038263f, 0.36878845f, -0.7682477f, 0.27148306f, 0.0f, 0.0f, -0.06021286f, -0.41727555f, 0.391993f, -0.44040105f, 0.24955101f, -0.64215904f, 0.0f, 0.0f, 0.25443196f, -0.01378958f, 0.44365f, 0.532962f, -0.5505775f, -0.38867053f, 0.0f, 0.0f, -0.36068565f, -0.6561666f, -0.48495996f, 0.24088316f, -0.18080297f, -0.33682436f, 0.0f, 0.0f, -0.5382455f, -0.0967289f, -0.520862f, 0.3319532f, -0.03226394f, 0.5642732f, 0.0f, 0.0f, 0.40151656f, -0.44825724f, -0.5491002f, -0.09593627f, 0.5719564f, 9.7783E-4f, 0.0f, 0.0f, 0.21961099f, 0.62823725f, -0.01004593f, -0.66105646f, -0.17161594f, -0.30089924f, 0.0f, 0.0f, 0.27961472f, 0.05452339f, 0.61485904f, 0.11958885f, -0.61032563f, -0.39241856f, 0.0f, 0.0f, -0.30223066f, -0.23605925f, -0.09697276f, -0.46458104f, -0.37853464f, 0.69599205f, 0.0f, 0.0f, 0.00236355f, 0.627021f, 0.49658954f, -0.20369644f, -0.5645756f, 2.1299E-4f, 0.0f, 0.0f, -0.64198494f, 0.5967626f, 0.46274573f, 0.08842191f, 0.09802999f, -0.01295307f, 0.0f, 0.0f, -0.05396543f, 0.13439533f, -0.33103493f, 0.55991757f, -0.581276f, -0.4669604f, 0.0f, 0.0f, -0.43965992f, 0.07544961f, 0.15096395f, -0.38868406f, -0.0033436f, -0.79191536f, 0.0f, 0.0f, -0.21743914f, -0.3201963f, -0.5606711f, 0.02728491f, -0.49444926f, -0.5390899f, 0.0f, 0.0f, -0.36492598f, 0.525299f, 0.18002252f, 0.14829475f, 0.17212619f, -0.71194315f, 0.0f, 0.0f, 0.00518762f, 0.50490296f, 0.24361032f, 0.13688117f, -0.6138129f, -0.5386997f, 0.0f, 0.0f, 0.6642118f, 0.21833853f, -0.08790993f, 0.15624551f, -0.68780726f, 0.07701505f, 0.0f, 0.0f, 0.5271063f, -0.4214367f, -0.06996455f, -0.24196342f, -0.68814844f, 0.08695091f, 0.0f, 0.0f, 0.62392247f, -0.23663281f, -0.59058625f, 0.22685863f, -0.36683947f, -0.14105847f, 0.0f, 0.0f, 0.18069851f, -0.08382855f, 0.6624017f, 0.16722813f, -0.2550364f, -0.6546266f, 0.0f, 0.0f, -0.37112528f, 0.43100318f, -0.11342774f, 0.14418808f, 0.5753327f, 0.558425f, 0.0f, 0.0f, 0.55378723f, 0.2109816f, -0.32249767f, 0.31268308f, -0.37624696f, -0.5526927f, 0.0f, 0.0f, 0.2601466f, 0.5637346f, -0.21638358f, 0.41216916f, -0.25078073f, -0.5787321f, 0.0f, 0.0f, 0.11217864f, 0.54196554f, -0.31989127f, 0.5469122f, 0.24062434f, 0.48409277f, 0.0f, 0.0f, 0.08756442f, -0.12083081f, 0.69931173f, 0.35220575f, 0.28770483f, -0.5309167f, 0.0f, 0.0f, 0.33957022f, 0.04252094f, -0.30935928f, 0.6102221f, 0.54650813f, 0.34079123f, 0.0f, 0.0f, 0.32746112f, 0.3209522f, -0.61142534f, 0.32197323f, -0.3823607f, 0.4074941f, 0.0f, 0.0f, 0.58741915f, -0.3091603f, -0.5764298f, -0.03884619f, 0.04792671f, -0.47252658f, 0.0f, 0.0f, 0.02622438f, 0.0317689f, -0.12510902f, 0.36102733f, -0.72217214f, 0.57513255f, 0.0f, 0.0f, -0.27510375f, -0.5153402f, 0.02577402f, 0.5920107f, 0.40728366f, -0.37645912f, 0.0f, 0.0f, -0.2998334f, -0.6101729f, -0.18551919f, 0.50515944f, 0.18206593f, -0.46372136f, 0.0f, 0.0f, -0.64290893f, -0.3488701f, -0.55318606f, -0.21230198f, -0.19828983f, 0.273042f, 0.0f, 0.0f, -0.3277888f, -0.09431729f, 0.5781117f, 0.5434669f, 0.17699502f, -0.47197676f, 0.0f, 0.0f, -0.0757387f, 0.5338175f, -0.13406342f, 0.7176539f, 0.3427106f, 0.24259408f, 0.0f, 0.0f, -0.30574274f, 0.17419448f, -0.7886155f, 0.43305677f, 0.06485332f, 0.25003806f, 0.0f, 0.0f, 0.43970358f, -0.5165152f, -0.39723462f, -0.3451349f, 0.3212983f, -0.3996583f, 0.0f, 0.0f, -0.251849f, -0.35937572f, 0.15273239f, -0.51640934f, 0.42187157f, -0.5826146f, 0.0f, 0.0f, -0.57396f, 0.1912786f, 0.45995635f, -0.43664715f, 0.460163f, 0.1414631f, 0.0f, 0.0f, 0.11500068f, 0.05112652f, -0.25672856f, -0.5471574f, 0.6766993f, 0.40118355f, 0.0f, 0.0f, -0.4525267f, -0.4080999f, -0.06493154f, 0.19116563f, 0.7652301f, 0.0483374f, 0.0f, 0.0f, -0.08007565f, 0.7530531f, 0.34797424f, 0.29104492f, 0.00401859f, -0.46977597f, 0.0f, 0.0f, -0.38902575f, 0.4910004f, -0.17812125f, -0.43787557f, -0.46923187f, 0.40489107f, 0.0f, 0.0f, 0.37433237f, -0.29441765f, -0.06628513f, 0.33217472f, 0.7391716f, 0.334791f, 0.0f, 0.0f, -0.0297323f, -0.51371026f, 0.3413352f, -0.4136179f, -0.51561743f, -0.42634124f, 0.0f, 0.0f, 0.5105717f, -0.237402f, 0.26673588f, 0.5521767f, 0.16849318f, 0.52774966f, 0.0f, 0.0f};
    private static final Float2[] CELL_2D = new Float2[]{new Float2(-0.43135393f, 0.12819435f), new Float2(-0.17333168f, 0.41527838f), new Float2(-0.28219575f, -0.35052183f), new Float2(-0.28064737f, 0.35176277f), new Float2(0.3125509f, -0.3237467f), new Float2(0.33830184f, -0.29673535f), new Float2(-0.4393982f, -0.09710417f), new Float2(-0.44604436f, -0.05953503f), new Float2(-0.30222303f, 0.3334085f), new Float2(-0.21268106f, -0.39656875f), new Float2(-0.29911566f, 0.33619907f), new Float2(0.22933237f, 0.38717782f), new Float2(0.44754392f, -0.046951506f), new Float2(0.1777518f, 0.41340572f), new Float2(0.16885225f, -0.4171198f), new Float2(-0.097659715f, 0.43927506f), new Float2(0.084501885f, 0.44199485f), new Float2(-0.40987605f, -0.18574613f), new Float2(0.34765857f, -0.2857158f), new Float2(-0.335067f, -0.30038327f), new Float2(0.229819f, -0.38688916f), new Float2(-0.010699241f, 0.4498728f), new Float2(-0.44601414f, -0.059761196f), new Float2(0.3650294f, 0.26316068f), new Float2(-0.34947944f, 0.28348568f), new Float2(-0.41227207f, 0.18036559f), new Float2(-0.26732782f, 0.36198872f), new Float2(0.32212403f, -0.31422302f), new Float2(0.2880446f, -0.34573156f), new Float2(0.38921708f, -0.22585405f), new Float2(0.4492085f, -0.026678115f), new Float2(-0.44977248f, 0.014307996f), new Float2(0.12781754f, -0.43146574f), new Float2(-0.035721004f, 0.44858f), new Float2(-0.4297407f, -0.13350253f), new Float2(-0.32178178f, 0.3145735f), new Float2(-0.3057159f, 0.33020872f), new Float2(-0.414504f, 0.17517549f), new Float2(-0.373814f, 0.25052565f), new Float2(0.22368914f, -0.39046532f), new Float2(0.0029677756f, -0.4499902f), new Float2(0.17471284f, -0.4146992f), new Float2(-0.44237724f, -0.08247648f), new Float2(-0.2763961f, -0.35511294f), new Float2(-0.4019386f, -0.20234962f), new Float2(0.3871414f, -0.22939382f), new Float2(-0.43000874f, 0.1326367f), new Float2(-0.030375743f, -0.44897363f), new Float2(-0.34861815f, 0.28454417f), new Float2(0.045535173f, -0.44769025f), new Float2(-0.037580293f, 0.44842806f), new Float2(0.3266409f, 0.309525f), new Float2(0.065400176f, -0.4452222f), new Float2(0.03409026f, 0.44870687f), new Float2(-0.44491938f, 0.06742967f), new Float2(-0.4255936f, -0.14618507f), new Float2(0.4499173f, 0.008627303f), new Float2(0.052426063f, 0.44693568f), new Float2(-0.4495305f, -0.020550266f), new Float2(-0.12047757f, 0.43357256f), new Float2(-0.3419864f, -0.2924813f), new Float2(0.386532f, 0.23041917f), new Float2(0.045060977f, -0.4477382f), new Float2(-0.06283466f, 0.4455915f), new Float2(0.39326003f, -0.21873853f), new Float2(0.44722617f, -0.04988731f), new Float2(0.3753571f, -0.24820767f), new Float2(-0.2736623f, 0.35722396f), new Float2(0.17004615f, 0.4166345f), new Float2(0.41026923f, 0.18487608f), new Float2(0.3232272f, -0.31308815f), new Float2(-0.28823102f, -0.34557614f), new Float2(0.20509727f, 0.4005435f), new Float2(0.4414086f, -0.08751257f), new Float2(-0.16847004f, 0.4172743f), new Float2(-0.0039780326f, 0.4499824f), new Float2(-0.20551336f, 0.4003302f), new Float2(-0.006095675f, -0.4499587f), new Float2(-0.11962281f, -0.43380916f), new Float2(0.39015284f, -0.2242337f), new Float2(0.017235318f, 0.4496698f), new Float2(-0.30150703f, 0.33405614f), new Float2(-0.015142624f, -0.44974515f), new Float2(-0.4142574f, -0.1757578f), new Float2(-0.19163772f, -0.40715474f), new Float2(0.37492487f, 0.24886008f), new Float2(-0.22377743f, 0.39041474f), new Float2(-0.41663432f, -0.17004661f), new Float2(0.36191717f, 0.2674247f), new Float2(0.18911268f, -0.4083337f), new Float2(-0.3127425f, 0.3235616f), new Float2(-0.3281808f, 0.30789182f), new Float2(-0.22948067f, 0.38708994f), new Float2(-0.34452662f, 0.28948474f), new Float2(-0.41670954f, -0.16986217f), new Float2(-0.2578903f, -0.36877173f), new Float2(-0.3612038f, 0.26838747f), new Float2(0.22679965f, 0.38866684f), new Float2(0.20715706f, 0.3994821f), new Float2(0.083551764f, -0.44217542f), new Float2(-0.43122333f, 0.12863296f), new Float2(0.32570556f, 0.3105091f), new Float2(0.1777011f, -0.41342753f), new Float2(-0.44518253f, 0.0656698f), new Float2(0.39551434f, 0.21463552f), new Float2(-0.4264614f, 0.14363383f), new Float2(-0.37937996f, -0.24201414f), new Float2(0.04617599f, -0.4476246f), new Float2(-0.37140542f, -0.25408268f), new Float2(0.25635704f, -0.36983925f), new Float2(0.03476646f, 0.44865498f), new Float2(-0.30654544f, 0.32943875f), new Float2(-0.22569798f, 0.38930762f), new Float2(0.41164485f, -0.18179253f), new Float2(-0.29077458f, -0.3434387f), new Float2(0.28422785f, -0.3488761f), new Float2(0.31145895f, -0.32479736f), new Float2(0.44641557f, -0.05668443f), new Float2(-0.3037334f, -0.33203316f), new Float2(0.4079607f, 0.18991591f), new Float2(-0.3486949f, -0.2844501f), new Float2(0.32648215f, 0.30969244f), new Float2(0.32111424f, 0.3152549f), new Float2(0.011833827f, 0.44984436f), new Float2(0.43338442f, 0.1211526f), new Float2(0.31186685f, 0.32440573f), new Float2(-0.27275348f, 0.35791835f), new Float2(-0.42222863f, -0.15563737f), new Float2(-0.10097001f, -0.438526f), new Float2(-0.2741171f, -0.35687506f), new Float2(-0.14651251f, 0.425481f), new Float2(0.2302279f, -0.38664597f), new Float2(-0.36994356f, 0.25620648f), new Float2(0.10570035f, -0.4374099f), new Float2(-0.26467136f, 0.36393553f), new Float2(0.3521828f, 0.2801201f), new Float2(-0.18641879f, -0.40957054f), new Float2(0.1994493f, -0.40338564f), new Float2(0.3937065f, 0.21793391f), new Float2(-0.32261583f, 0.31371805f), new Float2(0.37962353f, 0.2416319f), new Float2(0.1482922f, 0.424864f), new Float2(-0.4074004f, 0.19111493f), new Float2(0.4212853f, 0.15817298f), new Float2(-0.26212972f, 0.36577043f), new Float2(-0.2536987f, -0.37166783f), new Float2(-0.21002364f, 0.3979825f), new Float2(0.36241525f, 0.2667493f), new Float2(-0.36450386f, -0.26388812f), new Float2(0.23184867f, 0.38567626f), new Float2(-0.3260457f, 0.3101519f), new Float2(-0.21300453f, -0.3963951f), new Float2(0.3814999f, -0.23865843f), new Float2(-0.34297732f, 0.29131868f), new Float2(-0.43558657f, 0.11297941f), new Float2(-0.21046796f, 0.3977477f), new Float2(0.33483645f, -0.30064023f), new Float2(0.34304687f, 0.29123673f), new Float2(-0.22918367f, -0.38726586f), new Float2(0.25477073f, -0.3709338f), new Float2(0.42361748f, -0.1518164f), new Float2(-0.15387742f, 0.4228732f), new Float2(-0.44074494f, 0.09079596f), new Float2(-0.06805276f, -0.4448245f), new Float2(0.44535172f, -0.06451237f), new Float2(0.25624645f, -0.36991587f), new Float2(0.32781982f, -0.30827612f), new Float2(-0.41227743f, -0.18035334f), new Float2(0.3354091f, -0.30000123f), new Float2(0.44663286f, -0.054946158f), new Float2(-0.16089533f, 0.42025313f), new Float2(-0.09463955f, 0.43993562f), new Float2(-0.026376883f, -0.4492263f), new Float2(0.44710281f, -0.050981198f), new Float2(-0.4365671f, 0.10912917f), new Float2(-0.39598587f, 0.21376434f), new Float2(-0.42400482f, -0.15073125f), new Float2(-0.38827947f, 0.22746222f), new Float2(-0.42836526f, -0.13785212f), new Float2(0.3303888f, 0.30552125f), new Float2(0.3321435f, -0.30361274f), new Float2(-0.41302106f, -0.17864382f), new Float2(0.084030606f, -0.44208467f), new Float2(-0.38228828f, 0.23739347f), new Float2(-0.37123957f, -0.25432497f), new Float2(0.4472364f, -0.049795635f), new Float2(-0.44665912f, 0.054732345f), new Float2(0.048627254f, -0.44736493f), new Float2(-0.42031014f, -0.16074637f), new Float2(0.22053608f, 0.3922548f), new Float2(-0.36249006f, 0.2666476f), new Float2(-0.40360868f, -0.19899757f), new Float2(0.21527278f, 0.39516786f), new Float2(-0.43593928f, -0.11161062f), new Float2(0.4178354f, 0.1670735f), new Float2(0.20076302f, 0.40273342f), new Float2(-0.07278067f, -0.4440754f), new Float2(0.36447486f, -0.26392817f), new Float2(-0.43174517f, 0.12687041f), new Float2(-0.29743645f, 0.33768559f), new Float2(-0.2998672f, 0.3355289f), new Float2(-0.26736742f, 0.3619595f), new Float2(0.28084233f, 0.35160714f), new Float2(0.34989464f, 0.28297302f), new Float2(-0.22296856f, 0.39087725f), new Float2(0.33058232f, 0.30531186f), new Float2(-0.24366812f, -0.37831977f), new Float2(-0.034027766f, 0.4487116f), new Float2(-0.31935883f, 0.31703302f), new Float2(0.44546336f, -0.063737005f), new Float2(0.44835043f, 0.03849544f), new Float2(-0.44273585f, -0.08052933f), new Float2(0.054522987f, 0.44668472f), new Float2(-0.28125608f, 0.35127628f), new Float2(0.12666969f, 0.43180412f), new Float2(-0.37359813f, 0.25084746f), new Float2(0.29597083f, -0.3389709f), new Float2(-0.37143773f, 0.25403547f), new Float2(-0.4044671f, -0.19724695f), new Float2(0.16361657f, -0.41920117f), new Float2(0.32891855f, -0.30710354f), new Float2(-0.2494825f, -0.374511f), new Float2(0.032831334f, 0.44880074f), new Float2(-0.16630606f, -0.41814148f), new Float2(-0.10683318f, 0.43713462f), new Float2(0.0644026f, -0.4453676f), new Float2(-0.4483231f, 0.03881238f), new Float2(-0.42137775f, -0.15792651f), new Float2(0.05097921f, -0.44710302f), new Float2(0.20505841f, -0.40056342f), new Float2(0.41780984f, -0.16713744f), new Float2(-0.35651895f, -0.27458012f), new Float2(0.44783983f, 0.04403978f), new Float2(-0.33999997f, -0.2947881f), new Float2(0.3767122f, 0.24614613f), new Float2(-0.31389344f, 0.32244518f), new Float2(-0.14620018f, -0.42558843f), new Float2(0.39702904f, -0.21182053f), new Float2(0.44591492f, -0.0604969f), new Float2(-0.41048893f, -0.18438771f), new Float2(0.1475104f, -0.4251361f), new Float2(0.0925803f, 0.44037357f), new Float2(-0.15896647f, -0.42098653f), new Float2(0.2482445f, 0.37533274f), new Float2(0.43836242f, -0.10167786f), new Float2(0.06242803f, 0.44564867f), new Float2(0.2846591f, -0.3485243f), new Float2(-0.34420276f, -0.28986976f), new Float2(0.11981889f, -0.43375504f), new Float2(-0.2435907f, 0.37836963f), new Float2(0.2958191f, -0.3391033f), new Float2(-0.1164008f, 0.43468478f), new Float2(0.12740372f, -0.4315881f), new Float2(0.3680473f, 0.2589231f), new Float2(0.2451437f, 0.3773653f), new Float2(-0.43145096f, 0.12786736f)};
    private static final Float3[] CELL_3D = new Float3[]{new Float3(0.14537874f, -0.41497818f, -0.09569818f), new Float3(-0.012428297f, -0.14579184f, -0.42554703f), new Float3(0.28779796f, -0.026064834f, -0.34495357f), new Float3(-0.07732987f, 0.23770943f, 0.37418488f), new Float3(0.11072059f, -0.3552302f, -0.25308585f), new Float3(0.27552092f, 0.26405212f, -0.23846321f), new Float3(0.29416895f, 0.15260646f, 0.30442718f), new Float3(0.4000921f, -0.20340563f, 0.0324415f), new Float3(-0.16973041f, 0.39708647f, -0.12654613f), new Float3(-0.14832245f, -0.38596946f, 0.17756131f), new Float3(0.2623597f, -0.2354853f, 0.27966776f), new Float3(-0.2709003f, 0.3505271f, -0.07901747f), new Float3(-0.035165507f, 0.38852343f, 0.22430544f), new Float3(-0.12677127f, 0.1920044f, 0.38673422f), new Float3(0.02952022f, 0.44096857f, 0.084706925f), new Float3(-0.28068542f, -0.26699677f, 0.22897254f), new Float3(-0.17115955f, 0.21411856f, 0.35687205f), new Float3(0.21132272f, 0.39024058f, -0.074531786f), new Float3(-0.10243528f, 0.21280442f, -0.38304216f), new Float3(-0.330425f, -0.15669867f, 0.26223055f), new Float3(0.20911114f, 0.31332782f, -0.24616706f), new Float3(0.34467816f, -0.19442405f, -0.21423413f), new Float3(0.19844781f, -0.32143423f, -0.24453732f), new Float3(-0.29290086f, 0.22629151f, 0.2559321f), new Float3(-0.16173328f, 0.00631477f, -0.41988388f), new Float3(-0.35820603f, -0.14830318f, -0.2284614f), new Float3(-0.18520673f, -0.34541193f, -0.2211087f), new Float3(0.3046301f, 0.10263104f, 0.3149085f), new Float3(-0.038167685f, -0.25517663f, -0.3686843f), new Float3(-0.40849522f, 0.18059509f, 0.05492789f), new Float3(-0.026874434f, -0.27497414f, 0.35519993f), new Float3(-0.038010985f, 0.3277859f, 0.30596006f), new Float3(0.23711208f, 0.29003868f, -0.2493099f), new Float3(0.44476604f, 0.039469305f, 0.05590469f), new Float3(0.019851472f, -0.015031833f, -0.44931054f), new Float3(0.4274339f, 0.033459943f, -0.1366773f), new Float3(-0.20729886f, 0.28714147f, -0.27762738f), new Float3(-0.3791241f, 0.12811777f, 0.205793f), new Float3(-0.20987213f, -0.10070873f, -0.38511226f), new Float3(0.01582799f, 0.42638946f, 0.14297384f), new Float3(-0.18881294f, -0.31609967f, -0.2587096f), new Float3(0.1612989f, -0.19748051f, -0.3707885f), new Float3(-0.08974491f, 0.22914875f, -0.37674487f), new Float3(0.07041229f, 0.41502303f, -0.15905343f), new Float3(-0.108292565f, -0.15860616f, 0.40696046f), new Float3(0.24741006f, -0.33094147f, 0.17823021f), new Float3(-0.10688367f, -0.27016446f, -0.34363797f), new Float3(0.23964521f, 0.068036005f, -0.37475494f), new Float3(-0.30638862f, 0.25974283f, 0.2028785f), new Float3(0.15933429f, -0.311435f, -0.2830562f), new Float3(0.27096906f, 0.14126487f, -0.33033317f), new Float3(-0.15197805f, 0.3623355f, 0.2193528f), new Float3(0.16997737f, 0.3456013f, 0.232739f), new Float3(-0.19861557f, 0.38362765f, -0.12602258f), new Float3(-0.18874821f, -0.2050155f, -0.35333094f), new Float3(0.26591033f, 0.3015631f, -0.20211722f), new Float3(-0.08838976f, -0.42888197f, -0.1036702f), new Float3(-0.042018693f, 0.30995926f, 0.3235115f), new Float3(-0.32303345f, 0.20154992f, -0.23984788f), new Float3(0.2612721f, 0.27598545f, -0.24097495f), new Float3(0.38571304f, 0.21934603f, 0.074918374f), new Float3(0.07654968f, 0.37217322f, 0.24109592f), new Float3(0.4317039f, -0.02577753f, 0.12436751f), new Float3(-0.28904364f, -0.341818f, -0.045980845f), new Float3(-0.22019476f, 0.38302338f, -0.085483104f), new Float3(0.41613227f, -0.16696343f, -0.03817252f), new Float3(0.22047181f, 0.02654239f, -0.391392f), new Float3(-0.10403074f, 0.38900796f, -0.2008741f), new Float3(-0.14321226f, 0.3716144f, -0.20950656f), new Float3(0.39783806f, -0.062066693f, 0.20092937f), new Float3(-0.25992745f, 0.2616725f, -0.25780848f), new Float3(0.40326184f, -0.11245936f, 0.1650236f), new Float3(-0.0895347f, -0.30482447f, 0.31869355f), new Float3(0.1189372f, -0.2875222f, 0.3250922f), new Float3(0.02167047f, -0.032846306f, -0.44827616f), new Float3(-0.34113437f, 0.2500031f, 0.15370683f), new Float3(0.31629646f, 0.3082064f, -0.08640228f), new Float3(0.2355139f, -0.34393343f, -0.16953762f), new Float3(-0.028745415f, -0.39559332f, 0.21255504f), new Float3(-0.24614552f, 0.020202823f, -0.3761705f), new Float3(0.042080294f, -0.44704396f, 0.029680781f), new Float3(0.27274588f, 0.22884719f, -0.27520657f), new Float3(-0.13475229f, -0.027208483f, -0.42848748f), new Float3(0.38296244f, 0.123193145f, -0.20165123f), new Float3(-0.35476136f, 0.12717022f, 0.24591078f), new Float3(0.23057902f, 0.30638957f, 0.23549682f), new Float3(-0.08323845f, -0.19222452f, 0.39827263f), new Float3(0.2993663f, -0.2619918f, -0.21033332f), new Float3(-0.21548657f, 0.27067477f, 0.2877511f), new Float3(0.016833553f, -0.26806557f, -0.36105052f), new Float3(0.052404292f, 0.4335128f, -0.108721785f), new Float3(0.0094010485f, -0.44728905f, 0.0484161f), new Float3(0.34656888f, 0.011419145f, -0.28680938f), new Float3(-0.3706868f, -0.25511044f, 0.0031566927f), new Float3(0.274117f, 0.21399724f, -0.28559598f), new Float3(0.06413434f, 0.17087185f, 0.41132662f), new Float3(-0.38818797f, -0.039732803f, -0.22412363f), new Float3(0.064194694f, -0.28036824f, 0.3460819f), new Float3(-0.19861208f, -0.33911735f, 0.21920918f), new Float3(-0.20320301f, -0.38716415f, 0.10636004f), new Float3(-0.13897364f, -0.27759016f, -0.32577604f), new Float3(-0.065556414f, 0.34225327f, -0.28471926f), new Float3(-0.25292465f, -0.2904228f, 0.23277397f), new Float3(0.14444765f, 0.1069184f, 0.41255707f), new Float3(-0.364378f, -0.24471f, -0.09922543f), new Float3(0.42861426f, -0.13584961f, -0.018295068f), new Float3(0.16587292f, -0.31368086f, -0.27674988f), new Float3(0.22196105f, -0.365814f, 0.13933203f), new Float3(0.043229405f, -0.38327307f, 0.23180372f), new Float3(-0.0848127f, -0.44048697f, -0.035749655f), new Float3(0.18220821f, -0.39532593f, 0.1140946f), new Float3(-0.32693234f, 0.30365425f, 0.05838957f), new Float3(-0.40804854f, 0.042278584f, -0.18495652f), new Float3(0.26760253f, -0.012996716f, 0.36155218f), new Float3(0.30248925f, -0.10099903f, -0.3174893f), new Float3(0.1448494f, 0.42592168f, -0.01045808f), new Float3(0.41984022f, 0.0806232f, 0.14047809f), new Float3(-0.30088723f, -0.3330409f, -0.032413557f), new Float3(0.36393103f, -0.12912844f, -0.23104121f), new Float3(0.32958066f, 0.018417599f, -0.30583882f), new Float3(0.27762595f, -0.2974929f, -0.19215047f), new Float3(0.41490006f, -0.14479318f, -0.096916884f), new Float3(0.14501671f, -0.039899293f, 0.4241205f), new Float3(0.092990234f, -0.29973218f, -0.32251117f), new Float3(0.10289071f, -0.36126688f, 0.24778973f), new Float3(0.26830572f, -0.070760414f, -0.35426685f), new Float3(-0.4227307f, -0.07933162f, -0.13230732f), new Float3(-0.17812248f, 0.18068571f, -0.3716518f), new Float3(0.43907887f, -0.028418485f, -0.094351165f), new Float3(0.29725835f, 0.23827997f, -0.23949975f), new Float3(-0.17070028f, 0.22158457f, 0.3525077f), new Float3(0.38066867f, 0.14718525f, -0.18954648f), new Float3(-0.17514457f, -0.2748879f, 0.31025964f), new Float3(-0.22272375f, -0.23167789f, 0.31499124f), new Float3(0.13696331f, 0.13413431f, -0.40712288f), new Float3(-0.35295033f, -0.24728934f, -0.1295146f), new Float3(-0.25907442f, -0.29855776f, -0.21504351f), new Float3(-0.37840194f, 0.21998167f, -0.10449899f), new Float3(-0.056358058f, 0.14857374f, 0.42101023f), new Float3(0.32514286f, 0.09666047f, -0.29570064f), new Float3(-0.41909957f, 0.14067514f, -0.08405979f), new Float3(-0.3253151f, -0.3080335f, -0.042254567f), new Float3(0.2857946f, -0.05796152f, 0.34272718f), new Float3(-0.2733604f, 0.1973771f, -0.29802075f), new Float3(0.21900366f, 0.24100378f, -0.31057137f), new Float3(0.31827673f, -0.27134296f, 0.16605099f), new Float3(-0.03222023f, -0.33311614f, -0.30082467f), new Float3(-0.30877802f, 0.19927941f, -0.25969952f), new Float3(-0.06487612f, -0.4311323f, 0.11142734f), new Float3(0.39211714f, -0.06294284f, -0.2116184f), new Float3(-0.16064045f, -0.3589281f, -0.21878128f), new Float3(-0.037677713f, -0.22903514f, 0.3855169f), new Float3(0.13948669f, -0.3602214f, 0.23083329f), new Float3(-0.4345094f, 0.005751117f, 0.11691243f), new Float3(-0.10446375f, 0.41681284f, -0.13362028f), new Float3(0.26587275f, 0.25519434f, 0.2582393f), new Float3(0.2051462f, 0.19753908f, 0.3484155f), new Float3(-0.26608557f, 0.23483312f, 0.2766801f), new Float3(0.07849406f, -0.33003464f, -0.29566166f), new Float3(-0.21606864f, 0.053764515f, -0.39105463f), new Float3(-0.18577918f, 0.21484992f, 0.34903526f), new Float3(0.024924217f, -0.32299542f, -0.31233433f), new Float3(-0.12016783f, 0.40172666f, 0.16332598f), new Float3(-0.021600846f, -0.06885389f, 0.44417626f), new Float3(0.259767f, 0.30963007f, 0.19786438f), new Float3(-0.16115539f, -0.09823036f, 0.40850917f), new Float3(-0.32788968f, 0.14616702f, 0.27133662f), new Float3(0.2822735f, 0.03754421f, -0.3484424f), new Float3(0.03169341f, 0.34740525f, -0.28426242f), new Float3(0.22026137f, -0.3460788f, -0.18497133f), new Float3(0.2933396f, 0.30319735f, 0.15659896f), new Float3(-0.3194923f, 0.24537522f, -0.20053846f), new Float3(-0.3441586f, -0.16988562f, -0.23493347f), new Float3(0.27036458f, -0.35742772f, 0.040600598f), new Float3(0.2298569f, 0.37441564f, 0.09735889f), new Float3(0.09326604f, -0.31701088f, 0.30545956f), new Float3(-0.11161653f, -0.29850188f, 0.31770802f), new Float3(0.21729073f, -0.34600052f, -0.1885958f), new Float3(0.19913395f, 0.38203415f, -0.12998295f), new Float3(-0.054191817f, -0.21031451f, 0.3941206f), new Float3(0.08871337f, 0.20121174f, 0.39261147f), new Float3(0.27876732f, 0.35054046f, 0.04370535f), new Float3(-0.32216644f, 0.30672136f, 0.06804997f), new Float3(-0.42773664f, 0.13206677f, 0.045822866f), new Float3(0.24013188f, -0.1612516f, 0.34472394f), new Float3(0.1448608f, -0.2387819f, 0.35284352f), new Float3(-0.38370657f, -0.22063984f, 0.081162356f), new Float3(-0.4382628f, -0.09082753f, -0.046648555f), new Float3(-0.37728354f, 0.05445141f, 0.23914887f), new Float3(0.12595794f, 0.34839457f, 0.25545222f), new Float3(-0.14062855f, -0.27087736f, -0.33067968f), new Float3(-0.15806945f, 0.4162932f, -0.06491554f), new Float3(0.2477612f, -0.29278675f, -0.23535146f), new Float3(0.29161328f, 0.33125353f, 0.08793625f), new Float3(0.073652655f, -0.16661598f, 0.4114783f), new Float3(-0.26126525f, -0.24222377f, 0.27489653f), new Float3(-0.3721862f, 0.25279015f, 0.008634938f), new Float3(-0.36911917f, -0.25528118f, 0.032902323f), new Float3(0.22784418f, -0.3358365f, 0.1944245f), new Float3(0.36339816f, -0.23101902f, 0.13065979f), new Float3(-0.3042315f, -0.26984522f, 0.19268309f), new Float3(-0.3199312f, 0.31633255f, -0.008816978f), new Float3(0.28748524f, 0.16422755f, -0.30476475f), new Float3(-0.14510968f, 0.3277541f, -0.27206695f), new Float3(0.3220091f, 0.05113441f, 0.31015387f), new Float3(-0.12474009f, -0.043336052f, -0.4301882f), new Float3(-0.2829556f, -0.30561906f, -0.1703911f), new Float3(0.10693844f, 0.34910247f, -0.26304305f), new Float3(-0.14206612f, -0.30553767f, -0.29826826f), new Float3(-0.25054833f, 0.31564668f, -0.20023163f), new Float3(0.3265788f, 0.18712291f, 0.24664004f), new Float3(0.07646097f, -0.30266908f, 0.3241067f), new Float3(0.34517714f, 0.27571207f, -0.085648015f), new Float3(0.29813796f, 0.2852657f, 0.17954728f), new Float3(0.28122503f, 0.34667164f, 0.056844097f), new Float3(0.43903455f, -0.0979043f, -0.012783354f), new Float3(0.21483733f, 0.18501726f, 0.3494475f), new Float3(0.2595421f, -0.07946825f, 0.3589188f), new Float3(0.3182823f, -0.30735552f, -0.08203022f), new Float3(-0.40898594f, -0.046477184f, 0.18185264f), new Float3(-0.2826749f, 0.07417482f, 0.34218854f), new Float3(0.34838647f, 0.22544225f, -0.1740766f), new Float3(-0.32264152f, -0.14205854f, -0.27968165f), new Float3(0.4330735f, -0.11886856f, -0.028594075f), new Float3(-0.08717822f, -0.39098963f, -0.20500502f), new Float3(-0.21496783f, 0.3939974f, -0.032478984f), new Float3(-0.26873308f, 0.32268628f, -0.16172849f), new Float3(0.2105665f, -0.1961317f, -0.34596834f), new Float3(0.43618459f, -0.11055175f, 0.0046166084f), new Float3(0.053333335f, -0.3136395f, -0.31825432f), new Float3(-0.059862167f, 0.13610291f, -0.4247264f), new Float3(0.36649886f, 0.2550543f, -0.055909745f), new Float3(-0.23410155f, -0.18240573f, 0.33826706f), new Float3(-0.047309477f, -0.422215f, -0.14831145f), new Float3(-0.23915662f, -0.25776964f, -0.28081828f), new Float3(-0.1242081f, 0.42569533f, -0.07652336f), new Float3(0.26148328f, -0.36501792f, 0.02980623f), new Float3(-0.27287948f, -0.3499629f, 0.07458405f), new Float3(0.0078929f, -0.16727713f, 0.41767937f), new Float3(-0.017303303f, 0.29784867f, -0.33687797f), new Float3(0.20548357f, -0.32526004f, -0.23341466f), new Float3(-0.3231995f, 0.15642828f, -0.2712421f), new Float3(-0.2669546f, 0.25993437f, -0.2523279f), new Float3(-0.05554373f, 0.3170814f, -0.3144428f), new Float3(-0.20839357f, -0.31092283f, -0.24979813f), new Float3(0.06989323f, -0.31561416f, 0.31305373f), new Float3(0.38475662f, -0.16053091f, -0.16938764f), new Float3(-0.30262154f, -0.30015376f, -0.14431883f), new Float3(0.34507355f, 0.0861152f, 0.27569625f), new Float3(0.18144733f, -0.27887824f, -0.3029914f), new Float3(-0.038550105f, 0.09795111f, 0.4375151f), new Float3(0.35336703f, 0.26657528f, 0.08105161f), new Float3(-0.007945601f, 0.14035943f, -0.42747644f), new Float3(0.40630993f, -0.14917682f, -0.123119935f), new Float3(-0.20167735f, 0.008816271f, -0.40217972f), new Float3(-0.075270556f, -0.42564347f, -0.12514779f)};

    public Noise() {
        this(1337);
    }

    public Noise(int seed) {
        this.seed = seed;
        this.calculateFractalBounding();
    }

    public Noise(int seed, float frequency) {
        this(seed, frequency, 5, 1, 2.0f, 0.5f);
    }

    public Noise(int seed, float frequency, int noiseType) {
        this(seed, frequency, noiseType, 1, 2.0f, 0.5f);
    }

    public Noise(int seed, float frequency, int noiseType, int octaves) {
        this(seed, frequency, noiseType, octaves, 2.0f, 0.5f);
    }

    public Noise(int seed, float frequency, int noiseType, int octaves, float lacunarity, float gain) {
        this.seed = seed;
        this.frequency = Math.max(1.0E-4f, frequency);
        this.noiseType = noiseType;
        this.octaves = octaves;
        this.lacunarity = lacunarity;
        this.gain = gain;
        this.calculateFractalBounding();
    }

    public Noise(Noise other) {
        this(other.seed, other.frequency, other.noiseType, other.octaves, other.lacunarity, other.gain);
        this.fractalType = other.fractalType;
        this.pointHash = other.pointHash;
        this.interpolation = other.interpolation;
        this.gradientPerturbAmp = other.gradientPerturbAmp;
        this.cellularReturnType = other.cellularReturnType;
        this.cellularDistanceFunction = other.cellularDistanceFunction;
        this.sharpness = other.sharpness;
        this.sharpnessInverse = 1.0f / this.sharpness;
        this.mutation = other.mutation;
        this.fractalSpiral = other.fractalSpiral;
    }

    @Override
    public String getTag() {
        return "NoiN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '~' + this.noiseType + '~' + this.octaves + '~' + this.fractalType + '~' + this.interpolation + '~' + this.cellularReturnType + '~' + this.cellularDistanceFunction + '~' + (this.fractalSpiral ? (char)'1' : '0') + '~' + BitConversion.floatToReversedIntBits((float)this.frequency) + '~' + BitConversion.floatToReversedIntBits((float)this.lacunarity) + '~' + BitConversion.floatToReversedIntBits((float)this.gain) + '~' + BitConversion.floatToReversedIntBits((float)this.gradientPerturbAmp) + '~' + BitConversion.floatToReversedIntBits((float)this.sharpness) + '~' + BitConversion.floatToReversedIntBits((float)this.mutation) + "`";
    }

    @Override
    public Noise deserializeFromString(String data) {
        if (data == null || data.length() < 27) {
            return this;
        }
        int pos = data.indexOf(126);
        int seed = DigitTools.intFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int noiseType = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        int n2 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int octaves = DigitTools.intFromDec((CharSequence)data, (int)n2, (int)pos);
        int n3 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int fractalType = DigitTools.intFromDec((CharSequence)data, (int)n3, (int)pos);
        int n4 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int interpolation = DigitTools.intFromDec((CharSequence)data, (int)n4, (int)pos);
        int n5 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int cellularReturnType = DigitTools.intFromDec((CharSequence)data, (int)n5, (int)pos);
        int n6 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int cellularDistanceFunction = DigitTools.intFromDec((CharSequence)data, (int)n6, (int)pos);
        boolean fractalSpiral = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)(pos = data.indexOf(126, pos + 1))) == 1;
        int n7 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        float frequency = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n7, (int)pos));
        int n8 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        float lacunarity = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n8, (int)pos));
        int n9 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        float gain = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n9, (int)pos));
        int n10 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        float gradientPerturbAmp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n10, (int)pos));
        int n11 = pos + 1;
        pos = data.indexOf(126, pos + 1);
        float sharpness = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n11, (int)pos));
        int n12 = pos + 1;
        pos = data.indexOf(96, pos + 1);
        float mutation = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)n12, (int)pos));
        this.setSeed(seed);
        this.setFrequency(frequency);
        this.setNoiseType(noiseType);
        this.setFractalOctaves(octaves);
        this.setFractalLacunarity(lacunarity);
        this.setFractalGain(gain);
        this.calculateFractalBounding();
        this.fractalType = fractalType;
        this.interpolation = interpolation;
        this.gradientPerturbAmp = gradientPerturbAmp;
        this.cellularReturnType = cellularReturnType;
        this.cellularDistanceFunction = cellularDistanceFunction;
        this.sharpness = sharpness;
        this.sharpnessInverse = 1.0f / sharpness;
        this.mutation = mutation;
        this.fractalSpiral = fractalSpiral;
        return this;
    }

    @Override
    public Noise copy() {
        return new Noise(this);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setFrequency(float frequency) {
        this.frequency = Math.max(1.0E-4f, frequency);
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = Math.min(Math.max(interpolation, 0), 2);
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setNoiseType(int noiseType) {
        this.noiseType = noiseType;
    }

    public int getNoiseType() {
        return this.noiseType;
    }

    public void setFractalOctaves(int octaves) {
        this.octaves = Math.max(1, octaves);
        this.calculateFractalBounding();
    }

    public int getFractalOctaves() {
        return this.octaves;
    }

    public void setFractalLacunarity(float lacunarity) {
        this.lacunarity = lacunarity;
    }

    public float getFractalLacunarity() {
        return this.lacunarity;
    }

    public void setFractalGain(float gain) {
        this.gain = gain;
        this.calculateFractalBounding();
    }

    public float getFractalGain() {
        return this.gain;
    }

    public void setFractalType(int fractalType) {
        this.fractalType = fractalType;
    }

    public int getFractalType() {
        return this.fractalType;
    }

    public void setCellularDistanceFunction(int cellularDistanceFunction) {
        this.cellularDistanceFunction = cellularDistanceFunction;
    }

    public int getCellularDistanceFunction() {
        return this.cellularDistanceFunction;
    }

    public void setCellularReturnType(int cellularReturnType) {
        this.cellularReturnType = cellularReturnType;
    }

    public int getCellularReturnType() {
        return this.cellularReturnType;
    }

    public void setCellularNoiseLookup(Noise noise) {
    }

    public void setGradientPerturbAmp(float gradientPerturbAmp) {
        this.gradientPerturbAmp = gradientPerturbAmp / 0.45f;
    }

    public float getGradientPerturbAmp() {
        return this.gradientPerturbAmp * 0.45f;
    }

    public float getFoamSharpness() {
        return this.sharpness;
    }

    public void setFoamSharpness(float sharpness) {
        this.sharpness = sharpness = Math.max(1.0E-6f, sharpness);
        this.sharpnessInverse = 1.0f / sharpness;
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public void setSharpness(float sharpness) {
        this.sharpness = sharpness = Math.max(1.0E-6f, sharpness);
        this.sharpnessInverse = 1.0f / sharpness;
    }

    public float getMutation() {
        return this.mutation;
    }

    public void setMutation(float mutation) {
        this.mutation = mutation;
    }

    public boolean isFractalSpiral() {
        return this.fractalSpiral;
    }

    public void setFractalSpiral(boolean fractalSpiral) {
        this.fractalSpiral = fractalSpiral;
    }

    public void setPointHash(IPointHash hash) {
        if (hash != null) {
            this.pointHash = hash;
        }
    }

    public IPointHash getPointHash() {
        return this.pointHash;
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return 6;
    }

    @Override
    public boolean canUseSeed() {
        return true;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = (int)(seed ^ seed >>> 32);
    }

    public double getNoise(double x, double y) {
        return this.getConfiguredNoise((float)x, (float)y);
    }

    public double getNoise(double x, double y, double z) {
        return this.getConfiguredNoise((float)x, (float)y, (float)z);
    }

    public double getNoise(double x, double y, double z, double w) {
        return this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w);
    }

    public double getNoise(double x, double y, double z, double w, double u) {
        return this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w, (float)u);
    }

    public double getNoise(double x, double y, double z, double w, double u, double v) {
        return this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w, (float)u, (float)v);
    }

    public double getNoiseWithSeed(double x, double y, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        double r = this.getConfiguredNoise((float)x, (float)y);
        this.seed = s;
        return r;
    }

    public double getNoiseWithSeed(double x, double y, double z, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        double r = this.getConfiguredNoise((float)x, (float)y, (float)z);
        this.seed = s;
        return r;
    }

    public double getNoiseWithSeed(double x, double y, double z, double w, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        double r = this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w);
        this.seed = s;
        return r;
    }

    public double getNoiseWithSeed(double x, double y, double z, double w, double u, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        double r = this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w, (float)u);
        this.seed = s;
        return r;
    }

    public double getNoiseWithSeed(double x, double y, double z, double w, double u, double v, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        double r = this.getConfiguredNoise((float)x, (float)y, (float)z, (float)w, (float)u, (float)v);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoise(float x, float y) {
        return this.getConfiguredNoise(x, y);
    }

    @Override
    public float getNoise(float x, float y, float z) {
        return this.getConfiguredNoise(x, y, z);
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        return this.getConfiguredNoise(x, y, z, w);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        return this.getConfiguredNoise(x, y, z, w, u);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        return this.getConfiguredNoise(x, y, z, w, u, v);
    }

    public float getNoiseWithSeed(float x, float y, int seed) {
        int s = this.seed;
        this.seed = seed;
        float r = this.getConfiguredNoise(x, y);
        this.seed = s;
        return r;
    }

    public float getNoiseWithSeed(float x, float y, float z, int seed) {
        int s = this.seed;
        this.seed = seed;
        float r = this.getConfiguredNoise(x, y, z);
        this.seed = s;
        return r;
    }

    public float getNoiseWithSeed(float x, float y, float z, float w, int seed) {
        int s = this.seed;
        this.seed = seed;
        float r = this.getConfiguredNoise(x, y, z, w);
        this.seed = s;
        return r;
    }

    public float getNoiseWithSeed(float x, float y, float z, float w, float u, int seed) {
        int s = this.seed;
        this.seed = seed;
        float r = this.getConfiguredNoise(x, y, z, w, u);
        this.seed = s;
        return r;
    }

    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, int seed) {
        int s = this.seed;
        this.seed = seed;
        float r = this.getConfiguredNoise(x, y, z, w, u, v);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        float r = this.getConfiguredNoise(x, y);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        float r = this.getConfiguredNoise(x, y, z);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        float r = this.getConfiguredNoise(x, y, z, w);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        float r = this.getConfiguredNoise(x, y, z, w, u);
        this.seed = s;
        return r;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        int s = this.seed;
        this.seed = (int)(seed ^ seed >>> 32);
        float r = this.getConfiguredNoise(x, y, z, w, u, v);
        this.seed = s;
        return r;
    }

    protected static int fastRound(float f) {
        return (int)((double)f + 16384.5) - 16384;
    }

    private static float lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    protected static float hermiteInterpolator(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    protected static float quinticInterpolator(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    protected static float cubicLerp(float a, float b, float c, float d, float t) {
        float p = d - c - (a - b);
        return t * (t * t * p + t * (a - b - p) + (c - a)) + b;
    }

    private void calculateFractalBounding() {
        float amp = this.gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            ampFractal += amp;
            amp *= this.gain;
        }
        this.fractalBounding = 1.0f / ampFractal;
    }

    private float valCoord2D(int seed, int x, int y) {
        return (float)IntPointHash.hashAll(x, y, seed) * 4.656613E-10f;
    }

    private float valCoord3D(int seed, int x, int y, int z) {
        return (float)IntPointHash.hashAll(x, y, z, seed) * 4.656613E-10f;
    }

    private float valCoord4D(int seed, int x, int y, int z, int w) {
        return (float)IntPointHash.hashAll(x, y, z, w, seed) * 4.656613E-10f;
    }

    private float valCoord5D(int seed, int x, int y, int z, int w, int u) {
        return (float)IntPointHash.hashAll(x, y, z, w, u, seed) * 4.656613E-10f;
    }

    private float valCoord6D(int seed, int x, int y, int z, int w, int u, int v) {
        return (float)IntPointHash.hashAll(x, y, z, w, u, v, seed) * 4.656613E-10f;
    }

    private float phCoord2D(int seed, int x, int y) {
        return (float)this.pointHash.hashWithState(x, y, seed) * 4.656613E-10f;
    }

    private float phCoord3D(int seed, int x, int y, int z) {
        return (float)this.pointHash.hashWithState(x, y, z, seed) * 4.656613E-10f;
    }

    private float phCoord4D(int seed, int x, int y, int z, int w) {
        return (float)this.pointHash.hashWithState(x, y, z, w, seed) * 4.656613E-10f;
    }

    private float phCoord5D(int seed, int x, int y, int z, int w, int u) {
        return (float)this.pointHash.hashWithState(x, y, z, w, u, seed) * 4.656613E-10f;
    }

    private float phCoord6D(int seed, int x, int y, int z, int w, int u, int v) {
        return (float)this.pointHash.hashWithState(x, y, z, w, u, v, seed) * 4.656613E-10f;
    }

    protected float gradCoord2D(int seed, int x, int y, float xd, float yd) {
        int hash = IntPointHash.hash256(x, y, seed) << 1;
        return xd * GRADIENTS_2D[hash] + yd * GRADIENTS_2D[hash + 1];
    }

    protected float gradCoord3D(int seed, int x, int y, int z, float xd, float yd, float zd) {
        int hash = IntPointHash.hash32(x, y, z, seed) << 2;
        return xd * GRADIENTS_3D[hash] + yd * GRADIENTS_3D[hash + 1] + zd * GRADIENTS_3D[hash + 2];
    }

    protected float gradCoord4D(int seed, int x, int y, int z, int w, float xd, float yd, float zd, float wd) {
        int hash = IntPointHash.hash256(x, y, z, w, seed) & 0xFC;
        return xd * GRADIENTS_4D[hash] + yd * GRADIENTS_4D[hash + 1] + zd * GRADIENTS_4D[hash + 2] + wd * GRADIENTS_4D[hash + 3];
    }

    protected float gradCoord5D(int seed, int x, int y, int z, int w, int u, float xd, float yd, float zd, float wd, float ud) {
        int hash = IntPointHash.hash256(x, y, z, w, u, seed) << 3;
        return xd * GRADIENTS_5D[hash] + yd * GRADIENTS_5D[hash + 1] + zd * GRADIENTS_5D[hash + 2] + wd * GRADIENTS_5D[hash + 3] + ud * GRADIENTS_5D[hash + 4];
    }

    protected float gradCoord6D(int seed, int x, int y, int z, int w, int u, int v, float xd, float yd, float zd, float wd, float ud, float vd) {
        int hash = IntPointHash.hash256(x, y, z, w, u, v, seed) << 3;
        return xd * GRADIENTS_6D[hash] + yd * GRADIENTS_6D[hash + 1] + zd * GRADIENTS_6D[hash + 2] + wd * GRADIENTS_6D[hash + 3] + ud * GRADIENTS_6D[hash + 4] + vd * GRADIENTS_6D[hash + 5];
    }

    protected static float rotateX2D(float x, float y) {
        return x * 0.60888857f + y * -0.79435533f;
    }

    protected static float rotateY2D(float x, float y) {
        return x * 0.79435533f + y * 0.60888857f;
    }

    protected static float rotateX3D(float x, float y, float z) {
        return x * 0.022796689f + y * 0.6762915f + z * -0.7374005f;
    }

    protected static float rotateY3D(float x, float y, float z) {
        return x * 0.2495309f + y * 0.710348f + z * 0.65922207f;
    }

    protected static float rotateZ3D(float x, float y, float z) {
        return x * 0.96803886f + y * -0.19905107f + z * -0.15257645f;
    }

    protected static float rotateX4D(float x, float y, float z, float w) {
        return x * 0.56994784f + y * 0.73698366f + z * -0.032582887f + w * -0.36399758f;
    }

    protected static float rotateY4D(float x, float y, float z, float w) {
        return x * 0.15522823f + y * 0.17709523f + z * -0.70977026f + w * 0.6650917f;
    }

    protected static float rotateZ4D(float x, float y, float z, float w) {
        return x * 0.048383337f + y * 0.31241095f + z * 0.6948458f + w * 0.64695185f;
    }

    protected static float rotateW4D(float x, float y, float z, float w) {
        return x * 0.80643165f + y * -0.5737908f + z * 0.117984585f + w * 0.09043744f;
    }

    protected static float rotateX5D(float x, float y, float z, float w, float u) {
        return x * 0.15241279f + y * -0.25867105f + z * -0.4891826f + w * 0.76633126f + u * -0.2929089f;
    }

    protected static float rotateY5D(float x, float y, float z, float w, float u) {
        return x * -0.071648605f + y * -0.50838286f + z * -0.5846508f + w * -0.32423407f + u * 0.54003435f;
    }

    protected static float rotateZ5D(float x, float y, float z, float w, float u) {
        return x * 0.5391124f + y * 0.4637201f + z * -0.026844958f + w * 0.280563f + u * 0.6471617f;
    }

    protected static float rotateW5D(float x, float y, float z, float w, float u) {
        return x * -0.49085906f + y * -0.31591907f + z * 0.48681808f + w * 0.47338942f + u * 0.44924563f;
    }

    protected static float rotateU5D(float x, float y, float z, float w, float u) {
        return x * 0.6656547f + y * -0.6028584f + z * 0.42894477f + w * -0.08820091f + u * -0.067607686f;
    }

    protected static float rotateX6D(float x, float y, float z, float w, float u, float v) {
        return x * -0.08509823f + y * 0.06214115f + z * 0.6423843f + w * 0.5472782f + u * -0.5181073f + v * -0.113706514f;
    }

    protected static float rotateY6D(float x, float y, float z, float w, float u, float v) {
        return x * 0.10805606f + y * -0.32546705f + z * -0.39722922f + w * 0.09643809f + u * -0.5818281f + v * 0.61822736f;
    }

    protected static float rotateZ6D(float x, float y, float z, float w, float u, float v) {
        return x * 0.25048932f + y * -0.38664693f + z * -0.23466472f + w * 0.737466f + u * 0.42578286f + v * -0.11068163f;
    }

    protected static float rotateW6D(float x, float y, float z, float w, float u, float v) {
        return x * 0.09908584f + y * 0.40409476f + z * 0.30127344f + w * 0.15201136f + u * 0.40369806f + v * 0.7440702f;
    }

    protected static float rotateU6D(float x, float y, float z, float w, float u, float v) {
        return x * -0.77204174f + y * -0.5265151f + z * 0.19957253f + w * -0.04645967f + u * 0.21865113f + v * 0.19909623f;
    }

    protected static float rotateV6D(float x, float y, float z, float w, float u, float v) {
        return x * 0.5606137f + y * -0.5518124f + z * 0.4997557f + w * -0.35558528f + u * 0.07311652f + v * 0.056045208f;
    }

    protected static float rotateX7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * -0.0056246454f + y * 0.22085516f + z * -0.056895677f + w * -0.64328486f + u * -0.33487085f + v * 0.6496998f + m * -0.06876752f;
    }

    protected static float rotateY7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * 0.01596674f + y * -0.37080574f + z * -0.025529016f + w * -0.10742046f + u * -0.6966578f + v * -0.28485247f + m * 0.53745764f;
    }

    protected static float rotateZ7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * 0.008921546f + y * -0.34519064f + z * 0.36534208f + w * 0.5084714f + u * -0.3967137f + v * 0.40262818f + m * -0.41995296f;
    }

    protected static float rotateW7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * 0.038903408f + y * -0.5202531f + z * -0.53966314f + w * 0.15212174f + u * 0.31441835f + v * 0.4756642f + m * 0.3037334f;
    }

    protected static float rotateU7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * -0.012086739f + y * 0.29884708f + z * 0.5341516f + w * 0.23332183f + u * 0.16124533f + v * 0.3296939f + m * 0.66290057f;
    }

    protected static float rotateV7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * -0.87554497f + y * -0.3094948f + z * 0.23862007f + w * -0.23033796f + u * 0.16879246f + v * -0.023977367f + m * -0.016762836f;
    }

    protected static float rotateM7D(float x, float y, float z, float w, float u, float v, float m) {
        return x * 0.48203847f + y * -0.49149963f + z * 0.48378336f + w * -0.4381444f + u * 0.31174773f + v * -0.0641025f + m * -0.049135793f;
    }

    public float getConfiguredNoise(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.noiseType) {
            case 0: {
                return this.singleValue(this.seed, x, y);
            }
            case 1: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleValueFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleValueFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleValueFractalDomainWarp(x, y);
                    }
                }
                return this.singleValueFractalFBM(x, y);
            }
            case 10: {
                return this.singleFoam(this.seed, x, y);
            }
            case 11: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y);
                    }
                }
                return this.singleFoamFractalFBM(x, y);
            }
            case 14: {
                return this.singleFoam(this.seed, x, y, this.mutation);
            }
            case 15: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, this.mutation);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, this.mutation);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, this.mutation);
                    }
                }
                return this.singleFoamFractalFBM(x, y, this.mutation);
            }
            case 16: {
                return this.singleTaffy(this.seed, x, y, this.mutation);
            }
            case 17: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleTaffyFractalBillow(x, y, this.mutation);
                    }
                    case 2: {
                        return this.singleTaffyFractalRidgedMulti(x, y, this.mutation);
                    }
                    case 3: {
                        return this.singleTaffyFractalDomainWarp(x, y, this.mutation);
                    }
                }
                return this.singleTaffyFractalFBM(x, y, this.mutation);
            }
            case 12: {
                return this.singleHoney(this.seed, x, y);
            }
            case 13: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleHoneyFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleHoneyFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleHoneyFractalDomainWarp(x, y);
                    }
                }
                return this.singleHoneyFractalFBM(x, y);
            }
            case 2: {
                return this.singlePerlin(this.seed, x, y);
            }
            case 3: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singlePerlinFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singlePerlinFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singlePerlinFractalDomainWarp(x, y);
                    }
                }
                return this.singlePerlinFractalFBM(x, y);
            }
            case 5: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleSimplexFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleSimplexFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleSimplexFractalDomainWarp(x, y);
                    }
                }
                return this.singleSimplexFractalFBM(x, y);
            }
            case 6: {
                switch (this.cellularReturnType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.singleCellular(this.seed, x, y);
                    }
                    case 8: {
                        return this.singleCellularMerging(this.seed, x, y);
                    }
                }
                return this.singleCellular2Edge(this.seed, x, y);
            }
            case 7: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleCellularFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleCellularFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleCellularFractalDomainWarp(x, y);
                    }
                }
                return this.singleCellularFractalFBM(x, y);
            }
            case 18: {
                return this.getWhiteNoise(x, y);
            }
            case 8: {
                return this.singleCubic(this.seed, x, y);
            }
            case 9: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleCubicFractalBillow(x, y);
                    }
                    case 2: {
                        return this.singleCubicFractalRidgedMulti(x, y);
                    }
                    case 3: {
                        return this.singleCubicFractalDomainWarp(x, y);
                    }
                }
                return this.singleCubicFractalFBM(x, y);
            }
        }
        return this.singleSimplex(this.seed, x, y);
    }

    public float getConfiguredNoise(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.noiseType) {
            case 0: {
                return this.singleValue(this.seed, x, y, z);
            }
            case 1: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleValueFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleValueFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleValueFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleValueFractalFBM(x, y, z);
            }
            case 10: {
                return this.singleFoam(this.seed, x, y, z);
            }
            case 11: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z);
            }
            case 14: {
                return this.singleFoam(this.seed, x, y, z, this.mutation);
            }
            case 15: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, this.mutation);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, this.mutation);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, this.mutation);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, this.mutation);
            }
            case 16: {
                return this.singleTaffy(this.seed, x, y, z, this.mutation);
            }
            case 17: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleTaffyFractalBillow(x, y, z, this.mutation);
                    }
                    case 2: {
                        return this.singleTaffyFractalRidgedMulti(x, y, z, this.mutation);
                    }
                    case 3: {
                        return this.singleTaffyFractalDomainWarp(x, y, z, this.mutation);
                    }
                }
                return this.singleTaffyFractalFBM(x, y, z, this.mutation);
            }
            case 12: {
                return this.singleHoney(this.seed, x, y, z);
            }
            case 13: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleHoneyFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleHoneyFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleHoneyFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleHoneyFractalFBM(x, y, z);
            }
            case 2: {
                return this.singlePerlin(this.seed, x, y, z);
            }
            case 3: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singlePerlinFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singlePerlinFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singlePerlinFractalDomainWarp(x, y, z);
                    }
                }
                return this.singlePerlinFractalFBM(x, y, z);
            }
            case 5: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleSimplexFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleSimplexFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleSimplexFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleSimplexFractalFBM(x, y, z);
            }
            case 6: {
                switch (this.cellularReturnType) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.singleCellular(this.seed, x, y, z);
                    }
                    case 8: {
                        return this.singleCellularMerging(this.seed, x, y, z);
                    }
                }
                return this.singleCellular2Edge(this.seed, x, y, z);
            }
            case 7: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleCellularFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleCellularFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleCellularFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleCellularFractalFBM(x, y, z);
            }
            case 18: {
                return this.getWhiteNoise(x, y, z);
            }
            case 8: {
                return this.singleCubic(this.seed, x, y, z);
            }
            case 9: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleCubicFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.singleCubicFractalRidgedMulti(x, y, z);
                    }
                    case 3: {
                        return this.singleCubicFractalDomainWarp(x, y, z);
                    }
                }
                return this.singleCubicFractalFBM(x, y, z);
            }
        }
        return this.singleSimplex(this.seed, x, y, z);
    }

    public float getConfiguredNoise(float x, float y, float z, float w) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        switch (this.noiseType) {
            case 0: {
                return this.singleValue(this.seed, x, y, z, w);
            }
            case 1: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleValueFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singleValueFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singleValueFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singleValueFractalFBM(x, y, z, w);
            }
            case 10: {
                return this.singleFoam(this.seed, x, y, z, w);
            }
            case 11: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w);
            }
            case 14: {
                return this.singleFoam(this.seed, x, y, z, w, this.mutation);
            }
            case 15: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w, this.mutation);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w, this.mutation);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w, this.mutation);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w, this.mutation);
            }
            case 16: {
                return this.singleTaffy(this.seed, x, y, z, w, this.mutation);
            }
            case 17: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleTaffyFractalBillow(x, y, z, w, this.mutation);
                    }
                    case 2: {
                        return this.singleTaffyFractalRidgedMulti(x, y, z, w, this.mutation);
                    }
                    case 3: {
                        return this.singleTaffyFractalDomainWarp(x, y, z, w, this.mutation);
                    }
                }
                return this.singleTaffyFractalFBM(x, y, z, w, this.mutation);
            }
            case 12: {
                return this.singleHoney(this.seed, x, y, z, w);
            }
            case 13: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleHoneyFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singleHoneyFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singleHoneyFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singleHoneyFractalFBM(x, y, z, w);
            }
            case 2: {
                return this.singlePerlin(this.seed, x, y, z, w);
            }
            case 3: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singlePerlinFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singlePerlinFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singlePerlinFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singlePerlinFractalFBM(x, y, z, w);
            }
            case 5: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleSimplexFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singleSimplexFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singleSimplexFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singleSimplexFractalFBM(x, y, z, w);
            }
            case 18: {
                return this.getWhiteNoise(x, y, z, w);
            }
            case 8: {
                return this.singleCubic(this.seed, x, y, z, w);
            }
            case 9: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleCubicFractalBillow(x, y, z, w);
                    }
                    case 2: {
                        return this.singleCubicFractalRidgedMulti(x, y, z, w);
                    }
                    case 3: {
                        return this.singleCubicFractalDomainWarp(x, y, z, w);
                    }
                }
                return this.singleCubicFractalFBM(x, y, z, w);
            }
        }
        return this.singleSimplex(this.seed, x, y, z, w);
    }

    public float getConfiguredNoise(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.noiseType) {
            case 0: {
                return this.singleValue(this.seed, x, y, z, w, u);
            }
            case 1: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleValueFractalBillow(x, y, z, w, u);
                    }
                    case 2: {
                        return this.singleValueFractalRidgedMulti(x, y, z, w, u);
                    }
                }
                return this.singleValueFractalFBM(x, y, z, w, u);
            }
            case 10: {
                return this.singleFoam(this.seed, x, y, z, w, u);
            }
            case 11: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w, u);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w, u);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w, u);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w, u);
            }
            case 14: {
                return this.singleFoam(this.seed, x, y, z, w, u, this.mutation);
            }
            case 15: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w, u, this.mutation);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w, u, this.mutation);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w, u, this.mutation);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w, u, this.mutation);
            }
            case 16: {
                return this.singleTaffy(this.seed, x, y, z, w, u, this.mutation);
            }
            case 17: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleTaffyFractalBillow(x, y, z, w, u, this.mutation);
                    }
                    case 2: {
                        return this.singleTaffyFractalRidgedMulti(x, y, z, w, u, this.mutation);
                    }
                    case 3: {
                        return this.singleTaffyFractalDomainWarp(x, y, z, w, u, this.mutation);
                    }
                }
                return this.singleTaffyFractalFBM(x, y, z, w, u, this.mutation);
            }
            case 12: {
                return this.singleHoney(this.seed, x, y, z, w, u);
            }
            case 13: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleHoneyFractalBillow(x, y, z, w, u);
                    }
                    case 2: {
                        return this.singleHoneyFractalRidgedMulti(x, y, z, w, u);
                    }
                    case 3: {
                        return this.singleHoneyFractalDomainWarp(x, y, z, w, u);
                    }
                }
                return this.singleHoneyFractalFBM(x, y, z, w, u);
            }
            case 2: {
                return this.singlePerlin(this.seed, x, y, z, w, u);
            }
            case 3: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singlePerlinFractalBillow(x, y, z, w, u);
                    }
                    case 2: {
                        return this.singlePerlinFractalRidgedMulti(x, y, z, w, u);
                    }
                    case 3: {
                        return this.singlePerlinFractalDomainWarp(x, y, z, w, u);
                    }
                }
                return this.singlePerlinFractalFBM(x, y, z, w, u);
            }
            case 5: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleSimplexFractalBillow(x, y, z, w, u);
                    }
                    case 2: {
                        return this.singleSimplexFractalRidgedMulti(x, y, z, w, u);
                    }
                    case 3: {
                        return this.singleSimplexFractalDomainWarp(x, y, z, w, u);
                    }
                }
                return this.singleSimplexFractalFBM(x, y, z, w, u);
            }
            case 18: {
                return this.getWhiteNoise(x, y, z, w, u);
            }
        }
        return this.singleSimplex(this.seed, x, y, z, w, u);
    }

    public float getConfiguredNoise(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.noiseType) {
            case 0: {
                return this.singleValue(this.seed, x, y, z, w, u, v);
            }
            case 1: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleValueFractalBillow(x, y, z, w, u, v);
                    }
                    case 2: {
                        return this.singleValueFractalRidgedMulti(x, y, z, w, u, v);
                    }
                    case 3: {
                        return this.singleValueFractalDomainWarp(x, y, z, w, u, v);
                    }
                }
                return this.singleValueFractalFBM(x, y, z, w, u, v);
            }
            case 10: {
                return this.singleFoam(this.seed, x, y, z, w, u, v);
            }
            case 11: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w, u, v);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w, u, v);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w, u, v);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w, u, v);
            }
            case 14: {
                return this.singleFoam(this.seed, x, y, z, w, u, v, this.mutation);
            }
            case 15: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleFoamFractalBillow(x, y, z, w, u, v, this.mutation);
                    }
                    case 2: {
                        return this.singleFoamFractalRidgedMulti(x, y, z, w, u, v, this.mutation);
                    }
                    case 3: {
                        return this.singleFoamFractalDomainWarp(x, y, z, w, u, v, this.mutation);
                    }
                }
                return this.singleFoamFractalFBM(x, y, z, w, u, v, this.mutation);
            }
            case 16: {
                return this.singleTaffy(this.seed, x, y, z, w, u, v, this.mutation);
            }
            case 17: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleTaffyFractalBillow(x, y, z, w, u, v, this.mutation);
                    }
                    case 2: {
                        return this.singleTaffyFractalRidgedMulti(x, y, z, w, u, v, this.mutation);
                    }
                    case 3: {
                        return this.singleTaffyFractalDomainWarp(x, y, z, w, u, v, this.mutation);
                    }
                }
                return this.singleTaffyFractalFBM(x, y, z, w, u, v, this.mutation);
            }
            case 12: {
                return this.singleHoney(this.seed, x, y, z, w, u, v);
            }
            case 13: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleHoneyFractalBillow(x, y, z, w, u, v);
                    }
                    case 2: {
                        return this.singleHoneyFractalRidgedMulti(x, y, z, w, u, v);
                    }
                    case 3: {
                        return this.singleHoneyFractalDomainWarp(x, y, z, w, u, v);
                    }
                }
                return this.singleHoneyFractalFBM(x, y, z, w, u, v);
            }
            case 2: {
                return this.singlePerlin(this.seed, x, y, z, w, u, v);
            }
            case 3: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singlePerlinFractalBillow(x, y, z, w, u, v);
                    }
                    case 2: {
                        return this.singlePerlinFractalRidgedMulti(x, y, z, w, u, v);
                    }
                    case 3: {
                        return this.singlePerlinFractalDomainWarp(x, y, z, w, u, v);
                    }
                }
                return this.singlePerlinFractalFBM(x, y, z, w, u, v);
            }
            case 5: {
                switch (this.fractalType) {
                    case 1: {
                        return this.singleSimplexFractalBillow(x, y, z, w, u, v);
                    }
                    case 2: {
                        return this.singleSimplexFractalRidgedMulti(x, y, z, w, u, v);
                    }
                    case 3: {
                        return this.singleSimplexFractalDomainWarp(x, y, z, w, u, v);
                    }
                }
                return this.singleSimplexFractalFBM(x, y, z, w, u, v);
            }
            case 18: {
                return this.getWhiteNoise(x, y, z, w, u, v);
            }
        }
        return this.singleSimplex(this.seed, x, y, z, w, u, v);
    }

    private int floatToIntMixed(float f) {
        int i = BitConversion.floatToIntBits((float)f);
        return i ^ i >>> 16;
    }

    public float getWhiteNoise(float x, float y) {
        int xi = this.floatToIntMixed(x);
        int yi = this.floatToIntMixed(y);
        return this.valCoord2D(this.seed, xi, yi);
    }

    public float getWhiteNoise(float x, float y, float z) {
        int xi = this.floatToIntMixed(x);
        int yi = this.floatToIntMixed(y);
        int zi = this.floatToIntMixed(z);
        return this.valCoord3D(this.seed, xi, yi, zi);
    }

    public float getWhiteNoise(float x, float y, float z, float w) {
        int xi = this.floatToIntMixed(x);
        int yi = this.floatToIntMixed(y);
        int zi = this.floatToIntMixed(z);
        int wi = this.floatToIntMixed(w);
        return this.valCoord4D(this.seed, xi, yi, zi, wi);
    }

    public float getWhiteNoise(float x, float y, float z, float w, float u) {
        int xi = this.floatToIntMixed(x);
        int yi = this.floatToIntMixed(y);
        int zi = this.floatToIntMixed(z);
        int wi = this.floatToIntMixed(w);
        int ui = this.floatToIntMixed(u);
        return this.valCoord5D(this.seed, xi, yi, zi, wi, ui);
    }

    public float getWhiteNoise(float x, float y, float z, float w, float u, float v) {
        int xi = this.floatToIntMixed(x);
        int yi = this.floatToIntMixed(y);
        int zi = this.floatToIntMixed(z);
        int wi = this.floatToIntMixed(w);
        int ui = this.floatToIntMixed(u);
        int vi = this.floatToIntMixed(v);
        return this.valCoord6D(this.seed, xi, yi, zi, wi, ui, vi);
    }

    private static int hashPart1024(int x, int y, int s) {
        return ((s += x ^ y) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    private static int hashPart1024(int x, int y, int z, int s) {
        return ((s += x ^ y ^ z) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    private static int hashPart1024(int x, int y, int z, int w, int s) {
        return ((s += x ^ y ^ z ^ w) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int s) {
        return ((s += x ^ y ^ z ^ w ^ u) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int v, int s) {
        return ((s += x ^ y ^ z ^ w ^ u ^ v) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int v, int m, int s) {
        return ((s += x ^ y ^ z ^ w ^ u ^ v ^ m) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >> 22;
    }

    public static float wobbleTight(int seed, float value) {
        int floor = value >= 0.0f ? (int)value : (int)value - 1;
        int z = seed + floor;
        int x = z++;
        x = (x ^ x >>> 16) * 139181;
        x = (x ^ x >>> 15) * 472471;
        float start = (float)(x >>> 1 ^ x >>> 16) * 4.656613E-10f;
        x = (z ^ z >>> 16) * 139181;
        x = (x ^ x >>> 15) * 472471;
        float end = (float)(x >>> 1 ^ x >>> 16) * 4.656613E-10f;
        value -= (float)floor;
        value *= value * (3.0f - 2.0f * value);
        return (1.0f - value) * start + value * end;
    }

    public float getValueFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleValueFractalFBM(x, y);
            }
            case 1: {
                return this.singleValueFractalBillow(x, y);
            }
            case 2: {
                return this.singleValueFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    protected float singleValueFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleValue(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleValue(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singleValue(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleValue(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleValue(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getValue(float x, float y) {
        return this.singleValue(this.seed, x * this.frequency, y * this.frequency);
    }

    public float singleValue(int seed, float x, float y) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        switch (this.interpolation) {
            case 1: {
                x = Noise.hermiteInterpolator(x);
                y = Noise.hermiteInterpolator(y);
                break;
            }
            case 2: {
                x = Noise.quinticInterpolator(x);
                y = Noise.quinticInterpolator(y);
            }
        }
        return ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 858965, yFloor *= 703641, seed) + x * (float)Noise.hashPart1024(xFloor + 858965, yFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 703641, seed) + x * (float)Noise.hashPart1024(xFloor + 858965, yFloor + 703641, seed))) * 0.001953125f;
    }

    protected float valueNoise(int seed, float x, float y) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        return ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 858965, yFloor *= 703641, seed) + x * (float)Noise.hashPart1024(xFloor + 858965, yFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 703641, seed) + x * (float)Noise.hashPart1024(xFloor + 858965, yFloor + 703641, seed))) * 9.765625E-4f + 0.5f;
    }

    public float getValueFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 1: {
                return this.singleValueFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleValueFractalRidgedMulti(x, y, z);
            }
        }
        return this.singleValueFractalFBM(x, y, z);
    }

    protected float singleValueFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleValue(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleValue(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleValue(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleValue(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleValue(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getValue(float x, float y, float z) {
        return this.singleValue(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public float singleValue(int seed, float x, float y, float z) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        switch (this.interpolation) {
            case 1: {
                x = Noise.hermiteInterpolator(x);
                y = Noise.hermiteInterpolator(y);
                z = Noise.hermiteInterpolator(z);
                break;
            }
            case 2: {
                x = Noise.quinticInterpolator(x);
                y = Noise.quinticInterpolator(y);
                z = Noise.quinticInterpolator(z);
            }
        }
        return ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 898289, yFloor *= 769541, zFloor *= 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor, zFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 769541, zFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor, zFloor + 659247, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 769541, zFloor + 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor + 659247, seed)))) * 0.001953125f;
    }

    protected float valueNoise(int seed, float x, float y, float z) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        return ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 898289, yFloor *= 769541, zFloor *= 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor, zFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 769541, zFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor, zFloor + 659247, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 769541, zFloor + 659247, seed) + x * (float)Noise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor + 659247, seed)))) * 9.765625E-4f + 0.5f;
    }

    public float getValueFractal(float x, float y, float z, float w) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        switch (this.fractalType) {
            case 1: {
                return this.singleValueFractalBillow(x, y, z, w);
            }
            case 2: {
                return this.singleValueFractalRidgedMulti(x, y, z, w);
            }
        }
        return this.singleValueFractalFBM(x, y, z, w);
    }

    protected float singleValueFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleValue(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleValue(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleValue(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleValue(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleValue(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getValue(float x, float y, float z, float w) {
        return this.singleValue(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    public float singleValue(int seed, float x, float y, float z, float w) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        switch (this.interpolation) {
            case 1: {
                x = Noise.hermiteInterpolator(x);
                y = Noise.hermiteInterpolator(y);
                z = Noise.hermiteInterpolator(z);
                w = Noise.hermiteInterpolator(w);
                break;
            }
            case 2: {
                x = Noise.quinticInterpolator(x);
                y = Noise.quinticInterpolator(y);
                z = Noise.quinticInterpolator(z);
                w = Noise.quinticInterpolator(w);
            }
        }
        return ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 924081, yFloor *= 814365, zFloor *= 717677, wFloor *= 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor + 632469, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed))))) * 0.001953125f;
    }

    protected float valueNoise(int seed, float x, float y, float z, float w) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        return ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 924081, yFloor *= 814365, zFloor *= 717677, wFloor *= 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor + 632469, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed) + x * (float)Noise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed))))) * 9.765625E-4f + 0.5f;
    }

    public float getValueFractal(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.fractalType) {
            case 1: {
                return this.singleValueFractalBillow(x, y, z, w, u);
            }
            case 2: {
                return this.singleValueFractalRidgedMulti(x, y, z, w, u);
            }
        }
        return this.singleValueFractalFBM(x, y, z, w, u);
    }

    protected float singleValueFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singleValue(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleValue(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singleValue(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singleValue(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += (Math.abs(this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleValue(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getValue(float x, float y, float z, float w, float u) {
        return this.singleValue(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    public float singleValue(int seed, float x, float y, float z, float w, float u) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        int uFloor = u >= 0.0f ? (int)u : (int)u - 1;
        u -= (float)uFloor;
        switch (this.interpolation) {
            case 1: {
                x = Noise.hermiteInterpolator(x);
                y = Noise.hermiteInterpolator(y);
                z = Noise.hermiteInterpolator(z);
                w = Noise.hermiteInterpolator(w);
                u = Noise.hermiteInterpolator(u);
                break;
            }
            case 2: {
                x = Noise.quinticInterpolator(x);
                y = Noise.quinticInterpolator(y);
                z = Noise.quinticInterpolator(z);
                w = Noise.quinticInterpolator(w);
                u = Noise.quinticInterpolator(u);
            }
        }
        return ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 942307, yFloor *= 846807, zFloor *= 760987, wFloor *= 683863, uFloor *= 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)))))) * 0.001953125f;
    }

    protected float valueNoise(int seed, float x, float y, float z, float w, float u) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = u >= 0.0f ? (int)u : (int)u - 1;
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        return ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor *= 942307, yFloor *= 846807, zFloor *= 760987, wFloor *= 683863, uFloor *= 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)Noise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)))))) * 9.765625E-4f + 0.5f;
    }

    public float getValueFractal(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.fractalType) {
            case 1: {
                return this.singleValueFractalBillow(x, y, z, w, u, v);
            }
            case 2: {
                return this.singleValueFractalRidgedMulti(x, y, z, w, u, v);
            }
        }
        return this.singleValueFractalFBM(x, y, z, w, u, v);
    }

    protected float singleValueFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singleValue(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleValue(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singleValue(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singleValue(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += (Math.abs(this.singleValue(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleValueFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleValue(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getValue(float x, float y, float z, float w, float u, float v) {
        return this.singleValue(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    public float singleValue(int seed, float x, float y, float z, float w, float u, float v) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        int uFloor = u >= 0.0f ? (int)u : (int)u - 1;
        u -= (float)uFloor;
        int vFloor = v >= 0.0f ? (int)v : (int)v - 1;
        v -= (float)vFloor;
        switch (this.interpolation) {
            case 1: {
                x = Noise.hermiteInterpolator(x);
                y = Noise.hermiteInterpolator(y);
                z = Noise.hermiteInterpolator(z);
                w = Noise.hermiteInterpolator(w);
                u = Noise.hermiteInterpolator(u);
                v = Noise.hermiteInterpolator(v);
                break;
            }
            case 2: {
                x = Noise.quinticInterpolator(x);
                y = Noise.quinticInterpolator(y);
                z = Noise.quinticInterpolator(z);
                w = Noise.quinticInterpolator(w);
                u = Noise.quinticInterpolator(u);
                v = Noise.quinticInterpolator(v);
            }
        }
        return ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor *= 871367, zFloor *= 794331, wFloor *= 724107, uFloor *= 660091, vFloor *= 601733, seed) + x * (float)Noise.hashPart1024((xFloor *= 955873) + 955873, yFloor, zFloor, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))))))) * 0.001953125f;
    }

    protected float valueNoise(int seed, float x, float y, float z, float w, float u, float v) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = u >= 0.0f ? (int)u : (int)u - 1;
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        int vFloor = v >= 0.0f ? (int)v : (int)v - 1;
        v -= (float)vFloor;
        v *= v * (3.0f - 2.0f * v);
        return ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor *= 871367, zFloor *= 794331, wFloor *= 724107, uFloor *= 660091, vFloor *= 601733, seed) + x * (float)Noise.hashPart1024((xFloor *= 955873) + 955873, yFloor, zFloor, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)Noise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))))))) * 9.765625E-4f + 0.5f;
    }

    protected float valueNoise(int seed, float x, float y, float z, float w, float u, float v, float m) {
        int xFloor = x >= 0.0f ? (int)x : (int)x - 1;
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = y >= 0.0f ? (int)y : (int)y - 1;
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = z >= 0.0f ? (int)z : (int)z - 1;
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = w >= 0.0f ? (int)w : (int)w - 1;
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = u >= 0.0f ? (int)u : (int)u - 1;
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        int vFloor = v >= 0.0f ? (int)v : (int)v - 1;
        v -= (float)vFloor;
        v *= v * (3.0f - 2.0f * v);
        int mFloor = m >= 0.0f ? (int)m : (int)m - 1;
        m -= (float)mFloor;
        m *= m * (3.0f - 2.0f * m);
        return ((1.0f - m) * ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor *= 820779, wFloor *= 756429, uFloor *= 697123, vFloor *= 642469, mFloor *= 592099, seed) + x * (float)Noise.hashPart1024((xFloor *= 966367) + 966367, yFloor *= 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed))))))) + m * ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)Noise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)Noise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)))))))) * 9.765625E-4f + 0.5f;
    }

    public float getFoam(float x, float y) {
        return this.singleFoam(this.seed, x * this.frequency, y * this.frequency);
    }

    public float singleFoam(int seed, float x, float y) {
        float p2;
        float p0 = x;
        float p1 = x * -0.5f + y * 0.8660254f;
        float xin = p2 = x * -0.5f + y * -0.8660254f;
        float yin = p0;
        float a = this.valueNoise(seed, xin, yin);
        xin = p1;
        yin = p2;
        float b = this.valueNoise(seed += 648055, xin + a, yin);
        xin = p0;
        yin = p1;
        float c = this.valueNoise(seed += 648055, xin + b, yin);
        float result = (a + b + c) * 0.33333334f;
        float sharp = this.sharpness * 2.2f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public float getFoamFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleFoamFractalFBM(x, y);
            }
            case 1: {
                return this.singleFoamFractalBillow(x, y);
            }
            case 2: {
                return this.singleFoamFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    protected float singleFoamFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += this.singleFoam(seed + i, x, y) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singleFoam(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += (Math.abs(this.singleFoam(++seed, x, y)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getFoamFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleFoamFractalFBM(x, y, z);
            }
            case 1: {
                return this.singleFoamFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleFoamFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    protected float singleFoamFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleFoam(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getFoam(float x, float y, float z) {
        return this.singleFoam(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public float singleFoam(int seed, float x, float y, float z) {
        float p3;
        float p0 = x;
        float p1 = x * -0.33333334f + y * 0.94280905f;
        float p2 = x * -0.33333334f + y * -0.47140452f + z * 0.8164966f;
        float xin = p3 = x * -0.33333334f + y * -0.47140452f + z * -0.8164966f;
        float yin = p2;
        float zin = p0;
        float a = this.valueNoise(seed, xin, yin, zin);
        xin = p0;
        yin = p1;
        zin = p3;
        float b = this.valueNoise(seed += 648055, xin + a, yin, zin);
        xin = p1;
        yin = p2;
        zin = p3;
        float c = this.valueNoise(seed += 648055, xin + b, yin, zin);
        xin = p0;
        yin = p1;
        zin = p2;
        float d = this.valueNoise(seed += 648055, xin + c, yin, zin);
        float result = (a + b + c + d) * 0.25f;
        float sharp = this.sharpness * 3.3f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    protected float singleFoamFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleFoam(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getFoam(float x, float y, float z, float w) {
        return this.singleFoam(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    public float singleFoam(int seed, float x, float y, float z, float w) {
        float p0 = x;
        float p1 = x * -0.25f + y * 0.96824586f;
        float p2 = x * -0.25f + y * -0.3227486f + z * 0.91287094f;
        float p3 = x * -0.25f + y * -0.3227486f + z * -0.45643547f + w * 0.7905694f;
        float p4 = x * -0.25f + y * -0.3227486f + z * -0.45643547f + w * -0.7905694f;
        float xin = p1;
        float yin = p2;
        float zin = p3;
        float win = p4;
        float a = this.valueNoise(seed, xin, yin, zin, win);
        xin = p0;
        yin = p2;
        zin = p3;
        win = p4;
        float b = this.valueNoise(seed += 648055, xin + a, yin, zin, win);
        xin = p0;
        yin = p1;
        zin = p3;
        win = p4;
        float c = this.valueNoise(seed += 648055, xin + b, yin, zin, win);
        xin = p0;
        yin = p1;
        zin = p2;
        win = p4;
        float d = this.valueNoise(seed += 648055, xin + c, yin, zin, win);
        xin = p0;
        yin = p1;
        zin = p2;
        win = p3;
        float e = this.valueNoise(seed += 648055, xin + d, yin, zin, win);
        float result = (a + b + c + d + e) * 0.2f;
        float sharp = this.sharpness * 4.4f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public float getFoamFractal(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleFoamFractalFBM(x, y, z, w, u);
            }
            case 1: {
                return this.singleFoamFractalBillow(x, y, z, w, u);
            }
            case 2: {
                return this.singleFoamFractalRidgedMulti(x, y, z, w, u);
            }
        }
        return 0.0f;
    }

    protected float singleFoamFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleFoam(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singleFoam(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleFoam(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getFoam(float x, float y, float z, float w, float u) {
        return this.singleFoam(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    public float singleFoam(int seed, float x, float y, float z, float w, float u) {
        float p0 = x * 0.8157559f + y * 0.5797767f;
        float p1 = x * -0.73149234f + y * 0.6832997f;
        float p2 = x * -0.020860305f + y * -0.3155297f + z * 0.9486833f;
        float p3 = x * -0.020860305f + y * -0.3155297f + z * -0.31622776f + w * 0.8944272f;
        float p4 = x * -0.020860305f + y * -0.3155297f + z * -0.31622776f + w * -0.4472136f + u * 0.7745967f;
        float p5 = x * -0.020860305f + y * -0.3155297f + z * -0.31622776f + w * -0.4472136f + u * -0.7745967f;
        float xin = p1;
        float yin = p2;
        float zin = p3;
        float win = p4;
        float uin = p5;
        float a = this.valueNoise(seed, xin, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p2;
        zin = p3;
        win = p4;
        uin = p5;
        float b = this.valueNoise(seed, xin + a, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p3;
        win = p4;
        uin = p5;
        float c = this.valueNoise(seed, xin + b, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p4;
        uin = p5;
        float d = this.valueNoise(seed, xin + c, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p5;
        float e = this.valueNoise(seed, xin + d, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p4;
        float f = this.valueNoise(seed, xin + e, yin, zin, win, uin);
        float result = (a + b + c + d + e + f) * 0.16666667f;
        float sharp = this.sharpness * 5.5f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public float getFoamFractal(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleFoamFractalFBM(x, y, z, w, u, v);
            }
            case 1: {
                return this.singleFoamFractalBillow(x, y, z, w, u, v);
            }
            case 2: {
                return this.singleFoamFractalRidgedMulti(x, y, z, w, u, v);
            }
        }
        return 0.0f;
    }

    protected float singleFoamFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singleFoam(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getFoam(float x, float y, float z, float w, float u, float v) {
        return this.singleFoam(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    public float singleFoam(int seed, float x, float y, float z, float w, float u, float v) {
        float p0 = x;
        float p1 = x * -0.16666667f + y * 0.9860133f;
        float p2 = x * -0.16666667f + y * -0.19720265f + z * 0.9660918f;
        float p3 = x * -0.16666667f + y * -0.19720265f + z * -0.24152295f + w * 0.9354144f;
        float p4 = x * -0.16666667f + y * -0.19720265f + z * -0.24152295f + w * -0.31180477f + u * 0.8819171f;
        float p5 = x * -0.16666667f + y * -0.19720265f + z * -0.24152295f + w * -0.31180477f + u * -0.44095856f + v * 0.7637626f;
        float p6 = x * -0.16666667f + y * -0.19720265f + z * -0.24152295f + w * -0.31180477f + u * -0.44095856f + v * -0.7637626f;
        float xin = p0;
        float yin = p5;
        float zin = p3;
        float win = p6;
        float uin = p1;
        float vin = p4;
        float a = this.valueNoise(seed, xin, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p2;
        yin = p6;
        zin = p0;
        win = p4;
        uin = p5;
        vin = p3;
        float b = this.valueNoise(seed, xin + a, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p1;
        yin = p2;
        zin = p3;
        win = p4;
        uin = p6;
        vin = p5;
        float c = this.valueNoise(seed, xin + b, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p6;
        yin = p0;
        zin = p2;
        win = p5;
        uin = p4;
        vin = p1;
        float d = this.valueNoise(seed, xin + c, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p2;
        yin = p1;
        zin = p5;
        win = p0;
        uin = p3;
        vin = p6;
        float e = this.valueNoise(seed, xin + d, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p0;
        yin = p4;
        zin = p6;
        win = p3;
        uin = p1;
        vin = p2;
        float f = this.valueNoise(seed, xin + e, yin, zin, win, uin, vin);
        seed += 648055;
        xin = p5;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p4;
        vin = p0;
        float g = this.valueNoise(seed, xin + f, yin, zin, win, uin, vin);
        float result = (a + b + c + d + e + f + g) * 0.14285715f;
        float sharp = this.sharpness * 6.6f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    protected float singleFoamFractalFBM(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = this.singleFoam(seed, x, y, z, w, u, v, m);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity, m *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalDomainWarp(float x, float y, float z, float w, float u, float v, float m) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleFoam(seed, x, y, z, w, u, v, m);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            m *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1170 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2340 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 3510 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 4681 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 5851 & 0x3FFF];
            float g = TrigTools.SIN_TABLE[idx + 7021 & 0x3FFF];
            latest = this.singleFoam(++seed, x + a, y + b, z + c, w + d, u + e, v + f, m + g);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalBillow(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = Math.abs(this.singleFoam(seed, x, y, z, w, u, v, m)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleFoam(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity, m *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleFoamFractalRidgedMulti(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleFoam(seed + i, x, y, z, w, u, v, m));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            m *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float singleFoam(int seed, float x, float y, float z, float w, float u, float v, float m) {
        float p0 = x;
        float p1 = x * -0.14285715f + y * 0.9897433f;
        float p2 = x * -0.14285715f + y * -0.16495723f + z * 0.97590005f;
        float p3 = x * -0.14285715f + y * -0.16495723f + z * -0.19518001f + w * 0.9561829f;
        float p4 = x * -0.14285715f + y * -0.16495723f + z * -0.19518001f + w * -0.23904572f + u * 0.9258201f;
        float p5 = x * -0.14285715f + y * -0.16495723f + z * -0.19518001f + w * -0.23904572f + u * -0.3086067f + v * 0.8728716f;
        float p6 = x * -0.14285715f + y * -0.16495723f + z * -0.19518001f + w * -0.23904572f + u * -0.3086067f + v * -0.4364358f + m * 0.75592893f;
        float p7 = x * -0.14285715f + y * -0.16495723f + z * -0.19518001f + w * -0.23904572f + u * -0.3086067f + v * -0.4364358f + m * -0.75592893f;
        float xin = p0;
        float yin = p6;
        float zin = p3;
        float win = p7;
        float uin = p1;
        float vin = p4;
        float min = p5;
        float a = this.valueNoise(seed, xin, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p2;
        yin = p3;
        zin = p0;
        win = p4;
        uin = p6;
        vin = p5;
        min = p7;
        float b = this.valueNoise(seed, xin + a, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p1;
        yin = p2;
        zin = p4;
        win = p3;
        uin = p5;
        vin = p7;
        min = p6;
        float c = this.valueNoise(seed, xin + b, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p7;
        yin = p0;
        zin = p2;
        win = p5;
        uin = p4;
        vin = p6;
        min = p1;
        float d = this.valueNoise(seed, xin + c, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p3;
        yin = p1;
        zin = p5;
        win = p6;
        uin = p7;
        vin = p0;
        min = p2;
        float e = this.valueNoise(seed, xin + d, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p4;
        yin = p7;
        zin = p6;
        win = p2;
        uin = p0;
        vin = p1;
        min = p3;
        float f = this.valueNoise(seed, xin + e, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p5;
        yin = p4;
        zin = p7;
        win = p1;
        uin = p2;
        vin = p3;
        min = p0;
        float g = this.valueNoise(seed, xin + f, yin, zin, win, uin, vin, min);
        seed += 648055;
        xin = p6;
        yin = p5;
        zin = p1;
        win = p0;
        uin = p3;
        vin = p2;
        min = p4;
        float h = this.valueNoise(seed, xin + g, yin, zin, win, uin, vin, min);
        float result = (a + b + c + d + e + f + g + h) * 0.125f;
        float sharp = this.sharpness * 7.7f;
        float diff = 0.5f - result;
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + sharp * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public float getTaffy(float x, float y) {
        return this.singleTaffy(this.seed, x * this.frequency, y * this.frequency);
    }

    protected float trillNoise(int seed, float x, float y) {
        int sx = seed;
        int sy = (seed << 13 | seed >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y))) * 0.16f));
    }

    protected float trillNoise(int seed, float x, float y, float z) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z))) * 0.15f));
    }

    protected float trillNoise(int seed, float x, float y, float z, float w) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int sw = (sz << 13 | sz >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + w * 21.0f);
        sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * w)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z));
        idx = sw + (int)(w * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)w) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sw & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sw + 4096 & 0x3FFF] * w))) * 0.14f));
    }

    protected float trillNoise(int seed, float x, float y, float z, float w, float u) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int sw = (sz << 13 | sz >>> 19) + 1234567;
        int su = (sw << 13 | sw >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + w * 21.0f);
        sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * w)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z));
        idx = sw + (int)(w * 95.0f + u * 21.0f);
        sum += TrigTools.cos((float)w) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sw & 0x3FFF] * u)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sw + 4096 & 0x3FFF] * w));
        idx = su + (int)(u * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)u) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[su & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[su + 4096 & 0x3FFF] * u))) * 0.13f));
    }

    protected float trillNoise(int seed, float x, float y, float z, float w, float u, float v) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int sw = (sz << 13 | sz >>> 19) + 1234567;
        int su = (sw << 13 | sw >>> 19) + 1234567;
        int sv = (su << 13 | su >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + w * 21.0f);
        sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * w)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z));
        idx = sw + (int)(w * 95.0f + u * 21.0f);
        sum += TrigTools.cos((float)w) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sw & 0x3FFF] * u)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sw + 4096 & 0x3FFF] * w));
        idx = su + (int)(u * 95.0f + v * 21.0f);
        sum += TrigTools.cos((float)u) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[su & 0x3FFF] * v)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[su + 4096 & 0x3FFF] * u));
        idx = sv + (int)(v * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)v) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sv & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sv + 4096 & 0x3FFF] * v))) * 0.12f));
    }

    protected float trillNoise(int seed, float x, float y, float z, float w, float u, float v, float m) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int sw = (sz << 13 | sz >>> 19) + 1234567;
        int su = (sw << 13 | sw >>> 19) + 1234567;
        int sv = (su << 13 | su >>> 19) + 1234567;
        int sm = (sv << 13 | sv >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + w * 21.0f);
        sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * w)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z));
        idx = sw + (int)(w * 95.0f + u * 21.0f);
        sum += TrigTools.cos((float)w) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sw & 0x3FFF] * u)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sw + 4096 & 0x3FFF] * w));
        idx = su + (int)(u * 95.0f + v * 21.0f);
        sum += TrigTools.cos((float)u) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[su & 0x3FFF] * v)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[su + 4096 & 0x3FFF] * u));
        idx = sv + (int)(v * 95.0f + m * 21.0f);
        sum += TrigTools.cos((float)v) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sv & 0x3FFF] * m)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sv + 4096 & 0x3FFF] * v));
        idx = sm + (int)(m * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)m) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sm & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sm + 4096 & 0x3FFF] * m))) * 0.11f));
    }

    protected float trillNoise(int seed, float x, float y, float z, float w, float u, float v, float m, float n) {
        int sx = seed;
        int sy = (sx << 13 | sx >>> 19) + 1234567;
        int sz = (sy << 13 | sy >>> 19) + 1234567;
        int sw = (sz << 13 | sz >>> 19) + 1234567;
        int su = (sw << 13 | sw >>> 19) + 1234567;
        int sv = (su << 13 | su >>> 19) + 1234567;
        int sm = (sv << 13 | sv >>> 19) + 1234567;
        int sn = (sm << 13 | sm >>> 19) + 1234567;
        int idx = sx + (int)(x * 95.0f + y * 21.0f);
        float sum = TrigTools.cos((float)x) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * y)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * x));
        idx = sy + (int)(y * 95.0f + z * 21.0f);
        sum += TrigTools.cos((float)y) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * z)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * y));
        idx = sz + (int)(z * 95.0f + w * 21.0f);
        sum += TrigTools.cos((float)z) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sz & 0x3FFF] * w)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sz + 4096 & 0x3FFF] * z));
        idx = sw + (int)(w * 95.0f + u * 21.0f);
        sum += TrigTools.cos((float)w) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sw & 0x3FFF] * u)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sw + 4096 & 0x3FFF] * w));
        idx = su + (int)(u * 95.0f + v * 21.0f);
        sum += TrigTools.cos((float)u) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[su & 0x3FFF] * v)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[su + 4096 & 0x3FFF] * u));
        idx = sv + (int)(v * 95.0f + m * 21.0f);
        sum += TrigTools.cos((float)v) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sv & 0x3FFF] * m)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sv + 4096 & 0x3FFF] * v));
        idx = sm + (int)(m * 95.0f + n * 21.0f);
        sum += TrigTools.cos((float)m) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sm & 0x3FFF] * n)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sm + 4096 & 0x3FFF] * m));
        idx = sn + (int)(n * 95.0f + x * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)n) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sn & 0x3FFF] * x)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sn + 4096 & 0x3FFF] * n))) * 0.1f));
    }

    public float singleTaffyVarargs(int seed, float ... coordinates) {
        if (coordinates == null) {
            return (Hasher.randomize3Float((long)seed) - 0.5f) * 2.0f;
        }
        switch (coordinates.length) {
            case 0: {
                return (Hasher.randomize3Float((long)seed) - 0.5f) * 2.0f;
            }
            case 1: {
                return LineWobble.wobble((int)seed, (float)coordinates[0]);
            }
            case 2: {
                return this.singleTaffy(seed, coordinates[0], coordinates[1]);
            }
            case 3: {
                return this.singleTaffy(seed, coordinates[0], coordinates[1], coordinates[2]);
            }
            case 4: {
                return this.singleTaffy(seed, coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
            }
            case 5: {
                return this.singleTaffy(seed, coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4]);
            }
            case 6: {
                return this.singleTaffy(seed, coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5]);
            }
        }
        return this.singleTaffy(seed, coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5], coordinates[6]);
    }

    public float singleTaffy(int seed, float x, float y) {
        float p2;
        float p0 = x * 0.57565147f + y * 0.8176952f;
        float p1 = x * -0.9655443f + y * 0.26023862f;
        float xin = p2 = x * -0.17945707f + y * -0.98376584f;
        float yin = p0;
        float a = this.trillNoise(seed, xin, yin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p1;
        yin = p2;
        float b = this.trillNoise(seed, xin + a, yin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p0;
        yin = p1;
        float c = this.trillNoise(seed, xin + b, yin);
        float result = (a + b + c) * 0.33333334f;
        float sharp = this.sharpnessInverse;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public float getTaffyFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleTaffyFractalFBM(x, y);
            }
            case 1: {
                return this.singleTaffyFractalBillow(x, y);
            }
            case 2: {
                return this.singleTaffyFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    protected float singleTaffyFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += this.singleTaffy(seed + i, x, y) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += (Math.abs(this.singleTaffy(++seed, x, y)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getTaffyFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleTaffyFractalFBM(x, y, z);
            }
            case 1: {
                return this.singleTaffyFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleTaffyFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    protected float singleTaffyFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleTaffy(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleTaffy(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getTaffy(float x, float y, float z) {
        return this.singleTaffy(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public float singleTaffy(int seed, float x, float y, float z) {
        float p3;
        float p0 = x * 0.7798978f + y * 0.6259069f;
        float p1 = x * -0.48268777f + y * 0.87579256f;
        float p2 = x * -0.25014642f + y * -0.5203461f + z * 0.81649655f;
        float xin = p3 = x * 0.0060886918f + y * -0.5773158f + z * -0.81649673f;
        float yin = p2;
        float zin = p0;
        float a = this.trillNoise(seed, xin, yin, zin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p0;
        yin = p1;
        zin = p3;
        float b = this.trillNoise(seed, xin + a, yin, zin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p1;
        yin = p2;
        zin = p3;
        float c = this.trillNoise(seed, xin + b, yin, zin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p0;
        yin = p1;
        zin = p2;
        float d = this.trillNoise(seed, xin + c, yin, zin);
        float result = (a + b + c + d) * 0.25f;
        float sharp = this.sharpnessInverse * 0.8f;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    protected float singleTaffyFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleTaffy(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleTaffy(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getTaffyFractal(float x, float y, float z, float w) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleTaffyFractalFBM(x, y, z, w);
            }
            case 1: {
                return this.singleTaffyFractalBillow(x, y, z, w);
            }
            case 2: {
                return this.singleTaffyFractalRidgedMulti(x, y, z, w);
            }
        }
        return 0.0f;
    }

    public float getTaffy(float x, float y, float z, float w) {
        return this.singleTaffy(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    public float singleTaffy(int seed, float x, float y, float z, float w) {
        float p4;
        float p0 = x * 0.84720474f + y * 0.5312665f;
        float p1 = x * -0.56399137f + y * 0.82578063f;
        float p2 = x * -0.18557791f + y * -0.36363098f + z * 0.91287094f;
        float p3 = x * 0.02354939f + y * -0.40755945f + z * -0.45643544f + w * 0.7905694f;
        float xin = p4 = x * 0.10397277f + y * -0.39474648f + z * -0.45643544f + w * -0.7905694f;
        float yin = p1;
        float zin = p3;
        float win = p2;
        float a = this.trillNoise(seed, xin, yin, zin, win);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p3;
        yin = p2;
        zin = p0;
        win = p4;
        float b = this.trillNoise(seed, xin + a, yin, zin, win);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p0;
        yin = p3;
        zin = p4;
        win = p1;
        float c = this.trillNoise(seed, xin + b, yin, zin, win);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p2;
        yin = p4;
        zin = p1;
        win = p0;
        float d = this.trillNoise(seed, xin + c, yin, zin, win);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p1;
        yin = p0;
        zin = p2;
        win = p3;
        float e = this.trillNoise(seed, xin + d, yin, zin, win);
        float result = (a + b + c + d + e) * 0.2f;
        float sharp = this.sharpnessInverse * 0.6666667f;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public float getTaffyFractal(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleTaffyFractalFBM(x, y, z, w, u);
            }
            case 1: {
                return this.singleTaffyFractalBillow(x, y, z, w, u);
            }
            case 2: {
                return this.singleTaffyFractalRidgedMulti(x, y, z, w, u);
            }
        }
        return 0.0f;
    }

    protected float singleTaffyFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleTaffy(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleTaffy(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singleTaffy(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleTaffy(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getTaffy(float x, float y, float z, float w, float u) {
        return this.singleTaffy(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    public float singleTaffy(int seed, float x, float y, float z, float w, float u) {
        float p0 = x * 0.88808066f + y * 0.4596875f;
        float p1 = x * -0.773132f + y * 0.63424504f;
        float p2 = x * 0.02839993f + y * -0.31493902f + z * 0.94868326f;
        float p3 = x * 0.022960793f + y * -0.3153843f + z * -0.3162278f + w * 0.8944272f;
        float p4 = x * -0.09451942f + y * -0.30177158f + z * -0.3162278f + w * -0.44721365f + u * 0.77459663f;
        float p5 = x * -0.071354955f + y * -0.30807218f + z * -0.3162278f + w * -0.44721365f + u * -0.7745968f;
        float xin = p1;
        float yin = p2;
        float zin = p3;
        float win = p4;
        float uin = p5;
        float a = this.trillNoise(seed, xin, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p2;
        zin = p3;
        win = p4;
        uin = p5;
        float b = this.trillNoise(seed, xin + a, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p3;
        win = p4;
        uin = p5;
        float c = this.trillNoise(seed, xin + b, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p4;
        uin = p5;
        float d = this.trillNoise(seed, xin + c, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p5;
        float e = this.trillNoise(seed, xin + d, yin, zin, win, uin);
        seed -= 1640531523;
        seed ^= seed >>> 14;
        xin = p0;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p4;
        float f = this.trillNoise(seed, xin + e, yin, zin, win, uin);
        float result = (a + b + c + d + e + f) * 0.16666667f;
        float sharp = this.sharpnessInverse * 0.5714286f;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public float getTaffyFractal(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleTaffyFractalFBM(x, y, z, w, u, v);
            }
            case 1: {
                return this.singleTaffyFractalBillow(x, y, z, w, u, v);
            }
            case 2: {
                return this.singleTaffyFractalRidgedMulti(x, y, z, w, u, v);
            }
        }
        return 0.0f;
    }

    protected float singleTaffyFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleTaffy(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singleTaffy(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getTaffy(float x, float y, float z, float w, float u, float v) {
        return this.singleTaffy(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    public float singleTaffy(int seed, float x, float y, float z, float w, float u, float v) {
        float p0 = x * 0.87910366f + y * 0.4766307f;
        float p1 = x * -0.6905121f + y * 0.7233209f;
        float p2 = x * -0.038522165f + y * -0.25530905f + z * 0.9660918f;
        float p3 = x * -0.10241036f + y * -0.23702061f + z * -0.24152295f + w * 0.9354144f;
        float p4 = x * 0.054299045f + y * -0.25240397f + z * -0.24152295f + w * -0.3118048f + u * 0.8819171f;
        float p5 = x * 0.0047030966f + y * -0.2581542f + z * -0.24152295f + w * -0.3118048f + u * -0.44095856f + v * 0.7637626f;
        float p6 = x * -0.16337831f + y * -0.19993554f + z * -0.24152295f + w * -0.3118048f + u * -0.44095856f + v * -0.7637627f;
        float xin = p0;
        float yin = p5;
        float zin = p3;
        float win = p6;
        float uin = p1;
        float vin = p4;
        float a = this.trillNoise(seed, xin, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p2;
        yin = p6;
        zin = p0;
        win = p4;
        uin = p5;
        vin = p3;
        float b = this.trillNoise(seed, xin + a, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p1;
        yin = p2;
        zin = p3;
        win = p4;
        uin = p6;
        vin = p5;
        float c = this.trillNoise(seed, xin + b, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p6;
        yin = p0;
        zin = p2;
        win = p5;
        uin = p4;
        vin = p1;
        float d = this.trillNoise(seed, xin + c, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p2;
        yin = p1;
        zin = p5;
        win = p0;
        uin = p3;
        vin = p6;
        float e = this.trillNoise(seed, xin + d, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p0;
        yin = p4;
        zin = p6;
        win = p3;
        uin = p1;
        vin = p2;
        float f = this.trillNoise(seed, xin + e, yin, zin, win, uin, vin);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p5;
        yin = p1;
        zin = p2;
        win = p3;
        uin = p4;
        vin = p0;
        float g = this.trillNoise(seed, xin + f, yin, zin, win, uin, vin);
        float result = (a + b + c + d + e + f + g) * 0.14285715f;
        float sharp = this.sharpnessInverse * 0.5f;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    protected float singleTaffyFractalFBM(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = this.singleTaffy(seed, x, y, z, w, u, v, m);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity, m *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalDomainWarp(float x, float y, float z, float w, float u, float v, float m) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleTaffy(seed, x, y, z, w, u, v, m);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            m *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1170 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2340 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 3510 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 4681 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 5851 & 0x3FFF];
            float g = TrigTools.SIN_TABLE[idx + 7021 & 0x3FFF];
            latest = this.singleTaffy(++seed, x + a, y + b, z + c, w + d, u + e, v + f, m + g);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalBillow(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = Math.abs(this.singleTaffy(seed, x, y, z, w, u, v, m)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            sum += (Math.abs(this.singleTaffy(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity, m *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleTaffyFractalRidgedMulti(float x, float y, float z, float w, float u, float v, float m) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleTaffy(seed + i, x, y, z, w, u, v, m));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            m *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float singleTaffy(int seed, float x, float y, float z, float w, float u, float v, float m) {
        float p0 = x * 0.8787378f + y * 0.47730482f;
        float p1 = x * -0.46614632f + y * 0.8847077f;
        float p2 = x * -0.11980514f + y * -0.18238907f + z * 0.97590005f;
        float p3 = x * 0.03081842f + y * -0.21601889f + z * -0.19518004f + w * 0.9561829f;
        float p4 = x * 0.010164112f + y * -0.21797714f + z * -0.19518004f + w * -0.23904574f + u * 0.92582005f;
        float p5 = x * -0.009578837f + y * -0.21800756f + z * -0.19518004f + w * -0.23904574f + u * -0.30860677f + v * 0.8728715f;
        float p6 = x * 0.046218276f + y * -0.21324952f + z * -0.19518004f + w * -0.23904574f + u * -0.30860677f + v * -0.4364359f + m * 0.7559289f;
        float p7 = x * -0.059933554f + y * -0.20982619f + z * -0.19518004f + w * -0.23904574f + u * -0.30860677f + v * -0.4364359f + m * -0.7559293f;
        float xin = p0;
        float yin = p6;
        float zin = p3;
        float win = p7;
        float uin = p1;
        float vin = p4;
        float min = p5;
        float a = this.trillNoise(seed, xin, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p2;
        yin = p3;
        zin = p0;
        win = p4;
        uin = p6;
        vin = p5;
        min = p7;
        float b = this.trillNoise(seed, xin + a, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p1;
        yin = p2;
        zin = p4;
        win = p3;
        uin = p5;
        vin = p7;
        min = p6;
        float c = this.trillNoise(seed, xin + b, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p7;
        yin = p0;
        zin = p2;
        win = p5;
        uin = p4;
        vin = p6;
        min = p1;
        float d = this.trillNoise(seed, xin + c, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p3;
        yin = p1;
        zin = p5;
        win = p6;
        uin = p7;
        vin = p0;
        min = p2;
        float e = this.trillNoise(seed, xin + d, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p4;
        yin = p7;
        zin = p6;
        win = p2;
        uin = p0;
        vin = p1;
        min = p3;
        float f = this.trillNoise(seed, xin + e, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p5;
        yin = p4;
        zin = p7;
        win = p1;
        uin = p2;
        vin = p3;
        min = p0;
        float g = this.trillNoise(seed, xin + f, yin, zin, win, uin, vin, min);
        seed = seed * 648051 ^ 0x7F4A7C15;
        xin = p6;
        yin = p5;
        zin = p1;
        win = p0;
        uin = p3;
        vin = p2;
        min = p4;
        float h = this.trillNoise(seed, xin + g, yin, zin, win, uin, vin, min);
        float result = (a + b + c + d + e + f + g + h) * 0.125f;
        float sharp = this.sharpnessInverse * 0.44444445f;
        return result / ((sharp - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public float getPerlinFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 3: {
                return this.singlePerlinFractalDomainWarp(x, y);
            }
            case 1: {
                return this.singlePerlinFractalBillow(x, y);
            }
            case 2: {
                return this.singlePerlinFractalRidgedMulti(x, y);
            }
        }
        return this.singlePerlinFractalFBM(x, y);
    }

    protected float singlePerlinFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singlePerlin(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singlePerlin(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singlePerlin(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singlePerlin(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singlePerlin(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getPerlin(float x, float y) {
        return this.singlePerlin(this.seed, x * this.frequency, y * this.frequency);
    }

    protected float singlePerlin(int seed, float x, float y) {
        float ys;
        float xs;
        int x0 = MathTools.fastFloor((float)x);
        int y0 = MathTools.fastFloor((float)y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        switch (this.interpolation) {
            default: {
                xs = x - (float)x0;
                ys = y - (float)y0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(x - (float)x0);
                ys = Noise.hermiteInterpolator(y - (float)y0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(x - (float)x0);
                ys = Noise.quinticInterpolator(y - (float)y0);
            }
        }
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float xf0 = Noise.lerp(this.gradCoord2D(seed, x0, y0, xd0, yd0), this.gradCoord2D(seed, x1, y0, xd1, yd0), xs);
        float xf1 = Noise.lerp(this.gradCoord2D(seed, x0, y1, xd0, yd1), this.gradCoord2D(seed, x1, y1, xd1, yd1), xs);
        return Noise.lerp(xf0, xf1, ys);
    }

    public float getPerlinFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singlePerlinFractalFBM(x, y, z);
            }
            case 1: {
                return this.singlePerlinFractalBillow(x, y, z);
            }
            case 2: {
                return this.singlePerlinFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    protected float singlePerlinFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singlePerlin(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singlePerlin(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singlePerlin(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singlePerlin(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singlePerlin(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getPerlin(float x, float y, float z) {
        return this.singlePerlin(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    protected float singlePerlin(int seed, float x, float y, float z) {
        float zs;
        float ys;
        float xs;
        int x0 = MathTools.fastFloor((float)x);
        int y0 = MathTools.fastFloor((float)y);
        int z0 = MathTools.fastFloor((float)z);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        switch (this.interpolation) {
            default: {
                xs = x - (float)x0;
                ys = y - (float)y0;
                zs = z - (float)z0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(x - (float)x0);
                ys = Noise.hermiteInterpolator(y - (float)y0);
                zs = Noise.hermiteInterpolator(z - (float)z0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(x - (float)x0);
                ys = Noise.quinticInterpolator(y - (float)y0);
                zs = Noise.quinticInterpolator(z - (float)z0);
            }
        }
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float zd0 = z - (float)z0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float zd1 = zd0 - 1.0f;
        float xf00 = Noise.lerp(this.gradCoord3D(seed, x0, y0, z0, xd0, yd0, zd0), this.gradCoord3D(seed, x1, y0, z0, xd1, yd0, zd0), xs);
        float xf10 = Noise.lerp(this.gradCoord3D(seed, x0, y1, z0, xd0, yd1, zd0), this.gradCoord3D(seed, x1, y1, z0, xd1, yd1, zd0), xs);
        float xf01 = Noise.lerp(this.gradCoord3D(seed, x0, y0, z1, xd0, yd0, zd1), this.gradCoord3D(seed, x1, y0, z1, xd1, yd0, zd1), xs);
        float xf11 = Noise.lerp(this.gradCoord3D(seed, x0, y1, z1, xd0, yd1, zd1), this.gradCoord3D(seed, x1, y1, z1, xd1, yd1, zd1), xs);
        float yf0 = Noise.lerp(xf00, xf10, ys);
        float yf1 = Noise.lerp(xf01, xf11, ys);
        return Noise.lerp(yf0, yf1, zs);
    }

    public float getPerlin(float x, float y, float z, float w) {
        return this.singlePerlin(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    protected float singlePerlin(int seed, float x, float y, float z, float w) {
        float ws;
        float zs;
        float ys;
        float xs;
        int x0 = MathTools.fastFloor((float)x);
        int y0 = MathTools.fastFloor((float)y);
        int z0 = MathTools.fastFloor((float)z);
        int w0 = MathTools.fastFloor((float)w);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        int w1 = w0 + 1;
        switch (this.interpolation) {
            default: {
                xs = x - (float)x0;
                ys = y - (float)y0;
                zs = z - (float)z0;
                ws = w - (float)w0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(x - (float)x0);
                ys = Noise.hermiteInterpolator(y - (float)y0);
                zs = Noise.hermiteInterpolator(z - (float)z0);
                ws = Noise.hermiteInterpolator(w - (float)w0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(x - (float)x0);
                ys = Noise.quinticInterpolator(y - (float)y0);
                zs = Noise.quinticInterpolator(z - (float)z0);
                ws = Noise.quinticInterpolator(w - (float)w0);
            }
        }
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float zd0 = z - (float)z0;
        float wd0 = w - (float)w0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float zd1 = zd0 - 1.0f;
        float wd1 = wd0 - 1.0f;
        float xf000 = Noise.lerp(this.gradCoord4D(seed, x0, y0, z0, w0, xd0, yd0, zd0, wd0), this.gradCoord4D(seed, x1, y0, z0, w0, xd1, yd0, zd0, wd0), xs);
        float xf100 = Noise.lerp(this.gradCoord4D(seed, x0, y1, z0, w0, xd0, yd1, zd0, wd0), this.gradCoord4D(seed, x1, y1, z0, w0, xd1, yd1, zd0, wd0), xs);
        float xf010 = Noise.lerp(this.gradCoord4D(seed, x0, y0, z1, w0, xd0, yd0, zd1, wd0), this.gradCoord4D(seed, x1, y0, z1, w0, xd1, yd0, zd1, wd0), xs);
        float xf110 = Noise.lerp(this.gradCoord4D(seed, x0, y1, z1, w0, xd0, yd1, zd1, wd0), this.gradCoord4D(seed, x1, y1, z1, w0, xd1, yd1, zd1, wd0), xs);
        float xf001 = Noise.lerp(this.gradCoord4D(seed, x0, y0, z0, w1, xd0, yd0, zd0, wd1), this.gradCoord4D(seed, x1, y0, z0, w1, xd1, yd0, zd0, wd1), xs);
        float xf101 = Noise.lerp(this.gradCoord4D(seed, x0, y1, z0, w1, xd0, yd1, zd0, wd1), this.gradCoord4D(seed, x1, y1, z0, w1, xd1, yd1, zd0, wd1), xs);
        float xf011 = Noise.lerp(this.gradCoord4D(seed, x0, y0, z1, w1, xd0, yd0, zd1, wd1), this.gradCoord4D(seed, x1, y0, z1, w1, xd1, yd0, zd1, wd1), xs);
        float xf111 = Noise.lerp(this.gradCoord4D(seed, x0, y1, z1, w1, xd0, yd1, zd1, wd1), this.gradCoord4D(seed, x1, y1, z1, w1, xd1, yd1, zd1, wd1), xs);
        float yf00 = Noise.lerp(xf000, xf100, ys);
        float yf10 = Noise.lerp(xf010, xf110, ys);
        float yf01 = Noise.lerp(xf001, xf101, ys);
        float yf11 = Noise.lerp(xf011, xf111, ys);
        float zf0 = Noise.lerp(yf00, yf10, zs);
        float zf1 = Noise.lerp(yf01, yf11, zs);
        return Noise.lerp(zf0, zf1, ws) * 0.55f;
    }

    protected float singlePerlinFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singlePerlin(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singlePerlin(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singlePerlin(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singlePerlin(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singlePerlin(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getPerlin(float x, float y, float z, float w, float u) {
        return this.singlePerlin(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    protected float singlePerlin(int seed, float x, float y, float z, float w, float u) {
        float us;
        float ws;
        float zs;
        float ys;
        float xs;
        int x0 = MathTools.fastFloor((float)x);
        int y0 = MathTools.fastFloor((float)y);
        int z0 = MathTools.fastFloor((float)z);
        int w0 = MathTools.fastFloor((float)w);
        int u0 = MathTools.fastFloor((float)u);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        int w1 = w0 + 1;
        int u1 = u0 + 1;
        switch (this.interpolation) {
            default: {
                xs = x - (float)x0;
                ys = y - (float)y0;
                zs = z - (float)z0;
                ws = w - (float)w0;
                us = u - (float)u0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(x - (float)x0);
                ys = Noise.hermiteInterpolator(y - (float)y0);
                zs = Noise.hermiteInterpolator(z - (float)z0);
                ws = Noise.hermiteInterpolator(w - (float)w0);
                us = Noise.hermiteInterpolator(u - (float)u0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(x - (float)x0);
                ys = Noise.quinticInterpolator(y - (float)y0);
                zs = Noise.quinticInterpolator(z - (float)z0);
                ws = Noise.quinticInterpolator(w - (float)w0);
                us = Noise.quinticInterpolator(u - (float)u0);
            }
        }
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float zd0 = z - (float)z0;
        float wd0 = w - (float)w0;
        float ud0 = u - (float)u0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float zd1 = zd0 - 1.0f;
        float wd1 = wd0 - 1.0f;
        float ud1 = ud0 - 1.0f;
        float xf0000 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z0, w0, u0, xd0, yd0, zd0, wd0, ud0), this.gradCoord5D(seed, x1, y0, z0, w0, u0, xd1, yd0, zd0, wd0, ud0), xs);
        float xf1000 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z0, w0, u0, xd0, yd1, zd0, wd0, ud0), this.gradCoord5D(seed, x1, y1, z0, w0, u0, xd1, yd1, zd0, wd0, ud0), xs);
        float xf0100 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z1, w0, u0, xd0, yd0, zd1, wd0, ud0), this.gradCoord5D(seed, x1, y0, z1, w0, u0, xd1, yd0, zd1, wd0, ud0), xs);
        float xf1100 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z1, w0, u0, xd0, yd1, zd1, wd0, ud0), this.gradCoord5D(seed, x1, y1, z1, w0, u0, xd1, yd1, zd1, wd0, ud0), xs);
        float xf0010 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z0, w1, u0, xd0, yd0, zd0, wd1, ud0), this.gradCoord5D(seed, x1, y0, z0, w1, u0, xd1, yd0, zd0, wd1, ud0), xs);
        float xf1010 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z0, w1, u0, xd0, yd1, zd0, wd1, ud0), this.gradCoord5D(seed, x1, y1, z0, w1, u0, xd1, yd1, zd0, wd1, ud0), xs);
        float xf0110 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z1, w1, u0, xd0, yd0, zd1, wd1, ud0), this.gradCoord5D(seed, x1, y0, z1, w1, u0, xd1, yd0, zd1, wd1, ud0), xs);
        float xf1110 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z1, w1, u0, xd0, yd1, zd1, wd1, ud0), this.gradCoord5D(seed, x1, y1, z1, w1, u0, xd1, yd1, zd1, wd1, ud0), xs);
        float xf0001 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z0, w0, u1, xd0, yd0, zd0, wd0, ud1), this.gradCoord5D(seed, x1, y0, z0, w0, u1, xd1, yd0, zd0, wd0, ud1), xs);
        float xf1001 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z0, w0, u1, xd0, yd1, zd0, wd0, ud1), this.gradCoord5D(seed, x1, y1, z0, w0, u1, xd1, yd1, zd0, wd0, ud1), xs);
        float xf0101 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z1, w0, u1, xd0, yd0, zd1, wd0, ud1), this.gradCoord5D(seed, x1, y0, z1, w0, u1, xd1, yd0, zd1, wd0, ud1), xs);
        float xf1101 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z1, w0, u1, xd0, yd1, zd1, wd0, ud1), this.gradCoord5D(seed, x1, y1, z1, w0, u1, xd1, yd1, zd1, wd0, ud1), xs);
        float xf0011 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z0, w1, u1, xd0, yd0, zd0, wd1, ud1), this.gradCoord5D(seed, x1, y0, z0, w1, u1, xd1, yd0, zd0, wd1, ud1), xs);
        float xf1011 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z0, w1, u1, xd0, yd1, zd0, wd1, ud1), this.gradCoord5D(seed, x1, y1, z0, w1, u1, xd1, yd1, zd0, wd1, ud1), xs);
        float xf0111 = Noise.lerp(this.gradCoord5D(seed, x0, y0, z1, w1, u1, xd0, yd0, zd1, wd1, ud1), this.gradCoord5D(seed, x1, y0, z1, w1, u1, xd1, yd0, zd1, wd1, ud1), xs);
        float xf1111 = Noise.lerp(this.gradCoord5D(seed, x0, y1, z1, w1, u1, xd0, yd1, zd1, wd1, ud1), this.gradCoord5D(seed, x1, y1, z1, w1, u1, xd1, yd1, zd1, wd1, ud1), xs);
        float yf000 = Noise.lerp(xf0000, xf1000, ys);
        float yf100 = Noise.lerp(xf0100, xf1100, ys);
        float yf010 = Noise.lerp(xf0010, xf1010, ys);
        float yf110 = Noise.lerp(xf0110, xf1110, ys);
        float yf001 = Noise.lerp(xf0001, xf1001, ys);
        float yf101 = Noise.lerp(xf0101, xf1101, ys);
        float yf011 = Noise.lerp(xf0011, xf1011, ys);
        float yf111 = Noise.lerp(xf0111, xf1111, ys);
        float zf00 = Noise.lerp(yf000, yf100, zs);
        float zf10 = Noise.lerp(yf010, yf110, zs);
        float zf01 = Noise.lerp(yf001, yf101, zs);
        float zf11 = Noise.lerp(yf011, yf111, zs);
        float wf0 = Noise.lerp(zf00, zf10, ws);
        float wf1 = Noise.lerp(zf01, zf11, ws);
        return Noise.lerp(wf0, wf1, us) * 0.7777777f;
    }

    protected float singlePerlinFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singlePerlin(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += this.singlePerlin(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singlePerlin(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singlePerlin(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singlePerlin(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += (Math.abs(this.singlePerlin(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singlePerlin(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getPerlin(float x, float y, float z, float w, float u, float v) {
        return this.singlePerlin(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    protected float singlePerlin(int seed, float x, float y, float z, float w, float u, float v) {
        float vs;
        float us;
        float ws;
        float zs;
        float ys;
        float xs;
        int x0 = MathTools.fastFloor((float)x);
        int y0 = MathTools.fastFloor((float)y);
        int z0 = MathTools.fastFloor((float)z);
        int w0 = MathTools.fastFloor((float)w);
        int u0 = MathTools.fastFloor((float)u);
        int v0 = MathTools.fastFloor((float)v);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        int w1 = w0 + 1;
        int u1 = u0 + 1;
        int v1 = v0 + 1;
        switch (this.interpolation) {
            default: {
                xs = x - (float)x0;
                ys = y - (float)y0;
                zs = z - (float)z0;
                ws = w - (float)w0;
                us = u - (float)u0;
                vs = v - (float)v0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(x - (float)x0);
                ys = Noise.hermiteInterpolator(y - (float)y0);
                zs = Noise.hermiteInterpolator(z - (float)z0);
                ws = Noise.hermiteInterpolator(w - (float)w0);
                us = Noise.hermiteInterpolator(u - (float)u0);
                vs = Noise.hermiteInterpolator(v - (float)v0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(x - (float)x0);
                ys = Noise.quinticInterpolator(y - (float)y0);
                zs = Noise.quinticInterpolator(z - (float)z0);
                ws = Noise.quinticInterpolator(w - (float)w0);
                us = Noise.quinticInterpolator(u - (float)u0);
                vs = Noise.quinticInterpolator(v - (float)v0);
            }
        }
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float zd0 = z - (float)z0;
        float wd0 = w - (float)w0;
        float ud0 = u - (float)u0;
        float vd0 = v - (float)v0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float zd1 = zd0 - 1.0f;
        float wd1 = wd0 - 1.0f;
        float ud1 = ud0 - 1.0f;
        float vd1 = vd0 - 1.0f;
        float xf00000 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w0, u0, v0, xd0, yd0, zd0, wd0, ud0, vd0), this.gradCoord6D(seed, x1, y0, z0, w0, u0, v0, xd1, yd0, zd0, wd0, ud0, vd0), xs);
        float xf10000 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w0, u0, v0, xd0, yd1, zd0, wd0, ud0, vd0), this.gradCoord6D(seed, x1, y1, z0, w0, u0, v0, xd1, yd1, zd0, wd0, ud0, vd0), xs);
        float xf01000 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w0, u0, v0, xd0, yd0, zd1, wd0, ud0, vd0), this.gradCoord6D(seed, x1, y0, z1, w0, u0, v0, xd1, yd0, zd1, wd0, ud0, vd0), xs);
        float xf11000 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w0, u0, v0, xd0, yd1, zd1, wd0, ud0, vd0), this.gradCoord6D(seed, x1, y1, z1, w0, u0, v0, xd1, yd1, zd1, wd0, ud0, vd0), xs);
        float xf00100 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w1, u0, v0, xd0, yd0, zd0, wd1, ud0, vd0), this.gradCoord6D(seed, x1, y0, z0, w1, u0, v0, xd1, yd0, zd0, wd1, ud0, vd0), xs);
        float xf10100 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w1, u0, v0, xd0, yd1, zd0, wd1, ud0, vd0), this.gradCoord6D(seed, x1, y1, z0, w1, u0, v0, xd1, yd1, zd0, wd1, ud0, vd0), xs);
        float xf01100 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w1, u0, v0, xd0, yd0, zd1, wd1, ud0, vd0), this.gradCoord6D(seed, x1, y0, z1, w1, u0, v0, xd1, yd0, zd1, wd1, ud0, vd0), xs);
        float xf11100 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w1, u0, v0, xd0, yd1, zd1, wd1, ud0, vd0), this.gradCoord6D(seed, x1, y1, z1, w1, u0, v0, xd1, yd1, zd1, wd1, ud0, vd0), xs);
        float xf00010 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w0, u1, v0, xd0, yd0, zd0, wd0, ud1, vd0), this.gradCoord6D(seed, x1, y0, z0, w0, u1, v0, xd1, yd0, zd0, wd0, ud1, vd0), xs);
        float xf10010 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w0, u1, v0, xd0, yd1, zd0, wd0, ud1, vd0), this.gradCoord6D(seed, x1, y1, z0, w0, u1, v0, xd1, yd1, zd0, wd0, ud1, vd0), xs);
        float xf01010 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w0, u1, v0, xd0, yd0, zd1, wd0, ud1, vd0), this.gradCoord6D(seed, x1, y0, z1, w0, u1, v0, xd1, yd0, zd1, wd0, ud1, vd0), xs);
        float xf11010 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w0, u1, v0, xd0, yd1, zd1, wd0, ud1, vd0), this.gradCoord6D(seed, x1, y1, z1, w0, u1, v0, xd1, yd1, zd1, wd0, ud1, vd0), xs);
        float xf00110 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w1, u1, v0, xd0, yd0, zd0, wd1, ud1, vd0), this.gradCoord6D(seed, x1, y0, z0, w1, u1, v0, xd1, yd0, zd0, wd1, ud1, vd0), xs);
        float xf10110 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w1, u1, v0, xd0, yd1, zd0, wd1, ud1, vd0), this.gradCoord6D(seed, x1, y1, z0, w1, u1, v0, xd1, yd1, zd0, wd1, ud1, vd0), xs);
        float xf01110 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w1, u1, v0, xd0, yd0, zd1, wd1, ud1, vd0), this.gradCoord6D(seed, x1, y0, z1, w1, u1, v0, xd1, yd0, zd1, wd1, ud1, vd0), xs);
        float xf11110 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w1, u1, v0, xd0, yd1, zd1, wd1, ud1, vd0), this.gradCoord6D(seed, x1, y1, z1, w1, u1, v0, xd1, yd1, zd1, wd1, ud1, vd0), xs);
        float xf00001 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w0, u0, v1, xd0, yd0, zd0, wd0, ud0, vd1), this.gradCoord6D(seed, x1, y0, z0, w0, u0, v1, xd1, yd0, zd0, wd0, ud0, vd1), xs);
        float xf10001 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w0, u0, v1, xd0, yd1, zd0, wd0, ud0, vd1), this.gradCoord6D(seed, x1, y1, z0, w0, u0, v1, xd1, yd1, zd0, wd0, ud0, vd1), xs);
        float xf01001 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w0, u0, v1, xd0, yd0, zd1, wd0, ud0, vd1), this.gradCoord6D(seed, x1, y0, z1, w0, u0, v1, xd1, yd0, zd1, wd0, ud0, vd1), xs);
        float xf11001 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w0, u0, v1, xd0, yd1, zd1, wd0, ud0, vd1), this.gradCoord6D(seed, x1, y1, z1, w0, u0, v1, xd1, yd1, zd1, wd0, ud0, vd1), xs);
        float xf00101 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w1, u0, v1, xd0, yd0, zd0, wd1, ud0, vd1), this.gradCoord6D(seed, x1, y0, z0, w1, u0, v1, xd1, yd0, zd0, wd1, ud0, vd1), xs);
        float xf10101 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w1, u0, v1, xd0, yd1, zd0, wd1, ud0, vd1), this.gradCoord6D(seed, x1, y1, z0, w1, u0, v1, xd1, yd1, zd0, wd1, ud0, vd1), xs);
        float xf01101 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w1, u0, v1, xd0, yd0, zd1, wd1, ud0, vd1), this.gradCoord6D(seed, x1, y0, z1, w1, u0, v1, xd1, yd0, zd1, wd1, ud0, vd1), xs);
        float xf11101 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w1, u0, v1, xd0, yd1, zd1, wd1, ud0, vd1), this.gradCoord6D(seed, x1, y1, z1, w1, u0, v1, xd1, yd1, zd1, wd1, ud0, vd1), xs);
        float xf00011 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w0, u1, v1, xd0, yd0, zd0, wd0, ud1, vd1), this.gradCoord6D(seed, x1, y0, z0, w0, u1, v1, xd1, yd0, zd0, wd0, ud1, vd1), xs);
        float xf10011 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w0, u1, v1, xd0, yd1, zd0, wd0, ud1, vd1), this.gradCoord6D(seed, x1, y1, z0, w0, u1, v1, xd1, yd1, zd0, wd0, ud1, vd1), xs);
        float xf01011 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w0, u1, v1, xd0, yd0, zd1, wd0, ud1, vd1), this.gradCoord6D(seed, x1, y0, z1, w0, u1, v1, xd1, yd0, zd1, wd0, ud1, vd1), xs);
        float xf11011 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w0, u1, v1, xd0, yd1, zd1, wd0, ud1, vd1), this.gradCoord6D(seed, x1, y1, z1, w0, u1, v1, xd1, yd1, zd1, wd0, ud1, vd1), xs);
        float xf00111 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z0, w1, u1, v1, xd0, yd0, zd0, wd1, ud1, vd1), this.gradCoord6D(seed, x1, y0, z0, w1, u1, v1, xd1, yd0, zd0, wd1, ud1, vd1), xs);
        float xf10111 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z0, w1, u1, v1, xd0, yd1, zd0, wd1, ud1, vd1), this.gradCoord6D(seed, x1, y1, z0, w1, u1, v1, xd1, yd1, zd0, wd1, ud1, vd1), xs);
        float xf01111 = Noise.lerp(this.gradCoord6D(seed, x0, y0, z1, w1, u1, v1, xd0, yd0, zd1, wd1, ud1, vd1), this.gradCoord6D(seed, x1, y0, z1, w1, u1, v1, xd1, yd0, zd1, wd1, ud1, vd1), xs);
        float xf11111 = Noise.lerp(this.gradCoord6D(seed, x0, y1, z1, w1, u1, v1, xd0, yd1, zd1, wd1, ud1, vd1), this.gradCoord6D(seed, x1, y1, z1, w1, u1, v1, xd1, yd1, zd1, wd1, ud1, vd1), xs);
        float yf0000 = Noise.lerp(xf00000, xf10000, ys);
        float yf1000 = Noise.lerp(xf01000, xf11000, ys);
        float yf0100 = Noise.lerp(xf00100, xf10100, ys);
        float yf1100 = Noise.lerp(xf01100, xf11100, ys);
        float yf0010 = Noise.lerp(xf00010, xf10010, ys);
        float yf1010 = Noise.lerp(xf01010, xf11010, ys);
        float yf0110 = Noise.lerp(xf00110, xf10110, ys);
        float yf1110 = Noise.lerp(xf01110, xf11110, ys);
        float yf0001 = Noise.lerp(xf00001, xf10001, ys);
        float yf1001 = Noise.lerp(xf01001, xf11001, ys);
        float yf0101 = Noise.lerp(xf00101, xf10101, ys);
        float yf1101 = Noise.lerp(xf01101, xf11101, ys);
        float yf0011 = Noise.lerp(xf00011, xf10011, ys);
        float yf1011 = Noise.lerp(xf01011, xf11011, ys);
        float yf0111 = Noise.lerp(xf00111, xf10111, ys);
        float yf1111 = Noise.lerp(xf01111, xf11111, ys);
        float zf000 = Noise.lerp(yf0000, yf1000, zs);
        float zf100 = Noise.lerp(yf0100, yf1100, zs);
        float zf010 = Noise.lerp(yf0010, yf1010, zs);
        float zf110 = Noise.lerp(yf0110, yf1110, zs);
        float zf001 = Noise.lerp(yf0001, yf1001, zs);
        float zf101 = Noise.lerp(yf0101, yf1101, zs);
        float zf011 = Noise.lerp(yf0011, yf1011, zs);
        float zf111 = Noise.lerp(yf0111, yf1111, zs);
        float wf00 = Noise.lerp(zf000, zf100, ws);
        float wf10 = Noise.lerp(zf010, zf110, ws);
        float wf01 = Noise.lerp(zf001, zf101, ws);
        float wf11 = Noise.lerp(zf011, zf111, ws);
        float uf0 = Noise.lerp(wf00, wf10, us);
        float uf1 = Noise.lerp(wf01, wf11, us);
        return Noise.lerp(uf0, uf1, vs) * 1.61f;
    }

    protected float singlePerlinFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singlePerlin(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singlePerlin(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singlePerlin(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singlePerlin(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += (Math.abs(this.singlePerlin(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singlePerlinFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singlePerlin(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getSimplexFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleSimplexFractalFBM(x, y);
            }
            case 1: {
                return this.singleSimplexFractalBillow(x, y);
            }
            case 2: {
                return this.singleSimplexFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    public float layered2D(float x, float y, int seed, int octaves) {
        return this.layered2D(x, y, seed, octaves, 0.03125f);
    }

    public float layered2D(float x, float y, int seed, int octaves, float frequency) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency);
        float amp = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            x += x;
            y += y;
            sum += this.singleSimplex(seed + i, x, y) * (amp *= 0.5f);
        }
        float ampFractal = (1 << octaves) - 1;
        return sum / ampFractal;
    }

    public float layered2D(float x, float y, int seed, int octaves, float frequency, float lacunarity) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency);
        float amp = 1.0f;
        float gain = 1.0f / lacunarity;
        for (int i = 1; i < octaves; ++i) {
            sum += this.singleSimplex(seed + i, x *= lacunarity, y *= lacunarity) * (amp *= gain);
        }
        amp = gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            ampFractal += amp;
            amp *= gain;
        }
        return sum / ampFractal;
    }

    public float layered2D(float x, float y, int seed, int octaves, float frequency, float lacunarity, float gain) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency);
        float amp = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            sum += this.singleSimplex(seed + i, x *= lacunarity, y *= lacunarity) * (amp *= gain);
        }
        amp = gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            ampFractal += amp;
            amp *= gain;
        }
        return sum / ampFractal;
    }

    public float ridged2D(float x, float y, int seed, int octaves) {
        return this.ridged2D(x, y, seed, octaves, 0.03125f, 2.0f);
    }

    public float ridged2D(float x, float y, int seed, int octaves, float frequency) {
        return this.ridged2D(x, y, seed, octaves, frequency, 2.0f);
    }

    public float ridged2D(float x, float y, int seed, int octaves, float frequency, float lacunarity) {
        x *= frequency;
        y *= frequency;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= lacunarity;
            y *= lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    protected float singleSimplexFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleSimplex(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleSimplex(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singleSimplex(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleSimplex(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.singleSimplex(++seed, x *= this.lacunarity, y *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getSimplex(float x, float y) {
        return this.singleSimplex(this.seed, x * this.frequency, y * this.frequency);
    }

    public float singleSimplex(int seed, float x, float y) {
        int j1;
        int i1;
        float Y0;
        float y0;
        int j;
        float t = (x + y) * 0.36602542f;
        int i = MathTools.fastFloor((float)(x + t));
        float X0 = (float)i - (t = (float)(i + (j = MathTools.fastFloor((float)(y + t)))) * 0.21132487f);
        float x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (float)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        float x1 = x0 - (float)i1 + 0.21132487f;
        float y1 = y0 - (float)j1 + 0.21132487f;
        float x2 = x0 - 1.0f + 0.42264974f;
        float y2 = y0 - 1.0f + 0.42264974f;
        float n = 0.0f;
        t = 0.5f - x0 * x0 - y0 * y0;
        if (t >= 0.0f) {
            t *= t;
            n += t * t * this.gradCoord2D(seed, i, j, x0, y0);
        }
        if ((t = 0.5f - x1 * x1 - y1 * y1) > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord2D(seed, i + i1, j + j1, x1, y1);
        }
        if ((t = 0.5f - x2 * x2 - y2 * y2) > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord2D(seed, i + 1, j + 1, x2, y2);
        }
        return n * 99.206894f;
    }

    public float getSimplexFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleSimplexFractalFBM(x, y, z);
            }
            case 1: {
                return this.singleSimplexFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleSimplexFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    public float layered3D(float x, float y, float z, int seed, int octaves) {
        return this.layered3D(x, y, z, seed, octaves, 0.03125f);
    }

    public float layered3D(float x, float y, float z, int seed, int octaves, float frequency) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency, z *= frequency);
        float amp = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            x += x;
            y += y;
            z += z;
            sum += this.singleSimplex(seed + i, x, y, z) * (amp *= 0.5f);
        }
        float ampFractal = (1 << octaves) - 1;
        return sum / ampFractal;
    }

    public float layered3D(float x, float y, float z, int seed, int octaves, float frequency, float lacunarity) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency, z *= frequency);
        float amp = 1.0f;
        float gain = 1.0f / lacunarity;
        for (int i = 1; i < octaves; ++i) {
            sum += this.singleSimplex(seed + i, x *= lacunarity, y *= lacunarity, z *= lacunarity) * (amp *= 0.5f);
        }
        amp = gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            ampFractal += amp;
            amp *= gain;
        }
        return sum / ampFractal;
    }

    public float layered3D(float x, float y, float z, int seed, int octaves, float frequency, float lacunarity, float gain) {
        float sum = this.singleSimplex(seed, x *= frequency, y *= frequency, z *= frequency);
        float amp = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            sum += this.singleSimplex(seed + i, x *= lacunarity, y *= lacunarity, z *= lacunarity) * (amp *= gain);
        }
        amp = gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < octaves; ++i) {
            ampFractal += amp;
            amp *= gain;
        }
        return sum / ampFractal;
    }

    public float ridged3D(float x, float y, float z, int seed, int octaves) {
        return this.ridged3D(x, y, z, seed, octaves, 0.03125f, 2.0f);
    }

    public float ridged3D(float x, float y, float z, int seed, int octaves, float frequency) {
        return this.ridged3D(x, y, z, seed, octaves, frequency, 2.0f);
    }

    public float ridged3D(float x, float y, float z, int seed, int octaves, float frequency, float lacunarity) {
        x *= frequency;
        y *= frequency;
        z *= frequency;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= lacunarity;
            y *= lacunarity;
            z *= lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    protected float singleSimplexFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleSimplex(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleSimplex(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleSimplex(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleSimplex(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getSimplex(float x, float y, float z) {
        return this.singleSimplex(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public float singleSimplex(int seed, float x, float y, float z) {
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        float t = (x + y + z) * 0.33333334f;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        t = (float)(i + j + k) * 0.16666667f;
        float x0 = x - ((float)i - t);
        float y0 = y - ((float)j - t);
        float z0 = z - ((float)k - t);
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        float x1 = x0 - (float)i1 + 0.16666667f;
        float y1 = y0 - (float)j1 + 0.16666667f;
        float z1 = z0 - (float)k1 + 0.16666667f;
        float x2 = x0 - (float)i2 + 0.33333334f;
        float y2 = y0 - (float)j2 + 0.33333334f;
        float z2 = z0 - (float)k2 + 0.33333334f;
        float x3 = x0 - 0.5f;
        float y3 = y0 - 0.5f;
        float z3 = z0 - 0.5f;
        float n = 0.0f;
        t = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
        if (t > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord3D(seed, i, j, k, x0, y0, z0);
        }
        if ((t = 0.6f - x1 * x1 - y1 * y1 - z1 * z1) > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord3D(seed, i + i1, j + j1, k + k1, x1, y1, z1);
        }
        if ((t = 0.6f - x2 * x2 - y2 * y2 - z2 * z2) > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord3D(seed, i + i2, j + j2, k + k2, x2, y2, z2);
        }
        if ((t = 0.6f - x3 * x3 - y3 * y3 - z3 * z3) > 0.0f) {
            t *= t;
            n += t * t * this.gradCoord3D(seed, i + 1, j + 1, k + 1, x3, y3, z3);
        }
        return 31.5f * n;
    }

    public float getSimplexFractal(float x, float y, float z, float w) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleSimplexFractalFBM(x, y, z, w);
            }
            case 1: {
                return this.singleSimplexFractalBillow(x, y, z, w);
            }
            case 2: {
                return this.singleSimplexFractalRidgedMulti(x, y, z, w);
            }
        }
        return 0.0f;
    }

    protected float singleSimplexFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleSimplex(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleSimplex(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleSimplex(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    protected float singleSimplexFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleSimplex(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    public float getSimplex(float x, float y, float z, float w) {
        return this.singleSimplex(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    public float singleSimplex(int seed, float x, float y, float z, float w) {
        float skew = (x + y + z + w) * F4;
        int i = MathTools.fastFloor((float)(x + skew));
        int j = MathTools.fastFloor((float)(y + skew));
        int k = MathTools.fastFloor((float)(z + skew));
        int l = MathTools.fastFloor((float)(w + skew));
        float unskew = (float)(i + j + k + l) * G4;
        float X0 = (float)i - unskew;
        float Y0 = (float)j - unskew;
        float Z0 = (float)k - unskew;
        float W0 = (float)l - unskew;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        int i1 = 2 - rankx >>> 31;
        int j1 = 2 - ranky >>> 31;
        int k1 = 2 - rankz >>> 31;
        int l1 = 2 - rankw >>> 31;
        int i2 = 1 - rankx >>> 31;
        int j2 = 1 - ranky >>> 31;
        int k2 = 1 - rankz >>> 31;
        int l2 = 1 - rankw >>> 31;
        int i3 = -rankx >>> 31;
        int j3 = -ranky >>> 31;
        int k3 = -rankz >>> 31;
        int l3 = -rankw >>> 31;
        float x1 = x0 - (float)i1 + G4;
        float y1 = y0 - (float)j1 + G4;
        float z1 = z0 - (float)k1 + G4;
        float w1 = w0 - (float)l1 + G4;
        float x2 = x0 - (float)i2 + 2.0f * G4;
        float y2 = y0 - (float)j2 + 2.0f * G4;
        float z2 = z0 - (float)k2 + 2.0f * G4;
        float w2 = w0 - (float)l2 + 2.0f * G4;
        float x3 = x0 - (float)i3 + 3.0f * G4;
        float y3 = y0 - (float)j3 + 3.0f * G4;
        float z3 = z0 - (float)k3 + 3.0f * G4;
        float w3 = w0 - (float)l3 + 3.0f * G4;
        float x4 = x0 - 1.0f + 4.0f * G4;
        float y4 = y0 - 1.0f + 4.0f * G4;
        float z4 = z0 - 1.0f + 4.0f * G4;
        float w4 = w0 - 1.0f + 4.0f * G4;
        float t0 = 0.4675f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 > 0.0f) {
            t0 *= t0;
            t0 *= t0 * this.gradCoord4D(seed, i, j, k, l, x0, y0, z0, w0);
        } else {
            t0 = 0.0f;
        }
        float t1 = 0.4675f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t1 > 0.0f) {
            t1 *= t1;
            t1 *= t1 * this.gradCoord4D(seed, i + i1, j + j1, k + k1, l + l1, x1, y1, z1, w1);
        } else {
            t1 = 0.0f;
        }
        float t2 = 0.4675f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t2 > 0.0f) {
            t2 *= t2;
            t2 *= t2 * this.gradCoord4D(seed, i + i2, j + j2, k + k2, l + l2, x2, y2, z2, w2);
        } else {
            t2 = 0.0f;
        }
        float t3 = 0.4675f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t3 > 0.0f) {
            t3 *= t3;
            t3 *= t3 * this.gradCoord4D(seed, i + i3, j + j3, k + k3, l + l3, x3, y3, z3, w3);
        } else {
            t3 = 0.0f;
        }
        float t4 = 0.4675f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t4 > 0.0f) {
            t4 *= t4;
            t4 *= t4 * this.gradCoord4D(seed, i + 1, j + 1, k + 1, l + 1, x4, y4, z4, w4);
        } else {
            t4 = 0.0f;
        }
        float n = (t0 + t1 + t2 + t3 + t4) * 141.0f;
        return n / (0.75f + Math.abs(n));
    }

    public float getSimplex(float x, float y, float z, float w, float u) {
        return this.singleSimplex(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    public float getSimplexFractal(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleSimplexFractalFBM(x, y, z, w, u);
            }
            case 1: {
                return this.singleSimplexFractalBillow(x, y, z, w, u);
            }
            case 2: {
                return this.singleSimplexFractalRidgedMulti(x, y, z, w, u);
            }
        }
        return 0.0f;
    }

    protected float singleSimplexFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singleSimplex(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleSimplex(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singleSimplex(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    protected float singleSimplexFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singleSimplex(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += (Math.abs(this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    public float singleSimplex(int seed, float x, float y, float z, float w, float u) {
        float n5;
        float n4;
        float n3;
        float n2;
        float n1;
        float n0;
        float t = (x + y + z + w + u) * F5;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        int l = MathTools.fastFloor((float)(w + t));
        int h = MathTools.fastFloor((float)(u + t));
        t = (float)(i + j + k + l + h) * G5;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float U0 = (float)h - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        float u0 = u - U0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        int ranku = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (x0 > u0) {
            ++rankx;
        } else {
            ++ranku;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (y0 > u0) {
            ++ranky;
        } else {
            ++ranku;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        if (z0 > u0) {
            ++rankz;
        } else {
            ++ranku;
        }
        if (w0 > u0) {
            ++rankw;
        } else {
            ++ranku;
        }
        int i1 = 3 - rankx >>> 31;
        int j1 = 3 - ranky >>> 31;
        int k1 = 3 - rankz >>> 31;
        int l1 = 3 - rankw >>> 31;
        int h1 = 3 - ranku >>> 31;
        int i2 = 2 - rankx >>> 31;
        int j2 = 2 - ranky >>> 31;
        int k2 = 2 - rankz >>> 31;
        int l2 = 2 - rankw >>> 31;
        int h2 = 2 - ranku >>> 31;
        int i3 = 1 - rankx >>> 31;
        int j3 = 1 - ranky >>> 31;
        int k3 = 1 - rankz >>> 31;
        int l3 = 1 - rankw >>> 31;
        int h3 = 1 - ranku >>> 31;
        int i4 = -rankx >>> 31;
        int j4 = -ranky >>> 31;
        int k4 = -rankz >>> 31;
        int l4 = -rankw >>> 31;
        int h4 = -ranku >>> 31;
        float x1 = x0 - (float)i1 + G5;
        float y1 = y0 - (float)j1 + G5;
        float z1 = z0 - (float)k1 + G5;
        float w1 = w0 - (float)l1 + G5;
        float u1 = u0 - (float)h1 + G5;
        float x2 = x0 - (float)i2 + 2.0f * G5;
        float y2 = y0 - (float)j2 + 2.0f * G5;
        float z2 = z0 - (float)k2 + 2.0f * G5;
        float w2 = w0 - (float)l2 + 2.0f * G5;
        float u2 = u0 - (float)h2 + 2.0f * G5;
        float x3 = x0 - (float)i3 + 3.0f * G5;
        float y3 = y0 - (float)j3 + 3.0f * G5;
        float z3 = z0 - (float)k3 + 3.0f * G5;
        float w3 = w0 - (float)l3 + 3.0f * G5;
        float u3 = u0 - (float)h3 + 3.0f * G5;
        float x4 = x0 - (float)i4 + 4.0f * G5;
        float y4 = y0 - (float)j4 + 4.0f * G5;
        float z4 = z0 - (float)k4 + 4.0f * G5;
        float w4 = w0 - (float)l4 + 4.0f * G5;
        float u4 = u0 - (float)h4 + 4.0f * G5;
        float x5 = x0 - 1.0f + 5.0f * G5;
        float y5 = y0 - 1.0f + 5.0f * G5;
        float z5 = z0 - 1.0f + 5.0f * G5;
        float w5 = w0 - 1.0f + 5.0f * G5;
        float u5 = u0 - 1.0f + 5.0f * G5;
        t = 0.67f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0 - u0 * u0;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * this.gradCoord5D(seed, i, j, k, l, h, x0, y0, z0, w0, u0);
        }
        t = 0.67f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1 - u1 * u1;
        if (t < 0.0f) {
            n1 = 0.0f;
        } else {
            t *= t;
            n1 = t * t * this.gradCoord5D(seed, i + i1, j + j1, k + k1, l + l1, h + h1, x1, y1, z1, w1, u1);
        }
        t = 0.67f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2 - u2 * u2;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * this.gradCoord5D(seed, i + i2, j + j2, k + k2, l + l2, h + h2, x2, y2, z2, w2, u2);
        }
        t = 0.67f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3 - u3 * u3;
        if (t < 0.0f) {
            n3 = 0.0f;
        } else {
            t *= t;
            n3 = t * t * this.gradCoord5D(seed, i + i3, j + j3, k + k3, l + l3, h + h3, x3, y3, z3, w3, u3);
        }
        t = 0.67f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4 - u4 * u4;
        if (t < 0.0f) {
            n4 = 0.0f;
        } else {
            t *= t;
            n4 = t * t * this.gradCoord5D(seed, i + i4, j + j4, k + k4, l + l4, h + h4, x4, y4, z4, w4, u4);
        }
        t = 0.67f - x5 * x5 - y5 * y5 - z5 * z5 - w5 * w5 - u5 * u5;
        if (t < 0.0f) {
            n5 = 0.0f;
        } else {
            t *= t;
            n5 = t * t * this.gradCoord5D(seed, i + 1, j + 1, k + 1, l + 1, h + 1, x5, y5, z5, w5, u5);
        }
        float n = (n0 + n1 + n2 + n3 + n4 + n5) * 32.0f;
        return n / (0.7f + Math.abs(n));
    }

    public float getSimplex(float x, float y, float z, float w, float u, float v) {
        return this.singleSimplex(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    public float getSimplexFractal(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleSimplexFractalFBM(x, y, z, w, u, v);
            }
            case 1: {
                return this.singleSimplexFractalBillow(x, y, z, w, u, v);
            }
            case 2: {
                return this.singleSimplexFractalRidgedMulti(x, y, z, w, u, v);
            }
        }
        return 0.0f;
    }

    protected float singleSimplexFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singleSimplex(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleSimplex(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singleSimplex(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleSimplexFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleSimplex(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    protected float singleSimplexFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singleSimplex(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += (Math.abs(this.singleSimplex(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    public float singleSimplex(int seed, float x, float y, float z, float w, float u, float v) {
        float t = (x + y + z + w + u + v) * F6;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        int l = MathTools.fastFloor((float)(w + t));
        int h = MathTools.fastFloor((float)(u + t));
        int g = MathTools.fastFloor((float)(v + t));
        t = (float)(i + j + k + l + h + g) * G6;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float U0 = (float)h - t;
        float V0 = (float)g - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        float u0 = u - U0;
        float v0 = v - V0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        int ranku = 0;
        int rankv = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (x0 > u0) {
            ++rankx;
        } else {
            ++ranku;
        }
        if (x0 > v0) {
            ++rankx;
        } else {
            ++rankv;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (y0 > u0) {
            ++ranky;
        } else {
            ++ranku;
        }
        if (y0 > v0) {
            ++ranky;
        } else {
            ++rankv;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        if (z0 > u0) {
            ++rankz;
        } else {
            ++ranku;
        }
        if (z0 > v0) {
            ++rankz;
        } else {
            ++rankv;
        }
        if (w0 > u0) {
            ++rankw;
        } else {
            ++ranku;
        }
        if (w0 > v0) {
            ++rankw;
        } else {
            ++rankv;
        }
        if (u0 > v0) {
            ++ranku;
        } else {
            ++rankv;
        }
        int i1 = 4 - rankx >>> 31;
        int j1 = 4 - ranky >>> 31;
        int k1 = 4 - rankz >>> 31;
        int l1 = 4 - rankw >>> 31;
        int h1 = 4 - ranku >>> 31;
        int g1 = 4 - rankv >>> 31;
        int i2 = 3 - rankx >>> 31;
        int j2 = 3 - ranky >>> 31;
        int k2 = 3 - rankz >>> 31;
        int l2 = 3 - rankw >>> 31;
        int h2 = 3 - ranku >>> 31;
        int g2 = 3 - rankv >>> 31;
        int i3 = 2 - rankx >>> 31;
        int j3 = 2 - ranky >>> 31;
        int k3 = 2 - rankz >>> 31;
        int l3 = 2 - rankw >>> 31;
        int h3 = 2 - ranku >>> 31;
        int g3 = 2 - rankv >>> 31;
        int i4 = 1 - rankx >>> 31;
        int j4 = 1 - ranky >>> 31;
        int k4 = 1 - rankz >>> 31;
        int l4 = 1 - rankw >>> 31;
        int h4 = 1 - ranku >>> 31;
        int g4 = 1 - rankv >>> 31;
        int i5 = -rankx >>> 31;
        int j5 = -ranky >>> 31;
        int k5 = -rankz >>> 31;
        int l5 = -rankw >>> 31;
        int h5 = -ranku >>> 31;
        int g5 = -rankv >>> 31;
        float x1 = x0 - (float)i1 + G6;
        float y1 = y0 - (float)j1 + G6;
        float z1 = z0 - (float)k1 + G6;
        float w1 = w0 - (float)l1 + G6;
        float u1 = u0 - (float)h1 + G6;
        float v1 = v0 - (float)g1 + G6;
        float x2 = x0 - (float)i2 + 2.0f * G6;
        float y2 = y0 - (float)j2 + 2.0f * G6;
        float z2 = z0 - (float)k2 + 2.0f * G6;
        float w2 = w0 - (float)l2 + 2.0f * G6;
        float u2 = u0 - (float)h2 + 2.0f * G6;
        float v2 = v0 - (float)g2 + 2.0f * G6;
        float x3 = x0 - (float)i3 + 3.0f * G6;
        float y3 = y0 - (float)j3 + 3.0f * G6;
        float z3 = z0 - (float)k3 + 3.0f * G6;
        float w3 = w0 - (float)l3 + 3.0f * G6;
        float u3 = u0 - (float)h3 + 3.0f * G6;
        float v3 = v0 - (float)g3 + 3.0f * G6;
        float x4 = x0 - (float)i4 + 4.0f * G6;
        float y4 = y0 - (float)j4 + 4.0f * G6;
        float z4 = z0 - (float)k4 + 4.0f * G6;
        float w4 = w0 - (float)l4 + 4.0f * G6;
        float u4 = u0 - (float)h4 + 4.0f * G6;
        float v4 = v0 - (float)g4 + 4.0f * G6;
        float x5 = x0 - (float)i5 + 5.0f * G6;
        float y5 = y0 - (float)j5 + 5.0f * G6;
        float z5 = z0 - (float)k5 + 5.0f * G6;
        float w5 = w0 - (float)l5 + 5.0f * G6;
        float u5 = u0 - (float)h5 + 5.0f * G6;
        float v5 = v0 - (float)g5 + 5.0f * G6;
        float x6 = x0 - 1.0f + 6.0f * G6;
        float y6 = y0 - 1.0f + 6.0f * G6;
        float z6 = z0 - 1.0f + 6.0f * G6;
        float w6 = w0 - 1.0f + 6.0f * G6;
        float u6 = u0 - 1.0f + 6.0f * G6;
        float v6 = v0 - 1.0f + 6.0f * G6;
        float n0 = 0.69f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0 - u0 * u0 - v0 * v0;
        if (n0 <= 0.0f) {
            n0 = 0.0f;
        } else {
            n0 *= n0;
            n0 *= n0 * this.gradCoord6D(seed, i, j, k, l, h, g, x0, y0, z0, w0, u0, v0);
        }
        float n1 = 0.69f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1 - u1 * u1 - v1 * v1;
        if (n1 <= 0.0f) {
            n1 = 0.0f;
        } else {
            n1 *= n1;
            n1 *= n1 * this.gradCoord6D(seed, i + i1, j + j1, k + k1, l + l1, h + h1, g + g1, x1, y1, z1, w1, u1, v1);
        }
        float n2 = 0.69f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2 - u2 * u2 - v2 * v2;
        if (n2 <= 0.0f) {
            n2 = 0.0f;
        } else {
            n2 *= n2;
            n2 *= n2 * this.gradCoord6D(seed, i + i2, j + j2, k + k2, l + l2, h + h2, g + g2, x2, y2, z2, w2, u2, v2);
        }
        float n3 = 0.69f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3 - u3 * u3 - v3 * v3;
        if (n3 <= 0.0f) {
            n3 = 0.0f;
        } else {
            n3 *= n3;
            n3 *= n3 * this.gradCoord6D(seed, i + i3, j + j3, k + k3, l + l3, h + h3, g + g3, x3, y3, z3, w3, u3, v3);
        }
        float n4 = 0.69f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4 - u4 * u4 - v4 * v4;
        if (n4 <= 0.0f) {
            n4 = 0.0f;
        } else {
            n4 *= n4;
            n4 *= n4 * this.gradCoord6D(seed, i + i4, j + j4, k + k4, l + l4, h + h4, g + g4, x4, y4, z4, w4, u4, v4);
        }
        float n5 = 0.69f - x5 * x5 - y5 * y5 - z5 * z5 - w5 * w5 - u5 * u5 - v5 * v5;
        if (n5 <= 0.0f) {
            n5 = 0.0f;
        } else {
            n5 *= n5;
            n5 *= n5 * this.gradCoord6D(seed, i + i5, j + j5, k + k5, l + l5, h + h5, g + g5, x5, y5, z5, w5, u5, v5);
        }
        float n6 = 0.69f - x6 * x6 - y6 * y6 - z6 * z6 - w6 * w6 - u6 * u6 - v6 * v6;
        if (n6 <= 0.0f) {
            n6 = 0.0f;
        } else {
            n6 *= n6;
            n6 *= n6 * this.gradCoord6D(seed, i + 1, j + 1, k + 1, l + 1, h + 1, g + 1, x6, y6, z6, w6, u6, v6);
        }
        float n = (n0 + n1 + n2 + n3 + n4 + n5 + n6) * 64.0f;
        return n / (0.5f + Math.abs(n));
    }

    public float getCubicFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleCubicFractalFBM(x, y);
            }
            case 1: {
                return this.singleCubicFractalBillow(x, y);
            }
            case 2: {
                return this.singleCubicFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    protected float singleCubicFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleCubic(seed, x, y);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleCubic(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singleCubic(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleCubic(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleCubic(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getCubic(float x, float y) {
        return this.singleCubic(0, x *= this.frequency, y *= this.frequency);
    }

    protected float singleCubic(int seed, float x, float y) {
        int x1 = MathTools.fastFloor((float)x);
        int y1 = MathTools.fastFloor((float)y);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        float xs = x - (float)x1;
        float ys = y - (float)y1;
        float e = this.sharpness * Noise.cubicLerp(Noise.cubicLerp(this.phCoord2D(seed, x0, y0), this.phCoord2D(seed, x1, y0), this.phCoord2D(seed, x2, y0), this.phCoord2D(seed, x3, y0), xs), Noise.cubicLerp(this.phCoord2D(seed, x0, y1), this.phCoord2D(seed, x1, y1), this.phCoord2D(seed, x2, y1), this.phCoord2D(seed, x3, y1), xs), Noise.cubicLerp(this.phCoord2D(seed, x0, y2), this.phCoord2D(seed, x1, y2), this.phCoord2D(seed, x2, y2), this.phCoord2D(seed, x3, y2), xs), Noise.cubicLerp(this.phCoord2D(seed, x0, y3), this.phCoord2D(seed, x1, y3), this.phCoord2D(seed, x2, y3), this.phCoord2D(seed, x3, y3), xs), ys);
        return e / (1.0f + Math.abs(e));
    }

    public float getCubicFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleCubicFractalFBM(x, y, z);
            }
            case 1: {
                return this.singleCubicFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleCubicFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    protected float singleCubicFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleCubic(seed, x, y, z);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleCubic(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleCubic(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleCubic(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleCubic(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getCubic(float x, float y, float z) {
        return this.singleCubic(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    protected float singleCubic(int seed, float x, float y, float z) {
        int x1 = MathTools.fastFloor((float)x);
        int y1 = MathTools.fastFloor((float)y);
        int z1 = MathTools.fastFloor((float)z);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int z0 = z1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        int z3 = z1 + 2;
        float xs = x - (float)x1;
        float ys = y - (float)y1;
        float zs = z - (float)z1;
        float e = this.sharpness * Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(this.phCoord3D(seed, x0, y0, z0), this.phCoord3D(seed, x1, y0, z0), this.phCoord3D(seed, x2, y0, z0), this.phCoord3D(seed, x3, y0, z0), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y1, z0), this.phCoord3D(seed, x1, y1, z0), this.phCoord3D(seed, x2, y1, z0), this.phCoord3D(seed, x3, y1, z0), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y2, z0), this.phCoord3D(seed, x1, y2, z0), this.phCoord3D(seed, x2, y2, z0), this.phCoord3D(seed, x3, y2, z0), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y3, z0), this.phCoord3D(seed, x1, y3, z0), this.phCoord3D(seed, x2, y3, z0), this.phCoord3D(seed, x3, y3, z0), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord3D(seed, x0, y0, z1), this.phCoord3D(seed, x1, y0, z1), this.phCoord3D(seed, x2, y0, z1), this.phCoord3D(seed, x3, y0, z1), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y1, z1), this.phCoord3D(seed, x1, y1, z1), this.phCoord3D(seed, x2, y1, z1), this.phCoord3D(seed, x3, y1, z1), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y2, z1), this.phCoord3D(seed, x1, y2, z1), this.phCoord3D(seed, x2, y2, z1), this.phCoord3D(seed, x3, y2, z1), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y3, z1), this.phCoord3D(seed, x1, y3, z1), this.phCoord3D(seed, x2, y3, z1), this.phCoord3D(seed, x3, y3, z1), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord3D(seed, x0, y0, z2), this.phCoord3D(seed, x1, y0, z2), this.phCoord3D(seed, x2, y0, z2), this.phCoord3D(seed, x3, y0, z2), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y1, z2), this.phCoord3D(seed, x1, y1, z2), this.phCoord3D(seed, x2, y1, z2), this.phCoord3D(seed, x3, y1, z2), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y2, z2), this.phCoord3D(seed, x1, y2, z2), this.phCoord3D(seed, x2, y2, z2), this.phCoord3D(seed, x3, y2, z2), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y3, z2), this.phCoord3D(seed, x1, y3, z2), this.phCoord3D(seed, x2, y3, z2), this.phCoord3D(seed, x3, y3, z2), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord3D(seed, x0, y0, z3), this.phCoord3D(seed, x1, y0, z3), this.phCoord3D(seed, x2, y0, z3), this.phCoord3D(seed, x3, y0, z3), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y1, z3), this.phCoord3D(seed, x1, y1, z3), this.phCoord3D(seed, x2, y1, z3), this.phCoord3D(seed, x3, y1, z3), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y2, z3), this.phCoord3D(seed, x1, y2, z3), this.phCoord3D(seed, x2, y2, z3), this.phCoord3D(seed, x3, y2, z3), xs), Noise.cubicLerp(this.phCoord3D(seed, x0, y3, z3), this.phCoord3D(seed, x1, y3, z3), this.phCoord3D(seed, x2, y3, z3), this.phCoord3D(seed, x3, y3, z3), xs), ys), zs);
        return e / (1.0f + Math.abs(e));
    }

    public float getCubicFractal(float x, float y, float z, float w) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleCubicFractalFBM(x, y, z, w);
            }
            case 1: {
                return this.singleCubicFractalBillow(x, y, z, w);
            }
            case 2: {
                return this.singleCubicFractalRidgedMulti(x, y, z, w);
            }
        }
        return 0.0f;
    }

    protected float singleCubicFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleCubic(seed, x, y, z, w);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleCubic(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleCubic(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleCubic(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        int i = 0;
        while (++i < this.octaves) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.singleCubic(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCubicFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleCubic(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getCubic(float x, float y, float z, float w) {
        return this.singleCubic(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    protected float singleCubic(int seed, float x, float y, float z, float w) {
        int x1 = MathTools.fastFloor((float)x);
        int y1 = MathTools.fastFloor((float)y);
        int z1 = MathTools.fastFloor((float)z);
        int w1 = MathTools.fastFloor((float)w);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int z0 = z1 - 1;
        int w0 = w1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        int w2 = w1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        int z3 = z1 + 2;
        int w3 = w1 + 2;
        float xs = x - (float)x1;
        float ys = y - (float)y1;
        float zs = z - (float)z1;
        float ws = w - (float)w1;
        float e = this.sharpness * Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z0, w0), this.phCoord4D(seed, x1, y0, z0, w0), this.phCoord4D(seed, x2, y0, z0, w0), this.phCoord4D(seed, x3, y0, z0, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z0, w0), this.phCoord4D(seed, x1, y1, z0, w0), this.phCoord4D(seed, x2, y1, z0, w0), this.phCoord4D(seed, x3, y1, z0, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z0, w0), this.phCoord4D(seed, x1, y2, z0, w0), this.phCoord4D(seed, x2, y2, z0, w0), this.phCoord4D(seed, x3, y2, z0, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z0, w0), this.phCoord4D(seed, x1, y3, z0, w0), this.phCoord4D(seed, x2, y3, z0, w0), this.phCoord4D(seed, x3, y3, z0, w0), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z1, w0), this.phCoord4D(seed, x1, y0, z1, w0), this.phCoord4D(seed, x2, y0, z1, w0), this.phCoord4D(seed, x3, y0, z1, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z1, w0), this.phCoord4D(seed, x1, y1, z1, w0), this.phCoord4D(seed, x2, y1, z1, w0), this.phCoord4D(seed, x3, y1, z1, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z1, w0), this.phCoord4D(seed, x1, y2, z1, w0), this.phCoord4D(seed, x2, y2, z1, w0), this.phCoord4D(seed, x3, y2, z1, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z1, w0), this.phCoord4D(seed, x1, y3, z1, w0), this.phCoord4D(seed, x2, y3, z1, w0), this.phCoord4D(seed, x3, y3, z1, w0), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z2, w0), this.phCoord4D(seed, x1, y0, z2, w0), this.phCoord4D(seed, x2, y0, z2, w0), this.phCoord4D(seed, x3, y0, z2, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z2, w0), this.phCoord4D(seed, x1, y1, z2, w0), this.phCoord4D(seed, x2, y1, z2, w0), this.phCoord4D(seed, x3, y1, z2, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z2, w0), this.phCoord4D(seed, x1, y2, z2, w0), this.phCoord4D(seed, x2, y2, z2, w0), this.phCoord4D(seed, x3, y2, z2, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z2, w0), this.phCoord4D(seed, x1, y3, z2, w0), this.phCoord4D(seed, x2, y3, z2, w0), this.phCoord4D(seed, x3, y3, z2, w0), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z3, w0), this.phCoord4D(seed, x1, y0, z3, w0), this.phCoord4D(seed, x2, y0, z3, w0), this.phCoord4D(seed, x3, y0, z3, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z3, w0), this.phCoord4D(seed, x1, y1, z3, w0), this.phCoord4D(seed, x2, y1, z3, w0), this.phCoord4D(seed, x3, y1, z3, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z3, w0), this.phCoord4D(seed, x1, y2, z3, w0), this.phCoord4D(seed, x2, y2, z3, w0), this.phCoord4D(seed, x3, y2, z3, w0), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z3, w0), this.phCoord4D(seed, x1, y3, z3, w0), this.phCoord4D(seed, x2, y3, z3, w0), this.phCoord4D(seed, x3, y3, z3, w0), xs), ys), zs), Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z0, w1), this.phCoord4D(seed, x1, y0, z0, w1), this.phCoord4D(seed, x2, y0, z0, w1), this.phCoord4D(seed, x3, y0, z0, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z0, w1), this.phCoord4D(seed, x1, y1, z0, w1), this.phCoord4D(seed, x2, y1, z0, w1), this.phCoord4D(seed, x3, y1, z0, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z0, w1), this.phCoord4D(seed, x1, y2, z0, w1), this.phCoord4D(seed, x2, y2, z0, w1), this.phCoord4D(seed, x3, y2, z0, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z0, w1), this.phCoord4D(seed, x1, y3, z0, w1), this.phCoord4D(seed, x2, y3, z0, w1), this.phCoord4D(seed, x3, y3, z0, w1), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z1, w1), this.phCoord4D(seed, x1, y0, z1, w1), this.phCoord4D(seed, x2, y0, z1, w1), this.phCoord4D(seed, x3, y0, z1, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z1, w1), this.phCoord4D(seed, x1, y1, z1, w1), this.phCoord4D(seed, x2, y1, z1, w1), this.phCoord4D(seed, x3, y1, z1, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z1, w1), this.phCoord4D(seed, x1, y2, z1, w1), this.phCoord4D(seed, x2, y2, z1, w1), this.phCoord4D(seed, x3, y2, z1, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z1, w1), this.phCoord4D(seed, x1, y3, z1, w1), this.phCoord4D(seed, x2, y3, z1, w1), this.phCoord4D(seed, x3, y3, z1, w1), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z2, w1), this.phCoord4D(seed, x1, y0, z2, w1), this.phCoord4D(seed, x2, y0, z2, w1), this.phCoord4D(seed, x3, y0, z2, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z2, w1), this.phCoord4D(seed, x1, y1, z2, w1), this.phCoord4D(seed, x2, y1, z2, w1), this.phCoord4D(seed, x3, y1, z2, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z2, w1), this.phCoord4D(seed, x1, y2, z2, w1), this.phCoord4D(seed, x2, y2, z2, w1), this.phCoord4D(seed, x3, y2, z2, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z2, w1), this.phCoord4D(seed, x1, y3, z2, w1), this.phCoord4D(seed, x2, y3, z2, w1), this.phCoord4D(seed, x3, y3, z2, w1), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z3, w1), this.phCoord4D(seed, x1, y0, z3, w1), this.phCoord4D(seed, x2, y0, z3, w1), this.phCoord4D(seed, x3, y0, z3, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z3, w1), this.phCoord4D(seed, x1, y1, z3, w1), this.phCoord4D(seed, x2, y1, z3, w1), this.phCoord4D(seed, x3, y1, z3, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z3, w1), this.phCoord4D(seed, x1, y2, z3, w1), this.phCoord4D(seed, x2, y2, z3, w1), this.phCoord4D(seed, x3, y2, z3, w1), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z3, w1), this.phCoord4D(seed, x1, y3, z3, w1), this.phCoord4D(seed, x2, y3, z3, w1), this.phCoord4D(seed, x3, y3, z3, w1), xs), ys), zs), Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z0, w2), this.phCoord4D(seed, x1, y0, z0, w2), this.phCoord4D(seed, x2, y0, z0, w2), this.phCoord4D(seed, x3, y0, z0, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z0, w2), this.phCoord4D(seed, x1, y1, z0, w2), this.phCoord4D(seed, x2, y1, z0, w2), this.phCoord4D(seed, x3, y1, z0, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z0, w2), this.phCoord4D(seed, x1, y2, z0, w2), this.phCoord4D(seed, x2, y2, z0, w2), this.phCoord4D(seed, x3, y2, z0, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z0, w2), this.phCoord4D(seed, x1, y3, z0, w2), this.phCoord4D(seed, x2, y3, z0, w2), this.phCoord4D(seed, x3, y3, z0, w2), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z1, w2), this.phCoord4D(seed, x1, y0, z1, w2), this.phCoord4D(seed, x2, y0, z1, w2), this.phCoord4D(seed, x3, y0, z1, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z1, w2), this.phCoord4D(seed, x1, y1, z1, w2), this.phCoord4D(seed, x2, y1, z1, w2), this.phCoord4D(seed, x3, y1, z1, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z1, w2), this.phCoord4D(seed, x1, y2, z1, w2), this.phCoord4D(seed, x2, y2, z1, w2), this.phCoord4D(seed, x3, y2, z1, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z1, w2), this.phCoord4D(seed, x1, y3, z1, w2), this.phCoord4D(seed, x2, y3, z1, w2), this.phCoord4D(seed, x3, y3, z1, w2), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z2, w2), this.phCoord4D(seed, x1, y0, z2, w2), this.phCoord4D(seed, x2, y0, z2, w2), this.phCoord4D(seed, x3, y0, z2, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z2, w2), this.phCoord4D(seed, x1, y1, z2, w2), this.phCoord4D(seed, x2, y1, z2, w2), this.phCoord4D(seed, x3, y1, z2, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z2, w2), this.phCoord4D(seed, x1, y2, z2, w2), this.phCoord4D(seed, x2, y2, z2, w2), this.phCoord4D(seed, x3, y2, z2, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z2, w2), this.phCoord4D(seed, x1, y3, z2, w2), this.phCoord4D(seed, x2, y3, z2, w2), this.phCoord4D(seed, x3, y3, z2, w2), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z3, w2), this.phCoord4D(seed, x1, y0, z3, w2), this.phCoord4D(seed, x2, y0, z3, w2), this.phCoord4D(seed, x3, y0, z3, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z3, w2), this.phCoord4D(seed, x1, y1, z3, w2), this.phCoord4D(seed, x2, y1, z3, w2), this.phCoord4D(seed, x3, y1, z3, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z3, w2), this.phCoord4D(seed, x1, y2, z3, w2), this.phCoord4D(seed, x2, y2, z3, w2), this.phCoord4D(seed, x3, y2, z3, w2), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z3, w2), this.phCoord4D(seed, x1, y3, z3, w2), this.phCoord4D(seed, x2, y3, z3, w2), this.phCoord4D(seed, x3, y3, z3, w2), xs), ys), zs), Noise.cubicLerp(Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z0, w3), this.phCoord4D(seed, x1, y0, z0, w3), this.phCoord4D(seed, x2, y0, z0, w3), this.phCoord4D(seed, x3, y0, z0, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z0, w3), this.phCoord4D(seed, x1, y1, z0, w3), this.phCoord4D(seed, x2, y1, z0, w3), this.phCoord4D(seed, x3, y1, z0, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z0, w3), this.phCoord4D(seed, x1, y2, z0, w3), this.phCoord4D(seed, x2, y2, z0, w3), this.phCoord4D(seed, x3, y2, z0, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z0, w3), this.phCoord4D(seed, x1, y3, z0, w3), this.phCoord4D(seed, x2, y3, z0, w3), this.phCoord4D(seed, x3, y3, z0, w3), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z1, w3), this.phCoord4D(seed, x1, y0, z1, w3), this.phCoord4D(seed, x2, y0, z1, w3), this.phCoord4D(seed, x3, y0, z1, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z1, w3), this.phCoord4D(seed, x1, y1, z1, w3), this.phCoord4D(seed, x2, y1, z1, w3), this.phCoord4D(seed, x3, y1, z1, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z1, w3), this.phCoord4D(seed, x1, y2, z1, w3), this.phCoord4D(seed, x2, y2, z1, w3), this.phCoord4D(seed, x3, y2, z1, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z1, w3), this.phCoord4D(seed, x1, y3, z1, w3), this.phCoord4D(seed, x2, y3, z1, w3), this.phCoord4D(seed, x3, y3, z1, w3), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z2, w3), this.phCoord4D(seed, x1, y0, z2, w3), this.phCoord4D(seed, x2, y0, z2, w3), this.phCoord4D(seed, x3, y0, z2, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z2, w3), this.phCoord4D(seed, x1, y1, z2, w3), this.phCoord4D(seed, x2, y1, z2, w3), this.phCoord4D(seed, x3, y1, z2, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z2, w3), this.phCoord4D(seed, x1, y2, z2, w3), this.phCoord4D(seed, x2, y2, z2, w3), this.phCoord4D(seed, x3, y2, z2, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z2, w3), this.phCoord4D(seed, x1, y3, z2, w3), this.phCoord4D(seed, x2, y3, z2, w3), this.phCoord4D(seed, x3, y3, z2, w3), xs), ys), Noise.cubicLerp(Noise.cubicLerp(this.phCoord4D(seed, x0, y0, z3, w3), this.phCoord4D(seed, x1, y0, z3, w3), this.phCoord4D(seed, x2, y0, z3, w3), this.phCoord4D(seed, x3, y0, z3, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y1, z3, w3), this.phCoord4D(seed, x1, y1, z3, w3), this.phCoord4D(seed, x2, y1, z3, w3), this.phCoord4D(seed, x3, y1, z3, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y2, z3, w3), this.phCoord4D(seed, x1, y2, z3, w3), this.phCoord4D(seed, x2, y2, z3, w3), this.phCoord4D(seed, x3, y2, z3, w3), xs), Noise.cubicLerp(this.phCoord4D(seed, x0, y3, z3, w3), this.phCoord4D(seed, x1, y3, z3, w3), this.phCoord4D(seed, x2, y3, z3, w3), this.phCoord4D(seed, x3, y3, z3, w3), xs), ys), zs), ws);
        return e / (1.0f + Math.abs(e));
    }

    public float getCellular(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.cellularReturnType) {
            case 0: 
            case 1: 
            case 2: {
                return this.singleCellular(this.seed, x, y);
            }
            case 8: {
                return this.singleCellularMerging(this.seed, x, y);
            }
        }
        return this.singleCellular2Edge(this.seed, x, y);
    }

    public float switchCellular(int seed, float x, float y) {
        switch (this.cellularReturnType) {
            case 0: 
            case 1: 
            case 2: {
                return this.singleCellular(seed, x, y);
            }
            case 8: {
                return this.singleCellularMerging(seed, x, y);
            }
        }
        return this.singleCellular2Edge(seed, x, y);
    }

    protected float singleCellular(int seed, float x, float y) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        float distance = 999999.0f;
        int xc = 0;
        int yc = 0;
        switch (this.cellularDistanceFunction) {
            default: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = vecX * vecX + vecY * vecY;
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
                break;
            }
            case 1: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY);
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
                break;
            }
            case 2: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY) + (vecX * vecX + vecY * vecY);
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
                distance /= 1.7071068f;
            }
        }
        switch (this.cellularReturnType) {
            case 0: {
                return this.valCoord2D(0, xc, yc);
            }
            case 1: {
                Float2 vec = CELL_2D[IntPointHash.hash256(xc, yc, seed)];
                return this.layered2D((float)xc + vec.x, (float)yc + vec.y, 123, 3);
            }
            case 2: {
                return distance - 1.0f;
            }
        }
        return 0.0f;
    }

    protected float singleCellularMerging(int seed, float x, float y) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        float sum = 0.0f;
        switch (this.cellularDistanceFunction) {
            case 0: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        int hash = IntPointHash.hashAll(xi, yi, seed);
                        Float2 vec = CELL_2D[hash & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float distance = 1.0f - (vecX * vecX + vecY * vecY);
                        if (!(distance > 0.0f)) continue;
                        sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance;
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        int hash = IntPointHash.hashAll(xi, yi, seed);
                        Float2 vec = CELL_2D[hash & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float distance = 1.0f - (Math.abs(vecX) + Math.abs(vecY));
                        if (!(distance > 0.0f)) continue;
                        sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance;
                    }
                }
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        int hash = IntPointHash.hashAll(xi, yi, seed);
                        Float2 vec = CELL_2D[hash & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float distance = 2.0f - (Math.abs(vecX) + Math.abs(vecY) + (vecX * vecX + vecY * vecY));
                        if (!(distance > 0.0f)) continue;
                        sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance * 0.125f;
                    }
                }
                break;
            }
        }
        return sum / (64.0f + Math.abs(sum));
    }

    protected float singleCellular2Edge(int seed, float x, float y) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        float distance = 999999.0f;
        float distance2 = 999999.0f;
        switch (this.cellularDistanceFunction) {
            default: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = vecX * vecX + vecY * vecY;
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY);
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[IntPointHash.hash256(xi, yi, seed)];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY) + (vecX * vecX + vecY * vecY);
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
                distance2 /= 1.7071068f;
                distance /= 1.7071068f;
            }
        }
        switch (this.cellularReturnType) {
            case 3: {
                return distance2 - 1.0f;
            }
            case 4: {
                return Math.min(Math.max(distance2 + distance - 1.0f, -1.0f), 1.0f);
            }
            case 5: {
                return Math.min(Math.max(distance2 - distance - 1.0f, -1.0f), 1.0f);
            }
            case 6: {
                return Math.min(Math.max(distance2 * distance - 1.0f, -1.0f), 1.0f);
            }
            case 7: {
                return Math.min(Math.max(distance / distance2 - 1.0f, -1.0f), 1.0f);
            }
        }
        return 0.0f;
    }

    protected float singleCellularFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.switchCellular(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.switchCellular(seed + i, x *= this.lacunarity, y *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.switchCellular(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.switchCellular(++seed, (x *= this.lacunarity) + a, (y *= this.lacunarity) + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.switchCellular(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.switchCellular(++seed, x *= this.lacunarity, y *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.switchCellular(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getCellular(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.cellularReturnType) {
            case 0: 
            case 1: 
            case 2: {
                return this.singleCellular(this.seed, x, y, z);
            }
            case 8: {
                return this.singleCellularMerging(this.seed, x, y, z);
            }
        }
        return this.singleCellular2Edge(this.seed, x, y, z);
    }

    protected float switchCellular(int seed, float x, float y, float z) {
        switch (this.cellularReturnType) {
            case 0: 
            case 1: 
            case 2: {
                return this.singleCellular(seed, x, y, z);
            }
            case 8: {
                return this.singleCellularMerging(seed, x, y, z);
            }
        }
        return this.singleCellular2Edge(seed, x, y, z);
    }

    protected float singleCellular(int seed, float x, float y, float z) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        int zr = Noise.fastRound(z);
        float distance = 999999.0f;
        int xc = 0;
        int yc = 0;
        int zc = 0;
        switch (this.cellularDistanceFunction) {
            case 0: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = vecX * vecX + vecY * vecY + vecZ * vecZ;
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                break;
            }
            case 1: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ);
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                distance /= 1.5f;
                break;
            }
            case 2: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ) + (vecX * vecX + vecY * vecY + vecZ * vecZ);
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                distance *= 0.5f;
            }
        }
        switch (this.cellularReturnType) {
            case 0: {
                return this.valCoord3D(seed, xc, yc, zc);
            }
            case 1: {
                Float3 vec = CELL_3D[IntPointHash.hash256(xc, yc, zc, seed)];
                return this.layered3D((float)xc + vec.x, (float)yc + vec.y, (float)zc + vec.z, 123, 3);
            }
            case 2: {
                return distance - 1.0f;
            }
        }
        return 0.0f;
    }

    protected float singleCellularMerging(int seed, float x, float y, float z) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        int zr = Noise.fastRound(z);
        float sum = 0.0f;
        switch (this.cellularDistanceFunction) {
            case 0: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            int hash = IntPointHash.hashAll(xi, yi, zi, seed);
                            Float3 vec = CELL_3D[hash & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float distance = 1.0f - (vecX * vecX + vecY * vecY + vecZ * vecZ);
                            if (!(distance > 0.0f)) continue;
                            sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            int hash = IntPointHash.hashAll(xi, yi, zi, seed);
                            Float3 vec = CELL_3D[hash & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float distance = 1.0f - (Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ));
                            if (!(distance > 0.0f)) continue;
                            sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            int hash = IntPointHash.hashAll(xi, yi, zi, seed);
                            Float3 vec = CELL_3D[hash & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float distance = 2.0f - (Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ) + (vecX * vecX + vecY * vecY + vecZ * vecZ));
                            if (!(distance > 0.0f)) continue;
                            sum += (float)((hash >>> 28) - (hash >>> 24 & 0xF)) * (distance *= 3.0f) * distance * distance * 0.125f;
                        }
                    }
                }
                break;
            }
        }
        return sum / (64.0f + Math.abs(sum));
    }

    protected float singleCellular2Edge(int seed, float x, float y, float z) {
        int xr = Noise.fastRound(x);
        int yr = Noise.fastRound(y);
        int zr = Noise.fastRound(z);
        float distance = 999999.0f;
        float distance2 = 999999.0f;
        switch (this.cellularDistanceFunction) {
            case 0: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = vecX * vecX + vecY * vecY + vecZ * vecZ;
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ);
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                distance /= 1.5f;
                distance2 /= 1.5f;
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[IntPointHash.hash256(xi, yi, zi, seed)];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ) + (vecX * vecX + vecY * vecY + vecZ * vecZ);
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                distance *= 0.5f;
                distance2 *= 0.5f;
                break;
            }
        }
        switch (this.cellularReturnType) {
            case 3: {
                return distance2 - 1.0f;
            }
            case 4: {
                return Math.min(Math.max(distance2 + distance - 1.0f, -1.0f), 1.0f);
            }
            case 5: {
                return Math.min(Math.max(distance2 - distance - 1.0f, -1.0f), 1.0f);
            }
            case 6: {
                return Math.min(Math.max(distance2 * distance - 1.0f, -1.0f), 1.0f);
            }
            case 7: {
                return Math.min(Math.max(distance / distance2 - 1.0f, -1.0f), 1.0f);
            }
        }
        return 0.0f;
    }

    protected float singleCellularFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.switchCellular(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.switchCellular(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.switchCellular(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.switchCellular(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.switchCellular(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.switchCellular(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleCellularFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.switchCellular(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public void gradientPerturb3(float[] v3) {
        this.singleGradientPerturb3(this.seed, this.gradientPerturbAmp, this.frequency, v3);
    }

    public void gradientPerturbFractal3(float[] v3) {
        int seed = this.seed;
        float amp = this.gradientPerturbAmp * this.fractalBounding;
        float freq = this.frequency;
        this.singleGradientPerturb3(seed, amp, this.frequency, v3);
        for (int i = 1; i < this.octaves; ++i) {
            this.singleGradientPerturb3(++seed, amp *= this.gain, freq *= this.lacunarity, v3);
        }
    }

    private void singleGradientPerturb3(int seed, float perturbAmp, float frequency, float[] v3) {
        float zs;
        float ys;
        float xs;
        float xf = v3[0] * frequency;
        float yf = v3[1] * frequency;
        float zf = v3[2] * frequency;
        int x0 = MathTools.fastFloor((float)xf);
        int y0 = MathTools.fastFloor((float)yf);
        int z0 = MathTools.fastFloor((float)zf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        switch (this.interpolation) {
            default: {
                xs = xf - (float)x0;
                ys = yf - (float)y0;
                zs = zf - (float)z0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(xf - (float)x0);
                ys = Noise.hermiteInterpolator(yf - (float)y0);
                zs = Noise.hermiteInterpolator(zf - (float)z0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(xf - (float)x0);
                ys = Noise.quinticInterpolator(yf - (float)y0);
                zs = Noise.quinticInterpolator(zf - (float)z0);
            }
        }
        Float3 vec0 = CELL_3D[IntPointHash.hash256(x0, y0, z0, seed)];
        Float3 vec1 = CELL_3D[IntPointHash.hash256(x1, y0, z0, seed)];
        float lx0x = Noise.lerp(vec0.x, vec1.x, xs);
        float ly0x = Noise.lerp(vec0.y, vec1.y, xs);
        float lz0x = Noise.lerp(vec0.z, vec1.z, xs);
        vec0 = CELL_3D[IntPointHash.hash256(x0, y1, z0, seed)];
        vec1 = CELL_3D[IntPointHash.hash256(x1, y1, z0, seed)];
        float lx1x = Noise.lerp(vec0.x, vec1.x, xs);
        float ly1x = Noise.lerp(vec0.y, vec1.y, xs);
        float lz1x = Noise.lerp(vec0.z, vec1.z, xs);
        float lx0y = Noise.lerp(lx0x, lx1x, ys);
        float ly0y = Noise.lerp(ly0x, ly1x, ys);
        float lz0y = Noise.lerp(lz0x, lz1x, ys);
        vec0 = CELL_3D[IntPointHash.hash256(x0, y0, z1, seed)];
        vec1 = CELL_3D[IntPointHash.hash256(x1, y0, z1, seed)];
        lx0x = Noise.lerp(vec0.x, vec1.x, xs);
        ly0x = Noise.lerp(vec0.y, vec1.y, xs);
        lz0x = Noise.lerp(vec0.z, vec1.z, xs);
        vec0 = CELL_3D[IntPointHash.hash256(x0, y1, z1, seed)];
        vec1 = CELL_3D[IntPointHash.hash256(x1, y1, z1, seed)];
        lx1x = Noise.lerp(vec0.x, vec1.x, xs);
        ly1x = Noise.lerp(vec0.y, vec1.y, xs);
        lz1x = Noise.lerp(vec0.z, vec1.z, xs);
        v3[0] = v3[0] + Noise.lerp(lx0y, Noise.lerp(lx0x, lx1x, ys), zs) * perturbAmp;
        v3[1] = v3[1] + Noise.lerp(ly0y, Noise.lerp(ly0x, ly1x, ys), zs) * perturbAmp;
        v3[2] = v3[2] + Noise.lerp(lz0y, Noise.lerp(lz0x, lz1x, ys), zs) * perturbAmp;
    }

    public void gradientPerturb2(float[] v2) {
        this.singleGradientPerturb2(this.seed, this.gradientPerturbAmp, this.frequency, v2);
    }

    public void gradientPerturbFractal2(float[] v2) {
        int seed = this.seed;
        float amp = this.gradientPerturbAmp * this.fractalBounding;
        float freq = this.frequency;
        this.singleGradientPerturb2(seed, amp, this.frequency, v2);
        for (int i = 1; i < this.octaves; ++i) {
            this.singleGradientPerturb2(++seed, amp *= this.gain, freq *= this.lacunarity, v2);
        }
    }

    private void singleGradientPerturb2(int seed, float perturbAmp, float frequency, float[] v2) {
        float ys;
        float xs;
        float xf = v2[0] * frequency;
        float yf = v2[1] * frequency;
        int x0 = MathTools.fastFloor((float)xf);
        int y0 = MathTools.fastFloor((float)yf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        switch (this.interpolation) {
            default: {
                xs = xf - (float)x0;
                ys = yf - (float)y0;
                break;
            }
            case 1: {
                xs = Noise.hermiteInterpolator(xf - (float)x0);
                ys = Noise.hermiteInterpolator(yf - (float)y0);
                break;
            }
            case 2: {
                xs = Noise.quinticInterpolator(xf - (float)x0);
                ys = Noise.quinticInterpolator(yf - (float)y0);
            }
        }
        Float2 vec0 = CELL_2D[IntPointHash.hash256(x0, y0, seed)];
        Float2 vec1 = CELL_2D[IntPointHash.hash256(x1, y0, seed)];
        float lx0x = Noise.lerp(vec0.x, vec1.x, xs);
        float ly0x = Noise.lerp(vec0.y, vec1.y, xs);
        vec0 = CELL_2D[IntPointHash.hash256(x0, y1, seed)];
        vec1 = CELL_2D[IntPointHash.hash256(x1, y1, seed)];
        float lx1x = Noise.lerp(vec0.x, vec1.x, xs);
        float ly1x = Noise.lerp(vec0.y, vec1.y, xs);
        v2[0] = v2[0] + Noise.lerp(lx0x, lx1x, ys) * perturbAmp;
        v2[1] = v2[1] + Noise.lerp(ly0x, ly1x, ys) * perturbAmp;
    }

    public float getHoney(float x, float y) {
        return this.singleHoney(this.seed, x * this.frequency, y * this.frequency);
    }

    public float singleHoney(int seed, float x, float y) {
        float result = (this.singleSimplex(seed, x, y) + this.singleValue(seed ^ 0x9E3779B9, x, y)) * 0.5f + 1.0f;
        return result <= 1.0f ? result * result - 1.0f : (result - 2.0f) * -(result - 2.0f) + 1.0f;
    }

    public float getHoneyFractal(float x, float y) {
        x *= this.frequency;
        y *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleHoneyFractalFBM(x, y);
            }
            case 1: {
                return this.singleHoneyFractalBillow(x, y);
            }
            case 2: {
                return this.singleHoneyFractalRidgedMulti(x, y);
            }
        }
        return 0.0f;
    }

    protected float singleHoneyFractalFBM(float x, float y) {
        int seed = this.seed;
        float sum = this.singleHoney(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += this.singleHoney(seed + i, x, y) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalDomainWarp(float x, float y) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleHoney(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.singleHoney(++seed, x + a, y + b);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalBillow(float x, float y) {
        int seed = this.seed;
        float sum = Math.abs(this.singleHoney(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
            sum += (Math.abs(this.singleHoney(++seed, x, y)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalRidgedMulti(float x, float y) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleHoney(seed + i, x, y));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            float t = x;
            x = y * this.lacunarity;
            y = t * this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getHoneyFractal(float x, float y, float z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleHoneyFractalFBM(x, y, z);
            }
            case 1: {
                return this.singleHoneyFractalBillow(x, y, z);
            }
            case 2: {
                return this.singleHoneyFractalRidgedMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    protected float singleHoneyFractalFBM(float x, float y, float z) {
        int seed = this.seed;
        float sum = this.singleHoney(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalDomainWarp(float x, float y, float z) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleHoney(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.singleHoney(++seed, x + a, y + b, (z *= this.lacunarity) + c);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalBillow(float x, float y, float z) {
        int seed = this.seed;
        float sum = Math.abs(this.singleHoney(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalRidgedMulti(float x, float y, float z) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleHoney(seed + i, x, y, z));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getHoney(float x, float y, float z) {
        return this.singleHoney(this.seed, x * this.frequency, y * this.frequency, z * this.frequency);
    }

    public float singleHoney(int seed, float x, float y, float z) {
        float result = (this.singleSimplex(seed, x, y, z) + this.singleValue(seed ^ 0x9E3779B9, x, y, z)) * 0.5f + 1.0f;
        return result <= 1.0f ? result * result - 1.0f : (result - 2.0f) * -(result - 2.0f) + 1.0f;
    }

    protected float singleHoneyFractalFBM(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = this.singleHoney(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalDomainWarp(float x, float y, float z, float w) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleHoney(seed, x, y, z, w);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.singleHoney(++seed, x + a, y + b, z + c, w + d);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalBillow(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = Math.abs(this.singleHoney(seed, x, y, z, w)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalRidgedMulti(float x, float y, float z, float w) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleHoney(seed + i, x, y, z, w));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getHoney(float x, float y, float z, float w) {
        return this.singleHoney(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency);
    }

    public float singleHoney(int seed, float x, float y, float z, float w) {
        float result = (this.singleSimplex(seed, x, y, z, w) + this.singleValue(seed ^ 0x9E3779B9, x, y, z, w)) * 0.5f + 1.0f;
        return result <= 1.0f ? result * result - 1.0f : (result - 2.0f) * -(result - 2.0f) + 1.0f;
    }

    public float getHoneyFractal(float x, float y, float z, float w, float u) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleHoneyFractalFBM(x, y, z, w, u);
            }
            case 1: {
                return this.singleHoneyFractalBillow(x, y, z, w, u);
            }
            case 2: {
                return this.singleHoneyFractalRidgedMulti(x, y, z, w, u);
            }
        }
        return 0.0f;
    }

    protected float singleHoneyFractalFBM(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = this.singleHoney(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += this.singleHoney(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalDomainWarp(float x, float y, float z, float w, float u) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleHoney(seed, x, y, z, w, u);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.singleHoney(++seed, x + a, y + b, z + c, w + d, u + e);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalBillow(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = Math.abs(this.singleHoney(seed, x, y, z, w, u)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += (Math.abs(this.singleHoney(seed + i, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalRidgedMulti(float x, float y, float z, float w, float u) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleHoney(seed + i, x, y, z, w, u));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getHoney(float x, float y, float z, float w, float u) {
        return this.singleHoney(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency);
    }

    public float singleHoney(int seed, float x, float y, float z, float w, float u) {
        float result = (this.singleSimplex(seed, x, y, z, w, u) + this.singleValue(seed ^ 0x9E3779B9, x, y, z, w, u)) * 0.5f + 1.0f;
        return result <= 1.0f ? result * result - 1.0f : (result - 2.0f) * -(result - 2.0f) + 1.0f;
    }

    public float getHoneyFractal(float x, float y, float z, float w, float u, float v) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        w *= this.frequency;
        u *= this.frequency;
        v *= this.frequency;
        switch (this.fractalType) {
            case 0: {
                return this.singleHoneyFractalFBM(x, y, z, w, u, v);
            }
            case 1: {
                return this.singleHoneyFractalBillow(x, y, z, w, u, v);
            }
            case 2: {
                return this.singleHoneyFractalRidgedMulti(x, y, z, w, u, v);
            }
        }
        return 0.0f;
    }

    protected float singleHoneyFractalFBM(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = this.singleHoney(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalDomainWarp(float x, float y, float z, float w, float u, float v) {
        float latest;
        int seed = this.seed;
        float sum = latest = this.singleHoney(seed, x, y, z, w, u, v);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.singleHoney(++seed, x + a, y + b, z + c, w + d, u + e, v + f);
            sum += latest * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalBillow(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = Math.abs(this.singleHoney(seed, x, y, z, w, u, v)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += (Math.abs(this.singleHoney(++seed, x *= this.lacunarity, y *= this.lacunarity, z *= this.lacunarity, w *= this.lacunarity, u *= this.lacunarity, v *= this.lacunarity)) * 2.0f - 1.0f) * (amp *= this.gain);
        }
        return sum * this.fractalBounding;
    }

    protected float singleHoneyFractalRidgedMulti(float x, float y, float z, float w, float u, float v) {
        int seed = this.seed;
        float sum = 0.0f;
        float exp = 2.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.singleHoney(seed + i, x, y, z, w, u, v));
            correction += (exp *= 0.5f);
            sum += spike * exp;
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            w *= this.lacunarity;
            u *= this.lacunarity;
            v *= this.lacunarity;
        }
        return sum * 2.0f / correction - 1.0f;
    }

    public float getHoney(float x, float y, float z, float w, float u, float v) {
        return this.singleHoney(this.seed, x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency);
    }

    public float singleHoney(int seed, float x, float y, float z, float w, float u, float v) {
        float result = (this.singleSimplex(seed, x, y, z, w, u, v) + this.singleValue(seed ^ 0x9E3779B9, x, y, z, w, u, v)) * 0.5f + 1.0f;
        return result <= 1.0f ? result * result - 1.0f : (result - 2.0f) * -(result - 2.0f) + 1.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Noise noise = (Noise)o;
        if (this.seed != noise.seed) {
            return false;
        }
        if (Float.compare(noise.frequency, this.frequency) != 0) {
            return false;
        }
        if (this.interpolation != noise.interpolation) {
            return false;
        }
        if (this.noiseType != noise.noiseType) {
            return false;
        }
        if (this.octaves != noise.octaves) {
            return false;
        }
        if (Float.compare(noise.lacunarity, this.lacunarity) != 0) {
            return false;
        }
        if (Float.compare(noise.gain, this.gain) != 0) {
            return false;
        }
        if (this.fractalType != noise.fractalType) {
            return false;
        }
        if (this.cellularDistanceFunction != noise.cellularDistanceFunction) {
            return false;
        }
        if (this.cellularReturnType != noise.cellularReturnType) {
            return false;
        }
        if (Float.compare(noise.gradientPerturbAmp, this.gradientPerturbAmp) != 0) {
            return false;
        }
        if (Float.compare(noise.sharpness, this.sharpness) != 0) {
            return false;
        }
        return Float.compare(noise.mutation, this.mutation) == 0;
    }

    public String toString() {
        return "Noise{seed=" + this.seed + ", frequency=" + this.frequency + ", interpolation=" + this.interpolation + ", noiseType=" + this.noiseType + ", octaves=" + this.octaves + ", lacunarity=" + this.lacunarity + ", gain=" + this.gain + ", fractalType=" + this.fractalType + ", cellularDistanceFunction=" + this.cellularDistanceFunction + ", cellularReturnType=" + this.cellularReturnType + ", gradientPerturbAmp=" + this.gradientPerturbAmp + ", sharpness=" + this.sharpness + ", mutation=" + this.mutation + ", fractalSpiral=" + this.fractalSpiral + '}';
    }

    public static class Float2 {
        public final float x;
        public final float y;

        public Float2(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Float3 {
        public final float x;
        public final float y;
        public final float z;

        public Float3(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

