/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.yellowstonegames.core.Interpolations;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.SimplexNoise;

public class NoiseAdjustment
implements INoise {
    public INoise wrapped;
    public Interpolations.Interpolator adjustment;

    public NoiseAdjustment() {
        this(new SimplexNoise(123L), Interpolations.smooth);
    }

    public NoiseAdjustment(INoise toWrap, Interpolations.Interpolator adjust) {
        this.wrapped = toWrap;
        this.adjustment = adjust;
    }

    public NoiseAdjustment(NoiseAdjustment other) {
        this.wrapped = other.getWrapped().copy();
        this.adjustment = other.getAdjustment();
    }

    public INoise getWrapped() {
        return this.wrapped;
    }

    public NoiseAdjustment setWrapped(INoise wrapped) {
        this.wrapped = wrapped;
        return this;
    }

    public Interpolations.Interpolator getAdjustment() {
        return this.adjustment;
    }

    public NoiseAdjustment setAdjustment(Interpolations.Interpolator adjustment) {
        this.adjustment = adjustment;
        return this;
    }

    @Override
    public int getMinDimension() {
        return this.wrapped.getMinDimension();
    }

    @Override
    public int getMaxDimension() {
        return this.wrapped.getMaxDimension();
    }

    @Override
    public boolean canUseSeed() {
        return this.wrapped.canUseSeed();
    }

    @Override
    public NoiseAdjustment copy() {
        return new NoiseAdjustment(this.wrapped.copy(), this.adjustment);
    }

    @Override
    public float getNoise(float x, float y) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoise(x, y)));
    }

    @Override
    public float getNoise(float x, float y, float z) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoise(x, y, z)));
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoise(x, y, z, w)));
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoise(x, y, z, w, u)));
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoise(x, y, z, w, u, v)));
    }

    @Override
    public void setSeed(long seed) {
        this.wrapped.setSeed(seed);
    }

    @Override
    public long getSeed() {
        return this.wrapped.getSeed();
    }

    @Override
    public float getNoiseWithSeed(float x, float y, long seed) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoiseWithSeed(x, y, seed)));
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, long seed) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoiseWithSeed(x, y, z, seed)));
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoiseWithSeed(x, y, z, w, seed)));
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoiseWithSeed(x, y, z, w, u, seed)));
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        return 2.0f * (-0.5f + this.adjustment.apply(0.5f + 0.5f * this.wrapped.getNoiseWithSeed(x, y, z, w, u, v, seed)));
    }

    @Override
    public String getTag() {
        return "NAdj";
    }

    @Override
    public String serializeToString() {
        return "`" + INoise.Serializer.serialize(this.wrapped) + '~' + this.adjustment.getTag() + "`";
    }

    @Override
    public NoiseAdjustment deserializeFromString(String data) {
        int pos = data.indexOf(96, data.indexOf(96, 2) + 1) + 1;
        this.setWrapped(INoise.Serializer.deserialize(data.substring(1, pos)));
        this.setAdjustment(Interpolations.get((String)data.substring(pos + 1, data.indexOf(96, pos + 2))));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoiseAdjustment that = (NoiseAdjustment)o;
        if (!this.wrapped.equals(that.wrapped)) {
            return false;
        }
        return this.adjustment.equals((Object)that.adjustment);
    }

    public int hashCode() {
        int result = this.wrapped.hashCode();
        result = 31 * result + this.adjustment.hashCode();
        return result;
    }
}

