/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.Noise;
import com.github.yellowstonegames.grid.SimplexNoise;

public class NoiseWrapper
implements INoise {
    public INoise wrapped;
    protected long seed;
    public float frequency;
    public int mode;
    protected int octaves;
    public boolean fractalSpiral = false;

    public NoiseWrapper() {
        this(new SimplexNoise(123L), 123L, 0.03125f, 0, 1, false);
    }

    public NoiseWrapper(INoise toWrap) {
        this(toWrap, toWrap.canUseSeed() ? toWrap.getSeed() : 123L, 0.03125f, 0, 1, false);
    }

    public NoiseWrapper(INoise toWrap, float frequency, int mode, int octaves) {
        this(toWrap, toWrap.canUseSeed() ? toWrap.getSeed() : 123L, frequency, mode, octaves, false);
    }

    public NoiseWrapper(INoise toWrap, long seed, float frequency, int mode, int octaves) {
        this(toWrap, seed, frequency, mode, octaves, false);
    }

    public NoiseWrapper(INoise toWrap, long seed, float frequency, int mode, int octaves, boolean fractalSpiral) {
        this.wrapped = toWrap;
        this.setSeed(seed);
        this.frequency = frequency;
        this.mode = mode;
        this.octaves = octaves;
        this.fractalSpiral = fractalSpiral;
    }

    public NoiseWrapper(NoiseWrapper other) {
        this.setWrapped(other.getWrapped().copy());
        this.setSeed(other.getSeed());
        this.setFrequency(other.getFrequency());
        this.setFractalType(other.getFractalType());
        this.setFractalOctaves(other.getFractalOctaves());
        this.setFractalSpiral(other.isFractalSpiral());
    }

    public INoise getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(INoise wrapped) {
        this.wrapped = wrapped;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public int getMode() {
        return this.getFractalType();
    }

    public void setMode(int mode) {
        this.setFractalType(mode);
    }

    public int getFractalType() {
        return this.mode;
    }

    public void setFractalType(int mode) {
        this.mode = mode;
    }

    public int getOctaves() {
        return this.getFractalOctaves();
    }

    public void setOctaves(int octaves) {
        this.setFractalOctaves(octaves);
    }

    public int getFractalOctaves() {
        return this.octaves;
    }

    public void setFractalOctaves(int octaves) {
        this.octaves = Math.max(1, octaves);
    }

    public boolean isFractalSpiral() {
        return this.fractalSpiral;
    }

    public void setFractalSpiral(boolean fractalSpiral) {
        this.fractalSpiral = fractalSpiral;
    }

    @Override
    public int getMinDimension() {
        return this.wrapped.getMinDimension();
    }

    @Override
    public int getMaxDimension() {
        return this.wrapped.getMaxDimension();
    }

    @Override
    public boolean canUseSeed() {
        return this.wrapped.canUseSeed();
    }

    @Override
    public String getTag() {
        return "WraN";
    }

    @Override
    public String serializeToString() {
        return "`" + INoise.Serializer.serialize(this.wrapped) + '~' + this.seed + '~' + this.frequency + '~' + this.mode + '~' + this.octaves + '~' + (this.fractalSpiral ? (char)'1' : '0') + '`';
    }

    @Override
    public NoiseWrapper deserializeFromString(String data) {
        int pos = data.indexOf(96, data.indexOf(96, 2) + 1) + 1;
        this.setWrapped(INoise.Serializer.deserialize(data.substring(1, pos)));
        int n = pos + 1;
        pos = data.indexOf(126, pos + 2);
        this.setSeed(Base.BASE10.readLong((CharSequence)data, n, pos));
        int n2 = pos + 1;
        pos = data.indexOf(126, pos + 2);
        this.setFrequency(Float.parseFloat(data.substring(n2, pos)));
        int n3 = pos + 1;
        pos = data.indexOf(126, pos + 2);
        this.setMode(Base.BASE10.readInt((CharSequence)data, n3, pos));
        int n4 = pos + 1;
        pos = data.indexOf(126, pos + 2);
        this.setOctaves(Base.BASE10.readInt((CharSequence)data, n4, pos));
        this.setFractalSpiral(data.charAt(pos + 1) == '1');
        return this;
    }

    @Override
    public NoiseWrapper copy() {
        return new NoiseWrapper(this);
    }

    public String toString() {
        return "NoiseWrapper{wrapped=" + this.wrapped + ", seed=" + this.seed + ", frequency=" + this.frequency + ", mode=" + this.mode + ", octaves=" + this.octaves + ", fractalSpiral=" + this.fractalSpiral + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoiseWrapper that = (NoiseWrapper)o;
        if (this.seed != that.seed) {
            return false;
        }
        if (Float.compare(that.frequency, this.frequency) != 0) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        if (this.octaves != that.octaves) {
            return false;
        }
        if (this.fractalSpiral != that.fractalSpiral) {
            return false;
        }
        return this.wrapped.equals(that.wrapped);
    }

    public int hashCode() {
        int result = this.wrapped.hashCode();
        result = 31 * result + (int)(this.seed ^ this.seed >>> 32);
        result = 31 * result + (this.frequency != 0.0f ? Float.floatToIntBits(this.frequency) : 0);
        result = 31 * result + this.mode;
        result = 31 * result + this.octaves;
        result = 31 * result + (this.fractalSpiral ? 1 : 0);
        return result;
    }

    @Override
    public float getNoise(float x, float y) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, this.seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, this.seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, this.seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, this.seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, this.seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, this.seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, this.seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, this.seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, this.seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, this.seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, this.seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, this.seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, this.seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, this.seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, this.seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, this.seed);
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        if (this.wrapped.canUseSeed()) {
            this.wrapped.setSeed(seed);
        }
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, long seed) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, long seed) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        switch (this.mode) {
            default: {
                return this.fbm(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, seed);
            }
            case 1: {
                return this.billow(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, seed);
            }
            case 2: {
                return this.ridged(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, seed);
            }
            case 3: 
        }
        return this.warp(x * this.frequency, y * this.frequency, z * this.frequency, w * this.frequency, u * this.frequency, v * this.frequency, seed);
    }

    protected float fbm(float x, float y, long seed) {
        float sum = this.wrapped.getNoiseWithSeed(x, y, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, seed + (long)i) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float billow(float x, float y, long seed) {
        float sum = Math.abs(this.wrapped.getNoiseWithSeed(x, y, seed)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            sum += (Math.abs(this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, seed + (long)i)) * 2.0f - 1.0f) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float ridged(float x, float y, long seed) {
        float sum = 0.0f;
        float exp = 1.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.wrapped.getNoiseWithSeed(x, y, seed + (long)i));
            sum += spike * exp;
            correction += (exp *= 0.5f);
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            x *= 2.0f;
            y *= 2.0f;
        }
        return sum / correction - 1.0f;
    }

    protected float warp(float x, float y, long seed) {
        float latest;
        float sum = latest = this.wrapped.getNoiseWithSeed(x, y, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX2D(x, y);
                float y2 = Noise.rotateY2D(x, y);
                x = x2;
                y = y2;
            }
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            latest = this.wrapped.getNoiseWithSeed((x *= 2.0f) + a, (y *= 2.0f) + b, seed + (long)i);
            sum += latest * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float fbm(float x, float y, float z, long seed) {
        float sum = this.wrapped.getNoiseWithSeed(x, y, z, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, seed + (long)i) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float billow(float x, float y, float z, long seed) {
        float sum = Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, seed)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            sum += (Math.abs(this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, seed + (long)i)) * 2.0f - 1.0f) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float ridged(float x, float y, float z, long seed) {
        float sum = 0.0f;
        float exp = 1.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, seed + (long)i));
            sum += spike * exp;
            correction += (exp *= 0.5f);
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
        }
        return sum / correction - 1.0f;
    }

    protected float warp(float x, float y, float z, long seed) {
        float latest;
        float sum = latest = this.wrapped.getNoiseWithSeed(x, y, z, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX3D(x, y, z);
                float y2 = Noise.rotateY3D(x, y, z);
                float z2 = Noise.rotateZ3D(x, y, z);
                x = x2;
                y = y2;
                z = z2;
            }
            x *= 2.0f;
            y *= 2.0f;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            latest = this.wrapped.getNoiseWithSeed(x + a, y + b, (z *= 2.0f) + c, seed + (long)i);
            sum += latest * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float fbm(float x, float y, float z, float w, long seed) {
        float sum = this.wrapped.getNoiseWithSeed(x, y, z, w, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, seed + (long)i) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float billow(float x, float y, float z, float w, long seed) {
        float sum = Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, seed)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            sum += (Math.abs(this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, seed + (long)i)) * 2.0f - 1.0f) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float ridged(float x, float y, float z, float w, long seed) {
        float sum = 0.0f;
        float exp = 1.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, seed + (long)i));
            sum += spike * exp;
            correction += (exp *= 0.5f);
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
        }
        return sum / correction - 1.0f;
    }

    protected float warp(float x, float y, float z, float w, long seed) {
        float latest;
        float sum = latest = this.wrapped.getNoiseWithSeed(x, y, z, w, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX4D(x, y, z, w);
                float y2 = Noise.rotateY4D(x, y, z, w);
                float z2 = Noise.rotateZ4D(x, y, z, w);
                float w2 = Noise.rotateW4D(x, y, z, w);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 2048 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 6144 & 0x3FFF];
            latest = this.wrapped.getNoiseWithSeed(x + a, y + b, z + c, w + d, seed + (long)i);
            sum += latest * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float fbm(float x, float y, float z, float w, float u, long seed) {
        float sum = this.wrapped.getNoiseWithSeed(x, y, z, w, u, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, u *= 2.0f, seed + (long)i) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float billow(float x, float y, float z, float w, float u, long seed) {
        float sum = Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, u, seed)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            sum += (Math.abs(this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, u *= 2.0f, seed + (long)i)) * 2.0f - 1.0f) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float ridged(float x, float y, float z, float w, float u, long seed) {
        float sum = 0.0f;
        float exp = 1.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, u, seed + (long)i));
            sum += spike * exp;
            correction += (exp *= 0.5f);
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
            u *= 2.0f;
        }
        return sum / correction - 1.0f;
    }

    protected float warp(float x, float y, float z, float w, float u, long seed) {
        float latest;
        float sum = latest = this.wrapped.getNoiseWithSeed(x, y, z, w, u, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX5D(x, y, z, w, u);
                float y2 = Noise.rotateY5D(x, y, z, w, u);
                float z2 = Noise.rotateZ5D(x, y, z, w, u);
                float w2 = Noise.rotateW5D(x, y, z, w, u);
                float u2 = Noise.rotateU5D(x, y, z, w, u);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
            u *= 2.0f;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1638 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 3276 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4915 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 6553 & 0x3FFF];
            latest = this.wrapped.getNoiseWithSeed(x + a, y + b, z + c, w + d, u + e, seed + (long)i);
            sum += latest * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float fbm(float x, float y, float z, float w, float u, float v, long seed) {
        float sum = this.wrapped.getNoiseWithSeed(x, y, z, w, u, v, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, u *= 2.0f, v *= 2.0f, seed + (long)i) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float billow(float x, float y, float z, float w, float u, float v, long seed) {
        float sum = Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, u, v, seed)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            sum += (Math.abs(this.wrapped.getNoiseWithSeed(x *= 2.0f, y *= 2.0f, z *= 2.0f, w *= 2.0f, u *= 2.0f, v *= 2.0f, seed + (long)i)) * 2.0f - 1.0f) * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }

    protected float ridged(float x, float y, float z, float w, float u, float v, long seed) {
        float sum = 0.0f;
        float exp = 1.0f;
        float correction = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            float spike = 1.0f - Math.abs(this.wrapped.getNoiseWithSeed(x, y, z, w, u, v, seed + (long)i));
            sum += spike * exp;
            correction += (exp *= 0.5f);
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
            u *= 2.0f;
            v *= 2.0f;
        }
        return sum / correction - 1.0f;
    }

    protected float warp(float x, float y, float z, float w, float u, float v, long seed) {
        float latest;
        float sum = latest = this.wrapped.getNoiseWithSeed(x, y, z, w, u, v, seed);
        float amp = 1.0f;
        for (int i = 1; i < this.octaves; ++i) {
            if (this.fractalSpiral) {
                float x2 = Noise.rotateX6D(x, y, z, w, u, v);
                float y2 = Noise.rotateY6D(x, y, z, w, u, v);
                float z2 = Noise.rotateZ6D(x, y, z, w, u, v);
                float w2 = Noise.rotateW6D(x, y, z, w, u, v);
                float u2 = Noise.rotateU6D(x, y, z, w, u, v);
                float v2 = Noise.rotateV6D(x, y, z, w, u, v);
                x = x2;
                y = y2;
                z = z2;
                w = w2;
                u = u2;
                v = v2;
            }
            x *= 2.0f;
            y *= 2.0f;
            z *= 2.0f;
            w *= 2.0f;
            u *= 2.0f;
            v *= 2.0f;
            int idx = (int)(latest * 8192.0f) & 0x3FFF;
            float a = TrigTools.SIN_TABLE[idx];
            float b = TrigTools.SIN_TABLE[idx + 1365 & 0x3FFF];
            float c = TrigTools.SIN_TABLE[idx + 2730 & 0x3FFF];
            float d = TrigTools.SIN_TABLE[idx + 4096 & 0x3FFF];
            float e = TrigTools.SIN_TABLE[idx + 5461 & 0x3FFF];
            float f = TrigTools.SIN_TABLE[idx + 6826 & 0x3FFF];
            latest = this.wrapped.getNoiseWithSeed(x + a, y + b, z + c, w + d, u + e, v + f, seed + (long)i);
            sum += latest * (amp *= 0.5f);
        }
        return sum / (amp * (float)((1 << this.octaves) - 1));
    }
}

