/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.ObjectList;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.LineDrawer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OrthoLine
implements LineDrawer {
    public final ObjectList<Coord> lastLine = new ObjectList();

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY) {
        return OrthoLine.line(startX, startY, endX, endY, null);
    }

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY, ObjectList<Coord> buffer) {
        int dx = endX - startX;
        int dy = endY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int workX = startX;
        int workY = startY;
        if (buffer == null) {
            buffer = new ObjectList(1 + nx + ny);
        } else {
            buffer.clear();
            buffer.ensureCapacity(1 + nx + ny);
        }
        buffer.add((Object)Coord.get(startX, startY));
        int ix = 0;
        int iy = 0;
        while (ix <= nx || iy <= ny) {
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                workX += signX;
                ++ix;
            } else {
                workY += signY;
                ++iy;
            }
            buffer.add((Object)Coord.get(workX, workY));
        }
        return buffer;
    }

    public static ObjectList<Coord> line(int startX, int startY, int endX, int endY, int maxLength, ObjectList<Coord> buffer) {
        int dx = endX - startX;
        int dy = endY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        maxLength = Math.max(0, Math.min(1 + nx + ny, maxLength));
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int workX = startX;
        int workY = startY;
        if (buffer == null) {
            buffer = new ObjectList(maxLength);
        } else {
            buffer.clear();
            buffer.ensureCapacity(maxLength);
        }
        if (maxLength == 0) {
            return buffer;
        }
        buffer.add((Object)Coord.get(startX, startY));
        int ix = 0;
        int iy = 0;
        while ((ix <= nx || iy <= ny) && buffer.size() < maxLength) {
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                workX += signX;
                ++ix;
            } else {
                workY += signY;
                ++iy;
            }
            buffer.add((Object)Coord.get(workX, workY));
        }
        return buffer;
    }

    public static boolean reachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return OrthoLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap, buffer);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        int dx = targetX - startX;
        int dy = targetY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int x = startX;
        int y = startY;
        int dist = nx + ny;
        if (buffer == null) {
            buffer = new ObjectList(dist + 1);
        } else {
            buffer.clear();
        }
        if (maxLength <= 0) {
            return false;
        }
        if (startX == targetX && startY == targetY) {
            buffer.add((Object)Coord.get(startX, startY));
            return true;
        }
        float decay = 1.0f / (float)dist;
        float currentForce = 1.0f;
        int ix = 0;
        int iy = 0;
        while ((ix <= nx || iy <= ny) && buffer.size() < maxLength) {
            buffer.add((Object)Coord.get(x, y));
            if (x == targetX && y == targetY) {
                return true;
            }
            if (x != startX || y != startY) {
                currentForce -= resistanceMap[x][y];
            }
            if ((currentForce -= decay) <= -0.001f) {
                return false;
            }
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                x += signX;
                ++ix;
                continue;
            }
            y += signY;
            ++iy;
        }
        return false;
    }

    public static boolean reachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap) {
        return OrthoLine.reachable(start.x, start.y, target.x, target.y, Integer.MAX_VALUE, resistanceMap);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, Integer.MAX_VALUE, resistanceMap);
    }

    public static boolean reachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap) {
        if (maxLength <= 0) {
            return false;
        }
        int dx = targetX - startX;
        int dy = targetY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int x = startX;
        int y = startY;
        int dist = nx + ny;
        int traveled = 0;
        if (startX == targetX && startY == targetY) {
            return true;
        }
        float decay = 1.0f / (float)dist;
        float currentForce = 1.0f;
        int ix = 0;
        int iy = 0;
        while ((ix <= nx || iy <= ny) && traveled < maxLength) {
            ++traveled;
            if (x == targetX && y == targetY) {
                return true;
            }
            if (x != startX || y != startY) {
                currentForce -= resistanceMap[x][y];
            }
            if ((currentForce -= decay) <= -0.001f) {
                return false;
            }
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                x += signX;
                ++ix;
                continue;
            }
            y += signY;
            ++iy;
        }
        return false;
    }

    public static ObjectList<Coord> line(Coord start, Coord end) {
        return OrthoLine.line(start.x, start.y, end.x, end.y);
    }

    public static Coord[] lineArray(int startX, int startY, int endX, int endY) {
        int dx = endX - startX;
        int dy = endY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int workX = startX;
        int workY = startY;
        Coord[] drawn = new Coord[nx + ny + 1];
        drawn[0] = Coord.get(startX, startY);
        int i = 1;
        int ix = 0;
        int iy = 0;
        while (ix <= nx || iy <= ny) {
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                workX += signX;
                ++ix;
            } else {
                workY += signY;
                ++iy;
            }
            drawn[i] = Coord.get(workX, workY);
            ++i;
        }
        return drawn;
    }

    public static Coord[] lineArray(int startX, int startY, int endX, int endY, int maxLength) {
        int dx = endX - startX;
        int dy = endY - startY;
        int nx = Math.abs(dx);
        int ny = Math.abs(dy);
        maxLength = Math.max(0, Math.min(nx + ny + 1, maxLength));
        int signX = dx >> 31 | 1;
        int signY = dy >> 31 | 1;
        int workX = startX;
        int workY = startY;
        Coord[] drawn = new Coord[maxLength];
        if (maxLength == 0) {
            return drawn;
        }
        drawn[0] = Coord.get(startX, startY);
        int i = 1;
        int ix = 0;
        int iy = 0;
        while (ix <= nx || iy <= ny) {
            if ((1 + ix + ix) * ny < (1 + iy + iy) * nx) {
                workX += signX;
                ++ix;
            } else {
                workY += signY;
                ++iy;
            }
            drawn[i] = Coord.get(workX, workY);
            ++i;
        }
        return drawn;
    }

    public static Coord[] lineArray(Coord start, Coord end) {
        return OrthoLine.lineArray(start.x, start.y, end.x, end.y);
    }

    public static char[] lineChars(Coord[] line) {
        if (line == null) {
            return null;
        }
        int len = line.length;
        if (len == 0) {
            return new char[0];
        }
        if (len == 1) {
            return new char[]{'\u2500'};
        }
        char[] cs = new char[len];
        cs[0] = line[0].x == line[1].x ? 9474 : 9472;
        cs[len - 1] = line[len - 1].x == line[len - 2].x ? 9474 : 9472;
        block21: for (int i = 1; i < len - 1; ++i) {
            Coord before = line[i - 1];
            Coord current = line[i];
            Coord next = line[i + 1];
            switch (before.toGoTo(current)) {
                case RIGHT: {
                    switch (current.toGoTo(next)) {
                        case DOWN: {
                            cs[i] = 9496;
                            continue block21;
                        }
                        case UP: {
                            cs[i] = 9488;
                            continue block21;
                        }
                    }
                    cs[i] = 9472;
                    continue block21;
                }
                case LEFT: {
                    switch (current.toGoTo(next)) {
                        case DOWN: {
                            cs[i] = 9492;
                            continue block21;
                        }
                        case UP: {
                            cs[i] = 9484;
                            continue block21;
                        }
                    }
                    cs[i] = 9472;
                    continue block21;
                }
                case UP: {
                    switch (current.toGoTo(next)) {
                        case LEFT: {
                            cs[i] = 9488;
                            continue block21;
                        }
                        case RIGHT: {
                            cs[i] = 9484;
                            continue block21;
                        }
                    }
                    cs[i] = 9474;
                    continue block21;
                }
                default: {
                    switch (current.toGoTo(next)) {
                        case LEFT: {
                            cs[i] = 9496;
                            continue block21;
                        }
                        case RIGHT: {
                            cs[i] = 9492;
                            continue block21;
                        }
                    }
                    cs[i] = 9474;
                }
            }
        }
        return cs;
    }

    public static char[] lineChars(List<Coord> line) {
        if (line == null) {
            return null;
        }
        int len = line.size();
        if (len == 0) {
            return new char[0];
        }
        if (len == 1) {
            return new char[]{'\u2500'};
        }
        char[] cs = new char[len];
        cs[0] = line.get((int)0).x == line.get((int)1).x ? 9474 : 9472;
        cs[len - 1] = line.get((int)(len - 1)).x == line.get((int)(len - 2)).x ? 9474 : 9472;
        block21: for (int i = 1; i < len - 1; ++i) {
            Coord before = line.get(i - 1);
            Coord current = line.get(i);
            Coord next = line.get(i + 1);
            switch (before.toGoTo(current)) {
                case RIGHT: {
                    switch (current.toGoTo(next)) {
                        case DOWN: {
                            cs[i] = 9496;
                            continue block21;
                        }
                        case UP: {
                            cs[i] = 9488;
                            continue block21;
                        }
                    }
                    cs[i] = 9472;
                    continue block21;
                }
                case LEFT: {
                    switch (current.toGoTo(next)) {
                        case DOWN: {
                            cs[i] = 9492;
                            continue block21;
                        }
                        case UP: {
                            cs[i] = 9484;
                            continue block21;
                        }
                    }
                    cs[i] = 9472;
                    continue block21;
                }
                case UP: {
                    switch (current.toGoTo(next)) {
                        case LEFT: {
                            cs[i] = 9488;
                            continue block21;
                        }
                        case RIGHT: {
                            cs[i] = 9484;
                            continue block21;
                        }
                    }
                    cs[i] = 9474;
                    continue block21;
                }
                default: {
                    switch (current.toGoTo(next)) {
                        case LEFT: {
                            cs[i] = 9496;
                            continue block21;
                        }
                        case RIGHT: {
                            cs[i] = 9492;
                            continue block21;
                        }
                    }
                    cs[i] = 9474;
                }
            }
        }
        return cs;
    }

    @Override
    public ObjectList<Coord> getLastLine() {
        return this.lastLine;
    }

    @Override
    public ObjectList<Coord> drawLine(Coord a, Coord b) {
        this.lastLine.clear();
        return OrthoLine.line(a.x, a.y, b.x, b.y, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY) {
        this.lastLine.clear();
        return OrthoLine.line(startX, startY, targetX, targetY, Integer.MAX_VALUE, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, int maxLength) {
        this.lastLine.clear();
        return OrthoLine.line(startX, startY, targetX, targetY, maxLength, this.lastLine);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, ObjectList<Coord> buffer) {
        return OrthoLine.line(startX, startY, targetX, targetY, buffer);
    }

    @Override
    public boolean isReachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return OrthoLine.reachable(start.x, start.y, target.x, target.y, resistanceMap, buffer);
    }

    @Override
    public ObjectList<Coord> drawLine(int startX, int startY, int targetX, int targetY, int maxLength, ObjectList<Coord> buffer) {
        return OrthoLine.line(startX, startY, targetX, targetY, maxLength, buffer);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, resistanceMap, buffer);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap, ObjectList<Coord> buffer) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, maxLength, resistanceMap, buffer);
    }

    @Override
    public boolean isReachable(@NonNull Coord start, @NonNull Coord target, @NonNull float[][] resistanceMap) {
        return OrthoLine.reachable(start.x, start.y, target.x, target.y, resistanceMap);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, @NonNull float[][] resistanceMap) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, resistanceMap);
    }

    @Override
    public boolean isReachable(int startX, int startY, int targetX, int targetY, int maxLength, @NonNull float[][] resistanceMap) {
        return OrthoLine.reachable(startX, startY, targetX, targetY, maxLength, resistanceMap);
    }

    @Override
    public Coord[] drawLineArray(Coord a, Coord b) {
        return OrthoLine.lineArray(a.x, a.y, b.x, b.y);
    }

    @Override
    public Coord[] drawLineArray(int startX, int startY, int targetX, int targetY) {
        return OrthoLine.lineArray(startX, startY, targetX, targetY, Integer.MAX_VALUE);
    }

    @Override
    public Coord[] drawLineArray(int startX, int startY, int targetX, int targetY, int maxLength) {
        return OrthoLine.lineArray(startX, startY, targetX, targetY, maxLength);
    }
}

