/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.QuasiRandomTools;

public class PhantomNoise
implements INoise {
    public Hasher hasher;
    public int dim;
    public float sharpness;
    protected float inverse;
    protected transient float[] working;
    protected transient float[] points;
    protected transient float[] input;
    protected transient float[][] vertices;
    protected transient int[] floors;
    protected transient int[] hashFloors;
    public static final PhantomNoise instance2D = new PhantomNoise(QuasiRandomTools.goldenLong[2][0], 2);
    public static final PhantomNoise instance3D = new PhantomNoise(QuasiRandomTools.goldenLong[3][0], 3);
    public static final PhantomNoise instance4D = new PhantomNoise(QuasiRandomTools.goldenLong[4][0], 4);
    public static final PhantomNoise instance5D = new PhantomNoise(QuasiRandomTools.goldenLong[5][0], 5);
    public static final PhantomNoise instance6D = new PhantomNoise(QuasiRandomTools.goldenLong[6][0], 6);
    public static final PhantomNoise instance7D = new PhantomNoise(QuasiRandomTools.goldenLong[7][0], 7);
    public static final PhantomNoise instance8D = new PhantomNoise(QuasiRandomTools.goldenLong[8][0], 8);

    public PhantomNoise() {
        this(-77195684566545666L, 3);
    }

    public PhantomNoise(long seed, int dimension) {
        this(seed, dimension, 0.825f * (float)Math.max(2, dimension));
    }

    public PhantomNoise(long seed, int dimension, float sharpness) {
        this.dim = Math.max(2, dimension);
        this.sharpness = sharpness;
        this.input = new float[this.dim];
        this.working = new float[this.dim + 1];
        this.points = new float[this.dim + 1];
        this.vertices = new float[this.dim + 1][this.dim];
        float id = -1.0f / (float)this.dim;
        this.vertices[0][0] = 1.0f;
        for (int v = 1; v <= this.dim; ++v) {
            this.vertices[v][0] = id;
        }
        for (int d = 1; d < this.dim; ++d) {
            float t = 0.0f;
            for (int i = 0; i < d; ++i) {
                t += this.vertices[d][i] * this.vertices[d][i];
            }
            this.vertices[d][d] = (float)Math.sqrt(1.0f - t);
            t = (id - t) / this.vertices[d][d];
            for (int v = d + 1; v <= this.dim; ++v) {
                this.vertices[v][d] = t;
            }
        }
        this.hasher = new Hasher(seed);
        this.floors = new int[this.dim + 1];
        this.hashFloors = new int[this.dim + 1];
        this.inverse = 1.0f / ((float)this.dim + 1.0f);
    }

    public PhantomNoise reassign(long seed, int dimension, float sharpness) {
        boolean unchanged;
        this.sharpness = sharpness;
        boolean bl = unchanged = this.dim == Math.max(2, dimension);
        if (!unchanged) {
            this.dim = Math.max(2, dimension);
            this.input = new float[this.dim];
            this.working = new float[this.dim + 1];
            this.points = new float[this.dim + 1];
            this.vertices = new float[this.dim + 1][this.dim];
            float id = -1.0f / (float)this.dim;
            this.vertices[0][0] = 1.0f;
            for (int v = 1; v <= this.dim; ++v) {
                this.vertices[v][0] = id;
            }
            for (int d = 1; d < this.dim; ++d) {
                float t = 0.0f;
                for (int i = 0; i < d; ++i) {
                    t += this.vertices[d][i] * this.vertices[d][i];
                }
                this.vertices[d][d] = (float)Math.sqrt(1.0f - t);
                t = (id - t) / this.vertices[d][d];
                for (int v = d + 1; v <= this.dim; ++v) {
                    this.vertices[v][d] = t;
                }
            }
            this.floors = new int[this.dim + 1];
            this.hashFloors = new int[this.dim + 1];
            this.inverse = 1.0f / ((float)this.dim + 1.0f);
        }
        for (int v = 0; v <= this.dim; ++v) {
            float theta = TrigTools.atan2((float)this.vertices[v][1], (float)this.vertices[v][0]) + Hasher.randomize3Float((long)((long)v - seed));
            float dist = (float)Math.sqrt(this.vertices[v][1] * this.vertices[v][1] + this.vertices[v][0] * this.vertices[v][0]);
            this.vertices[v][0] = TrigTools.cos((float)theta) * dist;
            this.vertices[v][1] = TrigTools.sin((float)theta) * dist;
        }
        this.hasher = new Hasher(seed);
        return this;
    }

    @Override
    public String getTag() {
        return "PhaN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.hasher.seed + '~' + this.dim + '~' + BitConversion.floatToReversedIntBits((float)this.sharpness) + '`';
    }

    @Override
    public PhantomNoise deserializeFromString(String data) {
        if (data == null || data.length() < 7) {
            return this;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return this.reassign(seed, dim, sharp);
    }

    public static PhantomNoise recreateFromString(String data) {
        if (data == null || data.length() < 7) {
            return null;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return new PhantomNoise(seed, dim, sharp);
    }

    @Override
    public PhantomNoise copy() {
        return new PhantomNoise(this.hasher.seed, this.dim, this.sharpness);
    }

    protected float valueNoise(int dim) {
        this.hashFloors[dim] = BitConversion.floatToRawIntBits((float)this.working[dim]);
        for (int i = 0; i < dim; ++i) {
            this.floors[i] = (double)this.working[i] >= 0.0 ? (int)this.working[i] : (int)this.working[i] - 1;
            int n = i;
            this.working[n] = this.working[n] - (float)this.floors[i];
            int n2 = i;
            this.working[n2] = (float)((double)this.working[n2] * ((double)this.working[i] * (3.0 - 2.0 * (double)this.working[i])));
        }
        float sum = 0.0f;
        int limit = 1 << dim;
        for (int i = 0; i < limit; ++i) {
            float temp = 1.0f;
            for (int j = 0; j < dim; ++j) {
                int bit = i >>> j & 1;
                temp *= (float)bit + (float)(1 | -bit) * this.working[j];
                this.hashFloors[j] = this.floors[j] - bit;
            }
            sum += temp * (float)this.hasher.hash(this.hashFloors, dim + 1);
        }
        return sum * 2.3283064E-10f + 0.5f;
    }

    protected float valueNoise2D() {
        this.hashFloors[2] = BitConversion.floatToRawIntBits((float)this.working[2]);
        for (int i = 0; i < 2; ++i) {
            this.floors[i] = (double)this.working[i] >= 0.0 ? (int)this.working[i] : (int)this.working[i] - 1;
            int n = i;
            this.working[n] = this.working[n] - (float)this.floors[i];
            int n2 = i;
            this.working[n2] = (float)((double)this.working[n2] * ((double)this.working[i] * (3.0 - 2.0 * (double)this.working[i])));
        }
        float sum = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float temp = 1.0f;
            int bit = i & 1;
            temp *= (float)bit + (float)(1 | -bit) * this.working[0];
            this.hashFloors[0] = this.floors[0] - bit;
            bit = i >>> 1;
            this.hashFloors[1] = this.floors[1] - bit;
            sum += (temp *= (float)bit + (float)(1 | -bit) * this.working[1]) * (float)this.hasher.hash(this.hashFloors, 3);
        }
        return sum * 2.3283064E-10f + 0.5f;
    }

    public float getNoise(float ... args) {
        return this.noise(args.length, args);
    }

    public float noise(int used, float ... args) {
        for (int v = 0; v <= this.dim; ++v) {
            this.points[v] = 0.0f;
            for (int d = 0; d < this.dim; ++d) {
                int n = v;
                this.points[n] = this.points[n] + args[d] * this.vertices[v][d];
            }
        }
        this.working[this.dim] = 0.618034f;
        float result = 0.0f;
        float warp = 0.0f;
        for (int i = 0; i <= this.dim; ++i) {
            int j = 0;
            int d = 0;
            while (j < this.dim) {
                if (d == i) {
                    ++d;
                }
                this.working[j] = this.points[d];
                ++j;
                ++d;
            }
            this.working[0] = this.working[0] + warp;
            warp = this.valueNoise(used);
            result += warp;
            int n = this.dim;
            this.working[n] = this.working[n] + -0.42331082f;
        }
        float diff = 0.5f - (result *= this.inverse);
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + this.sharpness * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public float getNoise2D(float x, float y) {
        this.points[0] = -0.41614684f * x + 0.9092974f * y;
        this.points[1] = -0.57940125f * x + -0.81504244f * y;
        this.points[2] = 0.99554807f * x + -0.09425498f * y;
        this.working[2] = 0.618034f;
        float result = 0.0f;
        float warp = 0.0f;
        for (int i = 0; i <= 2; ++i) {
            int j = 0;
            int d = 0;
            while (j < 2) {
                if (d == i) {
                    ++d;
                }
                this.working[j] = this.points[d];
                ++j;
                ++d;
            }
            this.working[0] = this.working[0] + warp;
            warp = this.valueNoise2D();
            result += warp;
            this.working[2] = this.working[2] + -0.42331082f;
        }
        float diff = 0.5f - (result *= this.inverse);
        int sign = BitConversion.floatToRawIntBits((float)diff) >> 31;
        int one = sign | 1;
        return (result + (float)sign) / (Float.MIN_VALUE - (float)sign + (result + this.sharpness * diff) * (float)one) - (float)sign - (float)sign - 1.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhantomNoise that = (PhantomNoise)o;
        if (this.dim != that.dim) {
            return false;
        }
        if (Float.compare(that.sharpness, this.sharpness) != 0) {
            return false;
        }
        return this.hasher.seed == that.hasher.seed;
    }

    void printDebugInfo() {
        System.out.println("PhantomNoise with Dimension " + this.dim + ":");
        String dimNames = "xyzwuvmnopqrstabcdefghijkl";
        for (int v = 0; v <= this.dim; ++v) {
            System.out.print("final float p" + v + " = ");
            for (int i = 0; i < this.dim; ++i) {
                if ((double)this.vertices[v][i] == 0.0) continue;
                if (i > 0) {
                    System.out.print(" + ");
                }
                if ((double)this.vertices[v][i] == 1.0) {
                    System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(i % "xyzwuvmnopqrstabcdefghijkl".length()));
                    continue;
                }
                System.out.print("xyzwuvmnopqrstabcdefghijkl".charAt(i % "xyzwuvmnopqrstabcdefghijkl".length()) + " * " + this.vertices[v][i] + "f");
            }
            System.out.println(';');
        }
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return this.dim;
    }

    @Override
    public boolean canUseSeed() {
        return false;
    }

    @Override
    public long getSeed() {
        return this.hasher.seed;
    }

    @Override
    public void setSeed(long seed) {
        this.reassign(seed, this.dim, this.sharpness);
    }

    @Override
    public float getNoise(float x, float y) {
        if (this.dim >= 2) {
            return this.getNoise2D(x, y);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 2D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z) {
        if (this.dim >= 3) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            return this.noise(3, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 3D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        if (this.dim >= 4) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            return this.noise(4, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 4D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        if (this.dim >= 5) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            return this.noise(5, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 5D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        if (this.dim >= 6) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            this.input[5] = v;
            return this.noise(6, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 6D noise.");
    }
}

