/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.ds.FloatList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.WhiskerRandom;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.CoordObjectOrderedMap;
import com.github.yellowstonegames.grid.CoordOrderedSet;
import com.github.yellowstonegames.grid.Region;

public final class PoissonDisk {
    private static final float inverseRootTwo = (float)Math.sqrt(0.5);

    private PoissonDisk() {
    }

    public static CoordObjectOrderedMap<ObjectList<Coord>> sampleCircle(Coord center, float radius, float minimumDistance, int maxX, int maxY) {
        return PoissonDisk.sampleCircle(center, radius, minimumDistance, maxX, maxY, 10, (EnhancedRandom)new WhiskerRandom());
    }

    public static CoordObjectOrderedMap<ObjectList<Coord>> sampleCircle(Coord center, float radius, float minimumDistance, int maxX, int maxY, int pointsPerIteration, EnhancedRandom rng) {
        int radius2 = Math.round(radius);
        return PoissonDisk.sample(center.translate(-radius2, -radius2), center.translate(radius2, radius2), radius, minimumDistance, maxX, maxY, pointsPerIteration, rng);
    }

    public static CoordObjectOrderedMap<ObjectList<Coord>> sampleRectangle(Coord minPosition, Coord maxPosition, float minimumDistance) {
        return PoissonDisk.sampleRectangle(minPosition, maxPosition, minimumDistance, maxPosition.x + 1, maxPosition.y + 1, 10, (EnhancedRandom)new WhiskerRandom());
    }

    public static CoordObjectOrderedMap<ObjectList<Coord>> sampleRectangle(Coord minPosition, Coord maxPosition, float minimumDistance, int pointsPerIteration, EnhancedRandom rng) {
        return PoissonDisk.sample(minPosition, maxPosition, 0.0f, minimumDistance, maxPosition.x + 1, maxPosition.y + 1, pointsPerIteration, rng);
    }

    public static CoordObjectOrderedMap<ObjectList<Coord>> sampleRectangle(Coord minPosition, Coord maxPosition, float minimumDistance, int maxX, int maxY, int pointsPerIteration, EnhancedRandom rng) {
        return PoissonDisk.sample(minPosition, maxPosition, 0.0f, minimumDistance, maxX, maxY, pointsPerIteration, rng);
    }

    public static CoordOrderedSet sampleMap(char[][] map, float minimumDistance, EnhancedRandom rng, char ... blocking) {
        return PoissonDisk.sampleMap(Coord.get(1, 1), Coord.get(map.length - 2, map[0].length - 2), map, minimumDistance, rng, blocking);
    }

    public static CoordOrderedSet sampleMap(Coord minPosition, Coord maxPosition, char[][] map, float minimumDistance, EnhancedRandom rng, char ... blocking) {
        int width = map.length;
        int height = map[0].length;
        boolean restricted = blocking != null && blocking.length > 0;
        Coord dimensions = maxPosition.subtract(minPosition);
        float cellSize = Math.max(minimumDistance * inverseRootTwo, 1.0f);
        float minimumDistance2 = minimumDistance * minimumDistance;
        int gridWidth = (int)((float)dimensions.x / cellSize) + 1;
        int gridHeight = (int)((float)dimensions.y / cellSize) + 1;
        Coord[][] grid = new Coord[gridWidth][gridHeight];
        ObjectList activePoints = new ObjectList();
        CoordOrderedSet points = new CoordOrderedSet(128);
        Region valid = new Region(map, blocking).notAnd(new Region(width, height).insertRectangle(minPosition.x, minPosition.y, maxPosition.x - minPosition.x + 1, maxPosition.y - minPosition.y + 1));
        Coord p = valid.singleRandom(rng);
        if (p == null) {
            return points;
        }
        Coord index = p.subtract(minPosition).divide(cellSize);
        grid[index.x][index.y] = p;
        activePoints.add((Object)p);
        points.add(p);
        while (activePoints.size() != 0) {
            int listIndex = rng.nextInt(activePoints.size());
            Coord point = (Coord)activePoints.get(listIndex);
            boolean found = false;
            for (int k = 0; k < 20; ++k) {
                float d = rng.nextFloat();
                float radius = minimumDistance + minimumDistance * d;
                float angle = rng.nextFloat();
                float newX = radius * TrigTools.sinTurns((float)angle);
                float newY = radius * TrigTools.cosTurns((float)angle);
                Coord q = point.translateCapped(Math.round(newX), Math.round(newY), width, height);
                for (int frustration = 0; restricted && !valid.contains(q) && frustration < 8; ++frustration) {
                    angle = rng.nextFloat();
                    newX = radius * TrigTools.sinTurns((float)angle);
                    newY = radius * TrigTools.cosTurns((float)angle);
                    q = point.translateCapped(Math.round(newX), Math.round(newY), width, height);
                }
                if (q.x < minPosition.x || q.x > maxPosition.x || q.y < minPosition.y || q.y > maxPosition.y) continue;
                Coord qIndex = q.subtract(minPosition).divide((int)Math.ceil(cellSize));
                boolean tooClose = false;
                block3: for (int i = Math.max(0, qIndex.x - 2); i < Math.min(gridWidth, qIndex.x + 3) && !tooClose; ++i) {
                    for (int j = Math.max(0, qIndex.y - 2); j < Math.min(gridHeight, qIndex.y + 3); ++j) {
                        if (grid[i][j] == null || !(grid[i][j].distanceSq(q) < minimumDistance2)) continue;
                        tooClose = true;
                        continue block3;
                    }
                }
                if (tooClose) continue;
                found = true;
                activePoints.add((Object)q);
                if (!restricted || valid.contains(q)) {
                    points.add(q);
                }
                grid[qIndex.x][qIndex.y] = q;
            }
            if (found) continue;
            activePoints.remove(listIndex);
        }
        return points;
    }

    protected static CoordObjectOrderedMap<ObjectList<Coord>> sample(Coord minPos, Coord maxPos, float maxSampleRadius, float radius, int xBound, int yBound, int pointsPerTry, EnhancedRandom random) {
        radius = Math.max(1.0001f, radius);
        maxSampleRadius *= maxSampleRadius;
        float radius2 = radius * radius;
        float iCellSize = 1.0f / (radius * inverseRootTwo);
        float ik = 1.0f / (float)pointsPerTry;
        float width = maxPos.x - minPos.x + 1;
        float height = maxPos.y - minPos.y + 1;
        Coord gridCenter = minPos.average(maxPos);
        int gridWidth = Math.min((int)Math.ceil(width * iCellSize), xBound);
        int gridHeight = Math.min((int)Math.ceil(height * iCellSize), yBound);
        float[][] gridX = new float[gridWidth][gridHeight];
        float[][] gridY = new float[gridWidth][gridHeight];
        FloatList qx = new FloatList(false, gridWidth + gridHeight);
        FloatList qy = new FloatList(false, gridWidth + gridHeight);
        CoordObjectOrderedMap<ObjectList<Coord>> graph = new CoordObjectOrderedMap<ObjectList<Coord>>(8 + (int)((float)(gridWidth * gridHeight) * iCellSize));
        graph.put(PoissonDisk.sample(width * 0.5f, height * 0.5f, iCellSize, qx, qy, gridX, gridY, minPos), new ObjectList(4));
        block0: while (qx.notEmpty()) {
            int i = random.nextInt(qx.size());
            float px = qx.get(i);
            float py = qy.get(i);
            Coord parent = Coord.get((int)px, (int)py);
            float seed = random.nextFloat();
            for (int j = 0; j < pointsPerTry; ++j) {
                float x = px + radius * TrigTools.cosTurns((float)seed);
                float y = py + radius * TrigTools.sinTurns((float)seed);
                seed += ik;
                if (!(x >= (float)minPos.x) || !(x < (float)maxPos.x + 0.99999994f) || !(y >= (float)minPos.y) || !(y < (float)maxPos.y + 0.99999994f) || !PoissonDisk.far(x, y, iCellSize, radius2, gridCenter, maxSampleRadius, gridX, gridY, minPos)) continue;
                Coord sam = PoissonDisk.sample(x, y, iCellSize, qx, qy, gridX, gridY, minPos);
                ((ObjectList)graph.get(parent)).add((Object)sam);
                graph.put(sam, new ObjectList(4));
                continue block0;
            }
            qx.removeAt(i);
            qy.removeAt(i);
        }
        return graph;
    }

    private static boolean far(float x, float y, float iCellSize, float radius2, Coord gridCenter, float maxSampleRadius, float[][] gridX, float[][] gridY, Coord minPos) {
        if (maxSampleRadius != 0.0f && gridCenter.distanceSq(x, y) > maxSampleRadius) {
            return false;
        }
        int i = (int)((x - (float)minPos.x) * iCellSize);
        int j = (int)((y - (float)minPos.y) * iCellSize);
        int gridWidth = gridX.length;
        int i0 = Math.max(i - 2, 0);
        int j0 = Math.max(j - 2, 0);
        int i1 = Math.min(i + 3, gridWidth);
        int j1 = Math.min(j + 3, gridX[0].length);
        for (int xx = i0; xx < i1; ++xx) {
            for (int yy = j0; yy < j1; ++yy) {
                float dx = gridX[xx][yy];
                if (!(dx >= 0.0f)) continue;
                dx -= x;
                float dy = gridY[xx][yy] - y;
                if (!((dx = dx * dx + dy * dy) < radius2)) continue;
                return false;
            }
        }
        return true;
    }

    private static Coord sample(float x, float y, float invCellSize, FloatList qx, FloatList qy, float[][] gridX, float[][] gridY, Coord minPos) {
        int gx = (int)((x - (float)minPos.x) * invCellSize);
        int gy = (int)((y - (float)minPos.y) * invCellSize);
        gridX[gx][gy] = x;
        gridY[gx][gy] = y;
        qx.add(x);
        qy.add(y);
        return Coord.get((int)x, (int)y);
    }
}

