/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.Base;
import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.random.LineWobble;
import com.github.tommyettinger.random.WhiskerRandom;
import com.github.yellowstonegames.core.DescriptiveColor;

public class Radiance {
    private static final WhiskerRandom random = new WhiskerRandom();
    public float range;
    public int color;
    public float flicker;
    public float strobe;
    public float delay;
    public float flare;
    private final transient int seed;

    public Radiance() {
        this(0.0f, -8421377, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Radiance(float range) {
        this(range, -8421377, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Radiance(float range, int color) {
        this(range, color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Radiance(float range, int color, float flicker) {
        this(range, color, flicker, 0.0f, 0.0f, 0.0f);
    }

    public Radiance(float range, int color, float flicker, float strobe) {
        this(range, color, flicker, strobe, 0.0f, 0.0f);
    }

    public Radiance(float range, String color, float flicker, float strobe) {
        this(range, DescriptiveColor.describeOklab((CharSequence)color), flicker, strobe, 0.0f, 0.0f);
    }

    public Radiance(float range, int color, float flicker, float strobe, float delay) {
        this(range, color, flicker, strobe, delay, 0.0f);
    }

    public Radiance(float range, int color, float flicker, float strobe, float delay, float flare) {
        this.range = range;
        this.color = color;
        this.flicker = flicker;
        this.strobe = strobe;
        this.delay = delay;
        this.flare = flare;
        this.seed = random.nextInt();
    }

    public Radiance(Radiance other) {
        this(other.range, other.color, other.flicker, other.strobe, other.delay, other.flare);
    }

    public float currentRange() {
        float time = (float)(System.currentTimeMillis() & 0x3FFFFL) * 0.0030517578f;
        float current = this.range;
        if (this.flicker != 0.0f) {
            current *= LineWobble.wobble((int)this.seed, (float)(time * this.flicker + this.delay)) * 0.375f + 0.625f;
        }
        if (this.strobe != 0.0f) {
            current *= MathTools.swayTight((float)(time * this.strobe + this.delay)) * 0.5f + 0.5f;
        }
        return Math.max(current, this.range * this.flare);
    }

    public static Radiance[] makeChain(int length, float range, int color, float strobe) {
        if (length <= 1) {
            return new Radiance[]{new Radiance(range, color, 0.0f, strobe)};
        }
        Radiance[] chain = new Radiance[length];
        float d = -2.0f / (float)length;
        for (int i = 0; i < length; ++i) {
            chain[i] = new Radiance(range, color, 0.0f, strobe, d * (float)i);
        }
        return chain;
    }

    public String toString() {
        return "Radiance{range=" + this.range + ", color=" + this.color + ", flicker=" + this.flicker + ", strobe=" + this.strobe + ", delay=" + this.delay + ", flare=" + this.flare + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Radiance radiance = (Radiance)o;
        if (Float.compare(radiance.range, this.range) != 0) {
            return false;
        }
        if (radiance.color != this.color) {
            return false;
        }
        if (Float.compare(radiance.flicker, this.flicker) != 0) {
            return false;
        }
        if (Float.compare(radiance.strobe, this.strobe) != 0) {
            return false;
        }
        if (Float.compare(radiance.delay, this.delay) != 0) {
            return false;
        }
        return Float.compare(radiance.flare, this.flare) == 0;
    }

    public int hashCode() {
        int result = BitConversion.floatToIntBits((float)this.range);
        result = (result ^ (result << 11 | result >>> 21) ^ (result << 19 | result >>> 13)) + BitConversion.floatToIntBits((float)this.flicker);
        result = (result ^ (result << 11 | result >>> 21) ^ (result << 19 | result >>> 13)) + BitConversion.floatToIntBits((float)this.strobe);
        result = (result ^ (result << 11 | result >>> 21) ^ (result << 19 | result >>> 13)) + BitConversion.floatToIntBits((float)this.delay);
        result = (result ^ (result << 11 | result >>> 21) ^ (result << 19 | result >>> 13)) + BitConversion.floatToIntBits((float)this.flare);
        result = (result ^ (result << 11 | result >>> 21) ^ (result << 19 | result >>> 13)) + this.color;
        return result;
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append('`');
        Base.SIMPLE64.appendSigned(sb, this.range).append('~');
        Base.SIMPLE64.appendSigned(sb, this.color).append('~');
        Base.SIMPLE64.appendSigned(sb, this.flicker).append('~');
        Base.SIMPLE64.appendSigned(sb, this.strobe).append('~');
        Base.SIMPLE64.appendSigned(sb, this.delay).append('~');
        Base.SIMPLE64.appendSigned(sb, this.flare).append('`');
        return sb.toString();
    }

    public static Radiance deserializeFromString(String data) {
        if (data == null) {
            return null;
        }
        int idx = 0;
        int n = idx + 1;
        int n2 = data.indexOf(126, idx + 1);
        idx = n2;
        int n3 = idx + 1;
        int n4 = data.indexOf(126, idx + 1);
        idx = n4;
        int n5 = idx + 1;
        int n6 = data.indexOf(126, idx + 1);
        idx = n6;
        int n7 = idx + 1;
        int n8 = data.indexOf(126, idx + 1);
        idx = n8;
        int n9 = idx + 1;
        idx = data.indexOf(126, idx + 1);
        return new Radiance(Base.SIMPLE64.readFloatExact((CharSequence)data, n, n2), Base.SIMPLE64.readInt((CharSequence)data, n3, n4), Base.SIMPLE64.readFloatExact((CharSequence)data, n5, n6), Base.SIMPLE64.readFloatExact((CharSequence)data, n7, n8), Base.SIMPLE64.readFloatExact((CharSequence)data, n9, idx), Base.SIMPLE64.readFloatExact((CharSequence)data, idx + 1, data.indexOf(96, idx + 1)));
    }
}

