/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.CoordOrderedSet;
import com.github.yellowstonegames.grid.Measurement;
import java.util.List;

public enum Radius {
    SQUARE,
    DIAMOND,
    CIRCLE;

    public static final Radius[] ALL;

    public float radius(Coord start, Coord end) {
        float dx = start.x - end.x;
        float dy = start.y - end.y;
        return this.radius(dx, dy);
    }

    public float radius(Coord end) {
        return this.radius(end.x, end.y);
    }

    public float radius(float startx, float starty, float endx, float endy) {
        float dx = startx - endx;
        float dy = starty - endy;
        return this.radius(dx, dy);
    }

    public float radius(float dx, float dy) {
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        switch (this) {
            case SQUARE: {
                return Math.max(dx, dy);
            }
            case CIRCLE: {
                return (float)Math.sqrt(dx * dx + dy * dy);
            }
        }
        return dx + dy;
    }

    public Coord onUnitShape(float distance, EnhancedRandom rng) {
        int y;
        int x;
        switch (this) {
            case SQUARE: {
                x = rng.nextInt((int)(-distance), (int)distance + 1);
                y = rng.nextInt((int)(-distance), (int)distance + 1);
                break;
            }
            case DIAMOND: {
                x = rng.nextInt((int)(-distance), (int)distance + 1);
                y = rng.nextInt((int)(-distance), (int)distance + 1);
                if (!(this.radius(x, y) > distance)) break;
                if (x > 0) {
                    if (y > 0) {
                        x = (int)(distance - (float)x);
                        y = (int)(distance - (float)y);
                        break;
                    }
                    x = (int)(distance - (float)x);
                    y = (int)(-distance - (float)y);
                    break;
                }
                if (y > 0) {
                    x = (int)(-distance - (float)x);
                    y = (int)(distance - (float)y);
                    break;
                }
                x = (int)(-distance - (float)x);
                y = (int)(-distance - (float)y);
                break;
            }
            default: {
                float radius = distance * (float)Math.sqrt(rng.nextFloat());
                float theta = rng.nextFloat();
                x = Math.round(TrigTools.cosTurns((float)theta) * radius);
                y = Math.round(TrigTools.sinTurns((float)theta) * radius);
            }
        }
        return Coord.get(x, y);
    }

    public float area(float radiusLength) {
        switch (this) {
            case SQUARE: {
                return (radiusLength * 2.0f + 1.0f) * (radiusLength * 2.0f + 1.0f);
            }
            case DIAMOND: {
                return radiusLength * (radiusLength + 1.0f) * 2.0f + 1.0f;
            }
        }
        return (float)Math.PI * radiusLength * radiusLength + 1.0f;
    }

    private int clamp(int n, int min, int max) {
        return Math.min(Math.max(min, n), max - 1);
    }

    public CoordOrderedSet perimeter(Coord center, int radiusLength, boolean surpassEdges, int width, int height) {
        CoordOrderedSet rim = new CoordOrderedSet(4 * radiusLength);
        if (!(surpassEdges || center.x >= 0 && center.x < width && center.y >= 0 && center.y <= height)) {
            return rim;
        }
        if (radiusLength < 1) {
            rim.add(center);
            return rim;
        }
        block0 : switch (this) {
            case SQUARE: {
                for (int i = center.x - radiusLength; i <= center.x + radiusLength; ++i) {
                    int x = i;
                    if (!surpassEdges) {
                        x = this.clamp(i, 0, width);
                    }
                    rim.add(Coord.get(x, this.clamp(center.y - radiusLength, 0, height)));
                    rim.add(Coord.get(x, this.clamp(center.y + radiusLength, 0, height)));
                }
                for (int j = center.y - radiusLength; j <= center.y + radiusLength; ++j) {
                    int y = j;
                    if (!surpassEdges) {
                        y = this.clamp(j, 0, height);
                    }
                    rim.add(Coord.get(this.clamp(center.x - radiusLength, 0, height), y));
                    rim.add(Coord.get(this.clamp(center.x + radiusLength, 0, height), y));
                }
                break;
            }
            case DIAMOND: {
                int x;
                int xUp = center.x + radiusLength;
                int xDown = center.x - radiusLength;
                int yUp = center.y + radiusLength;
                int yDown = center.y - radiusLength;
                if (!surpassEdges) {
                    xDown = this.clamp(xDown, 0, width);
                    xUp = this.clamp(xUp, 0, width);
                    yDown = this.clamp(yDown, 0, height);
                    yUp = this.clamp(yUp, 0, height);
                }
                rim.add(Coord.get(xDown, center.y));
                rim.add(Coord.get(xUp, center.y));
                rim.add(Coord.get(center.x, yDown));
                rim.add(Coord.get(center.x, yUp));
                int i = xDown + 1;
                int c = 1;
                while (i < center.x) {
                    x = i;
                    if (!surpassEdges) {
                        x = this.clamp(i, 0, width);
                    }
                    rim.add(Coord.get(x, this.clamp(center.y - c, 0, height)));
                    rim.add(Coord.get(x, this.clamp(center.y + c, 0, height)));
                    ++i;
                    ++c;
                }
                i = center.x + 1;
                c = 1;
                while (i < center.x + radiusLength) {
                    x = i;
                    if (!surpassEdges) {
                        x = this.clamp(i, 0, width);
                    }
                    rim.add(Coord.get(x, this.clamp(center.y + radiusLength - c, 0, height)));
                    rim.add(Coord.get(x, this.clamp(center.y - radiusLength + c, 0, height)));
                    ++i;
                    ++c;
                }
                break;
            }
            default: {
                for (int denom = 1; denom <= 256; denom *= 2) {
                    boolean anySuccesses = false;
                    for (int i = 1; i <= denom; i += 2) {
                        Coord p;
                        float theta = i / denom;
                        int x = (int)((double)TrigTools.cosTurns((float)theta) * ((double)radiusLength + 0.25)) + center.x;
                        int y = (int)((double)TrigTools.sinTurns((float)theta) * ((double)radiusLength + 0.25)) + center.y;
                        if (!surpassEdges) {
                            x = this.clamp(x, 0, width);
                            y = this.clamp(y, 0, height);
                        }
                        boolean test = !rim.contains(p = Coord.get(x, y));
                        rim.add(p);
                        anySuccesses = test || anySuccesses;
                    }
                    if (!anySuccesses) break block0;
                }
            }
        }
        return rim;
    }

    public Coord extend(Coord center, Coord middle, int radiusLength, boolean surpassEdges, int width, int height) {
        if (!(surpassEdges || center.x >= 0 && center.x < width && center.y >= 0 && center.y <= height && middle.x >= 0 && middle.x < width && middle.y >= 0 && middle.y <= height)) {
            return Coord.get(0, 0);
        }
        if (radiusLength < 1) {
            return center;
        }
        float theta = TrigTools.atan2Turns((float)(middle.y - center.y), (float)(middle.x - center.x));
        float cosTheta = TrigTools.cosTurns((float)theta);
        float sinTheta = TrigTools.sinTurns((float)theta);
        Coord end = Coord.get(middle.x, middle.y);
        switch (this) {
            case SQUARE: 
            case DIAMOND: {
                int rad2 = 0;
                if (surpassEdges) {
                    while (this.radius(center.x, center.y, end.x, end.y) < (float)radiusLength) {
                        end = Coord.get(Math.round(cosTheta * (float)(++rad2)) + center.x, Math.round(sinTheta * (float)rad2) + center.y);
                    }
                } else {
                    while (this.radius(center.x, center.y, end.x, end.y) < (float)radiusLength) {
                        end = Coord.get(this.clamp(Math.round(cosTheta * (float)(++rad2)) + center.x, 0, width), this.clamp(Math.round(sinTheta * (float)rad2) + center.y, 0, height));
                        if (end.x != 0 && end.x != width - 1 && end.y != 0 && end.y != height - 1) continue;
                        return end;
                    }
                }
                return end;
            }
        }
        end = Coord.get(this.clamp(Math.round(cosTheta * (float)radiusLength) + center.x, 0, width), this.clamp(Math.round(sinTheta * (float)radiusLength) + center.y, 0, height));
        if (!surpassEdges) {
            long edgeLength;
            if (end.x < 0) {
                edgeLength = Math.round((float)(-center.x) / cosTheta);
                end = end.setY(this.clamp(Math.round(sinTheta * (float)edgeLength) + center.y, 0, height));
            } else if (end.x >= width) {
                edgeLength = Math.round((float)(width - 1 - center.x) / cosTheta);
                end = end.setY(this.clamp(Math.round(sinTheta * (float)edgeLength) + center.y, 0, height));
            }
            if (end.y < 0) {
                edgeLength = Math.round((float)(-center.y) / sinTheta);
                end = end.setX(this.clamp(Math.round(cosTheta * (float)edgeLength) + center.x, 0, width));
            } else if (end.y >= height) {
                edgeLength = Math.round((float)(height - 1 - center.y) / sinTheta);
                end = end.setX(this.clamp(Math.round(cosTheta * (float)edgeLength) + center.x, 0, width));
            }
        }
        return end;
    }

    public boolean inRange(int startx, int starty, int endx, int endy, int minRange, int maxRange) {
        float dist = this.radius(startx, starty, endx, endy);
        return (double)dist >= (double)minRange - 0.001 && (double)dist <= (double)maxRange + 0.001;
    }

    public int roughDistance(int xPos, int yPos) {
        int x = Math.abs(xPos);
        int y = Math.abs(yPos);
        switch (this) {
            case CIRCLE: {
                if (x == y) {
                    return 3 * x;
                }
                if (x < y) {
                    return 3 * x + 2 * (y - x);
                }
                return 3 * y + 2 * (x - y);
            }
            case DIAMOND: {
                return 2 * (x + y);
            }
        }
        return 2 * Math.max(x, y);
    }

    public List<Coord> pointsInside(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height) {
        return this.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, null);
    }

    public List<Coord> pointsInside(Coord center, int radiusLength, boolean surpassEdges, int width, int height) {
        if (center == null) {
            return null;
        }
        return this.pointsInside(center.x, center.y, radiusLength, surpassEdges, width, height, null);
    }

    public List<Coord> pointsInside(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height, List<Coord> buf) {
        ObjectList contents;
        ObjectList objectList = contents = buf == null ? new ObjectList((int)Math.ceil(this.area(radiusLength))) : buf;
        if (!(surpassEdges || centerX >= 0 && centerX < width && centerY >= 0 && centerY < height)) {
            return contents;
        }
        if (radiusLength < 1) {
            contents.add(Coord.get(centerX, centerY));
            return contents;
        }
        switch (this) {
            case SQUARE: {
                for (int i = centerX - radiusLength; i <= centerX + radiusLength; ++i) {
                    for (int j = centerY - radiusLength; j <= centerY + radiusLength; ++j) {
                        if (!surpassEdges && (i < 0 || j < 0 || i >= width || j >= height)) continue;
                        contents.add(Coord.get(i, j));
                    }
                }
                break;
            }
            case DIAMOND: {
                for (int i = centerX - radiusLength; i <= centerX + radiusLength; ++i) {
                    for (int j = centerY - radiusLength; j <= centerY + radiusLength; ++j) {
                        if (Math.abs(centerX - i) + Math.abs(centerY - j) > radiusLength || !surpassEdges && (i < 0 || j < 0 || i >= width || j >= height)) continue;
                        contents.add(Coord.get(i, j));
                    }
                }
                break;
            }
            default: {
                for (int dx = -radiusLength; dx <= radiusLength; ++dx) {
                    float changedX = (float)dx - 0.25f * (float)(dx >> 31 | -dx >>> 31);
                    int rndX = Math.round(changedX);
                    float high = (float)Math.sqrt((float)(radiusLength * radiusLength) - changedX * changedX);
                    if (surpassEdges || centerX + rndX >= 0 && centerX + rndX < width) {
                        contents.add(Coord.get(centerX + rndX, centerY));
                    }
                    for (float dy = high; dy >= 0.75f; dy -= 1.0f) {
                        int rndY = Math.round(dy - 0.25f);
                        if (surpassEdges || centerX + rndX >= 0 && centerY + rndY >= 0 && centerX + rndX < width && centerY + rndY < height) {
                            contents.add(Coord.get(centerX + rndX, centerY + rndY));
                        }
                        if (!surpassEdges && (centerX + rndX < 0 || centerY - rndY < 0 || centerX + rndX >= width || centerY - rndY >= height)) continue;
                        contents.add(Coord.get(centerX + rndX, centerY - rndY));
                    }
                }
            }
        }
        return contents;
    }

    public static List<Coord> inSquare(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height) {
        return SQUARE.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, null);
    }

    public static List<Coord> inDiamond(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height) {
        return DIAMOND.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, null);
    }

    public static List<Coord> inCircle(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height) {
        return CIRCLE.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, null);
    }

    public static List<Coord> inSquare(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height, List<Coord> buf) {
        return SQUARE.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, buf);
    }

    public static List<Coord> inDiamond(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height, List<Coord> buf) {
        return DIAMOND.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, buf);
    }

    public static List<Coord> inCircle(int centerX, int centerY, int radiusLength, boolean surpassEdges, int width, int height, List<Coord> buf) {
        return CIRCLE.pointsInside(centerX, centerY, radiusLength, surpassEdges, width, height, buf);
    }

    public CoordOrderedSet expand(int distance, int width, int height, Iterable<Coord> points) {
        List<Coord> around = this.pointsInside(Coord.get(distance, distance), distance, false, width, height);
        CoordOrderedSet expanded = new CoordOrderedSet(around.size() * 16, 0.25f);
        for (Coord pt : points) {
            for (Coord ar : around) {
                int tx = pt.x + ar.x - distance;
                int ty = pt.y + ar.y - distance;
                if (tx < 0 || tx >= width || ty < 0 || ty >= height) continue;
                expanded.add(Coord.get(tx, ty));
            }
        }
        return expanded;
    }

    public Measurement matchingMeasurement() {
        switch (this) {
            case SQUARE: {
                return Measurement.CHEBYSHEV;
            }
            case DIAMOND: {
                return Measurement.MANHATTAN;
            }
        }
        return Measurement.EUCLIDEAN;
    }

    static {
        ALL = Radius.values();
    }
}

