/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.ArrayTools;
import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ObjectOrderedSet;
import com.github.tommyettinger.random.EnhancedRandom;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.LZSEncoding;
import com.github.yellowstonegames.core.StringTools;
import com.github.yellowstonegames.grid.BlueNoise;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.HilbertCurve;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Region
implements Collection<Coord> {
    public long[] data;
    public int height;
    public int width;
    private int ySections;
    private long yEndMask;
    private boolean tallied;
    private int ct;
    private int[] counts;
    public static final Region[] BLUE_LEVELS = new Region[256];

    public Region() {
        this.width = 64;
        this.height = 64;
        this.ySections = 1;
        this.yEndMask = -1L;
        this.data = new long[64];
        this.counts = new int[64];
        this.ct = 0;
        this.tallied = true;
    }

    public Region(boolean[][] bits) {
        this.width = bits.length;
        this.height = bits[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        int x = 0;
        int xs = 0;
        while (x < this.width) {
            for (int y = 0; y < this.height; ++y) {
                if (!bits[x][y]) continue;
                int n = xs + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
            ++x;
            xs += this.ySections;
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(boolean[][] map) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (map[x][y] ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!map[x][y]) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(char[][] map, char yes) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[x][y] != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(char[][] map, char yes) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (map[x][y] == yes ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[x][y] != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(char[][] map, char[] yes) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            block1: for (int y = 0; y < this.height; ++y) {
                for (char e : yes) {
                    if (map[x][y] != e) continue;
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | 1L << (y & 0x3F);
                    continue block1;
                }
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(char[][] map, char[] yes) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                block1: for (int y = 0; y < this.height; ++y) {
                    for (char e : yes) {
                        if (map[x][y] != e) continue;
                        int n = x * this.ySections + (y >> 6);
                        this.data[n] = this.data[n] | 1L << (y & 0x3F);
                        continue block1;
                    }
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            block4: for (int y = 0; y < this.height; ++y) {
                for (char e : yes) {
                    if (map[x][y] != e) continue;
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | 1L << (y & 0x3F);
                    continue block4;
                }
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(String[] map, char yes) {
        this.height = map.length;
        this.width = map[0].length();
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[y].charAt(x) != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(String[] map, char yes) {
        if (map != null && map.length > 0 && this.height == map.length && this.width == map[0].length()) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (map[y].charAt(x) == yes ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.height = map == null ? 0 : map.length;
        this.width = map == null || map.length <= 0 ? 0 : map[0].length();
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[y].charAt(y) != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(int[][] map, int yes) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[x][y] != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(int[][] map, int yes) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (map[x][y] == yes ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (map[x][y] != yes) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(int[][] map, int lower, int upper) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            int[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(int[][] map, int lower, int upper) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                int[] column = map[x];
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (column[y] >= lower && column[y] < upper ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            int[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(byte[][] map, int lower, int upper) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            byte[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(byte[][] map, int lower, int upper) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                byte[] column = map[x];
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (column[y] >= lower && column[y] < upper ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            byte[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(short[][] map, int lower, int upper) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            short[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(short[][] map, int lower, int upper) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                short[] column = map[x];
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (column[y] >= lower && column[y] < upper ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            short[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (column[y] < lower || column[y] >= upper) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(float[][] map, float upperBound) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(map[x][y] <= upperBound)) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(float[][] map, float upperBound) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (!(map[x][y] <= upperBound)) continue;
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | 1L << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(map[x][y] <= upperBound)) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(float[][] map, float lowerBound, float upperBound) {
        this.width = map.length;
        this.height = map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!(map[x][y] >= lowerBound) || !(map[x][y] < upperBound)) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(float[][] map, float lower, float upper) {
        if (map != null && map.length > 0 && this.width == map.length && this.height == map[0].length) {
            Arrays.fill(this.data, 0L);
            for (int x = 0; x < this.width; ++x) {
                float[] column = map[x];
                for (int y = 0; y < this.height; ++y) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | (column[y] >= lower && column[y] < upper ? 1L : 0L) << (y & 0x3F);
                }
            }
            this.tallied = false;
            return this;
        }
        this.width = map == null ? 0 : map.length;
        this.height = map == null || map.length <= 0 ? 0 : map[0].length;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        for (int x = 0; x < this.width; ++x) {
            float[] column = map[x];
            for (int y = 0; y < this.height; ++y) {
                if (!(column[y] >= lower) || !(column[y] < upper)) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(float[][] map, float lowerBound, float upperBound, int scale) {
        scale = Math.min(63, Math.max(1, scale));
        int baseWidth = map.length;
        int baseHeight = map[0].length;
        this.width = baseWidth * scale;
        this.height = baseHeight * scale;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        long shape = (1L << scale) - 1L;
        int bx = 0;
        int x = 0;
        while (bx < baseWidth) {
            int by = 0;
            int y = 0;
            while (by < baseHeight) {
                if (map[bx][by] >= lowerBound && map[bx][by] < upperBound) {
                    for (int i = 0; i < scale; ++i) {
                        int n = (x + i) * this.ySections + (y >> 6);
                        this.data[n] = this.data[n] | shape << (y & 0x3F);
                        long leftover = (y + scale - 1 & 0x3F) + 1;
                        if (leftover >= (long)((y & 0x3F) + 1) || (long)y + leftover >> 6 >= (long)this.ySections) continue;
                        int n2 = (x + i) * this.ySections + (y >> 6) + 1;
                        this.data[n2] = this.data[n2] | (1L << (int)leftover) - 1L;
                    }
                }
                ++by;
                y += scale;
            }
            ++bx;
            x += scale;
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
    }

    public Region refill(float[][] map, float lowerBound, float upperBound, int scale) {
        scale = Math.min(63, Math.max(1, scale));
        if (map != null && map.length > 0 && this.width == map.length * scale && this.height == map[0].length * scale) {
            Arrays.fill(this.data, 0L);
            int baseWidth = map.length;
            int baseHeight = map[0].length;
            long shape = (1L << scale) - 1L;
            int bx = 0;
            int x = 0;
            while (bx < baseWidth) {
                float[] column = map[bx];
                int by = 0;
                int y = 0;
                while (by < baseHeight) {
                    if (column[by] >= lowerBound && column[by] < upperBound) {
                        for (int i = 0; i < scale; ++i) {
                            int n = (x + i) * this.ySections + (y >> 6);
                            this.data[n] = this.data[n] | shape << (y & 0x3F);
                            long leftover = (y + scale - 1 & 0x3F) + 1;
                            if (leftover >= (long)((y & 0x3F) + 1) || (long)y + leftover >> 6 >= (long)this.ySections) continue;
                            int n2 = (x + i) * this.ySections + (y >> 6) + 1;
                            this.data[n2] = this.data[n2] | (1L << (int)leftover) - 1L;
                        }
                    }
                    ++by;
                    y += scale;
                }
                ++bx;
                x += scale;
            }
            this.tallied = false;
            return this;
        }
        int baseWidth = map == null ? 0 : map.length;
        int baseHeight = map == null || map.length <= 0 ? 0 : map[0].length;
        this.width = baseWidth * scale;
        this.height = baseHeight * scale;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        long shape = (1L << scale) - 1L;
        int bx = 0;
        int x = 0;
        while (bx < baseWidth) {
            int by = 0;
            int y = 0;
            while (by < baseHeight) {
                if (map[bx][by] >= lowerBound && map[bx][by] < upperBound) {
                    for (int i = 0; i < scale; ++i) {
                        int n = (x + i) * this.ySections + (y >> 6);
                        this.data[n] = this.data[n] | shape << (y & 0x3F);
                        long leftover = y + scale - 1 & 0x3F;
                        if (leftover >= (long)y || (long)y >= (long)this.height - leftover) continue;
                        int n3 = (x + i) * this.ySections + (y >> 6) + 1;
                        this.data[n3] = this.data[n3] | (1L << (int)leftover) - 1L;
                    }
                }
                ++by;
                y += scale;
            }
            ++bx;
            x += scale;
        }
        this.counts = new int[this.width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(boolean[] bits, int width, int height) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        int a = 0;
        int x = 0;
        int y = 0;
        while (a < bits.length) {
            if (bits[a]) {
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
            x = ++a / height;
            y = a % height;
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region refill(boolean[] bits, int width, int height) {
        if (bits != null && this.width == width && this.height == height) {
            Arrays.fill(this.data, 0L);
            int a = 0;
            int x = 0;
            int y = 0;
            while (a < bits.length) {
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | (bits[a] ? 1L : 0L) << (y & 0x3F);
                x = ++a / height;
                y = a % height;
            }
            this.tallied = false;
            return this;
        }
        this.width = bits == null || width < 0 ? 0 : width;
        this.height = bits == null || bits.length <= 0 || height < 0 ? 0 : height;
        this.ySections = this.height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
        this.data = new long[this.width * this.ySections];
        if (bits != null) {
            int a = 0;
            int x = 0;
            int y = 0;
            while (a < bits.length) {
                if (bits[a]) {
                    int n = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | 1L << (y & 0x3F);
                }
                x = ++a / this.height;
                y = a % this.height;
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
        return this;
    }

    public Region(int width, int height) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        this.counts = new int[width * this.ySections];
        this.ct = 0;
        this.tallied = true;
    }

    public Region resizeAndEmpty(int width, int height) {
        if (width == this.width && height == this.height) {
            Arrays.fill(this.data, 0L);
            Arrays.fill(this.counts, 0);
            this.ct = 0;
            this.tallied = true;
        } else {
            this.width = Math.max(width, 0);
            this.height = Math.max(height, 0);
            this.ySections = this.height + 63 >> 6;
            this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
            this.data = new long[this.width * this.ySections];
            this.counts = new int[this.width * this.ySections];
            this.ct = 0;
            this.tallied = true;
        }
        return this;
    }

    public Region(Coord single, int width, int height) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        this.counts = new int[width * this.ySections];
        if (single.x < width && single.y < height && single.x >= 0 && single.y >= 0) {
            this.ct = single.x * this.ySections + (single.y >> 6);
            this.data[this.ct] = this.data[this.ct] | 1L << (single.y & 0x3F);
            this.counts[this.ct] = 1;
            this.ct = 1;
            this.tallied = true;
        } else {
            this.ct = 0;
            this.tallied = true;
        }
    }

    public Region(int width, int height, Coord ... points) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        if (points != null) {
            for (int i = 0; i < points.length; ++i) {
                int x = points[i].x;
                int y = points[i].y;
                if (x >= width || y >= height || x < 0 || y < 0) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region(int width, int height, Iterable<Coord> points) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        if (points != null) {
            for (Coord c : points) {
                int x = c.x;
                int y = c.y;
                if (x >= width || y >= height || x < 0 || y < 0) continue;
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region(EnhancedRandom random, int width, int height) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        for (int i = 0; i < width * this.ySections; ++i) {
            this.data[i] = random.nextLong();
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region refill(EnhancedRandom random, int width, int height) {
        if (random != null) {
            int i;
            if (this.width == width && this.height == height) {
                for (i = 0; i < width * this.ySections; ++i) {
                    this.data[i] = random.nextLong();
                }
            } else {
                this.width = Math.max(width, 0);
                this.height = Math.max(height, 0);
                this.ySections = this.height + 63 >> 6;
                this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
                this.data = new long[this.width * this.ySections];
                for (i = 0; i < this.width * this.ySections; ++i) {
                    this.data[i] = random.nextLong();
                }
                this.counts = new int[width * this.ySections];
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                    int n = a;
                    this.data[n] = this.data[n] & this.yEndMask;
                }
            }
            this.tallied = false;
        }
        return this;
    }

    public Region(EnhancedRandom random, float fraction, int width, int height) {
        this.width = width;
        this.height = height;
        int bitCount = (int)(fraction * 64.0f);
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        for (int i = 0; i < width * this.ySections; ++i) {
            this.data[i] = Region.approximateBits(random, bitCount);
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region refill(EnhancedRandom random, float fraction, int width, int height) {
        if (random != null) {
            int i;
            int bitCount = (int)(fraction * 64.0f);
            if (this.width == width && this.height == height) {
                for (i = 0; i < width * this.ySections; ++i) {
                    this.data[i] = Region.approximateBits(random, bitCount);
                }
            } else {
                this.width = Math.max(width, 0);
                this.height = Math.max(height, 0);
                this.ySections = this.height + 63 >> 6;
                this.yEndMask = -1L >>> 64 - (this.height & 0x3F);
                this.data = new long[this.width * this.ySections];
                for (i = 0; i < this.width * this.ySections; ++i) {
                    this.data[i] = Region.approximateBits(random, bitCount);
                }
                this.counts = new int[width * this.ySections];
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                    int n = a;
                    this.data[n] = this.data[n] & this.yEndMask;
                }
            }
        }
        this.tallied = false;
        return this;
    }

    public Region(Region other) {
        this.width = other.width;
        this.height = other.height;
        this.ySections = other.ySections;
        this.yEndMask = other.yEndMask;
        this.data = new long[this.width * this.ySections];
        this.counts = new int[this.width * this.ySections];
        System.arraycopy(other.data, 0, this.data, 0, this.width * this.ySections);
        System.arraycopy(other.counts, 0, this.counts, 0, this.width * this.ySections);
        this.ct = other.ct;
        this.tallied = other.tallied;
    }

    public Region(long[] data2, int width, int height) {
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        System.arraycopy(data2, 0, this.data, 0, width * this.ySections);
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region(long[] data2, int dataWidth, int dataHeight, int width, int height) {
        int j;
        int i;
        this.width = width;
        this.height = height;
        this.ySections = height + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (height & 0x3F);
        this.data = new long[width * this.ySections];
        int ySections2 = dataHeight + 63 >> 6;
        if (ySections2 == 0) {
            this.counts = new int[0];
            this.tallied = false;
            return;
        }
        if (this.ySections == 1) {
            System.arraycopy(data2, 0, this.data, 0, Math.min(dataWidth, width));
        } else if (dataHeight >= height) {
            i = 0;
            j = 0;
            while (i < width && i < dataWidth) {
                System.arraycopy(data2, i, this.data, j, this.ySections);
                i += ySections2;
                j += this.ySections;
            }
        } else {
            i = 0;
            j = 0;
            while (i < width && i < dataWidth) {
                System.arraycopy(data2, i, this.data, j, ySections2);
                i += ySections2;
                j += this.ySections;
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.counts = new int[width * this.ySections];
        this.tallied = false;
    }

    public Region refill(long[] data2, int dataWidth, int dataHeight, int width, int height) {
        int j;
        int i;
        if (width != this.width || height != this.height) {
            this.width = width;
            this.height = height;
            this.ySections = height + 63 >> 6;
            this.yEndMask = -1L >>> 64 - (height & 0x3F);
            this.data = new long[width * this.ySections];
            this.counts = new int[width * this.ySections];
        } else {
            Arrays.fill(this.data, 0L);
        }
        int ySections2 = dataHeight + 63 >> 6;
        if (ySections2 == 0) {
            return this;
        }
        if (this.ySections == 1) {
            System.arraycopy(data2, 0, this.data, 0, Math.min(dataWidth, width));
        } else if (dataHeight >= height) {
            i = 0;
            j = 0;
            while (i < width && i < dataWidth) {
                System.arraycopy(data2, i, this.data, j, this.ySections);
                i += ySections2;
                j += this.ySections;
            }
        } else {
            i = 0;
            j = 0;
            while (i < width && i < dataWidth) {
                System.arraycopy(data2, i, this.data, j, ySections2);
                i += ySections2;
                j += this.ySections;
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region remake(Region other) {
        if (this.width == other.width && this.height == other.height) {
            System.arraycopy(other.data, 0, this.data, 0, this.width * this.ySections);
            System.arraycopy(other.counts, 0, this.counts, 0, this.width * this.ySections);
            this.ct = other.ct;
            this.tallied = other.tallied;
            return this;
        }
        this.width = other.width;
        this.height = other.height;
        this.ySections = other.ySections;
        this.yEndMask = other.yEndMask;
        this.data = new long[this.width * this.ySections];
        this.counts = new int[this.width * this.ySections];
        System.arraycopy(other.data, 0, this.data, 0, this.width * this.ySections);
        System.arraycopy(other.counts, 0, this.counts, 0, this.width * this.ySections);
        this.ct = other.ct;
        this.tallied = other.tallied;
        return this;
    }

    public Region alterBounds(int widthChange, int heightChange) {
        int newWidth = this.width + widthChange;
        int newHeight = this.height + heightChange;
        if (newWidth <= 0 || newHeight <= 0) {
            this.width = 0;
            this.height = 0;
            this.ySections = 0;
            this.yEndMask = -1L;
            this.data = new long[0];
            this.counts = new int[0];
            this.ct = 0;
            this.tallied = true;
            return this;
        }
        int newYSections = newHeight + 63 >> 6;
        this.yEndMask = -1L >>> 64 - (newHeight & 0x3F);
        long[] newData = new long[newWidth * newYSections];
        this.counts = new int[newWidth * newYSections];
        for (int x = 0; x < this.width && x < newWidth; ++x) {
            for (int ys = 0; ys < this.ySections && ys < newYSections; ++ys) {
                newData[x * newYSections + ys] = this.data[x * this.ySections + ys];
            }
        }
        this.ySections = newYSections;
        this.width = newWidth;
        this.height = newHeight;
        this.data = newData;
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    private void tally() {
        this.ct = 0;
        for (int i = 0; i < this.counts.length; ++i) {
            int n;
            int tmp = Long.bitCount(this.data[i]);
            if (tmp == 0) {
                n = 0;
            } else {
                n = this.ct + tmp;
                this.ct = this.ct;
            }
            this.counts[i] = n;
        }
        this.tallied = true;
    }

    public Region copyRotated(int turns) {
        switch (turns & 3) {
            case 0: {
                return this.copy();
            }
            case 1: {
                Region next = new Region(this.height, this.width);
                for (int x = 0; x < this.width; ++x) {
                    int y = 0;
                    int iy = this.height - 1;
                    while (y < this.height) {
                        if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L) {
                            int n = iy * this.ySections + (x >> 6);
                            next.data[n] = next.data[n] | 1L << (x & 0x3F);
                        }
                        ++y;
                        --iy;
                    }
                }
                return next;
            }
            case 2: {
                Region next = new Region(this.width, this.height);
                int x = 0;
                int ix = this.width - 1;
                while (x < this.width) {
                    int y = 0;
                    int iy = this.height - 1;
                    while (y < this.height) {
                        if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L) {
                            int n = ix * this.ySections + (iy >> 6);
                            next.data[n] = next.data[n] | 1L << (iy & 0x3F);
                        }
                        ++y;
                        --iy;
                    }
                    ++x;
                    --ix;
                }
                return next;
            }
        }
        Region next = new Region(this.height, this.width);
        int x = 0;
        int ix = this.width - 1;
        while (x < this.width) {
            for (int y = 0; y < this.height; ++y) {
                if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L) continue;
                int n = y * this.ySections + (ix >> 6);
                next.data[n] = next.data[n] | 1L << (ix & 0x3F);
            }
            ++x;
            --ix;
        }
        return next;
    }

    public Region flip(boolean leftRight, boolean upDown) {
        block13: {
            long t;
            int x;
            if (this.ySections <= 0) {
                return this;
            }
            if (leftRight) {
                x = 0;
                int o = this.width - 1;
                while (x < this.width >>> 1) {
                    for (int y = 0; y < this.ySections; ++y) {
                        t = this.data[x * this.ySections + y];
                        this.data[x * this.ySections + y] = this.data[o * this.ySections + y];
                        this.data[o * this.ySections + y] = t;
                    }
                    ++x;
                    --o;
                }
            }
            if (!upDown) break block13;
            if (this.yEndMask == -1L) {
                for (x = 0; x < this.width; ++x) {
                    int y = 0;
                    int o = this.ySections - 1;
                    while (y < this.ySections >>> 1) {
                        t = Long.reverse(this.data[x * this.ySections + y]);
                        this.data[x * this.ySections + y] = Long.reverse(this.data[x * this.ySections + o]);
                        this.data[x * this.ySections + o] = t;
                        ++y;
                        --o;
                    }
                    if ((this.ySections & 1) != 1) continue;
                    this.data[x * this.ySections + (this.ySections >>> 1)] = Long.reverse(this.data[x * this.ySections + (this.ySections >>> 1)]);
                }
            } else {
                int shift = Long.numberOfLeadingZeros(this.yEndMask);
                if (this.ySections == 1) {
                    for (int x2 = 0; x2 < this.width; ++x2) {
                        this.data[x2] = Long.reverse(this.data[x2]) >>> shift;
                    }
                } else {
                    for (int x3 = 0; x3 < this.width; ++x3) {
                        int ie = x3 * this.ySections + this.ySections - 1;
                        int ib = x3 * this.ySections + this.ySections - 2;
                        int il = x3 * this.ySections + 1;
                        int is = x3 * this.ySections;
                        long end = Long.reverse(this.data[ie]);
                        long big = Long.reverse(this.data[ib]);
                        long little = Long.reverse(this.data[il]);
                        long start = Long.reverse(this.data[is]);
                        this.data[ie] = start >>> shift;
                        this.data[is] = end >>> shift;
                        int n = is;
                        this.data[n] = this.data[n] | big << 64 - shift;
                        this.data[ib] = start << 64 - shift;
                        int n2 = ib;
                        this.data[n2] = this.data[n2] | little >>> shift;
                        for (int y = 1; y < this.ySections >>> 1; ++y) {
                            end = big;
                            start = little;
                            big = Long.reverse(this.data[--ib]);
                            little = Long.reverse(this.data[++il]);
                            this.data[++is] = end >>> shift;
                            int n3 = is;
                            this.data[n3] = this.data[n3] | big << 64 - shift;
                            this.data[ib] = start << 64 - shift;
                            int n4 = ib;
                            this.data[n4] = this.data[n4] | little >>> shift;
                        }
                    }
                }
            }
        }
        return this;
    }

    public Region set(boolean value, int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            if (value) {
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] | 1L << (y & 0x3F);
            } else {
                int n = x * this.ySections + (y >> 6);
                this.data[n] = this.data[n] & (1L << (y & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.tallied = false;
        }
        return this;
    }

    public Region set(boolean value, Coord point) {
        if (point == null) {
            return this;
        }
        return this.set(value, point.x, point.y);
    }

    public Region insert(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] | 1L << (y & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region insert(int tight) {
        if (tight < this.width * this.height && tight >= 0) {
            int n = tight % this.width * this.ySections + (tight / this.width >>> 6);
            this.data[n] = this.data[n] | 1L << (tight / this.width & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region insert(Coord point) {
        if (point == null) {
            return this;
        }
        return this.insert(point.x, point.y);
    }

    public Region insert(int x, int y, Region other) {
        long tmp;
        int j;
        long prev;
        int jj;
        int j2;
        int oi;
        int i;
        if (other == null || other.ySections <= 0 || other.width <= 0) {
            return this;
        }
        int start = Math.max(0, x);
        int len = Math.min(this.width, Math.min(other.width, other.width + x) - start);
        int oys = other.ySections;
        int jump = y == 0 ? 0 : (y < 0 ? -(-y >>> 6) : y >>> 6);
        int lily = y < 0 ? -(-y & 0x3F) : y & 0x3F;
        int originalJump = Math.max(0, -jump);
        int alterJump = Math.max(0, jump);
        long[] data2 = new long[other.width * this.ySections];
        if (oys == this.ySections) {
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = other.data[j2 * this.ySections + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = other.data[j2 * this.ySections + oi];
                    }
                }
            }
        } else if (oys < this.ySections) {
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = other.data[j2 * oys + oi];
                    }
                }
            }
        } else if (x < 0) {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                j2 = Math.max(0, -x);
                for (jj = 0; jj < len; ++jj) {
                    data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                    ++j2;
                }
            }
        } else if (x > 0) {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                j2 = 0;
                jj = start;
                while (j2 < len) {
                    data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                    ++j2;
                    ++jj;
                }
            }
        } else {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                for (j2 = 0; j2 < len; ++j2) {
                    data2[j2 * this.ySections + i] = other.data[j2 * oys + oi];
                }
            }
        }
        if (lily < 0) {
            for (i = start; i < len; ++i) {
                prev = 0L;
                for (j = 0; j < this.ySections; ++j) {
                    tmp = prev;
                    prev = (data2[i * this.ySections + j] & (-1L << -lily ^ 0xFFFFFFFFFFFFFFFFL)) << 64 + lily;
                    int n = i * this.ySections + j;
                    data2[n] = data2[n] >>> -lily;
                    int n2 = i * this.ySections + j;
                    data2[n2] = data2[n2] | tmp;
                }
            }
        } else if (lily > 0) {
            for (i = start; i < start + len; ++i) {
                prev = 0L;
                for (j = 0; j < this.ySections; ++j) {
                    tmp = prev;
                    prev = (data2[i * this.ySections + j] & (-1L >>> lily ^ 0xFFFFFFFFFFFFFFFFL)) >>> 64 - lily;
                    int n = i * this.ySections + j;
                    data2[n] = data2[n] << lily;
                    int n3 = i * this.ySections + j;
                    data2[n3] = data2[n3] | tmp;
                }
            }
        }
        len = Math.min(this.width, start + len);
        for (i = start; i < len; ++i) {
            for (j = 0; j < this.ySections; ++j) {
                int n = i * this.ySections + j;
                this.data[n] = this.data[n] | data2[i * this.ySections + j];
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region insertSeveral(Coord ... points) {
        for (int i = 0; i < points.length; ++i) {
            int x = points[i].x;
            int y = points[i].y;
            if (x >= this.width || y >= this.height || x < 0 || y < 0) continue;
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] | 1L << (y & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region insertSeveral(int[] points) {
        for (int i = 0; i < points.length; ++i) {
            int tight = points[i];
            if (tight >= this.width * this.height || tight < 0) continue;
            int n = tight % this.width * this.ySections + (tight / this.width >>> 6);
            this.data[n] = this.data[n] | 1L << (tight / this.width & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region insertSeveral(Iterable<Coord> points) {
        for (Coord pt : points) {
            int x = pt.x;
            int y = pt.y;
            if (x >= this.width || y >= this.height || x < 0 || y < 0) continue;
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] | 1L << (y & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region insertRectangle(int startX, int startY, int rectangleWidth, int rectangleHeight) {
        if (rectangleWidth < 1 || rectangleHeight < 1 || this.ySections <= 0) {
            return this;
        }
        if (startX < 0) {
            startX = 0;
        } else if (startX >= this.width) {
            startX = this.width - 1;
        }
        if (startY < 0) {
            startY = 0;
        } else if (startY >= this.height) {
            startY = this.height - 1;
        }
        int endX = Math.min(this.width, startX + rectangleWidth) - 1;
        int endY = Math.min(this.height, startY + rectangleHeight) - 1;
        int startSection = startY >> 6;
        int endSection = endY >> 6;
        if (startSection < endSection) {
            int a;
            long startMask = -1L << (startY & 0x3F);
            long endMask = -1L >>> (~endY & 0x3F);
            for (a = startX * this.ySections + startSection; a <= endX * this.ySections + startSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] | startMask;
            }
            if (endSection - startSection > 1) {
                for (int b = 1; b < endSection - startSection; ++b) {
                    for (int a2 = startX * this.ySections + startSection + b; a2 < endX * this.ySections + this.ySections; a2 += this.ySections) {
                        this.data[a2] = -1L;
                    }
                }
            }
            for (a = startX * this.ySections + endSection; a <= endX * this.ySections + endSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] | endMask;
            }
        } else {
            long mask = -1L << (startY & 0x3F) & -1L >>> (~endY & 0x3F);
            for (int a = startX * this.ySections + startSection; a <= endX * this.ySections + startSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] | mask;
            }
        }
        if (this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region insertCircle(Coord center, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            float changedX = (float)dx - 0.25f * (float)(dx >> 31 | -dx >>> 31);
            int rndX = Math.round(changedX);
            float high = (float)Math.sqrt((float)(radius * radius) - changedX * changedX);
            this.insert(center.x + rndX, center.y);
            for (float dy = high; dy >= 0.75f; dy -= 1.0f) {
                int rndY = Math.round(dy - 0.25f);
                this.insert(center.x + rndX, center.y + rndY);
                this.insert(center.x + rndX, center.y - rndY);
            }
        }
        return this;
    }

    public Region remove(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] & (1L << (y & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            this.tallied = false;
        }
        return this;
    }

    public Region remove(Coord point) {
        return this.remove(point.x, point.y);
    }

    public Region remove(int x, int y, Region other) {
        long tmp;
        int j;
        long prev;
        int jj;
        int j2;
        int oi;
        int i;
        if (other == null || other.ySections <= 0 || other.width <= 0) {
            return this;
        }
        int start = Math.max(0, x);
        int len = Math.min(this.width, Math.min(other.width, other.width + x) - start);
        int oys = other.ySections;
        int jump = y == 0 ? 0 : (y < 0 ? -(-y >>> 6) : y - 1 >>> 6);
        int lily = y < 0 ? -(-y & 0x3F) : y & 0x3F;
        int originalJump = Math.max(0, -jump);
        int alterJump = Math.max(0, jump);
        long[] data2 = new long[other.width * this.ySections];
        if (oys == this.ySections) {
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = other.data[j2 * this.ySections + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = other.data[j2 * this.ySections + oi];
                    }
                }
            }
        } else if (oys < this.ySections) {
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = other.data[j2 * oys + oi];
                    }
                }
            }
        } else if (x < 0) {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                j2 = Math.max(0, -x);
                for (jj = 0; jj < len; ++jj) {
                    data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                    ++j2;
                }
            }
        } else if (x > 0) {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                j2 = 0;
                jj = start;
                while (j2 < len) {
                    data2[jj * this.ySections + i] = other.data[j2 * oys + oi];
                    ++j2;
                    ++jj;
                }
            }
        } else {
            i = alterJump;
            for (oi = originalJump; i < this.ySections && oi < oys; ++i, ++oi) {
                for (j2 = 0; j2 < len; ++j2) {
                    data2[j2 * this.ySections + i] = other.data[j2 * oys + oi];
                }
            }
        }
        if (lily < 0) {
            for (i = start; i < len; ++i) {
                prev = 0L;
                for (j = 0; j < this.ySections; ++j) {
                    tmp = prev;
                    prev = (data2[i * this.ySections + j] & (-1L << -lily ^ 0xFFFFFFFFFFFFFFFFL)) << 64 + lily;
                    int n = i * this.ySections + j;
                    data2[n] = data2[n] >>> -lily;
                    int n2 = i * this.ySections + j;
                    data2[n2] = data2[n2] | tmp;
                }
            }
        } else if (lily > 0) {
            for (i = start; i < start + len; ++i) {
                prev = 0L;
                for (j = 0; j < this.ySections; ++j) {
                    tmp = prev;
                    prev = (data2[i * this.ySections + j] & (-1L >>> lily ^ 0xFFFFFFFFFFFFFFFFL)) >>> 64 - lily;
                    int n = i * this.ySections + j;
                    data2[n] = data2[n] << lily;
                    int n3 = i * this.ySections + j;
                    data2[n3] = data2[n3] | tmp;
                }
            }
        }
        len = Math.min(this.width, start + len);
        for (i = start; i < len; ++i) {
            for (j = 0; j < this.ySections; ++j) {
                int n = i * this.ySections + j;
                this.data[n] = this.data[n] & (data2[i * this.ySections + j] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region removeSeveral(Coord ... points) {
        for (int i = 0; i < points.length; ++i) {
            int x = points[i].x;
            int y = points[i].y;
            if (x >= this.width || y >= this.height || x < 0 || y < 0) continue;
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] & (1L << (y & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            this.tallied = false;
        }
        return this;
    }

    public Region removeSeveral(Iterable<Coord> points) {
        for (Coord pt : points) {
            int x = pt.x;
            int y = pt.y;
            if (x >= this.width || y >= this.height || x < 0 || y < 0) continue;
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] & (1L << (y & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
            this.tallied = false;
        }
        return this;
    }

    public Region removeRectangle(int startX, int startY, int rectangleWidth, int rectangleHeight) {
        if (startX < 0) {
            rectangleWidth += startX;
            startX = 0;
        } else if (startX >= this.width) {
            rectangleWidth = 1;
            startX = this.width - 1;
        }
        if (startY < 0) {
            rectangleHeight += startY;
            startY = 0;
        } else if (startY >= this.height) {
            rectangleHeight = 1;
            startY = this.height - 1;
        }
        if (rectangleWidth < 1 || rectangleHeight < 1 || this.ySections <= 0) {
            return this;
        }
        int endX = Math.min(this.width, startX + rectangleWidth) - 1;
        int startSection = startY >> 6;
        int endY = Math.min(this.height, startY + rectangleHeight) - 1;
        int endSection = endY >> 6;
        if (startSection < endSection) {
            int a;
            long startMask = -1L << (startY & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
            long endMask = -1L >>> (~endY & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
            for (a = startX * this.ySections + startSection; a <= endX * this.ySections + startSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & startMask;
            }
            if (endSection - startSection > 1) {
                for (int b = 1; b < endSection - startSection; ++b) {
                    for (int a2 = startX * this.ySections + startSection + b; a2 < endX * this.ySections + this.ySections; a2 += this.ySections) {
                        this.data[a2] = 0L;
                    }
                }
            }
            for (a = startX * this.ySections + endSection; a <= endX * this.ySections + endSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & endMask;
            }
        } else {
            long mask = -1L << (startY & 0x3F) & -1L >>> (~endY & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
            for (int a = startX * this.ySections + startSection; a <= endX * this.ySections + startSection; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & mask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region removeCircle(Coord center, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            float changedX = (float)dx - 0.25f * (float)(dx >> 31 | -dx >>> 31);
            int rndX = Math.round(changedX);
            float high = (float)Math.sqrt((float)(radius * radius) - changedX * changedX);
            this.remove(center.x + rndX, center.y);
            for (float dy = high; dy >= 0.75f; dy -= 1.0f) {
                int rndY = Math.round(dy - 0.25f);
                this.remove(center.x + rndX, center.y + rndY);
                this.remove(center.x + rndX, center.y - rndY);
            }
        }
        return this;
    }

    public Region empty() {
        Arrays.fill(this.data, 0L);
        Arrays.fill(this.counts, 0);
        this.ct = 0;
        this.tallied = true;
        return this;
    }

    public Region allOn() {
        if (this.ySections > 0) {
            if (this.yEndMask == -1L) {
                Arrays.fill(this.data, -1L);
                Arrays.fill(this.counts, 64);
                this.ct = this.ySections * this.width << 6;
                this.tallied = true;
            } else {
                this.ct = Long.bitCount(this.yEndMask);
                for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                    this.data[a] = this.yEndMask;
                    this.counts[a] = this.ct;
                    for (int i = 0; i < this.ySections - 1; ++i) {
                        this.data[a - i - 1] = -1L;
                        this.counts[a - i - 1] = 64;
                    }
                }
                this.ct *= this.width;
                this.ct += (this.ySections - 1) * this.width << 6;
                this.tallied = true;
            }
        }
        return this;
    }

    public Region fill(boolean contents) {
        if (contents) {
            if (this.ySections > 0) {
                if (this.yEndMask == -1L) {
                    Arrays.fill(this.data, -1L);
                    Arrays.fill(this.counts, 64);
                    this.ct = this.ySections * this.width << 6;
                    this.tallied = true;
                } else {
                    this.ct = Long.bitCount(this.yEndMask);
                    for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                        this.data[a] = this.yEndMask;
                        this.counts[a] = this.ct;
                        for (int i = 0; i < this.ySections - 1; ++i) {
                            this.data[a - i - 1] = -1L;
                            this.counts[a - i - 1] = 64;
                        }
                    }
                    this.ct *= this.width;
                    this.ct += (this.ySections - 1) * this.width << 6;
                    this.tallied = true;
                }
            }
        } else {
            Arrays.fill(this.data, 0L);
            Arrays.fill(this.counts, 0);
            this.ct = 0;
            this.tallied = true;
        }
        return this;
    }

    public Region removeEdges() {
        if (this.ySections > 0) {
            int i;
            for (i = 0; i < this.ySections; ++i) {
                this.data[i] = 0L;
                this.data[this.width * this.ySections - 1 - i] = 0L;
            }
            if (this.ySections == 1) {
                i = 0;
                while (i < this.width) {
                    int n = i++;
                    this.data[n] = this.data[n] & (this.yEndMask >>> 1 & 0xFFFFFFFFFFFFFFFEL);
                }
            } else {
                for (i = this.ySections; i < this.data.length - this.ySections; i += this.ySections) {
                    int n = i;
                    this.data[n] = this.data[n] & 0xFFFFFFFFFFFFFFFEL;
                }
                for (int a = this.ySections * 2 - 1; a < this.data.length - this.ySections; a += this.ySections) {
                    int n = a;
                    this.data[n] = this.data[n] & this.yEndMask >>> 1;
                }
            }
            this.tallied = false;
        }
        return this;
    }

    public Region copy() {
        return new Region(this);
    }

    public boolean[][] decode() {
        boolean[][] bools = new boolean[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                bools[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L;
            }
        }
        return bools;
    }

    public char[][] intoChars(char[][] chars, char on, char off) {
        for (int x = 0; x < this.width && x < chars.length; ++x) {
            for (int y = 0; y < this.height && y < chars[x].length; ++y) {
                chars[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? on : off;
            }
        }
        return chars;
    }

    public char[][] intoChars(char[][] chars, char on) {
        for (int x = 0; x < this.width && x < chars.length; ++x) {
            for (int y = 0; y < this.height && y < chars[x].length; ++y) {
                if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L) continue;
                chars[x][y] = on;
            }
        }
        return chars;
    }

    public char[][] toChars(char on, char off) {
        char[][] chars = new char[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                chars[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? on : off;
            }
        }
        return chars;
    }

    public char[][] toChars() {
        return this.toChars('.', '#');
    }

    public StringBuilder show(char on, char off) {
        StringBuilder sb = new StringBuilder((this.width + 1) * this.height);
        int y = 0;
        while (y < this.height) {
            for (int x = 0; x < this.width; ++x) {
                sb.append((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? on : off);
            }
            if (++y >= this.height) continue;
            sb.append('\n');
        }
        return sb;
    }

    public String toString() {
        return this.show('.', '#').toString();
    }

    public char[][] writeCharsToOff(char[][] map, char filler) {
        if (map == null || map.length == 0) {
            return new char[0][0];
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        char[][] chars = new char[width2][height2];
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                chars[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? map[x][y] : filler;
            }
        }
        return chars;
    }

    public short[][] writeShortsToOff(short[][] map, short filler) {
        if (map == null || map.length == 0) {
            return new short[0][0];
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        short[][] shorts = new short[width2][height2];
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                shorts[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? map[x][y] : filler;
            }
        }
        return shorts;
    }

    public char[][] writeChars(char[][] map, char toWrite) {
        if (map == null || map.length == 0) {
            return new char[0][0];
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        char[][] chars = new char[width2][height2];
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                chars[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? toWrite : map[x][y];
            }
        }
        return chars;
    }

    public int[][] writeInts(int[][] map, int toWrite) {
        if (map == null || map.length == 0) {
            return new int[0][0];
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        int[][] ints = new int[width2][height2];
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                ints[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? toWrite : map[x][y];
            }
        }
        return ints;
    }

    public int[][] writeIntsInto(int[][] map, int toWrite) {
        if (map == null || map.length == 0) {
            return map;
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L) continue;
                map[x][y] = toWrite;
            }
        }
        return map;
    }

    public float[][] writeFloats(float[][] map, float toWrite) {
        if (map == null || map.length == 0) {
            return new float[0][0];
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        float[][] doubles = new float[width2][height2];
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                doubles[x][y] = (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? toWrite : map[x][y];
            }
        }
        return doubles;
    }

    public float[][] writeFloatsInto(float[][] map, float toWrite) {
        if (map == null || map.length == 0) {
            return map;
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L) continue;
                map[x][y] = toWrite;
            }
        }
        return map;
    }

    public char[][] writeCharsInto(char[][] map, char toWrite) {
        if (map == null || map.length == 0) {
            return map;
        }
        int width2 = Math.min(this.width, map.length);
        int height2 = Math.min(this.height, map[0].length);
        for (int x = 0; x < width2; ++x) {
            for (int y = 0; y < height2; ++y) {
                if ((this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L) continue;
                map[x][y] = toWrite;
            }
        }
        return map;
    }

    public Region or(Region other) {
        for (int x = 0; x < this.width && x < other.width; ++x) {
            for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                int n = x * this.ySections + y;
                this.data[n] = this.data[n] | other.data[x * other.ySections + y];
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region and(Region other) {
        for (int x = 0; x < this.width && x < other.width; ++x) {
            for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                int n = x * this.ySections + y;
                this.data[n] = this.data[n] & other.data[x * other.ySections + y];
            }
        }
        this.tallied = false;
        return this;
    }

    public Region andWrapping64(Region other) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.ySections; ++y) {
                int n = x * this.ySections + y;
                this.data[n] = this.data[n] & other.data[x & 0x3F];
            }
        }
        this.tallied = false;
        return this;
    }

    public Region andNot(Region other) {
        for (int x = 0; x < this.width && x < other.width; ++x) {
            for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                int n = x * this.ySections + y;
                this.data[n] = this.data[n] & (other.data[x * other.ySections + y] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        this.tallied = false;
        return this;
    }

    public Region notAnd(Region other) {
        for (int x = 0; x < this.width && x < other.width; ++x) {
            for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                this.data[x * this.ySections + y] = other.data[x * other.ySections + y] & (this.data[x * this.ySections + y] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        this.tallied = false;
        return this;
    }

    public Region xor(Region other) {
        for (int x = 0; x < this.width && x < other.width; ++x) {
            for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                int n = x * this.ySections + y;
                this.data[n] = this.data[n] ^ other.data[x * other.ySections + y];
            }
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (int a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region not() {
        int a;
        for (a = 0; a < this.data.length; ++a) {
            this.data[a] = this.data[a] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (this.ySections > 0 && this.yEndMask != -1L) {
            for (a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                int n = a;
                this.data[n] = this.data[n] & this.yEndMask;
            }
        }
        this.tallied = false;
        return this;
    }

    public Region translate(int x, int y) {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0 && (x != 0 || y != 0)) {
            long tmp;
            int j;
            long prev;
            int jj;
            int j2;
            int oi;
            int i;
            int start = Math.max(0, x);
            int len = Math.min(this.width, this.width + x) - start;
            int jump = y == 0 ? 0 : (y < 0 ? -(-y >>> 6) : y >>> 6);
            int lily = y < 0 ? -(-y & 0x3F) : y & 0x3F;
            int originalJump = Math.max(0, -jump);
            int alterJump = Math.max(0, jump);
            long[] data2 = new long[this.width * this.ySections];
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = this.data[j2 * this.ySections + oi];
                    }
                }
            }
            if (lily < 0) {
                for (i = start; i < len; ++i) {
                    prev = 0L;
                    for (j = 0; j < this.ySections; ++j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L << -lily ^ 0xFFFFFFFFFFFFFFFFL)) << 64 + lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] >>> -lily;
                        int n2 = i * this.ySections + j;
                        data2[n2] = data2[n2] | tmp;
                    }
                }
            } else if (lily > 0) {
                for (i = start; i < start + len; ++i) {
                    prev = 0L;
                    for (j = 0; j < this.ySections; ++j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L >>> lily ^ 0xFFFFFFFFFFFFFFFFL)) >>> 64 - lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] << lily;
                        int n3 = i * this.ySections + j;
                        data2[n3] = data2[n3] | tmp;
                    }
                }
            }
            if (this.yEndMask != -1L) {
                for (int a = this.ySections - 1; a < data2.length; a += this.ySections) {
                    int n = a;
                    data2[n] = data2[n] & this.yEndMask;
                }
            }
            this.data = data2;
            this.tallied = false;
        }
        return result;
    }

    public Region insertTranslation(int x, int y) {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0 && (x != 0 || y != 0)) {
            long tmp;
            int j;
            long prev;
            int jj;
            int j2;
            int oi;
            int i;
            int start = Math.max(0, x);
            int len = Math.min(this.width, this.width + x) - start;
            int jump = y == 0 ? 0 : (y < 0 ? -(-y >>> 6) : y >>> 6);
            int lily = y < 0 ? -(-y & 0x3F) : y & 0x3F;
            int originalJump = Math.max(0, -jump);
            int alterJump = Math.max(0, jump);
            long[] data2 = new long[this.width * this.ySections];
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i < this.ySections && oi < this.ySections; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = this.data[j2 * this.ySections + oi];
                    }
                }
            }
            if (lily < 0) {
                for (i = start; i < len; ++i) {
                    prev = 0L;
                    for (j = 0; j < this.ySections; ++j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L << -lily ^ 0xFFFFFFFFFFFFFFFFL)) << 64 + lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] >>> -lily;
                        int n2 = i * this.ySections + j;
                        data2[n2] = data2[n2] | tmp;
                    }
                }
            } else if (lily > 0) {
                for (i = start; i < start + len; ++i) {
                    prev = 0L;
                    for (j = 0; j < this.ySections; ++j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L >>> lily ^ 0xFFFFFFFFFFFFFFFFL)) >>> 64 - lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] << lily;
                        int n3 = i * this.ySections + j;
                        data2[n3] = data2[n3] | tmp;
                    }
                }
            }
            for (i = 0; i < this.width * this.ySections; ++i) {
                int n = i;
                data2[n] = data2[n] | this.data[i];
            }
            if (this.yEndMask != -1L) {
                for (int a = this.ySections - 1; a < data2.length; a += this.ySections) {
                    int n = a;
                    data2[n] = data2[n] & this.yEndMask;
                }
            }
            this.data = data2;
            this.tallied = false;
        }
        return result;
    }

    public Region zoom(int x, int y) {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0) {
            int a;
            long tmp;
            int j;
            long prev;
            int jj;
            int j2;
            int oi;
            int i;
            x = -x;
            y = -y;
            int width2 = this.width + 1 >>> 1;
            int ySections2 = this.ySections + 1 >>> 1;
            int start = Math.max(0, x);
            int len = Math.min(this.width, this.width + x) - start;
            int jump = y == 0 ? 0 : (y < 0 ? -(-y >>> 6) : y >>> 6);
            int lily = y < 0 ? -(-y & 0x3F) : y & 0x3F;
            int originalJump = Math.max(0, -jump);
            int alterJump = Math.max(0, jump);
            int oddX = x & 1;
            int oddY = y & 1;
            long[] data2 = new long[this.width * this.ySections];
            long yEndMask2 = -1L >>> 64 - (this.height + 1 >>> 1 & 0x3F);
            if (x < 0) {
                i = alterJump;
                for (oi = originalJump; i <= ySections2 && oi < this.ySections; ++i, ++oi) {
                    j2 = Math.max(0, -x);
                    for (jj = 0; jj < len; ++jj) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                    }
                }
            } else if (x > 0) {
                i = alterJump;
                for (oi = originalJump; i <= ySections2 && oi < this.ySections; ++i, ++oi) {
                    j2 = 0;
                    jj = start;
                    while (j2 < len) {
                        data2[jj * this.ySections + i] = this.data[j2 * this.ySections + oi];
                        ++j2;
                        ++jj;
                    }
                }
            } else {
                i = alterJump;
                for (oi = originalJump; i <= ySections2 && oi < this.ySections; ++i, ++oi) {
                    for (j2 = 0; j2 < len; ++j2) {
                        data2[j2 * this.ySections + i] = this.data[j2 * this.ySections + oi];
                    }
                }
            }
            if (lily < 0) {
                for (i = start; i < len; ++i) {
                    prev = 0L;
                    for (j = ySections2; j >= 0; --j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L << -lily ^ 0xFFFFFFFFFFFFFFFFL)) << 64 + lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] >>> -lily;
                        int n2 = i * this.ySections + j;
                        data2[n2] = data2[n2] | tmp;
                    }
                }
            } else if (lily > 0) {
                for (i = start; i < start + len; ++i) {
                    prev = 0L;
                    for (j = 0; j < ySections2; ++j) {
                        tmp = prev;
                        prev = (data2[i * this.ySections + j] & (-1L >>> lily ^ 0xFFFFFFFFFFFFFFFFL)) >>> 64 - lily;
                        int n = i * this.ySections + j;
                        data2[n] = data2[n] << lily;
                        int n3 = i * this.ySections + j;
                        data2[n3] = data2[n3] | tmp;
                    }
                }
            }
            if (yEndMask2 != -1L) {
                for (a = ySections2 - 1; a < data2.length; a += this.ySections) {
                    int n = a;
                    data2[n] = data2[n] & yEndMask2;
                    if (ySections2 >= this.ySections) continue;
                    data2[a + 1] = 0L;
                }
            }
            for (i = 0; i < width2; ++i) {
                for (j = 0; j < ySections2; ++j) {
                    prev = data2[i * this.ySections + j];
                    tmp = prev >>> 32;
                    prev &= 0xFFFFFFFFL;
                    prev = (prev | prev << 16) & 0xFFFF0000FFFFL;
                    prev = (prev | prev << 8) & 0xFF00FF00FF00FFL;
                    prev = (prev | prev << 4) & 0xF0F0F0F0F0F0F0FL;
                    prev = (prev | prev << 2) & 0x3333333333333333L;
                    prev = (prev | prev << 1) & 0x5555555555555555L;
                    prev <<= oddY;
                    if (oddX == 1) {
                        if (i * 2 + 1 < this.width) {
                            this.data[(i * this.ySections + j) * 2 + this.ySections] = prev;
                        }
                        if (i * 2 < this.width) {
                            this.data[(i * this.ySections + j) * 2] = 0L;
                        }
                    } else {
                        if (i * 2 < this.width) {
                            this.data[(i * this.ySections + j) * 2] = prev;
                        }
                        if (i * 2 + 1 < this.width) {
                            this.data[(i * this.ySections + j) * 2 + this.ySections] = 0L;
                        }
                    }
                    if (j * 2 + 1 >= this.ySections) continue;
                    tmp = (tmp | tmp << 16) & 0xFFFF0000FFFFL;
                    tmp = (tmp | tmp << 8) & 0xFF00FF00FF00FFL;
                    tmp = (tmp | tmp << 4) & 0xF0F0F0F0F0F0F0FL;
                    tmp = (tmp | tmp << 2) & 0x3333333333333333L;
                    tmp = (tmp | tmp << 1) & 0x5555555555555555L;
                    tmp <<= oddY;
                    if (oddX == 1) {
                        if (i * 2 + 1 < this.width) {
                            this.data[(i * this.ySections + j) * 2 + this.ySections + 1] = tmp;
                        }
                        if (i * 2 >= this.width) continue;
                        this.data[(i * this.ySections + j) * 2 + 1] = 0L;
                        continue;
                    }
                    if (i * 2 < this.width) {
                        this.data[(i * this.ySections + j) * 2 + 1] = tmp;
                    }
                    if (i * 2 + 1 >= this.width) continue;
                    this.data[(i * this.ySections + j) * 2 + this.ySections + 1] = 0L;
                }
            }
            if (this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < this.data.length; a += this.ySections) {
                    int n = a;
                    this.data[n] = this.data[n] & this.yEndMask;
                }
            }
            this.tallied = false;
        }
        return result;
    }

    public Region connect() {
        Region result = this;
        if (this.width >= 2 && this.ySections != 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                int n = a;
                next[n] = next[n] | (this.data[a] << 1 & this.data[a] >>> 1 | this.data[a + this.ySections]);
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] << 1 & this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a]);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] << 1 & this.data[i] >>> 1 | this.data[i - this.ySections] & this.data[i + this.ySections]);
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | (this.data[i - 1] & Long.MIN_VALUE) >>> 63 & this.data[i] >>> 1;
                    }
                } else {
                    for (i = this.ySections; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n5 = i;
                        next[n5] = next[n5] | this.data[i] >>> 1 & 1L;
                    }
                }
                if (a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n6 = i;
                        next[n6] = next[n6] | (this.data[i + 1] & 1L) << 63 & this.data[i] << 1;
                    }
                    continue;
                }
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n7 = i;
                    next[n7] = next[n7] | this.data[i] << 1 & Long.MIN_VALUE;
                }
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region connect8way() {
        Region result = this;
        if (this.width >= 2 && this.ySections != 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                int n = a;
                next[n] = next[n] | (this.data[a] << 1 & this.data[a] >>> 1 | this.data[a + this.ySections] | this.data[a + this.ySections] << 1 | this.data[a + this.ySections] >>> 1);
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] << 1 & this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a] | this.data[(this.width - 2) * this.ySections + a] << 1 | this.data[(this.width - 2) * this.ySections + a] >>> 1);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] << 1 & this.data[i] >>> 1 | this.data[i - this.ySections] & this.data[i + this.ySections] | this.data[i - this.ySections] << 1 & this.data[i + this.ySections] >>> 1 | this.data[i + this.ySections] << 1 & this.data[i - this.ySections] >>> 1);
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | ((this.data[i - 1] & Long.MIN_VALUE) >>> 63 & this.data[i] >>> 1 | (this.data[i - this.ySections - 1] & Long.MIN_VALUE) >>> 63 & this.data[i + this.ySections] >>> 1 | (this.data[i + this.ySections - 1] & Long.MIN_VALUE) >>> 63 & this.data[i - this.ySections] >>> 1);
                    }
                } else {
                    for (i = this.ySections; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n5 = i;
                        next[n5] = next[n5] | (this.data[i] >>> 1 & 1L | this.data[i - this.ySections] >>> 1 & 1L | this.data[i + this.ySections] >>> 1 & 1L);
                    }
                }
                if (a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n6 = i;
                        next[n6] = next[n6] | ((this.data[i + 1] & 1L) << 63 & this.data[i] << 1 | (this.data[i - this.ySections + 1] & 1L) << 63 & this.data[i + this.ySections] << 1 | (this.data[i + this.ySections + 1] & 1L) << 63 & this.data[i - this.ySections] << 1);
                    }
                    continue;
                }
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n7 = i;
                    next[n7] = next[n7] | (this.data[i] << 1 & Long.MIN_VALUE | this.data[i - this.ySections] << 1 & Long.MIN_VALUE | this.data[i + this.ySections] << 1 & Long.MIN_VALUE);
                }
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region connectLines() {
        Region result = this;
        if (this.width >= 2 && this.ySections != 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                int n = a;
                next[n] = next[n] | (this.data[a] << 1 & this.data[a] >>> 1 | this.data[a + this.ySections] | this.data[a + this.ySections] << 1 | this.data[a + this.ySections] >>> 1);
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] << 1 & this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a] | this.data[(this.width - 2) * this.ySections + a] << 1 | this.data[(this.width - 2) * this.ySections + a] >>> 1);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] << 1 & this.data[i] >>> 1 | this.data[i - this.ySections] & this.data[i + this.ySections] | this.data[i - this.ySections] << 1 & this.data[i + this.ySections] >>> 1 ^ this.data[i + this.ySections] << 1 & this.data[i - this.ySections] >>> 1);
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | ((this.data[i - 1] & Long.MIN_VALUE) >>> 63 & this.data[i] >>> 1 | (this.data[i - this.ySections - 1] & Long.MIN_VALUE) >>> 63 & this.data[i + this.ySections] >>> 1 ^ (this.data[i + this.ySections - 1] & Long.MIN_VALUE) >>> 63 & this.data[i - this.ySections] >>> 1);
                    }
                } else {
                    for (i = this.ySections; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n5 = i;
                        next[n5] = next[n5] | (this.data[i] >>> 1 & 1L | this.data[i - this.ySections] >>> 1 & 1L | this.data[i + this.ySections] >>> 1 & 1L);
                    }
                }
                if (a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n6 = i;
                        next[n6] = next[n6] | ((this.data[i + 1] & 1L) << 63 & this.data[i] << 1 | (this.data[i - this.ySections + 1] & 1L) << 63 & this.data[i + this.ySections] << 1 ^ (this.data[i + this.ySections + 1] & 1L) << 63 & this.data[i - this.ySections] << 1);
                    }
                    continue;
                }
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n7 = i;
                    next[n7] = next[n7] | (this.data[i] << 1 & Long.MIN_VALUE | this.data[i - this.ySections] << 1 & Long.MIN_VALUE | this.data[i + this.ySections] << 1 & Long.MIN_VALUE);
                }
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region thin() {
        Region result = this;
        if (this.width > 2 && this.ySections > 0) {
            Region c1 = new Region(this).retract();
            Region c2 = new Region(c1).expand().xor(this).expand().and(this);
            this.remake(c1).or(c2);
        }
        return result;
    }

    public Region thinFully() {
        while (this.size() != this.thin().size()) {
        }
        return this;
    }

    public Region thin8way() {
        Region result = this;
        if (this.width > 2 && this.ySections > 0) {
            Region c1 = new Region(this).retract8way();
            Region c2 = new Region(c1).expand8way().xor(this).expand8way().and(this);
            this.remake(c1).or(c2);
        }
        return result;
    }

    public Region thinFully8way() {
        while (this.size() != this.thin8way().size()) {
        }
        return this;
    }

    public Region disperse() {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0) {
            long mask = 0x5555555555555555L;
            for (int i = 0; i < this.width; ++i) {
                int j = 0;
                while (j < this.ySections) {
                    int n = j++;
                    this.data[n] = this.data[n] & mask;
                }
                mask ^= 0xFFFFFFFFFFFFFFFFL;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region disperse8way() {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0) {
            int len = this.data.length;
            long mask = 0x5555555555555555L;
            for (int j = 0; j < len - 1; j += 2) {
                int n = j;
                this.data[n] = this.data[n] & mask;
                this.data[j + 1] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region disperseRandom(EnhancedRandom random) {
        Region result = this;
        if (this.width >= 1 && this.ySections > 0) {
            int len = this.data.length;
            int j = 0;
            while (j < len) {
                int n = j++;
                this.data[n] = this.data[n] & Region.randomInterleave(random);
            }
            this.tallied = false;
        }
        return result;
    }

    public static long approximateBits(EnhancedRandom random, int bitCount) {
        long result;
        if (bitCount <= 0) {
            result = 0L;
        } else if (bitCount >= 64) {
            result = -1L;
        } else if (bitCount == 32) {
            result = random.nextLong();
        } else {
            boolean high = bitCount > 32;
            int altered = high ? 64 - bitCount : bitCount;
            int lsb = BitConversion.lowestOneBit((int)altered);
            long data = random.nextLong();
            for (int i = lsb << 1; i <= 16; i <<= 1) {
                if ((altered & i) == 0) {
                    data &= random.nextLong();
                    continue;
                }
                data |= random.nextLong();
            }
            result = high ? random.nextLong() & data ^ 0xFFFFFFFFFFFFFFFFL : random.nextLong() & data;
        }
        return result;
    }

    public static long randomInterleave(EnhancedRandom random) {
        long bits = random.nextLong() & 0xFFFFFFFFL;
        long ib = (bits ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
        bits |= bits << 16;
        ib |= ib << 16;
        bits &= 0xFFFF0000FFFFL;
        ib &= 0xFFFF0000FFFFL;
        bits |= bits << 8;
        ib |= ib << 8;
        bits &= 0xFF00FF00FF00FFL;
        ib &= 0xFF00FF00FF00FFL;
        bits |= bits << 4;
        ib |= ib << 4;
        bits &= 0xF0F0F0F0F0F0F0FL;
        ib &= 0xF0F0F0F0F0F0F0FL;
        bits |= bits << 2;
        ib |= ib << 2;
        bits &= 0x3333333333333333L;
        ib &= 0x3333333333333333L;
        bits |= bits << 1;
        ib |= ib << 1;
        return (bits &= 0x5555555555555555L) | (ib &= 0x5555555555555555L) << 1;
    }

    public Region expand() {
        Region result = this;
        if (this.width >= 2 && this.ySections != 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                int n = a;
                next[n] = next[n] | (this.data[a] << 1 | this.data[a] >>> 1 | this.data[a + this.ySections]);
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] << 1 | this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a]);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] << 1 | this.data[i] >>> 1 | this.data[i - this.ySections] | this.data[i + this.ySections]);
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | (this.data[i - 1] & Long.MIN_VALUE) >>> 63;
                    }
                }
                if (a >= this.ySections - 1) continue;
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n5 = i;
                    next[n5] = next[n5] | (this.data[i + 1] & 1L) << 63;
                }
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region expand(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.expand();
        }
        return this;
    }

    public Region[] expandSeries(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                regions[i] = new Region(temp.expand());
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> expandSeriesToLimit() {
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (temp.size() != temp.expand().size()) {
            regions.add((Object)new Region(temp));
        }
        return regions;
    }

    public Region fringe() {
        Region cpy = new Region(this);
        this.expand();
        return this.andNot(cpy);
    }

    public Region fringe(int amount) {
        Region cpy = new Region(this);
        this.expand(amount);
        return this.andNot(cpy);
    }

    public Region[] fringeSeries(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            int i;
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            regions[0] = new Region(temp);
            for (i = 1; i < amount; ++i) {
                regions[i] = new Region(temp.expand());
            }
            for (i = 0; i < amount - 1; ++i) {
                regions[i].xor(regions[i + 1]);
            }
            regions[amount - 1].fringe();
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> fringeSeriesToLimit() {
        ObjectList<Region> regions = this.expandSeriesToLimit();
        for (int i = regions.size() - 1; i > 0; --i) {
            ((Region)regions.get(i)).xor((Region)regions.get(i - 1));
        }
        ((Region)regions.get(0)).xor(this);
        return regions;
    }

    public Region retract() {
        Region result = this;
        if (this.width > 2 && this.ySections > 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, this.ySections, next, this.ySections, (this.width - 2) * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                if (a > 0 && a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) & this.data[i - this.ySections] & this.data[i + this.ySections]);
                    }
                    continue;
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & this.data[i] >>> 1 & this.data[i - this.ySections] & this.data[i + this.ySections]);
                    }
                    continue;
                }
                if (a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & (this.data[i] << 1 & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) & this.data[i - this.ySections] & this.data[i + this.ySections]);
                    }
                    continue;
                }
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n = i;
                    next[n] = next[n] & (this.data[i] << 1 & this.data[i] >>> 1 & this.data[i - this.ySections] & this.data[i + this.ySections]);
                }
            }
            if (this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region retract(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.retract();
        }
        return this;
    }

    public Region[] retractSeries(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                regions[i] = new Region(temp.retract());
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> retractSeriesToLimit() {
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (!temp.retract().isEmpty()) {
            regions.add((Object)new Region(temp));
        }
        return regions;
    }

    public Region surface() {
        Region cpy = new Region(this).retract();
        return this.xor(cpy);
    }

    public Region surface(int amount) {
        Region cpy = new Region(this).retract(amount);
        return this.xor(cpy);
    }

    public Region[] surfaceSeries(int amount) {
        int i;
        if (amount <= 0) {
            return new Region[0];
        }
        Region[] regions = new Region[amount];
        Region temp = new Region(this);
        regions[0] = new Region(temp);
        for (i = 1; i < amount; ++i) {
            regions[i] = new Region(temp.retract());
        }
        for (i = 0; i < amount - 1; ++i) {
            regions[i].xor(regions[i + 1]);
        }
        regions[amount - 1].surface();
        return regions;
    }

    public ObjectList<Region> surfaceSeriesToLimit() {
        ObjectList<Region> result;
        ObjectList<Region> regions = this.retractSeriesToLimit();
        if (regions.isEmpty()) {
            result = regions;
        } else {
            regions.add(0, (Object)((Region)regions.get(0)).copy().xor(this));
            for (int i = 1; i < regions.size() - 1; ++i) {
                ((Region)regions.get(i)).xor((Region)regions.get(i + 1));
            }
            result = regions;
        }
        return result;
    }

    public Region expand8way() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                int n = a;
                next[n] = next[n] | (this.data[a] << 1 | this.data[a] >>> 1 | this.data[a + this.ySections] | this.data[a + this.ySections] << 1 | this.data[a + this.ySections] >>> 1);
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] << 1 | this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a] | this.data[(this.width - 2) * this.ySections + a] << 1 | this.data[(this.width - 2) * this.ySections + a] >>> 1);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] << 1 | this.data[i] >>> 1 | this.data[i - this.ySections] | this.data[i - this.ySections] << 1 | this.data[i - this.ySections] >>> 1 | this.data[i + this.ySections] | this.data[i + this.ySections] << 1 | this.data[i + this.ySections] >>> 1);
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | ((this.data[i - 1] & Long.MIN_VALUE) >>> 63 | (this.data[i - this.ySections - 1] & Long.MIN_VALUE) >>> 63 | (this.data[i + this.ySections - 1] & Long.MIN_VALUE) >>> 63);
                    }
                }
                if (a >= this.ySections - 1) continue;
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n5 = i;
                    next[n5] = next[n5] | ((this.data[i + 1] & 1L) << 63 | (this.data[i - this.ySections + 1] & 1L) << 63 | (this.data[i + this.ySections + 1] & 1L) << 63);
                }
            }
            if (this.ySections > 0 && this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region expand8way(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.expand8way();
        }
        return this;
    }

    public Region[] expandSeries8way(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                regions[i] = new Region(temp.expand8way());
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> expandSeriesToLimit8way() {
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (temp.size() != temp.expand8way().size()) {
            regions.add((Object)new Region(temp));
        }
        return regions;
    }

    public Region fringe8way() {
        Region cpy = new Region(this);
        this.expand8way();
        return this.andNot(cpy);
    }

    public Region fringe8way(int amount) {
        Region cpy = new Region(this);
        this.expand8way(amount);
        return this.andNot(cpy);
    }

    public Region[] fringeSeries8way(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            int i;
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            regions[0] = new Region(temp);
            for (i = 1; i < amount; ++i) {
                regions[i] = new Region(temp.expand8way());
            }
            for (i = 0; i < amount - 1; ++i) {
                regions[i].xor(regions[i + 1]);
            }
            regions[amount - 1].fringe8way();
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> fringeSeriesToLimit8way() {
        ObjectList<Region> regions = this.expandSeriesToLimit8way();
        for (int i = regions.size() - 1; i > 0; --i) {
            ((Region)regions.get(i)).xor((Region)regions.get(i - 1));
        }
        ((Region)regions.get(0)).xor(this);
        return regions;
    }

    public Region retract8way() {
        Region result = this;
        if (this.width > 2 && this.ySections > 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            System.arraycopy(this.data, this.ySections, next, this.ySections, (this.width - 2) * this.ySections);
            for (a = 0; a < this.ySections; ++a) {
                int i;
                if (a > 0 && a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) & this.data[i - this.ySections] & this.data[i + this.ySections] & (this.data[i - this.ySections] << 1 | (this.data[i - 1 - this.ySections] & Long.MIN_VALUE) >>> 63) & (this.data[i + this.ySections] << 1 | (this.data[i - 1 + this.ySections] & Long.MIN_VALUE) >>> 63) & (this.data[i - this.ySections] >>> 1 | (this.data[i + 1 - this.ySections] & 1L) << 63) & (this.data[i + this.ySections] >>> 1 | (this.data[i + 1 + this.ySections] & 1L) << 63));
                    }
                    continue;
                }
                if (a > 0) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & this.data[i] >>> 1 & this.data[i - this.ySections] & this.data[i + this.ySections] & (this.data[i - this.ySections] << 1 | (this.data[i - 1 - this.ySections] & Long.MIN_VALUE) >>> 63) & (this.data[i + this.ySections] << 1 | (this.data[i - 1 + this.ySections] & Long.MIN_VALUE) >>> 63) & this.data[i - this.ySections] >>> 1 & this.data[i + this.ySections] >>> 1);
                    }
                    continue;
                }
                if (a < this.ySections - 1) {
                    for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        int n = i;
                        next[n] = next[n] & (this.data[i] << 1 & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) & this.data[i - this.ySections] & this.data[i + this.ySections] & this.data[i - this.ySections] << 1 & this.data[i + this.ySections] << 1 & (this.data[i - this.ySections] >>> 1 | (this.data[i + 1 - this.ySections] & 1L) << 63) & (this.data[i + this.ySections] >>> 1 | (this.data[i + 1 + this.ySections] & 1L) << 63));
                    }
                    continue;
                }
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n = i;
                    next[n] = next[n] & (this.data[i] << 1 & this.data[i] >>> 1 & this.data[i - this.ySections] & this.data[i + this.ySections] & this.data[i - this.ySections] << 1 & this.data[i + this.ySections] << 1 & this.data[i - this.ySections] >>> 1 & this.data[i + this.ySections] >>> 1);
                }
            }
            if (this.yEndMask != -1L) {
                for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                    int n = a;
                    next[n] = next[n] & this.yEndMask;
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region retract8way(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.retract8way();
        }
        return this;
    }

    public Region[] retractSeries8way(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                regions[i] = new Region(temp.retract8way());
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> retractSeriesToLimit8way() {
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (!temp.retract8way().isEmpty()) {
            regions.add((Object)new Region(temp));
        }
        return regions;
    }

    public Region surface8way() {
        Region cpy = new Region(this).retract8way();
        return this.xor(cpy);
    }

    public Region surface8way(int amount) {
        Region cpy = new Region(this).retract8way(amount);
        return this.xor(cpy);
    }

    public Region[] surfaceSeries8way(int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            int i;
            Region[] regions = new Region[amount];
            Region temp = new Region(this);
            regions[0] = new Region(temp);
            for (i = 1; i < amount; ++i) {
                regions[i] = new Region(temp.retract8way());
            }
            for (i = 0; i < amount - 1; ++i) {
                regions[i].xor(regions[i + 1]);
            }
            regions[amount - 1].surface8way();
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> surfaceSeriesToLimit8way() {
        ObjectList<Region> result;
        ObjectList<Region> regions = this.retractSeriesToLimit8way();
        if (regions.isEmpty()) {
            result = regions;
        } else {
            regions.add(0, (Object)((Region)regions.get(0)).copy().xor(this));
            for (int i = 1; i < regions.size() - 1; ++i) {
                ((Region)regions.get(i)).xor((Region)regions.get(i + 1));
            }
            result = regions;
        }
        return result;
    }

    public Region flood(Region bounds) {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0 && bounds != null && bounds.width >= 2 && bounds.ySections > 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            for (a = 0; a < this.ySections && a < bounds.ySections; ++a) {
                int j;
                int n = a;
                next[n] = next[n] | (this.data[a] | this.data[a] << 1 | this.data[a] >>> 1 | this.data[a + this.ySections]) & bounds.data[a];
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] | this.data[(this.width - 1) * this.ySections + a] << 1 | this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a]) & bounds.data[(this.width - 1) * bounds.ySections + a];
                int i = this.ySections + a;
                for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] | this.data[i] << 1 | this.data[i] >>> 1 | this.data[i - this.ySections] | this.data[i + this.ySections]) & bounds.data[j];
                }
                if (a > 0) {
                    i = this.ySections + a;
                    for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | (this.data[i] | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & bounds.data[j];
                    }
                }
                if (a >= this.ySections - 1 || a >= bounds.ySections - 1) continue;
                i = this.ySections + a;
                for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                    int n5 = i;
                    next[n5] = next[n5] | (this.data[i] | (this.data[i + 1] & 1L) << 63) & bounds.data[j];
                }
            }
            if (this.yEndMask != -1L && bounds.yEndMask != -1L) {
                if (this.ySections == bounds.ySections) {
                    long mask = this.yEndMask >>> 1 <= bounds.yEndMask >>> 1 ? this.yEndMask : bounds.yEndMask;
                    for (int a2 = this.ySections - 1; a2 < next.length; a2 += this.ySections) {
                        int n = a2;
                        next[n] = next[n] & mask;
                    }
                } else if (this.ySections < bounds.ySections) {
                    for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                        int n = a;
                        next[n] = next[n] & this.yEndMask;
                    }
                } else {
                    for (a = bounds.ySections - 1; a < next.length; a += this.ySections) {
                        int n = a;
                        next[n] = next[n] & bounds.yEndMask;
                    }
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region flood(Region bounds, int amount) {
        int ct = this.size();
        for (int i = 0; i < amount; ++i) {
            this.flood(bounds);
            int ct2 = this.size();
            if (ct == ct2) break;
            ct = ct2;
        }
        return this;
    }

    public Region[] floodSeries(Region bounds, int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            int ct = this.size();
            Region[] regions = new Region[amount];
            boolean done = false;
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                if (done) {
                    regions[i] = new Region(temp);
                    continue;
                }
                regions[i] = new Region(temp.flood(bounds));
                int ct2 = temp.size();
                if (ct == ct2) {
                    done = true;
                    continue;
                }
                ct = ct2;
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> floodSeriesToLimit(Region bounds) {
        int ct = this.size();
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (true) {
            temp.flood(bounds);
            int ct2 = temp.size();
            if (ct == ct2) {
                return regions;
            }
            ct = ct2;
            regions.add((Object)new Region(temp));
        }
    }

    public Region flood8way(Region bounds) {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0 && bounds != null && bounds.width >= 2 && bounds.ySections > 0) {
            int a;
            long[] next = new long[this.width * this.ySections];
            for (a = 0; a < this.ySections && a < bounds.ySections; ++a) {
                int j;
                int n = a;
                next[n] = next[n] | (this.data[a] | this.data[a] << 1 | this.data[a] >>> 1 | this.data[a + this.ySections] | this.data[a + this.ySections] << 1 | this.data[a + this.ySections] >>> 1) & bounds.data[a];
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] | (this.data[(this.width - 1) * this.ySections + a] | this.data[(this.width - 1) * this.ySections + a] << 1 | this.data[(this.width - 1) * this.ySections + a] >>> 1 | this.data[(this.width - 2) * this.ySections + a] | this.data[(this.width - 2) * this.ySections + a] << 1 | this.data[(this.width - 2) * this.ySections + a] >>> 1) & bounds.data[(this.width - 1) * bounds.ySections + a];
                int i = this.ySections + a;
                for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] | (this.data[i] | this.data[i] << 1 | this.data[i] >>> 1 | this.data[i - this.ySections] | this.data[i - this.ySections] << 1 | this.data[i - this.ySections] >>> 1 | this.data[i + this.ySections] | this.data[i + this.ySections] << 1 | this.data[i + this.ySections] >>> 1) & bounds.data[j];
                }
                if (a > 0) {
                    i = this.ySections + a;
                    for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                        int n4 = i;
                        next[n4] = next[n4] | (this.data[i] | (this.data[i - 1] & Long.MIN_VALUE) >>> 63 | (this.data[i - this.ySections - 1] & Long.MIN_VALUE) >>> 63 | (this.data[i + this.ySections - 1] & Long.MIN_VALUE) >>> 63) & bounds.data[j];
                    }
                }
                if (a >= this.ySections - 1 || a >= bounds.ySections - 1) continue;
                i = this.ySections + a;
                for (j = bounds.ySections + a; i < (this.width - 1) * this.ySections && j < (bounds.width - 1) * bounds.ySections; i += this.ySections, j += bounds.ySections) {
                    int n5 = i;
                    next[n5] = next[n5] | (this.data[i] | (this.data[i + 1] & 1L) << 63 | (this.data[i - this.ySections + 1] & 1L) << 63 | (this.data[i + this.ySections + 1] & 1L) << 63) & bounds.data[j];
                }
            }
            if (this.yEndMask != -1L && bounds.yEndMask != -1L) {
                if (this.ySections == bounds.ySections) {
                    long mask = this.yEndMask >>> 1 <= bounds.yEndMask >>> 1 ? this.yEndMask : bounds.yEndMask;
                    for (int a2 = this.ySections - 1; a2 < next.length; a2 += this.ySections) {
                        int n = a2;
                        next[n] = next[n] & mask;
                    }
                } else if (this.ySections < bounds.ySections) {
                    for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                        int n = a;
                        next[n] = next[n] & this.yEndMask;
                    }
                } else {
                    for (a = bounds.ySections - 1; a < next.length; a += this.ySections) {
                        int n = a;
                        next[n] = next[n] & bounds.yEndMask;
                    }
                }
            }
            this.data = next;
            this.tallied = false;
        }
        return result;
    }

    public Region flood8way(Region bounds, int amount) {
        int ct = this.size();
        for (int i = 0; i < amount; ++i) {
            this.flood8way(bounds);
            int ct2 = this.size();
            if (ct == ct2) break;
            ct = ct2;
        }
        return this;
    }

    public Region[] floodSeries8way(Region bounds, int amount) {
        Region[] result;
        if (amount <= 0) {
            result = new Region[]{};
        } else {
            int ct = this.size();
            Region[] regions = new Region[amount];
            boolean done = false;
            Region temp = new Region(this);
            for (int i = 0; i < amount; ++i) {
                if (done) {
                    regions[i] = new Region(temp);
                    continue;
                }
                regions[i] = new Region(temp.flood8way(bounds));
                int ct2 = temp.size();
                if (ct == ct2) {
                    done = true;
                    continue;
                }
                ct = ct2;
            }
            result = regions;
        }
        return result;
    }

    public ObjectList<Region> floodSeriesToLimit8way(Region bounds) {
        int ct = this.size();
        ObjectList regions = new ObjectList();
        Region temp = new Region(this);
        while (true) {
            temp.flood8way(bounds);
            int ct2 = temp.size();
            if (ct == ct2) {
                return regions;
            }
            ct = ct2;
            regions.add((Object)new Region(temp));
        }
    }

    public Region splash(Region bounds, EnhancedRandom rng) {
        if (this.width >= 2 && this.ySections > 0 && bounds != null && bounds.width >= 2 && bounds.ySections > 0) {
            this.insert(new Region(this).fringe().and(bounds).singleRandom(rng));
        }
        return this;
    }

    public Region spill(Region bounds, int volume, EnhancedRandom rng) {
        return this.spill(bounds, volume, rng, null, null);
    }

    public Region spill(Region bounds, int volume, EnhancedRandom rng, Region temp, Region temp2) {
        int current;
        Region result = this;
        if (this.width >= 2 && this.ySections > 0 && bounds != null && bounds.width >= 2 && bounds.ySections > 0 && (current = this.size()) < volume) {
            if (temp == null) {
                temp = new Region(this);
            } else {
                temp.remake(this);
            }
            if (temp2 == null) {
                temp2 = new Region(this);
            } else {
                temp2.remake(this);
            }
            temp.notAnd(bounds);
            long[] boundsData = temp.data;
            temp2.remake(this).fringe().and(bounds).tally();
            if (temp2.ct > 0) {
                for (int i = current; i < volume; ++i) {
                    int p;
                    Coord c = temp2.singleRandom(rng);
                    int x = c.x;
                    int y = c.y;
                    int n = p = x * this.ySections + (y >> 6);
                    this.data[n] = this.data[n] | 1L << (y & 0x3F);
                    if (this.data[p] == this.data[n]) continue;
                    int n2 = p;
                    this.counts[n2] = this.counts[n2] + 1;
                    for (int j = p + 1; j < this.data.length; ++j) {
                        if (this.counts[j] <= 0) continue;
                        int n3 = j;
                        this.counts[n3] = this.counts[n3] + 1;
                    }
                    ++this.ct;
                    int n4 = p;
                    temp2.data[n4] = temp2.data[n4] & (1L << (y & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
                    if (x < this.width - 1 && (boundsData[p = (x + 1) * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L) {
                        int n5 = p;
                        temp2.data[n5] = temp2.data[n5] | 1L << (y & 0x3F);
                    }
                    if (y < this.height - 1 && (boundsData[p = x * this.ySections + (y + 1 >> 6)] & 1L << (y + 1 & 0x3F)) != 0L) {
                        int n6 = p;
                        temp2.data[n6] = temp2.data[n6] | 1L << (y + 1 & 0x3F);
                    }
                    if (y > 0 && (boundsData[p = x * this.ySections + (y - 1 >> 6)] & 1L << (y - 1 & 0x3F)) != 0L) {
                        int n7 = p;
                        temp2.data[n7] = temp2.data[n7] | 1L << (y - 1 & 0x3F);
                    }
                    if (x > 0 && (boundsData[p = (x - 1) * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L) {
                        int n8 = p;
                        temp2.data[n8] = temp2.data[n8] | 1L << (y & 0x3F);
                    }
                    temp2.tally();
                    if (temp2.ct <= 0) break;
                }
                this.tallied = false;
            }
        }
        return result;
    }

    public Region removeCorners() {
        int a;
        if (this.width <= 2 || this.ySections <= 0) {
            return this;
        }
        long[] next = new long[this.width * this.ySections];
        System.arraycopy(this.data, 0, next, 0, this.width * this.ySections);
        for (a = 0; a < this.ySections; ++a) {
            int i;
            if (a > 0 && a < this.ySections - 1) {
                int n = a;
                next[n] = next[n] & ((this.data[a] << 1 | (this.data[a - 1] & Long.MIN_VALUE) >>> 63) & (this.data[a] >>> 1 | (this.data[a + 1] & 1L) << 63));
                int n2 = (this.width - 1) * this.ySections + a;
                next[n2] = next[n2] & ((this.data[(this.width - 1) * this.ySections + a] << 1 | (this.data[(this.width - 1) * this.ySections + a - 1] & Long.MIN_VALUE) >>> 63) & (this.data[(this.width - 1) * this.ySections + a] >>> 1 | (this.data[(this.width - 1) * this.ySections + a + 1] & 1L) << 63));
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n3 = i;
                    next[n3] = next[n3] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) | this.data[i - this.ySections] & this.data[i + this.ySections]);
                }
                continue;
            }
            if (a > 0) {
                int n = a;
                next[n] = next[n] & ((this.data[a] << 1 | (this.data[a - 1] & Long.MIN_VALUE) >>> 63) & this.data[a] >>> 1);
                int n4 = (this.width - 1) * this.ySections + a;
                next[n4] = next[n4] & ((this.data[(this.width - 1) * this.ySections + a] << 1 | (this.data[(this.width - 1) * this.ySections + a - 1] & Long.MIN_VALUE) >>> 63) & this.data[(this.width - 1) * this.ySections + a] >>> 1);
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n5 = i;
                    next[n5] = next[n5] & ((this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63) & this.data[i] >>> 1 | this.data[i - this.ySections] & this.data[i + this.ySections]);
                }
                continue;
            }
            if (a < this.ySections - 1) {
                int n = a;
                next[n] = next[n] & (this.data[a] << 1 & (this.data[a] >>> 1 | (this.data[a + 1] & 1L) << 63));
                int n6 = (this.width - 1) * this.ySections + a;
                next[n6] = next[n6] & (this.data[(this.width - 1) * this.ySections + a] << 1 & (this.data[(this.width - 1) * this.ySections + a] >>> 1 | (this.data[(this.width - 1) * this.ySections + a + 1] & 1L) << 63));
                for (i = this.ySections + a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    int n7 = i;
                    next[n7] = next[n7] & (this.data[i] << 1 & (this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63) | this.data[i - this.ySections] & this.data[i + this.ySections]);
                }
                continue;
            }
            next[0] = next[0] & (this.data[0] << 1 & this.data[0] >>> 1);
            int n = this.width - 1;
            next[n] = next[n] & (this.data[this.width - 1] << 1 & this.data[this.width - 1] >>> 1);
            for (i = 1 + a; i < this.width - 1; ++i) {
                int n8 = i;
                next[n8] = next[n8] & (this.data[i] << 1 & this.data[i] >>> 1 | this.data[i - this.ySections] & this.data[i + this.ySections]);
            }
        }
        if (this.yEndMask != -1L) {
            for (a = this.ySections - 1; a < next.length; a += this.ySections) {
                int n = a;
                next[n] = next[n] & this.yEndMask;
            }
        }
        this.data = next;
        this.tallied = false;
        return this;
    }

    public ObjectList<Region> split() {
        ObjectList scattered = new ObjectList(32);
        int fst = this.firstTight();
        Region remaining = new Region(this);
        while (fst >= 0) {
            Region filled = new Region(this.width, this.height).insert(fst).flood(remaining, this.width * this.height);
            scattered.add((Object)filled);
            remaining.andNot(filled);
            fst = remaining.firstTight();
        }
        return scattered;
    }

    public ObjectList<Region> split8way() {
        ObjectList scattered = new ObjectList(32);
        int fst = this.firstTight();
        Region remaining = new Region(this);
        while (fst >= 0) {
            Region filled = new Region(this.width, this.height).insert(fst).flood8way(remaining, this.width * this.height);
            scattered.add((Object)filled);
            remaining.andNot(filled);
            fst = remaining.firstTight();
        }
        return scattered;
    }

    public Region largestPart() {
        int fst = this.firstTight();
        int bestSize = 0;
        Region remaining = new Region(this);
        Region filled = new Region(this.width, this.height);
        Region choice = new Region(this.width, this.height);
        while (fst >= 0) {
            filled.empty().insert(fst).flood(remaining, this.width * this.height);
            int currentSize = filled.size();
            if (currentSize > bestSize) {
                bestSize = currentSize;
                choice.remake(filled);
            }
            remaining.andNot(filled);
            fst = remaining.firstTight();
        }
        return choice;
    }

    public Region largestPart8way() {
        int fst = this.firstTight();
        int bestSize = 0;
        Region remaining = new Region(this);
        Region filled = new Region(this.width, this.height);
        Region choice = new Region(this.width, this.height);
        while (fst >= 0) {
            filled.empty().insert(fst).flood8way(remaining, this.width * this.height);
            int currentSize = filled.size();
            if (currentSize > bestSize) {
                bestSize = currentSize;
                choice.remake(filled);
            }
            remaining.andNot(filled);
            fst = remaining.firstTight();
        }
        return choice;
    }

    public Region neighborUp() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = this.ySections - 1; a >= 0; --a) {
                int i;
                if (a > 0) {
                    for (i = a; i < this.width * this.ySections; i += this.ySections) {
                        this.data[i] = this.data[i] << 1 | (this.data[i - 1] & Long.MIN_VALUE) >>> 63;
                    }
                    continue;
                }
                for (i = a; i < this.width * this.ySections; i += this.ySections) {
                    this.data[i] = this.data[i] << 1;
                }
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborDown() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = 0; a < this.ySections; ++a) {
                int i;
                if (a < this.ySections - 1) {
                    for (i = a; i < this.width * this.ySections; i += this.ySections) {
                        this.data[i] = this.data[i] >>> 1 | (this.data[i + 1] & 1L) << 63;
                    }
                    continue;
                }
                for (i = a; i < this.width * this.ySections; i += this.ySections) {
                    this.data[i] = this.data[i] >>> 1;
                }
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborLeft() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = 0; a < this.ySections; ++a) {
                for (int i = this.ySections * (this.width - 1) + a; i >= this.ySections; i -= this.ySections) {
                    this.data[i] = this.data[i - this.ySections];
                }
                this.data[a] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborRight() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = 0; a < this.ySections; ++a) {
                for (int i = a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    this.data[i] = this.data[i + this.ySections];
                }
                this.data[(this.width - 1) * this.ySections + a] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborUpLeft() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = this.ySections - 1; a >= 0; --a) {
                int i;
                if (a > 0) {
                    for (i = this.ySections * (this.width - 1) + a; i >= this.ySections; i -= this.ySections) {
                        this.data[i] = this.data[i - this.ySections] << 1 | (this.data[i - this.ySections - 1] & Long.MIN_VALUE) >>> 63;
                    }
                    this.data[a] = 0L;
                    continue;
                }
                for (i = this.ySections * (this.width - 1) + a; i >= this.ySections; i -= this.ySections) {
                    this.data[i] = this.data[i - this.ySections] << 1;
                }
                this.data[a] = 0L;
            }
        }
        return result;
    }

    public Region neighborUpRight() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = this.ySections - 1; a >= 0; --a) {
                int i;
                if (a > 0) {
                    for (i = a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        this.data[i] = this.data[i + this.ySections] << 1 | (this.data[i + this.ySections - 1] & Long.MIN_VALUE) >>> 63;
                    }
                    this.data[(this.width - 1) * this.ySections + a] = 0L;
                    continue;
                }
                for (i = a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    this.data[i] = this.data[i + this.ySections] << 1;
                }
                this.data[(this.width - 1) * this.ySections + a] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborDownLeft() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = 0; a < this.ySections; ++a) {
                int i;
                if (a < this.ySections - 1) {
                    for (i = this.ySections * (this.width - 1) + a; i >= this.ySections; i -= this.ySections) {
                        this.data[i] = this.data[i - this.ySections] >>> 1 | (this.data[i - this.ySections + 1] & 1L) << 63;
                    }
                    this.data[a] = 0L;
                    continue;
                }
                for (i = this.ySections * (this.width - 1) + a; i >= this.ySections; i -= this.ySections) {
                    this.data[i] = this.data[i - this.ySections] >>> 1;
                }
                this.data[a] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region neighborDownRight() {
        Region result = this;
        if (this.width >= 2 && this.ySections > 0) {
            for (int a = 0; a < this.ySections; ++a) {
                int i;
                if (a < this.ySections - 1) {
                    for (i = a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                        this.data[i] = this.data[i + this.ySections] >>> 1 | (this.data[i + this.ySections + 1] & 1L) << 63;
                    }
                    this.data[(this.width - 1) * this.ySections + a] = 0L;
                    continue;
                }
                for (i = a; i < (this.width - 1) * this.ySections; i += this.ySections) {
                    this.data[i] = this.data[i + this.ySections] >>> 1;
                }
                this.data[(this.width - 1) * this.ySections + a] = 0L;
            }
            this.tallied = false;
        }
        return result;
    }

    public Region removeIsolated() {
        int fst = this.firstTight();
        Region remaining = new Region(this);
        Region filled = new Region(this);
        while (fst >= 0) {
            filled.empty().insert(fst).flood(remaining, 8);
            if (filled.size() <= 4) {
                this.andNot(filled);
            }
            remaining.andNot(filled);
            fst = remaining.firstTight();
        }
        return this;
    }

    public boolean intersects(Region other) {
        boolean result = false;
        if (other != null) {
            block0: for (int x = 0; x < this.width && x < other.width; ++x) {
                for (int y = 0; y < this.ySections && y < other.ySections; ++y) {
                    if ((this.data[x * this.ySections + y] & other.data[x * this.ySections + y]) == 0L) continue;
                    result = true;
                    break block0;
                }
            }
        }
        return result;
    }

    public static ObjectOrderedSet<Region> whichContain(int x, int y, Region ... packed) {
        ObjectOrderedSet found = new ObjectOrderedSet(packed.length);
        for (int i = 0; i < packed.length; ++i) {
            Region tmp = packed[i];
            if (tmp == null || !tmp.contains(x, y)) continue;
            found.add((Object)tmp);
        }
        return found;
    }

    public static ObjectOrderedSet<Region> whichContain(int x, int y, Collection<Region> packed) {
        ObjectOrderedSet found = new ObjectOrderedSet(packed.size());
        for (Region tmp : packed) {
            if (tmp == null || !tmp.contains(x, y)) continue;
            found.add((Object)tmp);
        }
        return found;
    }

    public static Collection<Region> appendContaining(Collection<Region> into, int x, int y, Region ... packed) {
        for (int i = 0; i < packed.length; ++i) {
            Region tmp = packed[i];
            if (tmp == null || !tmp.contains(x, y)) continue;
            into.add(tmp);
        }
        return into;
    }

    public static Collection<Region> appendContaining(Collection<Region> into, int x, int y, Collection<Region> packed) {
        for (Region tmp : packed) {
            if (tmp == null || !tmp.contains(x, y)) continue;
            into.add(tmp);
        }
        return into;
    }

    @Override
    public int size() {
        if (!this.tallied) {
            this.tally();
        }
        return this.ct;
    }

    public Coord fit(float xFraction, float yFraction) {
        long t;
        int x;
        Coord result = null;
        boolean finished = false;
        int xTotal = 0;
        int yTotal = 0;
        int bestX = -1;
        int[] xCounts = new int[this.width];
        for (x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                int tmp = Long.bitCount(t);
                int n = x;
                xCounts[n] = xCounts[n] + tmp;
                xTotal += tmp;
            }
        }
        int xTarget = (int)((float)xTotal * xFraction);
        for (x = 0; x < this.width; ++x) {
            if ((xTarget -= xCounts[x]) >= 0) continue;
            bestX = x;
            yTotal = xCounts[x];
            break;
        }
        if (bestX < 0) {
            result = Coord.get(-1, -1);
        } else {
            int yTarget = (int)((float)yTotal * yFraction);
            int y = 0;
            for (int s = 0; s < this.ySections; ++s) {
                t = this.data[bestX * this.ySections + s];
                for (long cy = 1L; cy != 0L && y < this.height; ++y, cy <<= 1) {
                    if ((t & cy) == 0L || --yTarget >= 0) continue;
                    result = Coord.get(bestX, y);
                    finished = true;
                    break;
                }
                if (finished) break;
            }
            if (!finished) {
                result = Coord.get(-1, -1);
            }
        }
        return result;
    }

    public int[][] fit(int[][] basis, int defaultValue) {
        int[][] result;
        int[][] next = ArrayTools.fill((int)defaultValue, (int)this.width, (int)this.height);
        if (basis == null || basis.length <= 0 || basis[0] == null || basis[0].length <= 0) {
            result = next;
        } else {
            long t;
            int xTotal = 0;
            int oX = basis.length;
            int oY = basis[0].length;
            int[] xCounts = new int[this.width];
            for (int x = 0; x < this.width; ++x) {
                for (int s = 0; s < this.ySections; ++s) {
                    t = this.data[x * this.ySections + s] | 0L;
                    if (t == 0L) continue;
                    int tmp = Long.bitCount(t);
                    int n = x;
                    xCounts[n] = xCounts[n] + tmp;
                    xTotal += tmp;
                }
            }
            if (xTotal <= 0) {
                result = next;
            } else {
                for (int aX = 0; aX < oX; ++aX) {
                    block3: for (int aY = 0; aY < oY; ++aY) {
                        int ao = basis[aX][aY];
                        if (ao == defaultValue) continue;
                        int xTarget = xTotal * aX / oX;
                        for (int x = 0; x < this.width; ++x) {
                            if ((xTarget -= xCounts[x]) >= 0) continue;
                            int bestX = x;
                            int yTotal = xCounts[x];
                            int yTarget = yTotal * aY / oY;
                            int y = 0;
                            for (int s = 0; s < this.ySections; ++s) {
                                t = this.data[bestX * this.ySections + s] | 0L;
                                for (long cy = 1L; cy != 0L && y < this.height; ++y, cy <<= 1) {
                                    if ((t & (cy | 0L)) == 0L || --yTarget >= 0) continue;
                                    next[bestX][y] = ao;
                                    continue block3;
                                }
                            }
                            continue block3;
                        }
                    }
                }
                result = next;
            }
        }
        return result;
    }

    public Region fray(float fractionKept) {
        Region cpy = new Region(this).retract();
        return this.xor(cpy).separatedRegionBlue(fractionKept).or(cpy);
    }

    public Region fray(EnhancedRandom random, float fractionKept) {
        Region cpy = new Region(this).retract();
        return this.xor(cpy).deteriorate(random, fractionKept).or(cpy);
    }

    public Region randomScatter(EnhancedRandom rng, int minimumDistance) {
        return this.randomScatter(rng, minimumDistance, -1);
    }

    public Region randomScatter(EnhancedRandom rng, int minimumDistance, int limit) {
        Region result = this;
        int total = 0;
        this.tally();
        if (this.ct != 0) {
            if (limit == 0) {
                result = this.empty();
            } else {
                if (limit < 0) {
                    limit = this.width * this.height;
                }
                long[] data2 = new long[this.data.length];
                block0: while (total < limit) {
                    if (!this.tallied) {
                        this.tally();
                    }
                    int tmp = rng.nextInt(this.ct);
                    for (int s = 0; s < this.ySections; ++s) {
                        for (int x = 0; x < this.width; ++x) {
                            int ct = this.counts[x * this.ySections + s];
                            if (ct <= tmp) continue;
                            long t = this.data[x * this.ySections + s];
                            long w = BitConversion.lowestOneBit((long)t);
                            --ct;
                            while (w != 0L) {
                                if (ct == tmp) {
                                    this.removeRectangle(x - minimumDistance, (s << 6 | Long.numberOfTrailingZeros(w)) - minimumDistance, minimumDistance << 1 | 1, minimumDistance << 1 | 1);
                                    int n = x * this.ySections + s;
                                    data2[n] = data2[n] | w;
                                    ++total;
                                    continue block0;
                                }
                                w = BitConversion.lowestOneBit((long)(t ^= w));
                                --ct;
                            }
                        }
                    }
                }
                this.data = data2;
                this.tallied = false;
            }
        }
        return result;
    }

    public float rateDensity() {
        float result = 0.0f;
        float sz = this.height * this.width;
        if (sz != 0.0f) {
            float onAmount = sz - (float)this.size();
            float retractedOn = sz - (float)this.copy().retract().size();
            result = (onAmount + retractedOn) / (sz * 2.0f);
        }
        return result;
    }

    public float rateRegularity() {
        float result = 0.0f;
        Region me2 = this.copy().surface8way();
        float irregularCount = me2.size();
        if (irregularCount != 0.0f) {
            result = (float)me2.remake(this).surface().size() / irregularCount;
        }
        return result;
    }

    private static int median(int[] working, int start, int amount) {
        Arrays.sort(working, start, start + amount);
        int result = (amount & 1) == 0 ? working[start + (amount >> 1) - 1] + working[start + (amount >> 1)] >>> 1 : working[start + (amount >> 1)];
        return result;
    }

    public void perceptualHashQuick(long[] into, int[] working) {
        int bits = 8 << (Integer.numberOfTrailingZeros(Integer.highestOneBit(into.length)) >> 1);
        if (working == null || working.length < bits * bits) {
            working = new int[bits * bits];
        }
        int blockWidth = this.width / bits;
        int blockHeight = this.height / bits;
        int blockWidthSections = blockWidth * this.ySections;
        if (blockHeight == 1) {
            for (int y = 0; y < bits; ++y) {
                for (int x = 0; x < bits; ++x) {
                    int value = 0;
                    for (int ix = 0; ix < blockWidthSections; ix += this.ySections) {
                        value = (int)((long)value + (this.data[x * blockWidthSections + ix + (y >> 6)] >>> (y & 0x3F) & 1L));
                    }
                    working[x * bits + y] = value;
                }
            }
        } else if (blockHeight < 64 && Integer.bitCount(blockHeight) == 1) {
            long yBlockMask = -1L << blockHeight ^ 0xFFFFFFFFFFFFFFFFL;
            int divisorMask = 64 / blockHeight - 1;
            int blockY = 0;
            int y = 0;
            while (y < bits) {
                long currentMask = yBlockMask << ((y & divisorMask) << blockHeight);
                for (int x = 0; x < bits; ++x) {
                    int value = 0;
                    for (int ix = 0; ix < blockWidthSections; ix += this.ySections) {
                        value += Long.bitCount(this.data[x * blockWidthSections + ix + (blockY >> 6)] & currentMask);
                    }
                    working[x * bits + y] = value;
                }
                ++y;
                blockY += blockHeight;
            }
        }
        int cellsPerBlock = blockWidth * blockHeight;
        int numBlocks = bits * bits;
        int halfCellCount = cellsPerBlock >>> 1;
        int bandSize = numBlocks >>> 2;
        int currentInto = 0;
        long currentIntoPos = 1L;
        for (int i = 0; i < 4; ++i) {
            int m = Region.median(working, i * bandSize, bandSize);
            for (int j = i * bandSize; j < (i + 1) * bandSize; ++j) {
                int v = working[j];
                if (v > m || v - m == 0 && m > halfCellCount) {
                    int n = currentInto;
                    into[n] = into[n] | currentIntoPos;
                }
                if ((currentIntoPos <<= 1) != 0L) continue;
                ++currentInto;
                currentIntoPos = 1L;
            }
        }
    }

    public Coord[] asCoords() {
        return this.asCoords(new Coord[this.size()]);
    }

    public Coord[] asCoords(Coord[] points) {
        Coord[] result = null;
        if (points == null) {
            points = new Coord[this.size()];
        }
        int idx = 0;
        int len = points.length;
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                long t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                long w = BitConversion.lowestOneBit((long)t);
                while (w != 0L) {
                    if (idx >= len) {
                        result = points;
                        break;
                    }
                    points[idx++] = Coord.get(x, s << 6 | Long.numberOfTrailingZeros(w));
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                }
                if (result != null) break;
            }
            if (result != null) break;
        }
        if (result == null) {
            result = points;
        }
        return result;
    }

    public int[] asEncoded() {
        int ct = this.size();
        int idx = 0;
        int[] points = new int[ct];
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                long t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                long w = BitConversion.lowestOneBit((long)t);
                while (w != 0L) {
                    points[idx++] = Coord.pureEncode(x, s << 6 | Long.numberOfTrailingZeros(w));
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                }
            }
        }
        return points;
    }

    public int[] asTightEncoded() {
        int ct = this.size();
        int idx = 0;
        int[] points = new int[ct];
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                long t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                long w = BitConversion.lowestOneBit((long)t);
                while (w != 0L) {
                    points[idx++] = (s << 6 | Long.numberOfTrailingZeros(w)) * this.width + x;
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                }
            }
        }
        return points;
    }

    public Coord first() {
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                long w = this.data[x * this.ySections + s];
                if (w == 0L) continue;
                return Coord.get(x, s << 6 | Long.numberOfTrailingZeros(w));
            }
        }
        return Coord.get(-1, -1);
    }

    public int firstTight() {
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                long w = this.data[x * this.ySections + s];
                if (w == 0L) continue;
                return (s << 6 | Long.numberOfTrailingZeros(w)) * this.width + x;
            }
        }
        return -1;
    }

    public Coord last() {
        for (int x = this.width - 1; x >= 0; --x) {
            for (int s = this.ySections - 1; s >= 0; --s) {
                long w = this.data[x * this.ySections + s];
                if (w == 0L) continue;
                return Coord.get(x, s << 6 | 63 - Long.numberOfLeadingZeros(w));
            }
        }
        return Coord.get(-1, -1);
    }

    public int lastTight() {
        for (int x = this.width - 1; x >= 0; --x) {
            for (int s = this.ySections - 1; s >= 0; --s) {
                long w = this.data[x * this.ySections + s];
                if (w == 0L) continue;
                return (s << 6 | 63 - Long.numberOfLeadingZeros(w)) * this.width + x;
            }
        }
        return -1;
    }

    public Coord nth(int index) {
        if (index < 0) {
            return Coord.get(-1, -1);
        }
        int ct = this.size();
        if (index >= ct) {
            return Coord.get(-1, -1);
        }
        for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                ct = this.counts[x * this.ySections + s];
                if (ct <= index) continue;
                long t = this.data[x * this.ySections + s];
                long w = BitConversion.lowestOneBit((long)t);
                --ct;
                while (w != 0L) {
                    if (ct == index) {
                        return Coord.get(x, s << 6 | Long.numberOfTrailingZeros(w));
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                    --ct;
                }
            }
        }
        return Coord.get(-1, -1);
    }

    public Coord atFraction(float fraction) {
        int ct = this.size();
        if (ct <= 0) {
            return Coord.get(-1, -1);
        }
        int tmp = Math.abs((int)(fraction * (float)ct) % ct);
        for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                ct = this.counts[x * this.ySections + s];
                if (ct <= tmp) continue;
                long t = this.data[x * this.ySections + s];
                long w = BitConversion.lowestOneBit((long)t);
                --ct;
                while (w != 0L) {
                    if (ct == tmp) {
                        return Coord.get(x, s << 6 | Long.numberOfTrailingZeros(w));
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                    --ct;
                }
            }
        }
        return Coord.get(-1, -1);
    }

    public int atFractionTight(float fraction) {
        int ct = this.size();
        if (ct <= 0) {
            return -1;
        }
        int tmp = Math.abs((int)(fraction * (float)ct) % ct);
        for (int x = 0; x < this.width; ++x) {
            for (int s = 0; s < this.ySections; ++s) {
                ct = this.counts[x * this.ySections + s];
                if (ct <= tmp) continue;
                long t = this.data[x * this.ySections + s];
                long w = BitConversion.lowestOneBit((long)t);
                --ct;
                while (w != 0L) {
                    if (ct == tmp) {
                        return (s << 6 | Long.numberOfTrailingZeros(w)) * this.width + x;
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                    --ct;
                }
            }
        }
        return -1;
    }

    public Coord singleRandom(EnhancedRandom rng) {
        int ct = this.size();
        int tmp = rng.nextInt(ct);
        for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                ct = this.counts[x * this.ySections + s];
                if (ct <= tmp) continue;
                long t = this.data[x * this.ySections + s] | 0L;
                --ct;
                while (t != 0L) {
                    long w = BitConversion.lowestOneBit((long)t);
                    if (ct == tmp) {
                        return Coord.get(x, s << 6 | Long.bitCount(w - 1L));
                    }
                    t ^= w;
                    --ct;
                }
            }
        }
        return Coord.get(-1, -1);
    }

    public int singleRandomTight(EnhancedRandom rng) {
        int ct = this.size();
        int tmp = rng.nextInt(ct);
        for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                ct = this.counts[x * this.ySections + s];
                if (ct <= tmp) continue;
                long t = this.data[x * this.ySections + s];
                long w = BitConversion.lowestOneBit((long)t);
                --ct;
                while (w != 0L) {
                    if (ct == tmp) {
                        return (s << 6 | Long.numberOfTrailingZeros(w)) * this.width + x;
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                    --ct;
                }
            }
        }
        return -1;
    }

    public static int interleaveBits(int x, int y) {
        x |= y << 16;
        x = (x & 0xFF00) << 8 | x >>> 8 & 0xFF00 | x & 0xFF0000FF;
        x = (x & 0xF000F0) << 4 | x >>> 4 & 0xF000F0 | x & 0xF00FF00F;
        x = (x & 0xC0C0C0C) << 2 | x >>> 2 & 0xC0C0C0C | x & 0xC3C3C3C3;
        return (x & 0x22222222) << 1 | x >>> 1 & 0x22222222 | x & 0x99999999;
    }

    public static int disperseBits(int n) {
        n = (n & 0x22222222) << 1 | n >>> 1 & 0x22222222 | n & 0x99999999;
        n = (n & 0xC0C0C0C) << 2 | n >>> 2 & 0xC0C0C0C | n & 0xC3C3C3C3;
        n = (n & 0xF000F0) << 4 | n >>> 4 & 0xF000F0 | n & 0xF00FF00F;
        return (n & 0xFF00) << 8 | n >>> 8 & 0xFF00 | n & 0xFF0000FF;
    }

    public Coord[] separatedBlue(float fraction) {
        return this.separatedBlue(fraction, -1);
    }

    public Coord[] separatedBlue(float fraction, int limit) {
        int ct;
        if (fraction <= 0.0f) {
            return new Coord[0];
        }
        if (fraction > 0.99609375f) {
            fraction = 0.99609375f;
        }
        if (limit >= (ct = this.size())) {
            return this.asCoords();
        }
        return this.copy().separatedRegionBlue(fraction, limit).asCoords();
    }

    public Region separatedRegionBlue(float fraction) {
        return this.separatedRegionBlue(fraction, -1);
    }

    public Region separatedRegionBlue(float fraction, int limit) {
        int ct;
        if (fraction <= 0.0f) {
            return this.empty();
        }
        if (fraction > 0.99609375f) {
            fraction = 0.99609375f;
        }
        if (limit >= (ct = this.size())) {
            return this;
        }
        ct = (int)((float)ct * fraction);
        if (limit >= 0 && limit < ct) {
            ct = limit;
        }
        for (int i = 255; i >= 0; --i) {
            if (ct < this.andWrapping64(BLUE_LEVELS[i]).size()) continue;
            return this;
        }
        return this;
    }

    public Coord[] randomPortion(EnhancedRandom rng, int size) {
        int ct = this.size();
        int idx = 0;
        int run = 0;
        if (ct <= 0 || size <= 0) {
            return new Coord[0];
        }
        if (ct <= size) {
            return this.asCoords();
        }
        Coord[] points = new Coord[size];
        int[] order = ArrayTools.range((int)ct);
        rng.shuffle(order);
        Arrays.sort(order, 0, size);
        block0: for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                long t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                long w = BitConversion.lowestOneBit((long)t);
                while (w != 0L) {
                    if (run++ == order[idx]) {
                        points[idx++] = Coord.get(x, s << 6 | Long.numberOfTrailingZeros(w));
                        if (idx >= size) break block0;
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                }
            }
        }
        return points;
    }

    public Region randomRegion(EnhancedRandom rng, int size) {
        int ct = this.size();
        int idx = 0;
        int run = 0;
        if (ct <= 0 || size <= 0) {
            return this.empty();
        }
        if (ct <= size) {
            return this;
        }
        int[] order = ArrayTools.range((int)ct);
        rng.shuffle(order);
        Arrays.sort(order, 0, size);
        block0: for (int s = 0; s < this.ySections; ++s) {
            for (int x = 0; x < this.width; ++x) {
                long t = this.data[x * this.ySections + s];
                if (t == 0L) continue;
                long w = BitConversion.lowestOneBit((long)t);
                while (w != 0L) {
                    if (run++ == order[idx]) {
                        if (++idx >= size) {
                            break block0;
                        }
                    } else {
                        int n = x * this.ySections + s;
                        this.data[n] = this.data[n] & (1L << Long.numberOfTrailingZeros(w) ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                    w = BitConversion.lowestOneBit((long)(t ^= w));
                }
            }
        }
        this.tallied = false;
        return this;
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height && this.ySections > 0 && (this.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) != 0L;
    }

    @Override
    public boolean isEmpty() {
        if (this.tallied) {
            return this.ct > 0;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static int[][] sum(Region ... regions) {
        if (regions == null || regions.length <= 0) {
            return new int[0][0];
        }
        int w = regions[0].width;
        int h = regions[0].height;
        int l = regions.length;
        int ys = regions[0].ySections;
        int[][] numbers = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    int[] nArray = numbers[x];
                    int n = y;
                    nArray[n] = nArray[n] + ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1 : 0);
                }
            }
        }
        return numbers;
    }

    public static int[][] sum(List<Region> regions) {
        if (regions == null || regions.isEmpty()) {
            return new int[0][0];
        }
        Region t = regions.get(0);
        int w = t.width;
        int h = t.height;
        int l = regions.size();
        int ys = t.ySections;
        int[][] numbers = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    int[] nArray = numbers[x];
                    int n = y;
                    nArray[n] = nArray[n] + ((regions.get((int)i).data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1 : 0);
                }
            }
        }
        return numbers;
    }

    public static float[][] sumFloat(Region ... regions) {
        if (regions == null || regions.length <= 0) {
            return new float[0][0];
        }
        int w = regions[0].width;
        int h = regions[0].height;
        int l = regions.length;
        int ys = regions[0].ySections;
        float[][] numbers = new float[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    float[] fArray = numbers[x];
                    int n = y;
                    fArray[n] = fArray[n] + ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1.0f : 0.0f);
                }
            }
        }
        return numbers;
    }

    public static float[][] sumFloat(List<Region> regions) {
        if (regions == null || regions.isEmpty()) {
            return new float[0][0];
        }
        Region t = regions.get(0);
        int w = t.width;
        int h = t.height;
        int l = regions.size();
        int ys = t.ySections;
        float[][] numbers = new float[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    float[] fArray = numbers[x];
                    int n = y;
                    fArray[n] = fArray[n] + ((regions.get((int)i).data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1.0f : 0.0f);
                }
            }
        }
        return numbers;
    }

    public static int[][] sumWeighted(Region[] regions, int[] weights) {
        if (regions == null || regions.length <= 0 || weights == null || weights.length < regions.length) {
            return new int[0][0];
        }
        int w = regions[0].width;
        int h = regions[0].height;
        int l = regions.length;
        int ys = regions[0].ySections;
        int[][] numbers = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    int[] nArray = numbers[x];
                    int n = y;
                    nArray[n] = nArray[n] + ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? weights[i] : 0);
                }
            }
        }
        return numbers;
    }

    public static float[][] sumWeightedFloat(Region[] regions, float[] weights) {
        if (regions == null || regions.length <= 0 || weights == null || weights.length < regions.length) {
            return new float[0][0];
        }
        int w = regions[0].width;
        int h = regions[0].height;
        int l = regions.length;
        int ys = regions[0].ySections;
        float[][] numbers = new float[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    float[] fArray = numbers[x];
                    int n = y;
                    fArray[n] = (float)((double)fArray[n] + ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? (double)weights[i] : 0.0));
                }
            }
        }
        return numbers;
    }

    public static int[][] sumInto(int[][] existing, Region ... regions) {
        if (regions == null || regions.length <= 0 || existing == null || existing.length == 0 || existing[0].length == 0) {
            return existing;
        }
        int w = existing.length;
        int h = existing[0].length;
        for (Region region : regions) {
            int ys = region.ySections;
            for (int x = 0; x < w && x < region.width; ++x) {
                for (int y = 0; y < h && y < region.height; ++y) {
                    int[] nArray = existing[x];
                    int n = y;
                    nArray[n] = nArray[n] + ((region.data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1 : 0);
                }
            }
        }
        return existing;
    }

    public static float[][] sumIntoFloat(float[][] existing, Region ... regions) {
        if (regions == null || regions.length <= 0 || existing == null || existing.length == 0 || existing[0].length == 0) {
            return existing;
        }
        int w = existing.length;
        int h = existing[0].length;
        int l = regions.length;
        int ys = regions[0].ySections;
        for (int i = 0; i < l; ++i) {
            for (int x = 0; x < w && x < regions[i].width; ++x) {
                for (int y = 0; y < h && y < regions[i].height; ++y) {
                    float[] fArray = existing[x];
                    int n = y;
                    fArray[n] = (float)((double)fArray[n] + ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1.0 : 0.0));
                }
            }
        }
        return existing;
    }

    public static int[][] bitSum(Region ... regions) {
        if (regions == null || regions.length <= 0) {
            return new int[0][0];
        }
        int w = regions[0].width;
        int h = regions[0].height;
        int l = Math.min(32, regions.length);
        int ys = regions[0].ySections;
        int[][] numbers = new int[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < l; ++i) {
                    int[] nArray = numbers[x];
                    int n = y;
                    nArray[n] = nArray[n] | ((regions[i].data[x * ys + (y >> 6)] & 1L << (y & 0x3F)) != 0L ? 1 << i : 0);
                }
            }
        }
        return numbers;
    }

    public int[][] dijkstraScan(int[][] into, Coord goal) {
        return this.dijkstraScan(into, goal, Integer.MAX_VALUE);
    }

    public int[][] dijkstraScan(int[][] into, Coord goal, int limit) {
        Region goals = new Region(goal, this.width, this.height);
        ArrayTools.fill((int[][])into, (int)Integer.MAX_VALUE);
        for (int i = 0; i < limit; ++i) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if ((goals.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L || into[x][y] <= i) continue;
                    into[x][y] = i;
                }
            }
            int sz = goals.size();
            goals.flood(this);
            if (sz == goals.size()) break;
        }
        return into;
    }

    public int[][] dijkstraScan(int[][] into, Region goals) {
        return this.dijkstraScan(into, goals, Integer.MAX_VALUE);
    }

    public int[][] dijkstraScan(int[][] into, Region goals, int limit) {
        ArrayTools.fill((int[][])into, (int)Integer.MAX_VALUE);
        for (int i = 0; i < limit; ++i) {
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if ((goals.data[x * this.ySections + (y >> 6)] & 1L << (y & 0x3F)) == 0L || into[x][y] <= i) continue;
                    into[x][y] = i;
                }
            }
            int sz = goals.size();
            goals.flood(this);
            if (sz == goals.size()) break;
        }
        return into;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region that = (Region)o;
        if (this.height != that.height) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.ySections != that.ySections) {
            return false;
        }
        if (this.yEndMask != that.yEndMask) {
            return false;
        }
        return Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return Hasher.gremory.hash(this.data) ^ (int)Hasher.randomize2((long)(Hasher.randomize2((long)this.height) + (long)this.width));
    }

    public long hash64() {
        return Hasher.gremory.hash64(this.data) ^ Hasher.randomize2((long)(Hasher.randomize2((long)this.height) + (long)this.width));
    }

    public long hash64(long seed) {
        return Hasher.hash64((long)seed, (long[])this.data) ^ Hasher.randomize2((long)(Hasher.randomize2((long)this.height) + (long)this.width));
    }

    public String serializeToString() {
        return this.width + "," + this.height + "," + StringTools.joinAlt((CharSequence)",", (long[])this.data);
    }

    public static Region deserializeFromString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        int gap = s.indexOf(44);
        int w = Integer.parseInt(s.substring(0, gap));
        int gap2 = s.indexOf(44, gap + 1);
        int h = Integer.parseInt(s.substring(gap + 1, gap2));
        String[] splits = StringTools.split((String)s.substring(gap2 + 1), (String)",");
        long[] data = new long[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            data[i] = DigitTools.longFromDec((CharSequence)splits[i]);
        }
        return new Region(data, w, h);
    }

    public static Region of(int width, int height, long ... data) {
        return new Region(data, width, height);
    }

    public String toCompressedString() {
        HilbertCurve.init2D();
        StringBuilder packing = new StringBuilder(this.width * this.height >> 3);
        DigitTools.appendHex((StringBuilder)packing, (int)this.width);
        DigitTools.appendHex((StringBuilder)packing, (int)this.height);
        int chunksX = this.width + 255 >> 8;
        int chunksY = this.height + 127 >> 7;
        int bigX = 0;
        int baseX = 0;
        while (bigX < chunksX) {
            int bigY = 0;
            int baseY = 0;
            while (bigY < chunksY) {
                packing.append(';');
                boolean on = false;
                int skip = 0;
                int xSize = Math.min(256, this.width - baseX);
                int ySize = Math.min(128, this.height - baseY);
                int limit = 32768;
                int mapLimit = xSize * ySize;
                if (xSize <= 128) {
                    limit >>= 1;
                    if (xSize <= 64) {
                        limit >>= 1;
                        if (ySize <= 64) {
                            limit >>= 1;
                            if (ySize <= 32) {
                                limit >>= 1;
                                if (xSize <= 32) {
                                    limit >>= 1;
                                }
                            }
                        }
                    }
                }
                int i = 0;
                int ml = 0;
                while (i < limit && ml < mapLimit) {
                    char hx = HilbertCurve.hilbertX[i];
                    char hy = HilbertCurve.hilbertY[i];
                    if (hx >= xSize || hy >= ySize) {
                        if (on) {
                            on = false;
                            packing.append((char)(skip + 256));
                            skip = 0;
                        }
                    } else {
                        boolean current;
                        ++ml;
                        boolean bl = current = (this.data[(baseX + hx) * this.ySections + (baseY + hy >> 6)] & 1L << hy) != 0L;
                        if (current != on) {
                            packing.append((char)(skip + 256));
                            skip = 0;
                            on = current;
                        }
                    }
                    ++i;
                    skip = (char)(skip + 1);
                }
                if (on) {
                    packing.append((char)(skip + 256));
                }
                ++bigY;
                baseY += 128;
            }
            ++bigX;
            baseX += 256;
        }
        return LZSEncoding.compressToUTF16((String)packing.toString());
    }

    public static Region decompress(String compressed) {
        HilbertCurve.init2D();
        compressed = LZSEncoding.decompressFromUTF16((String)compressed);
        int width = DigitTools.intFromHex((CharSequence)compressed);
        int height = DigitTools.intFromHex((CharSequence)compressed, (int)8, (int)16);
        Region target = new Region(width, height);
        int chunksX = width + 255 >> 8;
        int chunksY = height + 127 >> 7;
        int startPack = 16;
        int bigX = 0;
        int baseX = 0;
        while (bigX < chunksX) {
            int bigY = 0;
            int baseY = 0;
            while (bigY < chunksY) {
                int endPack;
                if ((endPack = compressed.indexOf(59, ++startPack)) < 0) {
                    endPack = compressed.length();
                }
                boolean on = false;
                int idx = 0;
                for (int p = startPack; p < endPack; ++p) {
                    if (on) {
                        int toSkip = idx + (compressed.charAt(p) - 256);
                        while (idx < toSkip && idx < 32768) {
                            target.insert(HilbertCurve.hilbertX[idx] + baseX, HilbertCurve.hilbertY[idx] + baseY);
                            ++idx;
                        }
                    } else {
                        idx += compressed.charAt(p) - 256;
                    }
                    on = !on;
                }
                startPack = endPack;
                ++bigY;
                baseY += 128;
            }
            ++bigX;
            baseX += 256;
        }
        return target;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Coord) {
            return this.contains((Coord)o);
        }
        return false;
    }

    @Override
    public Iterator<Coord> iterator() {
        return new GRIterator();
    }

    @Override
    public Object[] toArray() {
        return this.asCoords();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a instanceof Coord[]) {
            return this.asCoords((Coord[])a);
        }
        return a;
    }

    @Override
    public boolean add(Coord coord) {
        if (this.contains(coord)) {
            return false;
        }
        this.insert(coord);
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Coord) {
            if (this.contains((Coord)o)) {
                this.remove((Coord)o);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Coord> c) {
        boolean changed = false;
        for (Coord coord : c) {
            changed |= this.add(coord);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Region g2 = new Region(this.width, this.height);
        for (Object o : c) {
            if (!this.contains(o) || !(o instanceof Coord)) continue;
            g2.add((Coord)o);
        }
        boolean changed = this.equals(g2);
        this.remake(g2);
        return changed;
    }

    public Region deteriorate(EnhancedRandom rng, int preservation) {
        if (rng == null || this.width <= 2 || this.ySections <= 0 || preservation <= 0) {
            return this;
        }
        int i = 0;
        while (i < this.width * this.ySections) {
            long mash = rng.nextLong();
            for (int j = i; j < preservation; ++j) {
                mash |= rng.nextLong();
            }
            int n = i++;
            this.data[n] = this.data[n] & mash;
        }
        this.tallied = false;
        return this;
    }

    public Region deteriorate(EnhancedRandom random, float preservation) {
        if (random == null || this.width <= 2 || this.ySections <= 0 || preservation >= 1.0f) {
            return this;
        }
        if (preservation <= 0.0f) {
            return this.empty();
        }
        int bitCount = (int)(preservation * 64.0f);
        int i = 0;
        while (i < this.width * this.ySections) {
            int n = i++;
            this.data[n] = this.data[n] & Region.approximateBits(random, bitCount);
        }
        this.tallied = false;
        return this;
    }

    public Region toggle(int x, int y) {
        if (x >= 0 && y >= 0 && x < this.width && y < this.height && this.ySections > 0) {
            int n = x * this.ySections + (y >> 6);
            this.data[n] = this.data[n] ^ 1L << (y & 0x3F);
            this.tallied = false;
        }
        return this;
    }

    public Region mirrorY() {
        Region next = new Region(this.data, this.width, this.height, this.width * 2, this.height);
        int i = 0;
        int o = this.width * 2 - 1;
        while (i < this.width) {
            System.arraycopy(this.data, this.ySections * i, next.data, this.ySections * o, this.ySections);
            ++i;
            --o;
        }
        return next;
    }

    public boolean contains(Coord c) {
        return c != null && this.contains(c.x, c.y);
    }

    public int xBound(boolean findSmallest) {
        if (findSmallest) {
            return this.first().x;
        }
        return this.last().x;
    }

    public int yBound(boolean findSmallest) {
        long t = 0L;
        if (findSmallest) {
            for (int s = 0; s < this.ySections; ++s) {
                for (int x = 0; x < this.width; ++x) {
                    t |= this.data[x * this.ySections + s];
                }
                if (t == 0L) continue;
                return s << 6 | Long.numberOfTrailingZeros(t);
            }
            return -1;
        }
        for (int s = this.ySections - 1; s >= 0; --s) {
            for (int x = 0; x < this.width; ++x) {
                t |= this.data[x * this.ySections + s];
            }
            if (t == 0L) continue;
            return s << 6 | 63 - Long.numberOfLeadingZeros(t);
        }
        return -1;
    }

    static {
        Region.BLUE_LEVELS[0] = new Region(64, 64);
        for (int i = -127; i < 128; ++i) {
            Region.BLUE_LEVELS[i + 128] = new Region(BlueNoise.RAW_2D, -128, i);
        }
    }

    public class GRIterator
    implements Iterator<Coord> {
        public int index;
        private long t;
        private long w;

        public GRIterator() {
            if (!Region.this.tallied) {
                Region.this.tally();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < Region.this.ct;
        }

        @Override
        public Coord next() {
            if (this.index >= Region.this.ct) {
                return null;
            }
            for (int s = 0; s < Region.this.ySections; ++s) {
                for (int x = 0; x < Region.this.width; ++x) {
                    int c = Region.this.counts[x * Region.this.ySections + s];
                    if (c <= this.index) continue;
                    this.t = Region.this.data[x * Region.this.ySections + s] | 0L;
                    --c;
                    while (this.t != 0L) {
                        this.w = BitConversion.lowestOneBit((long)this.t);
                        if (c == this.index) {
                            ++this.index;
                            return Coord.get(x, s << 6 | Long.bitCount(this.w - 1L));
                        }
                        this.t ^= this.w;
                        --c;
                    }
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on this Iterator.");
        }
    }
}

