/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.TrigTools;
import com.github.tommyettinger.random.Ziggurat;

public final class RotationTools {
    private RotationTools() {
    }

    public static void rotate(float[] input, float[] rotation, float[] output) {
        int m = 0;
        for (int r = 0; r < input.length; ++r) {
            int c = 0;
            while (c < output.length) {
                int n = c++;
                output[n] = output[n] + rotation[m++] * input[r];
            }
        }
    }

    public static void matrixMultiply(float[] lf, float[] rt, float[] out, int side) {
        int o = 0;
        for (int r = 0; r < side; ++r) {
            for (int c = 0; c < side; ++c) {
                for (int i = 0; i < side; ++i) {
                    int n = o;
                    out[n] = out[n] + lf[r * side + i] * rt[side * i + c];
                }
                ++o;
            }
        }
    }

    private static long randomize(long state) {
        state = (state ^ 0xDB4F0B9175AE2165L) * -4126379630918251389L;
        state = (state ^ state >>> 27) * -5840758589994634535L;
        return state ^ state >>> 25;
    }

    private static float[] rotateStep(long seed, float[] small, int targetSize) {
        float t;
        int smallSize = targetSize - 1;
        int squareSize = targetSize * targetSize;
        float[] gauss = new float[targetSize];
        float[] house = new float[squareSize];
        float[] large = new float[squareSize];
        float[] out = new float[squareSize];
        for (int i = 0; i < smallSize; ++i) {
            System.arraycopy(small, i * smallSize, large, i * targetSize + targetSize + 1, smallSize);
        }
        large[0] = 1.0f;
        seed = RotationTools.randomize(seed + (long)squareSize);
        float sum = 0.0f;
        for (int i = 0; i < targetSize; ++i) {
            gauss[i] = t = (float)Ziggurat.normal((long)RotationTools.randomize(seed += -7046029254386353131L));
            sum += t * t;
        }
        float inv = 1.0f / (float)Math.sqrt(sum);
        sum = 0.0f;
        t = 1.0f;
        int i = 0;
        while (i < targetSize) {
            int n = i++;
            float f = gauss[n] * inv;
            gauss[n] = f;
            sum += (t -= f) * t;
            t = 0.0f;
        }
        sum = 1.4142135f / (float)Math.sqrt(sum);
        t = 1.0f;
        for (i = 0; i < targetSize; ++i) {
            gauss[i] = (t - gauss[i]) * sum;
            t = 0.0f;
        }
        int h = 0;
        for (int row = 0; row < targetSize; ++row) {
            int col = 0;
            while (col < targetSize) {
                house[h] = gauss[row] * gauss[col];
                ++col;
                ++h;
            }
        }
        for (i = 0; i < targetSize; ++i) {
            int n = targetSize * i + i;
            house[n] = house[n] - 1.0f;
        }
        RotationTools.matrixMultiply(house, large, out, targetSize);
        return out;
    }

    public static float[] randomRotation2D(long seed) {
        int index = (int)(RotationTools.randomize(seed * -7046029254386353131L) >>> 50);
        float s = TrigTools.SIN_TABLE[index];
        float c = TrigTools.SIN_TABLE[index + 4096 & 0x3FFF];
        return new float[]{c, s, -s, c};
    }

    public static float[] randomRotation3D(long seed) {
        return RotationTools.rotateStep(seed, RotationTools.randomRotation2D(seed - 3L), 3);
    }

    public static float[] randomRotation3D(long seed, float[] rotation2D) {
        return RotationTools.rotateStep(seed, rotation2D, 3);
    }

    public static float[] randomRotation4D(long seed) {
        return RotationTools.rotateStep(seed, RotationTools.randomRotation3D(seed - 4L), 4);
    }

    public static float[] randomRotation4D(long seed, float[] rotation3D) {
        return RotationTools.rotateStep(seed, rotation3D, 4);
    }

    public static float[] randomRotation5D(long seed) {
        return RotationTools.rotateStep(seed, RotationTools.randomRotation4D(seed - 5L), 5);
    }

    public static float[] randomRotation5D(long seed, float[] rotation4D) {
        return RotationTools.rotateStep(seed, rotation4D, 5);
    }

    public static float[] randomRotation6D(long seed) {
        return RotationTools.rotateStep(seed, RotationTools.randomRotation5D(seed - 6L), 6);
    }

    public static float[] randomRotation6D(long seed, float[] rotation5D) {
        return RotationTools.rotateStep(seed, rotation5D, 6);
    }
}

