/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.MathTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.grid.INoise;
import com.github.yellowstonegames.grid.LongPointHash;
import com.github.yellowstonegames.grid.Noise;

public class SimplexNoise
implements INoise {
    public long seed;
    public static final SimplexNoise instance = new SimplexNoise();
    public static final float F2 = 0.36602542f;
    public static final float G2 = 0.21132487f;
    public static final float H2 = 0.42264974f;
    public static final float LIMIT2 = 0.5f;
    public static final float F3 = 0.33333334f;
    public static final float G3 = 0.16666667f;
    public static final float LIMIT3 = 0.6f;
    public static final float F4 = (float)((Math.sqrt(5.0) - 1.0) * 0.25);
    public static final float G4 = (float)((5.0 - Math.sqrt(5.0)) * 0.05);
    public static final float LIMIT4 = 0.4675f;
    public static final float F5 = (float)((Math.sqrt(6.0) - 1.0) / 5.0);
    public static final float G5 = (float)((6.0 - Math.sqrt(6.0)) / 30.0);
    public static final float LIMIT5 = 0.67f;
    public static final float F6 = (float)((Math.sqrt(7.0) - 1.0) / 6.0);
    public static final float G6 = (float)((double)F6 / (1.0 + 6.0 * (double)F6));
    public static final float LIMIT6 = 0.69f;

    public SimplexNoise() {
        this.seed = 21130147473954L;
    }

    public SimplexNoise(long seed) {
        this.seed = seed;
    }

    protected static float gradCoord2D(long seed, int x, int y, float xd, float yd) {
        int h = LongPointHash.hash256(x, y, seed) << 1;
        return xd * Noise.GRADIENTS_2D[h] + yd * Noise.GRADIENTS_2D[h + 1];
    }

    protected static float gradCoord3D(long seed, int x, int y, int z, float xd, float yd, float zd) {
        int hash = LongPointHash.hash32(x, y, z, seed) << 2;
        return xd * Noise.GRADIENTS_3D[hash] + yd * Noise.GRADIENTS_3D[hash + 1] + zd * Noise.GRADIENTS_3D[hash + 2];
    }

    protected static float gradCoord5D(long seed, int x, int y, int z, int w, int u, float xd, float yd, float zd, float wd, float ud) {
        int hash = LongPointHash.hash256(x, y, z, w, u, seed) << 3;
        return xd * Noise.GRADIENTS_5D[hash] + yd * Noise.GRADIENTS_5D[hash + 1] + zd * Noise.GRADIENTS_5D[hash + 2] + wd * Noise.GRADIENTS_5D[hash + 3] + ud * Noise.GRADIENTS_5D[hash + 4];
    }

    @Override
    public float getNoise(float x, float y) {
        return SimplexNoise.noise(x, y, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z) {
        return SimplexNoise.noise(x, y, z, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        return SimplexNoise.noise(x, y, z, w, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        return SimplexNoise.noise(x, y, z, w, u, this.seed);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        return SimplexNoise.noise(x, y, z, w, u, v, this.seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, long seed) {
        return SimplexNoise.noise(x, y, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, long seed) {
        return SimplexNoise.noise(x, y, z, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        return SimplexNoise.noise(x, y, z, w, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        return SimplexNoise.noise(x, y, z, w, u, seed);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        return SimplexNoise.noise(x, y, z, w, u, v, seed);
    }

    public static float noise(float x, float y, long seed) {
        int j1;
        int i1;
        float Y0;
        float y0;
        int j;
        float t = (x + y) * 0.36602542f;
        int i = MathTools.fastFloor((float)(x + t));
        float X0 = (float)i - (t = (float)(i + (j = MathTools.fastFloor((float)(y + t)))) * 0.21132487f);
        float x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (float)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        float x1 = x0 - (float)i1 + 0.21132487f;
        float y1 = y0 - (float)j1 + 0.21132487f;
        float x2 = x0 - 1.0f + 0.42264974f;
        float y2 = y0 - 1.0f + 0.42264974f;
        float n0 = 0.5f - x0 * x0 - y0 * y0;
        if (n0 > 0.0f) {
            n0 *= n0;
            n0 *= n0 * SimplexNoise.gradCoord2D(seed, i, j, x0, y0);
        } else {
            n0 = 0.0f;
        }
        float n1 = 0.5f - x1 * x1 - y1 * y1;
        if (n1 > 0.0f) {
            n1 *= n1;
            n1 *= n1 * SimplexNoise.gradCoord2D(seed, i + i1, j + j1, x1, y1);
        } else {
            n1 = 0.0f;
        }
        float n2 = 0.5f - x2 * x2 - y2 * y2;
        if (n2 > 0.0f) {
            n2 *= n2;
            n2 *= n2 * SimplexNoise.gradCoord2D(seed, i + 1, j + 1, x2, y2);
        } else {
            n2 = 0.0f;
        }
        return (n0 + n1 + n2) * 99.206894f;
    }

    public static float noise(float x, float y, float z, long seed) {
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        float s = (x + y + z) * 0.33333334f;
        int i = MathTools.fastFloor((float)(x + s));
        int j = MathTools.fastFloor((float)(y + s));
        int k = MathTools.fastFloor((float)(z + s));
        float t = (float)(i + j + k) * 0.16666667f;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        float x1 = x0 - (float)i1 + 0.16666667f;
        float y1 = y0 - (float)j1 + 0.16666667f;
        float z1 = z0 - (float)k1 + 0.16666667f;
        float x2 = x0 - (float)i2 + 0.33333334f;
        float y2 = y0 - (float)j2 + 0.33333334f;
        float z2 = z0 - (float)k2 + 0.33333334f;
        float x3 = x0 - 0.5f;
        float y3 = y0 - 0.5f;
        float z3 = z0 - 0.5f;
        float n0 = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
        if (n0 > 0.0f) {
            n0 *= n0;
            n0 *= n0 * SimplexNoise.gradCoord3D(seed, i, j, k, x0, y0, z0);
        } else {
            n0 = 0.0f;
        }
        float n1 = 0.6f - x1 * x1 - y1 * y1 - z1 * z1;
        if (n1 > 0.0f) {
            n1 *= n1;
            n1 *= n1 * SimplexNoise.gradCoord3D(seed, i + i1, j + j1, k + k1, x1, y1, z1);
        } else {
            n1 = 0.0f;
        }
        float n2 = 0.6f - x2 * x2 - y2 * y2 - z2 * z2;
        if (n2 > 0.0f) {
            n2 *= n2;
            n2 *= n2 * SimplexNoise.gradCoord3D(seed, i + i2, j + j2, k + k2, x2, y2, z2);
        } else {
            n2 = 0.0f;
        }
        float n3 = 0.6f - x3 * x3 - y3 * y3 - z3 * z3;
        if (n3 > 0.0f) {
            n3 *= n3;
            n3 *= n3 * SimplexNoise.gradCoord3D(seed, i + 1, j + 1, k + 1, x3, y3, z3);
        } else {
            n3 = 0.0f;
        }
        return 31.5f * (n0 + n1 + n2 + n3);
    }

    public static float noise(float x, float y, float z, float w, long seed) {
        float n4;
        float n3;
        float n2;
        float n1;
        float n0;
        float[] gradient4DLUT = Noise.GRADIENTS_4D;
        float t = (x + y + z + w) * F4;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        int l = MathTools.fastFloor((float)(w + t));
        t = (float)(i + j + k + l) * G4;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        int i1 = 2 - rankx >>> 31;
        int j1 = 2 - ranky >>> 31;
        int k1 = 2 - rankz >>> 31;
        int l1 = 2 - rankw >>> 31;
        int i2 = 1 - rankx >>> 31;
        int j2 = 1 - ranky >>> 31;
        int k2 = 1 - rankz >>> 31;
        int l2 = 1 - rankw >>> 31;
        int i3 = -rankx >>> 31;
        int j3 = -ranky >>> 31;
        int k3 = -rankz >>> 31;
        int l3 = -rankw >>> 31;
        float x1 = x0 - (float)i1 + G4;
        float y1 = y0 - (float)j1 + G4;
        float z1 = z0 - (float)k1 + G4;
        float w1 = w0 - (float)l1 + G4;
        float x2 = x0 - (float)i2 + 2.0f * G4;
        float y2 = y0 - (float)j2 + 2.0f * G4;
        float z2 = z0 - (float)k2 + 2.0f * G4;
        float w2 = w0 - (float)l2 + 2.0f * G4;
        float x3 = x0 - (float)i3 + 3.0f * G4;
        float y3 = y0 - (float)j3 + 3.0f * G4;
        float z3 = z0 - (float)k3 + 3.0f * G4;
        float w3 = w0 - (float)l3 + 3.0f * G4;
        float x4 = x0 - 1.0f + 4.0f * G4;
        float y4 = y0 - 1.0f + 4.0f * G4;
        float z4 = z0 - 1.0f + 4.0f * G4;
        float w4 = w0 - 1.0f + 4.0f * G4;
        float t0 = 0.4675f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 > 0.0f) {
            int h0 = LongPointHash.hash256(i, j, k, l, seed) & 0xFC;
            t0 *= t0;
            n0 = t0 * t0 * (x0 * gradient4DLUT[h0] + y0 * gradient4DLUT[h0 | 1] + z0 * gradient4DLUT[h0 | 2] + w0 * gradient4DLUT[h0 | 3]);
        } else {
            n0 = 0.0f;
        }
        float t1 = 0.4675f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t1 > 0.0f) {
            int h1 = LongPointHash.hash256(i + i1, j + j1, k + k1, l + l1, seed) & 0xFC;
            t1 *= t1;
            n1 = t1 * t1 * (x1 * gradient4DLUT[h1] + y1 * gradient4DLUT[h1 | 1] + z1 * gradient4DLUT[h1 | 2] + w1 * gradient4DLUT[h1 | 3]);
        } else {
            n1 = 0.0f;
        }
        float t2 = 0.4675f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t2 > 0.0f) {
            int h2 = LongPointHash.hash256(i + i2, j + j2, k + k2, l + l2, seed) & 0xFC;
            t2 *= t2;
            n2 = t2 * t2 * (x2 * gradient4DLUT[h2] + y2 * gradient4DLUT[h2 | 1] + z2 * gradient4DLUT[h2 | 2] + w2 * gradient4DLUT[h2 | 3]);
        } else {
            n2 = 0.0f;
        }
        float t3 = 0.4675f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t3 > 0.0f) {
            int h3 = LongPointHash.hash256(i + i3, j + j3, k + k3, l + l3, seed) & 0xFC;
            t3 *= t3;
            n3 = t3 * t3 * (x3 * gradient4DLUT[h3] + y3 * gradient4DLUT[h3 | 1] + z3 * gradient4DLUT[h3 | 2] + w3 * gradient4DLUT[h3 | 3]);
        } else {
            n3 = 0.0f;
        }
        float t4 = 0.4675f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t4 > 0.0f) {
            int h4 = LongPointHash.hash256(i + 1, j + 1, k + 1, l + 1, seed) & 0xFC;
            t4 *= t4;
            n4 = t4 * t4 * (x4 * gradient4DLUT[h4] + y4 * gradient4DLUT[h4 | 1] + z4 * gradient4DLUT[h4 | 2] + w4 * gradient4DLUT[h4 | 3]);
        } else {
            n4 = 0.0f;
        }
        t = (n0 + n1 + n2 + n3 + n4) * 141.0f;
        return t / (0.75f + Math.abs(t));
    }

    public static float noise(float x, float y, float z, float w, float u, long seed) {
        float n5;
        float n4;
        float n3;
        float n2;
        float n1;
        float n0;
        float t = (x + y + z + w + u) * F5;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        int l = MathTools.fastFloor((float)(w + t));
        int h = MathTools.fastFloor((float)(u + t));
        t = (float)(i + j + k + l + h) * G5;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float U0 = (float)h - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        float u0 = u - U0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        int ranku = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (x0 > u0) {
            ++rankx;
        } else {
            ++ranku;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (y0 > u0) {
            ++ranky;
        } else {
            ++ranku;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        if (z0 > u0) {
            ++rankz;
        } else {
            ++ranku;
        }
        if (w0 > u0) {
            ++rankw;
        } else {
            ++ranku;
        }
        int i1 = 3 - rankx >>> 31;
        int j1 = 3 - ranky >>> 31;
        int k1 = 3 - rankz >>> 31;
        int l1 = 3 - rankw >>> 31;
        int h1 = 3 - ranku >>> 31;
        int i2 = 2 - rankx >>> 31;
        int j2 = 2 - ranky >>> 31;
        int k2 = 2 - rankz >>> 31;
        int l2 = 2 - rankw >>> 31;
        int h2 = 2 - ranku >>> 31;
        int i3 = 1 - rankx >>> 31;
        int j3 = 1 - ranky >>> 31;
        int k3 = 1 - rankz >>> 31;
        int l3 = 1 - rankw >>> 31;
        int h3 = 1 - ranku >>> 31;
        int i4 = -rankx >>> 31;
        int j4 = -ranky >>> 31;
        int k4 = -rankz >>> 31;
        int l4 = -rankw >>> 31;
        int h4 = -ranku >>> 31;
        float x1 = x0 - (float)i1 + G5;
        float y1 = y0 - (float)j1 + G5;
        float z1 = z0 - (float)k1 + G5;
        float w1 = w0 - (float)l1 + G5;
        float u1 = u0 - (float)h1 + G5;
        float x2 = x0 - (float)i2 + 2.0f * G5;
        float y2 = y0 - (float)j2 + 2.0f * G5;
        float z2 = z0 - (float)k2 + 2.0f * G5;
        float w2 = w0 - (float)l2 + 2.0f * G5;
        float u2 = u0 - (float)h2 + 2.0f * G5;
        float x3 = x0 - (float)i3 + 3.0f * G5;
        float y3 = y0 - (float)j3 + 3.0f * G5;
        float z3 = z0 - (float)k3 + 3.0f * G5;
        float w3 = w0 - (float)l3 + 3.0f * G5;
        float u3 = u0 - (float)h3 + 3.0f * G5;
        float x4 = x0 - (float)i4 + 4.0f * G5;
        float y4 = y0 - (float)j4 + 4.0f * G5;
        float z4 = z0 - (float)k4 + 4.0f * G5;
        float w4 = w0 - (float)l4 + 4.0f * G5;
        float u4 = u0 - (float)h4 + 4.0f * G5;
        float x5 = x0 - 1.0f + 5.0f * G5;
        float y5 = y0 - 1.0f + 5.0f * G5;
        float z5 = z0 - 1.0f + 5.0f * G5;
        float w5 = w0 - 1.0f + 5.0f * G5;
        float u5 = u0 - 1.0f + 5.0f * G5;
        t = 0.67f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0 - u0 * u0;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * SimplexNoise.gradCoord5D(seed, i, j, k, l, h, x0, y0, z0, w0, u0);
        }
        t = 0.67f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1 - u1 * u1;
        if (t < 0.0f) {
            n1 = 0.0f;
        } else {
            t *= t;
            n1 = t * t * SimplexNoise.gradCoord5D(seed, i + i1, j + j1, k + k1, l + l1, h + h1, x1, y1, z1, w1, u1);
        }
        t = 0.67f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2 - u2 * u2;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * SimplexNoise.gradCoord5D(seed, i + i2, j + j2, k + k2, l + l2, h + h2, x2, y2, z2, w2, u2);
        }
        t = 0.67f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3 - u3 * u3;
        if (t < 0.0f) {
            n3 = 0.0f;
        } else {
            t *= t;
            n3 = t * t * SimplexNoise.gradCoord5D(seed, i + i3, j + j3, k + k3, l + l3, h + h3, x3, y3, z3, w3, u3);
        }
        t = 0.67f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4 - u4 * u4;
        if (t < 0.0f) {
            n4 = 0.0f;
        } else {
            t *= t;
            n4 = t * t * SimplexNoise.gradCoord5D(seed, i + i4, j + j4, k + k4, l + l4, h + h4, x4, y4, z4, w4, u4);
        }
        t = 0.67f - x5 * x5 - y5 * y5 - z5 * z5 - w5 * w5 - u5 * u5;
        if (t < 0.0f) {
            n5 = 0.0f;
        } else {
            t *= t;
            n5 = t * t * SimplexNoise.gradCoord5D(seed, i + 1, j + 1, k + 1, l + 1, h + 1, x5, y5, z5, w5, u5);
        }
        t = (n0 + n1 + n2 + n3 + n4 + n5) * 32.0f;
        return t / (0.7f + Math.abs(t));
    }

    public static float noise(float x, float y, float z, float w, float u, float v, long seed) {
        int hash;
        float[] gradient6DLUT = Noise.GRADIENTS_6D;
        float t = (x + y + z + w + u + v) * F6;
        int i = MathTools.fastFloor((float)(x + t));
        int j = MathTools.fastFloor((float)(y + t));
        int k = MathTools.fastFloor((float)(z + t));
        int l = MathTools.fastFloor((float)(w + t));
        int h = MathTools.fastFloor((float)(u + t));
        int g = MathTools.fastFloor((float)(v + t));
        t = (float)(i + j + k + l + h + g) * G6;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float U0 = (float)h - t;
        float V0 = (float)g - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        float u0 = u - U0;
        float v0 = v - V0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        int ranku = 0;
        int rankv = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (x0 > u0) {
            ++rankx;
        } else {
            ++ranku;
        }
        if (x0 > v0) {
            ++rankx;
        } else {
            ++rankv;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (y0 > u0) {
            ++ranky;
        } else {
            ++ranku;
        }
        if (y0 > v0) {
            ++ranky;
        } else {
            ++rankv;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        if (z0 > u0) {
            ++rankz;
        } else {
            ++ranku;
        }
        if (z0 > v0) {
            ++rankz;
        } else {
            ++rankv;
        }
        if (w0 > u0) {
            ++rankw;
        } else {
            ++ranku;
        }
        if (w0 > v0) {
            ++rankw;
        } else {
            ++rankv;
        }
        if (u0 > v0) {
            ++ranku;
        } else {
            ++rankv;
        }
        int i1 = 4 - rankx >>> 31;
        int j1 = 4 - ranky >>> 31;
        int k1 = 4 - rankz >>> 31;
        int l1 = 4 - rankw >>> 31;
        int h1 = 4 - ranku >>> 31;
        int g1 = 4 - rankv >>> 31;
        int i2 = 3 - rankx >>> 31;
        int j2 = 3 - ranky >>> 31;
        int k2 = 3 - rankz >>> 31;
        int l2 = 3 - rankw >>> 31;
        int h2 = 3 - ranku >>> 31;
        int g2 = 3 - rankv >>> 31;
        int i3 = 2 - rankx >>> 31;
        int j3 = 2 - ranky >>> 31;
        int k3 = 2 - rankz >>> 31;
        int l3 = 2 - rankw >>> 31;
        int h3 = 2 - ranku >>> 31;
        int g3 = 2 - rankv >>> 31;
        int i4 = 1 - rankx >>> 31;
        int j4 = 1 - ranky >>> 31;
        int k4 = 1 - rankz >>> 31;
        int l4 = 1 - rankw >>> 31;
        int h4 = 1 - ranku >>> 31;
        int g4 = 1 - rankv >>> 31;
        int i5 = -rankx >>> 31;
        int j5 = -ranky >>> 31;
        int k5 = -rankz >>> 31;
        int l5 = -rankw >>> 31;
        int h5 = -ranku >>> 31;
        int g5 = -rankv >>> 31;
        float x1 = x0 - (float)i1 + G6;
        float y1 = y0 - (float)j1 + G6;
        float z1 = z0 - (float)k1 + G6;
        float w1 = w0 - (float)l1 + G6;
        float u1 = u0 - (float)h1 + G6;
        float v1 = v0 - (float)g1 + G6;
        float x2 = x0 - (float)i2 + 2.0f * G6;
        float y2 = y0 - (float)j2 + 2.0f * G6;
        float z2 = z0 - (float)k2 + 2.0f * G6;
        float w2 = w0 - (float)l2 + 2.0f * G6;
        float u2 = u0 - (float)h2 + 2.0f * G6;
        float v2 = v0 - (float)g2 + 2.0f * G6;
        float x3 = x0 - (float)i3 + 3.0f * G6;
        float y3 = y0 - (float)j3 + 3.0f * G6;
        float z3 = z0 - (float)k3 + 3.0f * G6;
        float w3 = w0 - (float)l3 + 3.0f * G6;
        float u3 = u0 - (float)h3 + 3.0f * G6;
        float v3 = v0 - (float)g3 + 3.0f * G6;
        float x4 = x0 - (float)i4 + 4.0f * G6;
        float y4 = y0 - (float)j4 + 4.0f * G6;
        float z4 = z0 - (float)k4 + 4.0f * G6;
        float w4 = w0 - (float)l4 + 4.0f * G6;
        float u4 = u0 - (float)h4 + 4.0f * G6;
        float v4 = v0 - (float)g4 + 4.0f * G6;
        float x5 = x0 - (float)i5 + 5.0f * G6;
        float y5 = y0 - (float)j5 + 5.0f * G6;
        float z5 = z0 - (float)k5 + 5.0f * G6;
        float w5 = w0 - (float)l5 + 5.0f * G6;
        float u5 = u0 - (float)h5 + 5.0f * G6;
        float v5 = v0 - (float)g5 + 5.0f * G6;
        float x6 = x0 - 1.0f + 6.0f * G6;
        float y6 = y0 - 1.0f + 6.0f * G6;
        float z6 = z0 - 1.0f + 6.0f * G6;
        float w6 = w0 - 1.0f + 6.0f * G6;
        float u6 = u0 - 1.0f + 6.0f * G6;
        float v6 = v0 - 1.0f + 6.0f * G6;
        float n0 = 0.69f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0 - u0 * u0 - v0 * v0;
        if (n0 <= 0.0f) {
            n0 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i, j, k, l, h, g, seed) * 6;
            n0 *= n0;
            n0 *= n0 * (gradient6DLUT[hash] * x0 + gradient6DLUT[hash + 1] * y0 + gradient6DLUT[hash + 2] * z0 + gradient6DLUT[hash + 3] * w0 + gradient6DLUT[hash + 4] * u0 + gradient6DLUT[hash + 5] * v0);
        }
        float n1 = 0.69f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1 - u1 * u1 - v1 * v1;
        if (n1 <= 0.0f) {
            n1 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + i1, j + j1, k + k1, l + l1, h + h1, g + g1, seed) * 6;
            n1 *= n1;
            n1 *= n1 * (gradient6DLUT[hash] * x1 + gradient6DLUT[hash + 1] * y1 + gradient6DLUT[hash + 2] * z1 + gradient6DLUT[hash + 3] * w1 + gradient6DLUT[hash + 4] * u1 + gradient6DLUT[hash + 5] * v1);
        }
        float n2 = 0.69f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2 - u2 * u2 - v2 * v2;
        if (n2 <= 0.0f) {
            n2 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + i2, j + j2, k + k2, l + l2, h + h2, g + g2, seed) * 6;
            n2 *= n2;
            n2 *= n2 * (gradient6DLUT[hash] * x2 + gradient6DLUT[hash + 1] * y2 + gradient6DLUT[hash + 2] * z2 + gradient6DLUT[hash + 3] * w2 + gradient6DLUT[hash + 4] * u2 + gradient6DLUT[hash + 5] * v2);
        }
        float n3 = 0.69f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3 - u3 * u3 - v3 * v3;
        if (n3 <= 0.0f) {
            n3 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + i3, j + j3, k + k3, l + l3, h + h3, g + g3, seed) * 6;
            n3 *= n3;
            n3 *= n3 * (gradient6DLUT[hash] * x3 + gradient6DLUT[hash + 1] * y3 + gradient6DLUT[hash + 2] * z3 + gradient6DLUT[hash + 3] * w3 + gradient6DLUT[hash + 4] * u3 + gradient6DLUT[hash + 5] * v3);
        }
        float n4 = 0.69f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4 - u4 * u4 - v4 * v4;
        if (n4 <= 0.0f) {
            n4 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + i4, j + j4, k + k4, l + l4, h + h4, g + g4, seed) * 6;
            n4 *= n4;
            n4 *= n4 * (gradient6DLUT[hash] * x4 + gradient6DLUT[hash + 1] * y4 + gradient6DLUT[hash + 2] * z4 + gradient6DLUT[hash + 3] * w4 + gradient6DLUT[hash + 4] * u4 + gradient6DLUT[hash + 5] * v4);
        }
        float n5 = 0.69f - x5 * x5 - y5 * y5 - z5 * z5 - w5 * w5 - u5 * u5 - v5 * v5;
        if (n5 <= 0.0f) {
            n5 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + i5, j + j5, k + k5, l + l5, h + h5, g + g5, seed) * 6;
            n5 *= n5;
            n5 *= n5 * (gradient6DLUT[hash] * x5 + gradient6DLUT[hash + 1] * y5 + gradient6DLUT[hash + 2] * z5 + gradient6DLUT[hash + 3] * w5 + gradient6DLUT[hash + 4] * u5 + gradient6DLUT[hash + 5] * v5);
        }
        float n6 = 0.69f - x6 * x6 - y6 * y6 - z6 * z6 - w6 * w6 - u6 * u6 - v6 * v6;
        if (n6 <= 0.0f) {
            n6 = 0.0f;
        } else {
            hash = LongPointHash.hash256(i + 1, j + 1, k + 1, l + 1, h + 1, g + 1, seed) * 6;
            n6 *= n6;
            n6 *= n6 * (gradient6DLUT[hash] * x6 + gradient6DLUT[hash + 1] * y6 + gradient6DLUT[hash + 2] * z6 + gradient6DLUT[hash + 3] * w6 + gradient6DLUT[hash + 4] * u6 + gradient6DLUT[hash + 5] * v6);
        }
        t = (n0 + n1 + n2 + n3 + n4 + n5 + n6) * 64.0f;
        return t / (0.5f + Math.abs(t));
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return 6;
    }

    @Override
    public boolean canUseSeed() {
        return true;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public String getTag() {
        return "SimN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + "`";
    }

    @Override
    public SimplexNoise deserializeFromString(String data) {
        this.seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)(data.length() - 1));
        return this;
    }

    public static SimplexNoise recreateFromString(String data) {
        return new SimplexNoise(DigitTools.longFromDec((CharSequence)data, (int)1, (int)(data.length() - 1)));
    }

    @Override
    public SimplexNoise copy() {
        return new SimplexNoise(this.seed);
    }

    public String toString() {
        return "SimplexNoise{seed=" + this.seed + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplexNoise that = (SimplexNoise)o;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return (int)(this.seed ^ this.seed >>> 32);
    }
}

