/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.MathTools;
import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.Noise;

@Beta
public class SorbetNoise {
    protected int octaves;
    protected float total = 1.0f;
    protected float start = 1.0f;
    protected final float lacunarity = 1.6f;
    protected final float gain = 0.6f;
    public int seed;
    private static final float radToIndex = 2607.5945f;

    public SorbetNoise() {
        this(-774979857, 3);
    }

    public SorbetNoise(int seed, int octaves) {
        this.seed = seed;
        this.setOctaves(octaves);
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOctaves(int octaves) {
        this.octaves = Math.max(1, octaves);
        this.start = 0.6f;
        this.total = 0.0f;
        for (int i = 0; i < this.octaves; ++i) {
            this.start /= 0.6f;
            this.total += this.start;
        }
        this.total = 1.0f / this.total;
    }

    public String serializeToString() {
        return "`" + this.seed + '~' + this.octaves + '`';
    }

    public static SorbetNoise deserializeFromString(String data) {
        if (data == null || data.length() < 5) {
            return null;
        }
        int pos = data.indexOf(126);
        int seed = DigitTools.intFromDec((CharSequence)data, (int)1, (int)pos);
        int octaves = DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1));
        return new SorbetNoise(seed, octaves);
    }

    private static int hashPart1024(int x, int y, int z, int s) {
        return ((s += x ^ y ^ z) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z) {
        int STEPX = 898289;
        int STEPY = 769541;
        int STEPZ = 659247;
        int xFloor = MathTools.floor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.floor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.floor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        return ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)SorbetNoise.hashPart1024(xFloor *= 898289, yFloor *= 769541, zFloor *= 659247, seed) + x * (float)SorbetNoise.hashPart1024(xFloor + 898289, yFloor, zFloor, seed)) + y * ((1.0f - x) * (float)SorbetNoise.hashPart1024(xFloor, yFloor + 769541, zFloor, seed) + x * (float)SorbetNoise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)SorbetNoise.hashPart1024(xFloor, yFloor, zFloor + 659247, seed) + x * (float)SorbetNoise.hashPart1024(xFloor + 898289, yFloor, zFloor + 659247, seed)) + y * ((1.0f - x) * (float)SorbetNoise.hashPart1024(xFloor, yFloor + 769541, zFloor + 659247, seed) + x * (float)SorbetNoise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor + 659247, seed)))) * 4.8875855E-4f - 0.25f;
    }

    public float getNoise(float x, float y, float z) {
        float noise = 0.0f;
        float amp = this.start;
        float warp = 0.3f;
        float warpTrk = 1.2f;
        float warpTrkGain = 1.5f;
        int sd = this.seed;
        for (int i = 0; i < this.octaves; ++i) {
            float xx = TrigTools.sin((float)((x - 2.0f) * warpTrk)) * 0.3f;
            float yy = TrigTools.sin((float)((y - 2.0f) * warpTrk)) * 0.3f;
            float zz = TrigTools.sin((float)((z - 2.0f) * warpTrk)) * 0.3f;
            int xs = (int)((x += zz) * 2607.5945f) & 0x3FFF;
            int xc = xs + 4096 & 0x3FFF;
            int ys = (int)((y += xx) * 2607.5945f) & 0x3FFF;
            int yc = ys + 4096 & 0x3FFF;
            int zs = (int)((z += yy) * 2607.5945f) & 0x3FFF;
            int zc = zs + 4096 & 0x3FFF;
            noise += TrigTools.sinTurns((float)((TrigTools.SIN_TABLE[xc] * TrigTools.SIN_TABLE[zs] + TrigTools.SIN_TABLE[yc] * TrigTools.SIN_TABLE[xs] + TrigTools.SIN_TABLE[zc] * TrigTools.SIN_TABLE[ys]) * SorbetNoise.valueNoise(sd ^ i, x, y, z))) * amp;
            xx = Noise.rotateX3D(x, y, z);
            yy = Noise.rotateY3D(x, y, z);
            zz = Noise.rotateZ3D(x, y, z);
            x = xx * 1.6f;
            y = yy * 1.6f;
            z = zz * 1.6f;
            warpTrk *= 1.5f;
            amp *= 0.6f;
        }
        return noise * this.total;
    }

    public String toString() {
        return "SorbetNoise with seed: " + this.seed + ", octaves:" + this.octaves;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SorbetNoise that = (SorbetNoise)o;
        if (this.octaves != that.octaves) {
            return false;
        }
        return this.seed == that.seed;
    }

    public int hashCode() {
        int result = this.octaves;
        result = 31 * result + this.seed;
        return result;
    }
}

