/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.IntObjectOrderedMap;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.CoordObjectOrderedMap;
import com.github.yellowstonegames.grid.IGridIdentified;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public class SpatialMap<V extends IGridIdentified>
extends AbstractCollection<V>
implements Arrangeable {
    public final CoordObjectOrderedMap<V> positionMap;
    public final IntObjectOrderedMap<V> idMap;

    public SpatialMap() {
        this(16, 0.75f);
    }

    public SpatialMap(int capacity) {
        this(capacity, 0.75f);
    }

    public SpatialMap(int capacity, float loadFactor) {
        this.positionMap = new CoordObjectOrderedMap(capacity, loadFactor);
        this.idMap = new IntObjectOrderedMap(capacity, loadFactor);
    }

    public SpatialMap(SpatialMap<? extends V> other) {
        this.positionMap = new CoordObjectOrderedMap(other.positionMap);
        this.idMap = new IntObjectOrderedMap(other.idMap);
    }

    @Override
    public boolean add(@NonNull V value) {
        Coord pos = value.getCoordPosition();
        int id = value.getIdentifier();
        if (this.idMap.containsKey(id)) {
            IGridIdentified v = (IGridIdentified)this.idMap.replace(id, value);
            assert (v != null);
            Coord old = v.getCoordPosition();
            this.positionMap.alter(old, pos);
            this.positionMap.replace(pos, value);
            return true;
        }
        if (this.positionMap.containsKey(pos)) {
            return false;
        }
        this.positionMap.put(pos, value);
        this.idMap.put(id, value);
        return true;
    }

    public Collection<V> values() {
        return this.idMap.values();
    }

    public Set<Coord> positions() {
        return this.positionMap.keySet();
    }

    public PrimitiveCollection.OfInt ids() {
        return this.idMap.keySet();
    }

    @Override
    public Iterator<V> iterator() {
        return this.idMap.values().iterator();
    }

    public Iterator<Coord> positionIterator() {
        return this.positionMap.keySet().iterator();
    }

    public PrimitiveIterator.OfInt idIterator() {
        return this.idMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.idMap.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.idMap.containsValue(o);
    }

    public boolean containsPosition(Coord position) {
        return this.positionMap.containsKey(position);
    }

    public boolean containsId(int id) {
        return this.idMap.containsKey(id);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IGridIdentified) {
            return this.removeId(((IGridIdentified)o).getIdentifier());
        }
        return false;
    }

    public boolean removePosition(Coord pos) {
        IGridIdentified v = (IGridIdentified)this.positionMap.remove(pos);
        if (v == null) {
            return false;
        }
        this.idMap.remove(v.getIdentifier());
        return true;
    }

    public boolean removeId(int id) {
        IGridIdentified v = (IGridIdentified)this.idMap.remove(id);
        if (v == null) {
            return false;
        }
        this.positionMap.remove(v.getCoordPosition());
        return true;
    }

    public boolean removeAt(int index) {
        if (index < 0 || index >= this.idMap.size()) {
            return false;
        }
        this.idMap.removeAt(index);
        this.positionMap.removeAt(index);
        return true;
    }

    public @Nullable V getAt(int index) {
        if (index < 0 || index >= this.idMap.size()) {
            return null;
        }
        return (V)((IGridIdentified)this.idMap.getAt(index));
    }

    public @Nullable V getById(int id) {
        return (V)((IGridIdentified)this.idMap.get(id));
    }

    public @Nullable V getByPosition(Coord position) {
        return (V)((IGridIdentified)this.positionMap.get(position));
    }

    public @Nullable V getByPosition(int x, int y) {
        return (V)((IGridIdentified)this.positionMap.get(Coord.get(x, y)));
    }

    public @Nullable V move(Coord oldPosition, Coord newPosition) {
        IGridIdentified occupant = (IGridIdentified)this.positionMap.getOrDefault(newPosition, null);
        if (occupant != null) {
            return (V)occupant;
        }
        occupant = (IGridIdentified)this.positionMap.get(oldPosition);
        if (occupant == null) {
            return null;
        }
        this.positionMap.alter(oldPosition, newPosition);
        occupant.setCoordPosition(newPosition);
        return (V)occupant;
    }

    public @Nullable V move(int id, Coord newPosition) {
        IGridIdentified mover = (IGridIdentified)this.idMap.get(id);
        if (mover == null) {
            return null;
        }
        return this.move(mover.getCoordPosition(), newPosition);
    }

    public @Nullable V moveAt(int index, Coord newPosition) {
        if (index < 0 || index >= this.positionMap.size()) {
            return null;
        }
        Coord pos = (Coord)this.positionMap.keyAt(index);
        return this.move(pos, newPosition);
    }

    @Override
    public void clear() {
        this.idMap.clear();
        this.positionMap.clear();
    }

    public void swap(int first, int second) {
        this.idMap.swap(first, second);
        this.positionMap.swap(first, second);
    }

    public void reverse() {
        this.idMap.reverse();
        this.positionMap.reverse();
    }

    @Override
    public String toString() {
        if (this.positionMap.size() == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        IntList idOrder = this.idMap.order();
        int n = idOrder.size();
        for (int i = 0; i < n; ++i) {
            int id = idOrder.get(i);
            IGridIdentified v = (IGridIdentified)this.idMap.get(id);
            if (v == null) continue;
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('#').append(id).append(" at ").append(v.getCoordPosition()).append('=').append(v);
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpatialMap that = (SpatialMap)o;
        if (!this.positionMap.equals(that.positionMap)) {
            return false;
        }
        return this.idMap.equals(that.idMap);
    }

    @Override
    public int hashCode() {
        int result = this.positionMap.hashCode();
        result = 31 * result + this.idMap.hashCode();
        return result;
    }
}

