/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.random.EnhancedRandom;
import com.github.tommyettinger.random.WhiskerRandom;
import com.github.yellowstonegames.grid.Coord;
import com.github.yellowstonegames.grid.Region;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Spill {
    private Region buffer;
    private Region buffer2;
    protected Region spillMap;
    protected Region passable;
    protected EnhancedRandom random;

    public Spill(char[][] passable) {
        this(new Region(passable, '.'));
    }

    public Spill(char[][] passable, char floorChar) {
        this(new Region(passable, floorChar));
    }

    public Spill(char[][] passable, @Nullable EnhancedRandom random) {
        this(new Region(passable, '.'), random);
    }

    public Spill(char[][] passable, char floorChar, @Nullable EnhancedRandom random) {
        this(new Region(passable, floorChar), random);
    }

    public Spill(Region passable) {
        this(passable, null);
    }

    public Spill(Region passable, @Nullable EnhancedRandom random) {
        this.random = random == null ? new WhiskerRandom() : random;
        this.passable = passable == null ? new Region(32, 32) : passable;
        this.spillMap = new Region(this.passable.width, this.passable.height);
        this.buffer = new Region(this.passable.width, this.passable.height);
        this.buffer2 = new Region(this.passable.width, this.passable.height);
    }

    public Region run(Coord entrance, int volume) {
        this.spillMap.empty().add(entrance);
        return this.spillMap.spill(this.passable, volume, this.random, this.buffer, this.buffer2);
    }

    public Region run(Region entrances, int volume) {
        return this.spillMap.empty().insert(0, 0, entrances).spill(this.passable, volume, this.random, this.buffer, this.buffer2);
    }

    public Region getSpillMap() {
        return this.spillMap;
    }

    public void setSpillMap(Region spillMap) {
        if (spillMap != null) {
            this.spillMap = spillMap;
        }
    }

    public Region getPassable() {
        return this.passable;
    }

    public void setPassable(Region passable) {
        if (passable != null) {
            this.passable = passable;
        }
    }

    public EnhancedRandom getRandom() {
        return this.random;
    }

    public void setRandom(EnhancedRandom random) {
        if (random != null) {
            this.random = random;
        }
    }
}

