/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.digital.TrigTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.core.annotations.Beta;
import com.github.yellowstonegames.grid.INoise;

@Beta
public class TaffyNoise
implements INoise {
    public long seed;
    public int dim;
    public float sharpness;
    protected float inverse;
    protected float lesserInverse;
    protected transient float[] working;
    protected transient float[] points;
    protected transient float[] input;
    protected transient float[][] vertices;

    public TaffyNoise() {
        this(-77195684566545666L, 3);
    }

    public TaffyNoise(long seed, int dimension) {
        this(seed, dimension, 0.25f + 0.4f * (float)Math.max(2, dimension));
    }

    public TaffyNoise(long seed, int dimension, float sharpness) {
        this.dim = Math.max(2, dimension);
        this.sharpness = 1.0f / sharpness;
        this.working = new float[this.dim + 1];
        this.points = new float[this.dim + 1];
        this.input = new float[this.dim];
        this.vertices = new float[this.dim + 1][this.dim];
        this.inverse = 1.0f / ((float)this.dim + 1.0f);
        this.lesserInverse = 1.0f / ((float)this.dim + 4.0f);
        this.setSeed(seed);
    }

    public TaffyNoise reassign(long seed, int dimension, float sharpness) {
        boolean unchanged;
        this.sharpness = 1.0f / sharpness;
        boolean bl = unchanged = this.dim == Math.max(2, dimension);
        if (!unchanged) {
            this.dim = Math.max(2, dimension);
            this.working = new float[this.dim + 1];
            this.points = new float[this.dim + 1];
            this.input = new float[this.dim];
            this.vertices = new float[this.dim + 1][this.dim];
            this.inverse = 1.0f / ((float)this.dim + 1.0f);
            this.lesserInverse = 1.0f / ((float)this.dim + 4.0f);
        }
        this.setSeed(seed);
        return this;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public void setSeed(long seed) {
        int v;
        this.seed = seed;
        float id = -1.0f / (float)this.dim;
        this.vertices[0][0] = 1.0f;
        for (v = 1; v <= this.dim; ++v) {
            this.vertices[v][0] = id;
        }
        for (int d = 1; d < this.dim; ++d) {
            float t = 0.0f;
            for (int i = 0; i < d; ++i) {
                t += this.vertices[d][i] * this.vertices[d][i];
            }
            this.vertices[d][d] = (float)Math.sqrt(1.0f - t);
            t = (id - t) / this.vertices[d][d];
            for (int v2 = d + 1; v2 <= this.dim; ++v2) {
                this.vertices[v2][d] = t;
            }
        }
        for (v = 0; v <= this.dim; ++v) {
            int d = 0;
            while (d < this.dim) {
                float[] fArray = this.vertices[v];
                int n = d++;
                fArray[n] = fArray[n] * (Hasher.randomize3Float((long)(--seed)) + 1.0f);
            }
        }
    }

    @Override
    public String getTag() {
        return "TafN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '~' + this.dim + '~' + BitConversion.floatToReversedIntBits((float)(1.0f / this.sharpness)) + '`';
    }

    @Override
    public TaffyNoise deserializeFromString(String data) {
        if (data == null || data.length() < 7) {
            return this;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return this.reassign(seed, dim, sharp);
    }

    public static TaffyNoise recreateFromString(String data) {
        if (data == null || data.length() < 7) {
            return null;
        }
        int pos = data.indexOf(126);
        long seed = DigitTools.longFromDec((CharSequence)data, (int)1, (int)pos);
        int n = pos + 1;
        pos = data.indexOf(126, pos + 1);
        int dim = DigitTools.intFromDec((CharSequence)data, (int)n, (int)pos);
        float sharp = BitConversion.reversedIntBitsToFloat((int)DigitTools.intFromDec((CharSequence)data, (int)(pos + 1), (int)data.indexOf(96, pos + 1)));
        return new TaffyNoise(seed, dim, sharp);
    }

    @Override
    public TaffyNoise copy() {
        return new TaffyNoise(this.seed, this.dim, this.sharpness);
    }

    protected float valueNoise() {
        return this.valueNoise(this.dim);
    }

    protected float valueNoise(int dim) {
        int s = (int)(this.seed ^ this.seed >>> 32 ^ (long)BitConversion.floatToRawIntBits((float)this.working[dim]));
        float sum = 0.0f;
        int i = 0;
        int j = 1;
        while (i < dim) {
            s = s * 648051 ^ 0x7F4A7C15;
            float cx = this.working[i];
            float cy = this.working[j];
            int idx = s + (int)(cx * 95.0f + cy * 21.0f);
            sum += TrigTools.cos((float)cx) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[s & 0x3FFF] * cy)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[s + 4096 & 0x3FFF] * cx));
            ++i;
            ++j;
        }
        return TrigTools.sinTurns((float)(sum * this.lesserInverse));
    }

    protected float valueNoise2D() {
        int bits = BitConversion.floatToRawIntBits((float)this.working[this.dim]);
        int sx = (int)(this.seed ^ this.seed >>> 32 ^ (long)bits) * 648051 ^ 0x7F4A7C15;
        int sy = sx * 648051 ^ 0x7F4A7C15;
        float cx = this.working[0];
        float cy = this.working[1];
        int idx = sx + (int)(cx * 95.0f + cy * 21.0f);
        float sum = TrigTools.cos((float)cx) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sx & 0x3FFF] * cy)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sx + 4096 & 0x3FFF] * cx));
        idx = sy + (int)(cy * 95.0f + cx * 21.0f);
        return TrigTools.sinTurns((float)((sum += TrigTools.cos((float)cy) - TrigTools.SIN_TABLE[idx & 0x3FFF] - TrigTools.cos((float)(TrigTools.SIN_TABLE[sy & 0x3FFF] * cx)) + TrigTools.sin((float)(TrigTools.SIN_TABLE[sy + 4096 & 0x3FFF] * cy))) * this.lesserInverse));
    }

    public float getNoise(float ... args) {
        return this.noise(args.length, args);
    }

    public float noise(int dim, float ... args) {
        for (int v = 0; v <= dim; ++v) {
            this.points[v] = 0.0f;
            for (int d = 0; d < dim; ++d) {
                int n = v;
                this.points[n] = this.points[n] + args[d] * this.vertices[v][d];
            }
        }
        this.working[dim] = 0.618034f;
        float result = 0.0f;
        float warp = 0.0f;
        for (int i = 0; i <= dim; ++i) {
            int j = 0;
            int d = 0;
            while (j < dim) {
                if (d == i) {
                    ++d;
                }
                this.working[j] = this.points[d];
                ++j;
                ++d;
            }
            this.working[0] = this.working[0] + warp;
            warp = this.valueNoise(dim);
            result += warp;
            int n = dim;
            this.working[n] = this.working[n] + -0.42331082f;
        }
        return (result *= this.inverse) / ((this.sharpness - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public float getNoise2D(float x, float y) {
        this.points[0] = x * 0.60535836f + y * 0.79595304f;
        this.points[1] = x * -0.99609566f + y * 0.08828044f;
        this.points[2] = x * 0.45730183f + y * -0.88913614f;
        this.working[2] = 0.618034f;
        float result = 0.0f;
        float warp = 0.0f;
        for (int i = 0; i <= 2; ++i) {
            int j = 0;
            int d = 0;
            while (j < 2) {
                if (d == i) {
                    ++d;
                }
                this.working[j] = this.points[d];
                ++j;
                ++d;
            }
            this.working[0] = this.working[0] + warp;
            warp = this.valueNoise2D();
            result += warp;
            this.working[2] = this.working[2] + -0.42331082f;
        }
        return (result *= this.inverse) / ((this.sharpness - 1.0f) * (1.0f - Math.abs(result)) + 1.0000001f);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaffyNoise that = (TaffyNoise)o;
        if (this.seed != that.seed) {
            return false;
        }
        if (this.dim != that.dim) {
            return false;
        }
        return Float.compare(that.sharpness, this.sharpness) == 0;
    }

    @Override
    public int getMinDimension() {
        return 2;
    }

    @Override
    public int getMaxDimension() {
        return this.dim;
    }

    @Override
    public boolean canUseSeed() {
        return false;
    }

    @Override
    public float getNoise(float x, float y) {
        if (this.dim >= 2) {
            return this.getNoise2D(x, y);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 2D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z) {
        if (this.dim >= 3) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            return this.noise(3, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 3D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        if (this.dim >= 4) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            return this.noise(4, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 4D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        if (this.dim >= 5) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            return this.noise(5, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 5D noise.");
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        if (this.dim >= 6) {
            this.input[0] = x;
            this.input[1] = y;
            this.input[2] = z;
            this.input[3] = w;
            this.input[4] = u;
            this.input[5] = v;
            return this.noise(6, this.input);
        }
        throw new UnsupportedOperationException("Insufficient dimensions available for 6D noise.");
    }
}

