/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.MathTools;
import com.github.yellowstonegames.core.DigitTools;
import com.github.yellowstonegames.grid.INoise;

public class ValueNoise
implements INoise {
    public static final ValueNoise instance = new ValueNoise();
    public int seed = -774979857;

    public ValueNoise() {
    }

    public ValueNoise(int seed) {
        this.seed = seed;
    }

    public ValueNoise(long seed) {
        this.seed = (int)(seed ^ seed >>> 32);
    }

    @Override
    public String getTag() {
        return "ValN";
    }

    @Override
    public String serializeToString() {
        return "`" + this.seed + '`';
    }

    @Override
    public ValueNoise deserializeFromString(String data) {
        if (data == null || data.length() < 3) {
            return this;
        }
        this.seed = DigitTools.intFromDec((CharSequence)data, (int)1, (int)data.indexOf(96, 2));
        return this;
    }

    public static ValueNoise recreateFromString(String data) {
        if (data == null || data.length() < 3) {
            return null;
        }
        int seed = DigitTools.intFromDec((CharSequence)data, (int)1, (int)data.indexOf(96, 2));
        return new ValueNoise(seed);
    }

    @Override
    public ValueNoise copy() {
        return new ValueNoise(this.seed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueNoise that = (ValueNoise)o;
        return this.seed == that.seed;
    }

    public int hashCode() {
        return this.seed;
    }

    public String toString() {
        return "ValueNoise{seed=" + this.seed + '}';
    }

    public static float valueNoise(int seed, float x) {
        int STEPX = 648055;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        seed ^= seed >>> 17;
        return ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor *= 648055, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 648055, seed)) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int s) {
        s *= x ^ x >>> 12 | 1;
        return ((s += (x ^ x >>> 16) * 705617) >>> 3 ^ s >>> 10) & 0x3FF;
    }

    public static float valueNoise(int seed, float x, float y) {
        int STEPX = 858965;
        int STEPY = 703641;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        return ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor *= 858965, yFloor *= 703641, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 858965, yFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 703641, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 858965, yFloor + 703641, seed))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int s) {
        return ((s += x ^ y) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z) {
        int STEPX = 898289;
        int STEPY = 769541;
        int STEPZ = 659247;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.fastFloor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        return ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor *= 898289, yFloor *= 769541, zFloor *= 659247, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 898289, yFloor, zFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 769541, zFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 659247, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 898289, yFloor, zFloor + 659247, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 769541, zFloor + 659247, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 898289, yFloor + 769541, zFloor + 659247, seed)))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int z, int s) {
        return ((s += x ^ y ^ z) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z, float w) {
        int STEPX = 924081;
        int STEPY = 814365;
        int STEPZ = 717677;
        int STEPW = 632469;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.fastFloor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = MathTools.fastFloor((float)w);
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        return ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor *= 924081, yFloor *= 814365, zFloor *= 717677, wFloor *= 632469, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 632469, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor, zFloor, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 814365, zFloor, wFloor + 632469, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor, wFloor + 632469, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 717677, wFloor + 632469, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor, zFloor + 717677, wFloor + 632469, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 924081, yFloor + 814365, zFloor + 717677, wFloor + 632469, seed))))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int z, int w, int s) {
        return ((s += x ^ y ^ z ^ w) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z, float w, float u) {
        int STEPX = 942307;
        int STEPY = 846807;
        int STEPZ = 760987;
        int STEPW = 683863;
        int STEPU = 614557;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.fastFloor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = MathTools.fastFloor((float)w);
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = MathTools.fastFloor((float)u);
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        return ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor *= 942307, yFloor *= 846807, zFloor *= 760987, wFloor *= 683863, uFloor *= 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor, uFloor + 614557, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor, wFloor + 683863, uFloor + 614557, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 942307, yFloor + 846807, zFloor + 760987, wFloor + 683863, uFloor + 614557, seed)))))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int s) {
        return ((s += x ^ y ^ z ^ w ^ u) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z, float w, float u, float v) {
        int STEPX = 955873;
        int STEPY = 871367;
        int STEPZ = 794331;
        int STEPW = 724107;
        int STEPU = 660091;
        int STEPV = 601733;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.fastFloor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = MathTools.fastFloor((float)w);
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = MathTools.fastFloor((float)u);
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        int vFloor = MathTools.fastFloor((float)v);
        v -= (float)vFloor;
        v *= v * (3.0f - 2.0f * v);
        return ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor *= 871367, zFloor *= 794331, wFloor *= 724107, uFloor *= 660091, vFloor *= 601733, seed) + x * (float)ValueNoise.hashPart1024((xFloor *= 955873) + 955873, yFloor, zFloor, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor, vFloor + 601733, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor, uFloor + 660091, vFloor + 601733, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 955873, yFloor + 871367, zFloor + 794331, wFloor + 724107, uFloor + 660091, vFloor + 601733, seed))))))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int v, int s) {
        return ((s += x ^ y ^ z ^ w ^ u ^ v) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    public static float valueNoise(int seed, float x, float y, float z, float w, float u, float v, float m) {
        int STEPX = 966367;
        int STEPY = 890603;
        int STEPZ = 820779;
        int STEPW = 756429;
        int STEPU = 697123;
        int STEPV = 642469;
        int STEPM = 592099;
        int xFloor = MathTools.fastFloor((float)x);
        x -= (float)xFloor;
        x *= x * (3.0f - 2.0f * x);
        int yFloor = MathTools.fastFloor((float)y);
        y -= (float)yFloor;
        y *= y * (3.0f - 2.0f * y);
        int zFloor = MathTools.fastFloor((float)z);
        z -= (float)zFloor;
        z *= z * (3.0f - 2.0f * z);
        int wFloor = MathTools.fastFloor((float)w);
        w -= (float)wFloor;
        w *= w * (3.0f - 2.0f * w);
        int uFloor = MathTools.fastFloor((float)u);
        u -= (float)uFloor;
        u *= u * (3.0f - 2.0f * u);
        int vFloor = MathTools.fastFloor((float)v);
        v -= (float)vFloor;
        v *= v * (3.0f - 2.0f * v);
        int mFloor = MathTools.fastFloor((float)m);
        m -= (float)mFloor;
        m *= m * (3.0f - 2.0f * m);
        return ((1.0f - m) * ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor *= 820779, wFloor *= 756429, uFloor *= 697123, vFloor *= 642469, mFloor *= 592099, seed) + x * (float)ValueNoise.hashPart1024((xFloor *= 966367) + 966367, yFloor *= 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor, seed))))))) + m * ((1.0f - v) * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor, mFloor + 592099, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor, mFloor + 592099, seed)))))) + v * ((1.0f - u) * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor, vFloor + 642469, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor, vFloor + 642469, mFloor + 592099, seed))))) + u * ((1.0f - w) * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)))) + w * ((1.0f - z) * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed))) + z * ((1.0f - y) * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)) + y * ((1.0f - x) * (float)ValueNoise.hashPart1024(xFloor, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed) + x * (float)ValueNoise.hashPart1024(xFloor + 966367, yFloor + 890603, zFloor + 820779, wFloor + 756429, uFloor + 697123, vFloor + 642469, mFloor + 592099, seed)))))))) * 0.0019550342f - 1.0f;
    }

    private static int hashPart1024(int x, int y, int z, int w, int u, int v, int m, int s) {
        return ((s += x ^ y ^ z ^ w ^ u ^ v ^ m) ^ (s << 19 | s >>> 13) ^ (s << 5 | s >>> 27) ^ 0xD1B54A35) * 1201299 >>> 22;
    }

    @Override
    public int getMinDimension() {
        return 1;
    }

    @Override
    public int getMaxDimension() {
        return 6;
    }

    @Override
    public boolean canUseSeed() {
        return true;
    }

    @Override
    public float getNoise(float x, float y) {
        return ValueNoise.valueNoise(this.seed, x, y);
    }

    @Override
    public float getNoise(float x, float y, float z) {
        return ValueNoise.valueNoise(this.seed, x, y, z);
    }

    @Override
    public float getNoise(float x, float y, float z, float w) {
        return ValueNoise.valueNoise(this.seed, x, y, z, w);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u) {
        return ValueNoise.valueNoise(this.seed, x, y, z, w, u);
    }

    @Override
    public float getNoise(float x, float y, float z, float w, float u, float v) {
        return ValueNoise.valueNoise(this.seed, x, y, z, w, u, v);
    }

    @Override
    public void setSeed(long seed) {
        seed = (int)seed;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public float getNoiseWithSeed(float x, float y, long seed) {
        return ValueNoise.valueNoise((int)seed, x, y);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, long seed) {
        return ValueNoise.valueNoise((int)seed, x, y, z);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, long seed) {
        return ValueNoise.valueNoise((int)seed, x, y, z, w);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, long seed) {
        return ValueNoise.valueNoise((int)seed, x, y, z, w, u);
    }

    @Override
    public float getNoiseWithSeed(float x, float y, float z, float w, float u, float v, long seed) {
        return ValueNoise.valueNoise((int)seed, x, y, z, w, u, v);
    }
}

