/*
 * Decompiled with CFR 0.152.
 */
package com.github.yellowstonegames.grid;

import com.github.tommyettinger.digital.Hasher;
import com.github.tommyettinger.ds.IntIntOrderedMap;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.ObjectIntOrderedMap;
import com.github.tommyettinger.random.EnhancedRandom;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WaveFunctionCollapse {
    private boolean[][] wave;
    private int[][][] propagator;
    private int[][][] compatible;
    private int[] observed;
    private int[] stack;
    private int stacksize;
    public @NonNull EnhancedRandom random;
    private int targetWidth;
    private int targetHeight;
    private int totalOptions;
    private boolean periodic;
    private double[] baseWeights;
    private double[] weightLogWeights;
    private int[] sumsOfOnes;
    private double sumOfWeights;
    private double sumOfWeightLogWeights;
    private double startingEntropy;
    private double[] sumsOfWeights;
    private double[] sumsOfWeightLogWeights;
    private double[] entropies;
    private int order;
    private int[][] patterns;
    private IntIntOrderedMap choices;
    private int ground;
    private static final int[] DX = new int[]{-1, 0, 1, 0};
    private static final int[] DY = new int[]{0, 1, 0, -1};
    private static final int[] OPPOSITE = new int[]{2, 3, 0, 1};

    public WaveFunctionCollapse(@NonNull int[][] itemGrid, int order, int width, int height, EnhancedRandom random) {
        this(itemGrid, order, width, height, random, true, false, 1, 0);
    }

    public WaveFunctionCollapse(@NonNull int[][] itemGrid, int order, int width, int height, EnhancedRandom random, boolean periodicInput, boolean periodicOutput, int symmetry, int ground) {
        this.targetWidth = width;
        this.targetHeight = height;
        this.order = order;
        this.periodic = periodicOutput;
        this.random = random;
        symmetry = Math.min(Math.max(symmetry, 1), 8);
        int sampleWidth = itemGrid.length;
        int sampleHeight = itemGrid[0].length;
        this.choices = new IntIntOrderedMap(sampleWidth * sampleHeight);
        int[][] sample = new int[sampleWidth][sampleHeight];
        for (int y = 0; y < sampleHeight; ++y) {
            for (int x = 0; x < sampleWidth; ++x) {
                int color = itemGrid[x][y];
                int i = this.choices.getOrDefault(color, this.choices.size());
                if (i == this.choices.size()) {
                    this.choices.put(color, i);
                }
                sample[x][y] = i;
            }
        }
        ObjectIntOrderedMap<int[]> weights = new ObjectIntOrderedMap<int[]>(){

            protected int place(@NonNull Object item) {
                return item instanceof int[] ? Hasher.focalor.hash((int[])item) & this.mask : super.place(item);
            }

            protected int locateKey(@NonNull Object key) {
                if (key instanceof int[]) {
                    Object[] keyTable = this.keyTable;
                    int i = this.place(key);
                    while (true) {
                        int[] other;
                        if ((other = (int[])keyTable[i]) == null) {
                            return ~i;
                        }
                        if (Arrays.equals((int[])key, other)) {
                            return i;
                        }
                        i = i + 1 & this.mask;
                    }
                }
                return super.locateKey(key);
            }
        };
        for (int y = 0; y < (periodicInput ? sampleHeight : sampleHeight - order + 1); ++y) {
            for (int x = 0; x < (periodicInput ? sampleWidth : sampleWidth - order + 1); ++x) {
                int[][] ps;
                ps = new int[][]{this.patternFromSample(x, y, sample, sampleWidth, sampleHeight), this.reflect(ps[0]), this.rotate(ps[0]), this.reflect(ps[2]), this.rotate(ps[2]), this.reflect(ps[4]), this.rotate(ps[4]), this.reflect(ps[6])};
                for (int k = 0; k < symmetry; ++k) {
                    int[] ind = ps[k];
                    weights.put((Object)ind, weights.getOrDefault((Object)ind, 0) + 1);
                }
            }
        }
        this.totalOptions = weights.size();
        this.ground = (ground + this.totalOptions) % this.totalOptions;
        this.patterns = new int[this.totalOptions][];
        this.baseWeights = new double[this.totalOptions];
        for (int w = 0; w < this.totalOptions; ++w) {
            this.patterns[w] = (int[])weights.keyAt(w);
            this.baseWeights[w] = weights.getAt(w);
        }
        this.propagator = new int[4][][];
        IntList list = new IntList(this.totalOptions);
        for (int d = 0; d < 4; ++d) {
            this.propagator[d] = new int[this.totalOptions][];
            for (int t = 0; t < this.totalOptions; ++t) {
                list.clear();
                for (int t2 = 0; t2 < this.totalOptions; ++t2) {
                    if (!this.agrees(this.patterns[t], this.patterns[t2], DX[d], DY[d])) continue;
                    list.add(t2);
                }
                this.propagator[d][t] = list.toArray();
            }
        }
    }

    private int[] patternFromSample(int x, int y, int[][] sample, int sampleWidth, int sampleHeight) {
        int[] result = new int[this.order * this.order];
        for (int dy = 0; dy < this.order; ++dy) {
            for (int dx = 0; dx < this.order; ++dx) {
                result[dx + dy * this.order] = sample[(x + dx) % sampleWidth][(y + dy) % sampleHeight];
            }
        }
        return result;
    }

    private int[] rotate(int[] p) {
        int[] result = new int[this.order * this.order];
        for (int y = 0; y < this.order; ++y) {
            for (int x = 0; x < this.order; ++x) {
                result[x + y * this.order] = p[this.order - 1 - y + x * this.order];
            }
        }
        return result;
    }

    private int[] reflect(int[] p) {
        int[] result = new int[this.order * this.order];
        for (int y = 0; y < this.order; ++y) {
            for (int x = 0; x < this.order; ++x) {
                result[x + y * this.order] = p[this.order - 1 - x + y * this.order];
            }
        }
        return result;
    }

    private boolean agrees(int[] p1, int[] p2, int dx, int dy) {
        int xmin = Math.max(dx, 0);
        int xmax = dx < 0 ? dx + this.order : this.order;
        int ymin = Math.max(dy, 0);
        int ymax = dy < 0 ? dy + this.order : this.order;
        for (int y = ymin; y < ymax; ++y) {
            for (int x = xmin; x < xmax; ++x) {
                if (p1[x + this.order * y] == p2[x - dx + this.order * (y - dy)]) continue;
                return false;
            }
        }
        return true;
    }

    private void init() {
        this.wave = new boolean[this.targetWidth * this.targetHeight][];
        this.compatible = new int[this.wave.length][][];
        for (int i = 0; i < this.wave.length; ++i) {
            this.wave[i] = new boolean[this.totalOptions];
            this.compatible[i] = new int[this.totalOptions][];
            for (int t = 0; t < this.totalOptions; ++t) {
                this.compatible[i][t] = new int[4];
            }
        }
        this.weightLogWeights = new double[this.totalOptions];
        this.sumOfWeights = 0.0;
        this.sumOfWeightLogWeights = 0.0;
        for (int t = 0; t < this.totalOptions; ++t) {
            this.weightLogWeights[t] = this.baseWeights[t] * Math.log(this.baseWeights[t]);
            this.sumOfWeights += this.baseWeights[t];
            this.sumOfWeightLogWeights += this.weightLogWeights[t];
        }
        this.startingEntropy = Math.log(this.sumOfWeights) - this.sumOfWeightLogWeights / this.sumOfWeights;
        this.sumsOfOnes = new int[this.targetWidth * this.targetHeight];
        this.sumsOfWeights = new double[this.targetWidth * this.targetHeight];
        this.sumsOfWeightLogWeights = new double[this.targetWidth * this.targetHeight];
        this.entropies = new double[this.targetWidth * this.targetHeight];
        this.stack = new int[this.wave.length * this.totalOptions << 1];
        this.stacksize = 0;
    }

    private int observe() {
        int r;
        int i;
        double min = 1000.0;
        int argmin = -1;
        for (i = 0; i < this.wave.length; ++i) {
            double noise;
            if (this.onBoundary(i % this.targetWidth, i / this.targetWidth)) continue;
            int amount = this.sumsOfOnes[i];
            if (amount == 0) {
                return 0;
            }
            double entropy = this.entropies[i];
            if (amount <= 1 || !(entropy <= min) || !(entropy + (noise = 1.0E-6 * this.random.nextDouble()) < min)) continue;
            min = entropy + noise;
            argmin = i;
        }
        if (argmin == -1) {
            this.observed = new int[this.targetWidth * this.targetHeight];
            block1: for (i = 0; i < this.wave.length; ++i) {
                for (int t = 0; t < this.totalOptions; ++t) {
                    if (!this.wave[i][t]) continue;
                    this.observed[i] = t;
                    continue block1;
                }
            }
            return 1;
        }
        double[] distribution = new double[this.totalOptions];
        double sum = 0.0;
        double x = 0.0;
        for (int t = 0; t < this.totalOptions; ++t) {
            distribution[t] = this.wave[argmin][t] ? this.baseWeights[t] : 0.0;
            sum += distribution[t];
        }
        sum = this.random.nextDouble(sum);
        for (r = 0; r < this.totalOptions; ++r) {
            double d;
            x += distribution[r];
            if (d > sum) break;
        }
        boolean[] w = this.wave[argmin];
        for (int t = 0; t < this.totalOptions; ++t) {
            if (w[t] == (t == r)) continue;
            this.ban(argmin, t);
        }
        return -1;
    }

    private void propagate() {
        while (this.stacksize > 0) {
            int i1 = this.stack[this.stacksize - 2];
            int e2 = this.stack[this.stacksize - 1];
            this.stacksize -= 2;
            int x1 = i1 % this.targetWidth;
            int y1 = i1 / this.targetWidth;
            for (int d = 0; d < 4; ++d) {
                int dx = DX[d];
                int x2 = x1 + dx;
                int dy = DY[d];
                int y2 = y1 + dy;
                if (this.onBoundary(x2, y2)) continue;
                if (x2 < 0) {
                    x2 += this.targetWidth;
                } else if (x2 >= this.targetWidth) {
                    x2 -= this.targetWidth;
                }
                if (y2 < 0) {
                    y2 += this.targetHeight;
                } else if (y2 >= this.targetHeight) {
                    y2 -= this.targetHeight;
                }
                int i2 = x2 + y2 * this.targetWidth;
                int[] p = this.propagator[d][e2];
                int[][] compat = this.compatible[i2];
                for (int l = 0; l < p.length; ++l) {
                    int t2 = p[l];
                    int[] comp = compat[t2];
                    int n = d;
                    comp[n] = comp[n] - 1;
                    if (comp[d] != 0) continue;
                    this.ban(i2, t2);
                }
            }
        }
    }

    public boolean run(long seed, int limit) {
        if (this.wave == null) {
            this.init();
        }
        this.clear();
        this.random.setSeed(seed);
        for (int l = 0; l < limit || limit == 0; ++l) {
            int result = this.observe();
            if (result >= 0) {
                return result == 1;
            }
            this.propagate();
        }
        return false;
    }

    public boolean run(int limit) {
        if (this.wave == null) {
            this.init();
        }
        this.clear();
        for (int l = 0; l < limit || limit <= 0; ++l) {
            int result = this.observe();
            if (result >= 0) {
                return result == 1;
            }
            this.propagate();
        }
        return false;
    }

    private void ban(int i, int t) {
        this.wave[i][t] = false;
        int[] comp = this.compatible[i][t];
        for (int d = 0; d < 4; ++d) {
            comp[d] = 0;
        }
        this.stack[this.stacksize++] = i;
        this.stack[this.stacksize++] = t;
        double sum = this.sumsOfWeights[i];
        int n = i;
        this.entropies[n] = this.entropies[n] + (this.sumsOfWeightLogWeights[i] / sum - Math.log(sum));
        int n2 = i;
        this.sumsOfOnes[n2] = this.sumsOfOnes[n2] - 1;
        int n3 = i;
        this.sumsOfWeights[n3] = this.sumsOfWeights[n3] - this.baseWeights[t];
        int n4 = i;
        this.sumsOfWeightLogWeights[n4] = this.sumsOfWeightLogWeights[n4] - this.weightLogWeights[t];
        sum = this.sumsOfWeights[i];
        int n5 = i;
        this.entropies[n5] = this.entropies[n5] - (this.sumsOfWeightLogWeights[i] / sum - Math.log(sum));
    }

    private boolean onBoundary(int x, int y) {
        return !this.periodic && (x + this.order > this.targetWidth || y + this.order > this.targetHeight || x < 0 || y < 0);
    }

    public int[][] result() {
        int[][] result = new int[this.targetWidth][this.targetHeight];
        if (this.observed != null) {
            for (int y = 0; y < this.targetHeight; ++y) {
                int dy = y < this.targetHeight - this.order + 1 ? 0 : this.order - 1;
                for (int x = 0; x < this.targetWidth; ++x) {
                    int dx = x < this.targetWidth - this.order + 1 ? 0 : this.order - 1;
                    result[x][y] = this.choices.keyAt(this.patterns[this.observed[x - dx + (y - dy) * this.targetWidth]][dx + dy * this.order]);
                }
            }
        }
        return result;
    }

    private void clear() {
        int t;
        for (int i = 0; i < this.wave.length; ++i) {
            for (t = 0; t < this.totalOptions; ++t) {
                this.wave[i][t] = true;
                for (int d = 0; d < 4; ++d) {
                    this.compatible[i][t][d] = this.propagator[OPPOSITE[d]][t].length;
                }
            }
            this.sumsOfOnes[i] = this.baseWeights.length;
            this.sumsOfWeights[i] = this.sumOfWeights;
            this.sumsOfWeightLogWeights[i] = this.sumOfWeightLogWeights;
            this.entropies[i] = this.startingEntropy;
        }
        if (this.ground != 0) {
            for (int x = 0; x < this.targetWidth; ++x) {
                for (t = 0; t < this.totalOptions; ++t) {
                    if (t == this.ground) continue;
                    this.ban(x + (this.targetHeight - 1) * this.targetWidth, t);
                }
                for (int y = 0; y < this.targetHeight - 1; ++y) {
                    this.ban(x + y * this.targetWidth, this.ground);
                }
            }
            this.propagate();
        }
    }
}

