/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import java.util.LinkedList;
import java.util.List;
import squidpony.panel.IColoredString;
import squidpony.panel.ICombinedPanel;
import squidpony.panel.ISquidPanel;
import squidpony.squidgrid.gui.gdx.SquidPanel;

public class GroupCombinedPanel<T>
extends Group
implements ICombinedPanel<T> {
    protected ISquidPanel<T> bg;
    protected ISquidPanel<T> fg;
    protected int gridWidth = -1;
    protected int gridHeight = -1;

    public GroupCombinedPanel(ISquidPanel<T> bg, ISquidPanel<T> fg, int gridWidth, int gridHeight) {
        if (bg.gridWidth() != fg.gridWidth()) {
            throw new IllegalStateException("Cannot build a combined panel with backers of different widths");
        }
        if (bg.gridHeight() != fg.gridHeight()) {
            throw new IllegalStateException("Cannot build a combined panel with backers of different heights");
        }
        this.bg = bg;
        this.fg = fg;
        if (gridWidth < 0) {
            throw new IllegalStateException("Cannot create a panel with a negative width");
        }
        this.gridWidth = gridWidth;
        if (gridHeight < 0) {
            throw new IllegalStateException("Cannot create a panel with a negative height");
        }
        this.gridHeight = gridHeight;
        this.addActors();
    }

    public GroupCombinedPanel() {
    }

    public void setPanels(ISquidPanel<T> bg, ISquidPanel<T> fg) {
        if (this.bg != null) {
            throw new IllegalStateException("Cannot change the background panel");
        }
        this.bg = bg;
        if (this.fg != null) {
            throw new IllegalStateException("Cannot change the foreground panel");
        }
        this.fg = fg;
        if (bg.gridWidth() != fg.gridWidth()) {
            throw new IllegalStateException("Cannot build a combined panel with backers of different widths");
        }
        if (bg.gridHeight() != fg.gridHeight()) {
            throw new IllegalStateException("Cannot build a combined panel with backers of different heights");
        }
        this.gridWidth = bg.gridWidth();
        this.gridHeight = bg.gridHeight();
        this.addActors();
    }

    public void putFG(int x, int y, char c) {
        this.checkFG();
        this.fg.put(x, y, c);
    }

    public void putFG(int x, int y, char c, T color) {
        this.checkFG();
        this.fg.put(x, y, c, color);
    }

    public void putFG(int x, int y, String string, T foreground) {
        this.checkFG();
        this.fg.put(x, y, string, foreground);
    }

    public void putFG(int x, int y, IColoredString<? extends T> cs) {
        this.checkFG();
        this.fg.put(x, y, cs);
    }

    public void putBG(int x, int y, T color) {
        this.checkBG();
        this.bg.put(x, y, color);
    }

    public void put(int x, int y, char c, T foreground, T background) {
        this.checkFG();
        this.checkBG();
        this.bg.put(x, y, background);
        this.fg.put(x, y, c, foreground);
    }

    public void put(int x, int y, IColoredString<? extends T> cs, T background) {
        this.checkFG();
        this.checkBG();
        for (int i = x; i < cs.length() && i < this.gridWidth; ++i) {
            this.bg.put(i, y, background);
        }
        this.fg.put(x, y, cs);
    }

    public void put(int x, int y, String s, T foreground, T background) {
        this.checkFG();
        this.checkBG();
        for (int i = x; i < s.length() && i < this.gridWidth; ++i) {
            this.bg.put(i, y, background);
        }
        this.fg.put(x, y, s, foreground);
    }

    public void fillBG(T color) {
        if (this.gridWidth < 0 || this.gridHeight < 0) {
            throw new IllegalStateException("Width and height must be set before calling fillBG");
        }
        for (int x = 0; x < this.gridWidth; ++x) {
            for (int y = 0; y < this.gridHeight; ++y) {
                this.putBG(x, y, color);
            }
        }
    }

    public void refresh() {
        this.bg.refresh();
        this.fg.refresh();
    }

    public List<ISquidPanel<?>> getBackers() {
        LinkedList backers = new LinkedList();
        backers.add(this.fg.getBacker());
        backers.add(this.bg.getBacker());
        return backers;
    }

    protected void addActors() {
        this.addActor((Actor)((SquidPanel)this.bg.getBacker()));
        this.addActor((Actor)((SquidPanel)this.fg.getBacker()));
    }

    protected void checkFG() {
        if (this.fg == null) {
            throw new NullPointerException("The foreground panel must be set before writing to it");
        }
    }

    protected void checkBG() {
        if (this.bg == null) {
            throw new NullPointerException("The background panel must be set before writing to it");
        }
    }

    public String toString() {
        return String.format("%s@%s", ((Object)((Object)this)).getClass().getSimpleName(), Integer.toHexString(((Object)((Object)this)).hashCode()));
    }
}

