/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import squidpony.squidgrid.gui.gdx.SColor;
import squidpony.squidmath.Bresenham;
import squidpony.squidmath.Coord3D;
import squidpony.squidmath.RNG;

public class SColorFactory {
    private static final TreeMap<String, SColor> nameLookup = new TreeMap();
    private static final TreeMap<Integer, SColor> valueLookup = new TreeMap();
    private static RNG rng = new RNG();
    private static Map<Integer, SColor> colorBag = new HashMap<Integer, SColor>();
    private static Map<String, ArrayList<SColor>> palettes = new HashMap<String, ArrayList<SColor>>();
    private static int floor = 1;

    private SColorFactory() {
    }

    public static SColor colorForName(String s) {
        if (nameLookup.isEmpty()) {
            for (SColor sc : SColor.FULL_PALETTE) {
                nameLookup.put(sc.getName(), sc);
            }
        }
        return nameLookup.get(s);
    }

    public static SColor colorForValue(int rgb) {
        if (valueLookup.isEmpty()) {
            for (SColor sc : SColor.FULL_PALETTE) {
                valueLookup.put(sc.toIntBits(), sc);
            }
        }
        return valueLookup.containsKey(rgb) ? valueLookup.get(rgb) : SColorFactory.asSColor(rgb);
    }

    public static int quantityCached() {
        return colorBag.size();
    }

    private static int blend(int a, int b, double coef) {
        coef = MathUtils.clamp((double)coef, (double)0.0, (double)1.0);
        return (int)((double)a + (double)(b - a) * coef);
    }

    private static float blend(float a, float b, double coef) {
        float cf = MathUtils.clamp((float)((float)coef), (float)0.0f, (float)1.0f);
        return a + (b - a) * cf;
    }

    public static SColor blend(SColor color1, SColor color2, double coef) {
        return SColorFactory.asSColor(SColorFactory.blend(color1.a, color2.a, coef), SColorFactory.blend(color1.r, color2.r, coef), SColorFactory.blend(color1.g, color2.g, coef), SColorFactory.blend(color1.b, color2.b, coef));
    }

    public static SColor randomBlend(SColor color1, SColor color2, double min, double max) {
        return SColorFactory.blend(color1, color2, rng.between(min, max));
    }

    public static SColor add(SColor color1, SColor color2) {
        return SColorFactory.asSColor(color1.a + color2.a, color1.r + color2.r, color1.g + color2.g, color1.b + color2.b);
    }

    public static SColor lightWith(SColor color, SColor light) {
        return SColorFactory.asSColor(color.a * light.a, color.r * light.r, color.g * light.g, color.b * light.b);
    }

    public static void emptyCache() {
        colorBag = new HashMap<Integer, SColor>();
    }

    public static void setFloor(int value) {
        floor = Math.max(1, value);
    }

    public static SColor asSColor(int argb) {
        int working = argb;
        if (floor != 1) {
            int a = argb >> 24 & 0xFF;
            a -= a % floor;
            int r = argb >> 16 & 0xFF;
            r -= r % floor;
            int g = argb >> 8 & 0xFF;
            g -= g % floor;
            int b = argb & 0xFF;
            b -= b % floor;
            working = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        if (colorBag.containsKey(working)) {
            return colorBag.get(working);
        }
        SColor color = new SColor(working);
        colorBag.put(working, color);
        return color;
    }

    public static SColor asSColor(float a, float r, float g, float b) {
        int working = 0;
        int aa = MathUtils.round((float)(255.0f * a));
        aa -= aa % floor;
        int rr = MathUtils.round((float)(255.0f * r));
        rr -= rr % floor;
        int gg = MathUtils.round((float)(255.0f * g));
        gg -= gg % floor;
        int bb = MathUtils.round((float)(255.0f * b));
        if (colorBag.containsKey(working = (aa & 0xFF) << 24 | (rr & 0xFF) << 16 | (gg & 0xFF) << 8 | (bb -= bb % floor) & 0xFF)) {
            return colorBag.get(working);
        }
        SColor color = new SColor(working);
        colorBag.put(working, color);
        return color;
    }

    public static SColor asSColor(int r, int g, int b) {
        return SColorFactory.asSColor(255, r, g, b);
    }

    public static SColor asSColor(int a, int r, int g, int b) {
        a = Math.min(a, 255);
        a = Math.max(a, 0);
        r = Math.min(r, 255);
        r = Math.max(r, 0);
        g = Math.min(g, 255);
        g = Math.max(g, 0);
        b = Math.min(b, 255);
        b = Math.max(b, 0);
        return SColorFactory.asSColor(a << 24 | r << 16 | g << 8 | b);
    }

    public static SColor asSColor(Color color) {
        return SColorFactory.colorForValue(Color.rgba8888((float)color.a, (float)color.r, (float)color.g, (float)color.b));
    }

    public static SColor dim(SColor color) {
        return SColorFactory.blend(color, SColor.BLACK, 0.1);
    }

    public static SColor dimmer(SColor color) {
        return SColorFactory.blend(color, SColor.BLACK, 0.3);
    }

    public static SColor dimmest(SColor color) {
        return SColorFactory.blend(color, SColor.BLACK, 0.7);
    }

    public static SColor light(SColor color) {
        return SColorFactory.blend(color, SColor.WHITE, 0.1);
    }

    public static SColor lighter(SColor color) {
        return SColorFactory.blend(color, SColor.WHITE, 0.3);
    }

    public static SColor lightest(SColor color) {
        return SColorFactory.blend(color, SColor.WHITE, 0.6);
    }

    public static SColor desaturated(SColor color) {
        int r = MathUtils.round((float)(color.r * 255.0f));
        int g = MathUtils.round((float)(color.g * 255.0f));
        int b = MathUtils.round((float)(color.b * 255.0f));
        int average = (int)((double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114);
        return SColorFactory.asSColor(average, average, average);
    }

    public static SColor desaturate(SColor color, double percent) {
        return SColorFactory.blend(color, SColorFactory.desaturated(color), percent);
    }

    public static ArrayList<SColor> asGradient(SColor color1, SColor color2) {
        String name = SColorFactory.paletteNamer(color1, color2);
        if (palettes.containsKey(name)) {
            return palettes.get(name);
        }
        Queue gradient = Bresenham.line3D((Coord3D)SColorFactory.scolorToCoord3D(color1), (Coord3D)SColorFactory.scolorToCoord3D(color2));
        ArrayList<SColor> ret = new ArrayList<SColor>();
        for (Coord3D coord : gradient) {
            ret.add(SColorFactory.coord3DToSColor(coord));
        }
        palettes.put(name, ret);
        return ret;
    }

    public static ArrayList<SColor> palette(String name) {
        return palettes.get(name);
    }

    public static ArrayList<SColor> pallet(String name) {
        return palettes.get(name);
    }

    public static SColor fromPalette(String name, float percent) {
        ArrayList<SColor> list = palettes.get(name);
        if (list == null) {
            return null;
        }
        int index = Math.round((float)list.size() * percent);
        index = Math.min(index, list.size() - 1);
        index = Math.max(index, 0);
        return list.get(index);
    }

    public static SColor fromPallet(String name, float percent) {
        ArrayList<SColor> list = palettes.get(name);
        if (list == null) {
            return null;
        }
        int index = Math.round((float)list.size() * percent);
        index = Math.min(index, list.size() - 1);
        index = Math.max(index, 0);
        return list.get(index);
    }

    public static void addPallet(String name, ArrayList<SColor> palette) {
        SColorFactory.addPalette(name, palette);
    }

    public static void addPalette(String name, ArrayList<SColor> palette) {
        ArrayList<SColor> temp = new ArrayList<SColor>();
        for (SColor sc : palette) {
            temp.add(SColorFactory.asSColor(Color.rgba8888((Color)sc)));
        }
        palettes.put(name, temp);
    }

    private static Coord3D scolorToCoord3D(SColor color) {
        return new Coord3D(MathUtils.floor((float)(color.r * 255.0f)), MathUtils.floor((float)(color.g * 255.0f)), MathUtils.floor((float)(color.b * 255.0f)));
    }

    private static SColor coord3DToSColor(Coord3D coord) {
        return SColorFactory.asSColor(coord.x, coord.y, coord.z);
    }

    private static String paletteNamer(SColor color1, SColor color2) {
        return color1.getName() + " to " + color2.getName();
    }
}

