/*
 * Decompiled with CFR 0.152.
 */
package squidpony.squidgrid.gui.gdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.CharArray;
import squidpony.squidgrid.gui.gdx.SquidMouse;

public class SquidInput
extends InputAdapter {
    protected KeyHandler keyAction;
    protected boolean numpadDirections = true;
    protected boolean ignoreInput = false;
    protected SquidMouse mouse;
    protected final CharArray queue = new CharArray();
    protected final CharArray processingQueue = new CharArray();
    public static final char LEFT_ARROW = '\u2190';
    public static final char UP_ARROW = '\u2191';
    public static final char RIGHT_ARROW = '\u2192';
    public static final char DOWN_ARROW = '\u2193';
    public static final char DOWN_LEFT_ARROW = '\u2199';
    public static final char DOWN_RIGHT_ARROW = '\u2198';
    public static final char UP_RIGHT_ARROW = '\u2197';
    public static final char UP_LEFT_ARROW = '\u2196';
    public static final char CENTER_ARROW = '\u21ba';
    public static final char VERTICAL_ARROW = '\u2195';
    public static final char ENTER = '\u21b5';
    public static final char TAB = '\u21b9';
    public static final char BACKSPACE = '\u2280';
    public static final char FORWARD_DELETE = '\u2281';
    public static final char INSERT = '\u2208';
    public static final char PAGE_DOWN = '\u22a4';
    public static final char PAGE_UP = '\u22a5';
    public static final char HOME = '\u2302';
    public static final char END = '\u2623';
    public static final char ESCAPE = '\u2620';
    public static final char F1 = '\u2460';
    public static final char F2 = '\u2461';
    public static final char F3 = '\u2462';
    public static final char F4 = '\u2463';
    public static final char F5 = '\u2464';
    public static final char F6 = '\u2465';
    public static final char F7 = '\u2466';
    public static final char F8 = '\u2467';
    public static final char F9 = '\u2468';
    public static final char F10 = '\u2469';
    public static final char F11 = '\u246a';
    public static final char F12 = '\u246b';
    public static final char GAMEPAD_A = '\u24b6';
    public static final char GAMEPAD_B = '\u24b7';
    public static final char GAMEPAD_C = '\u24b8';
    public static final char GAMEPAD_X = '\u24cd';
    public static final char GAMEPAD_Y = '\u24ce';
    public static final char GAMEPAD_Z = '\u24cf';
    public static final char GAMEPAD_L1 = '\u24c1';
    public static final char GAMEPAD_L2 = '\u24db';
    public static final char GAMEPAD_R1 = '\u24c7';
    public static final char GAMEPAD_R2 = '\u24e1';
    public static final char GAMEPAD_LEFT_THUMB = '\u24a7';
    public static final char GAMEPAD_RIGHT_THUMB = '\u24ad';
    public static final char GAMEPAD_START = '\u2713';
    public static final char GAMEPAD_SELECT = '\u261c';

    public SquidInput() {
        this.keyAction = null;
        this.mouse = new SquidMouse(12.0f, 12.0f, (InputProcessor)new InputAdapter());
    }

    public SquidInput(SquidMouse mouse) {
        this.keyAction = null;
        this.mouse = mouse;
    }

    public SquidInput(KeyHandler keyHandler) {
        this.keyAction = keyHandler;
        this.mouse = new SquidMouse(12.0f, 12.0f, (InputProcessor)new InputAdapter());
    }

    public SquidInput(KeyHandler keyHandler, boolean ignoreInput) {
        this.keyAction = keyHandler;
        this.mouse = new SquidMouse(12.0f, 12.0f, (InputProcessor)new InputAdapter());
        this.ignoreInput = ignoreInput;
    }

    public SquidInput(KeyHandler keyHandler, SquidMouse mouse) {
        this.keyAction = keyHandler;
        this.mouse = mouse;
    }

    public SquidInput(KeyHandler keyHandler, SquidMouse mouse, boolean ignoreInput) {
        this.keyAction = keyHandler;
        this.mouse = mouse;
        this.ignoreInput = ignoreInput;
    }

    public void setKeyHandler(KeyHandler keyHandler) {
        this.keyAction = keyHandler;
    }

    public void setMouse(SquidMouse mouse) {
        this.mouse = mouse;
    }

    public boolean isUsingNumpadDirections() {
        return this.numpadDirections;
    }

    public void setUsingNumpadDirections(boolean using) {
        this.numpadDirections = using;
    }

    public KeyHandler getKeyHandler() {
        return this.keyAction;
    }

    public SquidMouse getMouse() {
        return this.mouse;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public void setIgnoreInput(boolean ignoreInput) {
        this.ignoreInput = ignoreInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() {
        CharArray q = this.processingQueue;
        SquidInput squidInput = this;
        synchronized (squidInput) {
            if (this.keyAction == null || this.queue.size < 2) {
                this.queue.clear();
                return;
            }
            q.addAll(this.queue);
            this.queue.clear();
        }
        int i = 0;
        int n = q.size;
        while (i < n) {
            char mods;
            char c = q.get(i++);
            this.keyAction.handle(c, ((mods = q.get(i++)) & '\u0001') != 0, (mods & 2) != 0, (mods & 4) != 0);
        }
        q.clear();
    }

    public boolean hasNext() {
        return this.queue.size >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        CharArray q = this.processingQueue;
        SquidInput squidInput = this;
        synchronized (squidInput) {
            if (this.keyAction == null || this.queue.size < 2) {
                this.queue.clear();
                return;
            }
            q.addAll(this.queue, 0, 2);
            this.queue.removeRange(0, 1);
        }
        if (q.size >= 2) {
            char c = q.get(0);
            char mods = q.get(1);
            this.keyAction.handle(c, (mods & '\u0001') != 0, (mods & 2) != 0, (mods & 4) != 0);
        }
        q.clear();
    }

    public void flush() {
        this.queue.clear();
    }

    public synchronized boolean keyDown(int keycode) {
        if (this.ignoreInput) {
            return false;
        }
        boolean alt = Gdx.input.isKeyPressed(57) || Gdx.input.isKeyPressed(58);
        boolean ctrl = Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130);
        boolean shift = Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60);
        char c = this.fromCode(keycode, shift);
        char mods = '\u0000';
        if (c != '\u0000') {
            this.queue.add(c);
            mods = (char)(mods | (alt ? 1 : 0));
            mods = (char)(mods | (ctrl ? 2 : 0));
            mods = (char)(mods | (shift ? 4 : 0));
            this.queue.add(mods);
        }
        return false;
    }

    public synchronized boolean keyUp(int keycode) {
        return false;
    }

    public synchronized boolean keyTyped(char character) {
        return false;
    }

    public synchronized boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.ignoreInput) {
            return false;
        }
        this.mouse.touchDown(screenX, screenY, pointer, button);
        return false;
    }

    public synchronized boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.ignoreInput) {
            return false;
        }
        this.mouse.touchUp(screenX, screenY, pointer, button);
        return false;
    }

    public synchronized boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.ignoreInput) {
            return false;
        }
        this.mouse.touchDragged(screenX, screenY, pointer);
        return false;
    }

    public synchronized boolean mouseMoved(int screenX, int screenY) {
        if (this.ignoreInput) {
            return false;
        }
        this.mouse.mouseMoved(screenX, screenY);
        return false;
    }

    public synchronized boolean scrolled(int amount) {
        if (this.ignoreInput) {
            return false;
        }
        this.mouse.scrolled(amount);
        return false;
    }

    public char fromCode(int keycode, boolean shift) {
        switch (keycode) {
            case 3: {
                return '\u2302';
            }
            case 112: {
                return '\u2281';
            }
            case 131: {
                return '\u2620';
            }
            case 132: {
                return '\u2623';
            }
            case 19: {
                return '\u2191';
            }
            case 20: {
                return '\u2193';
            }
            case 21: {
                return '\u2190';
            }
            case 22: {
                return '\u2192';
            }
            case 23: {
                return '\u21ba';
            }
            case 7: {
                return shift ? (char)')' : '0';
            }
            case 8: {
                return shift ? (char)'!' : '1';
            }
            case 9: {
                return shift ? (char)'@' : '2';
            }
            case 10: {
                return shift ? (char)'#' : '3';
            }
            case 11: {
                return shift ? (char)'$' : '4';
            }
            case 12: {
                return shift ? (char)'%' : '5';
            }
            case 13: {
                return shift ? (char)'^' : '6';
            }
            case 14: {
                return shift ? (char)'&' : '7';
            }
            case 15: {
                return shift ? (char)'*' : '8';
            }
            case 16: {
                return shift ? (char)'(' : '9';
            }
            case 144: {
                return this.numpadDirections ? (char)'\u2195' : '0';
            }
            case 145: {
                return this.numpadDirections ? (char)'\u2199' : '1';
            }
            case 146: {
                return this.numpadDirections ? (char)'\u2193' : '2';
            }
            case 147: {
                return this.numpadDirections ? (char)'\u2198' : '3';
            }
            case 148: {
                return this.numpadDirections ? (char)'\u2190' : '4';
            }
            case 149: {
                return this.numpadDirections ? (char)'\u21ba' : '5';
            }
            case 150: {
                return this.numpadDirections ? (char)'\u2192' : '6';
            }
            case 151: {
                return this.numpadDirections ? (char)'\u2196' : '7';
            }
            case 152: {
                return this.numpadDirections ? (char)'\u2191' : '8';
            }
            case 153: {
                return this.numpadDirections ? (char)'\u2197' : '9';
            }
            case 243: {
                return ':';
            }
            case 17: {
                return '*';
            }
            case 18: {
                return '#';
            }
            case 29: {
                return shift ? (char)'A' : 'a';
            }
            case 30: {
                return shift ? (char)'B' : 'b';
            }
            case 31: {
                return shift ? (char)'C' : 'c';
            }
            case 32: {
                return shift ? (char)'D' : 'd';
            }
            case 33: {
                return shift ? (char)'E' : 'e';
            }
            case 34: {
                return shift ? (char)'F' : 'f';
            }
            case 35: {
                return shift ? (char)'G' : 'g';
            }
            case 36: {
                return shift ? (char)'H' : 'h';
            }
            case 37: {
                return shift ? (char)'I' : 'i';
            }
            case 38: {
                return shift ? (char)'J' : 'j';
            }
            case 39: {
                return shift ? (char)'K' : 'k';
            }
            case 40: {
                return shift ? (char)'L' : 'l';
            }
            case 41: {
                return shift ? (char)'M' : 'm';
            }
            case 42: {
                return shift ? (char)'N' : 'n';
            }
            case 43: {
                return shift ? (char)'O' : 'o';
            }
            case 44: {
                return shift ? (char)'P' : 'p';
            }
            case 45: {
                return shift ? (char)'Q' : 'q';
            }
            case 46: {
                return shift ? (char)'R' : 'r';
            }
            case 47: {
                return shift ? (char)'S' : 's';
            }
            case 48: {
                return shift ? (char)'T' : 't';
            }
            case 49: {
                return shift ? (char)'U' : 'u';
            }
            case 50: {
                return shift ? (char)'V' : 'v';
            }
            case 51: {
                return shift ? (char)'W' : 'w';
            }
            case 52: {
                return shift ? (char)'X' : 'x';
            }
            case 53: {
                return shift ? (char)'Y' : 'y';
            }
            case 54: {
                return shift ? (char)'Z' : 'z';
            }
            case 55: {
                return shift ? (char)'<' : ',';
            }
            case 56: {
                return shift ? (char)'>' : '.';
            }
            case 61: {
                return '\u21b9';
            }
            case 62: {
                return ' ';
            }
            case 66: {
                return '\u21b5';
            }
            case 67: {
                return '\u2280';
            }
            case 68: {
                return shift ? (char)'~' : '`';
            }
            case 69: {
                return shift ? (char)'_' : '-';
            }
            case 70: {
                return shift ? (char)'+' : '=';
            }
            case 71: {
                return shift ? (char)'{' : '[';
            }
            case 72: {
                return shift ? (char)'}' : ']';
            }
            case 73: {
                return shift ? (char)'|' : '\\';
            }
            case 74: {
                return shift ? (char)':' : ';';
            }
            case 75: {
                return shift ? (char)'\"' : '\'';
            }
            case 76: {
                return shift ? (char)'?' : '/';
            }
            case 77: {
                return '@';
            }
            case 92: {
                return '\u22a5';
            }
            case 93: {
                return '\u22a4';
            }
            case 96: {
                return '\u24b6';
            }
            case 97: {
                return '\u24b7';
            }
            case 98: {
                return '\u24b8';
            }
            case 99: {
                return '\u24cd';
            }
            case 100: {
                return '\u24ce';
            }
            case 101: {
                return '\u24cf';
            }
            case 102: {
                return '\u24c1';
            }
            case 103: {
                return '\u24c7';
            }
            case 104: {
                return '\u24db';
            }
            case 105: {
                return '\u24e1';
            }
            case 106: {
                return '\u24a7';
            }
            case 107: {
                return '\u24ad';
            }
            case 108: {
                return '\u2713';
            }
            case 109: {
                return '\u261c';
            }
            case 133: {
                return '\u2208';
            }
            case 244: {
                return '\u2460';
            }
            case 245: {
                return '\u2461';
            }
            case 246: {
                return '\u2462';
            }
            case 247: {
                return '\u2463';
            }
            case 248: {
                return '\u2464';
            }
            case 249: {
                return '\u2465';
            }
            case 250: {
                return '\u2466';
            }
            case 251: {
                return '\u2467';
            }
            case 252: {
                return '\u2468';
            }
            case 253: {
                return '\u2469';
            }
            case 254: {
                return '\u246a';
            }
            case 255: {
                return '\u246b';
            }
        }
        return '\u0000';
    }

    public static interface KeyHandler {
        public void handle(char var1, boolean var2, boolean var3, boolean var4);
    }
}

